/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.util;

import java.lang.reflect.Modifier;
import net.sourceforge.phpdt.core.Flags;
import net.sourceforge.phpdt.core.IMember;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.corext.Assert;

public class JdtFlags {
    public static final String VISIBILITY_STRING_PRIVATE = "private";
    public static final String VISIBILITY_STRING_PACKAGE = "";
    public static final String VISIBILITY_STRING_PROTECTED = "protected";
    public static final String VISIBILITY_STRING_PUBLIC = "public";
    public static final int VISIBILITY_CODE_INVALID = -1;

    private JdtFlags() {
    }

    public static boolean isAbstract(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceMethod(member)) {
            return true;
        }
        return Flags.isAbstract(member.getFlags());
    }

    public static boolean isDeprecated(IMember member) throws JavaModelException {
        return Flags.isDeprecated(member.getFlags());
    }

    public static boolean isFinal(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceField(member)) {
            return true;
        }
        if (JdtFlags.isAnonymousType(member)) {
            return true;
        }
        return Flags.isFinal(member.getFlags());
    }

    public static boolean isPackageVisible(IMember member) throws JavaModelException {
        return !JdtFlags.isPrivate(member) && !JdtFlags.isProtected(member) && !JdtFlags.isPublic(member);
    }

    public static boolean isPrivate(IMember member) throws JavaModelException {
        return Flags.isPrivate(member.getFlags());
    }

    public static boolean isProtected(IMember member) throws JavaModelException {
        return Flags.isProtected(member.getFlags());
    }

    public static boolean isPublic(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceMember(member)) {
            return true;
        }
        return Flags.isPublic(member.getFlags());
    }

    public static boolean isStatic(IMember member) throws JavaModelException {
        if (JdtFlags.isNestedInterface(member)) {
            return true;
        }
        if (member.getElementType() != 9 && JdtFlags.isInterfaceMember(member)) {
            return true;
        }
        return Flags.isStatic(member.getFlags());
    }

    private static boolean isInterfaceMethod(IMember member) throws JavaModelException {
        return member.getElementType() == 9 && JdtFlags.isInterfaceMember(member);
    }

    private static boolean isInterfaceField(IMember member) throws JavaModelException {
        return member.getElementType() == 8 && JdtFlags.isInterfaceMember(member);
    }

    private static boolean isInterfaceMember(IMember member) throws JavaModelException {
        return member.getDeclaringType() != null && member.getDeclaringType().isInterface();
    }

    private static boolean isNestedInterface(IMember member) throws JavaModelException {
        return member.getElementType() == 7 && member.getDeclaringType() != null && ((IType)member).isInterface();
    }

    private static boolean isAnonymousType(IMember member) throws JavaModelException {
        return member.getElementType() == 7 && ((IType)member).isAnonymous();
    }

    public static int getVisibilityCode(IMember member) throws JavaModelException {
        if (JdtFlags.isPublic(member)) {
            return 1;
        }
        if (JdtFlags.isProtected(member)) {
            return 4;
        }
        if (JdtFlags.isPrivate(member)) {
            return 2;
        }
        return 1;
    }

    public static String getVisibilityString(int visibilityCode) {
        if (Modifier.isPublic(visibilityCode)) {
            return VISIBILITY_STRING_PUBLIC;
        }
        if (Modifier.isProtected(visibilityCode)) {
            return VISIBILITY_STRING_PROTECTED;
        }
        if (Modifier.isPrivate(visibilityCode)) {
            return VISIBILITY_STRING_PRIVATE;
        }
        return VISIBILITY_STRING_PACKAGE;
    }

    public static void assertVisibility(int visibility) {
        Assert.isTrue(visibility == 1 || visibility == 4 || visibility == 2);
    }

    public static boolean isHigherVisibility(int newVisibility, int oldVisibility) {
        JdtFlags.assertVisibility(oldVisibility);
        JdtFlags.assertVisibility(newVisibility);
        switch (oldVisibility) {
            case 2: {
                return newVisibility == 1 || newVisibility == 4;
            }
            case 4: {
                return newVisibility == 1;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    public static int getLowerVisibility(int visibility1, int visibility2) {
        if (JdtFlags.isHigherVisibility(visibility1, visibility2)) {
            return visibility2;
        }
        return visibility1;
    }

    public static int clearAccessModifiers(int flags) {
        return JdtFlags.clearFlag(7, flags);
    }

    public static int clearFlag(int flag, int flags) {
        return flags & ~flag;
    }
}

