/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.formatter.impl;

import java.util.Map;

public class FormatterOptions {
    public static final String OPTION_InsertNewlineBeforeOpeningBrace = "net.sourceforge.phpeclipse.formatter.newline.openingBrace";
    public static final String OPTION_InsertNewlineInControlStatement = "net.sourceforge.phpeclipse.formatter.newline.controlStatement";
    public static final String OPTION_InsertNewLineInEmptyBlock = "net.sourceforge.phpeclipse.formatter.newline.emptyBlock";
    public static final String OPTION_ClearAllBlankLines = "net.sourceforge.phpeclipse.formatter.newline.clearAll";
    public static final String OPTION_SplitLineExceedingLength = "net.sourceforge.phpeclipse.formatter.lineSplit";
    public static final String OPTION_CompactAssignment = "net.sourceforge.phpeclipse.formatter.style.assignment";
    public static final String OPTION_CompactStringConcatenation = "net.sourceforge.phpeclipse.formatter.style.compactStringConcatenation";
    public static final String OPTION_CompactArrays = "net.sourceforge.phpeclipse.formatter.style.compactArrays";
    public static final String OPTION_TabulationChar = "net.sourceforge.phpeclipse.formatter.tabulation.char";
    public static final String OPTION_TabulationSize = "net.sourceforge.phpeclipse.formatter.tabulation.size";
    public static final String OPTION_CompactDereferencing = "net.sourceforge.phpeclipse.formatter.style.assignment";
    public static final String INSERT = "insert";
    public static final String DO_NOT_INSERT = "do not insert";
    public static final String PRESERVE_ONE = "preserve one";
    public static final String CLEAR_ALL = "clear all";
    public static final String NORMAL = "normal";
    public static final String COMPACT = "compact";
    public static final String TAB = "tab";
    public static final String SPACE = "space";
    public boolean newLineBeforeOpeningBraceMode = false;
    public boolean newlineInControlStatementMode = false;
    public boolean clearAllBlankLinesMode = false;
    public int maxLineLength = 80;
    public boolean compactAssignmentMode = false;
    public boolean compactStringConcatenation = false;
    public boolean compactArrays = false;
    public boolean compactDereferencingMode = true;
    public int tabSize = 4;
    public boolean indentWithTab = true;
    public boolean newLineInEmptyBlockMode = true;
    public char[] lineSeparatorSequence = System.getProperty("line.separator").toCharArray();

    public FormatterOptions() {
    }

    public FormatterOptions(Map settings) {
        if (settings == null) {
            return;
        }
        Object[] entries = settings.entrySet().toArray();
        int i = 0;
        int max = entries.length;
        while (i < max) {
            Map.Entry entry = (Map.Entry)entries[i];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) {
                String optionID = (String)entry.getKey();
                String optionValue = (String)entry.getValue();
                if (optionID.equals(OPTION_InsertNewlineBeforeOpeningBrace)) {
                    if (optionValue.equals(INSERT)) {
                        this.newLineBeforeOpeningBraceMode = true;
                    } else if (optionValue.equals(DO_NOT_INSERT)) {
                        this.newLineBeforeOpeningBraceMode = false;
                    }
                } else if (optionID.equals(OPTION_InsertNewlineInControlStatement)) {
                    if (optionValue.equals(INSERT)) {
                        this.newlineInControlStatementMode = true;
                    } else if (optionValue.equals(DO_NOT_INSERT)) {
                        this.newlineInControlStatementMode = false;
                    }
                } else if (optionID.equals(OPTION_ClearAllBlankLines)) {
                    if (optionValue.equals(CLEAR_ALL)) {
                        this.clearAllBlankLinesMode = true;
                    } else if (optionValue.equals(PRESERVE_ONE)) {
                        this.clearAllBlankLinesMode = false;
                    }
                } else if (optionID.equals(OPTION_InsertNewLineInEmptyBlock)) {
                    if (optionValue.equals(INSERT)) {
                        this.newLineInEmptyBlockMode = true;
                    } else if (optionValue.equals(DO_NOT_INSERT)) {
                        this.newLineInEmptyBlockMode = false;
                    }
                } else {
                    int val;
                    if (optionID.equals(OPTION_SplitLineExceedingLength)) {
                        try {
                            val = Integer.parseInt(optionValue);
                            if (val >= 0) {
                                this.maxLineLength = val;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (optionID.equals("net.sourceforge.phpeclipse.formatter.style.assignment")) {
                        if (optionValue.equals(COMPACT)) {
                            this.compactAssignmentMode = true;
                        } else if (optionValue.equals(NORMAL)) {
                            this.compactAssignmentMode = false;
                        }
                    } else if (optionID.equals(OPTION_CompactArrays)) {
                        if (optionValue.equals(COMPACT)) {
                            this.compactArrays = true;
                        } else if (optionValue.equals(NORMAL)) {
                            this.compactArrays = false;
                        }
                    } else if (optionID.equals(OPTION_CompactStringConcatenation)) {
                        if (optionValue.equals(COMPACT)) {
                            this.compactStringConcatenation = true;
                        } else if (optionValue.equals(NORMAL)) {
                            this.compactStringConcatenation = false;
                        }
                    } else if (optionID.equals(OPTION_TabulationChar)) {
                        if (optionValue.equals(TAB)) {
                            this.indentWithTab = true;
                        } else if (optionValue.equals(SPACE)) {
                            this.indentWithTab = false;
                        }
                    } else if (optionID.equals(OPTION_TabulationSize)) {
                        try {
                            val = Integer.parseInt(optionValue);
                            if (val > 0) {
                                this.tabSize = val;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            ++i;
        }
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public boolean isAddingNewLineBeforeOpeningBrace() {
        return this.newLineBeforeOpeningBraceMode;
    }

    public boolean isAddingNewLineInControlStatement() {
        return this.newlineInControlStatementMode;
    }

    public boolean isAddingNewLineInEmptyBlock() {
        return this.newLineInEmptyBlockMode;
    }

    public boolean isClearingAllBlankLines() {
        return this.clearAllBlankLinesMode;
    }

    public boolean isCompactingAssignment() {
        return this.compactAssignmentMode;
    }

    public boolean isCompactingDereferencing() {
        return this.compactDereferencingMode;
    }

    public boolean isUsingTabForIndenting() {
        return this.indentWithTab;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparatorSequence = lineSeparator.toCharArray();
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }
}

