/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Map;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.internal.ui.dialogs.StatusInfo;
import net.sourceforge.phpdt.internal.ui.dialogs.StatusUtil;
import net.sourceforge.phpdt.internal.ui.preferences.OptionsConfigurationBlock;
import net.sourceforge.phpdt.internal.ui.preferences.PreferencesMessages;
import net.sourceforge.phpdt.internal.ui.util.PixelConverter;
import net.sourceforge.phpdt.internal.ui.util.TabFolderLayout;
import net.sourceforge.phpdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class CompilerConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String PREF_PB_PHP_VAR_DEPRECATED = "net.sourceforge.phpeclipse.compiler.problem.phpVarDeprecatedWarning";
    private static final String PREF_PB_PHP_KEYWORD = "net.sourceforge.phpeclipse.compiler.problem.phpBadStyleKeywordWarning";
    private static final String PREF_PB_PHP_UPPERCASE_IDENTIFIER = "net.sourceforge.phpeclipse.compiler.problem.phpBadStyleUppercaseIdentifierWarning";
    private static final String PREF_PB_PHP_FILE_NOT_EXIST = "net.sourceforge.phpeclipse.compiler.problem.phpIncludeNotExistWarning";
    private static final String PREF_PB_UNREACHABLE_CODE = "net.sourceforge.phpeclipse.compiler.problem.codeCannotBeReachedWarning";
    private static final String PREF_PB_UNINITIALIZED_LOCAL_VARIABLE = "net.sourceforge.phpeclipse.compiler.problem.uninitializedLocalVariableWarning";
    private static final String PREF_PB_MAX_PER_UNIT = "net.sourceforge.phpeclipse.compiler.maxProblemPerUnit";
    private static final String GENERATE = "generate";
    private static final String DO_NOT_GENERATE = "do not generate";
    private static final String PRESERVE = "preserve";
    private static final String OPTIMIZE_OUT = "optimize out";
    private static final String VERSION_1_1 = "1.1";
    private static final String VERSION_1_2 = "1.2";
    private static final String VERSION_1_3 = "1.3";
    private static final String VERSION_1_4 = "1.4";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ABORT = "abort";
    private static final String CLEAN = "clean";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final String DEFAULT_CONF = "default";
    private static final String USER_CONF = "user";
    private ArrayList fComplianceControls = new ArrayList();
    private PixelConverter fPixelConverter;
    private IStatus fMaxNumberProblemsStatus = new StatusInfo();
    private static final String[] KEYS = new String[]{"net.sourceforge.phpeclipse.compiler.problem.phpIncludeNotExistWarning", "net.sourceforge.phpeclipse.compiler.problem.phpVarDeprecatedWarning", "net.sourceforge.phpeclipse.compiler.problem.phpBadStyleKeywordWarning", "net.sourceforge.phpeclipse.compiler.problem.phpBadStyleUppercaseIdentifierWarning", "net.sourceforge.phpeclipse.compiler.problem.codeCannotBeReachedWarning", "net.sourceforge.phpeclipse.compiler.problem.uninitializedLocalVariableWarning", "net.sourceforge.phpeclipse.compiler.maxProblemPerUnit"};

    public CompilerConfigurationBlock(IStatusChangeListener context, IJavaProject project) {
        super(context, project, CompilerConfigurationBlock.getKeys());
    }

    private static String[] getKeys() {
        return KEYS;
    }

    protected final Map getOptions(boolean inheritJavaCoreOptions) {
        Map map = super.getOptions(inheritJavaCoreOptions);
        return map;
    }

    protected final Map getDefaultOptions() {
        Map map = super.getDefaultOptions();
        return map;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        Composite commonComposite = this.createStyleTabContent((Composite)folder);
        Composite advancedComposite = this.createAdvancedTabContent(folder);
        TabItem item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.common.tabtitle"));
        item.setControl((Control)commonComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.advanced.tabtitle"));
        item.setControl((Control)advancedComposite);
        this.validateSettings(null, null);
        return folder;
    }

    private Composite createStyleTabContent(Composite folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite composite = new Composite(folder, 0);
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.common.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(50);
        description.setLayoutData((Object)gd);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_file_not_exist.label");
        this.addComboBox(composite, label, PREF_PB_PHP_FILE_NOT_EXIST, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_var_deprecated.label");
        this.addComboBox(composite, label, PREF_PB_PHP_VAR_DEPRECATED, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_keyword.label");
        this.addComboBox(composite, label, PREF_PB_PHP_KEYWORD, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_uppercase_identifier.label");
        this.addComboBox(composite, label, PREF_PB_PHP_UPPERCASE_IDENTIFIER, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unreachable_code.label");
        this.addComboBox(composite, label, PREF_PB_UNREACHABLE_CODE, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unitialized_local_variable.label");
        this.addComboBox(composite, label, PREF_PB_UNINITIALIZED_LOCAL_VARIABLE, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_overriding_pkg_dflt.label");
        return composite;
    }

    private Composite createAdvancedTabContent(TabFolder folder) {
        String[] stringArray = new String[]{ERROR, WARNING, IGNORE};
        String[] stringArray2 = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        String[] stringArray3 = new String[]{ENABLED, DISABLED};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.advanced.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(50);
        description.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(6);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_max_per_unit.label");
        Text text = this.addTextField(composite, label, PREF_PB_MAX_PER_UNIT, 0, 0);
        text.setTextLimit(6);
        text.setLayoutData((Object)gd);
        return composite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(String changedKey, String newValue) {
        if (changedKey != null) {
            if (!PREF_PB_MAX_PER_UNIT.equals(changedKey)) return;
            this.fMaxNumberProblemsStatus = this.validateMaxNumberProblems();
        } else {
            this.fMaxNumberProblemsStatus = this.validateMaxNumberProblems();
        }
        IStatus status = StatusUtil.getMostSevere(new IStatus[]{this.fMaxNumberProblemsStatus});
        this.fContext.statusChanged(status);
    }

    private IStatus validateMaxNumberProblems() {
        String number = (String)this.fWorkingValues.get(PREF_PB_MAX_PER_UNIT);
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value <= 0) {
                    status.setError(PreferencesMessages.getFormattedString("CompilerConfigurationBlock.invalid_input", number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(PreferencesMessages.getFormattedString("CompilerConfigurationBlock.invalid_input", number));
            }
        }
        return status;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.getString("CompilerConfigurationBlock.needsbuild.title");
        String message = workspaceSettings ? PreferencesMessages.getString("CompilerConfigurationBlock.needsfullbuild.message") : PreferencesMessages.getString("CompilerConfigurationBlock.needsprojectbuild.message");
        return new String[]{title, message};
    }
}

