/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.folding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.phpdt.internal.ui.text.folding.JavaFoldingStructureProviderDescriptor;
import net.sourceforge.phpdt.ui.text.folding.IJavaFoldingStructureProvider;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class JavaFoldingStructureProviderRegistry {
    private static final String EXTENSION_POINT = "foldingStructureProviders";
    private Map fDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFoldingStructureProviderDescriptor[] getFoldingProviderDescriptors() {
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.values().toArray(new JavaFoldingStructureProviderDescriptor[this.fDescriptors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFoldingStructureProviderDescriptor getFoldingProviderDescriptor(String id) {
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return (JavaFoldingStructureProviderDescriptor)this.fDescriptors.get(id);
        }
    }

    public IJavaFoldingStructureProvider getCurrentFoldingProvider() {
        String id = PHPeclipsePlugin.getDefault().getPreferenceStore().getString("editor_folding_provider");
        JavaFoldingStructureProviderDescriptor desc = this.getFoldingProviderDescriptor(id);
        if (desc != null) {
            try {
                return desc.createProvider();
            }
            catch (CoreException e) {
                PHPeclipsePlugin.log(e);
            }
        }
        return null;
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        HashMap<String, JavaFoldingStructureProviderDescriptor> map = new HashMap<String, JavaFoldingStructureProviderDescriptor>();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PHPeclipsePlugin.getPluginId(), EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            JavaFoldingStructureProviderDescriptor desc = new JavaFoldingStructureProviderDescriptor(elements[i]);
            map.put(desc.getId(), desc);
            ++i;
        }
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.fDescriptors = Collections.unmodifiableMap(map);
        }
    }
}

