/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.spelling;

import java.text.MessageFormat;
import net.sourceforge.phpdt.internal.ui.PHPUIMessages;
import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.text.java.IInvocationContext;
import net.sourceforge.phpdt.internal.ui.text.java.IPHPCompletionProposal;
import net.sourceforge.phpdt.internal.ui.text.spelling.SpellCheckEngine;
import net.sourceforge.phpdt.internal.ui.text.spelling.WordCorrectionProposal;
import net.sourceforge.phpdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import net.sourceforge.phpdt.internal.ui.text.spelling.engine.ISpellChecker;
import net.sourceforge.phpdt.ui.PreferenceConstants;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class WordIgnoreProposal
implements IPHPCompletionProposal {
    private IInvocationContext fContext;
    private String fWord;

    public WordIgnoreProposal(String word, IInvocationContext context) {
        this.fWord = word;
        this.fContext = context;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.createSpellChecker(engine.getLocale(), PreferenceConstants.getPreferenceStore());
        if (checker != null) {
            checker.ignoreWord(this.fWord);
        }
    }

    public String getAdditionalProposalInfo() {
        return MessageFormat.format(PHPUIMessages.getString("Spelling.ignore.info"), WordCorrectionProposal.getHtmlRepresentation(this.fWord));
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return MessageFormat.format(PHPUIMessages.getString("Spelling.ignore.label"), this.fWord);
    }

    public Image getImage() {
        return PHPUiImages.get("net.sourceforge.phpdt.internal.ui.never_translate.gif");
    }

    public final int getRelevance() {
        return -2147483647;
    }

    public final Point getSelection(IDocument document) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }
}

