/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ltk.ui.wizards;

import net.sourceforge.phpdt.internal.compiler.parser.Scanner;
import net.sourceforge.phpdt.ltk.core.RenameIdentifierInfo;
import net.sourceforge.phpdt.ltk.ui.UITexts;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RenameLocalVariablePage
extends UserInputWizardPage {
    private static final String DS_KEY;
    private static final String DS_RENAME_DQ_STRINGS = "RENAME_DQ_STRINGS";
    private static final String DS_RENAME_PHPDOC = "RENAME_PHPDOC";
    private static final String DS_RENAME_OTHER_COMMENTS = "RENAME_OTHER_COMMENTS";
    private final RenameIdentifierInfo info;
    private IDialogSettings dialogSettings;
    private Text txtNewName;
    private Button cbRenameDQStrings;
    private Button cbRenamePHPdoc;
    private Button cbRenameOtherComments;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.phpdt.ltk.ui.wizards.RenameLocalVariablePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DS_KEY = clazz.getName();
    }

    public RenameLocalVariablePage(RenameIdentifierInfo info) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.phpdt.ltk.ui.wizards.RenameLocalVariablePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName());
        this.info = info;
        this.initDialogSettings();
    }

    public void createControl(Composite parent) {
        Composite composite = this.createRootComposite(parent);
        this.setControl((Control)composite);
        this.createLblNewName(composite);
        this.createTxtNewName(composite);
        this.createCbDQStrings(composite);
        this.createCbPHPdoc(composite);
        this.createCbOtherComments(composite);
        this.validate();
        this.getRefactoringWizard().setForcePreviewReview(true);
    }

    private Composite createRootComposite(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        result.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)result);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void createLblNewName(Composite composite) {
        Label lblNewName = new Label(composite, 0);
        lblNewName.setText(UITexts.renamePropertyInputPage_lblNewName);
    }

    private void createTxtNewName(Composite composite) {
        this.txtNewName = new Text(composite, 2048);
        this.txtNewName.setText(this.info.getOldName());
        this.txtNewName.setLayoutData((Object)new GridData(768));
        this.txtNewName.selectAll();
        this.txtNewName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                RenameLocalVariablePage.this.info.setNewName(RenameLocalVariablePage.this.txtNewName.getText());
                RenameLocalVariablePage.this.validate();
            }
        });
    }

    private void createCbDQStrings(Composite composite) {
        String texts = UITexts.renameLocalVariable_cbDQStrings;
        this.cbRenameDQStrings = this.createCheckbox(composite, texts);
        this.cbRenameDQStrings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean selected = RenameLocalVariablePage.this.cbRenameDQStrings.getSelection();
                RenameLocalVariablePage.this.dialogSettings.put(RenameLocalVariablePage.DS_RENAME_DQ_STRINGS, selected);
                RenameLocalVariablePage.this.info.setRenameDQString(selected);
            }
        });
        this.initDQStringsOption();
    }

    private void createCbPHPdoc(Composite composite) {
        String texts = UITexts.renameLocalVariable_cbPHPdoc;
        this.cbRenamePHPdoc = this.createCheckbox(composite, texts);
        this.cbRenamePHPdoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean selected = RenameLocalVariablePage.this.cbRenamePHPdoc.getSelection();
                RenameLocalVariablePage.this.dialogSettings.put(RenameLocalVariablePage.DS_RENAME_PHPDOC, selected);
                RenameLocalVariablePage.this.info.setRenamePHPdoc(selected);
            }
        });
        this.initPHPdocOption();
    }

    private void createCbOtherComments(Composite composite) {
        String texts = UITexts.renameLocalVariable_cbOtherDoc;
        this.cbRenameOtherComments = this.createCheckbox(composite, texts);
        this.cbRenameOtherComments.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean selected = RenameLocalVariablePage.this.cbRenameOtherComments.getSelection();
                RenameLocalVariablePage.this.dialogSettings.put(RenameLocalVariablePage.DS_RENAME_OTHER_COMMENTS, selected);
                RenameLocalVariablePage.this.info.setRenameOtherComments(selected);
            }
        });
        this.initOtherCommentsOption();
    }

    private Button createCheckbox(Composite composite, String text) {
        Button result = new Button(composite, 32);
        result.setText(text);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        result.setLayoutData((Object)gridData);
        return result;
    }

    private void initDialogSettings() {
        IDialogSettings ds = PHPeclipsePlugin.getDefault().getDialogSettings();
        this.dialogSettings = ds.getSection(DS_KEY);
        if (this.dialogSettings == null) {
            this.dialogSettings = ds.addNewSection(DS_KEY);
            this.dialogSettings.put(DS_RENAME_DQ_STRINGS, true);
            this.dialogSettings.put(DS_RENAME_PHPDOC, true);
            this.dialogSettings.put(DS_RENAME_OTHER_COMMENTS, true);
        }
    }

    private static boolean isVariable(String txt) {
        if (txt.length() <= 1) {
            return false;
        }
        if (txt.charAt(0) != '$') {
            return false;
        }
        int i = 1;
        while (i < txt.length()) {
            if (!Scanner.isPHPIdentifierPart(txt.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void validate() {
        String txt = this.txtNewName.getText();
        this.setPageComplete(RenameLocalVariablePage.isVariable(txt) && !txt.equals(this.info.getOldName()));
    }

    private void initDQStringsOption() {
        boolean refs = this.dialogSettings.getBoolean(DS_RENAME_DQ_STRINGS);
        this.cbRenameDQStrings.setSelection(refs);
        this.info.setRenameDQString(refs);
    }

    private void initPHPdocOption() {
        boolean refs = this.dialogSettings.getBoolean(DS_RENAME_PHPDOC);
        this.cbRenamePHPdoc.setSelection(refs);
        this.info.setRenamePHPdoc(refs);
    }

    private void initOtherCommentsOption() {
        boolean refs = this.dialogSettings.getBoolean(DS_RENAME_OTHER_COMMENTS);
        this.cbRenameOtherComments.setSelection(refs);
        this.info.setRenameOtherComments(refs);
    }
}

