/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ui;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaElementDelta;
import net.sourceforge.phpdt.core.IJavaModel;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.IParent;
import net.sourceforge.phpdt.core.ISourceReference;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.corext.util.JavaModelUtil;
import net.sourceforge.phpdt.ui.IWorkingCopyProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class StandardJavaElementContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers = false;
    protected boolean fProvideWorkingCopy = false;

    public StandardJavaElementContentProvider() {
    }

    public StandardJavaElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        this.fProvideMembers = provideMembers;
        this.fProvideWorkingCopy = provideWorkingCopy;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public void setProvideWorkingCopy(boolean b) {
        this.fProvideWorkingCopy = b;
    }

    public boolean providesWorkingCopies() {
        return this.fProvideWorkingCopy;
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            if (element instanceof IJavaModel) {
                return this.getJavaProjects((IJavaModel)element);
            }
            if (element instanceof IPackageFragmentRoot) {
                return this.getPackageFragments((IPackageFragmentRoot)element);
            }
            if (element instanceof IFolder) {
                return this.getResources((IFolder)element);
            }
            if (this.fProvideMembers && element instanceof ISourceReference && element instanceof IParent) {
                if (this.fProvideWorkingCopy && element instanceof ICompilationUnit) {
                    element = JavaModelUtil.toWorkingCopy((ICompilationUnit)element);
                }
                return ((IParent)element).getChildren();
            }
        }
        catch (JavaModelException javaModelException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren(Object element) {
        Object[] children;
        IJavaProject jp;
        if (this.fProvideMembers) {
            if (element instanceof ICompilationUnit) {
                return true;
            }
        } else if (element instanceof ICompilationUnit || element instanceof IFile) {
            return false;
        }
        if (element instanceof IJavaProject && !(jp = (IJavaProject)element).getProject().isOpen()) {
            return false;
        }
        if (element instanceof IParent) {
            try {
                if (((IParent)element).hasChildren()) {
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {
                return true;
            }
        }
        return (children = this.getChildren(element)) != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return null;
        }
        return this.internalGetParent(element);
    }

    private Object[] getPackageFragments(IPackageFragmentRoot root) throws JavaModelException {
        Object[] fragments = root.getChildren();
        return fragments;
    }

    protected Object[] getJavaProjects(IJavaModel jm) throws JavaModelException {
        return jm.getJavaProjects();
    }

    private Object[] getResources(IFolder folder) {
        try {
            IResource[] members = folder.members();
            ArrayList<IResource> nonJavaResources = new ArrayList<IResource>();
            int i = 0;
            while (i < members.length) {
                IJavaElement element;
                IResource o = members[i];
                if (!(o instanceof IFolder && (element = JavaCore.create((IFolder)o)) instanceof IPackageFragmentRoot && element.exists())) {
                    nonJavaResources.add(o);
                }
                ++i;
            }
            return nonJavaResources.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    protected boolean isClassPathChange(IJavaElementDelta delta) {
        if (delta.getElement().getElementType() != 3) {
            return false;
        }
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    protected Object skipProjectPackageFragmentRoot(IPackageFragmentRoot root) {
        try {
            if (this.isProjectPackageFragmentRoot(root)) {
                return root.getParent();
            }
            return root;
        }
        catch (JavaModelException javaModelException) {
            return root;
        }
    }

    protected boolean isPackageFragmentEmpty(IJavaElement element) throws JavaModelException {
        IPackageFragment fragment;
        return element instanceof IPackageFragment && !(fragment = (IPackageFragment)element).hasChildren();
    }

    protected boolean isProjectPackageFragmentRoot(IPackageFragmentRoot root) throws JavaModelException {
        IResource resource = root.getResource();
        return resource instanceof IProject;
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IJavaProject) {
            return ((IJavaProject)element).getJavaModel();
        }
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IJavaElement jParent = JavaCore.create((IResource)parent);
            if (jParent != null && jParent.exists()) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IPackageFragment) {
            IPackageFragmentRoot parent = (IPackageFragmentRoot)((IPackageFragment)element).getParent();
            return this.skipProjectPackageFragmentRoot(parent);
        }
        if (element instanceof IJavaElement) {
            IJavaElement candidate = ((IJavaElement)element).getParent();
            if (candidate != null && candidate.getElementType() == 5) {
                candidate = JavaModelUtil.toOriginal((ICompilationUnit)candidate);
            }
            return candidate;
        }
        return null;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }
}

