/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.actions;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.phpdt.internal.ui.util.PHPFileUtil;
import net.sourceforge.phpdt.internal.ui.viewsupport.ListContentProvider;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.actions.IncludesScanner;
import net.sourceforge.phpeclipse.builder.IdentifierIndexManager;
import net.sourceforge.phpeclipse.builder.PHPIdentifierLocation;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import net.sourceforge.phpeclipse.phpeditor.php.PHPWordExtractor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class OpenDeclarationEditorAction {
    private PHPEditor fEditor;
    private IProject fProject;
    private boolean isIncludeString;

    public OpenDeclarationEditorAction(PHPEditor editor) {
        this.fEditor = editor;
        this.fProject = null;
        this.isIncludeString = false;
    }

    protected void openSelectedElement(ITextSelection selection) {
        IDocument doc = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        int pos = selection.getOffset();
        this.openSelectedPosition(doc, pos);
    }

    protected void openSelectedPosition(IDocument doc, int position) {
        IFile f = ((IFileEditorInput)this.fEditor.getEditorInput()).getFile();
        this.fProject = f.getProject();
        String identifierOrInclude = this.getIdentifierOrInclude(doc, position);
        if (identifierOrInclude != null && !identifierOrInclude.equals("")) {
            if (this.isIncludeString) {
                this.openIncludeFile(identifierOrInclude);
            } else {
                this.openIdentifierDeclaration(f, identifierOrInclude);
            }
        }
    }

    private void openIncludeFile(String filename) {
        block9: {
            if (filename != null && !filename.equals("")) {
                try {
                    IFile currentFile = ((IFileEditorInput)this.fEditor.getEditorInput()).getFile();
                    IPath path = PHPFileUtil.determineFilePath(filename, (IResource)currentFile, this.fProject);
                    if (path != null) {
                        PHPeclipsePlugin.getDefault().openFileInTextEditor(path.toString());
                        return;
                    }
                }
                catch (Exception exception) {}
                try {
                    Object[] locations;
                    IdentifierIndexManager indexManager = PHPeclipsePlugin.getDefault().getIndexManager(this.fProject);
                    List list = indexManager.getFileList(filename);
                    if (list == null || list.size() <= 0) break block9;
                    String workspaceLocation = String.valueOf(this.fProject.getFullPath().toString()) + File.separatorChar;
                    ListSelectionDialog listSelectionDialog = new ListSelectionDialog(PHPeclipsePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)list, (IStructuredContentProvider)new ListContentProvider(), (ILabelProvider)new LabelProvider(), "Select the includes to open.");
                    listSelectionDialog.setTitle("Multiple includes found");
                    if (listSelectionDialog.open() != 0 || (locations = listSelectionDialog.getResult()) == null) break block9;
                    try {
                        int i = 0;
                        while (i < locations.length) {
                            String openFilename = String.valueOf(workspaceLocation) + (String)locations[i];
                            PHPeclipsePlugin.getDefault().openFileInTextEditor(openFilename);
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void openIdentifierDeclaration(IFile f, String identiifer) {
        IdentifierIndexManager indexManager;
        List locationsList;
        if (identiifer != null && !identiifer.equals("") && (locationsList = (indexManager = PHPeclipsePlugin.getDefault().getIndexManager(this.fProject)).getLocations(identiifer)) != null && locationsList.size() > 0) {
            String workspaceLocation = String.valueOf(this.fProject.getFullPath().toString()) + File.separatorChar;
            if (locationsList.size() > 1) {
                Object[] locations;
                IncludesScanner includesScanner = new IncludesScanner(this.fProject, (IFileEditorInput)this.fEditor.getEditorInput());
                includesScanner.addFile(f);
                Set exactIncludeSet = includesScanner.getSet();
                int i = 0;
                while (i < locationsList.size()) {
                    PHPIdentifierLocation includeName = (PHPIdentifierLocation)locationsList.get(i);
                    if (exactIncludeSet.contains(includeName.getFilename())) {
                        includeName.setMatch(2);
                    } else {
                        includeName.setMatch(0);
                    }
                    ++i;
                }
                Collections.sort(locationsList);
                ListSelectionDialog listSelectionDialog = new ListSelectionDialog(PHPeclipsePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)locationsList, (IStructuredContentProvider)new ListContentProvider(), (ILabelProvider)new LabelProvider(), "Select the resources to open.");
                listSelectionDialog.setTitle("Multiple declarations found");
                if (listSelectionDialog.open() == 0 && (locations = listSelectionDialog.getResult()) != null) {
                    try {
                        int i2 = 0;
                        while (i2 < locations.length) {
                            PHPIdentifierLocation location = (PHPIdentifierLocation)locations[i2];
                            String filename = String.valueOf(workspaceLocation) + location.getFilename();
                            if (location.getOffset() >= 0) {
                                PHPeclipsePlugin.getDefault().openFileAndGotoOffset(filename, location.getOffset(), identiifer.length());
                            } else {
                                PHPeclipsePlugin.getDefault().openFileAndFindString(filename, identiifer);
                            }
                            ++i2;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    PHPIdentifierLocation location = (PHPIdentifierLocation)locationsList.get(0);
                    String filename = String.valueOf(workspaceLocation) + location.getFilename();
                    if (location.getOffset() >= 0) {
                        PHPeclipsePlugin.getDefault().openFileAndGotoOffset(filename, location.getOffset(), identiifer.length());
                    } else {
                        PHPeclipsePlugin.getDefault().openFileAndFindString(filename, identiifer);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getIdentifierOrInclude(IDocument doc, int pos) {
        Point word = null;
        int start = -1;
        int end = -1;
        this.isIncludeString = false;
        try {
            int position = pos;
            int character = 32;
            while (position >= 0) {
                character = doc.getChar(position);
                if (character == 34 || character == 39 || character == 13 || character == 10) break;
                --position;
            }
            if (character == 34 || character == 39) {
                start = position;
                position = pos;
                int length = doc.getLength();
                character = 32;
                while (position < length) {
                    character = doc.getChar(position);
                    if (character == 34 || character == 39 || character == 13 || character == 10) break;
                    ++position;
                }
                if ((character == 34 || character == 39) && (end = position) > ++start) {
                    word = new Point(start, end - start);
                    this.isIncludeString = true;
                }
            }
            if (word == null) {
                word = PHPWordExtractor.findWord(doc, pos);
                this.isIncludeString = false;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (word != null) {
            try {
                return doc.get(word.x, word.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }
}

