/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.builder;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.sourceforge.phpdt.core.compiler.ITerminalSymbols;
import net.sourceforge.phpdt.core.compiler.InvalidInputException;
import net.sourceforge.phpdt.internal.compiler.parser.Scanner;
import net.sourceforge.phpdt.internal.compiler.parser.SyntaxError;
import net.sourceforge.phpdt.internal.compiler.util.Util;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.builder.PHPIdentifierLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class IdentifierIndexManager {
    private HashMap fFileMap;
    private String fFilename;
    private TreeMap fIndentifierMap;

    public IdentifierIndexManager(String filename) {
        this.fFilename = filename;
        this.initialize();
        this.readFile();
    }

    private static boolean equalCharArrays(char[] a, char[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < b.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public LineCreator createLineCreator() {
        return new LineCreator();
    }

    public void addFile(IFile fileToParse) {
        LineCreator lineCreator = this.createLineCreator();
        try {
            this.addInputStream(new BufferedInputStream(fileToParse.getContents()), fileToParse.getProjectRelativePath().toString(), lineCreator, fileToParse.getCharset());
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addInputStream(InputStream stream, String filePath, LineCreator lineCreator, String charset) throws CoreException {
        try {
            try {
                StringBuffer lineBuffer = new StringBuffer();
                lineBuffer.append(filePath);
                lineCreator.parseIdentifiers(Util.getInputStreamAsCharArray(stream, -1, charset), lineBuffer);
                this.addLine(lineBuffer.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (stream == null) return;
        stream.close();
    }

    private void addLine(String line) {
        this.addLine(this.fIndentifierMap, this.fFileMap, line, null);
    }

    public TreeMap getIdentifiers(IFile file) {
        TreeMap treeMap = new TreeMap(new StringComparator());
        this.addIdentifiers(treeMap, file);
        return treeMap;
    }

    public TreeMap getIdentifiers(String startClazz) {
        TreeMap treeMap = new TreeMap(new StringComparator());
        this.addIdentifiers(treeMap, startClazz);
        return treeMap;
    }

    public void addIdentifiers(TreeMap treeMap, IFile file) {
        String line = (String)this.fFileMap.get(file.getProjectRelativePath().toString());
        if (line != null) {
            ArrayList allClassNames = new ArrayList();
            this.addLine(treeMap, null, line, allClassNames);
            int i = 0;
            while (i < allClassNames.size()) {
                String clazz = (String)allClassNames.get(i++);
                this.addClassName(treeMap, clazz, allClassNames);
            }
        }
    }

    public void addIdentifiers(TreeMap treeMap, String startClazz) {
        ArrayList allClassNames = new ArrayList();
        this.addClassName(treeMap, startClazz, allClassNames);
        int i = 0;
        while (i < allClassNames.size()) {
            String clazz = (String)allClassNames.get(i++);
            this.addClassName(treeMap, clazz, allClassNames);
        }
    }

    private boolean addClassName(TreeMap treeMap, String clazz, List allClassNames) {
        List list = this.getLocations(clazz);
        if (list == null) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < list.size()) {
            PHPIdentifierLocation ident = (PHPIdentifierLocation)list.get(i);
            if (ident.isClass()) {
                String line = (String)this.fFileMap.get(ident.getFilename());
                this.addLine(treeMap, null, line, allClassNames);
                result = true;
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addLine(TreeMap treeMap, HashMap fileMap, String line, List allClassNames) {
        String phpFileName = null;
        String identifier = null;
        String classname = null;
        String offset = null;
        PHPIdentifierLocation phpIdentifier = null;
        StringTokenizer tokenizer = new StringTokenizer(line, "\t");
        try {
            if (!tokenizer.hasMoreTokens()) return;
            phpFileName = tokenizer.nextToken();
            while (true) {
                if (!tokenizer.hasMoreTokens()) {
                    if (fileMap == null) return;
                    fileMap.put(phpFileName, line);
                    return;
                }
                String token = tokenizer.nextToken();
                switch (token.charAt(0)) {
                    case 'c': {
                        classname = identifier = token.substring(1);
                        phpIdentifier = new PHPIdentifierLocation(identifier, 1, phpFileName);
                        break;
                    }
                    case 'd': {
                        identifier = token.substring(1);
                        phpIdentifier = new PHPIdentifierLocation(identifier, 5, phpFileName);
                        break;
                    }
                    case 'e': {
                        String extName;
                        identifier = null;
                        phpIdentifier = null;
                        if (allClassNames == null || allClassNames.contains(extName = token.substring(1))) break;
                        allClassNames.add(extName);
                        break;
                    }
                    case 'f': {
                        identifier = token.substring(1);
                        phpIdentifier = new PHPIdentifierLocation(identifier, 2, phpFileName);
                        break;
                    }
                    case 'g': {
                        identifier = token.substring(1);
                        phpIdentifier = new PHPIdentifierLocation(identifier, 7, phpFileName);
                        break;
                    }
                    case 'i': {
                        String implName;
                        identifier = null;
                        phpIdentifier = null;
                        if (allClassNames == null || allClassNames.contains(implName = token.substring(1))) break;
                        allClassNames.add(implName);
                        break;
                    }
                    case 'k': {
                        identifier = token.substring(1);
                        phpIdentifier = new PHPIdentifierLocation(identifier, 6, phpFileName);
                        break;
                    }
                    case 'm': {
                        identifier = token.substring(1);
                        phpIdentifier = new PHPIdentifierLocation(identifier, 4, phpFileName, classname);
                        break;
                    }
                    case 'v': {
                        identifier = token.substring(1);
                        phpIdentifier = new PHPIdentifierLocation(identifier, 3, phpFileName, classname);
                        break;
                    }
                    case 'o': {
                        identifier = null;
                        if (phpIdentifier == null) break;
                        offset = token.substring(1);
                        phpIdentifier.setOffset(Integer.parseInt(offset));
                        break;
                    }
                    case 'p': {
                        identifier = null;
                        if (phpIdentifier == null) break;
                        offset = token.substring(1);
                        phpIdentifier.setPHPDocOffset(Integer.parseInt(offset));
                        break;
                    }
                    case 'l': {
                        identifier = null;
                        if (phpIdentifier == null) break;
                        offset = token.substring(1);
                        phpIdentifier.setPHPDocLength(Integer.parseInt(offset));
                        break;
                    }
                    default: {
                        PHPeclipsePlugin.log(4, "Unknown token character in IdentifierIndexManager: " + token.charAt(0));
                        identifier = null;
                        phpIdentifier = null;
                        classname = null;
                    }
                }
                if (identifier == null || phpIdentifier == null) continue;
                ArrayList<PHPIdentifierLocation> list = (ArrayList<PHPIdentifierLocation>)treeMap.get(identifier);
                if (list == null) {
                    list = new ArrayList<PHPIdentifierLocation>();
                    list.add(phpIdentifier);
                    treeMap.put(identifier, list);
                    continue;
                }
                boolean flag = false;
                int i = 0;
                while (i < list.size()) {
                    if (list.get(i).equals(phpIdentifier)) {
                        flag = true;
                        break;
                    }
                    ++i;
                }
                if (flag) continue;
                list.add(phpIdentifier);
            }
        }
        catch (Throwable e) {
            PHPeclipsePlugin.log(e);
        }
    }

    public void changeFile(IFile fileToParse) {
        this.removeFile(fileToParse);
        this.addFile(fileToParse);
    }

    public List getLocations(String identifier) {
        List list = (List)this.fIndentifierMap.get(identifier);
        if (list != null) {
            return list;
        }
        return new ArrayList();
    }

    public void initialize() {
        this.fIndentifierMap = new TreeMap(new StringComparator());
        this.fFileMap = new HashMap();
    }

    private void readFile() {
        try {
            FileReader fileReader = new FileReader(this.fFilename);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while (bufferedReader.ready()) {
                String line = bufferedReader.readLine();
                this.addLine(line);
            }
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeFile(IFile fileToParse) {
        String line = (String)this.fFileMap.get(fileToParse.getProjectRelativePath().toString());
        if (line != null) {
            this.removeLine(line);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeLine(String line) {
        String phpFileName = null;
        String identifier = null;
        String classname = null;
        PHPIdentifierLocation phpIdentifier = null;
        StringTokenizer tokenizer = new StringTokenizer(line, "\t");
        if (!tokenizer.hasMoreTokens()) return;
        phpFileName = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            ArrayList list;
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case 'c': {
                    classname = identifier = token.substring(1);
                    phpIdentifier = new PHPIdentifierLocation(identifier, 1, phpFileName);
                    break;
                }
                case 'd': {
                    identifier = token.substring(1);
                    phpIdentifier = new PHPIdentifierLocation(identifier, 5, phpFileName);
                    break;
                }
                case 'e': {
                    identifier = null;
                    phpIdentifier = null;
                    break;
                }
                case 'f': {
                    identifier = token.substring(1);
                    phpIdentifier = new PHPIdentifierLocation(identifier, 2, phpFileName);
                    break;
                }
                case 'g': {
                    identifier = token.substring(1);
                    phpIdentifier = new PHPIdentifierLocation(identifier, 7, phpFileName);
                    break;
                }
                case 'i': {
                    identifier = null;
                    phpIdentifier = null;
                    break;
                }
                case 'k': {
                    identifier = token.substring(1);
                    phpIdentifier = new PHPIdentifierLocation(identifier, 6, phpFileName);
                    break;
                }
                case 'm': {
                    identifier = token.substring(1);
                    phpIdentifier = new PHPIdentifierLocation(identifier, 4, phpFileName, classname);
                    break;
                }
                case 'o': {
                    identifier = null;
                    break;
                }
                case 'p': {
                    identifier = null;
                    break;
                }
                case 'l': {
                    identifier = null;
                    break;
                }
                case 'v': {
                    identifier = token.substring(1);
                    phpIdentifier = new PHPIdentifierLocation(identifier, 3, phpFileName, classname);
                    break;
                }
                default: {
                    PHPeclipsePlugin.log(4, "Unknown token character in IdentifierIndexManager: " + token.charAt(0));
                    identifier = null;
                    phpIdentifier = null;
                    classname = null;
                }
            }
            if (identifier == null || phpIdentifier == null || (list = (ArrayList)this.fIndentifierMap.get(identifier)) == null) continue;
            int i = 0;
            while (i < list.size()) {
                if (list.get(i).equals(phpIdentifier)) {
                    list.remove(i);
                    break;
                }
                ++i;
            }
            if (list.size() != 0) continue;
            this.fIndentifierMap.remove(identifier);
        }
        this.fFileMap.remove(phpFileName);
    }

    public void writeFile() {
        try {
            FileWriter fileWriter = new FileWriter(this.fFilename);
            Collection collection = this.fFileMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                fileWriter.write(String.valueOf(line) + '\n');
            }
            fileWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SortedMap getIdentifierMap() {
        return this.fIndentifierMap;
    }

    public synchronized List getFileList(String filePattern) {
        Set set = this.fFileMap.keySet();
        if (set.isEmpty()) {
            return null;
        }
        Iterator iter = set.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (iter.hasNext()) {
            String fileName = (String)iter.next();
            int index = fileName.indexOf(filePattern);
            if (index == -1 || fileName.length() != index + filePattern.length()) continue;
            list.add(fileName);
        }
        return list;
    }

    static /* synthetic */ boolean access$0(char[] cArray, char[] cArray2) {
        return IdentifierIndexManager.equalCharArrays(cArray, cArray2);
    }

    public class LineCreator
    implements ITerminalSymbols {
        private Scanner fScanner = new Scanner(true, false, false, false, true, null, null, true);
        private int fToken;

        private void addIdentifierInformation(char typeOfIdentifier, char[] identifier, StringBuffer line) {
            line.append('\t');
            line.append(typeOfIdentifier);
            line.append(identifier);
        }

        private void addIdentifierInformation(char typeOfIdentifier, char[] identifier, StringBuffer line, int phpdocOffset, int phpdocLength) {
            line.append('\t');
            line.append(typeOfIdentifier);
            line.append(identifier);
            line.append("\to");
            line.append(this.fScanner.getCurrentTokenStartPosition());
            if (phpdocOffset >= 0) {
                line.append("\tp");
                line.append(phpdocOffset);
                line.append("\tl");
                line.append(phpdocLength);
            }
        }

        private void addClassVariableInformation(char typeOfIdentifier, char[] identifier, StringBuffer line, int phpdocOffset, int phpdocLength) {
            line.append('\t');
            line.append(typeOfIdentifier);
            line.append(identifier);
            line.append("\to");
            line.append(this.fScanner.getCurrentTokenStartPosition() + 1);
            if (phpdocOffset >= 0) {
                line.append("\tp");
                line.append(phpdocOffset);
                line.append("\tl");
                line.append(phpdocLength);
            }
        }

        private void getNextToken() throws InvalidInputException {
            this.fToken = this.fScanner.getNextToken();
        }

        private void skipComments() {
            try {
                this.getNextToken();
                while (this.fToken == 902 || this.fToken == 903) {
                    this.getNextToken();
                }
            }
            catch (InvalidInputException e1) {
                e1.printStackTrace();
            }
        }

        /*
         * Unable to fully structure code
         */
        private void parseDeclarations(char[] parent, StringBuffer buf, boolean goBack) {
            block25: {
                counter = 0;
                hasModifiers = false;
                phpdocOffset = -1;
                phpdocLength = -1;
lbl5:
                // 3 sources

                try {
                    while (this.fToken != 0 && this.fToken != 1) {
                        block27: {
                            block26: {
                                phpdocOffset = -1;
                                hasModifiers = false;
                                if (this.fToken == 903) {
                                    phpdocOffset = this.fScanner.getCurrentTokenStartPosition();
                                    phpdocLength = this.fScanner.getCurrentTokenEndPosition() - this.fScanner.getCurrentTokenStartPosition() + 1;
                                    this.getNextToken();
                                    while (this.fToken == 1027 || this.fToken == 1069 || this.fToken == 1056 || this.fToken == 1055 || this.fToken == 1054 || this.fToken == 1050) {
                                        hasModifiers = true;
                                        this.getNextToken();
                                    }
                                    if (this.fToken == 0 || this.fToken == 1) break block25;
                                }
                                if (this.fToken == 1020) {
                                    this.skipComments();
                                    if (this.fToken == 52) {
                                        this.getNextToken();
                                    }
                                    if (this.fToken != 138) continue;
                                    ident = this.fScanner.getCurrentIdentifierSource();
                                    if (parent != null && IdentifierIndexManager.access$0(parent, ident)) {
                                        this.addIdentifierInformation('k', ident, buf, phpdocOffset, phpdocLength);
                                    } else if (parent != null) {
                                        this.addIdentifierInformation('m', ident, buf, phpdocOffset, phpdocLength);
                                    } else {
                                        this.addIdentifierInformation('f', ident, buf, phpdocOffset, phpdocLength);
                                    }
                                    this.skipComments();
                                    this.parseDeclarations(null, buf, true);
                                    continue;
                                }
                                if (this.fToken == 1021 || this.fToken == 1057) {
                                    this.skipComments();
                                    if (this.fToken != 138) continue;
                                    ident = this.fScanner.getCurrentIdentifierSource();
                                    this.addIdentifierInformation('c', ident, buf, phpdocOffset, phpdocLength);
                                    this.skipComments();
                                    if (this.fToken == 1030) {
                                        this.skipComments();
                                        while (this.fToken == 138) {
                                            ident = this.fScanner.getCurrentIdentifierSource();
                                            this.addIdentifierInformation('e', ident, buf);
                                            this.skipComments();
                                            if (this.fToken != 134) continue;
                                            this.skipComments();
                                        }
                                    }
                                    if (this.fToken == 1058) {
                                        this.skipComments();
                                        while (this.fToken == 138) {
                                            ident = this.fScanner.getCurrentIdentifierSource();
                                            this.addIdentifierInformation('e', ident, buf);
                                            this.skipComments();
                                            if (this.fToken != 134) continue;
                                            this.skipComments();
                                        }
                                    }
                                    while (this.fToken != 130 && this.fToken != 0 && this.fToken != 1) {
                                        this.getNextToken();
                                    }
                                    this.parseDeclarations(ident, buf, true);
                                    continue;
                                }
                                if (this.fToken != 1034 && !hasModifiers && this.fToken != 1027 && this.fToken != 1069 && this.fToken != 1056 && this.fToken != 1055 && this.fToken != 1054) break block26;
                                while (this.fToken == 1034 || this.fToken == 1027 || this.fToken == 1069 || this.fToken == 1056 || this.fToken == 1055 || this.fToken == 1054) {
                                    this.skipComments();
                                }
                                while (this.fToken == 150) {
                                    ident = this.fScanner.getCurrentIdentifierSource();
                                    classVariable = new char[ident.length - 1];
                                    System.arraycopy(ident, 1, classVariable, 0, ident.length - 1);
                                    this.addClassVariableInformation('v', classVariable, buf, phpdocOffset, phpdocLength);
                                    this.skipComments();
                                    if (this.fToken != 134) continue;
                                    this.skipComments();
                                }
                                ** GOTO lbl5
                            }
                            if (!hasModifiers && this.fToken == 138) {
                                ident = this.fScanner.getCurrentIdentifierSource();
                                this.getNextToken();
                                if (ident.length != 6 || ident[0] != 'd' || ident[1] != 'e' || ident[2] != 'f' || ident[3] != 'i' || ident[4] != 'n' || ident[5] != 'e' || this.fToken != 128) continue;
                                this.getNextToken();
                                if (this.fToken == 136) {
                                    ident = this.fScanner.getCurrentStringLiteralSource();
                                    this.addIdentifierInformation('d', ident, buf, phpdocOffset, phpdocLength);
                                    this.getNextToken();
                                    continue;
                                }
                                if (this.fToken != 154) continue;
                                ident = this.fScanner.getCurrentStringLiteralSource();
                                this.addIdentifierInformation('d', ident, buf, phpdocOffset, phpdocLength);
                                this.getNextToken();
                                continue;
                            }
                            if (this.fToken != 1026) break block27;
                            while (this.fToken != 0 && this.fToken != 1 && this.fToken != 140 && this.fToken != 130 && this.fToken != 131) {
                                this.getNextToken();
                                if (this.fToken != 150) continue;
                                ident = this.fScanner.getCurrentIdentifierSource();
                                this.addIdentifierInformation('g', ident, buf, phpdocOffset, phpdocLength);
                            }
                            ** GOTO lbl5
                        }
                        if (this.fToken == 130) {
                            this.getNextToken();
                            ++counter;
                            continue;
                        }
                        if (this.fToken == 131) {
                            this.getNextToken();
                            if (--counter != 0 || !goBack) continue;
                            return;
                        }
                        this.getNextToken();
                    }
                }
                catch (InvalidInputException v0) {
                }
                catch (SyntaxError e) {
                    e.printStackTrace();
                }
            }
        }

        public synchronized void parseIdentifiers(char[] charArray, StringBuffer buf) {
            int phpdocOffset = -1;
            int phpdocLength = -1;
            this.fScanner.setSource(charArray);
            this.fScanner.setPHPMode(false);
            this.fToken = 0;
            try {
                this.getNextToken();
                block9: while (this.fToken != 0) {
                    phpdocOffset = -1;
                    switch (this.fToken) {
                        case 903: {
                            phpdocOffset = this.fScanner.getCurrentTokenStartPosition();
                            phpdocLength = this.fScanner.getCurrentTokenEndPosition() - this.fScanner.getCurrentTokenStartPosition() + 1;
                            this.getNextToken();
                            while (this.fToken == 1027 || this.fToken == 1069 || this.fToken == 1056 || this.fToken == 1055 || this.fToken == 1054 || this.fToken == 1050) {
                                this.getNextToken();
                            }
                            if (this.fToken == 0 || this.fToken != 1) continue block9;
                            break;
                        }
                        case 1020: {
                            this.skipComments();
                            if (this.fToken == 52) {
                                this.getNextToken();
                            }
                            if (this.fToken != 138) continue block9;
                            char[] ident = this.fScanner.getCurrentIdentifierSource();
                            this.addIdentifierInformation('f', ident, buf, phpdocOffset, phpdocLength);
                            this.skipComments();
                            if (this.fToken == 128) {
                                this.skipComments();
                                do {
                                    if (this.fToken == 150) {
                                        ident = this.fScanner.getCurrentIdentifierSource();
                                        this.addIdentifierInformation('v', ident, buf, phpdocOffset, phpdocLength);
                                    }
                                    this.skipComments();
                                    if (this.fToken != 134) continue;
                                    this.skipComments();
                                } while (this.fToken != 129);
                            }
                            this.parseDeclarations(null, buf, true);
                            break;
                        }
                        case 1021: 
                        case 1057: {
                            this.skipComments();
                            if (this.fToken != 138) continue block9;
                            char[] ident = this.fScanner.getCurrentIdentifierSource();
                            this.addIdentifierInformation('c', ident, buf, phpdocOffset, phpdocLength);
                            this.skipComments();
                            if (this.fToken == 1030) {
                                this.skipComments();
                                while (this.fToken == 138) {
                                    ident = this.fScanner.getCurrentIdentifierSource();
                                    this.addIdentifierInformation('e', ident, buf);
                                    this.skipComments();
                                    if (this.fToken != 134) continue;
                                    this.skipComments();
                                }
                            }
                            if (this.fToken == 1058) {
                                this.skipComments();
                                while (this.fToken == 138) {
                                    ident = this.fScanner.getCurrentIdentifierSource();
                                    this.addIdentifierInformation('e', ident, buf);
                                    this.skipComments();
                                    if (this.fToken != 134) continue;
                                    this.skipComments();
                                }
                            }
                            while (this.fToken != 130 && this.fToken != 0 && this.fToken != 1) {
                                this.getNextToken();
                            }
                            this.parseDeclarations(ident, buf, true);
                            break;
                        }
                        case 150: {
                            char[] ident = this.fScanner.getCurrentIdentifierSource();
                            this.addIdentifierInformation('g', ident, buf, phpdocOffset, phpdocLength);
                            this.getNextToken();
                            break;
                        }
                        default: {
                            this.getNextToken();
                        }
                    }
                }
            }
            catch (InvalidInputException invalidInputException) {
            }
            catch (SyntaxError e) {
                e.printStackTrace();
            }
        }
    }

    class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }

        public boolean equals(Object o) {
            String cfr_ignored_0 = (String)o;
            return this.compare(this, o) == 0;
        }
    }
}

