/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.builder;

import net.sourceforge.phpeclipse.obfuscator.PHPIdentifier;

public class PHPIdentifierLocation
extends PHPIdentifier
implements Comparable {
    public static final int UNDEFINED_MATCH = 0;
    public static final int PATTERN_MATCH = 1;
    public static final int EXACT_MATCH = 2;
    private int fMatch;
    private String fClassname;
    private String fFilename;
    private int fOffset;
    private int fPHPDocLength;
    private int fPHPDocOffset;
    private String fUsage;

    public PHPIdentifierLocation(String identifier, int type, String filename) {
        this(identifier, type, filename, null);
    }

    public PHPIdentifierLocation(String identifier, int type, String filename, String classname) {
        super(identifier, type);
        this.fFilename = filename;
        this.fClassname = classname;
        this.fOffset = -1;
        this.fPHPDocLength = -1;
        this.fPHPDocOffset = -1;
        this.fUsage = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PHPIdentifierLocation)) {
            return false;
        }
        return super.equals(obj) && this.fFilename.equals(((PHPIdentifierLocation)obj).fFilename);
    }

    public String getClassname() {
        return this.fClassname;
    }

    public String getFilename() {
        return this.fFilename;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getPHPDocLength() {
        return this.fPHPDocLength;
    }

    public int getPHPDocOffset() {
        return this.fPHPDocOffset;
    }

    public String getUsage() {
        return this.fUsage;
    }

    public void setClassname(String string) {
        this.fClassname = string;
    }

    public void setFilename(String string) {
        this.fFilename = string;
    }

    public void setOffset(int i) {
        this.fOffset = i;
    }

    public void setPHPDocLength(int i) {
        this.fPHPDocLength = i;
    }

    public void setPHPDocOffset(int i) {
        this.fPHPDocOffset = i;
    }

    public void setUsage(String string) {
        this.fUsage = string;
    }

    public String toString() {
        String result = null;
        switch (this.fMatch) {
            case 0: {
                result = " [";
                break;
            }
            case 1: {
                result = " [pattern include][";
                break;
            }
            case 2: {
                result = " [exact include][";
                break;
            }
            default: {
                result = "";
            }
        }
        return String.valueOf(super.toString()) + result + this.fFilename + "]";
    }

    public int compareTo(Object o) {
        PHPIdentifierLocation i = (PHPIdentifierLocation)o;
        if (this.fMatch > i.fMatch) {
            return -1;
        }
        if (this.fMatch < i.fMatch) {
            return 1;
        }
        return this.fFilename.compareTo(i.fFilename);
    }

    public int getMatch() {
        return this.fMatch;
    }

    public void setMatch(int match) {
        this.fMatch = match;
    }
}

