/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.obfuscator;

import java.io.File;
import java.io.InputStream;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.obfuscator.ObfuscatorIgnoreSet;
import net.sourceforge.phpeclipse.obfuscator.ObfuscatorMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;

public class ObfuscatorIgnores
extends ObfuscatorIgnoreSet {
    private static final String DEFAULT_FILE = "default-obfuscator.xml";
    private static final String TEMPLATE_FILE = "obfuscator.xml";
    private static ObfuscatorIgnores fgIgnores;
    private IProject fProject;
    static /* synthetic */ Class class$0;

    public ObfuscatorIgnores(IProject project) {
        this.fProject = project;
        try {
            File templateFile = this.getTemplateFile();
            if (templateFile.exists()) {
                this.addFromFile(templateFile);
            } else {
                this.addFromStream(this.getDefaultsAsStream());
                this.saveToFile(templateFile);
            }
        }
        catch (CoreException e) {
            PHPeclipsePlugin.log(e);
            ErrorDialog.openError(null, (String)ObfuscatorMessages.getString("Obfuscator.error.title"), (String)e.getMessage(), (IStatus)e.getStatus());
            this.clear();
        }
    }

    public void reset() throws CoreException {
        this.clear();
        this.addFromFile(this.getTemplateFile());
    }

    public void restoreDefaults() throws CoreException {
        this.clear();
        this.addFromStream(this.getDefaultsAsStream());
    }

    public void save() throws CoreException {
        this.saveToFile(this.getTemplateFile());
    }

    private InputStream getDefaultsAsStream() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.phpeclipse.obfuscator.ObfuscatorIgnores");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getResourceAsStream(DEFAULT_FILE);
    }

    private File getTemplateFile() {
        IPath path = this.fProject.getFullPath();
        path = path.append(TEMPLATE_FILE);
        return path.toFile();
    }
}

