/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.core.internal.parser;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.phpeclipse.xml.core.internal.model.XMLDocument;
import net.sourceforge.phpeclipse.xml.core.internal.model.XMLElement;
import net.sourceforge.phpeclipse.xml.core.internal.parser.DefaultProblem;
import net.sourceforge.phpeclipse.xml.core.model.IXMLDocument;
import net.sourceforge.phpeclipse.xml.core.model.IXMLElement;
import net.sourceforge.phpeclipse.xml.core.parser.IProblem;
import net.sourceforge.phpeclipse.xml.core.parser.IProblemCollector;
import net.sourceforge.phpeclipse.xml.core.parser.IXMLParser;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
implements IXMLParser {
    IProblemCollector problemCollector;
    IDocument source;
    String systemId;

    public IXMLDocument parse() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            SAXParser parser = factory.newSAXParser();
            InputSource in = new InputSource(new StringReader(this.source.get()));
            if (this.systemId != null) {
                in.setSystemId(this.systemId);
            }
            ModelBuilder builder = new ModelBuilder();
            parser.parse(in, (DefaultHandler)builder);
            return builder.document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public void setProblemCollector(IProblemCollector problemCollector) {
        this.problemCollector = problemCollector;
    }

    public void setSource(IDocument source) {
        this.source = source;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    int computeLength(XMLElement element, int line, int column) {
        try {
            String endTag;
            int lineOffset;
            IRegion result;
            int offset;
            offset = column <= 0 ? ((offset = (result = this.findStringForward(lineOffset = this.source.getLineOffset(line), endTag = this.getEndTag(element))) != null ? result.getOffset() + endTag.length() : ((result = this.findStringForward(lineOffset, "/>")) == null ? -1 : result.getOffset() + 2)) < 0 || this.getLine(offset) != line ? lineOffset : ++offset) : this.getOffset(line, column);
            return offset - element.getSourceRegion().getOffset();
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    int computeOffset(XMLElement element, int line, int column) {
        try {
            int offset;
            String prefix = "<";
            if (column <= 0) {
                String startTag;
                offset = this.getOffset(line, 0);
                int lastCharColumn = this.getLastCharColumn(line);
                String lineText = this.source.get(this.source.getLineOffset(line - 1), lastCharColumn);
                int lastIndex = lineText.indexOf(startTag = this.getStartTag(element));
                if (lastIndex > -1) {
                    offset += lastIndex + 1;
                } else {
                    offset = this.getOffset(line, lastCharColumn);
                    IRegion result = this.findStringBackward(offset - 1, prefix);
                    offset = result.getOffset();
                }
            } else {
                offset = this.getOffset(line, column);
                IRegion result = this.findStringForward(offset - 1, prefix);
                offset = result.getOffset();
            }
            return offset;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private IRegion findStringBackward(int startOffset, String string) throws BadLocationException {
        int offset = startOffset;
        int length = string.length();
        while (offset >= 0) {
            String match = this.source.get(offset, length);
            if (match.equals(string)) {
                return new Region(offset, length);
            }
            --offset;
        }
        return null;
    }

    private IRegion findStringForward(int startOffset, String string) throws BadLocationException {
        int offset = startOffset;
        int length = string.length();
        int sourceLength = this.source.getLength();
        while (offset + length <= sourceLength) {
            String match = this.source.get(offset, length);
            if (match.equals(string)) {
                return new Region(offset, length);
            }
            ++offset;
        }
        return null;
    }

    private String getEndTag(IXMLElement element) {
        StringBuffer buf = new StringBuffer("</");
        if (element.getPrefix() != null) {
            buf.append(element.getPrefix());
            buf.append(':');
        }
        buf.append(element.getLocalName());
        buf.append('>');
        return buf.toString();
    }

    private String getStartTag(IXMLElement element) {
        StringBuffer buf = new StringBuffer("<");
        if (element.getPrefix() != null) {
            buf.append(element.getPrefix());
            buf.append(':');
        }
        buf.append(element.getLocalName());
        return buf.toString();
    }

    int getOffset(int line, int column) throws BadLocationException {
        return this.source.getLineOffset(line - 1) + column - 1;
    }

    private int getLine(int offset) throws BadLocationException {
        return this.source.getLineOfOffset(offset) + 1;
    }

    int getLastCharColumn(int line) throws BadLocationException {
        String lineDelimiter = this.source.getLineDelimiter(line - 1);
        int lineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
        return this.source.getLineLength(line - 1) - lineDelimiterLength;
    }

    class ModelBuilder
    extends DefaultHandler {
        XMLDocument document;
        private XMLElement top;
        private Locator locator;
        private long timeout;

        ModelBuilder() {
        }

        public void startDocument() throws SAXException {
            this.timeout = System.currentTimeMillis() + 2000L;
            this.document = new XMLDocument(XMLParser.this.source, XMLParser.this.systemId);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            int offset;
            int colonIndex;
            if (System.currentTimeMillis() > this.timeout) {
                throw new SAXException("timeout");
            }
            XMLElement newTop = new XMLElement(XMLParser.this.source);
            newTop.setLocalName(localName);
            newTop.setNamespaceURI(namespaceURI);
            if (qName != null && (colonIndex = qName.indexOf(58)) >= 0) {
                newTop.setPrefix(qName.substring(0, colonIndex));
            }
            if ((offset = XMLParser.this.computeOffset(newTop, this.locator.getLineNumber(), this.locator.getColumnNumber())) >= 0) {
                newTop.setSourceRegion(offset, 0);
            }
            if (this.top != null) {
                newTop.setParent(this.top);
            }
            this.top = newTop;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            XMLElement previousTop;
            int length = XMLParser.this.computeLength(this.top, this.locator.getLineNumber(), this.locator.getColumnNumber());
            if (length >= 0) {
                this.top.setSourceRegion(this.top.getSourceRegion().getOffset(), length);
            }
            if ((previousTop = (XMLElement)this.top.getParent()) != null) {
                previousTop.addChild(this.top);
            } else {
                this.document.setRoot(this.top);
            }
            this.top = previousTop;
        }

        public void error(SAXParseException e) throws SAXException {
            if (XMLParser.this.problemCollector != null) {
                XMLParser.this.problemCollector.addProblem(this.createProblem(e, true));
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            if (XMLParser.this.problemCollector != null) {
                XMLParser.this.problemCollector.addProblem(this.createProblem(e, true));
            }
        }

        public void warning(SAXParseException e) throws SAXException {
            if (XMLParser.this.problemCollector != null) {
                XMLParser.this.problemCollector.addProblem(this.createProblem(e, false));
            }
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private IProblem createProblem(SAXParseException e, boolean error) {
            int line = e.getLineNumber();
            int column = e.getColumnNumber();
            if (line < 0) {
                line = 0;
            }
            if (column < 1) {
                column = 1;
            }
            int offset = 0;
            int length = 1;
            try {
                offset = XMLParser.this.getOffset(line, column);
                length = XMLParser.this.getLastCharColumn(line) - column;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            return new DefaultProblem(e.getLocalizedMessage(), offset, offset + length, line, error);
        }
    }
}

