/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.ui.php.launching;

import java.io.File;
import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.util.PHPFileSelector;
import net.sourceforge.phpdt.internal.ui.util.PHPProjectSelector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class PHPMainTab
extends AbstractLaunchConfigurationTab {
    protected Text fProjText;
    protected Button fProjButton;
    protected Text fMainText;
    protected Button fSearchButton;
    protected PHPProjectSelector projectSelector;
    protected PHPFileSelector fileSelector;
    private Button fUseDefaultInterpreterButton;
    private Button fInterpreterButton;
    private Text fInterpreterText;
    static /* synthetic */ Class class$0;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createMainTypeEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createInterpreterEditor(comp);
    }

    private void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Project:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.projectSelector = new PHPProjectSelector((Composite)group);
        this.projectSelector.setBrowseDialogMessage("Choose the project containing the application entry point:");
        this.projectSelector.setLayoutData((Object)new GridData(768));
        this.projectSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PHPMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createMainTypeEditor(Composite parent) {
        Font font = parent.getFont();
        Group mainGroup = new Group(parent, 0);
        mainGroup.setText("File: ");
        GridData gd = new GridData(768);
        mainGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainGroup.setLayout((Layout)layout);
        mainGroup.setFont(font);
        this.fileSelector = new PHPFileSelector((Composite)mainGroup, this.projectSelector);
        this.fileSelector.setBrowseDialogMessage("Choose the PHP file that represents the application entry point:");
        this.fileSelector.setLayoutData((Object)new GridData(768));
        this.fileSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PHPMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createInterpreterEditor(Composite parent) {
        Font font = parent.getFont();
        Group interpreterGroup = new Group(parent, 0);
        interpreterGroup.setText("Interpreter: ");
        GridData gd = new GridData(768);
        interpreterGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        interpreterGroup.setLayout((Layout)layout);
        interpreterGroup.setFont(font);
        this.fInterpreterText = new Text((Composite)interpreterGroup, 2052);
        gd = new GridData(768);
        this.fInterpreterText.setLayoutData((Object)gd);
        this.fInterpreterText.setFont(font);
        this.fInterpreterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PHPMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fInterpreterButton = this.createPushButton((Composite)interpreterGroup, "Browse..", null);
        this.fInterpreterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PHPMainTab.this.handleBrowseSellected(event);
            }
        });
        this.fUseDefaultInterpreterButton = new Button((Composite)interpreterGroup, 32);
        this.fUseDefaultInterpreterButton.setText("Use default interpreter");
        gd = new GridData(768);
        this.fUseDefaultInterpreterButton.setLayoutData((Object)gd);
        this.fUseDefaultInterpreterButton.setFont(font);
        this.fUseDefaultInterpreterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PHPMainTab.this.handleDefaultSellected(event);
            }
        });
    }

    protected void setInterpreterTextEnabledState() {
        if (this.isDefaultInterpreter()) {
            this.fInterpreterText.setEnabled(false);
            this.fInterpreterButton.setEnabled(false);
        } else {
            this.fInterpreterText.setEnabled(true);
            this.fInterpreterButton.setEnabled(true);
        }
    }

    protected boolean isDefaultInterpreter() {
        return this.fUseDefaultInterpreterButton.getSelection();
    }

    protected void handleDefaultSellected(SelectionEvent event) {
        this.setInterpreterTextEnabledState();
        this.updateLaunchConfigurationDialog();
    }

    protected void handleBrowseSellected(SelectionEvent event) {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        String fileName = dlg.open();
        if (fileName != null) {
            this.fInterpreterText.setText(fileName);
            this.updateLaunchConfigurationDialog();
        }
    }

    protected IProject getContext() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            Object obj;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (obj = ss.getFirstElement()) instanceof IResource) {
                return ((IResource)obj).getProject();
            }
            IEditorPart part = page.getActiveEditor();
            if (part != null) {
                IResource file;
                IEditorInput input = part.getEditorInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((file = (IResource)input.getAdapter((Class)clazz)) != null) {
                    return file.getProject();
                }
            }
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IProject project = this.getContext();
        if (project != null) {
            configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PDA_PROFECT", project.getName());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String interpreterFile;
            String file;
            String project = configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PDA_PROFECT", null);
            if (project != null) {
                this.projectSelector.setSelectionText(project);
            }
            if ((file = configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PDA_FILE", null)) != null) {
                this.fileSelector.setSelectionText(file);
            }
            if ((interpreterFile = configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_INTERPRETER", null)) != null) {
                this.fInterpreterText.setText(interpreterFile);
            }
            boolean selection = configuration.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_DEFAULT_INTERPRETER", true);
            this.fUseDefaultInterpreterButton.setSelection(selection);
            this.setInterpreterTextEnabledState();
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String project = this.projectSelector.getSelectionText().trim();
        if (project.length() == 0) {
            project = null;
        }
        configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PDA_PROFECT", project);
        IFile file = this.fileSelector.getSelection();
        configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PDA_FILE", file == null ? "" : file.getProjectRelativePath().toString());
        configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_DEFAULT_INTERPRETER", this.fUseDefaultInterpreterButton.getSelection());
        configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_INTERPRETER", this.fInterpreterText.getText());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        String projectName = this.projectSelector.getSelectionText().trim();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            this.setErrorMessage("Project does not exist");
            return false;
        }
        String fileString = this.fileSelector.getSelectionText().trim();
        if (!"".equals(fileString)) {
            IFile file = project.getFile(this.fileSelector.getSelectionText().trim());
            if (!file.exists()) {
                this.setErrorMessage("File does not exist");
                return false;
            }
        } else {
            this.setErrorMessage("File does not exist");
            return false;
        }
        if (!this.fUseDefaultInterpreterButton.getSelection()) {
            File exe = new File(this.fInterpreterText.getText());
            System.out.println(exe.toString());
            if (!exe.exists()) {
                this.setErrorMessage("Invalid Interpreter");
                return false;
            }
        }
        return true;
    }

    public Image getImage() {
        return PHPUiImages.get((String)"net.sourceforge.phpdt.internal.ui.php_page.gif");
    }

    public String getName() {
        return "Main";
    }
}

