/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.text;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.phpeclipse.ui.ColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class AbstractTextTools {
    protected IPreferenceStore store;
    protected ColorManager colorManager;
    private Map tokens;
    private String[] properties;
    private String[] foregroundPropertyNames;
    private String[] backgroundPropertyNames;
    private String[] stylePropertyNames;
    private IPropertyChangeListener listener;

    public AbstractTextTools(IPreferenceStore store, String[] properties) {
        this(store, properties, new ColorManager());
    }

    public AbstractTextTools(IPreferenceStore store, String[] properties, ColorManager manager) {
        this.store = store;
        this.properties = properties;
        this.colorManager = manager;
        this.tokens = new HashMap();
        int length = properties.length;
        this.foregroundPropertyNames = new String[length];
        this.backgroundPropertyNames = new String[length];
        this.stylePropertyNames = new String[length];
        int i = 0;
        while (i < length) {
            String property = properties[i];
            String foreground = String.valueOf(property) + "_foreground";
            String background = String.valueOf(property) + "_background";
            String style = String.valueOf(property) + "_style";
            this.foregroundPropertyNames[i] = foreground;
            this.backgroundPropertyNames[i] = background;
            this.stylePropertyNames[i] = style;
            RGB rgb = this.getColor(store, foreground);
            if (rgb != null) {
                this.colorManager.bindColor(foreground, rgb);
            }
            if ((rgb = this.getColor(store, background)) != null) {
                this.colorManager.bindColor(background, rgb);
            }
            this.tokens.put(property, new Token((Object)new TextAttribute(this.colorManager.getColor(foreground), this.colorManager.getColor(background), this.getStyle(store, style))));
            ++i;
        }
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                AbstractTextTools.this.adaptToPreferenceChange(event);
            }
        };
        store.addPropertyChangeListener(this.listener);
    }

    public void dispose() {
        if (this.store != null) {
            this.store.removePropertyChangeListener(this.listener);
            this.store = null;
            this.listener = null;
        }
        if (this.colorManager != null) {
            this.colorManager.dispose();
            this.colorManager = null;
        }
        this.tokens = null;
        this.properties = null;
        this.foregroundPropertyNames = null;
        this.backgroundPropertyNames = null;
        this.stylePropertyNames = null;
    }

    public ColorManager getColorManager() {
        return this.colorManager;
    }

    public Map getTokens() {
        return this.tokens;
    }

    protected Token getToken(String key) {
        int index = this.indexOf(key);
        if (index < 0) {
            return null;
        }
        return (Token)this.tokens.get(this.properties[index]);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.indexOf(event.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        Token token = this.getToken(property);
        if (token != null) {
            if (property.endsWith("_foreground") || property.endsWith("_background")) {
                this.adaptToColorChange(token, event);
            } else if (property.endsWith("_style")) {
                this.adaptToStyleChange(token, event);
            }
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent event) {
        Object data;
        RGB rgb = this.getColor(event.getNewValue());
        String property = event.getProperty();
        this.colorManager.unbindColor(property);
        if (rgb != null) {
            this.colorManager.bindColor(property, rgb);
        }
        if ((data = token.getData()) instanceof TextAttribute) {
            TextAttribute old = (TextAttribute)data;
            int i = this.indexOf(property);
            token.setData((Object)new TextAttribute(this.colorManager.getColor(this.foregroundPropertyNames[i]), this.colorManager.getColor(this.backgroundPropertyNames[i]), old.getStyle()));
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event) {
        TextAttribute old;
        int style = this.getStyle((String)event.getNewValue());
        Object data = token.getData();
        if (data instanceof TextAttribute && (old = (TextAttribute)data).getStyle() != style) {
            token.setData((Object)new TextAttribute(old.getForeground(), old.getBackground(), style));
        }
    }

    private int indexOf(String property) {
        if (property != null) {
            int length = this.properties.length;
            int i = 0;
            while (i < length) {
                if (property.equals(this.properties[i]) || property.equals(this.foregroundPropertyNames[i]) || property.equals(this.backgroundPropertyNames[i]) || property.equals(this.stylePropertyNames[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private RGB getColor(IPreferenceStore store, String key) {
        return this.getColor(store.getString(key));
    }

    private RGB getColor(Object value) {
        if (value instanceof RGB) {
            return (RGB)value;
        }
        String str = (String)value;
        if (str.length() > 0) {
            return StringConverter.asRGB((String)str);
        }
        return null;
    }

    private int getStyle(IPreferenceStore store, String key) {
        return this.getStyle(store.getString(key));
    }

    private int getStyle(String value) {
        if (value.indexOf("bold") >= 0) {
            return 1;
        }
        return 0;
    }
}

