/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class TextDoubleClickStrategy
implements ITextDoubleClickStrategy {
    public void doubleClicked(ITextViewer viewer) {
        int offset = viewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        this.selectWord(viewer, viewer.getDocument(), offset);
    }

    protected void selectWord(ITextViewer textViewer, IDocument document, int offset) {
        try {
            int start = offset;
            while (start >= 0) {
                char c = document.getChar(start);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                --start;
            }
            int length = document.getLength();
            int end = offset;
            while (end < length) {
                char c = document.getChar(end);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                ++end;
            }
            if (start == end) {
                textViewer.setSelectedRange(start, 0);
            } else {
                textViewer.setSelectedRange(start + 1, end - start - 1);
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

