/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.text.rules;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.phpeclipse.ui.text.rules.FlatNode;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;

public abstract class AbstractPartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension {
    public static final boolean DEBUG = false;
    protected IPartitionTokenScanner scanner;
    protected IDocument document;
    protected List nodes = new ArrayList();
    protected int regionStart;
    protected int regionEnd;

    public AbstractPartitioner(IPartitionTokenScanner scanner) {
        this.scanner = scanner;
    }

    protected FlatNode createNode(String type, int offset, int length) {
        FlatNode node = new FlatNode(type);
        node.offset = offset;
        node.length = length;
        return node;
    }

    protected void addInnerRegion(FlatNode position) {
        this.nodes.add(this.computeFlatNodeIndex(position.offset), position);
    }

    protected void removeInnerRegion(FlatNode position) {
        this.nodes.remove(position);
    }

    protected void deleteInnerRegion(FlatNode position) {
        this.nodes.remove(position);
    }

    protected void resizeInnerRegion(FlatNode position) {
    }

    public void connect(IDocument document) {
        this.document = document;
        this.initialize();
    }

    public void disconnect() {
        this.nodes.clear();
        this.document = null;
    }

    protected void initialize() {
        this.scanner.setRange(this.document, 0, this.document.getLength());
        this.nodes.clear();
        IToken token = this.scanner.nextToken();
        while (!token.isEOF()) {
            String contentType = this.getTokenContentType(token);
            if (this.isSupportedContentType(contentType)) {
                this.addInnerRegion(this.createNode(contentType, this.scanner.getTokenOffset(), this.scanner.getTokenLength()));
            }
            token = this.scanner.nextToken();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.regionEnd = -1;
        this.regionStart = -1;
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public IRegion documentChanged2(DocumentEvent event) {
        int offset;
        int first = this.fixupPartitions(event);
        FlatNode[] category = this.nodes.toArray(new FlatNode[this.nodes.size()]);
        String contentType = "__dftl_partition_content_type";
        if (first == 0) {
            offset = 0;
        } else {
            FlatNode partition = category[first - 1];
            offset = event.getOffset();
            if (partition.includes(offset)) {
                offset = partition.offset;
                contentType = partition.type;
                --first;
            } else if (offset == partition.offset + partition.length) {
                offset = partition.offset;
                contentType = partition.type;
                --first;
            } else {
                offset = partition.offset + partition.length;
            }
        }
        this.scanner.setPartialRange(this.document, offset, this.document.getLength(), contentType, offset);
        int lastScannedPosition = offset;
        IToken token = this.scanner.nextToken();
        while (!token.isEOF()) {
            contentType = this.getTokenContentType(token);
            if (!this.isSupportedContentType(contentType)) {
                token = this.scanner.nextToken();
                continue;
            }
            offset = this.scanner.getTokenOffset();
            int length = this.scanner.getTokenLength();
            lastScannedPosition = offset + length;
            while (first < category.length) {
                FlatNode p = category[first];
                if (p.offset + p.length >= lastScannedPosition && (!p.overlapsWith(offset, length) || this.containsPosition(offset, length) && contentType.equals(p.type))) break;
                this.removeInnerRegion(p);
                this.rememberRegion(p.offset, p.length);
                ++first;
            }
            if (this.containsPosition(offset, length)) {
                if (lastScannedPosition > event.getOffset()) {
                    return this.createRegion();
                }
                ++first;
            } else {
                this.addInnerRegion(this.createNode(contentType, offset, length));
                this.rememberRegion(offset, length);
            }
            token = this.scanner.nextToken();
        }
        while (first < category.length) {
            FlatNode p = category[first++];
            this.removeInnerRegion(p);
            this.rememberRegion(p.offset, p.length);
        }
        return this.createRegion();
    }

    protected int fixupPartitions(DocumentEvent event) {
        String text;
        int last;
        int offset = event.getOffset();
        int length = event.getLength();
        int end = offset + length;
        int first = this.computeFlatNodeIndex(offset);
        if (first > 0) {
            FlatNode p = (FlatNode)this.nodes.get(first - 1);
            int right = p.offset + p.length;
            if (offset < right) {
                if (end < right) {
                    String text2 = event.getText();
                    p.length -= length;
                    if (text2 != null) {
                        p.length += text2.length();
                    }
                } else {
                    int cut = p.offset + p.length - offset;
                    p.length -= cut;
                }
            }
        }
        if (first < (last = this.computeFlatNodeIndex(end))) {
            FlatNode p = (FlatNode)this.nodes.get(last - 1);
            int right = p.offset + p.length;
            if (end < right) {
                int cut = end - p.offset;
                p.length -= cut;
                p.offset = offset;
                String text3 = event.getText();
                if (text3 != null) {
                    p.offset += text3.length();
                }
                --last;
            }
        }
        if ((text = event.getText()) != null) {
            length -= text.length();
        }
        int i = last;
        int size = this.nodes.size();
        while (i < size) {
            ((FlatNode)this.nodes.get((int)i)).offset -= length;
            ++i;
        }
        if (first < last) {
            do {
                this.deleteInnerRegion((FlatNode)this.nodes.get(--last));
            } while (first < last);
            this.rememberRegion(offset, 0);
        }
        return first;
    }

    protected boolean isSupportedContentType(String contentType) {
        return contentType != null;
    }

    protected String getTokenContentType(IToken token) {
        Object data = token.getData();
        if (data instanceof String) {
            return (String)data;
        }
        return null;
    }

    public String[] getLegalContentTypes() {
        return null;
    }

    public String getContentType(int offset) {
        return this.getPartition(offset).getType();
    }

    public ITypedRegion getPartition(int offset) {
        if (this.nodes.size() == 0) {
            return new TypedRegion(0, this.document.getLength(), "__dftl_partition_content_type");
        }
        int index = this.computeFlatNodeIndex(offset);
        if (index < this.nodes.size()) {
            FlatNode next = (FlatNode)this.nodes.get(index);
            if (offset == next.offset) {
                return new TypedRegion(next.offset, next.length, next.type);
            }
            if (index == 0) {
                return new TypedRegion(0, next.offset, "__dftl_partition_content_type");
            }
            FlatNode prev = (FlatNode)this.nodes.get(index - 1);
            if (prev.includes(offset)) {
                return new TypedRegion(prev.offset, prev.length, prev.type);
            }
            int end = prev.offset + prev.length;
            return new TypedRegion(end, next.offset - end, "__dftl_partition_content_type");
        }
        FlatNode prev = (FlatNode)this.nodes.get(this.nodes.size() - 1);
        if (prev.includes(offset)) {
            return new TypedRegion(prev.offset, prev.length, prev.type);
        }
        int end = prev.offset + prev.length;
        return new TypedRegion(end, this.document.getLength() - end, "__dftl_partition_content_type");
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        ArrayList<TypedRegion> list = new ArrayList<TypedRegion>();
        int end = offset + length;
        int index = this.computeFlatNodeIndex(offset);
        while (true) {
            FlatNode next;
            FlatNode prev;
            FlatNode flatNode = prev = index > 0 ? (FlatNode)this.nodes.get(index - 1) : null;
            if (prev != null) {
                if (prev.overlapsWith(offset, length)) {
                    list.add(new TypedRegion(prev.offset, prev.length, prev.type));
                }
                if (end <= prev.offset + prev.length) break;
            }
            FlatNode flatNode2 = next = index < this.nodes.size() ? (FlatNode)this.nodes.get(index) : null;
            if (next == null || offset < next.offset) {
                int off0 = offset;
                int off1 = offset + length;
                if (prev != null && off0 < prev.offset + prev.length) {
                    off0 = prev.offset + prev.length;
                }
                if (next != null && next.offset < off1) {
                    off1 = next.offset;
                }
                if (off0 < off1) {
                    list.add(new TypedRegion(off0, off1 - off0, "__dftl_partition_content_type"));
                }
            }
            if (next == null) break;
            ++index;
        }
        return list.toArray(new TypedRegion[list.size()]);
    }

    protected int computeFlatNodeIndex(int offset) {
        if (this.nodes.size() == 0) {
            return 0;
        }
        int left = 0;
        int mid = 0;
        int right = this.nodes.size() - 1;
        FlatNode p = null;
        while (left < right) {
            mid = (left + right) / 2;
            p = (FlatNode)this.nodes.get(mid);
            if (offset < p.offset) {
                right = left == mid ? left : mid - 1;
                continue;
            }
            if (offset > p.offset) {
                left = right == mid ? right : mid + 1;
                continue;
            }
            if (offset != p.offset) continue;
            left = right = mid;
        }
        int pos = left;
        p = (FlatNode)this.nodes.get(pos);
        if (offset > p.offset) {
            ++pos;
        } else {
            while (--pos >= 0) {
                p = (FlatNode)this.nodes.get(pos);
                if (offset == p.offset) continue;
            }
            ++pos;
        }
        return pos;
    }

    public boolean containsPosition(int offset, int length) {
        int size = this.nodes.size();
        if (size == 0) {
            return false;
        }
        int index = this.computeFlatNodeIndex(offset);
        if (index < size) {
            FlatNode p = (FlatNode)this.nodes.get(index);
            while (p.offset == offset) {
                if (p.length == length) {
                    return true;
                }
                if (++index >= size) break;
                p = (FlatNode)this.nodes.get(index);
            }
        }
        return false;
    }

    protected final void rememberRegion(int offset, int length) {
        if (this.regionStart == -1) {
            this.regionStart = offset;
        } else if (offset < this.regionStart) {
            this.regionStart = offset;
        }
        int endOffset = offset + length;
        if (this.regionEnd == -1) {
            this.regionEnd = endOffset;
        } else if (endOffset > this.regionEnd) {
            this.regionEnd = endOffset;
        }
    }

    protected final IRegion createRegion() {
        if (this.regionStart == -1 || this.regionEnd == -1) {
            return null;
        }
        return new Region(this.regionStart, this.regionEnd - this.regionStart);
    }
}

