/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.text.rules;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.phpeclipse.ui.text.rules.AbstractPartitioner;
import net.sourceforge.phpeclipse.ui.text.rules.FlatNode;
import net.sourceforge.phpeclipse.ui.text.rules.IDocumentView;
import net.sourceforge.phpeclipse.ui.text.rules.InnerDocumentView;
import net.sourceforge.phpeclipse.ui.text.rules.OuterDocumentView;
import net.sourceforge.phpeclipse.ui.text.rules.ViewNode;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public abstract class MultiViewPartitioner
extends AbstractPartitioner {
    private ViewListener viewListener = new ViewListener();
    private OuterDocumentView outerDocument;
    private DocumentEvent outerDocumentEvent;

    public MultiViewPartitioner(IPartitionTokenScanner scanner) {
        super(scanner);
    }

    public void setOuterPartitioner(IDocumentPartitioner partitioner) {
        IDocumentPartitioner old;
        if (this.outerDocument == null) {
            if (partitioner == null) {
                return;
            }
            this.outerDocument = new OuterDocumentView(this.document, this.nodes);
            this.outerDocument.addDocumentPartitioningListener(this.viewListener);
        }
        if ((old = this.outerDocument.getDocumentPartitioner()) != null) {
            this.outerDocument.setDocumentPartitioner(null);
            old.disconnect();
        }
        if (partitioner != null) {
            partitioner.connect((IDocument)this.outerDocument);
        }
        this.outerDocument.setDocumentPartitioner(partitioner);
        if (partitioner == null) {
            this.outerDocument.removeDocumentPartitioningListener(this.viewListener);
            this.outerDocument = null;
        }
    }

    protected abstract IDocumentPartitioner createPartitioner(String var1);

    protected void addInnerRegion(FlatNode position) {
        IDocumentPartitioner partitioner;
        if (this.outerDocument != null) {
            int outerOffset = this.outerDocument.getLocalOffset(position.offset);
            DocumentEvent event = null;
            if (outerOffset >= 0) {
                event = new DocumentEvent((IDocument)this.outerDocument, outerOffset, position.length, null);
                this.outerDocument.fireDocumentAboutToBeChanged(event);
            }
            super.addInnerRegion(position);
            if (event != null) {
                this.outerDocument.fireDocumentChanged(event);
            }
        } else {
            super.addInnerRegion(position);
        }
        if (position instanceof ViewNode && (partitioner = this.createPartitioner(position.type)) != null) {
            InnerDocumentView innerDocument;
            ((ViewNode)position).view = innerDocument = new InnerDocumentView(this.document, (ViewNode)position);
            partitioner.connect((IDocument)innerDocument);
            innerDocument.setDocumentPartitioner(partitioner);
            innerDocument.addDocumentPartitioningListener(this.viewListener);
        }
    }

    protected void removeInnerRegion(FlatNode position) {
        try {
            InnerDocumentView innerDocument;
            if (this.outerDocument != null) {
                int outerOffset;
                DocumentEvent event = null;
                if (position.offset >= 0 && position.length >= 0 && (outerOffset = this.outerDocument.getLocalOffset(position.offset)) > 0) {
                    event = new DocumentEvent((IDocument)this.outerDocument, outerOffset, 0, this.document.get(position.offset, position.length));
                    this.outerDocument.fireDocumentAboutToBeChanged(event);
                }
                super.removeInnerRegion(position);
                if (position.offset >= 0 && event != null) {
                    this.outerDocument.fireDocumentChanged(event);
                }
            } else {
                super.removeInnerRegion(position);
            }
            if (position instanceof ViewNode && (innerDocument = ((ViewNode)position).view) != null) {
                IDocumentPartitioner partitioner = innerDocument.getDocumentPartitioner();
                innerDocument.removeDocumentPartitioningListener(this.viewListener);
                innerDocument.setDocumentPartitioner(null);
                partitioner.disconnect();
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void deleteInnerRegion(FlatNode position) {
        InnerDocumentView innerDocument;
        super.deleteInnerRegion(position);
        if (position instanceof ViewNode && (innerDocument = ((ViewNode)position).view) != null) {
            IDocumentPartitioner partitioner = innerDocument.getDocumentPartitioner();
            innerDocument.removeDocumentPartitioningListener(this.viewListener);
            innerDocument.setDocumentPartitioner(null);
            partitioner.disconnect();
        }
    }

    public void connect(IDocument document) {
        super.connect(document);
        this.setOuterPartitioner(this.createPartitioner(null));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() {
        try {
            if (this.outerDocument != null) {
                this.outerDocument.removeDocumentPartitioningListener(this.viewListener);
                IDocumentPartitioner partitioner = this.outerDocument.getDocumentPartitioner();
                this.outerDocument.setDocumentPartitioner(null);
                partitioner.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.outerDocument = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.outerDocument = null;
            return;
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        int right;
        FlatNode p;
        int last;
        InnerDocumentView innerDocument;
        super.documentAboutToBeChanged(event);
        this.outerDocumentEvent = null;
        int offset = event.getOffset();
        int length = event.getLength();
        int end = offset + length;
        int first = this.computeFlatNodeIndex(offset);
        if (first > 0) {
            FlatNode p2 = (FlatNode)this.nodes.get(first - 1);
            int right2 = p2.offset + p2.length;
            if (offset < right2) {
                innerDocument = null;
                if (p2 instanceof ViewNode) {
                    innerDocument = ((ViewNode)p2).view;
                }
                if (end < right2) {
                    if (innerDocument != null) {
                        int start = innerDocument.getLocalOffset(offset);
                        innerDocument.fireDocumentAboutToBeChanged(new DocumentEvent((IDocument)innerDocument, start, length, event.getText()));
                    }
                    return;
                }
                if (innerDocument != null) {
                    int start = innerDocument.getLocalOffset(offset);
                    innerDocument.fireDocumentAboutToBeChanged(new DocumentEvent((IDocument)innerDocument, start, innerDocument.getLength() - start, null));
                }
            }
        }
        if ((last = this.computeFlatNodeIndex(end)) > 0 && (p = (FlatNode)this.nodes.get(last - 1)) instanceof ViewNode && (innerDocument = ((ViewNode)p).view) != null && end < (right = p.offset + p.length)) {
            int cut = innerDocument.getLocalOffset(end);
            innerDocument.fireDocumentAboutToBeChanged(new DocumentEvent((IDocument)innerDocument, 0, cut, null));
        }
        if (this.outerDocument != null) {
            int left = this.outerDocument.getLocalOffset(offset);
            int right3 = this.outerDocument.getLocalOffset(end);
            String text = event.getText();
            if (left >= 0 && right3 - left >= 0 && (left != right3 || text != null && text.length() > 0)) {
                this.outerDocumentEvent = new DocumentEvent((IDocument)this.outerDocument, left, right3 - left, text);
                this.outerDocument.fireDocumentAboutToBeChanged(this.outerDocumentEvent);
            }
        }
    }

    protected int fixupPartitions(DocumentEvent event) {
        String text;
        int last;
        int offset = event.getOffset();
        int length = event.getLength();
        int end = offset + length;
        int first = this.computeFlatNodeIndex(offset);
        if (first > 0) {
            FlatNode p = (FlatNode)this.nodes.get(first - 1);
            int right = p.offset + p.length;
            if (offset < right) {
                int start;
                InnerDocumentView innerDocument;
                if (end < right) {
                    String text2 = event.getText();
                    p.length -= length;
                    if (text2 != null) {
                        p.length += text2.length();
                    }
                    if (p instanceof ViewNode && (innerDocument = ((ViewNode)p).view) != null) {
                        start = innerDocument.getLocalOffset(offset);
                        innerDocument.fireDocumentChanged(new DocumentEvent((IDocument)innerDocument, start, length, text2));
                    }
                } else {
                    int cut = p.offset + p.length - offset;
                    p.length -= cut;
                    if (p instanceof ViewNode && (innerDocument = ((ViewNode)p).view) != null) {
                        start = innerDocument.getLocalOffset(offset);
                        innerDocument.fireDocumentChanged(new DocumentEvent((IDocument)innerDocument, start, cut, null));
                    }
                }
            }
        }
        if ((last = this.computeFlatNodeIndex(end)) > 0 && first != last) {
            FlatNode p = (FlatNode)this.nodes.get(last - 1);
            int right = p.offset + p.length;
            if (end < right) {
                InnerDocumentView innerDocument;
                int cut = end - p.offset;
                p.length -= cut;
                p.offset = offset;
                String text3 = event.getText();
                if (text3 != null) {
                    p.offset += text3.length();
                }
                if (p instanceof ViewNode && (innerDocument = ((ViewNode)p).view) != null) {
                    innerDocument.fireDocumentChanged(new DocumentEvent((IDocument)innerDocument, 0, cut, null));
                }
                --last;
            }
        }
        if ((text = event.getText()) != null) {
            length -= text.length();
        }
        int i = last;
        int size = this.nodes.size();
        while (i < size) {
            ((FlatNode)this.nodes.get((int)i)).offset -= length;
            ++i;
        }
        if (first < last) {
            do {
                this.deleteInnerRegion((FlatNode)this.nodes.get(--last));
            } while (first < last);
            this.rememberRegion(offset, 0);
        }
        if (this.outerDocumentEvent != null) {
            this.outerDocument.fireDocumentChanged(this.outerDocumentEvent);
        }
        return first;
    }

    protected String getContentType(String parent, String view) {
        if (view != null) {
            return view;
        }
        if (parent != null) {
            return parent;
        }
        return "__dftl_partition_content_type";
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        ArrayList list = new ArrayList();
        int end = offset + length;
        int index = this.computeFlatNodeIndex(offset);
        while (true) {
            FlatNode next;
            FlatNode prev;
            FlatNode flatNode = prev = index > 0 ? (FlatNode)this.nodes.get(index - 1) : null;
            if (prev != null) {
                if (prev.overlapsWith(offset, length)) {
                    this.addInnerPartitions(list, offset, length, prev);
                }
                if (end <= prev.offset + prev.length) break;
            }
            FlatNode flatNode2 = next = index < this.nodes.size() ? (FlatNode)this.nodes.get(index) : null;
            if (next == null || offset < next.offset) {
                this.addOuterPartitions(list, offset, length, prev, next);
            }
            if (next == null) break;
            ++index;
        }
        return list.toArray(new TypedRegion[list.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private void showList(List list) {
        try {
            throw new NullPointerException();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(">>>>>List start");
            i = 0;
            ** while (i < list.size())
        }
lbl-1000:
        // 1 sources

        {
            temp = (TypedRegion)list.get(i);
            System.out.print("Offset: ");
            System.out.print(temp.getOffset());
            System.out.print(", Length: ");
            System.out.print(temp.getLength());
            System.out.print(", Type: ");
            System.out.print(temp.getType());
            System.out.println("");
            ++i;
            continue;
        }
lbl18:
        // 1 sources

        System.out.println("<<<<<List end");
    }

    private void addOuterPartitions(List list, int offset, int length, FlatNode prev, FlatNode next) {
        block11: {
            int start = offset;
            int end = offset + length;
            if (prev != null && start < prev.offset + prev.length) {
                start = prev.offset + prev.length;
            }
            if (next != null && next.offset < end) {
                end = next.offset;
            }
            if (start == end) {
                return;
            }
            if (this.outerDocument == null) {
                list.add(new TypedRegion(start, end - start, this.getContentType(null, "__dftl_partition_content_type")));
                return;
            }
            try {
                start = this.outerDocument.getLocalOffset(start);
                end = this.outerDocument.getLocalOffset(end);
                int len = end - start;
                if (len < 0) break block11;
                ITypedRegion[] regions = null;
                try {
                    regions = this.outerDocument.computePartitioning(start, len);
                }
                catch (Exception exception) {
                    regions = new ITypedRegion[]{};
                    System.out.println("MultiViewerPartitioner#addOuterPartitions failure\nstart:" + start + " length:" + len + "\n" + this.outerDocument.get(start, len));
                }
                int i = 0;
                while (i < regions.length) {
                    ITypedRegion region = regions[i];
                    start = this.outerDocument.getParentOffset(region.getOffset());
                    end = start + region.getLength();
                    if (prev != null && start < (offset = prev.offset + prev.length)) {
                        start = offset;
                    }
                    if (next != null && (offset = next.offset) < end) {
                        end = offset;
                    }
                    list.add(new TypedRegion(start, end - start, this.getContentType(null, region.getType())));
                    ++i;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private void addInnerPartitions(List list, int offset, int length, FlatNode position) {
        InnerDocumentView innerDocument = null;
        if (position instanceof ViewNode) {
            innerDocument = ((ViewNode)position).view;
        }
        if (innerDocument == null) {
            list.add(new TypedRegion(position.offset, position.length, this.getContentType(position.type, null)));
            return;
        }
        try {
            int start = Math.max(offset, position.offset);
            int end = Math.min(offset + length, position.offset + position.length);
            length = end - start;
            offset = innerDocument.getLocalOffset(start);
            ITypedRegion[] regions = innerDocument.computePartitioning(offset, length);
            int i = 0;
            while (i < regions.length) {
                ITypedRegion region = regions[i];
                offset = innerDocument.getParentOffset(region.getOffset());
                length = region.getLength();
                list.add(new TypedRegion(offset, length, this.getContentType(position.type, region.getType())));
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public ITypedRegion getPartition(int offset) {
        if (this.nodes.size() == 0) {
            return this.getOuterPartition(offset, null, null);
        }
        int index = this.computeFlatNodeIndex(offset);
        if (index < this.nodes.size()) {
            FlatNode next = (FlatNode)this.nodes.get(index);
            if (offset == next.offset) {
                return this.getInnerPartition(offset, next);
            }
            if (index == 0) {
                return this.getOuterPartition(offset, null, next);
            }
            FlatNode prev = (FlatNode)this.nodes.get(index - 1);
            if (prev.includes(offset)) {
                return this.getInnerPartition(offset, prev);
            }
            return this.getOuterPartition(offset, prev, next);
        }
        FlatNode prev = (FlatNode)this.nodes.get(this.nodes.size() - 1);
        if (prev.includes(offset)) {
            return this.getInnerPartition(offset, prev);
        }
        return this.getOuterPartition(offset, prev, null);
    }

    protected ITypedRegion getOuterPartition(int offset, FlatNode prev, FlatNode next) {
        try {
            String type;
            int end;
            int start;
            if (this.outerDocument == null) {
                start = 0;
                end = this.document.getLength();
                type = this.getContentType(null, "__dftl_partition_content_type");
            } else {
                int outerOffset = this.outerDocument.getLocalOffset(offset);
                if (outerOffset < 0) {
                    start = 0;
                    end = this.document.getLength();
                    type = this.getContentType(null, "__dftl_partition_content_type");
                } else {
                    ITypedRegion region = this.outerDocument.getPartition(outerOffset);
                    start = region.getOffset();
                    end = start + region.getLength();
                    start = this.outerDocument.getParentOffset(start);
                    end = this.outerDocument.getParentOffset(end);
                    type = this.getContentType(null, region.getType());
                }
            }
            if (prev != null && start < (offset = prev.offset + prev.length)) {
                start = offset;
            }
            if (next != null && (offset = next.offset) < end) {
                end = offset;
            }
            return new TypedRegion(start, end - start, type);
        }
        catch (BadLocationException x) {
            x.printStackTrace();
            throw new IllegalArgumentException();
        }
    }

    protected ITypedRegion getInnerPartition(int offset, FlatNode position) {
        InnerDocumentView innerDocument;
        if (position instanceof ViewNode && (innerDocument = ((ViewNode)position).view) != null) {
            try {
                ITypedRegion region = innerDocument.getPartition(innerDocument.getLocalOffset(offset));
                offset = innerDocument.getParentOffset(region.getOffset());
                return new TypedRegion(offset, region.getLength(), this.getContentType(position.type, region.getType()));
            }
            catch (BadLocationException badLocationException) {}
        }
        return new TypedRegion(position.offset, position.length, position.type);
    }

    class ViewListener
    implements IDocumentPartitioningListener,
    IDocumentPartitioningListenerExtension {
        ViewListener() {
        }

        public void documentPartitioningChanged(IDocument document) {
            IDocumentView view = (IDocumentView)document;
            int start = view.getParentOffset(0);
            int end = view.getParentOffset(view.getLength());
            MultiViewPartitioner.this.rememberRegion(start, end - start);
        }

        public void documentPartitioningChanged(IDocument document, IRegion region) {
            IDocumentView view = (IDocumentView)document;
            int offset = region.getOffset();
            int start = view.getParentOffset(offset);
            int end = view.getParentOffset(offset + region.getLength());
            MultiViewPartitioner.this.rememberRegion(start, end - start);
        }
    }
}

