/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.text.source;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class DefaultSourceViewerConfiguration
extends SourceViewerConfiguration {
    public static final String PREFERENCE_TAB_WIDTH = "net.sourceforge.phpeclipse.ui.editor.tabWidth";
    public static final String PREFERENCE_SPACES_FOR_TABS = "net.sourceforge.phpeclipse.ui.editor.spacesForTabs";
    private IPreferenceStore store;

    public DefaultSourceViewerConfiguration(IPreferenceStore store) {
        this.store = store;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        int tabWidth = this.store.getInt(PREFERENCE_TAB_WIDTH);
        boolean useSpaces = this.store.getBoolean(PREFERENCE_SPACES_FOR_TABS);
        String[] prefixes = new String[tabWidth + 1];
        int i = 0;
        while (i <= tabWidth) {
            int j;
            StringBuffer prefix = new StringBuffer(tabWidth - 1);
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            prefixes[i] = prefix.toString();
            ++i;
        }
        prefixes[tabWidth] = "";
        return prefixes;
    }
}

