/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.views.outline;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.phpeclipse.core.model.ISourceReference;
import net.sourceforge.phpeclipse.ui.WebUI;
import net.sourceforge.phpeclipse.ui.views.util.ImageDescriptorRegistry;
import net.sourceforge.phpeclipse.ui.views.util.ImageImageDescriptor;
import net.sourceforge.phpeclipse.ui.views.util.OverlayImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class ProblemsLabelDecorator
extends LabelProvider
implements ILabelDecorator {
    private static final String ANNOTATION_TYPE_ERROR = "org.eclipse.ui.workbench.texteditor.error";
    private static final String ANNOTATION_TYPE_WARNING = "org.eclipse.ui.workbench.texteditor.warning";
    private ITextEditor editor;
    private ImageDescriptorRegistry registry = new ImageDescriptorRegistry();

    public ProblemsLabelDecorator(ITextEditor editor) {
        this.editor = editor;
    }

    public void dispose() {
        super.dispose();
        this.registry.dispose();
    }

    public Image decorateImage(Image image, Object element) {
        Annotation[] annotations = this.getAssociatedAnnotations((ISourceReference)element);
        ImageDescriptor overlay = null;
        int i = 0;
        while (i < annotations.length) {
            if (this.isError(annotations[i])) {
                overlay = WebUI.getDefault().getImageRegistry().getDescriptor("full/ovr16/error_co.gif");
            } else if (this.isWarning(annotations[i])) {
                overlay = WebUI.getDefault().getImageRegistry().getDescriptor("full/ovr16/warning_co.gif");
            }
            ++i;
        }
        if (overlay != null) {
            ImageImageDescriptor base = new ImageImageDescriptor(image);
            ImageDescriptor[][] imageDescriptorArrayArray = new ImageDescriptor[4][];
            imageDescriptorArrayArray[2] = new ImageDescriptor[]{overlay};
            return this.registry.get((ImageDescriptor)new OverlayImageDescriptor(base, imageDescriptorArrayArray, null));
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    private Annotation[] getAssociatedAnnotations(ISourceReference element) {
        ArrayList<Annotation> retVal = new ArrayList<Annotation>();
        if (this.editor != null) {
            IEditorInput input = this.editor.getEditorInput();
            IAnnotationModel model = this.editor.getDocumentProvider().getAnnotationModel((Object)input);
            if (model != null) {
                Iterator i = model.getAnnotationIterator();
                while (i.hasNext()) {
                    Annotation annotation = (Annotation)i.next();
                    Position pos = model.getPosition(annotation);
                    if (pos == null || !this.isInside(pos.getOffset(), element)) continue;
                    retVal.add(annotation);
                }
            }
        }
        return retVal.toArray(new Annotation[retVal.size()]);
    }

    private boolean isError(Annotation annotation) {
        return ANNOTATION_TYPE_ERROR.equals(annotation.getType());
    }

    private boolean isWarning(Annotation annotation) {
        return ANNOTATION_TYPE_WARNING.equals(annotation.getType());
    }

    private boolean isInside(int pos, ISourceReference element) {
        IRegion region = element.getSourceRegion();
        if (region != null) {
            int offset = region.getOffset();
            return offset <= pos && offset + region.getLength() > pos;
        }
        return false;
    }
}

