/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.ui.launcher;

import net.sourceforge.phpdt.debug.ui.PHPDebugUiConstants;
import net.sourceforge.phpdt.debug.ui.PHPDebugUiImages;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiMessages;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiPlugin;
import net.sourceforge.phpdt.internal.ui.util.DirectorySelector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PHPArgumentsTab
extends AbstractLaunchConfigurationTab {
    protected Text interpreterArgsText;
    protected Text programArgsText;
    protected DirectorySelector workingDirectorySelector;
    protected Button useDefaultWorkingDirectoryButton;
    private ArgumentsTabListener fListener = new ArgumentsTabListener();

    public void createControl(Composite parent) {
        Composite composite = this.createPageRoot(parent);
        Group grpWorkingDir = new Group(composite, 0);
        grpWorkingDir.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPArguments.working_dir"));
        grpWorkingDir.setLayoutData((Object)new GridData(768));
        grpWorkingDir.setLayout((Layout)new GridLayout());
        this.workingDirectorySelector = new DirectorySelector((Composite)grpWorkingDir);
        this.workingDirectorySelector.setBrowseDialogMessage(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPArguments.working_dir_browser_message"));
        this.workingDirectorySelector.setLayoutData((Object)new GridData(768));
        this.workingDirectorySelector.addModifyListener((ModifyListener)this.fListener);
        Composite defaultWorkingDirectoryComposite = new Composite((Composite)grpWorkingDir, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        defaultWorkingDirectoryComposite.setLayout((Layout)layout);
        this.useDefaultWorkingDirectoryButton = new Button(defaultWorkingDirectoryComposite, 32);
        this.useDefaultWorkingDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPArgumentsTab.this.setUseDefaultWorkingDirectory(((Button)e.getSource()).getSelection());
            }
        });
        this.useDefaultWorkingDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        new Label(defaultWorkingDirectoryComposite, 0).setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPArguments.working_dir_use_default_message"));
        defaultWorkingDirectoryComposite.pack();
        this.workingDirectorySelector.addModifyListener((ModifyListener)this.fListener);
        Group grpArgs = new Group(composite, 0);
        grpArgs.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPArguments.interpreter_args_box_title"));
        grpArgs.setLayoutData((Object)new GridData(1808));
        grpArgs.setLayout((Layout)new GridLayout());
        this.interpreterArgsText = new Text((Composite)grpArgs, 2626);
        this.interpreterArgsText.setLayoutData((Object)new GridData(1808));
        this.interpreterArgsText.addModifyListener((ModifyListener)this.fListener);
        Group grpProgArgs = new Group(composite, 0);
        grpProgArgs.setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPArguments.program_args_box_title"));
        grpProgArgs.setLayoutData((Object)new GridData(1808));
        grpProgArgs.setLayout((Layout)new GridLayout());
        this.programArgsText = new Text((Composite)grpProgArgs, 2626);
        this.programArgsText.setLayoutData((Object)new GridData(1808));
        this.programArgsText.addModifyListener((ModifyListener)this.fListener);
    }

    protected void setUseDefaultWorkingDirectory(boolean useDefault) {
        if (!this.useDefaultWorkingDirectoryButton.getSelection() == useDefault) {
            this.useDefaultWorkingDirectoryButton.setSelection(useDefault);
        }
        if (useDefault) {
            this.workingDirectorySelector.setSelectionText(PHPDebugUiConstants.DEFAULT_WORKING_DIRECTORY);
        }
        this.workingDirectorySelector.setEnabled(!useDefault);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.WORKING_DIRECTORY", PHPDebugUiConstants.DEFAULT_WORKING_DIRECTORY);
        configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "net.sourceforge.phpdt.debug.ui.PHPSourceLocator");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String workingDirectory = "";
        String interpreterArgs = "";
        String programArgs = "";
        boolean useDefaultWorkDir = true;
        try {
            workingDirectory = configuration.getAttribute("net.sourceforge.phpeclipse.launching.WORKING_DIRECTORY", "");
            interpreterArgs = configuration.getAttribute("net.sourceforge.phpeclipse.launching.INTERPRETER_ARGUMENTS", "");
            programArgs = configuration.getAttribute("net.sourceforge.phpeclipse.launching.PROGRAM_ARGUMENTS", "");
            useDefaultWorkDir = configuration.getAttribute("net.sourceforge.phpeclipse.launching.USE_DEFAULT_WORKING_DIRECTORY", true);
        }
        catch (CoreException e) {
            this.log(e);
        }
        this.workingDirectorySelector.setSelectionText(workingDirectory);
        this.interpreterArgsText.setText(interpreterArgs);
        this.programArgsText.setText(programArgs);
        this.setUseDefaultWorkingDirectory(useDefaultWorkDir);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.WORKING_DIRECTORY", this.workingDirectorySelector.getValidatedSelectionText());
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.INTERPRETER_ARGUMENTS", this.interpreterArgsText.getText());
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.PROGRAM_ARGUMENTS", this.programArgsText.getText());
        configuration.setAttribute("net.sourceforge.phpeclipse.launching.USE_DEFAULT_WORKING_DIRECTORY", this.useDefaultWorkingDirectoryButton.getSelection());
    }

    protected Composite createPageRoot(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        composite.setLayout((Layout)compositeLayout);
        this.setControl((Control)composite);
        return composite;
    }

    public String getName() {
        return PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPArguments.name");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            String workingDirectory = launchConfig.getAttribute("net.sourceforge.phpeclipse.launching.WORKING_DIRECTORY", "");
            if (workingDirectory.length() == 0) {
                this.setErrorMessage(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPArguments.working_dir_error_message"));
                return false;
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void log(Throwable t) {
        PHPDebugUiPlugin.log(t);
    }

    public Image getImage() {
        return PHPDebugUiImages.get("net.sourceforge.phpdt.debug.ui.arguments_tab.gif");
    }

    private class ArgumentsTabListener
    extends SelectionAdapter
    implements ModifyListener {
        private ArgumentsTabListener() {
        }

        public void modifyText(ModifyEvent e) {
            PHPArgumentsTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            PHPArgumentsTab.this.updateLaunchConfigurationDialog();
        }
    }
}

