/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.ui.launcher;

import java.util.ArrayList;
import net.sourceforge.phpdt.debug.ui.PHPDebugUiConstants;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiMessages;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiPlugin;
import net.sourceforge.phpdt.internal.ui.util.PHPFileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class PHPLaunchShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void launch(ISelection selection, String mode) {
        Object firstSelection;
        if (selection instanceof IStructuredSelection && (firstSelection = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile && PHPFileUtil.isPHPFile((IFile)((IFile)firstSelection))) {
            ILaunchConfiguration config = this.findLaunchConfiguration((IFile)firstSelection, mode);
            try {
                if (config != null) {
                    config.launch(mode, null);
                }
            }
            catch (CoreException e) {
                this.log(e);
            }
            return;
        }
        this.log("The resource selected is not a PHP file.");
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StructuredSelection selection = new StructuredSelection(input.getAdapter((Class)clazz));
        this.launch((ISelection)selection, mode);
    }

    protected ILaunchConfiguration findLaunchConfiguration(IFile phpFile, String mode) {
        ILaunchConfigurationType configType = this.getPHPLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = null;
        try {
            ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute("net.sourceforge.phpeclipse.launching.FILE_NAME", "").equals(phpFile.getFullPath().toString())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
        switch (candidateConfigs.size()) {
            case 0: {
                return this.createConfiguration(phpFile);
            }
            case 1: {
                return (ILaunchConfiguration)candidateConfigs.get(0);
            }
        }
        this.log(new RuntimeException(PHPDebugUiMessages.getString("LaunchConfigurationShortcut.PHP.multipleConfigurationsError")));
        return null;
    }

    protected ILaunchConfiguration createConfiguration(IFile phpFile) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getPHPLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(phpFile.getName()));
            wc.setAttribute("net.sourceforge.phpeclipse.launching.PROJECT_NAME", phpFile.getProject().getName());
            wc.setAttribute("net.sourceforge.phpeclipse.launching.FILE_NAME", phpFile.getProjectRelativePath().toString());
            wc.setAttribute("net.sourceforge.phpeclipse.launching.WORKING_DIRECTORY", PHPDebugUiConstants.DEFAULT_WORKING_DIRECTORY);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            this.log(ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getPHPLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("net.sourceforge.phpdt.launching.LaunchConfigurationTypePHPApplication");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void log(String message) {
        PHPDebugUiPlugin.log((IStatus)new Status(1, "net.sourceforge.phpeclipse.debug.ui", 1, message, null));
    }

    protected void log(Throwable t) {
        PHPDebugUiPlugin.log(t);
    }
}

