/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.httpquery.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpdt.httpquery.config.IConfiguration;
import net.sourceforge.phpdt.httpquery.config.IConfigurationWorkingCopy;
import net.sourceforge.phpdt.httpquery.preferences.ConfigurationContentProvider;
import net.sourceforge.phpdt.httpquery.preferences.ConfigurationDialog;
import net.sourceforge.phpdt.httpquery.preferences.ConfigurationTableLabelProvider;
import net.sourceforge.phpdt.httpquery.preferences.SWTUtil;
import net.sourceforge.phpdt.phphelp.PHPHelpPlugin;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ConfigurationComposite
extends Composite {
    protected Table table;
    protected TableViewer tableViewer;
    protected Button edit;
    protected Button remove;
    protected List selection2;

    public ConfigurationComposite(Composite parent, int style) {
        super(parent, style);
        this.createWidgets();
    }

    protected void createWidgets() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 6;
        layout.verticalSpacing = 6;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.setLayoutData(data);
        Label label = new Label((Composite)this, 64);
        label.setText(PHPHelpPlugin.getResource("%configurationsList"));
        label.setLayoutData((Object)new GridData(772));
        label = new Label((Composite)this, 0);
        this.table = new Table((Composite)this, 68354);
        data = new GridData(784);
        data.widthHint = 300;
        data.heightHint = 300;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        TableColumn statusColumn = new TableColumn(this.table, 0);
        statusColumn.setText(PHPHelpPlugin.getResource("%columnName"));
        ColumnWeightData colData = new ColumnWeightData(5, 30, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        TableColumn typeColumn = new TableColumn(this.table, 0);
        typeColumn.setText(PHPHelpPlugin.getResource("%columnType"));
        colData = new ColumnWeightData(5, 30, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        TableColumn localColumn = new TableColumn(this.table, 0);
        localColumn.setText(PHPHelpPlugin.getResource("%columnURL"));
        colData = new ColumnWeightData(5, 150, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        this.table.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ConfigurationContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationTableLabelProvider());
        this.tableViewer.setInput((Object)"root");
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigurationComposite.this.setSelection(event.getSelection());
            }
        });
        Composite buttonComp = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 8;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttonComp.setLayout((Layout)layout);
        data = new GridData(144);
        buttonComp.setLayoutData((Object)data);
        Button add = SWTUtil.createButton(buttonComp, PHPHelpPlugin.getResource("%add"));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationDialog dialog = new ConfigurationDialog(ConfigurationComposite.this.getShell());
                if (dialog.open() == 1) {
                    return;
                }
                ConfigurationComposite.this.tableViewer.refresh();
                List list = PHPHelpPlugin.getConfigurations();
                Object configuration = list.get(list.size() - 1);
                ConfigurationComposite.this.tableViewer.setSelection((ISelection)new StructuredSelection(configuration));
            }
        });
        this.edit = SWTUtil.createButton(buttonComp, PHPHelpPlugin.getResource("%edit"));
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConfiguration monitor = (IConfiguration)ConfigurationComposite.this.getSelection().get(0);
                IConfigurationWorkingCopy wc = monitor.getWorkingCopy();
                ConfigurationDialog dialog = new ConfigurationDialog(ConfigurationComposite.this.getShell(), wc);
                if (dialog.open() != 1) {
                    try {
                        ConfigurationComposite.this.tableViewer.refresh((Object)wc.save());
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this.edit.setEnabled(false);
        this.remove = SWTUtil.createButton(buttonComp, PHPHelpPlugin.getResource("%remove"));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator iterator = ConfigurationComposite.this.getSelection().iterator();
                while (iterator.hasNext()) {
                    IConfiguration monitor = (IConfiguration)iterator.next();
                    try {
                        monitor.delete();
                    }
                    catch (Exception exception) {}
                    ConfigurationComposite.this.tableViewer.remove((Object)monitor);
                    List list = PHPHelpPlugin.getConfigurations();
                    Object monitor2 = list.get(list.size() - 1);
                    ConfigurationComposite.this.tableViewer.setSelection((ISelection)new StructuredSelection(monitor2));
                }
            }
        });
        this.remove.setEnabled(false);
    }

    protected List getSelection() {
        return this.selection2;
    }

    protected void setSelection(ISelection sel2) {
        IStructuredSelection sel = (IStructuredSelection)sel2;
        Iterator iterator = sel.iterator();
        this.selection2 = new ArrayList();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof IConfiguration)) continue;
            this.selection2.add(obj);
        }
        if (!this.selection2.isEmpty()) {
            this.remove.setEnabled(true);
            this.edit.setEnabled(true);
        } else {
            this.edit.setEnabled(false);
            this.remove.setEnabled(false);
        }
    }
}

