/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.core.xdebug;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import net.sourceforge.phpeclipse.xdebug.core.Base64;
import net.sourceforge.phpeclipse.xdebug.core.PHPDebugUtils;
import net.sourceforge.phpeclipse.xdebug.core.XDebugCorePlugin;

public class XDebugConnection {
    private int fTransactionID;
    private Socket fDebugSocket;
    private OutputStreamWriter fDebugWriter;
    private DataInputStream fDebugReader;
    private boolean fInitialized;
    private boolean fIsClosed;
    private String fSessionID;

    public String getSessionID() {
        return this.fSessionID;
    }

    public boolean isInitialized() {
        return this.fInitialized;
    }

    public boolean isClosed() {
        return this.fIsClosed;
    }

    public XDebugConnection(Socket debugSocket) {
        this.fDebugSocket = debugSocket;
        this.fTransactionID = 0;
        this.fInitialized = false;
        try {
            this.fDebugWriter = new OutputStreamWriter(debugSocket.getOutputStream(), "UTF8");
            this.fDebugReader = new DataInputStream(debugSocket.getInputStream());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fIsClosed = false;
        String initString = this.readData();
        XDebugCorePlugin.log(1, initString);
        int startIdx = initString.indexOf("idekey=\"");
        if (startIdx == -1) {
            return;
        }
        int endIdx = initString.indexOf(34, startIdx += 8);
        if (endIdx == -1) {
            return;
        }
        this.fSessionID = initString.substring(startIdx, endIdx);
        this.fInitialized = true;
    }

    protected String readData() {
        if (this.fIsClosed) {
            return null;
        }
        byte[] byteBuffer = null;
        int count = 0;
        try {
            byte b;
            while ((b = this.fDebugReader.readByte()) != 0) {
                count = count * 10 + b - 48;
            }
            byteBuffer = new byte[count];
            int readCount = 0;
            int attempts = 0;
            while (count > 0 && attempts < 5) {
                int rc = this.fDebugReader.read(byteBuffer, readCount, count);
                readCount += rc;
                if ((count -= rc) > 65530) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                ++attempts;
            }
            this.fDebugReader.readFully(byteBuffer, readCount, count);
            b = this.fDebugReader.readByte();
            if (b != 0) {
                System.out.println("NULL-Byte missing!!");
            }
        }
        catch (IOException e) {
            if (!(e instanceof EOFException) && !this.fIsClosed) {
                e.printStackTrace();
            }
            return null;
        }
        return new String(byteBuffer);
    }

    private int sendRequest(String command, String arguments) {
        return this._sendRequest(command, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int _sendRequest(String command, String arguments) {
        if (this.fDebugSocket == null) {
            return 0;
        }
        XDebugCorePlugin.log(1, String.valueOf(command) + " -i " + this.fTransactionID + " " + arguments);
        Socket socket = this.fDebugSocket;
        synchronized (socket) {
            try {
                this.fDebugWriter.write(command);
                this.fDebugWriter.write(" -i " + this.fTransactionID);
                if (!"".equals(arguments)) {
                    this.fDebugWriter.write(" " + arguments);
                }
                this.fDebugWriter.write(0);
                this.fDebugWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.fTransactionID++;
    }

    public int eval(String Expression) {
        String encoded = Base64.encodeBytes(Expression.getBytes());
        return this.sendRequest("eval", "-- " + encoded);
    }

    public int featureGet(String featureName) {
        return this.sendRequest("feature_get", "-n " + featureName);
    }

    public int featureSet(String featureName, String value) {
        return this.sendRequest("feature_set", "-n " + featureName + " -v " + value);
    }

    public int breakpointSetOld(String file, int lineNumber) {
        String arg = "-t line -f file://" + PHPDebugUtils.escapeString(file) + " -n " + lineNumber;
        return this.sendRequest("breakpoint_set", arg);
    }

    public int breakpointSet(String file, int lineNumber, int hitCount) {
        String arg = "-t line -f file://" + PHPDebugUtils.escapeString(file) + " -n " + lineNumber;
        if (hitCount > 0) {
            arg = String.valueOf(arg) + " -h " + hitCount;
        }
        return this.sendRequest("breakpoint_set", arg);
    }

    public int breakpointGet(int id) {
        String arg = "-d " + id;
        return this.sendRequest("breakpoint_get", arg);
    }

    public int breakpointRemove(int id) {
        return this.sendRequest("breakpoint_set", "-d " + id);
    }

    public int stackGet() {
        return this.sendRequest("stack_get", "");
    }

    public void stepOver() {
        this.sendRequest("step_over", "");
    }

    public void stepInto() {
        this.sendRequest("step_into", "");
    }

    public void stepOut() {
        this.sendRequest("step_out", "");
    }

    public void run() {
        this.sendRequest("run", "");
    }

    public void stop() {
        this.sendRequest("stop", "");
    }

    public int propertySet(String Name, String Value) {
        String str = Base64.encodeBytes(Value.getBytes());
        int len = str.length();
        return this.sendRequest("property_set", "-n " + Name + " -d 0 -l " + len + " -- " + str);
    }

    public int contextGet(int Level2, int Type2) {
        return this.sendRequest("context_get", "-d " + Level2 + " -c " + Type2);
    }

    public int setVarValue(String Name, String Value) {
        return this.propertySet(Name, Value);
    }

    public void close() {
        if (!this.fIsClosed) {
            this.fIsClosed = true;
            try {
                this.fDebugSocket.close();
                this.fDebugReader.close();
                this.fDebugWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

