/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.php.model;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.EmptyStatement;
import net.sourceforge.phpdt.internal.compiler.ast.MethodDeclaration;
import net.sourceforge.phpdt.internal.core.CompilationUnit;

public class ValidBreakpointLocationLocator
extends ASTVisitor {
    public static final int LOCATION_NOT_FOUND = 0;
    public static final int LOCATION_LINE = 1;
    public static final int LOCATION_METHOD = 2;
    public static final int LOCATION_FIELD = 3;
    private CompilationUnit fCompilationUnit;
    private int fLineNumber;
    private boolean fBindingsResolved;
    private boolean fNeedBindings = false;
    private boolean fBestMatch;
    private int fLocationType;
    private boolean fLocationFound;
    private String fTypeName;
    private int fLineLocation;
    private int fMemberOffset;
    private List fLabels;

    public ValidBreakpointLocationLocator(CompilationUnit compilationUnit, int lineNumber, boolean bindingsResolved, boolean bestMatch) {
        this.fCompilationUnit = compilationUnit;
        this.fLineNumber = lineNumber;
        this.fBindingsResolved = bindingsResolved;
        this.fBestMatch = bestMatch;
        this.fLocationFound = false;
    }

    public boolean isBindingsRequired() {
        return this.fNeedBindings;
    }

    public int getLocationType() {
        return this.fLocationType;
    }

    public String getFullyQualifiedTypeName() {
        return this.fTypeName;
    }

    public int getLineLocation() {
        if (this.fLocationType == 1) {
            return this.fLineLocation;
        }
        return -1;
    }

    public int getMemberOffset() {
        return this.fMemberOffset;
    }

    public boolean visit(EmptyStatement node) {
        return false;
    }

    private String getLabel() {
        if (this.fLabels == null || this.fLabels.isEmpty()) {
            return null;
        }
        return (String)this.fLabels.get(this.fLabels.size() - 1);
    }

    private void nestLabel(String label) {
        if (this.fLabels == null) {
            this.fLabels = new ArrayList();
        }
        this.fLabels.add(label);
    }

    private void popLabel() {
        if (this.fLabels == null || this.fLabels.isEmpty()) {
            return;
        }
        this.fLabels.remove(this.fLabels.size() - 1);
    }

    public boolean visit(MethodDeclaration node) {
        int nameOffset;
        if (this.visit(node) && this.fBestMatch && this.lineNumber(nameOffset = node.sourceStart) == this.fLineNumber) {
            this.fMemberOffset = nameOffset;
            this.fLocationType = 2;
            this.fLocationFound = true;
            return false;
        }
        return false;
    }

    private int lineNumber(int offset) {
        return 10;
    }
}

