/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.php.model;

import net.sourceforge.phpeclipse.xdebug.core.PHPDebugUtils;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugElement;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugStackFrame;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.w3c.dom.Node;

public class XDebugAbstractValue
extends XDebugElement
implements IValue {
    private IVariable[] fVariables;
    private String fValueString;
    private String fTypeName;
    private boolean fhasChanged;
    protected String rowValue;

    public XDebugAbstractValue(XDebugStackFrame frame, Node value) throws DebugException {
        super(frame == null ? null : (XDebugTarget)frame.getDebugTarget());
        this.fTypeName = PHPDebugUtils.getAttributeValue(value, "type");
        this.fVariables = new IVariable[0];
        this.rowValue = "";
        try {
            this.rowValue = value.getFirstChild().getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            this.rowValue = "";
        }
    }

    public boolean hasChanged() {
        return this.fhasChanged;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fTypeName;
    }

    public String getValueString() throws DebugException {
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        return this.fVariables.length > 0;
    }

    public boolean setValue(String expression) throws DebugException {
        return true;
    }

    protected boolean verifyValue(String expression) {
        return true;
    }

    protected boolean supportsValueModification() {
        return false;
    }

    protected void setValueString(String valueString) {
        this.fValueString = valueString;
    }

    protected void setChildren(IVariable[] newChildren) {
        this.fVariables = newChildren;
    }
}

