/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpmanual.views;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.phpdt.internal.ui.text.JavaWordFinder;
import net.sourceforge.phpdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import net.sourceforge.phpdt.internal.ui.viewsupport.SelectionListenerWithASTManager;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import net.sourceforge.phpeclipse.phpmanual.PHPManualUIPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.tags.Div;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.htmlparser.visitors.TagFindingVisitor;
import org.osgi.framework.Bundle;

public class PHPManualView
extends ViewPart
implements INullSelectionListener,
ISelectionListenerWithAST {
    private Browser browser;
    private PHPEditor lastEditor;
    private String lastOccurrence = null;
    private final Path docPath = new Path("doc.zip");

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                String loc = event.location.toString();
                if (!loc.equalsIgnoreCase("about:blank") && !loc.startsWith("jar:")) {
                    String func = loc.replaceAll("file:///", "");
                    func = func.replaceAll("#.+$", "");
                    String[] afunc = loc.split("\\.");
                    if (!afunc[1].equalsIgnoreCase(PHPManualView.this.lastOccurrence)) {
                        PHPManualView.this.lastOccurrence = afunc[1];
                        PHPManualView.this.showReference(func);
                        event.doit = false;
                    }
                }
            }
        });
        parent.pack();
        this.lastEditor = this.getJavaEditor();
        if (this.lastEditor != null) {
            SelectionListenerWithASTManager.getDefault().addListener((ITextEditor)this.lastEditor, (ISelectionListenerWithAST)this);
        }
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener("net.sourceforge.phpeclipse.PHPUnitEditor", (ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener("net.sourceforge.phpeclipse.PHPUnitEditor", (ISelectionListener)this);
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void selectionChanged(IEditorPart part, ITextSelection selection) {
        IDocument document = ((PHPEditor)part).getViewer().getDocument();
        int offset = selection.getOffset();
        IRegion iRegion = JavaWordFinder.findWord((IDocument)document, (int)offset);
        if (document != null && iRegion != null) {
            try {
                String wordStr = document.get(iRegion.getOffset(), iRegion.getLength());
                if (!wordStr.equalsIgnoreCase(this.lastOccurrence)) {
                    this.showReference(wordStr);
                    this.lastOccurrence = wordStr;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != null && !((PHPEditor)part).equals(this.lastEditor)) {
            SelectionListenerWithASTManager.getDefault().addListener((ITextEditor)((PHPEditor)part), (ISelectionListenerWithAST)this);
            this.lastEditor = (PHPEditor)part;
        }
    }

    private void showReference(final String funcName) {
        new Thread(new Runnable(){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(this, funcName){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ String val$funcName;
                    {
                        this.this$1 = var1_1;
                        this.val$funcName = string;
                    }

                    public void run() {
                        String html = 2.access$0(this.this$1).getHtmlSource(this.val$funcName);
                        PHPManualView.access$3(2.access$0(this.this$1)).setText(html);
                    }
                });
            }

            static /* synthetic */ PHPManualView access$0(2 var0) {
                return var0.PHPManualView.this;
            }
        }).start();
    }

    private String filterHtmlSource(String source) {
        try {
            Parser parser = new Parser(source);
            String[] tagsToBeFound = new String[]{"DIV"};
            ArrayList<String> classList = new ArrayList<String>(Arrays.asList("section", "sect1", "title", "partintro", "refnamediv", "refsect1 description", "refsect1 parameters", "refsect1 returnvalues", "refsect1 examples", "refsect1 seealso", "refsect1 u", "example-contents"));
            TagFindingVisitor visitor = new TagFindingVisitor(tagsToBeFound);
            parser.visitAllNodesWith((NodeVisitor)visitor);
            Node[] allPTags = visitor.getTags(0);
            StringBuffer output = new StringBuffer();
            int i = 0;
            while (i < allPTags.length) {
                String tagClass = ((Div)allPTags[i]).getAttribute("class");
                if (classList.contains(tagClass)) {
                    output.append(allPTags[i].toHtml());
                }
                ++i;
            }
            return output.toString().replaceAll("\u2014", "-");
        }
        catch (ParserException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRefPageTemplate() {
        Bundle bundle = Platform.getBundle((String)"net.sourceforge.phpeclipse.phpmanual");
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)new Path("templates"), null);
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            try {
                URL resolve = FileLocator.resolve((URL)fileURL);
                input = new BufferedReader(new FileReader(String.valueOf(resolve.getPath()) + "/refpage.html"));
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        try {}
        catch (IOException ex) {
            ex.printStackTrace();
            return contents.toString();
        }
        if (input == null) return contents.toString();
        input.close();
        return contents.toString();
    }

    public static String replace(String source, String pattern, String replace) {
        if (source != null) {
            int len = pattern.length();
            StringBuffer sb = new StringBuffer();
            int found = -1;
            int start = 0;
            while ((found = source.indexOf(pattern, start)) != -1) {
                sb.append(source.substring(start, found));
                sb.append(replace);
                start = found + len;
            }
            sb.append(source.substring(start));
            return sb.toString();
        }
        return "";
    }

    public String getHtmlSource(String funcName) {
        if (funcName.length() == 0) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)"net.sourceforge.phpeclipse.phphelp");
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)this.docPath, null);
        ZipEntry entry = null;
        String[] prefixes = new String[]{"", "function", "control-structures", "ref", "http", "imagick", "ming"};
        byte[] b = null;
        if (funcName.matches("^[a-z-]+\\.[a-z-0-9]+\\.html$")) {
            funcName = funcName.substring(0, funcName.lastIndexOf(46));
        }
        try {
            URL resolve = FileLocator.resolve((URL)fileURL);
            ZipFile docFile = new ZipFile(resolve.getPath());
            int i = 0;
            while (i < prefixes.length) {
                entry = docFile.getEntry("doc/" + prefixes[i] + (prefixes[i].length() == 0 ? "" : ".") + funcName.replace('_', '-') + ".html");
                if (entry != null) {
                    InputStream ref = docFile.getInputStream(entry);
                    b = new byte[(int)entry.getSize()];
                    ref.read(b, 0, (int)entry.getSize());
                    if (b != null) {
                        String reference = this.filterHtmlSource(new String(b));
                        String refPageTpl = this.getRefPageTemplate();
                        refPageTpl = refPageTpl.replaceAll("%title%", funcName);
                        refPageTpl = PHPManualView.replace(refPageTpl, "%reference%", reference);
                        return refPageTpl;
                    }
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            return "<html>" + PHPManualUIPlugin.getString("LookupException") + "</html>";
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private PHPEditor getJavaEditor() {
        try {
            IEditorPart part = PHPeclipsePlugin.getActivePage().getActiveEditor();
            if (part instanceof PHPEditor) {
                return (PHPEditor)part;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Browser access$3(PHPManualView pHPManualView) {
        return pHPManualView.browser;
    }
}

