/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package net.sourceforge.phpdt.internal.corext.codemanipulation;

import net.sourceforge.phpdt.core.IMember;

/**
 * Query object to let operations callback the actions. Example is a callback to
 * ask if a existing method should be replaced.
 */
public interface IRequestQuery {

	// return codes
	public static final int CANCEL = 0;

	public static final int NO = 1;

	public static final int YES = 2;

	public static final int YES_ALL = 3;

	/**
	 * Do the callback. Returns YES, NO, YES_ALL or CANCEL
	 */
	int doQuery(IMember member);
}
