/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package net.sourceforge.phpdt.internal.core;

import net.sourceforge.phpdt.core.IBuffer;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.WorkingCopyOwner;

/**
 * Wraps an IBufferFactory. TODO remove when removing IBufferFactory
 * 
 * @deprecated
 */
public class BufferFactoryWrapper extends WorkingCopyOwner {

	public net.sourceforge.phpdt.core.IBufferFactory factory;

	private BufferFactoryWrapper(
			net.sourceforge.phpdt.core.IBufferFactory factory) {
		this.factory = factory;
	}

	public static WorkingCopyOwner create(
			net.sourceforge.phpdt.core.IBufferFactory factory) {
		return new BufferFactoryWrapper(factory);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.sourceforge.phpdt.core.WorkingCopyOwner#createBuffer(net.sourceforge.phpdt.core.ICompilationUnit)
	 */
	public IBuffer createBuffer(ICompilationUnit workingCopy) {
		if (this.factory == null)
			return super.createBuffer(workingCopy);
		return this.factory.createBuffer(workingCopy);
	}

	public boolean equals(Object obj) {
		if (!(obj instanceof BufferFactoryWrapper))
			return false;
		BufferFactoryWrapper other = (BufferFactoryWrapper) obj;
		if (this.factory == null)
			return other.factory == null;
		return this.factory.equals(other.factory);
	}

	public int hashCode() {
		if (this.factory == null)
			return 0;
		return this.factory.hashCode();
	}

	public String toString() {
		return "FactoryWrapper for " + this.factory; //$NON-NLS-1$
	}
}
