# Pantera - Web Pen-Test Proxy
#
# FILENAME      : panteraLib.py
# CODER         : Simon Roses Femerling
# DATE          : 11/09/2004
# LAST UPDATE   : 07/21/2006
# ABSTRACT      : Python Web Pen-Test Proxy :)
#                 Pantera lib stuff.
#
# - Roses Labs Innovations (RL+I)
# Roses Labs
# http://www.roseslabs.com
#
# Copyright (c) 2003-2006 Roses Labs.
#
# You may not distribute, transmit, repost this software for commercial 
# purposes without Roses Labs written permission. 
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, publish,
# distribute the Software, and to permit persons to whom the Software 
# is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

'''
@author:       Simon Roses Femerling
@license:      GNU General Public License 2.0 or later
@contact:      pantera.proxy@gmail.com
@organization: OWASP / Roses Labs
'''

# Pantera Lib imports

import os
import sys
import re
import random
import string
import xml.dom.minidom
import panterautils

#############################################################################################
# Defines
#############################################################################################

PanteraDataDict = {}
Default404List = []
RestrictedHostList = []
RestrictedPagesList = []
DontContentType = []
TargetList = []
    
#############################################################################################
# Our Functions
#############################################################################################

#############################################################################################
# FUNC     : def OpenFileAndRead
# PARAMS   : string
# RETURN   : string
# ABSTRACT : Open and read a file
def OpenFileAndRead(fil):
    '''
    
    '''
    """ OpenFileAndRead """
    data = ""
    fp = open(fil,"r")
    data = fp.read()
    fp.close()  
    return data
# EOF: def OpenFileAndRead

#############################################################################################
# FUNC     : class InvalidTag
# PARAMS   : Exception
# RETURN   : ...
# ABSTRACT : Invalid XML tag class
class InvalidTag(Exception):
    '''
    
    '''
    """ InvalidTag class """
    pass
# EOF: class InvalidTag

#################################################################
# class InternalDataParser
#################################################################

#############################################################################################
# FUNC     : class InternalDataParser
# PARAMS   : ...
# RETURN   : ...
# ABSTRACT : Internal XMl parser
class InternalDataParser:
    '''
    
    '''

    #############################################################################################
    # FUNC     : def __init__
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : init
    def __init__(self, MyDOM):
        '''
    
        '''
        """ __init__ func """        
        self.ConfigDict = {}      
        self.Default404List = []
        self.RestrictedHostList = []
        self.RestrictedPagesList = []
        self.DontContentType = []
        self.TargetList = []

        self.SetHost(MyDOM)
        self.SetPort(MyDOM)
        self.SetForceAuth(MyDOM)
        self.SetForceProxyAuth(MyDOM)
        self.SetSSLHost(MyDOM)
        self.SetSSLPort(MyDOM)
        self.SetProxyHost(MyDOM)
        self.SetProxyPort(MyDOM)
        self.SetTargets(MyDOM)
        self.SetListenHost(MyDOM)
        self.SetReplaceUserAgent(MyDOM)
        self.SetUserAgent(MyDOM)
        self.SetUser(MyDOM)
        self.SetPassword(MyDOM)
        self.SetDomain(MyDOM)
        self.SetProxyUser(MyDOM)
        self.SetProxyPassword(MyDOM)
        self.SetProxyDomain(MyDOM)
        self.SetVerbose(MyDOM)
        self.SetDebug(MyDOM)
        self.SetRefresh(MyDOM)
        self.SetRefreshSeconds(MyDOM)
        self.SetCSS(MyDOM)
        self.SetRejectReturnCodes(MyDOM)
        self.SetDBLogin(MyDOM)
        self.SetDBPassword(MyDOM)
        self.SetDBHost(MyDOM)
        self.SetDBName(MyDOM)
        self.SetForceSave(MyDOM)
        self.SetAnalyzerThreads(MyDOM)
        self.SetDontSaveExt(MyDOM)
        self.SetDontContentType(MyDOM)
        self.SetDefault404(MyDOM)
        self.SetRestrictedHost(MyDOM)
        self.SetRestrictedPages(MyDOM)
    # EOF: def __init__

    #############################################################################################
    # FUNC     : def getText
    # PARAMS   : XML node list
    # RETURN   : string
    # ABSTRACT : Get node list
    def getText(self, nodelist):
        '''
    
        '''
        """ getText func """
        rc = ""
        for node in nodelist:
            if node.nodeType == node.TEXT_NODE:
                rc = rc + node.data
        return rc
    # EOF: def getText

    #############################################################################################
    # FUNC     : 
    # PARAMS   : 
    # RETURN   : 
    # ABSTRACT : 
    def SetHost(self, MyDOM):
        '''
    
        '''
        try:
            s = MyDOM.getElementsByTagName("host")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.host = "%s" % str(self.getText(s.childNodes))
        else:
            self.host = '127.0.0.1'
        self.ConfigDict['host'] = str(self.host)

    #############################################################################################
    # FUNC     : 
    # PARAMS   : 
    # RETURN   : 
    # ABSTRACT : 
    def SetPort(self, MyDOM):
        '''
    
        '''
        try:
            s = MyDOM.getElementsByTagName("port")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.port = "%s" % int(self.getText(s.childNodes))
        else:
            self.port = 8080
        self.ConfigDict['port'] = int(self.port)

    #############################################################################################
    # FUNC     : def SetForcrAuth
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set force auth
    def SetForceAuth(self, MyDOM):
        '''
    
        '''
        """ SetForceAuth func """
        try:
            s = MyDOM.getElementsByTagName("force_auth")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.force_auth = "%s" % str(self.getText(s.childNodes))
        else:
            self.force_auth = str("no")
        self.ConfigDict['force_auth'] = str(self.force_auth)
    # EOF: SetForceAuth func

    #############################################################################################
    # FUNC     : def SetForceProxyAuth
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set force proxy auth
    def SetForceProxyAuth(self, MyDOM):
        '''
    
        '''
        """ SetForceProxyAuth func """
        try:
            s = MyDOM.getElementsByTagName("force_proxy_auth")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.force_proxy_auth = "%s" % str(self.getText(s.childNodes))
        else:
            self.force_proxy_auth = str("no")
        self.ConfigDict['force_proxy_auth'] = str(self.force_proxy_auth)
    # EOF: SetForceProxyAuth func

    #############################################################################################
    # FUNC     : def SetSSLHost
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get SSL host
    def SetSSLHost(self, MyDOM):
        '''
    
        '''
        """ SetSSLHost func """
        try:
            s = MyDOM.getElementsByTagName("ssl_proxy_host")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.sslhost = "%s" % str(self.getText(s.childNodes))
        else:
            self.sslhost = ''
        self.ConfigDict['ssl_host'] = str(self.sslhost)
    # EOF: def SetSSLHost

    #############################################################################################
    # FUNC     : def SetSSLPort
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get SSL port
    def SetSSLPort(self, MyDOM):
        '''
    
        '''
        """ SetSSLPort func """
        try:
            s = MyDOM.getElementsByTagName("ssl_proxy_port")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.sslport = "%s" % int(self.getText(s.childNodes))
        else:
            self.sslport = 8081
        self.ConfigDict['ssl_port'] = int(self.sslport)
    # EOF: def SetSSLPort

    #############################################################################################
    # FUNC     : def SetProxyHost
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get proxy host
    def SetProxyHost(self, MyDOM):
        '''
    
        '''
        """ SetProxyHost func """
        try:
            s = MyDOM.getElementsByTagName("proxy_host")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.proxyhost = "%s" % str(self.getText(s.childNodes))
        else:
            self.proxyhost = ''
        self.ConfigDict['proxy_host'] = str(self.proxyhost)
    # EOF: SetProxyHost func

    #############################################################################################
    # FUNC     : def SetProxyPort
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get proxy port
    def SetProxyPort(self, MyDOM):
        '''
    
        '''
        """ SetProxyPort func """
        try:
            s = MyDOM.getElementsByTagName("proxy_port")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.proxyport = "%s" % int(self.getText(s.childNodes))
        else:
            self.proxyport = 8082
        self.ConfigDict['proxy_port'] = int(self.proxyport)
    # EOF: def SetProxyPort


    #############################################################################################
    # FUNC     : def SetTargets
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get domains list
    def SetTargets(self, MyDOM):
        '''
    
        '''
        try:
            s = MyDOM.getElementsByTagName("target")[0]
        except KeyError:
            raise InvalidTag
        if s:
            for ss in s.getElementsByTagName("target_domain"):
                if ss:
                    r = ss.getAttribute('name').strip()
                    if r != '':
                        d = {}
                        d['domain'] = r
                        r = ss.getAttribute('save').strip()
                        if r == 'yes': d['save'] = 'yes'
                        elif r == 'no': d['save'] = 'no'
                        else: d['save'] = 'yes' # by default we allow save domains into project even if we dont allow them
                        r = ss.getAttribute('action').strip()
                        if r == 'yes': d['action'] = 'yes'
                        elif r == 'no': d['action'] = 'no'
                        else: d['action'] = 'yes' # by default we allow domain
                        self.TargetList.append(d)
                        continue
                        
    # EOF: def SetTargets 

    #############################################################################################
    # FUNC     : def SetListenHost
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get listen host
    def SetListenHost(self, MyDOM):
        '''
    
        '''
        """ SetListenHost func """
        try:
            s = MyDOM.getElementsByTagName("listen_host")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.listenhost = "%s" % str(self.getText(s.childNodes))
        else:
            self.listenhost = ''
        self.ConfigDict['listen_host'] = str(self.listenhost)
    # EOF: def SetListenHost

    #############################################################################################
    # FUNC     : def SetReplaceUserAgent
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set replace user agent mode
    def SetReplaceUserAgent(self, MyDOM):
        '''
    
        '''
        """ SetReplaceUserAgent func """
        try:
            s = MyDOM.getElementsByTagName("replace_user_agent")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.replace_user_agent = "%s" % str(self.getText(s.childNodes))
        else:
            self.replace_user_agent = str("no")
        self.ConfigDict['replace_user_agent'] = str(self.replace_user_agent)
    # EOF: SetVerbose func 

    #############################################################################################
    # FUNC     : def SetUserAgent
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get user agent
    def SetUserAgent(self, MyDOM):
        '''
    
        '''
        """ SetUserAgent func """
        try:
            s = MyDOM.getElementsByTagName("user_agent")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.useragent = "%s" % str(self.getText(s.childNodes))
        else:
            self.useragent = ''
        self.ConfigDict['user_agent'] = str(self.useragent)
    # EOF: def SetUserAgent

    #############################################################################################
    # FUNC     : def SetUser
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get user
    def SetUser(self, MyDOM):
        '''
    
        '''
        """ SetUser func """
        try:
            s = MyDOM.getElementsByTagName("user")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.user = "%s" % str(self.getText(s.childNodes))
        else:
            self.user = ''
        self.ConfigDict['user'] = str(self.user)
    # EOF: def SetUser

    #############################################################################################
    # FUNC     : def SetPassword
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get password
    def SetPassword(self, MyDOM):
        '''
    
        '''
        """ SetPassword func """
        try:
            s = MyDOM.getElementsByTagName("password")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.password = "%s" % str(self.getText(s.childNodes))
        else:
            self.password = ''
        self.ConfigDict['password'] = str(self.password)
    # EOF: def SetPassword

    #############################################################################################
    # FUNC     : def SetDomain
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get domain 
    def SetDomain(self, MyDOM):
        '''
    
        '''
        """ SetDomain func """
        try:
            s = MyDOM.getElementsByTagName("domain")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.domain = "%s" % str(self.getText(s.childNodes))
        else:
            self.domain = ''
        self.ConfigDict['domain'] = str(self.domain)
    # EOF: def SetDomain

    #############################################################################################
    # FUNC     : def SetProxyUser
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get proxy user
    def SetProxyUser(self, MyDOM):
        '''
    
        '''
        """ SetProxyUser func """
        try:
            s = MyDOM.getElementsByTagName("proxy_user")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.proxy_user = "%s" % str(self.getText(s.childNodes))
        else:
            self.proxy_user = ''
        self.ConfigDict['proxy_user'] = str(self.proxy_user)
    # EOF: def SetProxyUser

    #############################################################################################
    # FUNC     : def SetProxyPassword
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get proxy password
    def SetProxyPassword(self, MyDOM):
        '''
    
        '''
        """ SetProxyPassword func """
        try:
            s = MyDOM.getElementsByTagName("proxy_password")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.proxy_password = "%s" % str(self.getText(s.childNodes))
        else:
            self.proxy_password = ''
        self.ConfigDict['proxy_password'] = str(self.proxy_password)
    # EOF: def SetProxyPassword

    #############################################################################################
    # FUNC     : def SetProxyDomain
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get proxy domain 
    def SetProxyDomain(self, MyDOM):
        '''
    
        '''
        """ SetProxyDomain func """
        try:
            s = MyDOM.getElementsByTagName("proxy_domain")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.proxy_domain = "%s" % str(self.getText(s.childNodes))
        else:
            self.proxy_domain = ''
        self.ConfigDict['proxy_domain'] = str(self.proxy_domain)
    # EOF: def SetProxyDomain

    #############################################################################################
    # FUNC     : def SetVerbose
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set verbose mode
    def SetVerbose(self, MyDOM):
        '''
    
        '''
        """ SetVerbose func """
        try:
            s = MyDOM.getElementsByTagName("verbose")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.verbose = "%s" % str(self.getText(s.childNodes))
        else:
            self.verbose = str("no")
        self.ConfigDict['verbose'] = str(self.verbose)
    # EOF: SetVerbose func 

    #############################################################################################
    # FUNC     : def SetDebug
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set debug mode
    def SetDebug(self, MyDOM):
        '''
    
        '''
        """ SetDebug func """
        try:
            s = MyDOM.getElementsByTagName("debug")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.debug = "%s" % str(self.getText(s.childNodes))
        else:
            self.debug = str("no")
        self.ConfigDict['debug'] = str(self.debug)
    # EOF: def SetDebug
    
    #############################################################################################
    # FUNC     : def SetRefresh
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set refresh mode
    def SetRefresh(self, MyDOM):
        '''
    
        '''
        """ SetRefresh func """
        try:
            s = MyDOM.getElementsByTagName("refresh")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.refresh = "%s" % str(self.getText(s.childNodes))
        else:
            self.refresh = str("no")
        self.ConfigDict['refresh'] = str(self.refresh)
    # EOF: def SetRefresh
    
    #############################################################################################
    # FUNC     : def SetRefreshSeconds
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set refresh seconds
    def SetRefreshSeconds(self, MyDOM):
        '''
    
        '''
        """ SetRefreshSeconds func """
        try:
            s = MyDOM.getElementsByTagName("refresh_seconds")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.refresh_seconds = "%s" % str(self.getText(s.childNodes))
        else:
            self.refresh_seconds = 100
        self.ConfigDict['refresh_seconds'] = int(self.refresh_seconds)
    # EOF: def SetRefreshSeconds

    #############################################################################################
    # FUNC     : def SetCSS
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set CSS file
    def SetCSS(self, MyDOM):
        '''
    
        '''
        """ SetCSS func """
        try:
            s = MyDOM.getElementsByTagName("css_file")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.css_file = "%s" % str(self.getText(s.childNodes))
        else:
            self.css_file = ''
        self.ConfigDict['css_file'] = str(self.css_file)
    # EOF: def SetCSS
    
    #############################################################################################
    # FUNC     : def 
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set Return Codes to reject
    def SetRejectReturnCodes(self, MyDOM):
        '''
    
        '''
        """ SetRejectReturnCodes func """
        try:
            s = MyDOM.getElementsByTagName("reject_return_codes")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.reject_return_codes = "%s" % str(self.getText(s.childNodes))
        else:
            self.reject_return_codes = ''
        self.ConfigDict['reject_return_codes'] = str(self.reject_return_codes)
    # EOF: def SetRejectReturnCodes

    #############################################################################################
    # FUNC     : def SetDBLogin
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get DDBB login
    def SetDBLogin(self, MyDOM):
        '''
    
        '''
        """ SetDBLogin func """
        try:
            s = MyDOM.getElementsByTagName("db_login")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.db_login = "%s" % str(self.getText(s.childNodes))
        else:
            self.db_login = ''
        self.ConfigDict['db_login'] = str(self.db_login)
    # EOF: def SetDBLogin

    #############################################################################################
    # FUNC     : def SetDBPassword
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get DDBB passsword
    def SetDBPassword(self, MyDOM):
        '''
    
        '''
        """ SetDBPassword func """
        try:
            s = MyDOM.getElementsByTagName("db_password")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.db_password = "%s" % str(self.getText(s.childNodes))
        else:
            self.db_password = ''
        self.ConfigDict['db_password'] = str(self.db_password)
    # EOF: def SetDBPassword

    #############################################################################################
    # FUNC     : def SetDBHost
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get DDBB host
    def SetDBHost(self, MyDOM):
        '''
    
        '''
        """ SetDBHost func """
        try:
            s = MyDOM.getElementsByTagName("db_host")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.db_host = "%s" % str(self.getText(s.childNodes))
        else:
            self.db_host = ''
        self.ConfigDict['db_host'] = str(self.db_host)
    # EOF: def SetDBHost

    #############################################################################################
    # FUNC     : def SetDBName
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get DDBB name
    def SetDBName(self, MyDOM):
        '''
    
        '''
        """ SetDBName func """
        try:
            s = MyDOM.getElementsByTagName("db_name")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.db_name = "%s" % str(self.getText(s.childNodes))
        else:
            self.db_name = ''
        self.ConfigDict['db_name'] = str(self.db_name)
    # EOF: def SetDBName

    #############################################################################################
    # FUNC     : def SetForceSave
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set Force Save
    def SetForceSave(self, MyDOM):
        '''
    
        '''
        """ SetForceSave func """
        try:
            s = MyDOM.getElementsByTagName("force_dont_save")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.force_save = "%s" % str(self.getText(s.childNodes))
        else:
            self.force_save = str("no")
        self.ConfigDict['force_dont_save'] = str(self.force_save)
    # EOF: def SetForceSave
        
    #############################################################################################
    # FUNC     : def SetAnalyzerThreads
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Get number of analyzer threads
    def SetAnalyzerThreads(self, MyDOM):
        '''
    
        '''
        """ SetAnalyzerThreads func """
        try:
            s = MyDOM.getElementsByTagName("analyzer_threads")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.analyzer_threads = "%s" % int(self.getText(s.childNodes))
        else:
            self.analyzer_threads = 20
        self.ConfigDict['analyzer_threads'] = int(self.analyzer_threads)
    # EOF: def SetAnalyzerThreads

    #############################################################################################
    # FUNC     : def SetDontSaveExt
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set not extension to save
    def SetDontSaveExt(self, MyDOM):
        '''
    
        '''
        """ SetDontSaveExt func """
        try:
            s = MyDOM.getElementsByTagName("dont_save_ext")[0]
        except KeyError:
            raise InvalidTag
        if s:
            self.dont_save_ext = "%s" % str(self.getText(s.childNodes))
        else:
            self.dont_save_ext = ''
        self.ConfigDict['dont_save_ext'] = str(self.dont_save_ext)
    # EOF: def SetDontSaveExt

    #############################################################################################
    # FUNC     : def SetDontContentType
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set not content type to save
    def SetDontContentType(self, MyDOM):
        '''
    
        '''
        """ SetDontContentType func """
        try:
            s = MyDOM.getElementsByTagName("dont_save_content_type")[0]
        except KeyError:
            raise InvalidTag
        if s:
            for ss in s.getElementsByTagName("content_type"):
                if ss:
                    res = "%s" % str(self.getText(ss.childNodes))
                    self.DontContentType.append(res)  
    # EOF: def SetDontContentType

    #############################################################################################
    # FUNC     : def SetDefault404
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set 404 defaults
    def SetDefault404(self, MyDOM):
        '''
    
        '''
        """ SetDefault404 func """
        try:
            s = MyDOM.getElementsByTagName("default_404")[0]
        except KeyError:
            raise InvalidTag
        if s:
            for ss in s.getElementsByTagName("string_404"):
                if ss:
                    res = "%s" % str(self.getText(ss.childNodes))
                    self.Default404List.append(res)          
    # EOF: def SetDefault404

    #############################################################################################
    # FUNC     : def SetRestrictedHost
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set restricted hosts
    def SetRestrictedHost(self, MyDOM):
        '''
    
        '''
        """ SetRestrictedHost func """
        try:
            s = MyDOM.getElementsByTagName("restricted_hosts")[0]
        except KeyError:
            raise InvalidTag
        if s:
            for ss in s.getElementsByTagName("restrictedh"):
                if ss:
                    res = "%s" % str(self.getText(ss.childNodes))
                    if res != "":
                        self.RestrictedHostList.append(res)          
    # EOF: def SetRestrictedHost

    #############################################################################################
    # FUNC     : def SetRestrictedPages
    # PARAMS   : MyDOM
    # RETURN   : ...
    # ABSTRACT : Set restricted pages
    def SetRestrictedPages(self, MyDOM):
        '''
    
        '''
        """ SetRestrictedPages func """
        try:
            s = MyDOM.getElementsByTagName("restricted_pages")[0]
        except KeyError:
            raise InvalidTag
        if s:
            for ss in s.getElementsByTagName("restrictedp"):
                if ss:
                    res = "%s" % str(self.getText(ss.childNodes))
                    if res != "":
                        self.RestrictedPagesList.append(res)          
    # EOF: def SetRestrictedPages

    #############################################################################################
    # FUNC     : def GetConfig
    # PARAMS   : ...
    # RETURN   : dict
    # ABSTRACT : Return config
    def GetConfig(self):
        '''
    
        '''
        """ GetConfig func """
        return self.ConfigDict
    # EOF: def GetConfig    

    #############################################################################################
    # FUNC     : def GetDefault404
    # PARAMS   : ...
    # RETURN   : list
    # ABSTRACT : Return 404 defaults list 
    def GetDefault404(self):
        '''
    
        '''
        """ GetDefault404 func """
        return self.Default404List
    # EOF: def GetDefault404    

    #############################################################################################
    # FUNC     : def GetRestrictedHost
    # PARAMS   : ...
    # RETURN   : list
    # ABSTRACT : Return restricted host list
    def GetRestrictedHost(self):
        '''
    
        '''
        """ GetRestrictedHost func """
        return self.RestrictedHostList
    # EOF: def GetRestrictedHost    

    #############################################################################################
    # FUNC     : def GetRestrictedPages
    # PARAMS   : ...
    # RETURN   : list
    # ABSTRACT : Return restricted pages list
    def GetRestrictedPages(self):
        '''
    
        '''
        """ GetRestrictedPages func """
        return self.RestrictedPagesList
    # EOF: def GetRestrictedPages    

    #############################################################################################
    # FUNC     : def GetDontContentType
    # PARAMS   : ...
    # RETURN   : list
    # ABSTRACT : Return content type not to save
    def GetDontContentType(self):
        '''
    
        '''
        """ GetDontContentType func """
        return self.DontContentType
    # EOF: def GetDontContentType

    #############################################################################################
    # FUNC     : def GetTargetDomains
    # PARAMS   : ...
    # RETURN   : list
    # ABSTRACT : Return target domain list
    def GetTargetDomains(self):
        '''
    
        '''
        """ GetTargetDomains func """
        return self.TargetList
    # EOF: def GetTargetDomains

#################################################################
# class DataParser
#################################################################

#############################################################################################
# FUNC     : class DataParser
# PARAMS   : InternalDataParser
# RETURN   : ...
# ABSTRACT : XML parser class
class DataParser(InternalDataParser):
    '''
    
    '''

    #############################################################################################
    # FUNC     : def __init__
    # PARAMS   : dict
    # RETURN   : ...
    # ABSTRACT : Init internal variables
    def __init__(self, d = {}):
        '''
    
        '''
        """ __init__ func """
        self.configfile = "panteracfg.xml"
        self.xp_config = ""
        self.error_msg = ""
    # EOF: def __init__

    #############################################################################################
    # FUNC     : def SetFilename
    # PARAMS   : strinf
    # RETURN   : ...
    # ABSTRACT : Set XML file to parse 
    def SetFilename(self, f):
        '''
    
        '''
        """ SetFilename func """
        self.configfile = f
    # EOF: def SetFilename

    #############################################################################################
    # FUNC     : def ReturnFilename
    # PARAMS   : ...
    # RETURN   : string
    # ABSTRACT : Return XML filename
    def ReturnFilename(self):
        '''
    
        '''
        """ ReturnFilename func """
        return self.configfile
    # EOF: def ReturnFilename
        
    #############################################################################################
    # FUNC     : def BeginParse
    # PARAMS   : ...
    # RETURN   : None on error
    # ABSTRACT : Begin XML parsing
    def BeginParse(self):
        '''
    
        '''
        """ BeginParse func """
        dom1 = '' # config file

        # Config parser
        try:
            data = OpenFileAndRead(self.configfile)
            dom1 = xml.dom.minidom.parseString(data)
            self.s = dom1.getElementsByTagName("pantera")
            if self.s:
                self.xp_config = InternalDataParser(dom1.childNodes[0])
        except Exception, e:
            self.error_msg += "Error parsing XML file " + self.configfile
            return None      

        if dom1:
            dom1.unlink()
            dom1 = None
    # EOF: def BeginParse

    #############################################################################################
    # FUNC     : def GetErrorMsg
    # PARAMS   : ...
    # RETURN   : string
    # ABSTRACT : Get error msg
    def GetErrorMsg(self):
        '''
    
        '''
        """ GetErrorMsg func """
        return self.error_msg
    # EOF: def GetErrorMsg

    #############################################################################################
    # FUNC     : def GetConfigData
    # PARAMS   : ...
    # RETURN   : dict
    # ABSTRACT : Return config
    def GetConfigData(self):
        '''
    
        '''
        """ GetConfigData func """
        return self.xp_config.GetConfig()
    # EOF: def GetConfigData

    #############################################################################################
    # FUNC     : def GetDefault404
    # PARAMS   : ...
    # RETURN   : list
    # ABSTRACT : Return 404 default list
    def GetDefault404(self):        
        '''
    
        '''
        """ GetDefault404 func """
        return self.xp_config.GetDefault404()
    # EOF: def GetDefault404

    #############################################################################################
    # FUNC     : def GetRestrictedHost
    # PARAMS   : ...
    # RETURN   : list
    # ABSTRACT : Return restricted host list
    def GetRestrictedHost(self):        
        '''
    
        '''
        """ GetRestrictedHost func """
        return self.xp_config.GetRestrictedHost()
    # EOF: def GetRestrictedHost

    #############################################################################################
    # FUNC     : def GetRestrictedPages
    # PARAMS   : ...
    # RETURN   : list
    # ABSTRACT : Return restricted pages list
    def GetRestrictedPages(self):        
        '''
    
        '''
        """ GetRestrictedPages list """
        return self.xp_config.GetRestrictedPages()
    # EOF: def GetRestrictedPages
    
    #############################################################################################
    # FUNC     : def GetDontContentType
    # PARAMS   : ...
    # RETURN   : list
    # ABSTRACT : Return content type to not save
    def GetDontContentType(self):
        '''
    
        '''
        """ GetDontContentType func """
        return self.xp_config.GetDontContentType()
    # EOF: def GetDontContentType

    #############################################################################################
    # FUNC     : def GetTargetDomains
    # PARAMS   : ...
    # RETURN   : list
    # ABSTRACT : Return target domain list
    def GetTargetDomains(self):
        '''
    
        '''
        """ GetTargetDomains func """
        return self.xp_config.GetTargetDomains()
    # EOF: def GetTargetDomains

#################################################################
# XML Data Files Classes
#################################################################

#############################################################################################
# FUNC     : class GenericDataParser
# PARAMS   : ...
# RETURN   : ...
# ABSTRACT : XML parser class
class GenericDataParser:
    '''
    
    '''

    def __init__(self):
        '''
    
        '''
        self.iClear()
        
    def iClear(self):
        '''
    
        '''
        self.filename = ""
        self.idom = ''
        self.error_msg = ''
        
    def SetFileName(self, f):
        '''
    
        '''
        self.filename = f
        
    def GetFileName(self):
        '''
    
        '''
        return self.filename

    def SetErrorMsg(self, m):
        '''
    
        '''
        self.error_msg = m
        
    def GetErrorMsg(self):
        '''
    
        '''
        return self.error_msg

    def BeginParse(self):
        '''
    
        '''
        try:
            if self.filename == "":
                self.SetErrorMsg('Error: No XML data file')
                return -1
            data = OpenFileAndRead(self.filename)
            self.idom = xml.dom.minidom.parseString(data)
        except Exception, e:
            self.SetErrorMsg('Error parsing XML file %s" % self.configfile')
            return -1
        return 0

    def CloseParser(self):
        '''
    
        '''
        if self.idom:
            self.idom.unlink()
            self.idom = None
        
    def Get_Attribute(self, tagname, attrname):
        '''
    
        '''
        nodelist = self.idom.getElementsByTagName(tagname)
        print nodelist
        if nodelist:
            assert len(nodelist) == 1
            node = nodelist[0]
            return node.getAttribute(attrname).strip()
        else:
            return ""
    
    def Get_Tag(self, tagname):
        '''
    
        '''
        nodelist = self.idom.getElementsByTagName(tagname)
        if nodelist:
            assert len(nodelist) == 1
            data = nodelist[0]
            data.normalize()
            if data.childNodes:
                return data.firstChild.data.strip()

    def GetListTags(self, tagname):
        '''
    
        '''
        l = []
        append = l.append
        for tag in self.idom.getElementsByTagName(tagname):
            tag.normalize()
            append(tag.firstChild.data)
        return l
    
    def GetFirstChildrenByTagName(self, parent, tagname):
        '''
    
        '''
        l = []
        append = l.append
        for child in parent.childNodes:
            if (child.nodeType == Node.ELEMENT_NODE and child.tagname == tagname):
                append(child)
        return l

    def ReturnNode(self):
        return self.idom

#############################################################################################
# FUNC     : class ExtensionParser
# PARAMS   : ...
# RETURN   : ...
# ABSTRACT : File Extension parser class
class ExtensionParser(GenericDataParser):
    '''
    
    '''

    def __init__(self):
        '''
    
        '''
        self.iClear()
        
    def iClear(self):
        '''
    
        '''
        self.filename = "ext_types.xml"
        self.gene = GenericDataParser()

    def SetFileName(self, f):
        '''
    
        '''
        self.filename = f
        
    def GetFileName(self):
        '''
    
        '''
        return self.filename

    def BeginParser(self):
        '''
    
        '''
        self.gene.SetFileName(self.filename)
        res = self.gene.BeginParse()
        if res == -1:
            return -1
        return 0
    
    def ReturnExtData(self, ext=''):
        '''
    
        '''
        val = -1
        notes = -1
        idom = self.gene.ReturnNode()
        try:
            nodelist = idom.getElementsByTagName('type')
        except KeyError:
            raise InvalidTag
        for node in nodelist:
            r = node.getAttribute('ext').strip()
            if r == ext:
                val = node.getAttribute('desc').strip()
                my_note = node.getElementsByTagName('notes')
                if my_note:
                    data = my_note[0]
                    data.normalize()
                    if data.childNodes:
                        notes = data.firstChild.data.strip()
        return (val, notes)
    
    def ReturnAllExt(self):
        '''
    
        '''
        l = []
        append = l.append
        idom = self.gene.ReturnNode()
        nodelist = idom.getElementsByTagName('type')
        for node in nodelist:
            r = node.getAttribute('ext').strip()
            append(r)
        return l
        
    def GetError(self):
        '''
    
        '''
        return self.gene.GetErrorMsg()

#############################################################################################
# FUNC     : class SensibleWordsParser
# PARAMS   : ...
# RETURN   : ...
# ABSTRACT : Sensible Words parser class
class SensibleWordsParser(GenericDataParser):
    '''
    
    '''

    def __init__(self):
        '''
    
        '''
        self.iClear()
        
    def iClear(self):
        '''
    
        '''
        self.filename = "sensible_words.xml"
        self.gene = GenericDataParser()

    def SetFileName(self, f):
        '''
    
        '''
        if f != '':
            self.filename = f
        
    def GetFileName(self):
        '''
    
        '''
        return self.filename

    def BeginParser(self):
        '''
    
        '''
        self.gene.SetFileName(self.filename)
        res = self.gene.BeginParse()
        if res == -1:
            return -1
        return 0
    
    def ReturnData(self, ext=''):
        '''
    
        '''
        l = []
        name = -1
        search_str = -1
        idom = self.gene.ReturnNode()
        try:
            nodelist = idom.getElementsByTagName('word')
        except KeyError:
            raise InvalidTag
        add = l.append
        for node in nodelist:
            name = node.getAttribute('name').strip()
            data = node
            data.normalize()
            search_str = data.firstChild.data.strip()
            add((name,search_str))
        return l
    
    def GetError(self):
        '''
    
        '''
        return self.gene.GetErrorMsg()

#############################################################################################
# FUNC     : class HTTPEditorParser
# PARAMS   : ...
# RETURN   : ...
# ABSTRACT : HTTP Editor Profile parser class
class HTTPEditorParser(GenericDataParser):
    '''
    
    '''

    def __init__(self):
        '''
    
        '''
        self.iClear()
        
    def iClear(self):
        '''
    
        '''
        self.filename = ""
        self.gene = GenericDataParser()

    def SetFileName(self, f):
        '''
    
        '''
        if f != '':
            self.filename = f
        
    def GetFileName(self):
        '''
    
        '''
        return self.filename

    def BeginParser(self):
        '''
    
        '''
        if self.filename == '': return -1
        self.gene.SetFileName(self.filename)
        res = self.gene.BeginParse()
        if res == -1:
            return -1
        return 0
    
    def ReturnData(self, ext=''):
        '''
    
        '''
        dat = {}
        url_param = []
        header_param = []
        body_param = []
        idom = self.gene.ReturnNode()

        # do some init stuff
        dat['verb_style'] = 'raw'
        dat['verb'] = ''
        dat['url'] = ''
        dat['version_style'] = 'raw'
        dat['version'] = ''
        dat['connecthost'] = ''
        dat['connectport'] = ''
        dat['ssl'] = 0
        dat['url_num'] = 3
        dat['url_params'] = []
        dat['header_num'] = 3
        dat['header_params'] = []
        dat['body_num'] = 3
        dat['body_params'] = []
        
        try:
            nodelist = idom.getElementsByTagName('verb_style')
        except KeyError:
            raise InvalidTag
        for node in nodelist:
            data = node
            data.normalize()
            if data.firstChild != None:
                sstr = data.firstChild.data.strip()
                dat['verb_style'] = str(panterautils.FixStringForXML(sstr,1))
            else:
                dat['verb_style'] = 'raw'
        try:
            nodelist = idom.getElementsByTagName('verb')
        except KeyError:
            raise InvalidTag
        for node in nodelist:
            data = node
            data.normalize()
            if data.firstChild != None:
                sstr = data.firstChild.data.strip()
                dat['verb'] = str(panterautils.FixStringForXML(sstr,1))
            else:
                dat['verb'] = ''
        try:
            nodelist = idom.getElementsByTagName('url')
        except KeyError:
            raise InvalidTag
        for node in nodelist:
            data = node
            data.normalize()
            if data.firstChild != None:
                sstr = data.firstChild.data.strip()
                dat['url'] = str(panterautils.FixStringForXML(sstr,1))
            else:
                dat['url'] = ''
        try:
            nodelist = idom.getElementsByTagName('version_style')
        except KeyError:
            raise InvalidTag
        for node in nodelist:
            data = node
            data.normalize()
            if data.firstChild != None:
                sstr = data.firstChild.data.strip()
                dat['version_style'] = str(panterautils.FixStringForXML(sstr,1))
            else:
                dat['version_style'] = 'raw'
        try:
            nodelist = idom.getElementsByTagName('version')
        except KeyError:
            raise InvalidTag
        for node in nodelist:
            data = node
            data.normalize()
            if data.firstChild != None:
                sstr = data.firstChild.data.strip()
                dat['version'] = str(panterautils.FixStringForXML(sstr,1))
            else:
                dat['version'] = ''
        try:
            nodelist = idom.getElementsByTagName('connecthost')
        except KeyError:
            raise InvalidTag
        for node in nodelist:
            data = node
            data.normalize()
            if data.firstChild != None:
                sstr = data.firstChild.data.strip()
                dat['connecthost'] = str(panterautils.FixStringForXML(sstr,1))
            else:
                dat['connecthost'] = ''
        try:
            nodelist = idom.getElementsByTagName('connectport')
        except KeyError:
            raise InvalidTag
        for node in nodelist:
            data = node
            data.normalize()
            if data.firstChild != None:
                sstr = data.firstChild.data.strip()
                dat['connectport'] = str(panterautils.FixStringForXML(sstr,1))
            else:
                dat['connectport'] = ''
        try:
            nodelist = idom.getElementsByTagName('ssl')
        except KeyError:
            raise InvalidTag
        for node in nodelist:
            data = node
            data.normalize()
            if data.firstChild != None:
                sstr = data.firstChild.data.strip()
                try:
                    dat['ssl'] = int(sstr)
                except:
                    pass
            else:
                dat['ssl'] = 0
        try:
            nodelist = idom.getElementsByTagName("url_params")[0]
        except KeyError:
            raise InvalidTag
        if nodelist:
            ex = nodelist.getAttribute('extra').strip()
            try:
                dat['url_num'] = int(ex)
            except:
                pass
            for ss in nodelist.getElementsByTagName("url_param"):
                if ss:
                    name = ss.getAttribute('name').strip()
                    value = ss.getAttribute('value').strip()
                    name = str(panterautils.FixStringForXML(name,1))
                    value = str(panterautils.FixStringForXML(value,1))
                    url_param.append((name,value))
        try:
            nodelist = idom.getElementsByTagName("header_params")[0]
        except KeyError:
            raise InvalidTag
        if nodelist:
            ex = nodelist.getAttribute('extra').strip()
            try:
                dat['header_num'] = int(ex)    
            except:
                pass
            for ss in nodelist.getElementsByTagName("header_param"):
                if ss:
                    name = ss.getAttribute('name').strip()
                    value = ss.getAttribute('value').strip()
                    name = str(panterautils.FixStringForXML(name,1))
                    value = str(panterautils.FixStringForXML(value,1))
                    header_param.append((name,value))
        try:
            nodelist = idom.getElementsByTagName("body_params")[0]
        except KeyError:
            raise InvalidTag
        if nodelist:
            ex = nodelist.getAttribute('extra').strip()
            try:
                dat['body_num'] = int(ex)
            except:
                pass
            for ss in nodelist.getElementsByTagName("body_param"):
                if ss:
                    name = ss.getAttribute('name').strip()
                    value = ss.getAttribute('value').strip()
                    name = str(panterautils.FixStringForXML(name,1))
                    value = str(panterautils.FixStringForXML(value,1))
                    body_param.append((name,value))
        dat['url_params'] = url_param
        dat['header_params'] = header_param
        dat['body_params'] = body_param
        return dat
    
    def GetError(self):
        '''
    
        '''
        return self.gene.GetErrorMsg()

    
# RL+I EOF