<?php
/**
 * Hebrew Language Configure Help file
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @translathor Meliza
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: configure_help.he.php 5793 2009-06-28 06:58:35Z meliza $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}
$pgv_lang["SHOW_LIST_PLACES"]			= "רמות מקום ברשומות";
$pgv_lang["SHOW_LIST_PLACES_help"]		= "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />This determines how much of the Place information is shown in the Place fields on lists.<br /><br />Setting the value to <b>9</b> will ensure that all Place information will be shown.  Setting the value to <b>0</b> (zero) will hide places completely.  Setting the value to <b>1</b> will show the topmost level, which is normally the country.  Setting it to <b>2</b> will show the topmost two levels.  The second topmost level, below the country, is often the state, province, or territory. Etc.<br />";

$pgv_lang["new_gedcom_title"]			= "חקר משפחה מקובץ [#GEDCOMFILE#]";
$pgv_lang["keep_media_help"]			= "~#pgv_lang[keep_media]#~<br /><br />Should existing media links be retained in the database when a replacement GEDCOM is being uploaded. The <b>No</b> option removes existing media links from the database, while the <b>Yes</b> option keeps them.<br /><br />This option is useful when you export your GEDCOM from PhpGedView to an off-line GEDCOM maintenance program that does not handle embedded media pointers properly, and then subsequently re-import that changed GEDCOM into PhpGedView.  Under such circumstances, the media pointers within the GEDCOM you exported to your off-line editing program are destroyed, and you would have to re-link all of your media files to the proper Person, Family, and Source records after you re-import the GEDCOM into PhpGedView.<br /><br />The <b>Yes</b> option tells PhpGedView to keep the existing media links so that you do not have to re-create them after you import the changed GEDCOM, but this requires the off-line editing program to always produce the same Person, Family, and Source identification numbers.<br /><br /><i>Family Tree Maker</i> is one of several off-line editing programs that does <u>not</u> properly handle media object pointers within the GEDCOM.  <i>Legacy</i>, among many others, <u>does</u> handle these properly.<br />";
$pgv_lang["USE_MEDIA_VIEWER"]			= "השתמש במציג מדיה";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />When this option is <b>#pgv_lang[yes]#</b>, clicking on images will produce the Media Viewer page.  This page shows the details of the image.  If you have sufficient rights, you can also edit these details.<br /><br />When this option is <b>#pgv_lang[no]#</b>, clicking on images will produce a full-size image in a new window.<br />";
$pgv_lang["USE_MEDIA_FIREWALL"]		= "השתמש בחומת אש של מדיה";
$pgv_lang["USE_MEDIA_FIREWALL_help"]		= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />See the Wiki for a description of how to use the Media Firewall. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a><br />";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]	= "ספריית השורש בחומת האש של מדיה";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Directory in which the protected Media directory can be created.  #pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#<br />";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "כאשר שדה זה ריק, משתמשים בתיקיית <b>#GLOBALS[INDEX_DIRECTORY]#</b>.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]		= "הגן על תמונות ממוזערות של תמונות מוגנות";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]	= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />When an image is in the protected Media directory, should its thumbnail be protected as well?<br />";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "הראה tagline של עכבישים";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />On pages generated for search engines, display as the last line the particular search engine the page detected.  If this option is on, it can bias Google&reg; AdSense towards search engine optimization tools.<br />";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />This option will retain family links in privatized records.  This means that you will see empty \"private\" boxes on the pedigree chart and on other charts with private people.<br /><br />This is similar to the behavior of PhpGedView versions prior to v4.0.<br /><br />This setting is off by default.  It is recommended instead of turning this on, to point your pedigree root person in your GEDCOM configuration to a person who is not private.<br />";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "הראה קרבה לאדם פרטי";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 		= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />In past versions of PGV the pending edits were stored in the GEDCOM file and the changed records were then \"accepted\" into the database.  Starting with v4.1 pending changes are no longer stored in the GEDCOM file but in the changes file.  <br /><br />Setting this value to true will update the GEDCOM file when changes are accepted into the database.  This will keep the GEDCOM file synchronized with the database.  For greater compatibility with previous versions the default value of this field is on.<br /><br />You may want to turn it off to conserver memory when accepting changes.<br />";
$pgv_lang["SYNC_GEDCOM_FILE"]		= "סנכרן שינויים לתוך קובץ GEDCOM";
$pgv_lang["COMMIT_COMMAND_help"] 		= "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />If you wish to use a version control system such as CVS to archive changes to your GEDCOM file and your configuration or privacy settings, enter the command here.  Leave the box blank if you do not wish to use a version control system.  Valid options are <b>cvs</b> and <b>svn</b>.<br />";
$pgv_lang["COMMIT_COMMAND"] 			= "פקודת Commit של ניהול מהדורות";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Multi-site search allows users to search across multiple PhpGedView websites which you have setup in the Manage Sites administration area or remotely linked to.  This option controls whether the Multi-site Search feature is available to everyone or only to authenticated users.<br />";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "הראה חיפוש באתרים מרובים";
$pgv_lang["SHOW_NO_WATERMARK_help"]	= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />If the Media Firewall is enabled, users will see watermarks if they do not have the privilege level specified here.<br />";
$pgv_lang["SHOW_NO_WATERMARK"]		= "מי יכול לראות תמונות ללא סימני מים?";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />If the Media Firewall is enabled, should thumbnails be watermarked? Your media lists will load faster if you don't watermark the thumbnails.<br />";
$pgv_lang["WATERMARK_THUMB"]		= "הוסף סימני מים לתמונות ממוזערות?";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]	= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />If the Media Firewall is enabled, should copies of watermarked thumbnails be stored on the server in addition to the same thumbnails without watermarks?<br /><br />When set to <b>#pgv_lang[yes]#</b>, media lists containing watermarked thumbnails will be produced more quickly at the expense of higher server disk space requirements.<br />";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "שמור תמונות ממוזערות בעלות סימני מים על השרת?";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]	= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />If the Media Firewall is enabled, should copies of watermarked full size images be stored on the server in addition to the same images without watermarks?<br /><br />When set to <b>#pgv_lang[yes]#</b>, full-sized watermarked images will be produced more quickly at the expense of higher server disk space requirements.<br />";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "שמור תמונות בגודל מלא בעלות סימני מים על השרת?";
$pgv_lang["DB_UTF8_COLLATION"]			= "השתמש במאגר נתונים כדי לספק המרה colaion ל-UTF-8 ";
$pgv_lang["DB_UTF8_COLLATION_help"]		= "Controls whether PhpGedView should use the database's built-in sorting and collation facilities.  It is generally quicker to use the database to sort and filter data rather than PHP, although not all databases/versions provide this feature.  The collation sequence used for each language is set in that language's settings page.<br /><br /><span class=\"warning\">IMPORTANT: You should only set this value to YES if you do so BEFORE the database tables are created for the first time. Selecting it on an existing database could cause your data to become corrupted.</span><br /><br />MySQL and PostgreSQL both offer good support for UTF-8, although not all collation sequences are available in earlier versions of MySQL.  Other databases offer little or no support for UTF-8. If you are unsure of your database's support of UTF-8, you should set this value to <b>No</b>.<br /><br />This <a href='http://en.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia article'><b>Wikipedia article</b></a> contains comprehensive information and links about UTF-8.<br />";
$pgv_lang["INDI_FACTS_ADD"] 			= "עובדות אישיות שניתן להוסיף";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />This is the list of GEDCOM facts that your users can add to individuals.  You can modify this list by removing or adding fact names, even custom ones, as necessary.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i> list.<br />";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "עובדות אישיות יחידות במינן";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to individuals.  For example, if BIRT is in this list, users will not be able to add more than one BIRT record to an individual.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[INDI_FACTS_ADD]#</i> list.<br />";
$pgv_lang["INDI_FACTS_QUICK"] 			= "עובדות אישיות עיקריות";
$pgv_lang["INDI_FACTS_QUICK_help"]		= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />This is the short list of GEDCOM individual facts that appears next to the full list and can be added with a single click.<br />";
$pgv_lang["FAM_FACTS_ADD"] 			= "עובדות משפחתיות שניתן להוסיף";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />This is the list of GEDCOM facts that your users can add to families.  You can modify this list by removing or adding fact names, even custom ones, as necessary.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i> list.<br />";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "עובדות משפחתיות יחידות במינן";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to families.  For example, if MARR is in this list, users will not be able to add more than one MARR record to a family.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[FAM_FACTS_ADD]#</i> list.<br />";
$pgv_lang["FAM_FACTS_QUICK"] 			= "עובדות משפחתיות עיקריות";
$pgv_lang["FAM_FACTS_QUICK_help"]		= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />This is the short list of GEDCOM family facts that appears next to the full list and can be added with a single click.<br />";
$pgv_lang["SOUR_FACTS_ADD"] 			= "עובדות מקור שניתן להוסיף";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />This is the list of GEDCOM facts that your users can add to sources.  You can modify this list by removing or adding fact names, even custom ones, as necessary.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i> list.<br />";
$pgv_lang["SOUR_FACTS_UNIQUE"] 		= "עובדות מקור יחידות במינן";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to sources.  For example, if TITL is in this list, users will not be able to add more than one TITL record to a source.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[SOUR_FACTS_ADD]#</i> list.<br />";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "עובדות עיקריות של מקורות";
$pgv_lang["SOUR_FACTS_QUICK_help"]		= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />This is the short list of GEDCOM source facts that appears next to the full list and can be added with a single click.<br />";
$pgv_lang["REPO_FACTS_ADD"] 			= "עובדות מאגר שניתן להוסיף";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />This is the list of GEDCOM facts that your users can add to repositories.  You can modify this list by removing or adding fact names, even custom ones, as necessary.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i> list.<br />";
$pgv_lang["REPO_FACTS_UNIQUE"] 		= "עובדות מאגר יחידות במינן";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />This is the list of GEDCOM facts that your users can only add <u>once</u> to repositories.  For example, if NAME is in this list, users will not be able to add more than one NAME record to a repository.  Fact names that appear in this list must not also appear in the <i>#pgv_lang[REPO_FACTS_ADD]#</i> list.<br />";
$pgv_lang["REPO_FACTS_QUICK"] 			= "עובדות עיקריות של מאגר";
$pgv_lang["REPO_FACTS_QUICK_help"]		= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />This is the short list of GEDCOM repository facts that appears next to the full list and can be added with a single click.<br />";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />You can change the list of languages supported by your PhpGedView site by adding or removing checkmarks as appropriate.  This changes the language choices available to your users.<br /><br />You can achieve the same thing through the <b>#pgv_lang[enable_disable_lang]#</b> link on the #pgv_lang[admin]# menu, where you can also change things such as the language's flag icon, the date format, or whether the surname should always be printed first.<br />";
$pgv_lang["MEDIA_ID_PREFIX"]			= "קידומת קוד זיהוי של מדיה";
$pgv_lang["MEDIA_ID_PREFIX_help"]		= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />When a new media record is added online in PhpGedView, a new ID for that media will be generated automatically. The media ID will have this prefix.<br />";
$pgv_lang["FAM_ID_PREFIX"]			= "קידומת קוד זיהוי של משפחה";
$pgv_lang["FAM_ID_PREFIX_help"]			= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />When a new family record is added online in PhpGedView, a new ID for that family will be generated automatically. The family ID will have this prefix.<br />";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]	= "הראה תמיד עובדות של משפחות בעדכון מהיר";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will always be shown on the Family tabs of the Quick Update form whether or not they already exist in the family's record.  For example, if MARR is in the list, then fields for marriage date and marriage place will always be shown on the form.<br />";
$pgv_lang["QUICK_ADD_FAMFACTS"]		= "הראה עובדות של משפחות בעדכון מהיר";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will be shown on the Family tabs of the Quick Update form.  Only the facts in this list will be shown on the form or made available for selection in the area where you add new facts on the form.<br />";
$pgv_lang["QUICK_REQUIRED_FACTS"]		= "הראה תמיד עובדות בעדכון מהיר";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]	= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will always be shown on the Quick Update form whether or not they already exist in the individual's record.  For example, if BIRT is in the list, fields for birth date and birth place will always be shown on the form.<br />";
$pgv_lang["QUICK_ADD_FACTS"]			= "הראה עובדות בעדכון מהיר";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will be shown on the Quick Update form.  Only the facts in this list will be shown on the form or made available for selection in the area where you add new facts on the form.<br />";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />When you add new members to a family, PhpGedView can supply default values for surnames according to regional custom.<br /><br /><ul><li>In the <b>Paternal</b> tradition, all family members share the father's surname.</li><li>In the <b>Spanish</b> and <b>Portuguese</b> tradition, children receive a surname from each parent.</li><li>In the <b>Icelandic</b> tradition, children receive their male parent's given name as a surname, with a suffix that denotes gender.</li><li>In the <b>Polish</b> tradition, all family members share the father's surname. For some surnames, the suffix indicates gender.  The suffixes <i>ski</i>, <i>cki</i>, and <i>dzki</i> indicate male, while the corresponding suffixes <i>ska</i>, <i>cka</i>, and <i>dzka</i> indicate female.</li></ul><br />";
$pgv_lang["ADVANCED_NAME_FACTS_help"] 	= "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will be shown on the add/edit name form.  If you use non-Latin alphabets such as Hebrew, Greek, Cyrillic or Arabic, you may want to add tags such as _HEB, ROMN, FONE, etc. to allow you to store names in several different alphabets.<br />";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] 	= "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />This is a comma separated list of GEDCOM fact tags that will be shown when you add or edit place names.  If you use non-Latin alphabets such as Hebrew, Greek, Cyrillic or Arabic, you may want to add tags such as _HEB, ROMN, FONE, etc. to allow you to store place names in several different alphabets.<br />";
$pgv_lang["USE_GEONAMES"]			= "השתמש במאגר נתונים GeoNames";
$pgv_lang["USE_GEONAMES_help"]			= "~#pgv_lang[USE_GEONAMES]#~<br /><br />Should the GeoNames database be used to provide more suggestions for place names?<br /><br />When this option is set to <b>#pgv_lang[yes]#</b>, the GeoNames database will be queried to supply suggestions for the place name being entered.  When set to <b>#pgv_lang[no]#</b>, only the current genealogical database will be searched.  As you enter more of the place name, the suggestion will become more precise.  This option can slow down data entry, particularly if your Internet connection is slow.<br /><br />The GeoNames geographical database is accessible free of charge. It currently contains over 8,000,000 geographical names.<br />";
$pgv_lang["AUTO_GENERATE_THUMBS"]		= "תמונות מזעריות שנוצרו בצורה אוטומטית";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]	= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Should the system automatically generate thumbnails for images that do not have them.  Your PHP installation might not support this functionality.<br />";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />This page provides extensive information about the server on which PhpGedView is being hosted.  Many configuration details about the server's software, as it relates to PHP and PhpGedView, can be viewed.<br />";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />This page collects all of the major topics of Configuration Help into one place.  You can view the information on your screen, or you can print it for later use.<br />";
$pgv_lang["more_help_advice"]			= "<br /><b>עזרה נוספת</b><br />עזרה נוספת זמינה ע\"י לחיצה על ה-<b>?</b> ליד פירטי הדף.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]			= "רוחב התמונות המזעריות שייווצרו";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />This is the width (in pixels) that the program will use when automatically generating thumbnails.  The default setting is 100.<br />";
$pgv_lang["SHOW_SOURCES"]			= "הצג מקורות";
$pgv_lang["SHOW_SOURCES_help"]		= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Set the privacy access level for all Sources.  If the user does not have access to Sources, the Source list will be removed from the Lists menu and the Sources tab will not be shown on the Individual Details page.<br />";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />If the option <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> is enabled this setting controls whether the admin must approve the registration.<br /><br />Setting this to <b>Yes</b> will require that all new users first verify themselves and then be approved by an admin before they can login.  With this setting on <b>No</b>, the <b>#pgv_lang[verified_by_admin]#</b> checkbox will be checked automatically when users verify their account, thus allowing an immediate login afterwards without admin intervention.<br />";
$pgv_lang["SPLIT_PLACES"]			= "פצל מקומות במצב עריכה";
$pgv_lang["SPLIT_PLACES_help"]			= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Set this to <b>Yes</b> to split each place name by commas into subfields for easier editing.  Example :<br /><ol><li>Default mode<br /><u>Place</u>: Half Moon Bay, San Mateo, California, USA<br /><br /></li><li>Split mode<br /><u>Country</u>: USA<br /><u>State</u>: California<br /><u>County</u>: San Mateo<br /><u>City</u>: Half Moon Bay</li></ol>";
$pgv_lang["ALLOW_REMEMBER_ME_help"]	= "~#pgv_lang[ALLOW_REMEMBER_ME]#~<br /><br />Many sites allow users to choose whether they want to be remembered from the same computer the next time they visit the site.  Enabling this option will put a <b>Remember Me</b> checkbox on the Login page.  When this checkbox is checked, PhpGedView has permission to store a cookie in the user's computer.  This cookie will allow PhpGedView to remember the user between visits from the same remote computer.<br />";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "קו מתחת לשמות בגרשיים";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Many programs will place the preferred given name in \"quotes\" in the GEDCOM.  The usual convention for this is to underline the preferred given name.  Enabling this option will convert any names surrounded by quotes to &lt;span&gt; with a CSS class of \"starredname\".<br /><br />For example, if the name in the GEDCOM were 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ enabling this option would change the part of the name enclosed in quotes to &lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt; for printing purposes.  Depending on other settings, the browser would then display that name as <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> or <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u> Charles</b><br />";
$pgv_lang["PRIVACY_BY_RESN"]			= "השתמש בהגבלת הפרטיות של (GEDCOM (RESN";
$pgv_lang["PRIVACY_BY_RESN_help"]		= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />The GEDCOM 5.5.1 specification includes the option of using RESN tags to set Privacy options for people and facts in the GEDCOM file.  Enabling this option will tell the program to look for level 1 RESN tags in GEDCOM records.  Level 2+ RESN tags are automatically applied and will not be affected by this setting.  Note that this might slow down some of the functions of PhpGedView such as the Individual list.<br />";
$pgv_lang["SHOW_LDS_AT_GLANCE"]		= "הראה קודי חוק המורמונים בתיבות התרשימים";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Setting this option to <b>Yes</b> will show status codes for LDS ordinances in chart boxes.<ul><li><b>B</b> - Baptism</li><li><b>E</b> - Endowed</li><li><b>S</b> - Sealed to spouse</li><li><b>P</b> - Sealed to parents</li></ul>A person who has all of the ordinances done will have <b>BESP</b> printed after their name.  Missing ordinances are indicated by <b>_</b> in place of the corresponding letter code.  For example, <b>BE__</b> indicates missing <b>S</b> and <b>P</b> ordinances.<br />";
$pgv_lang["GEDCOM_DEFAULT_TAB"]		= "חוצץ ברירת המחדל שיוצג על דף הנתונים האישיים";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />This option allows you to choose which tab opens automatically on the Individual page when that page is accessed.<br />";
$pgv_lang["SHOW_MARRIED_NAMES"]		= "הראה שמות נישואין ברשימת השמות";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />This option will show the married names of females on the Individual list.  This option requires that you calculate the married names when you import the GEDCOM file.<br />";
$pgv_lang["SHOW_QUICK_RESN"]			= "הראה שדות פרטיים על טופס #pgv_lang[quick_update_title]#";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />This option allows you to turn on or off the privacy fields on the #pgv_lang[quick_update_title]# form.  Privacy fields allow a user who is adding information through the form to override the default privacy for the fact they are entering.<br />";
$pgv_lang["USE_QUICK_UPDATE"]			= "השתמש בטופס #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />This option determines the user privileges required to submit changes through the #pgv_lang[quick_update_title]# form.<br /><br />The choice <b>#pgv_lang[nobody]#</b> means that this form cannot be used at all.<br />";
$pgv_lang["SEARCHLOG_CREATE"]		= "שמור קבצי לוג של החיפוש";
$pgv_lang["SEARCHLOG_CREATE_help"]		= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />How often should the program archive Searchlog files.<br />";
$pgv_lang["CHANGELOG_CREATE"]		= "שמור קבצי לוג של השינויים";
$pgv_lang["CHANGELOG_CREATE_help"]		= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />How often should the program archive Changelog files.<br />";
$pgv_lang["CHART_BOX_TAGS"]			= "נתונים אחרים שניתן להציג בתרשימים";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />This should be a comma or space separated list of facts, in addition to Birth and Death, that you want to appear in chart boxes such as the Pedigree chart.  This list requires you to use fact tags as defined in the GEDCOM 5.5.1 Standard.  For example, if you wanted the occupation to show up in the box, you would add \"OCCU\" to this field.<br />";
$pgv_lang["FULL_SOURCES"]			= "השתמש במקורות מלאים";
$pgv_lang["FULL_SOURCES_help"]			= "~#pgv_lang[FULL_SOURCES]#~<br /><br />Source citations can include fields to record the quality of the data (primary, secondary, etc.) and the date the event was recorded in the source.  If you don't use these fields, you can disable them when creating new source citations.<br />";
$pgv_lang["PREFER_LEVEL2_SOURCES"]		= "סוג מקור ";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]	= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />When adding new close relatives, you can add source citations to the records (e.g. INDI, FAM) or the facts (BIRT, MARR, DEAT).  This option controls which checkboxes are ticked by default.<br />";

//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]				= "בסיס GEDCOM";
$pgv_lang["media_conf"]				= "מולטימדיה";
$pgv_lang["media_general_conf"]			= "כללי";
$pgv_lang["media_firewall_conf"]			= "חומת מגן של מדיה";
$pgv_lang["accpriv_conf"]				= "גישה ופרטיות";
$pgv_lang["displ_conf"]				= "תצוגה ומבנה";
$pgv_lang["displ_names_conf"]			= "שמות";
$pgv_lang["displ_comsurn_conf"] 			= "שמות משפחה שכיחים";
$pgv_lang["displ_layout_conf"]			= "מבנה";
$pgv_lang["displ_hide_conf"]				= "הסתר והראה";
$pgv_lang["editopt_conf"]				= "אפשרויות העריכה";
$pgv_lang["useropt_conf"]				= "בחירות משתמש";
$pgv_lang["contact_conf"]				= "נתוני קשר";
$pgv_lang["meta_conf"]				= "מאפייני תצורה של האתר ותווי META";
$pgv_lang["gedconf_head"]				= "תצורת GEDCOM";
$pgv_lang["other_theme"]				= "אחר, הקלד";
$pgv_lang["performing_update"]			= "מבצע עדכון:";
$pgv_lang["config_file_read"]				= "קריאת קובץ תצורה";
$pgv_lang["does_not_exist"]				= "לא קיים";
$pgv_lang["media_drive_letter"]			= "אין לכלול בכתובת המדיה את האות של הכונן; יתכן והמדיה לא תוצג.";
$pgv_lang["db_setup_bad"]				= "התצורה הנוכחית שלך של מסד הנתונים אינה מתאימה. נא בדוק את הפרמטרים של קישוריות מסד הנתונים ועצב מחדש.";
$pgv_lang["bad_host_user_pass"]			= "PhpGedView was unable to make a connection to your MySQL database host.  Check the host, username, and password to make sure they are correct.";
$pgv_lang["bad_database_name"]			= "PhpGedView made a connection to your database host, but was unable to use the database with the name you entered.  Check that the database exists and that the username you entered has the appropriate permissions on that database.";
$pgv_lang["db"]					= "מסד נתונים";
//$pgv_lang["dbase"]					= "dBase";
$pgv_lang["current_gedcoms"]			= "GEDCOM-ים נוכחיים";
$pgv_lang["ged_gedcom"]				= "קובץ GEDCOM";
$pgv_lang["ged_title"]					= "כותרת GEDCOM";
$pgv_lang["ged_config"]				= "קובץ תצורה";
$pgv_lang["ged_search"]				= "קובצי לוג של החיפוש";
$pgv_lang["ged_change"]				= "קובצי לוג השינויים";
$pgv_lang["ged_privacy"]				= "קובץ פרטיות";
$pgv_lang["disabled"]					= "נפסל";
$pgv_lang["mouseover"]				= "עכבר עובר מעל";
$pgv_lang["mousedown"]				= "עכבר מושבת";
$pgv_lang["click"]					= "קליק עם עכבר";
$pgv_lang["enter_db_pass"]			= "עבור הגנה, עליך להכניס תמיד #pgv_lang[DBUSER]# ו#pgv_lang[DBPASS]# כאשר משנים את ערכי התצורה.";
$pgv_lang["server_url_note"]			= "זה צריך להיות ה-URL לתיקיית ה-PhpGedView שלך. שנה אותו רק אם אתה בטוח שאתה יודע מה שאתה עושה. PhpGedView חישב ערך <b><span dir=\"ltr\">#GUESS_URL#</span></b>";
$pgv_lang["DBTYPE"]				= "סוג מסד נתונים";
$pgv_lang["DBTYPE_help"]			= "~#pgv_lang[DBTYPE]#~<br /><br />The type of database to connect to.<br /><br />PhpGedView can use any database that has a PDO driver available.  You need to ensure that your php.ini file loads both the <b>php_pdo</b> library and the appropriate driver for your database, e.g. <b>php_pdo_mysql</b>.<br /><br />Most databases require a username and password.  You also need to create the database before installing PhpGedView. However, SQLite does not need #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, or #pgv_lang[DBPASS]#, but you will need to set a file path for your database in the #pgv_lang[DBNAME]# field.  PhpGedView will create the SQLite database file for you.<br />";
$pgv_lang["DBHOST"]			= "מארח מסד נתונים";
$pgv_lang["DBHOST_help"]			= "~#pgv_lang[DBHOST]#~<br /><br />The DNS or IP address of the computer hosting your database server.  This setting is ignored if you are using an SQLite database.<br />";
$pgv_lang["DBPORT"]			= "Port של מאגר מידע";
$pgv_lang["DBPORT_help"]			= "~#pgv_lang[DBPORT]#~<br /><br />The TCP Port that should be used when connecting to your database server.  Leave this setting blank to use the default port for your particular type of database.  This setting is ignored if you are using an SQLite database.<br />";
$pgv_lang["DBUSER"]			= "קוד משתמש של מסד נתונים";
$pgv_lang["DBUSER_help"]			= "~#pgv_lang[DBUSER]#~<br /><br />The database username required to login to your database.  This setting is ignored if you are using an SQLite database.<br />";
$pgv_lang["DBPASS"]				= "סיסמת מסד הנתונים";
$pgv_lang["DBPASS_help"]			= "~#pgv_lang[DBPASS]#~<br /><br />The database password for the user you entered in the #pgv_lang[DBUSER]# field.  This setting is ignored if you are using an SQLite database.<br />";
$pgv_lang["DBNAME"]			= "שם מסד הנתונים";
$pgv_lang["DBNAME_help"]			= "~#pgv_lang[DBNAME]#~<br /><br />The database in the server you want PhpGedView to use.<br /><br />The username you enter in the #pgv_lang[DBUSER]# field must have Create, Insert, Update, Delete, and Select privileges on this database.  In SQLite you need to set this to a file name in a directory that is writable by PHP such as your index directory (index/phpgedview.db).<br />";
$pgv_lang["TBLPREFIX_help"]		= "~#pgv_lang[TBLPREFIX]#~<br /><br />A prefix to prepend to the tables created by PhpGedView.  By changing this value you can set up multiple PhpGedView sites to use the same physical database but different tables.  For example, the same site could host a \"test\" as well as a \"production\" installation of PhpGedView with completely independent data tables.<br />";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />If you have an environment with multiple GEDCOMs, setting this value to <b>Yes</b> allows your site visitors <u>and</u> users to have the option of changing GEDCOMs.  Setting it to <b>No</b> disables GEDCOM switching for both visitors <u>and</u> logged in users.<br />";
$pgv_lang["upload_path"]			= "נתיב טעינה";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />This is the path where the GEDCOM file you wish to upload can be found. To select the path, click on <b>Browse</b> and navigate to your GEDCOM file and then click <b>Open</b>.";
$pgv_lang["gedcom_path"]			= "נתיב ושם קובץ ה-GEDCOM";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />There are two ways of importing your GEDCOM file into PhpGedView. They are:<ol><li>FTP the file to the server</li><li>Upload within PhpGedView</li></ol>When your file already exists on the server, you engage the <i>#pgv_lang[add_gedcom]#</i> procedure and fill in the path and name of your GEDCOM file as they exist on the server. The name can be with or without extension. If no extension is given, .ged will be assumed. The path is optional. If no path is given, the value of the <i>#pgv_lang[INDEX_DIRECTORY]#</i> option, as set in your PhpGedView site configuration, will be used.  Please note that on most servers, file and path names are case sensitive.<br /><br />When you engage the <i>#pgv_lang[upload_gedcom]#</i> procedure built into PhpGedView, you can use the <b>Browse</b> button to locate the desired file on your local computer. This can be a regular GEDCOM file or a ZIP file containing the GEDCOM file. PhpGedView will automatically extract and then use the GEDCOM file contained in that ZIP file.<br /><br />When uploading a file it is possible to specify an alternative path and/or filename to save it under on the server.<br /><br />See the <a href=\"readme.txt\">Readme.txt</a> file for more information.<br />";
$pgv_lang["CHARACTER_SET"]		= "סוג קידוד תווים";
$pgv_lang["CHARACTER_SET_help"]	= "~#pgv_lang[CHARACTER_SET]#~<br /><br />This is the character set of your GEDCOM file.  UTF-8 is the default and should work for almost all sites.  If you export your GEDCOM using IBM Windows encoding, you should put WINDOWS here.<br /><br />NOTE: PhpGedView can't support UNICODE (UTF-16) because the support is missing in PHP.<br />";
$pgv_lang["LANGUAGE"] 			= "שפה";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Assign the default language for the site.<br /><br />When the <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> option is set, users can override this setting through their browser's preferred language configuration, configuration options on their Account page, or through links or buttons on most PhpGedView pages.<br />";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "האם כל משתמש יכול לשנות שפה";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Set to <b>Yes</b> to allow users to override the site's default language.  They can do this through their browser's preferred language configuration, configuration options on their Account page, or through links or buttons on most PhpGedView pages.<br />";
$pgv_lang["CALENDAR_FORMAT"] 		= "מבנה לוח שנה";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Dates can be recorded in various calendars such as Gregorian, Julian, or the Jewish Calendar.  This option allows you to convert dates to a preferred calendar.  For example, you could select Gregorian to convert Julian and Hebrew dates to Gregorian.  The converted date is shown in parentheses after the regular date.<br /><br />Dates are only converted if they are valid for the calendar.  For example, only dates between 22&nbsp;SEP&nbsp;1792 and 31&nbsp;DEC&nbsp;1805 will be converted to the French Republican calendar and only dates after 15&nbsp;OCT&nbsp;1582 will be converted to the Gregorian calendar.<br /><br />Hebrew is the same as Jewish, but using Hebrew characters.  Arabic is the same as Hijri, but using Arabic characters.<br /><br />Note: Since the Jewish and Hijri calendar day starts at dusk, any event taking place from dusk till midnight will display as one day prior to the correct date.  The display of Hebrew and Arabic can be problematic in old browsers, which may display text backwards (left to right) or not at all.<br />";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "הראה אלפים בתאריך עברי";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Show Alafim in Hebrew calendars.<br /><br />Setting this to <b>Yes</b> will display the year 1969 as <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; while setting it to <b>No</b> will display the year as <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;.  This has no impact on the Jewish year setting.  The year will display as 5729 regardless of this setting.<br /><br />Note: This setting is similar to the PHP 5.0 Calendar constant CAL_JEWISH_ADD_ALAFIM.<br />";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]	= "הראה גרשיים בתאריך עברי";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Show single and double quotes when displaying Hebrew dates.<br /><br />Setting this to <b>Yes</b> will display February 8 1969 as <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; while setting it to <b>No</b> will display it as <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;.  This has no impact on the Jewish year setting since quotes are not used in Jewish dates displayed with Latin characters.<br /><br />Note: This setting is similar to the PHP 5.0 Calendar constants CAL_JEWISH_ADD_ALAFIM_GERESH and CAL_JEWISH_ADD_GERESHAYIM.  This single setting affects both.<br />";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	  = "הגייה אשכנזית";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Use Jewish Ashkenazi pronunciations.<br /><br />When set to <b>Yes</b> the months Cheshvan and Teves will be spelled with Ashkenazi pronunciation.  Setting it to <b>No</b> will change the months to Hesvan and Tevet.  This only affects the Jewish setting.  The Hebrew setting will always use the Hebrew alphabet.<br />";
//$pgv_lang["USE_RTL_FUNCTIONS"]		= "השתמש בעיבוד נתונים של שפות הנכתבות מימין לשמאל (RTL)";
//$pgv_lang["USE_RTL_FUNCTIONS_help"]		= "~#pgv_lang[USE_RTL_FUNCTIONS]#~<br /><br />Use processing to properly display GEDCOM data in RTL languages.  If set to <b>Yes</b> the database will be processed at runtime to ensure proper display of RTL data; this setting can slow down performance.<br />";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "מספר דורות באילן יוחסין";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Set the default number of generations to display on Descendancy and Pedigree charts.<br />";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]	= "מספר דורות מכסימלי באילן יוחסין";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Set the maximum number of generations to display on Pedigree charts.<br />";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "מכסימום דורות של צאצאים";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Set the maximum number of generations to display on Descendancy charts.<br />";
$pgv_lang["USE_RIN"]				= "השתמש במספר RIN במקום בקוד זיהוי של GEDCOM";
$pgv_lang["USE_RIN_help"]				= "~#pgv_lang[USE_RIN]#~<br /><br />Set to <b>Yes</b> to use the RIN number instead of the GEDCOM ID when asked for Individual IDs in configuration files, user settings, and charts.  This is useful for genealogy programs that do not consistently export GEDCOMs with the same ID assigned to each individual but always use the same RIN.<br />";
$pgv_lang["GENERATE_GUID"]              		= "צור בצורה אוטומטית קודי זיהוי גלובליים ייחודיים";
$pgv_lang["GENERATE_GUID_help"]         		= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> in this context is an acronym for ?Globally Unique ID?.<br /><br />GUIDs are intended to help identify each individual in a manner that is repeatable, so that central organizations such as the Family History Center of the LDS Church in Salt Lake City, or even compatible programs running on your own server, can determine whether they are dealing with the same person no matter where the GEDCOM originates.  The goal of the Family History Center is to have a central repository of genealogical data and expose it through web services. This will enable any program to access the data and update their data within it.<br /><br />If you do not intend to share this GEDCOM with anyone else, you do not need to let PhpGedView create these GUIDs; however, doing so will do no harm other than increasing the size of your GEDCOM.<br />";
$pgv_lang["PEDIGREE_ROOT_ID"]			= "אדם ברירת המחדל לאילן יוחסין ולתרשים צאצאים";
$pgv_lang["PEDIGREE_ROOT_ID_help"]		= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Set the ID of the default person to display on Pedigree and Descendancy charts.<br />";
$pgv_lang["GEDCOM_ID_PREFIX"]			= "קידומת קוד זיהוי אישי ";
$pgv_lang["GEDCOM_ID_PREFIX_help"]		= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />When a new individual record is added online in PhpGedView, a new ID for that individual will be generated automatically. The individual ID will have this prefix.<br />";
$pgv_lang["SOURCE_ID_PREFIX"]			= "קידומת קוד זיהוי של מקור";
$pgv_lang["SOURCE_ID_PREFIX_help"]		= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />When a new source record is added online in PhpGedView, a new ID for that source will be generated automatically.  The source ID will have this prefix.<br />";
$pgv_lang["REPO_ID_PREFIX"]			= "קידומת קוד זיהוי של מאגר";
$pgv_lang["REPO_ID_PREFIX_help"]		= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />When a new repository record is added online in PhpGedView, a new ID for that repository will be generated automatically. The repository ID will have this prefix.<br />";
$pgv_lang["PEDIGREE_FULL_DETAILS"]		= "הראה נתוני לידה ופטירה בתרשימים";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />This option controls whether or not to show the Birth and Death details of an individual on charts.<br />";
$pgv_lang["PEDIGREE_SHOW_GENDER"]		= "הראה צלמית מין בתרשימים";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]	= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />This option controls whether or not to show the individual's gender icon on charts.<br /><br />Since the gender is also indicated by the color of the box, this option doesn't conceal the gender. The option simply removes some duplicate information from the box.<br />";
$pgv_lang["PEDIGREE_LAYOUT"]			= "מבנה ברירת המחדל של אילן היוחסין";
$pgv_lang["PEDIGREE_LAYOUT_help"]		= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />This option indicates whether the Pedigree chart should be generated in landscape or portrait mode.<br />";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "הראה תיבות ריקות באילן היוחסין";
$pgv_lang["SHOW_EMPTY_BOXES_help"]		= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />This option controls whether or not to show empty boxes on Pedigree charts.<br />";
$pgv_lang["ZOOM_BOXES"]				= "אפשר הגדלה/הקטנה של תיבות התרשימים (ZOOM)";
$pgv_lang["ZOOM_BOXES_help"]			= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Allows a user to zoom boxes on charts to get more information.<br /><br />Set to <b>#pgv_lang[disabled]#</b> to disable this feature.  Set to <b>#pgv_lang[mouseover]#</b> to zoom boxes when the user mouses over the icon in the box.  Set to <b>#pgv_lang[click]#</b> to zoom boxes when the user clicks on the icon in the box.<br />";
$pgv_lang["LINK_ICONS"]				= "הופעת תיבות קישור בתיבת התרשימים";
$pgv_lang["LINK_ICONS_help"]			= "~#pgv_lang[LINK_ICONS]#~<br /><br />Allows the user to select links to other charts and close relatives of the person.<br /><br />Set to <b>#pgv_lang[disabled]#</b> to disable this feature.  Set to <b>#pgv_lang[mouseover]#</b> to popup the links when the user mouses over the icon in the box.  Set to <b>#pgv_lang[click]#</b> to popup the links when the user clicks on the icon in the box.<br />";
$pgv_lang["ABBREVIATE_CHART_LABELS"]	= "קצר תגים בתרשימים";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />This option controls whether or not to abbreviate labels like <b>Birth</b> on charts with just the first letter like <b>B</b>.<br /><br />You can customize the abbreviations by supplying overriding values in the <i>languages/extra.xx.php</i> file for each language.  For example, if you want to use <b>*</b> instead of <b>N</b> to abbreviate the BIRT fact in the French language, you should put the following entry into the <i>languages/extra.fr.php</i> file:<br /><br /><code>\$factAbbrev[\"BIRT\"]&nbsp;=&nbsp;\"*\";</code><br /><br />The lengths of abbreviations specified this way are not limited to 1 character.<br />";
$pgv_lang["SHOW_AGE_DIFF"]			= "הראה הפרשי תאריכים";
$pgv_lang["SHOW_AGE_DIFF_help"]		= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />This option controls whether or not the Close Relatives tab should show differences between birth dates of spouses, between marriage date and birth date of first child, and between birth dates of children.<br />";
$pgv_lang["SHOW_PARENTS_AGE"]		= "הראה את גיל ההורים ליד תאריך הלידה של הילד";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />This option controls whether or not to show age of father and mother next to child's birthdate on charts.<br />";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      	= "הראה מאורעות של קרובים על הדף האישי";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] 	= "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Births, marriages, and deaths of relatives are important events in one's life. This option controls whether or not to show these events on the <i>Personal facts and details</i> tab on the Individual page.<br /><br />The events affected by this option are:<ul><li>Death of spouse</li><li>Birth and death of children</li><li>Death of parents</li><li>Birth and death of siblings</li><li>Death of grand-parents</li><li>Birth and death of parents' siblings</li></ul><br />";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      	= "הרחב אוטומטית את רשימת המאורעות של קרובים";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] 	= "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />This option controls whether or not to automatically expand the <i>Events of close relatives</i> list.<br />";
$pgv_lang["EXPAND_SOURCES"]      		= "הרחב אוטומטית את המקורות";
$pgv_lang["EXPAND_SOURCES_help"] 		= "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />This option controls whether or not to automatically display content of a <i>Source</i> record on the Individual page.<br />";
$pgv_lang["EXPAND_NOTES"]      			= "הרחב אוטומטית את ההערות";
$pgv_lang["EXPAND_NOTES_help"] 		= "~#pgv_lang[EXPAND_NOTES]#~<br /><br />This option controls whether or not to automatically display content of a <i>Note</i> record on the Individual page.<br />";
$pgv_lang["SHOW_LEVEL2_NOTES"]     		= "הראה את כל ההתייחסויות להערות ומקורות בחוצצי הערות ומקורות";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] 	= "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />This option controls whether Notes and Source references that are attached to Facts should be shown on the Notes and Sources tabs of the Individual page.<br /><br />Ordinarily, the Notes and Sources tabs show only Notes and Source references that are attached directly to the individual's database record.  These are <i>level 1</i> Notes and Source references.<br /><br />The <b>#pgv_lang[yes]#</b> option causes these tabs to also show Notes and Source references that are part of the various Facts in the individual's database record.  These are <i>level 2</i> Notes and Source references because the various Facts are at level 1.<br />";
$pgv_lang["HIDE_LIVE_PEOPLE"]			= "אפשר פרטיות";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]		= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />This option will enable all privacy settings and hide the details of living people.<br /><br />Living people are defined to be those who do not have an event more recent than the number of years specified in variable \$MAX_ALIVE_AGE.  For this purpose, births of children are considered to be such events as well.<br />";
$pgv_lang["REQUIRE_AUTHENTICATION"] 	= "דרוש אשור מהמבקרים";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Enabling this option will force all visitors to login before they can view any data on the site.<br />";
$pgv_lang["PAGE_AFTER_LOGIN"]			= "הדף שיעלה אחרי התחברות";
$pgv_lang["PAGE_AFTER_LOGIN_help"]	= "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />Which page should users see after they have logged in?<br /><br />The choice made here determines whether a successful Login causes the Welcome or the MyGedView page to appear when the login is done from the #pgv_lang[welcome_page]#.<br /><br />A Login done from the link at the top of every other page will return the user to that page.<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "טכסט ברוכים הבאים על דף התחברות ";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Here you can choose text to appear on the login screen. You must determine which predefined text is most appropriate.<br /><br />You can also choose to enter your own custom Welcome text, but the text you enter will not be translated when your users change language.  However, if your custom text contains references to language variables that you can define in the various <i>languages/extra.xx.php</i> files, your site can show translated text.  Please refer to the Help text associated with the <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> field for more information.<br /><br />The predefined texts are:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br /></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "אין טכסט מוגדר מראש";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "טכסט מוכן מראש המודיע שכל המשתמשים יכולים לבקש קוד משתמש.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "טכסט מוכן מראש המודיע שהמנהלן יחליט אם לתת קוד משתמש";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "טכסט מוכן מראש המודיע שרק בני משפחה יכולים לבקש קוד משתמש.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "בחר טכסט ברוכים הבאים שיוקלד למטה.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "טכסט ברוכים הבאים מותאם";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />If you have opted for custom Welcome text, you can type that text here.  The text will NOT be translated into the language of the visitor, but will be shown exactly as you typed it.  However, if your custom text contains references to language variables that you can define in the various <i>languages/extra.xx.php</i> files, your site can show translated text.<br /><br />You can insert HTML tags into your custom Welcome text.<br /><br />The following description, taken from the Help text for the FAQ list, is equally applicable to the custom Welcome text.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] 	 = "כותרת סטנדרטית לטכסט ברוכים הבאים מותאם";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Choose to display a standard header for your custom Welcome text.  When your users change language, this header will appear in the new language.<br /><br />If set to <b>Yes</b>, the header will look look this:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]		= "הראה הסכם הגנה על פרטיות על הדף «בקש קוד משתמש חדש»";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]	= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />When set to <b>#pgv_lang[yes]#</b>, the following message will appear above the input fields on the «#pgv_lang[requestaccount]#» page:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"] 		= "בדוק תאריכי ילדים";
$pgv_lang["CHECK_CHILD_DATES_help"]		= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Check children's dates when determining whether a person is dead.  On older systems and large GEDCOMs this can slow down the response time of your site.<br />";
$pgv_lang["MAX_ALIVE_AGE"]			= "גיל שממנו מניחים שאדם ניפטר";
$pgv_lang["MAX_ALIVE_AGE_help"]			= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />If this person has any events other than Death, Burial, or Cremation more recent than this number of years, he is considered to be \"alive\".  Children's birth dates are considered to be such events for this purpose.<br />";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "לאפשר למשתמשים לראות נתוני קובץ GEDCOM";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Setting this to <b>Yes</b> will place links on individuals, sources, and families to let users bring up another window containing the raw data taken right out of the GEDCOM file.<br />";
$pgv_lang["ALLOW_EDIT_GEDCOM"]	= "אפשר עריכה מקוונת";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />This option enables online editing features for this database so that users with Edit privileges may update data online.<br />";
$pgv_lang["ENABLE_AUTOCOMPLETE"]	= "אפשר סיום אוטומטי";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"]	= "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />This option determines whether Autocomplete should be active while information is being entered into certain fields on input forms.  When this option is set to <b>#pgv_lang[yes]#</b>, text input fields for which Autocomplete is possible are indicated by a differently colored background.<br /><br />When Autocomplete is active, PhpGedView will search its database for possible matches according to what you have already entered.  As you enter more information, the list of possible matches is refined.  When you see the desired input in the list of matches, you can move the mouse cursor to that line of the list and then click the left mouse button to complete the input.<br /><br />The disadvantages of Autocomplete are that it slows the program, entails significant database activity, and also results in more data being sent to the browser.<br />";
$pgv_lang["EDIT_AUTOCLOSE"]		= "סגור אוטומטית חלון עריכה";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />This option controls whether or not to automatically close the Edit window after a successful update.<br />";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />The path to a readable and writable directory where PhpGedView should store index files (include the trailing \"/\").  PhpGedView does not require this directory's name to be \"index\".  You can choose any name you like.<br /><br />For security, this directory should be placed somewhere in the server's file space that is not accessible from the Internet. An example of such a structure follows:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />For the example shown, you would enter <b>../../dir4/dir5/dir6/index/</b> in this field.<br />";
$pgv_lang["POSTAL_CODE"]  		= "מיקום המיקוד";
$pgv_lang["POSTAL_CODE_help"] 		= "~#pgv_lang[POSTAL_CODE]#~<br /><br />Different countries use different ways to write the address. This option will enable you to place the postal code either before or after the city name.<br />";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "מספר מכסימלי של שמות משפחה אישיים";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Long lists of persons with the same surname can be broken into smaller sub-lists according to the first letter of the individual's given name.<br /><br />This option determines when sub-listing of surnames will occur.  To disable sub-listing completely, set this option to zero.<br />";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "מספר מכסימלי של שמות משפחה של משפחות";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Long lists of families with the same name can be broken into smaller sub-lists according to the first letter of the given name.<br /><br />This option determines when sub-listing of family names will occur.  To disable sub-listing completely, set this option to zero.<br />";
$pgv_lang["SURNAME_LIST_STYLE"]	= "סגנון רשימת שמות משפחה";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Lists of surnames, as they appear in the #pgv_lang[block_top10]# block, the #pgv_lang[individual_list]#, and the #pgv_lang[family_list]#, can be shown in different styles.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;In this style, the surnames are shown in a table that can be sorted either by surname or by count.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;In this style, the surnames are shown in a list, and the font size used for each name depends on the number of occurrences of that name in the database.  The list is not sortable.</li></ul><br />";
$pgv_lang["SHOW_ID_NUMBERS_help"]		= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />This option controls whether or not to show ID numbers in parentheses after person names on charts.<br />";
$pgv_lang["SHOW_LAST_CHANGE"]		= "הראה ברשימות את תאריך השינוי האחרון של רשומת ה-GEDCOM";
$pgv_lang["SHOW_LAST_CHANGE_help"]		= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />This option controls whether or not to show GEDCOM record last change date on lists.<br />";
$pgv_lang["SHOW_EST_LIST_DATES"]		= "הראה תאריכים מוערכים עבור לידה ופטירה";
$pgv_lang["SHOW_EST_LIST_DATES_help"]	= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />This option controls whether or not to show estimated dates for birth and death instead of leaving blanks on individual lists and charts for individuals whose dates are not known.<br />";
$pgv_lang["SHOW_PEDIGREE_PLACES"]		= "מספר הרמות של המקומות המוצגים בתיבות האישיות:";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />This sets how much of the place information is shown in the person boxes on charts.<br /><br />Setting the value to 9 will guarantee to show all place levels.  Setting the value to 0 will hide places completely.  Setting the value to 1 will show the first level, setting it to 2 will show the first two levels, etc.<br />";
$pgv_lang["MULTI_MEDIA"]				= "אפשר מאפיינים של מולטימדיה";
$pgv_lang["MULTI_MEDIA_help"]			= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1 allows you to link pictures, videos, and other multimedia objects into your GEDCOM.  If you do not include multimedia objects in your GEDCOM, you can disable the multimedia features by setting this value to <b>No</b>.<br /><br />See the Multimedia section in the <a href=\"readme.txt\">readme.txt</a> file for more information about including media in your site.<br />";
$pgv_lang["MEDIA_EXTERNAL"]			= "שמור קישורים";
$pgv_lang["MEDIA_EXTERNAL_help"]		= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />When a multimedia link is found starting with for example http://, ftp://, mms:// it will not be altered when set to <b>Yes</b>. For example, http://www.myfamily.com/photo/dad.jpg will stay http://www.myfamily.com/photo/dad.jpg.  When set to <b>No</b>, the link will be handled as a standard reference and the media depth will be used.  For example: http://www.myfamily.com/photo/dad.jpg will be changed to ./media/dad.jpg<br />";
$pgv_lang["MEDIA_DIRECTORY"]			= "תיקיית מולטימדיה";
$pgv_lang["MEDIA_DIRECTORY_help"]	    	= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />The path to a readable and writable directory where PhpGedView should store media files (include the trailing \"/\").  PhpGedView does not require this directory's name to be \"media\".  You can choose any name you like.<br /><br />Even though the Media Firewall feature lets you store media files in an area of the server's file space that is not accessible from the Internet, the directory named here must still exist and must be readable from the Internet and writable by PhpGedView.  For more information, please refer to the Media Firewall configuration options in the Multimedia section of the GEDCOM configuration page.<br />";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]		= "מספר הרמות של תיקיות מולטימדיה";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />A value of 0 will ignore all directories in the file path for the media object.  A value of 1 will retain the first directory containing this image.  Increasing the numbers increases number of parent directories to retain in the path.<br /><br />For example, if you link an image in your GEDCOM with a path like <b>C:\\Documents&nbsp;and&nbsp;Settings\\User\\My&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg</b>, a value of 0 will translate this path to <b>./media/grandpa.jpg</b>.  A value of 1 will translate this to <b>./media/Surname&nbsp;Line/grandpa.jpg</b>, etc.  Most people will only need to use a 0.  However, it is possible that some media objects kept in different directories have identical names and would overwrite each other when this option is set to 0.  Non-zero settings allow you to keep some organization in your media thereby preventing name collisions.<br />";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />If you have enabled multimedia in your site, you can have PhpGedView display a thumbnail image next to the person's name in charts and boxes.<br /><br />Currently, PhpGedView uses the first multimedia object listed in the GEDCOM record as the highlight image.  For people with multiple images, you should arrange the multimedia objects such that the one you wish to be highlighted appears first, before any others.<br /><br />See the Multimedia section in the <a href=\"readme.txt\">readme.txt</a> file for more information about including media in your site.<br />";
$pgv_lang["USE_THUMBS_MAIN"]			= "השתמש בתמונות מזעריות";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />This option determines whether PhpGedView should send the large or the small image to the browser whenever a chart or the Personal Details page requires a thumbnail.<br /><br />The <b>#pgv_lang[no]#</b> choice will cause PhpGedView to send the large image, while the <b>#pgv_lang[yes]#</b> choice will cause the small image to be sent.  Each individual image also has the &laquo;#factarray[_THUM]#&raquo; option which, when set to <b>#pgv_lang[yes]#</b>, will cause the large image to be sent regardless of the setting of the &laquo;#pgv_lang[USE_THUMBS_MAIN]#&raquo; option in the GEDCOM configuration.  You cannot force PhpGedView to send small images when the GEDCOM configuration specifies that large images should always be used.<br /><br />PhpGedView does not re-size the image being sent; the browser does this according to the page specifications it has also received.  This can have undesirable consequences when the image being sent is not truly a thumbnail where PhpGedView is expecting to send a small image.  This is not an error:  There are occasions where it may be desirable to display a large image in places where one would normally expect to see a thumbnail-sized picture.<br /><br />You should avoid setting the &laquo;#pgv_lang[USE_THUMBS_MAIN]#&raquo; option to <b>#pgv_lang[no]#</b>.  This choice will cause excessive amounts of image-related data to be sent to the browser, only to have the browser discard the excess.  Page loads, particularly of charts with many images, can be seriously slowed.<br />";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "הראה את שם הקובץ במציג המדיה";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />The Media Viewer can show the name of the Media file being viewed.  This option determines whether that file name is shown to users or not.<br /><br />You may want to hide the file name for security reasons.<br />";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "הראה קישור הורדה במציג המדיה";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />The Media Viewer can show a link which, when clicked, will download the Media file to the local PC.<br /><br />You may want to hide the download link for security reasons.<br />";
$pgv_lang["ENABLE_CLIPPINGS_CART"]		= "אפשר עגלת גזירות";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />The clippings cart allows users to add people to a temporary file that they can download in GEDCOM format for subsequent import into their genealogy software.<br />";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "החבא שגיאות GEDCOM";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Setting this to <b>Yes</b> will hide error messages produced by PhpGedView when it doesn't understand a tag in your GEDCOM file.  PhpGedView makes every effort to conform to the GEDCOM 5.5.1 standard, but many genealogy software programs include their own custom tags.  See the <a href=\"readme.txt\">readme.txt</a> file for more information.<br />";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "הוסף רווח במקום שההערות גלשו";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Some genealogy programs wrap notes at word boundaries while others wrap notes anywhere.  This can cause PhpGedView to run words together.  Setting this to <b>Yes</b> will add a space between words where they are wrapped in the original GEDCOM.<br />";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "הראה קישור לעזרה ע\"י סימן <b>?</b>";
$pgv_lang["SHOW_CONTEXT_HELP_help"]		= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />This option will enable links, identified by question marks, next to items on many pages.  These links allow users to get information or help about those items.<br />";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "הגבלת הימים באזור האירועים הקרובים";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] 	= "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Enter the maximum number of days to show in Upcoming Events blocks.  This number cannot be greater than 30. If you enter a larger value, 30 will be used.<br /><br />The value you enter here determines how far ahead PhpGedView looks when searching for upcoming events.  The results of this search, done once daily, are copied into a temporary file.<br /><br />No Upcoming Events blocks on Index or Portal pages can request more days than this value.  The larger you make this, the longer it will take to build the daily database extract, and the longer it will take to display the block, even when you request to display a number of days less than this setting.<br />";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "הכמות המינימאלית של מקרים כדי להיכלל ב-\"שמות המשפחה השכיחים\"";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"] = "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />This is the number of times that a surname must occur before it shows up in the Common Surname list on the Welcome page.<br />";
$pgv_lang["COMMON_NAMES_ADD"]		= "שמות שיש להוסיף לרשימת שמות המשפחה השכיחים (הפרד ע\"י פסיק)";
$pgv_lang["COMMON_NAMES_ADD_help"]		= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />If the number of times that a certain surname occurs is lower than the threshold, it will not appear in the list.  It can be added here manually.  If more than one surname is entered, they must be separated by a comma.  <b>Surnames are case-sensitive.</b><br />";
$pgv_lang["COMMON_NAMES_REMOVE"]		= "שמות שיש להסיר מרשימת שמות המשפחה השכיחים (הפרד ע\"י פסיק)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />If you want to remove a surname from the Common Surname list without increasing the threshold value, you can do that by entering the surname here.  If more than one surname is entered, they must be separated by a comma. <b>Surnames are case-sensitive.</b>  Surnames entered here will also be removed from the Top-10 list on the Welcome page.<br />";
$pgv_lang["HOME_SITE_URL"]		= "URL של האתר הראשי";
$pgv_lang["HOME_SITE_URL_help"]		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Each PhpGedView page includes a link to your main Home page.  The appearance of this link is controlled by the theme being used.  You enter the actual URL to your Home site here.<br />";
$pgv_lang["HOME_SITE_TEXT"]		= "טכסט של האתר הראשי";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />The legend used to identify the link to your main Home page.<br />";
$pgv_lang["CONTACT_EMAIL"]		= "הקשר לנתוני שושלת יוחסין";
$pgv_lang["CONTACT_EMAIL_help"]	= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />The person to contact about the genealogical data on this site.<br />";
$pgv_lang["CONTACT_METHOD"] 		= "שיטת הקשר";
$pgv_lang["CONTACT_METHOD_help"]	= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />The method to be used to contact the #pgv_lang[CONTACT_EMAIL]# about genealogy questions.<ul><li>The <b>#pgv_lang[mailto]#</b> option will create a \"mailto\" link that can be clicked to send an email using the mail client on the user's PC.</li><li>The <b>#pgv_lang[messaging]#</b> option will use a messaging system internal to PhpGedView, and no emails will be sent.</li><li>The <b>#pgv_lang[messaging2]#</b> option is the default.  It will use the PhpGedView messaging system and will also send copies of the messages via email.</li><li>The <b>#pgv_lang[messaging3]#</b> option allows PhpGedView to handle the messaging and will send the messages as emails, but will not store the messages internally.  This option is similar to the <b>#pgv_lang[mailto]#</b> option, except that the message will be sent by PhpGedView instead of the user's workstation.</li><li>The <b>#pgv_lang[no_messaging]#</b> option results in your users having no way of contacting you.</li></ul>";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "כתובת מענה עבור PhpGedView";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />E-mail address to be used in the &laquo;From:&raquo; field of e-mails that PhpGedView creates automatically.<br /><br />PhpGedView can automatically create e-mails to notify administrators of changes that need to be reviewed.  PhpGedView also sends notification e-mails to users who have requested an account.<br /><br />Usually, the &laquo;From:&raquo; field of these automatically created e-mails is something like <i>From: phpgedview-noreply@yoursite</i> to show that no response to the e-mail is required.  To guard against spam or other e-mail abuse, some e-mail systems require each message's &laquo;From:&raquo; field to reflect a valid e-mail account and will not accept messages that are apparently from account <i>phpgedview-noreply</i>.<br />";
$pgv_lang["WEBMASTER_EMAIL"]		= "הקשר הטכני";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />The person to be contacted about technical questions or errors encountered on your site.<br />";
$pgv_lang["SUPPORT_METHOD"] 		= "שיטת התמיכה";
$pgv_lang["SUPPORT_METHOD_help"]	= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />The method to be used to contact the #pgv_lang[WEBMASTER_EMAIL]# about technical questions.<ul><li>The <b>#pgv_lang[mailto]#</b> option will create a \"mailto\" link that can be clicked to send an email using the mail client on the user's PC.</li><li>The <b>#pgv_lang[messaging]#</b> option will use a messaging system internal to PhpGedView, and no emails will be sent.</li><li>The <b>#pgv_lang[messaging2]#</b> option is the default.  It will use the PhpGedView messaging system and will also send copies of the messages via email.</li><li>The <b>#pgv_lang[messaging3]#</b> option allows PhpGedView to handle the messaging and will send the messages as emails, but will not store the messages internally.  This option is similar to the <b>#pgv_lang[mailto]#</b> option, except that the message will be sent by PhpGedView instead of the user's workstation.</li><li>The <b>#pgv_lang[no_messaging]#</b> option results in your users having no way of contacting you.</li></ul>";
$pgv_lang["SHOW_FACT_ICONS"] 		= "הראה צלמיות של עובדות";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Set this to <b>#pgv_lang[yes]#</b> to display icons near Fact names on the #pgv_lang[personal_facts]# page.  Fact icons will be displayed only if they exist in the <i>images/facts</i> directory of the current theme.<br />";
$pgv_lang["FAVICON"]			= "צלמית של מועדפים";
$pgv_lang["FAVICON_help"]			= "~#pgv_lang[FAVICON]#~<br /><br />Change this to point to the icon you want to display in peoples' favorites menu when they bookmark your site.<br />";
$pgv_lang["THEME_DIR"]			= "תיקיית עיצוב";
$pgv_lang["THEME_DIR_help"]		= "~#pgv_lang[THEME_DIR]#~<br /><br />The directory where your PhpGedView theme files are kept.<br /><br />You may customize any of the standard themes that come with PhpGedView to give your site a unique look and feel.  See the Theme Customization section of the <a href=\"readme.txt\">readme.txt</a> file for more information.<br />";
$pgv_lang["TIME_LIMIT"] 			= "הגבלת זמן של PHP";
$pgv_lang["TIME_LIMIT_help"]		= "~#pgv_lang[TIME_LIMIT]#~<br /><br />The maximum time in seconds that PhpGedView should be allowed to run.<br /><br />The default is 1 minute.  Depending on the size of your GEDCOM file, you may need to increase this time limit when you need to build the indexes.  Set this value to 0 to allow PHP to run forever.<br /><br />CAUTION: Setting this to 0 or setting it too high could cause your site to hang on certain operating systems until the script finishes.  Setting it to 0 means it may never finish until a server administrator kills the process or restarts the server.  A large Pedigree chart can take a very long time to run; leaving this value as low as possible ensures that someone cannot crash your server by requesting an excessively large chart.<br />";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />The path to store PhpGedView session files.<br /><br />Some hosts do not have PHP configured properly and sessions are not maintained between page requests.  This option lets site administrators overcome that problem by saving files in one of their local directories.  The ./index/ directory is a good choice if you need to change this.  The default is to leave the field empty, which will use the Save path as configured in <i>php.ini</i>.<br />";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />If you use https or a port other than the default, you will need to enter the URL to access your server here.<br />";
$pgv_lang["LOGIN_URL"]			= "URL של התחברות";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br />You only need to enter a Login URL if you want to redirect to a different site or location when your users login.  This is very useful if you need to switch from http to https when your users login.  Include the full URL to <i>login.php</i>.  For example, https://www.yourserver.com/phpgedview/login.php .<br />";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />The time in seconds that a PhpGedView session remains active before requiring a login.  The default is 7200, which is 2 hours.<br />";
$pgv_lang["SHOW_STATS"] 			= "הצג סטטיסטיקות של העיבוד";
$pgv_lang["SHOW_STATS_help"]		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Show runtime statistics and database queries at the bottom of every page.<br />";
$pgv_lang["SHOW_COUNTER"] 		= "הראה מוני פגיעה";
$pgv_lang["SHOW_COUNTER_help"]	= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Show hit counters on Portal and Individual pages.<br />";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Gives visitors the option of registering themselves for an account on the site.<br /><br />The visitor will receive an email message with a code to verify his application for an account.  After verification, the Administrator will have to approve the registration before it becomes active.<br />";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Gives users the option of selecting their own theme.<br />";
$pgv_lang["PGV_SIMPLE_MAIL_help"] 	= "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />In normal mail headers for external mails, the email address as well as the name are used. Some mail systems will not accept this. When set to <b>Yes</b>, only the email address will be used.<br />";
$pgv_lang["PGV_SMTP_ACTIVE_help"] = "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Use SMTP to send e-mails from PhpGedView.<br /><br />This option requires access to an SMTP mail server.  When set to <b>#pgv_lang[no]#</b> PhpGedView will use the e-mail system built into PHP on this server.<br />";
$pgv_lang["PGV_SMTP_HOST_help"] = "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />This is the name of the SMTP mail server.  Example: <b>smtp.foo.bar.com</b>.<br />";
$pgv_lang["PGV_SMTP_HELO_help"] = "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />This is the domain part of a valid e-mail address on the SMTP server.<br /><br />For example, if you have an e-mail account such as <b>yourname@abc.xyz.com</b>, you would enter <b>abc.xyz.com</b> here.<br />";
$pgv_lang["PGV_SMTP_PORT_help"] = "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />The port number to be used for connections to the SMTP server.  Generally, this is port <b>25</b>.<br />";
$pgv_lang["PGV_SMTP_AUTH_help"] = "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Use name and password authentication to connect to the SMTP server.<br /><br />Some SMTP servers require all connections to be authenticated before they will accept outbound e-mails.<br />";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] = "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />The user name required for authentication with the SMTP server.<br />";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] = "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />The password required for authentication with the SMTP server.<br />";
$pgv_lang["PGV_SMTP_SSL_help"]		 = "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />Transport Layer Security (TLS) and Secure Sockets Layer (SSL) are Internet data encryption protocols.<br /><br />TLS 1.0, 1.1 and 1.2 are standardized developments of SSL 3.0. TLS 1.0 and SSL 3.1 are equivalent. Further work on SSL is now done under the new name, TLS.<br /><br />If your SMTP Server requires the TLS or SSL protocol during login, you should select the <b>#pgv_lang[yes]#</b> option.<br />";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] = "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Enter the name to be used in the &laquo;From:&raquo; field of e-mails originating at this site.<br /><br />For example, if your name is <b>John Smith</b> and you are the site administrator for a site that is  known as <b>Jones Genealogy</b>, you could enter something like <b>John Smith</b> or <b>Jones Genealogy</b> or even <b>John Smith, Administrator: Jones Genealogy</b>.  You may enter whatever you wish, but HTML is not permitted.<br />";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Enter a descriptive title to be displayed when users are choosing among GEDCOM datasets at your site.<br />";
$pgv_lang["LOGFILE_CREATE"]		= "גנוז קבצי יומן";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />How often should the program archive log files.<br />";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />The maximum amount of memory that can be consumed by PhpGedView scripts.  The default is 32 Mb.  Many hosts disable this option in their PHP configuration; changing this value may not actually affect the current maximum memory setting. <br />";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Specifies whether messages sent through PhpGedView can be stored in the database.  If set to <b>Yes</b> users will be able to retrieve their messages when they login to PhpGedView.  If set to <b>No</b> messages will only be emailed.<br />";
$pgv_lang["ALLOW_THEME_DROPDOWN"]	= "הראה את הבחירה הנגללת של שינויי העיצוב";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Gives users the option of selecting their own theme from a menu.<br /><br />Even with this option set, the theme currently in effect may not provide for such a menu.  To be effective, this option requires the <b>#pgv_lang[ALLOW_USER_THEMES]#</b> option to be set as well.<br />";
$pgv_lang["MAX_VIEW_RATE"]		= "שעור צפייה מכסימלי של דפים";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />This option limits the rate at which a user can view pages.<br /><br />If that rate is exceeded, PhpGedView treats the session as a hacking attempt;  the session will be terminated with a suitable message.  These two values should place a reasonable limit on the amount of bandwith and downloaded bytes from the server.  This feature can be switched off by setting the time interval to 0.<br />";
$pgv_lang["META_AUTHOR"]		= "תווית META של מחבר";
$pgv_lang["META_AUTHOR_help"]		= "~#pgv_lang[META_AUTHOR]#~<br /><br />The value to place in the Author meta tag in the HTML page header.  Leave this field empty to use the full name of the #pgv_lang[CONTACT_EMAIL]#.<br />";
$pgv_lang["META_AUTHOR_descr"]		= "השאר שדה זה ריק כדי להשתמש בשם המלא של #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]		= "תווית META של מוציא לאור";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />The value to place in the Publisher meta tag in the HTML page header.  Leave this field empty to use the full name of the #pgv_lang[CONTACT_EMAIL]#.<br />";
$pgv_lang["META_PUBLISHER_descr"]	= "השאר שדה זה ריק כדי להשתמש בשם המלא של #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]		= "תווית META של זכויות יוצרים";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />The value to place in the Copyright meta tag in the HTML page header.  Leave this field empty to use the full name of the #pgv_lang[CONTACT_EMAIL]#.<br />";
$pgv_lang["META_COPYRIGHT_descr"]	= "השאר שדה זה ריק כדי להשתמש בשם המלא של #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]		= "תווית META של תאור";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />The value to place in the Description meta tag in the HTML page header.  Leave this field empty to use the title of the currently active database.<br />";
$pgv_lang["META_DESCRIPTION_descr"]	= "השאר שדה זה ריק כדי להשתמש בכותרת של ה-GEDCOM הפעיל.";
$pgv_lang["META_PAGE_TOPIC"]		= "תווית META של נושא הדף";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />The value to place in the Page-topic meta tag in the HTML page header.  Leave this field empty to use the title of the currently active database.<br />";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "השאר שדה זה ריק כדי להשתמש בכותרת של ה-GEDCOM הפעיל עבור הערך זה.";
$pgv_lang["META_AUDIENCE"]		= "תווית META של קהל";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />The value to place in the Audience meta tag in the HTML page header.<br />";
$pgv_lang["META_PAGE_TYPE"]		= "תווית META של סוג הדף";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />The value to place in the Page-type meta tag in the HTML page header.<br />";
$pgv_lang["META_ROBOTS"]		= "תווית META של רובוטים";
$pgv_lang["META_ROBOTS_help"]		= "~#pgv_lang[META_ROBOTS]#~<br /><br />The value to place in the Robots meta tag in the HTML page header.  Some robots or web crawlers ignore this value.<br />";
$pgv_lang["META_REVISIT"]			= "תדירות ש-METACRAWLER-ים אמורים לבקר תווית META";
$pgv_lang["META_REVISIT_help"]		= "~#pgv_lang[META_REVISIT]#~<br /><br />The value to place in the Revisit meta tag in the HTML page header.  Some web crawlers ignore this value.<br />";
$pgv_lang["META_KEYWORDS"]		= "תווית META של מילות מפתח";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />The value to place in the Keywords meta tag in the HTML page header.  Some search engines will use the Keywords meta tag to help index your page.<br /><br />The #pgv_lang[common_surnames]# list that appears in the #pgv_lang[gedcom_stats]# block on your Welcome page can also be added to anything you enter here.<br />";
$pgv_lang["META_SURNAME_KEYWORDS"]	= "הוסף את שמות המשפחה השכיחים לשדה META של מילות מפתח";
$pgv_lang["META_SURNAME_KEYWORDS_help"]	= "~#pgv_lang[META_SURNAME_KEYWORDS]#~<br /><br />With this option set to <b>Yes</b> the surnames from the #pgv_lang[common_surnames]# list will be added to the Keywords meta field.  This can help search engines better find your site.<br />";
$pgv_lang["META_TITLE"]			= "הוסף לתג הכתרת TITLE";
$pgv_lang["META_TITLE_help"]		= "~#pgv_lang[META_TITLE]#~<br /><br />Anything on this line will be added to the TITLE tag in the HTML page header after the regular page title and before the PhpGedView credit.<br />";
$pgv_lang["ENABLE_RSS"]			= "אפשר RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />This option lets you disable the RSS feature.<br /><br />RSS lets users monitor your site for changes to the Index page without actually visiting your site periodically.  If too many users make use of this feature or if the refresh frequency set by these users is too high, RSS can use up too much bandwidth or server capacity.<br /><br />This <a href='http://en.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia article'><b>Wikipedia article</b></a> contains comprehensive information and links about RSS and the various RSS formats.<br />";
$pgv_lang["RSS_FORMAT"]			= "מבנה RSS";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />The format to be used as the default feed format for the site. The numeric suffixes <u>do not</u> indicate version: they identify formats.  For example, RSS 2.0 is not newer than RSS 1.0, but a different format. Feed readers should be able to read any format.<br /><br />This <a href='http://en.wikipedia.org/wiki/RSS' target='_blank'title='Wikipedia article'><b>Wikipedia article</b></a> contains comprehensive information and links about RSS and the various RSS formats.<br />";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "בדוק שקובצי ה-GEDCOM ניתנים להורדה";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />For security reasons, GEDCOM files should not be in a location where they can be directly downloaded, thus bypassing privacy checks. Clicking this link will check if your GEDCOM files can be downloaded over the network.<br /><br />On some systems this check has been known to take a really long time or not even complete.  If that is the case for you, then you should try to point your browser directly at your GEDCOM to see if it can be downloaded.<br />";
$pgv_lang["gedcom_download_secure"]	= "לא ניתן להוריד את קובץ #GEDCOM# .";
$pgv_lang["welcome_new2"]			= "<br /><br />מכיוון שאתה רואה דף זה, התקנת בהצלחה את PhpGedView על שרת האינטרנט שלך ואתה מוכן לעצב אותו לפי בחירתך.<br />";
$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~#pgv_lang[welcome_new2]#This Help page will guide you through the configuration process.  As you enter different fields, this window will provide you with help information about the field you are in.  You may close this window; to open it again click on one of the \"?\" question marks next to the field label.<br />";
$pgv_lang["return_editconfig"]			= "תוכל לחזור להגדרה זו מתי שתרצה ע\"י הצבעה של תוכנת הגלישה שלך על הקובץ <i>edit_config.php</i>, או ע\"י לחיצה על הקישור <b>תצורה</b> הנמצא בדף <b>ניהול של PhpGedView </b>.<br />";
$pgv_lang["return_editconfig_gedcom"]	= "תוכל לחזור להגדרה זו מתי שתרצה ע\"י לחיצה על קישור: <b>ערוך</b> הנימצאת בטבלת <b>#pgv_lang[current_gedcoms]#</b> על הדף <b>#pgv_lang[gedcom_adm_head]#</b> או ע\"י הפניית הדפדפן שלך לקובץ ה-<i>editconfig_gedcom.php</i>.<br />";
$pgv_lang["save_config"] 			= "שמור תצורה";
$pgv_lang["download_gedconf"]		= "הורד את תצורת GEDCOM.";
$pgv_lang["not_writable"]			= "גילינו ש-PHP לא יכול לכתוב על קובץ התצורה שלך. אתה יכול להשתמש בכפתור <b>#pgv_lang[download_file]#</b> כדי לשמור את ההגדרה שלך לתוך קובץ שאותו תוכל להעלות ידנית.";
$pgv_lang["upload_to_index"]			= "העלה את הקובץ לתיקיית האינדקסים שלך: ";
$pgv_lang["import_sql"]			= "בתיקיית האינדקס שלך יש קבצי SQL. מכיוון שיתכן שמקורם בכלי ההגירה של משתמשים, תוכל לייבא את הנתונים למאגר הנתונים שלך. האם לנסות לייבא את הקובץ למאגר המידע שלך עכשיו? כל הנתונים הקשורים למשתמשים (משתמשים, חדשות, מועדפים, מבנה האזורים וההודעות) ייעלמו ממאגר המידע שלך.<br /><br />אם תחליט להמשיך לייבא את הנתונים, PhpGedView יינשא לייבא את הנתונים. אם דבר זה לא מצליח, תתבקש להגדיר את המשתמש האדמיניסטרטיבי הראשוני.<br />";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "ערוך פרטיות";
$pgv_lang["edit_privacy_title"]			= "ערוך הגדרת פרטיות של GEDCOM";
$pgv_lang["save_changed_settings"]		= "שמור שינויים";
$pgv_lang["add_new_pp_setting"]		= "הוסף הגדרות חדשות לפרטיות לפי קוד זיהוי";
$pgv_lang["add_new_up_setting"]		= "הוסף הגדרה חדשה לפרטיות משתמש";
$pgv_lang["add_new_gf_setting"]		= "הוסף הגדרה חדשה לפרטיות ערכים כלליים";
$pgv_lang["add_new_pf_setting"]		= "הוסף הגדרה חדשה לפרטיות ערכים לפי קוד זיהוי";
$pgv_lang["file_read_error"]			= "ש ג י א ה!!! לא ניתן לקרוא קובץ פרטיות!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "ערוך הגדרות קיימות לפרטיות לפי קוד זיהוי";
$pgv_lang["edit_exist_user_privacy_settings"]	= "ערוך הגדרות קיימות לפרטיות משתמש";
$pgv_lang["edit_exist_global_facts_settings"]	= "ערוך הגדרות קיימות לפרטיות ערכים כלליים";
$pgv_lang["edit_exist_person_facts_settings"]	= "ערוך הגדרה קיימת של פרטיות ערכים אישיים";
$pgv_lang["general_privacy"]			= "ערכי פרטיות כלליים";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />You can have different Privacy settings for each GEDCOM on your PhpGedView web site.  Check under the page title whether you are editing the correct GEDCOM.<br /><br />You can override these general settings by using the other Privacy forms on the #pgv_lang[edit_privacy_title]# page.<br />#pgv_lang[more_help_advice]#";
$pgv_lang["person_privacy"]			= "ערכי פרטיות לפי קוד זיהוי";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />These settings allow administrators to override default privacy settings for a particular person, family, source, or media object.<br /><br />Suppose for example you have a child who died in infancy. Normally because the child is dead, its details would be shown to public users. However, you and everyone else in your family are still private. You don't want to remove the death record for the child but you want to hide the details and make them private. If this child had the ID of I100 you should enter the following privacy settings:<br />ID: I100<br />Show to: Show only to authenticated users<br /><br />This works the other way as well. If you wanted to make public the details of someone (ID I101) who you know to be dead but don't have a death date for, you could add the following:<br />ID: I101<br />Show to: Show to public<br />";
$pgv_lang["user_privacy"]			= "ערכי פרטיות של משתמשים";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />These settings give administrators the ability to override default privacy settings for individuals in the GEDCOM based on Username.  Suppose you don't want the Username <b>John</b> to be able to see any details of ID I100 in the GEDCOM, you could configure it like this:<br />Username: John<br />ID: I100<br />Show?: \"Hide\"<br /><br />and details for the specified individual would be hidden for the Username \"John\" only.<br /><br />To show the details of I101 (which usually would be hidden because I101 is still alive) to Username \"John\" set:<br /><br />Username: John<br />ID: I101<br />Show?: \"Show\"<br />";
$pgv_lang["global_facts"]			= "ערכי פרטיות של נתונים גלובליים";
$pgv_lang["global_facts_help"]		= "~#pgv_lang[global_facts]#~<br /><br />These settings define facts on a global level that should be hidden for all individuals in the GEDCOM.  This only applies to level 1 fact records such as BIRT or DEAT that will appear with their own headings on the personal facts and details tab of the individual page.<br /><ul><li>The <b>#pgv_lang[name_of_fact]#</b> element determines which fact should be hidden.</li><li>The <b>#pgv_lang[choice]#</b> element specifies the fact itself or related details.</li><li>The <b>#pgv_lang[accessible_by]#</b> element determines at what access level the fact is shown.</li></ul><br />This feature is meant to hide certain facts, identified by GEDCOM tags, for all individuals alive or dead. By default the SSN tag is hidden to public users. This is to prevent people from stealing social security numbers and committing identity theft of dead persons.  This is probably mostly relevant for the USA.<br /><br />If you wanted to hide all marriages from public users in your GEDCOM you could set:<br /><br /><b>#pgv_lang[name_of_fact]#</b> (MARR) - Marriage<br /><b>#pgv_lang[choice]#</b> \"#pgv_lang[fact_show]#\"<br /><b>#pgv_lang[accessible_by]#</b> \"#pgv_lang[PRIV_USER]#\"<br /><br /><b>#pgv_lang[name_of_fact]#</b> (MARR) - Marriage<br /><b>#pgv_lang[choice]#</b> \"#pgv_lang[fact_details]#\"<br /><b>#pgv_lang[accessible_by]#</b> \"#pgv_lang[PRIV_USER]#\"<br /><br />These settings would hide marriages and related details to everyone who wasn't an admin.<br /><br />Unlike all other settings, in <b>#pgv_lang[edit_exist_global_facts_settings]#</b> you can hide facts even from admin users. Unwanted facts are completely suppressed.<br />";
$pgv_lang["person_facts"]			= "ערכי פרטיות של נתונים לפי קוד זיהוי";
$pgv_lang["person_facts_help"]		= "~#pgv_lang[person_facts]#~<br /><br />These settings define facts that are hidden for a specific person, family, or source and the level at which they are hidden.  This only applies to level 1 fact records such as BIRT or DEAT that will appear with their own headings on the relevant details page  of the person, family, or source.<br /><br />The first element is the ID of the person, family, or source. The second element is the fact.  The <b>#pgv_lang[choice]#</b> element specifies the fact itself or related details.  The <b>#pgv_lang[accessible_by]#</b> element determines at what access level the fact is shown.  Not all facts shown in the list are applicable to all types of IDs.  For example, Birth and Death facts are not relevant to Source records.<br /><br />The \$person_facts array works the same as the \$global_facts array except that you also specify the GEDCOM ID of the person you want to hide facts for. You could, for example, hide the marriage record for a specific person.<br />";
$pgv_lang["accessible_by"]			= "הראה ל-";
$pgv_lang["hide"]				= "הסתר";
$pgv_lang["show_question"]			= "הראה?";
$pgv_lang["user_name"]			= "קוד משתמש";
$pgv_lang["name_of_fact"]			= "שם העובדה";
$pgv_lang["choice"]				= "בחירה";
$pgv_lang["fact_show"]			= "הראה את העובדה";
$pgv_lang["fact_details"]			= "הראה פרטי העובדה";
$pgv_lang["privacy_header"]			= "ערוך הגדרות פרטיות";
$pgv_lang["unable_to_find_privacy_indi"]	= "לא נימצא אדם עם קוד זיהוי";
$pgv_lang["save_and_import"]		= "-אחרי שתשמור תצורת הGEDCOM תצטרך לייבא את ה-GEDCOM ע\"י לחיצה על כפתור <b>ייבא GEDCOM</b> או ע\"י מעבר ל<b>ניהול->ניהול GEDCOM-ים->ייבא</b>";
$pgv_lang["help_info"]				= "ניתן לקבל עזרה ע\"י לחיצה על \"?\" אדום ליד כל תא.";
$pgv_lang["SHOW_LIVING_NAMES"]	= "הראה שמות של אנשים חיים";
$pgv_lang["SHOW_LIVING_NAMES_help"]	= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Should the names of living people be shown to the public?<br />";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]	= "הראה עזרה למחקר";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]	= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />What type of user can view the Research Assistant module if it is installed?<br />";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]	= "השתמש בפרטיות בקשרי משפחה";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>No</b> means that authenticated users can see the details of all living people.  <b>Yes</b> means that users can only see the private information of living people they are related to.<br /><br />This option sets the default for all users who have access to this genealogical database.  The Administrator can override this option for individual users by editing the user's account details.<br />";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]	= "אורך מכסימלי של נתיב קשר משפחתי";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />If the <i>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</i> option is enabled, logged-in users will only be able to see or edit individuals within this number of relationship steps.<br /><br />This option sets the default for all users who have access to this genealogical database.  The Administrator can override this option for individual users by editing the user's account details.<br />";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]	= "בדוק קשרי נישואין";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Check relationships that are related by marriage.<br />";
$pgv_lang["SHOW_DEAD_PEOPLE"]	= "הראה אנשים שנפטרו";
$pgv_lang["SHOW_DEAD_PEOPLE_help"] 	= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Set the privacy access level for all dead people.<br />";
$pgv_lang["select_privacyfile_button"]	= "בחר קובץ פרטיות";
$pgv_lang["PRIVACY_BY_YEAR"]		= "הגבל את הפרטיות לפי גיל האירוע";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />The <b>#pgv_lang[PRIVACY_BY_YEAR]#</b> setting will hide the details of people based on how old they were at specific events regardless of whether they are dead or alive.<br /><br />Use this setting along with the <b>#pgv_lang[MAX_ALIVE_AGE]#</b> setting.  For example, if you made the Age setting 100 and set this option to <b>Yes</b>, all persons, alive or dead, born less than 100 years ago would be set to private.  People who were married less than 85 years ago and people who died less than 75 years ago would also be marked as private.  Please note that using this option will slow down your performance somewhat.<br />";

// Google Translate
$pgv_lang["google_translate"]			= "Google&reg; Translation";
$pgv_lang["commit"]				= "בצע";
$pgv_lang["commit_google"]			= "מסור שינויים של Google&reg; Translation";
$pgv_lang["commit_google_help"]		= "~#pgv_lang[commit_google]#~<br /><br />כאשר לוחצים על הקישור, כל התרגומים   שמערכת Google&reg; Translation צברה ועדיין לא נשמרו ישמרו.<br /><br />האינדיקטור מראה התקדמות של פעולת השמירה.<br /><br />";
$pgv_lang["google_translate_help"]	= "~#pgv_lang[google_translate]#~<br /><br />This tool uses Google&reg; Translate to provide hints to the translator.  It is <b>not</b> intended to replace translations done by a person who fully understands the source and the target languages.    Please be aware also that the Google&reg; translate tool is neither reliable nor always able to perform a translation.<br /><br />When a language text has already been translated, there will be no link to Google&reg; Translate.<br /><br />For each text where you want to use the Google&reg; Translate tool, you click the <b>#pgv_lang[google_translate]#</b> link.  After the page is reloaded, you should correct the mistranslated entries by hand. <b>There is no guarantee that the Google&reg; translation will be correct.</b> You will need to correct special characters such as #, <, >, / and HTML tags as well as references to other language or global variables in the translated text so that the result matches the original untranslated text.  Note that Google&reg; Translate will add a space after each HTML tag.  You will definitely need to remove these extra spaces.<br /><br />When you are satisfied with the result, click <b>#pgv_lang[commit]#</b> to allow that result to be saved.  If you do not click <b>#pgv_lang[commit]#</b>, the changes will be accumulated until you click the <b>#pgv_lang[commit_google]#</b> link at the bottom of the page to commit all saved texts at once.<br /><br />";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />הדף מיועד לשמש מתרגמים. ניתן לתרגם, להשוות, ולייצא קבצי שפות. קיימת גם אפשרות לעזור למתרגם לקבוע את מקור הטכסט ש-PhpGedView מראה.<br /><br />ניתן להשתמש באפשרויות ותוכניות העזר הבאות:<br />";
$pgv_lang["edit_langdiff"]			= "ערוך תוכן קבצי השפות";
$pgv_lang["bom_check"]			= "בדיקת (Byte Order Mark (BOM";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#<br />";
$pgv_lang["bom_check_desc"]		= "בדיקה זו תנתח את כל קבצי השפה לגבי ה-(BOM (Byte Order Mark. אם ה-BOM ימצא, הוא ימחק מהקובץ המושפע. הקודים המיוחדים הללו עלולים לגרום לפעולה שגוייה בחלקים של PhpGedView.";
$pgv_lang["lang_debug"]			= "אופציית ניפוי באגים של טכסט עזרה";
$pgv_lang["lang_debug_help"]		= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br />";
$pgv_lang["lang_debug_desc"]		= "התרת האופציה מדפיסה שמות של משתני שפה שבשימוש בטכסט העזרה, בחלון הצץ של טכסט העזרה.<br />הוא עוזר למתרגמים לקבוע את שם המשתנה אם יש להתאים את הטכסט.<br />ההגדרה בתוקף רק בישיבת ה-PhpGedView הנוכחית שלך.";
$pgv_lang["lang_debug_use"]			= "השתמש באופציית ניפוי באגים של טכסט עזרה";
$pgv_lang["bom_not_found"]			= "אף BOM לא התגלה.";
$pgv_lang["bom_found"]			= "BOM נמצא ב-";
$pgv_lang["edit_lang_utility"]			= "תוכנת עריכה של קובץ שפה";
$pgv_lang["edit_lang_utility_help"]		= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#<br />";
$pgv_lang["edit_lang_utility_desc"]		= "ניתן להשתמש בתוכנת עזר זו בעריכת תוכן של קובץ שפה ע\"י שימוש בקובץ האנגלי.<br /><br />התוכנה מראה את התוכן של קובץ השפה האנגלית המקורי (יש תשעה קבצים כאלה) ובמקביל את התוכן של קובץ השפה הנבחרת שלך.  לחץ על ההודעה מתחת לגרסה האנגלית ואז יפתח חלון חדש, ובו תוכל לעדכן את הטכסט. ניתן לשמור את השינוי או לוותר עליו.";
$pgv_lang["edit_lang_utility_warning"]		= "CAUTION!<br /><br />If you use the <b>#pgv_lang[close_window_without_refresh]#</b> button, you might not see your changes on the screen until you do a manual page reload.  It's possible that your language file may be destroyed if you add a message which has not yet appeared inside the language file or if you just edit a message you have edited directly before.<br /><br />If you don't really know what you're doing, please do not use the <b>#pgv_lang[close_window_without_refresh]#</b> button.";
$pgv_lang["language_to_edit"]		= "שפת עריכה";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />In this list box you select the language whose messages you want to edit.<br />";
$pgv_lang["file_to_edit"]			= "סוג קובץ שפה לעריכה";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]		= "PhpGedView has implemented support for many different languages.  This has been achieved by keeping all text that is visible to users in files completely separate from the main program.  There is a set of eight files for each supported language, and the various texts have been separated into one of these files according to function.  <b>Not all language files need to be present.</b>  When a given text is not yet available in translated form, PhpGedView will always use the English version.<br /><br />The files in each language set are:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;This file contains terms and common expressions for use during the administration of PhpGedView and the genealogical databases.<br /><br /></li><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;This file contains Help text for use during configuration of PhpGedView.  The Help text is not intended to be viewed by ordinary users.<br /><br /></li><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;This is a list of country names, taken from the Web site of the Statistics Division, United Nations Department of Economic and Social Affairs.  This is the relevant <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a> to the English list.  The list is available in either English or French.<br /><br /></li><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;This file contains terms and common expressions for use during the editing of entries in the genealogical databases.<br /><br /></li><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;This file contains the textual equivalents of the GEDCOM Fact codes found in the GEDCOM 5.5.1 Standard.  It also contains additional Fact codes not found in the Standard but used by various genealogy programs.<br /><br />An English copy of the <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standard</b></a> can be downloaded in PDF (Portable Document Format).<br /><br /></li><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;This file is a set of <b>f</b>requently <b>a</b>sked <b>q</b>uestions that have been collected by the PhpGedView development team.  Each FAQ has two entries in this file.  One entry is the FAQ heading (usually the question), and the other is the FAQ body (usually the answer).  Replacements for the <b><i>faqlist.xx.php</i></b> files, which are updated frequently, may be downloaded from the PhpGedView home site.<br /><br />The administrator can use the FAQs in this file to build an FAQ list that is specific to his site.<br /><br /></li><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;This file contains Help text for ordinary users.  Some Help topics in this file address the needs of administrators, and are hidden from users who do not have Admin rights.<br /><br /></li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Many terms and common expressions are found in this file.</li></ul><br />PhpGedView also supports an optional ninth language file, <b><i>extra.xx.php</i></b>.  This file is always loaded after all the others and provides a means whereby a site administrator can override or alter any standard text in the selected language.  It can also be used to provide a title for the genealogical databases that varies according to the currently active language.<br /><br />The contents of this additional file are completely up to the site administrator;  this file will <b>never</b> be distributed with any version of PhpGedView.  The administrator should never make changes to the standard language files;  all local changes should be concentrated in this optional file.<br />";
$pgv_lang["check"]			= "בדוק";
$pgv_lang["lang_save"]		= "שמור";
$pgv_lang["contents"]			= "תוכן";
$pgv_lang["listing"]			= "רישום";
$pgv_lang["no_content"]		= "אין תוכן";
$pgv_lang["editlang"]			= "ערוך";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />ערוך הודעה מקובץ שפה.<br />";
$pgv_lang["savelang"]			= "שמור";
$pgv_lang["savelang_help"]		= "~#pgv_lang[savelang]#~<br /><br />שמור הודעה שנערכה בקובץ השפה.<br />";
$pgv_lang["original_message"]		= "הודעה מקורית";
$pgv_lang["message_to_edit"]		= "הודעה שרוצים לערוך";
$pgv_lang["changed_message"]		= "שנה תוכן";
$pgv_lang["message_empty_warning"]      	= "-> Warning!!! This message is empty in #LANGUAGE_FILE# &lt;-";
$pgv_lang["language_to_export"]		= "שפה שאותה רוצים לייצא";
$pgv_lang["language_to_export_help"]	= "~#pgv_lang[language_to_export]#~<br /><br />From this list box you can select the language whose messages you want to export.<br /><br />The routine currently only exports the contents of the <i>configure_help.xx.php</i>, <i>help_text.xx.php</i>, and <i>lang.xx.php</i> files.  The output is an HTML file that you can print from your browser.<br />";
$pgv_lang["export_lang_utility"]		= "תוכנת עזר ליצוא קובץ שפות";
$pgv_lang["export"]				= "יצא";
$pgv_lang["export_lang_utility_help"]		= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#<br />";
$pgv_lang["export_lang_utility_desc"]	= "ניתן ליצור תיעוד למנהלנים.<br /><br />כלי עזר זה ייצור גרסת HTML של קובץ העזרה של התצורה בשפה הנבחרת. תוכל להשתמש בדפדפן שלך כדי להסתכל על הקובץ הזה הנמצא במבנה להדפסה.";
$pgv_lang["export_ok"]			= "הודעות עזרה יוצאו";
$pgv_lang["compare_lang_utility"]		= "תוכנת השוואה של קובץ שפה";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#<br />";
$pgv_lang["compare_lang_utility_desc"]	= "כלי עזר זה משווה בין שני קבצי שפות ומספק רשימה של התוספות והחסרים ביניהם.<br /><br />קרא את הקבצי ה-CHANGELOG לגבי השינויים בגרסה האנגלית. קבצי האנגלית ישמשו יחוס לשפות האחרות.";
$pgv_lang["new_language"]			= "שפת המקור";
$pgv_lang["new_language_help"]		= "~#pgv_lang[new_language]#~<br /><br />From this list box you can select the language whose messages you want to compare with those of another language.<br /><br />All changes and additions to language files are first made to the <b>English</b> language files, so you would normally select English as one of the languages to compare.<br />";
$pgv_lang["old_language"]			= "שפה משנית";
$pgv_lang["old_language_help"]		= "~#pgv_lang[old_language]#~<br /><br />From this list box you can select the language which you want to compare with the language selected in the <b>Source</b> list box.<br /><br />After you have made your choice, click the <b>Compare</b> button to get a list of all additions and subtractions in all four files of both languages.<br /><br />To refresh your memory:<br /><b>Addition</b> means: It is <u>in</u> the Source file, but <u>not</u> in the Secondary file.<br /><br /><b>Subtraction</b> means: It is <u>not</u> in the Source file, but it <u>is</u> in the Secondary file.  This might happen when a given message is no longer used and therefore was removed from the English files.  You can safely remove the corresponding message from the secondary language files.<br />";
$pgv_lang["compare"]				= "השווה";
$pgv_lang["comparing"]			= "קבצי שפה שמושווים";
$pgv_lang["additions"]				= "הוספות";
$pgv_lang["no_additions"]			= "אין הוספות";
$pgv_lang["subtractions"]			= "הורדות";
$pgv_lang["no_subtractions"]			= "אין הורדות";
$pgv_lang["config_lang_utility"]		= "עיצוב השפות הנתמכות";
$pgv_lang["config_lang_utility_help"]		= "~#pgv_lang[config_lang_utility]#~<br /><br />This page is used to control what language choices are available to your users.  For example, you can set things up so that only German and French are available.  This might be useful if, for example, you are not able to communicate with your users in Hungarian.<br /><br />You also use this page to alter certain aspects of PhpGedView that depend on the selected language.  For example, here is where you tell PhpGedView how to format date and time fields.<br /><br />The languages that are active and greyed out cannot be disabled because they are in use. Look at the bottom table to see where the language is used. When a language is no longer used by the GEDCOM or user you will be able to disable it.<br /><br />All of your changes will be recorded in a new file called <b>lang_settings.php</b> created in the <b>#INDEX_DIRECTORY#</b> directory.  All of your further changes will be made to this new file and PhpGedView will use only <u>this</u> file.  You can revert to the original default language settings by deleting this file.<br /><br />If you must report problems with your language settings, please tell the PhpGedView support team whether this new file is present or not.<br />";
$pgv_lang["active"]				= "פעיל";
$pgv_lang["active_help"]			= "~#pgv_lang[active]#~<br /><br />Allow users to select this language if the option <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> is enabled.<br />";
$pgv_lang["edit_settings"]			= "ערוך סביבה";
$pgv_lang["lang_edit"]				= "ערך";
$pgv_lang["lang_language"]			= "שפה";
$pgv_lang["export_filename"]			= "שם קובץ הפלט:";
$pgv_lang["lang_back"]			= "חזור לתפריט הראשי כדי לערוך ולעצב קבצי השפות";
$pgv_lang["lang_back_admin"]		= "חזור לתפריט הניהול";
$pgv_lang["lang_back_manage_gedcoms"]	= "חזור לתפריט ניהול GEDCOM-ים";
$pgv_lang["lang_name_catalan"]		= "קטלאנית (ולנסית)";
$pgv_lang["lang_name_czech"]		= "צ'כית";
$pgv_lang["lang_name_chinese"]		= "סינית";
$pgv_lang["lang_name_danish"]		= "דנית";
$pgv_lang["lang_name_dutch"]		= "הולנדית";
$pgv_lang["lang_name_english"]		= "אנגלית";
$pgv_lang["lang_name_finnish"]		= "פינית";
$pgv_lang["lang_name_french"]		= "צרפתית";
$pgv_lang["lang_name_german"]		= "גרמנית";
$pgv_lang["lang_name_hebrew"]		= "עברית";
$pgv_lang["lang_name_hungarian"] 		= "הונגרית";
$pgv_lang["lang_name_indonesian"]		= "אינדונזית";
$pgv_lang["lang_name_italian"]		= "איטלקית";
$pgv_lang["lang_name_norwegian"]		= "נורבגית";
$pgv_lang["lang_name_polish"]		= "פולנית";
$pgv_lang["lang_name_portuguese"]		= "פורטוגזית";
$pgv_lang["lang_name_romanian"]		= "רומנית";
$pgv_lang["lang_name_russian"]		= "רוסית";
$pgv_lang["lang_name_serbian-la"]		= "סרבית (אותיות לטיניות)";
$pgv_lang["lang_name_spanish"]		= "ספרדית";
$pgv_lang["lang_name_spanish-ar"]		= "ספרדית (אמריקה הלטינית)";
$pgv_lang["lang_name_swedish"]		= "שוודית";
$pgv_lang["lang_name_turkish"]		= "טורקית";
$pgv_lang["lang_name_greek"]		= "יוונית";
$pgv_lang["lang_name_arabic"]		= "ערבית";
$pgv_lang["lang_name_lithuanian"]		= "ליטאית";
$pgv_lang["lang_name_vietnamese"]		= "ויאטנמית";
$pgv_lang["lang_name_slovak"]		= "סלובקית";
$pgv_lang["lang_name_slovenian"] 		= "סלובנית";
$pgv_lang["lang_name_estonian"]		= "אסטונית";
$pgv_lang["lang_new_language"]		= "שפה חדשה";
$pgv_lang["original_lang_name"]		= "שם המקורי של השפה ב#D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~Original name of language~<br /><br />How is this language named in this language?<br /><br />English calls itself <b>English</b>;  German calls itself <b>Deutsch</b>;  Dutch calls itself <b>Nederlands</b>;  Czech calls itself <b>Ceština</b>, etc.<br />";
$pgv_lang["lang_shortcut"]			= "סימון מקוצר לשפה בשם קובץ שפה";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />This code defines an abbreviation for the language name.  This abbreviation forms part of the name of each of the language files used by PhpGedView.  For example, the abbreviation used for French is <b>fr</b>, and consequently the file names for French are <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i>, and <i>lang.<b>fr</b>.php</i><br />";
$pgv_lang["lang_langcode"]			= "קודי השפה";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />These codes allow PhpGedView to detect the Preferred Language setting of the browser being used. PhpGedView determines the language actually being requested by the browser by matching the browser's language code against this list.  Individual list entries must be separated by a semicolon.<br />";
$pgv_lang["lang_filenames"]			= "קבצי שפות";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]				= "קובץ הדגל";
$pgv_lang["flagsfile_help"]			= "~#pgv_lang[flagsfile]#~<br /><br />Name of the national flag image file for the selected language.<br /><br />Images for many countries are available from <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a> site.<br /><br />When you find a flag image you like, right-click on it and save the image in a temporary folder. Next, open the saved image with a suitable image editor (IrfanView is recommended for Windows systems), reduce its size 50x32 pixels, which is the normal size used in PhpGedView, and then save it as a GIF file to the <i><b>images/flags</b></i> folder.<br /><br />Although you can use any name you wish, you should select a name consistent with the two-letter language shortcut.  For example, Croatian is represented by the two-letter code <i><b>hr</b></i>, so the Croatian flag would normally be named <i><b>hr.gif</b></i>.<br />";
$pgv_lang["text_direction"]			= "כיוון הטכסט";
$pgv_lang["text_direction_help"]		= "~#pgv_lang[text_direction]#~<br /><br />Identifies which direction is used to write text in the chosen language.  Most languages are written from left to right.  Arabic and Hebrew are examples of languages that are written in the opposite direction (right to left).<br />";
$pgv_lang["date_format"]			= "מבנה תאריך";
$pgv_lang["date_format_help"]   		= "~#pgv_lang[date_format]#~<br /><br />This field defines the date format to be used by PhpGedView when displaying dates from the database. You can use either the <b>Standard</b> or the <b>Advanced</b> format.<ul><li><b>Standard</b><br />The following codes are used to represent different elements of the date.  Note that <b>D</b> and <b>M</b> have different meanings in the <b>Advanced</b> format.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;day of the month, without leading zeros; i.e. 1 to 31<br /><b>M</b>&nbsp;&nbsp;month name; i.e. January, February, etc.<br /><b>Y</b>&nbsp;&nbsp;full year, for example, 1999 or 44B.C.<br /><b>R</b>&nbsp;&nbsp;Calendar conversion.  Please see the topic <b>Calendar Conversion</b> below for a description of this code.</p>These codes can be combined in any order, along with spaces and punctuation.  For example, suppose your GEDCOM contains the date 20&nbsp;AUG&nbsp;1965.<p style=\"padding-left: 25px\">An <b>English</b> user could set the format to <b>D&nbsp;M&nbsp;Y</b> to get <b>20&nbsp;August&nbsp;1965</b>.<br />An <b>American</b> user could set the format to <b>M&nbsp;D,&nbsp;Y</b> to get <b>August&nbsp;20,&nbsp;1965</b><br />A <b>German</b> user could set the format to <b>D.&nbsp;M&nbsp;Y</b> to get <b>20.&nbsp;August&nbsp;1965</b><br />A <b>Hungarian</b> user could set the format to <b>Y.&nbsp;M&nbsp;D.</b> to get <b>1965.&nbsp;augusztus&nbsp;20.</b></p><br /></li><li><b>Advanced</b><br />More complex formatting options are available.  If your date format includes a letter other than <b>D</b>, <b>M</b>, <b>Y</b>, or <b>R</b>, it will be assumed to use the <b>Advanced</b> format.<br /><br />The following codes are used to represent different elements of the date.  Note that <b>D</b> and <b>M</b> have different meanings in the <b>Standard</b> format.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;day of the month, with leading zeros; i.e. 01 to 31<br /><b>j</b>&nbsp;&nbsp;day of the month, without leading zeros; i.e. 1 to 31<br /><b>S</b>&nbsp;&nbsp;ordinal suffix for the day number; for example, the letters <b>th</b> in <b>4th&nbsp;July</b>.<br /><b>l</b> (lower-case \"L\")&nbsp;&nbsp;day of the week; i.e. Monday, Tuesday, etc.<br /><b>D</b>&nbsp;&nbsp;abbreviated day of the week; i.e. M, Tu, W, Th, F, Sa, Su<br /><b>N</b>&nbsp;&nbsp;ISO day number; i.e. 0 to 6<br /><b>w</b>&nbsp;&nbsp;numeric day number; i.e. 1 to 7<br /><b>z</b>&nbsp;&nbsp;day of the year; i.e 1 to 365<br /><b>F</b>&nbsp;&nbsp;month name; i.e. January, February, etc.<br /><b>M</b>&nbsp;&nbsp;abbreviated month, i.e. Jan, Feb, etc.<br /><b>m</b>&nbsp;&nbsp;month number, with leading zeros; i.e. 01 to 12<br /><b>n</b>&nbsp;&nbsp;month number, without leading zeros; i.e. 1 to 12<br /><b>Y</b>&nbsp;&nbsp;full year, for example, 1999 or 44B.C.<br /><b>y</b>&nbsp;&nbsp;abbreviated year.  Some calendars allow years to be abbreviated.  For the Jewish calendar this is the year without the thousands.  For the Gregorian calendar this is the same as the full year.<br /><b>R</b>&nbsp;&nbsp;Calendar conversion.  Please see the topic <b>Calendar Conversion</b> below for a description of this code.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;internal GEDCOM format</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;calendar code, e.g. @#DGREGORIAN@, @#DHEBREW@, etc.<br /><b>A</b>&nbsp;&nbsp;day, i.e. 01 to 31<br /><b>O</b>&nbsp;&nbsp;month, e.g. JAN, FEB, MAR, etc.<br /><b>E</b>&nbsp;&nbsp;year, e.g. 1776, 1867, 2007, etc.<br /><br />To see the unconverted dates, use <b>A&nbsp;O&nbsp;E</b> or <b>@&nbsp;A&nbsp;O&nbsp;E</b></p><b>Some examples</b>, using the date 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;Sep&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = W&nbsp;8&nbsp;September&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;Sep&nbsp;65<br /><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = Wednesday&nbsp;-&nbsp;08&nbsp;-&nbsp;September&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"] 		= "For example, the date format <b>Y.m.d&nbsp;R</b> could prod uce <b>1805.04.26&nbsp;(XIII.08.06)</b>.  The output of the <b>R</b> formatting code is enclosed in parentheses to distinguish it from the regular date.<br /><br />The behavior of this code is similar to the <b>French</b> Calendar option in the GEDCOM configuration.  The difference between the two is that the <b>R</b> code, being defined at the Language Configuration level, works only on selected languages but across all GEDCOMs on the site.  The <b>French</b> Calendar option, set at the GEDCOM Configuration level, works on all languages but only on the GEDCOMs for which that option has been set.<br /><br />The <b>R</b> formatting code is considered to be normal text when the date format contains only <b>D</b>, <b>M</b>, and <b>Y</b> codes as described in the topic <b>Standard format</b> above.  In other words, for the <b>R</b> code to be recognized, the date format needs to contain a code from the <b>Advanced format</b> list that doesn't appear in the <b>Standard format</b> list.<br /><br />For example, the date format <b>D&nbsp;M&nbsp;Y&nbsp;R</b> will produce <b>13&nbsp;October&nbsp;1797&nbsp;R</b> in English for the date 13&nbsp;OCT&nbsp;1797. If, on the other hand, the date format were <b>j&nbsp;F&nbsp;Y&nbsp;R</b>, the same date would result in <b>13&nbsp;October&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> in English.<br /><br /><br /></li><li><b>Language alternatives</b>&nbsp;&nbsp;&nbsp;The abbreviated texts for the <b>Advanced format</b> codes D and M are set in the file <i>languages/lang.xx.php</i>, using  statements like <code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";</code> and <code>\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br />These can be changed by using a <i>languages/extra.xx.php</i> file as described in Wiki and ReadMe text for language adjustments, for example:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code><br /><br /><br /></li><li><b>Localization</b>&nbsp;&nbsp;&nbsp;Special formatting rules exist for a number of languages, particularly declension of month endings according to how the date is phrased.  These special rules are implemented in the various <i>includes/extras/functions.xx.php</i> files.</li></ul>";
$pgv_lang["time_format"]			= "מבנה זמן";
$pgv_lang["time_format_help"]		= "~#pgv_lang[time_format]#~<br /><br />This field defines the time format to be used by PhpGedView.<br /><br />Symbols you can use are:<br /><b>a</b> - lowercase Ante meridiem and Post meridiem; i.e. <b>am</b> or <b>pm</b><br /><b>A</b> - uppercase Ante meridiem and Post meridiem; i.e. <b>AM</b> or <b>PM</b><br /><b>B</b> - Swatch Internet time; i.e. <b>000</b> through <b>999</b><br /><b>c</b> - ISO 8601 date (added in PHP 5); e.g. <b>2004-02-12T15:19:21+00:00</b><br /><b>d</b> - day of the month, 2 digits, leading zero; i.e. <b>01</b> to <b>31</b><br /><b>D</b> - day, textual, three letters; e.g. <b>Mon</b><br /><b>F</b> - month, textual, long; e.g. <b>January</b><br /><b>g</b> - hour, 12-hour format, no leading zero; i.e. <b>1</b> through <b>12</b><br /><b>G</b> - hour, 24-hour format, no leading zero; i.e. <b>0</b> through <b>23</b><br /><b>h</b> - hour, 12-hour format, leading zero; i.e. <b>01</b> through <b>12</b><br /><b>H</b> - hour, 24-hour format, leading zero; i.e. <b>00</b> through <b>23</b><br /><b>i</b> - minutes, leading zero; i.e. <b>00</b> to <b>59</b><br /><b>I</b> (capital \"i\") - daylight saving time indicator; <b>1</b> if Daylight Saving Time, <b>0</b> otherwise.<br /><b>j</b> - day of the month, no leading zero; i.e. <b>1</b> to <b>31</b><br /><b>l</b> (lowercase \"L\") - day of the week, textual, long; e.g. <b>Friday</b><br /><b>L</b> - leap year indicator; <b>1</b> if it is a leap year, <b>0</b> otherwise.<br /><b>m</b> - month, numeric, leading zero; i.e. <b>01</b> through <b>12</b><br /><b>M</b> - month, textual, 3 letters; e.g. <b>Jan</b><br /><b>n</b> - month, numeric, no leading zero; i.e. <b>1</b> through <b>12</b><br /><b>O</b> (capital \"o\") - difference between local and Greenwich time (GMT) in hours; e.g. <b>+0200</b><br /><b>r</b> - RFC 2822 formatted date; e.g. <b>Thu,&nbsp;21&nbsp;Dec&nbsp;2000nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - seconds, leading zero; i.e. <b>00</b> through <b>59</b><br /><b>S</b> - day of the month suffix, English only, 2 characters; i.e. <b>st</b>, <b>nd</b>, <b>rd</b> or <b>th</b>. Works well with <b>j</b><br /><b>t</b> - number of days in the given month; i.e. <b>28</b> through <b>31</b><br /><b>T</b> - time zone setting of this machine; e.g. <b>CEST</b>, <b>EST</b>, <b>MDT</b><br /><b>U</b> - seconds since the start of the Unix Epoch (January&nbsp;1&nbsp;1970&nbsp;00:00:00 GMT)<br /><b>w</b> - day of the week, numeric; i.e. <b>0</b> (for Sunday) through <b>6</b> (for Saturday)<br /><b>W</b> - ISO-8601 week number of year, weeks starting on Monday; e.g. <b>42</b> (the 42nd week in the year)<br /><b>Y</b> - year, 4 digits; e.g. <b>1999</b><br /><b>y</b> - year, 2 digits; e.g. <b>99</b><br /><b>z</b> - day of year, numeric, no leading zeros; i.e. <b>0</b> (1 Jan) through <b>364</b> (31 Dec when not a leap year) or <b>365</b> (31 Dec in leap years)<br /><b>Z</b> - time zone offset in seconds.  The offset for time zones west of Greenwich is always negative, and for those east of Greenwich the offset is always positive. i.e. <b>-43200</b> through <b>43200</b><br /><br />You can change the order of these symbols, and you can add delimiters to the format.<br /><br />For example, in German this field normally contains <b>H:i:s</b> to produce a display like <b>09:01:25</b>. English usually defines the time format as <b>g:i:sa</b> to produce a display like <b>9:01:25am</b>.<br /><br />In the 24-hour system, midnight is 00:00.  In the 12-hour system, midnight is 12:00am and noon is 12:00pm.<br />";
$pgv_lang["week_start"]		= "יום תחילת השבוע";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />The day of the week that starts a new week in this language.  Most languages start the week on Sunday, but some start on Monday or other days.<br />";
$pgv_lang["name_reverse"]		= "שם משפחה קודם";
$pgv_lang["name_reverse_help"]	= "~#pgv_lang[name_reverse]#~<br /><br />In some languages the surname should be displayed first instead of the default to display it last.  Enabling this option will display the surname first.  Hungarian, Chinese, and Japanese are examples where the surname (the family name) is usually given first.<br />";
$pgv_lang["ltr"]				= "שמאל לימין";
$pgv_lang["rtl"]				= "ימין לשמאל";
$pgv_lang["file_does_not_exist"]	= "שגיאה! הקובץ לא קיים...";
$pgv_lang["optional_file_not_exist"]	= "קובץ בחירה זה אינו קיים.";
$pgv_lang["alphabet_upper"]		= "אותיות עיליות";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Upper case alphabet letters in this language.  This alphabet is used while sorting lists of names.<br />";
$pgv_lang["alphabet_lower"]		= "אותיות קטנות";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Lower case alphabet letters in this language.  This alphabet is used while sorting lists of names.<br />";
$pgv_lang["multi_letter_alphabet"]	= "אלף בית של צרוף אותיות";
$pgv_lang["multi_letter_alphabet_help"] = "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Multi-letter combinations that are to be treated as a single distinct letter when sorting lists of names and titles in this language.<br /><br />Some languages, Hungarian and Slovak for example, consider certain combinations of letters to be distinct letters in their own right.  The order in which you specify these letter combinations determines the order in which they are inserted into the normal alphabet during sorting.  This is important when several multi-letter combinations have the same first letter.  Except for <b>ch</b>, these letter combinations are inserted into the normal alphabet according to their first letter.  <b>ch</b> is always inserted after <b>h</b>.<br />";
$pgv_lang["multi_letter_equiv"]		= "תוים שהם ריבוי אותיות";
$pgv_lang["multi_letter_equiv_help"]	= "~#pgv_lang[multi_letter_equiv]#~<br /><br />In some languages, multiple letters are often treated as equivalent to a single letter when generating lists of names.<br /><br />For example, in Dutch, names beginning with IJ are listed together with names beginning with Y. In Norwegian, names beginning with AA are listed with &Aring;. In some languages, there are letters that can be written as one character or two. For example in Slovakian, the two characters D and \xC5\xBE can be written as the single character \xC7\x85. By specifying equivalents here, you can allow names beginning with these letters to be grouped together on the individual list pages.<br /><br />You should specify a comma-separated list of equivalents. To support databases that don't recognize UTF-8 encoding, you should specify both upper and lower case equivalents. This example demonstrates the format to use.<br /><br />Aa=&Aring;,aa=&aring;";
$pgv_lang["dictionary_sort"]		= "השתמש בכללי המילון למיון";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />This option controls how characters with diacritic marks are handled when sorting lists of names and titles.<br /><br />When set to <b>#pgv_lang[yes]#</b>, all characters with diacritic marks are treated as if they did not have any marks.  Diacritic marks are considered only when the two words being considered are otherwise identical.  When set to <b>#pgv_lang[no]#</b>, all letters are distinct, regardless of the presence or absence of diacritic marks.<br />";
$pgv_lang["collation"]		= "סדר נתוני בסיס הנתונים שהומר collation";
$pgv_lang["collation_help"]	= "~#pgv_lang[collation]#~<br /><br />If you are using the database's built-in collation rules, this option specifies the collation sequence to use for this language.  You should ensure that your database supports all the collation sequences you intend to use.<br /><br />The use of database collation is controlled in the site configuration settings.<br />";
$pgv_lang["lang_config_write_error"]	= "שגיאה בכתיבת הגדרת השפה לתוך קובץ <b>lang_settings.php</b>. בדוק הרשאות ונסה שנית.";
$pgv_lang["translation_forum"]		= "פורום התרגומים של PhpGedView על SourceForge";
$pgv_lang["translation_forum_help"]		= "~#pgv_lang[translation_forum]#~<br /><br />#pgv_lang[translation_forum_desc]#<br />";
$pgv_lang["translation_forum_desc"]		= "<a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=\"_blank\"><b>הקישור הזה</b></a> פותח חלון גלישה חדש. אתה תופנה לפורום התרגום של PhpGedView ובו תוכל לשוחח על בעיות מיוחדות הקשורות לתרגומים.";
$pgv_lang["lang_set_file_read_error"]	= "ש ג י א ה !!!לא הצליח לקרא את <b>lang_settings.php</b>!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "תוכל להשתמש בתת מערכת זו כדי להוסיף שפה חדשה שעדיין לא נתמכת ב-PhpGedView.<br /><br />תוכל להגדיר את ההגדרות הסטנדרטיות של השפה החדשה. הן כוללות את קודי השפה, כיוון השפה, תחילת השבוע עבור השפה, מבנה השעה, אלף בית וכו'.<br /><br />תקבל עזרה נוספת על ההגדרות של השפות אשר נתמכות ב-PhpGedView אחרי שתבחר את השפה ותלחץ על כפתור ה-<b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />עזרה נוספת קיימת על דף העיצוב של השפה.<br />";
$pgv_lang["add_new_lang_button"]		= "הוסף שפה חדשה";
$pgv_lang["hide_translated"]			= "הסתר מה שתורגם";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />If set to <b>Yes</b> you will only see those messages of your selected language file which have not been translated.  This means the new message does <u>not</u> appear in the target language file.<br /><br />Some language files contain English text for various untranslated messages.  This routine cannot identify these untranslated items, since they already are present in the target file.  The assumption is, \"If the message is present in the target file, it must have been translated.\"<br />";
$pgv_lang["lang_file_write_error"]		= "ש ג י א ה  !!!<br /><br />לא ניתן לכתוב את השינויים בקובץ השפה הנבחר!<br />בדוק הרשאות כתיבה על <b>#lang_filename#</b>";
$pgv_lang["no_open"]				= "ש ג י א ה !!!<br /><br />לא ניתן לפתוח את הקובץ  <b>#lang_filename#</b>";
$pgv_lang["users_langs"]			= "שפות המשתמשים";
$pgv_lang["configured_languages"]		= "השפות שבשימוש";

//-- User Migration Tool messages
$pgv_lang["um_header"] 			= "כלי להגירת נתוני משתמשים";
$pgv_lang["um_proceed"] 			= "בחר אופציה או לחץ על הקישור למטה כדי לחזור לתפריט הניהול<br />";
$pgv_lang["um_creating"] 			= "יוצר";
$pgv_lang["um_sql_index"] 			= "כלי זה יצור <i>authenticate.php</i> ומספר קבצי <i>.dat</i> בתיקיית ה-index שלך.<br /><br />לאחר יצירה מוצלחת תוכל לעבור לצורת האינדקס עם כל המשתמשים הנוכחיים והודעותיהם, מועדפים, חדשות ומבנה ה-MyGedView זמינים.<br /><br />שים לב: לאחר מעבר לצורת אינדקס יש לייבא שוב את קבצי ה-GEDCOM.<br />";
$pgv_lang["um_file_create_fail1"] 		= "יצירת קובץ חדש נכשלה - קיים כבר קובץ בשם הזה:";
$pgv_lang["um_file_create_fail2"] 		= "לא ניתן ליצר";
$pgv_lang["um_file_create_fail3"] 		= "בדוק הרשאות גישה לתיקיה הזו.";
$pgv_lang["um_file_create_succ1"] 		= "קובץ חדש נוצר בהצלחה:";
$pgv_lang["um_file_not_created"] 		= "קובץ לא נוצר.";
$pgv_lang["um_nomsg"] 			= "נראה שאין הודעות במערכת.";
$pgv_lang["um_nofav"] 			= "נראה שאין מועדפים במערכת.";
$pgv_lang["um_nonews"] 			= "נראה שאין חדשות במערכת.";
$pgv_lang["um_noblocks"] 			= "נראה שאין אזורים במערכת.";
$pgv_lang["um_index_sql"] 			= "כלי זה ייבא <i>authenticate.php</i> וקבצי <i>.dat</i> אחרים מתיקית ה-index שלך למאגר המידע שלך.<br />";
$pgv_lang["um_noaction"] 			= "אין צורך בפעולה כלשהי להגירת נתוני משתמשים לצורת SQL.<br /><br />כאשר תעבור לצורת SQL, תצטרך להפעיל שנית את כלי הגירת המשתמשים כדי לייבא את כל הנתונים למאגר נתוני SQL.  PhpGedView ישתמש בקבצים הקיימים בצורת האינדקס.<br /><br /><b><u>אין</u> למחוק <i>authenticate.php</i> וקבצי <i>.dat</i> מתיקיית ה- index שלך בזמן המעבר.</b><br />";
$pgv_lang["um_import"] 			= "ייבא";
$pgv_lang["um_export"] 			= "ייצא";
$pgv_lang["um_explain"] 			= "כלי זה ייבא או ייצא נתוני משתמשים בין טבלאות SQL לבין קבצי צורת אינדקס.<br /><br />נתוני משתמשים, מועדפים, הגדרות של אזורים, הודעות וחדשות יהיו שוב זמינים לאחר ההגירה.<br /><br /><b>זהירות</b><br />לא ניתן להשתמש בכלי זה להגירת נתונים בין מהדורות שונות של PhpGedView. וודא שהנתונים מועברים בים מהדורות זהות של PhpGedView.<br /><br /><b>ייבוא</b><br />אם תבחר לייבא קבצי נתוני משתמשים מצורת אינדקס, אז כל נתוני המשתמשים בטבלאות מאגר הנתונים <b>ידרסו</b>. הכלי <b>אינו</b> מאחד את הנתונים. לאחר הרצת היבוא לא ניתן עוד לשחזר את המידע הישן על ידי PhpGedView.<br /><br /><b>ייצוא</b><br />אם אתה מייצא נתוני משתמשים ממאגר נתוני SQL שלך לקובצי צורת אינדקס, הכלי יבנה קבצי <i>authenticate.php</i> ומספר קבצי <i>.dat</i> בתיקיית ה-index. קבצים בעלי שם זהה שכבר קיימים <u>לא</u> ידרסו; <u>חייבים</u> להסירם ידנית. לאחר מעבר לצורת אינדקס, כל המידע יהיה זמין מידית.<br /><br /><b>הערה:</b> לאחר מעבר לצורת אינדקס, עליך לייבא שוב את קבצי ה-GEDCOM שלך.<br />";
$pgv_lang["um_tool_help"] 			= "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] 		= "~הסב משתמשים מצורת SQL לצורת אינדקס~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] 		= "~הסב משתמשים מצורת אינדקס לצורת SQL~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] 			= "מייבא משתמשים";
$pgv_lang["um_imp_blocks"] 			= "מייבא אזורים";
$pgv_lang["um_imp_favorites"] 		= "מייבא מועדפים";
$pgv_lang["um_imp_messages"] 		= "מייבא הודעות";
$pgv_lang["um_imp_news"] 			= "מייבא חדשות";
$pgv_lang["um_nousers"] 			= "קובץ <i>authenticate.php</i> לא נמצא בתיקיית ה-index שלך. ההגירה מבוטלת.";
$pgv_lang["um_imp_succ"] 			= "היבוא עבר בהצלחה";
$pgv_lang["um_imp_fail"] 			= "היבוא נכשל";
$pgv_lang["um_backup"] 			= "גיבוי";
$pgv_lang["um_zip_succ"] 			= "קובץ ZIP נוצר בהצלחה.";
$pgv_lang["um_zip_dl"] 			= "הורד קובץ גיבוי במבנה ZIP ";
$pgv_lang["um_bu_explain"] 			= "כלי זה יכול ליצור גיבוי לסוגי נתונים שונים של PhpGedView.<br /><br />הנתונים שתחליט לגבות יאספו בקובץ ZIP, שאותו תוכל להוריד על ידי לחיצה על הקישור בתחתית הדף לאחר שהגיבוי יסתיים בהצלחה.<br /><br />קובץ ה-ZIP ישמר בתיקיית ה-Index שלך עד שתסיר אותו בצורה ידנית.<br />";
$pgv_lang["um_bu_help"] 			= "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] 			= "קובץ תצורה של PhpGedView";
$pgv_lang["um_bu_gedcoms"] 		= "קבצי GEDCOM";
$pgv_lang["um_bu_gedsets"] 			= "קבצי הגדרות, תצורה ופרטיות של GEDCOM";
$pgv_lang["um_bu_logs"] 			= "מוני GEDCOM, קבצי לוג של חיפוש וקבצי לוג של PhpGedView";
$pgv_lang["um_bu_usinfo"] 			= "הגדרות משתמש, הגדרות אזורים, מועדפים, הודעות, חדשות";
$pgv_lang["um_bu_media"]			= "קובצי מדיה";
$pgv_lang["um_mk_bu"] 			= "צור גיבוי";
$pgv_lang["um_nofiles"] 			= "לא נמצאו קבצים לגיבוי.";
$pgv_lang["um_files_exist"] 			= "קובץ אחד או יותר קיימים כבר. האם אתה רוצה לעלות עליהם?";
$pgv_lang["um_results"]			= "תוצאות";
$pgv_lang["preview_faq_item"] 		= "הצגה מוקדמת של כל ישויות FAQ";
$pgv_lang["preview_faq_item_help"] 		= "~#pgv_lang[preview_faq_item]#~<br />This option lets an admin user view the FAQ page without all the editing options and links.<br /><br /> Except for a single <b>Edit</b> link above the first FAQ item, the appearance of the FAQ page will be identical to what an ordinary user would see. This special <b>Edit</b> link will restore full Edit functionality to the FAQ page.<br />";
$pgv_lang["restore_faq_edits"] 		= "שחזר פונקציונאליות של עריכת FAQ";
$pgv_lang["restore_faq_edits_help"] 		= "~#pgv_lang[restore_faq_edits]#~<br />This option restores the FAQ page to what an admin user normally sees, so that individual FAQ items may be edited.<br />";
$pgv_lang["add_faq_item"] 			= "הוסף ישות שאלות נפוצות (FAQ)";
$pgv_lang["add_faq_item_help"] 		= "~#pgv_lang[add_faq_item]#~<br />This option will let you add an item to the FAQ page.<br />";
$pgv_lang["edit_faq_item"] 			= "ערוך ישות FAQ";
$pgv_lang["edit_faq_item_help"] 		= "~#pgv_lang[edit_faq_item]#~<br />This option will let you edit an item on the FAQ page.<br />";
$pgv_lang["delete_faq_item"] 			= "מחק ישותם FAQ";
$pgv_lang["delete_faq_item_help"] 		= "~#pgv_lang[delete_faq_item]#~<br />This option will let you delete an item from the FAQ page<br />";
$pgv_lang["moveup_faq_item"] 		= "העבר ישות FAQ למעלה";
$pgv_lang["moveup_faq_item_help"] 		= "~#pgv_lang[moveup_faq_item]#~<br />This option will let you move an item upwards on the FAQ page.<br /><br />Each time you use this option, the FAQ Position number of this item is reduced by one.  You can achieve the same effect by editing the item in question and changing the FAQ Position field.  When more than one FAQ item has the same position number, only one of these items will be visible.<br />";
$pgv_lang["movedown_faq_item"] 		= "העבר ישות FAQ למטה";
$pgv_lang["movedown_faq_item_help"]	= "~#pgv_lang[movedown_faq_item]#~<br />This option will let you move an item downwards on the FAQ page.<br /><br />Each time you use this option, the FAQ Position number of this item is increased by one.  You can achieve the same effect by editing the item in question and changing the FAQ Position field.  When more than one FAQ item has the same position number, only one of these items will be visible.<br />";
$pgv_lang["add_faq_header_help"] 		= "~#pgv_lang[add_faq_header]#~<br />This is the title or subject of the FAQ item.<br /><br />What you enter here can be formatted. HTML tags such as &lt;b&gt; and &lt;br /&gt; are allowed, as are HTML entities such as &amp;amp; and &amp;nbsp;.  HTML tags other than &lt;br /&gt; are probably not very useful in the FAQ title and should be avoided.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["add_faq_body_help"] 		= "~#pgv_lang[add_faq_body]#~<br />The text of the FAQ item is entered here.<br /><br />The text can be formatted. HTML tags such as &lt;b&gt; and &lt;br /&gt; are allowed, as are HTML entities such as &amp;amp; and &amp;nbsp;.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["add_faq_HTML"] 			= "HTML entities are a very easy way to add special characters to your FAQ titles and text.  You can use symbolic names, decimal numbers, or hexadecimal numbers.  A complete list of HTML entities, their coding, and their representation by your browser can be found here:  <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">HTML entity lists</a><br /><br />On occasion, you may need to show a Tilde character&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;or a Number Sign&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;in your URLs or text.  These characters have a special meaning to the PhpGedView Help system and can only be entered in their hexadecimal or decimal form.  Similarly, the&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;and&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;characters that usually enclose HTML tags must be entered in their hexadecimal or decimal forms if they are to be treated as normal text instead of signalling an HTML tag.<ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;or&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;will result in&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b>&nbsp;&nbsp;or&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;will result in&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;or&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;will result in&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;&nbsp;or&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;will result in&nbsp;&nbsp;<b>&#x7E;</b></li></ul>There is a&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;HTML entity, but this symbol is not interpreted as a Tilde when coded in URLs.";
$pgv_lang["add_faq_pgvLangRefs"] 		= "You can insert references to entries in the language files or to values of global variables.  Examples: <ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;is a reference to the language variable \$pgv_lang[\"add_to_cart\"], and if it were to appear in this field, would show as <b>#pgv_lang[add_to_cart]#</b> when the FAQ list is viewed in the current language.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;is a reference to the Fact name \$factarray[\"AFN\"], and if it were to appear in this field, would show as <b>#factarray[AFN]#</b> when the FAQ list is viewed in the current language. </li><li><b>&#x23;GLOBALS[VERSION]&#x23;&nbsp;&#x23;GLOBALS[VERSION_RELEASE]&#x23;</b>&nbsp;&nbsp;&nbsp;is a reference to the global variable \$VERSION, a space, and a reference to the global variable \$VERSION_RELEASE, and if they were to appear in this field, would show as <b>#GLOBALS[VERSION]#&nbsp;#GLOBALS[VERSION_RELEASE]#</b> when the FAQ list is viewed in the current language.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;is a reference to the global variable \$GEDCOM, which is the name of the current GEDCOM file.  If it were to appear in this field, it would show as <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp;is a reference to the global variable \$GEDCOM_TITLE, which is the title of the current GEDCOM file.  If it were to appear in this field, it would show as <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />This feature is useful when you wish to create FAQ lists that are different for each language your site supports.  You should put your customized FAQ list titles and entries into the <i>languages/extra.xx.php</i> files (<i>xx</i> is the code for each language), using the following format:<br />\$pgv_lang[\"faq_title1\"] 		= \"This is a sample FAQ title\";<br />\$pgv_lang[\"faq_body1\"] = \"This is a sample FAQ body.\";<br />";
$pgv_lang["add_faq_order_help"] 		= "~#pgv_lang[add_faq_order]#~<br />This field controls the order in which the FAQ items are displayed.<br /><br />You do not have to enter the numbers sequentially.  If you leave holes in the numbering scheme, you can insert other items later.  For example, if you use the numbers 1, 6, 11, 16, you can later insert items with the missing sequence numbers.  Negative numbers and zero are allowed, and can be used to insert items in front of the first one.<br /><br />When more than one FAQ item has the same position number, only one of these items will be visible.<br />";
$pgv_lang["add_faq_visibility_help"] 		= "~#pgv_lang[add_faq_visibility]#~<br />You can determine whether this FAQ will be visible regardless of GEDCOM, or whether it will be visible only to the current GEDCOM.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;The FAQ will appear in all FAQ lists, regardless of GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;The FAQ will appear only in the currently active GEDCOM's FAQ list.</li></ul><br />";
$pgv_lang["index_gedcom_news_adm_help"]= "אזור החדשות של ה-GEDCOM מאפשר שימוש ב<b>תווי וכניסות HTML</b>.<br /> אין להשתמש ב-HTML לכותרות של חדשות.<br /><br />חשוב תמיד להשתמש בתוויות התחלה וסיום. למנהלני האתר דרושה הבנה בסיסית של HTML.התוכנית משתמשת גם ב-<b>גיליונות סגנון - (Style Sheets (CSS </b>לכל עיצוב יש CSS משלו. תוכל להשתמש במשפחות - classes מה-CSS הללו כדי לשלוט בסגנון ההופעה של הודעתך.<br /><br />אם תזדקק לעזרה נוספת על נושא זה, באתר PhpGedView יש דוגמאות איך להשתמש בתווים הללו לאזור חדשות ה-GEDCOM שלך.<br /><br />בדומה לרשימת שאלות נפוצות  FAQ, הכותרות והטכסטים של חדשות מאפשרות הפניות משובצותGEDCOM embedded למשתני \$pgv_lang, \$factarray, ו-\$GLOBALS כדי לספק גמישות מושלמת ביצירת פרטי חדשות שיהיו רגישים לשפה הפעילה כעת.<br /><br />התיאור הבא נלקח מטכסט העזרה של רשימת שאלות הנפוצות ומתאים בצורה דומה equally applicable לפרטי החדשות של  GEDCOM.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />The maximum time the import is allowed to run for processing the GEDCOM file.";

// Media items
//$pgv_lang["media_import_help"] 		= "~#pgv_lang[media_import]#~<br />This import will convert the multimedia links in your GEDCOM file to multimedia records. For example, the following media entry will be changed from:<blockquote><code>1 OBJE<br />2 FORM jpg<br />2 FILE media/grandma.jpg<br />2 TITL Picture of grandma</code></blockquote>to:<blockquote><code>0 @M1@ OBJE<br />1 FORM jpg<br />1 FILE media/grandma.jpg<br />1 TITL Picture of grandma</code></blockquote>The new multimedia record will be stored separately in the database. Links to external multimedia files will be changed to references to the new multimedia record, which will in turn contain a reference to the external file. For example, the following GEDCOM record will be changed from:<blockquote><code>0 @I1@ INDI<br />1 NAME Your/Name/<br />1 OBJE<br />2 FORM jpg<br />2 FILE media/grandma.jpg<br />2 TITL Picture of grandma</code></blockquote>to:<blockquote><code>0 @I1@ INDI<br />1 NAME Your/Name/<br />1 OBJE @M1@<br /></code></blockquote>The advantage of using multimedia records is that you can easily administer your media. When you change the title of a multimedia record, it is changed for all GEDCOM records that link to this multimedia record. Several people,families, or sources can be linked to the same multimedia record.";

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"] 		= "נמצאו תוצאות";
$pgv_lang["ged_filter_reset"] 			= "חיפוש נקי";
$pgv_lang["ged_filter_description"] 		= "טכסט של אופציות החיפוש";
$pgv_lang["ged_filter_description_help"] 	= "~#pgv_lang[ged_filter_description]#~<br />This option lets you search the text associated with configuration options.<br /><br />As you type letters, the search will find all configuration options that contain that letter sequence.  The search becomes more precise as you type more letters.<br />";

?>
