<?php
/**
 * Hebrew Language Help-file
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @translator Meliza
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: help_text.he.php 5614 2009-05-31 07:39:44Z meliza $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}
$pgv_lang["medialist_recursive_help"]	= "~#pgv_lang[medialist_recursive]#~<br />כאשר האופציה נבחרת, #pgv_lang[multi_title]# יחפש לא רק בתיקייה הנבחרת מרשימת #pgv_lang[filter]# אלא גם בכל תת-התיקיות שלה. כאשר האופציה אינה נבחרת, החיפוש נעשה רק בתיקייה הנבחרת.<br /><br />הכותרות של כל ישויות המדיה נבחנות אח\"כ כדי לקבוע אם הן כוללות את הטכסט שהוכנס ב#pgv_lang[filter]#.  התוצאה של שתי הפעולות הללו קובעת את ישויות המולטימדיה שתוצגנה.<br /><br />";
$pgv_lang["sortby_help"]			= "~#pgv_lang[sortby]#~<br />בחר את הסדר שלפיו תרצה לראות את הרשימה.<br /><br />";
$pgv_lang["help_treenav.php"]		= "~#pgv_lang[interactive_tree]#~<br />השתמש ב#pgv_lang[interactive_tree]# כדי לראות עץ של משפחה שלמה של אדם בשני הכיוונים.  המצגת דומה למצגת שעון החול בכך שהיא מראה אב-אבות וצאצאים של אדם מוצא נתון.  התרשים נותן מצגת קומפקטית יותר בכך שהיא מראה תיבות של זוגות או משפחות במקום רק אנשים.<br /><ul><li><b>גלילה</b><br />כאשר סמן העכבר שלך משתנה לצלמית העברה, תוכל להקיש ולגרור את העץ כדי להציג חלקים אחרים של העץ.  כאשר את גורר את העץ דורות עתידיים מורחבים בצורה אוטומטית עד שאין יותר דורות להציג בכיוון זה.<br /></li><li><b>זום</b><br />ניתן להשתמש בצלמיות בצד שמאל כדי לקרב או להרחיק.  הרחקה מאפשרת לך לראות על המסך יותר מרכיבים מהעץ.  כאשר תתרחק יתכן שיהיה קשה לקרא את הטכסט; כאשר העכבר שלך מרחף מעל לתיבה תקבל מצגת מוגדלת של מה שיש בתוכה.<br /></li><li><b>הרחב פרטים</b><br />הקשה על תיבה תרחיב אותה ותציג נתונים מפורטים יותר.  במצגת מורחבת, כאשר מקישים על השם של אדם, דף #pgv_lang[indi_info]# שלו יפתח.  לחיצה על <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> תכין עץ עם אדם זה כאדם מוצא חדש.  לחיצה על <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> תקח אותך לדף הפירוט של המשפחה.<br /></li><li><b>שנה מצב בני זוג</b><br />צלמית <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> הנמצאת מיד מתחת לכפתורי הזום משנה את המצגת כך שמציגים או לא מציגים את כל בני הזוג בצד הצאצאים.  כאשר המצגת מוגדרת להצגת בני זוג, כל בני הזוג של האדם יוצגו בתיבה ביחד איתו.  כל ילדיו יוצגו גם כן.  כאשר המצגת מוגדרת לא להראות בני זוג, רק בן הזוג האחרון והילדים עם בן זוג זה יוצגו.<br /></li><li><b>עץ גדול</b><br />#pgv_lang[interactive_tree]# זמין מדפים רבים הכוללים את חוצץ העץ על דף #pgv_lang[indi_info]# ואזור של התרשימים על דף ברוכים הבאים.  כאשר מביטים על העץ בדפים הללו, רואים גם צלמית עץ מתחת לצלמיות הזום.  אם לוחצים על <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> עוברים לדף #pgv_lang[interactive_tree]#.</li></ul><br />";

$pgv_lang["move_mediadirs_help"]		= "~#pgv_lang[move_mediadirs]#~<br />כאשר חומת האש של מדיה נבחרה, ניתן לאחסן קבצי מולטימדיה בתיקייה על השרת שאין עליה גישה דרך האינטרנט.<br /><br />הכפתורים הללו מאפשרים לך להעביר בקלות מבנה תיקיית מדיה שלם בין התיקייה השמורה  (ללא גישה מהרשת) <span dir=\"ltr\"><b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b></span> והתיקייה הרגילה <span dir=\"ltr\"><b>#GLOBALS[MEDIA_DIRECTORY]#</b></span>.<br /><br />";
$pgv_lang["setperms_help"]			= "~#pgv_lang[setperms]#~<br />הכנס הרשאות בצורה רקורסיבית לספריות <span dir=\"ltr\"><b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b></span> ספריות המוגנות (ללא גישה מהרשת) ול-<span dir=\"ltr\"><b>#GLOBALS[MEDIA_DIRECTORY]#</b></span> הרגילות הן לאלו המוגבלות לקריאה בלבד והן לאלו המותרות בכתיבה.<br /><br />";
$pgv_lang["help_dir_editor.php"]		= "~#pgv_lang[index_dir_cleanup]#~<br /><br />הכלי יכול לעזור למנהלנים בניקוי קבצים מתיקיית האינדקס.<br /><br />במשך הזמן, קבצים כמו קבצי לוג, קבצי GEDCOM ישנים וגיבויים ישנים יכולים להבנות בתיקיית האינדקס.  מכיוון שרבים מהקבצים הללו נוצרים ע\"י התוכנה, יתכן שהם בבעלות המשתמש של שרת ה-web. אם הם בבעלות משתמש של שרת ה-web, יתכן ולא תוכל למחוק אותם. הכלי הזה  מאפשר לך למחוק קבצים אלה גם אם הם בבעלות משתמש שרת ה-web.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";
$pgv_lang["no_update_CHAN_help"] 		= "~#pgv_lang[no_update_CHAN]#~<br />מנהלנים צריכים לפעמים לנקות ולתקן נתונים שנמסרו ע\"י משתמשים.  לדוגמא, יתכן שהם צריכים להוסיף ארץ למקום PLAC. כאשר מנהלנים מבצעים שינויים כאלה, המידע על השינוי המקורי מוחלף בדרך כלל. יתכן שדבר הזה אינו רצוי.<br /><br />כאשר האופציה נבחרת, PhpGedView ישמור את נתוני השינוי המקוריים מבלי להחליף אותה עם הנתון של העיבוד הנוכחי. כאשר האופציה הזו נבחרת, מנהלנים יכולים לשנות או למחוק גם מידע הקשור לתג ה-CHAN המקורי.<br /><br />";
$pgv_lang["edit_SOUR_EVEN_help"]		= "~#pgv_lang[source_events]#~<br /><br />כל מקור רושם מאורעות מסוימים, בדרך כלל עבור תחום תאריכים נתון ועבור מקום מסוים. לדוגמא: מפקד אוכלוסין רושם מאורעות של מפקד אוכלוסין וכנסייה או בית כנסת רושמים מאורעות של לידות, נישואין ופטירה.<br /><br />בחר את המאורעות שרשומים ע\"י המקור הזה מהרשימה של מאורעות המסופקת. את הנתונים יש להגדיר במבנה תחום <i>FROM 1900 TO 1910</i>. מקום הוא המקום הנמוך שכולל את כל המיקומים התחתונים המוזכרים במקור הזה. לדוגמא, \"Oneida, Idaho, USA\" ישמש כמקום המקור למאורעות שהתרחשו בערים שונות במחוז Oneida. \"Idaho, USA\" יהיה המקום של המקור של מאורעות שהתרחשו לא רק במחוז Oneida אלא גם במחוזות אחרים של Idaho.<br /><br />";
$pgv_lang["cache_life_help"]			= "~#pgv_lang[cache_life]#~<br /><br />כדי לשפר ביצועים, אזור ברוכים הבאים הזה של PhpGedCom נשמר כקובץ  cache.  תוכל לקבוע כל כמה זמן קובץ ה-cache של האזור רוענן.<br /><br /><ul><li><b>-1</b> משמעותו שקובץ הcache אינו מרוענן אף פעם בצורה אוטומטית.  עליך למחוק את כל קבצי הcache כדי לקבל עותק חדש.  תוכל לבצע את הפעולה בקישור \"התאם אישית את דף ברוכים הבאים הזה\" .</li><li><b>0</b> (אפס) משמעותו שהאזור אינו בעל cache, וכל פעם שמציגים את האזור על דף ברוכים הבאים של PhpGedView, רואים העתק טרי.  ההגדרה הזו בשימוש באופן אוטומטי לאזורים שהם משתנים לעתים תכופות, כמו אזור #pgv_lang[logged_in_users_block]# ואזור #pgv_lang[random_media_block]#.</li><li><b>1</b> (אחד) משמעותו שקובץ cache של האזור הזה נבנה כל יום, <b>2</b> משמעותו שקובץ cache של האזור הזה נבנה כל יומיים, <b>7</b> משמעותו שעותק חדש נבנה פעם בשבוע, וכו'.</li></ul><br /><br />";
$pgv_lang["clear_cache_help"]		= "~נקה קובצי cache~<br /><br />כדי לשפר את הביצועים, מספר אזורים על דף הברוכים הבאים של PhpGedView נשמרים כקובצי cache בתיקיית ה-index. קובצי ה-cache של רוב האזורים מתחדשים פעם ביום, אבל יתכן ותרצה לפעמים לחדש אותם ידנית.<br /><br />הכפתור הזה מאפשר לחדש את קובצי ה-cache לפי הצורך.";
$pgv_lang["import_options_help"] 		= "ניתן לבחור אופציות נוספות שייבוא ה-GEDCOM ישתמש בהם.";
$pgv_lang["verify_gedcom_help"]		= "ניתן להמשיך להעלות ולייבא קובץ GEDCOM זה או להפסיק את ההעלאה והייבוא.";
$pgv_lang["add_gedcom_instructions"]	= "הכנס שם קובץ עבור ה-GEDCOM החדש הזה.  קובץ ה-GEDCOM החדש ייווצר בתיקיית האינדקס: #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]	= "~#pgv_lang[random_media_start_slide]#~<br /><br />האם תרצה שמצגת שקופיות תתחיל אוטומטית כאשר הדף נטען.<br /><br />מצגת השקופיות משנה את תוכן האזור ללא צורך בטעינת תוכן האזור מהשרת וללא צורך בהעלאת כול הדף מחדש.<br /><br />";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />ניתן להשתמש בהגדרות הללו כדי לאפשר או לא לאפשר שליטת הפעלה באזור התמונה האקראית.<br /><br />שליטת ההפעלה מאפשרת למשתמש לעבור לתמונה אקראית אחרת או להפעיל מדיה אקראית כמו מצגת שקופיות. מצגת השקופיות משנה את תוכן האזור ללא צורך בטעינת תוכן האזור מהשרת וללא צורך בהעלאת כל הדף מחדש.<br /><br />";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />השתמש בקישור זה כדי להוסיף מקור למאגר הנתונים שלך מבלי לקשור את המקור לרשומה אחרת. המקור החדש יופיע ברשימת המקורות, אבל לא בשום תרשים או מקום אחר בתוכנה עד שהוא מקושר לציטוט מקור.";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />השתמש בקישור זה כדי להוסיף הערה משותפת חדשה למאגר הנתונים שלך מבלי לקשר את ההערה לשום רשומה.<br /><br />ההערה החדשה תופיע ברשימת ההערות המשותפות, אבל לא תופיע בשום תרשים או בשום מקום אחר בתוכנית עד שהיא מקושרת לאדם, משפחה או מאורע.";
$pgv_lang["link_person_id_help"]		= "~#pgv_lang[label_local_id]#~<br /><br />בשדה זה יש להכניס את הקוד האישי של האדם שאליו אתה מקשר (לדוגמה I100).";
$pgv_lang["link_gedcom_id_help"]		= "~#pgv_lang[label_gedcom_id]#~<br /><br />השתמש באזור הזה כדי לבחור את זיהוי מסד הנתונים שכולל את האדם שאליו אתה רוצה לקשור.";
$pgv_lang["link_remote_site_help"]		= "~#pgv_lang[label_site]#~<br /><br />בקטע הזה מפרטים את הפרמטרים הדרושים כדי להתקשר לאתר מרוחק שבו נמצאים הנתונים שאליהם ברצונך להקשר. ניתן לבחור מרשימה של אתרים ידועים שבהם כבר השתמשת מקודם או הכנסת ה#pgv_lang[label_site_url2]# וה#pgv_lang[label_gedcom_id]# של אתר חדש.<br /><br />בשדה <b>#pgv_lang[label_site_url2]#</b>, יש למלא את ה-URL כדי לגשת לקובץ התיאור של שרותי הרשת (WDSL) שאומר ל-PhpGedView איך לגשת לנתונים באתר המרוחק.  עבור אתר PhpGedView מרוחק, ה-URL לקובץ ה-WSDL יראה כך: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />שדה ה<b>#pgv_lang[label_gedcom_id]#</b> ישמש להכנסת קוד זיהוי ברירת מחדל למאגר הנתונים עבור אתרים מרוחקים שדורשים אותו.  עבור אתרי PhpGedView, זה שם קובץ ה-GEDCOM.<br /><br /><i>הערה: אתרי PhpGedView מרוחקים חייבים להשתמש בגרסה 3.4 או מאוחרת יותר; לגרסאות מוקדמות יותר אין את היכולת הזו.</i>";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />האופציה מאפשרת לבחור אם נתוני האדם שאליו אתה מקשר הם באותו אתר, אבל במאגר נתונים של חקר משפחה שונה, או אם הנתונים באתר אחר שאליו ניתן להקשר בעזרת האינטרנט.<br /><br />אם האדם באותו האתר, תתבקש לבחור את המאפיין של מאגר הנתונים ואת קוד הזיהוי של האדם.<br /><br />עבור אתר מרוחק, תתבקש להכניס את ה-URL שלו, את מאפיין מאגר הנתונים, ואת קוד הקשר המרוחק של האדם.";
$pgv_lang["link_remote_rel_help"]		= "~#pgv_lang[label_rel_to_current]#~<br /><br />השתמש בבחירה הזו כדי לבחור את הקשר של האדם המרוחק אל האדם שאליו אתה מקשר אותו באתר שלך. לדוגמא, בחירת <i>אב</i> משמעותה שהאדם המרוחק הוא האב של האדם באתר המקומי שאליו אתה מקשר אותו.";
$pgv_lang["link_remote_help"]         		= "~#pgv_lang[link_remote]#~<br /><br />השתמש בטופס זה כדי לקשר אנשים לאתר אחר או למאגר נתוני חקר משפחה אחר שנגיש לעותק ה-PhpGedView שלך.<br /><br />כדי להוסיף קישור כזה, עליך לבחור סוג קשר ואח\"כ אתר מוכר ל-PhpGedView או להגדיר אתר חדש, ואח\"כ להוסיף את קוד הקשר של האדם באתר הזה שאליו תרצה לקשר.  PhpGedView מוריד לפי הצורך בצורה אוטומטית נתונים מהאתר המרוחק. הנתונים שהורדו <u>אינם</u> חלק ממאגר נתוני חקר המשפחה שלך; הם נשארים באתר המקורי אבל הם מקושרים לתוך הדפים השונים שבהם האדם המרוחק מוצג.<br /><br />התייחס לקישורי עזרה ליד כל ישות על הדף כדי לקבל מידע נוסף עליו.  ניתן גם לבדוק את ההדרכה באנגלית שבאון-ליין למידע נוסף: <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.";

//-- Edit Interface
$pgv_lang["edit_ABBR_help"]			= "~כותרת מקוצרת~<br /><br />השתמש בשדה זה כדי לשמור גרסה מקוצרת של כותרת.  השדה בשימוש ביחד עם שדה הכותרת של המקור.  כברירת מחדל PhpGedView ישתמש תחילה בכותרת ואח\"כ בכותרת המקוצרת.<br /><br />לפי הגדרות ה-GEDCOM 5.5, \"הכניסה קיימת כדי לספק כותרת מקוצרת עבור מיון, תיוק ושליפה של רשומות מקור (דף 62).\"<br /><br />ב-PhpGedView הכותרת המקוצרת היא שדה רשות, אבל בתוכניות חקר משפחה אחרות השדה חובה.";
$pgv_lang["edit_ROMN_help"]		= "~שם לטיני~<br /><br />בתרבויות רבות מקובל שיש שם מסורתי שכתוב באותיות מסורתיות וגם גרסה לטינית, כמו אנגלית, של השם.<br /><br />אם תעדיף לרשום את השם המסורתי בשדות השם הרגילים, תוכל להשתמש בשדה זה עבור הכתב הלטיני של אותו השם. השם הלטיני יופיע גם ברשימות וגם בתרשימים.<br /><br />עברית, יונית, רוסית, ערבית או סינית, הן דוגמאות לשפות בהן לאדם יש שם כתוב באלף בית שאינו לטיני (האלף בית ה\"מסורתי\") ובנוסף באותיות לטיניות (השם ה\"לטיני\").<br /><br />למרות ששם השדה \"לטיני\"ת הוא יכול להכיל גם אותיות שאינן לטיניות. דבר זה יכול להיות שימושי עבור שמות יפניים, ששם יתכנו שלושה אלף-בית שונים.";
$pgv_lang["edit_ROMN_GIVN_help"]		= "#pgv_lang[edit_ROMN_help]#<br /><br /> בשדה זה עלך להכניס שם פרטי, אחד או יותר, של האדם. לדוגמה, בשם \"John Robert Finlay\", השמות הפרטיים שעליך להכניס כאן הם \"John Robert\"<br /><br />";
$pgv_lang["edit_ROMN_SURN_help"]	= "#pgv_lang[edit_ROMN_help]#<br /><br />בשדה זה יש להכניס את שם המשפחה של האדם. לדוגמא, בשם \"John Robert Finlay\", שם המשפחה שימולא כאן, יהיה \"Finlay\".<br /><br />אנשים להם שם משפחה מורכב, שרווח בספרד ופורטוגל, יפרידו בין השמות בפסיק. משמעות הדבר שהאדם יופיע תחת כל אחד מהשמות. למשל, שמות המשפחה  \"Cortes,Vega\" יופיעו תחת <b>C</b> וגם תחת <b>V</b>, בעוד שהשם \"Cortes Vega\" יופיע רק תחת <b>C</b>.<br /><br />";
$pgv_lang["edit__HEB_help"]			= "~שם עברי~<br /><br />בתרבויות רבות מקובל שיש שם מסורתי שכתוב באותיות מסורתיות וגם גרסה לטינית, כמו אנגלית, של השם.<br /><br />אם תעדיף לרשום את השם הלטיני בשדות השם הרגילים, תוכל להשתמש בשדה זה עבור הכתב הלא-לטיני של אותו השם באלף בית העברי, היווני, הרוסי, הערבי או הסיני. השם העברי יופיע גם ברשימות וגם בתרשימים.<br /><br />למרות ששם השדה \"עברי\" הוא יכול להכיל גם אותיות אחרות.";
$pgv_lang["edit__HEB_GIVN_help"]	= "#pgv_lang[edit__HEB_help]#<br /><br />בשדה זה עלך להכניס שם פרטי, אחד או יותר, של האדם. לדוגמה, בשם \"John Robert Finlay\", השמות הפרטיים שעליך להכניס כאן הם \"John Robert\"<br /><br />";
$pgv_lang["edit__HEB_SURN_help"]	= "#pgv_lang[edit__HEB_help]#<br /><br />בשדה זה יש להכניס את שם המשפחה של האדם. לדוגמא, בשם \"John Robert Finlay\", שם המשפחה שימולא כאן, יהיה \"Finlay\".<br /><br />אנשים להם שם משפחה מורכב, שרווח בספרד ופורטוגל, יפרידו בין השמות בפסיק. משמעות הדבר שהאדם יופיע תחת כל אחד מהשמות. למשל, שמות המשפחה  \"Cortes,Vega\" יופיעו תחת <b>C</b> וגם תחת <b>V</b>, בעוד שהשם \"Cortes Vega\" יופיע רק תחת <b>C</b>.<br /><br />";
$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />השתמש בטופס זה כדי להוסיף אדם לא קשור.<br /><br />כאשר אתה מוסיף אדם לא קשור לאילן היוחסין שלך, האדם לא יהיה קשור לשום אדם אחר עד שלא תקשר ביניהם.  מאוחר יותר תוכל לקשר אותם מהגיליון שמאורגן בצורת טבלה #pgv_lang[relatives]# על דף ה-#pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]			= "הכנס את הכתובת של ה-URL כולל ה-<span dir=\"ltr\">http://</span>.<br /><br />דוגמת URL נראית כך: <b><span dir=\"ltr\">http://www.phpgedview.net/</span></b> השאר את השדה ריק אם אתה לא רוצה לכלול URL.";
$pgv_lang["edit_EMAIL_help"]		= "הכנס את כתובת האלקטרונית.<br /><br />דוגמה לכתובת אלקטרונית נראית כך: <b>name@hotmail.com</b> השאר את השדה ריק אם אתה לא רוצה לכלול כתובת אלקטרונית.";
$pgv_lang["edit_FAX_help"]			= "הכנס את מספר הפקס כולל קוד מדינה וקוד אזור.<br /><br />השאר את השדה ריק אם אתה לא רוצה לכלול מספר פקס.  לדוגמה, מספר בגרמניה יכול להיות <span dir=\"ltr\">+49 25859 56 76 89</span> ומספר בארה\"ב או בקנדה יכול להיות <span dir=\"ltr\">+1 888 555-1212</span>.";
$pgv_lang["edit_PHON_help"]			= "הכנס את מספר הטלפון כולל קוד מדינה וקוד אזור.<br /><br />השאר את השדה ריק אם אתה לא רוצה לכלול מספר טלפון.  לדוגמה, מספר בגרמניה יכול להיות <span dir=\"ltr\">+49 25859 56 76 89</span> ומספר בארה\"ב או בקנדה יכול להיות <span dir=\"ltr\">+1 888 555-1212</span>.";
$pgv_lang["edit_ADDR_help"]		= "הכנס את הכתובת לתוך השדה בדיוק כפי שהיית רושם אותה על מעטפה.<br /><br />השאר את השדה ריק אם אתה לא רוצה לכלול כתובת.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~קידומת שם משפחה~<br /><br />הכנס או בחר מרשימה מילים שמקדימות את החלק הראשי של שם משפחה. דוגמאות למילים כאלו הן <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, וכו'.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]			= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />יש להכניס את שם הנישואין של האדם לפי אותם חוקים של שדה השם.  השדה הוא שדה רשות.<br /><br /><br /><br />למשל אם מרים בראון נישאה לאברהם סגל, ניתן להכניס (ללא המירכאות כמובן)<ul><li>כמקובל בארה\"ב:&nbsp;&nbsp;\"מרים בראון /סגל/\"</li><li>כמקובל באירופה:&nbsp;&nbsp;\"מרים /סגל/\"</li><li>שימוש אירופאי אחר:&nbsp;&nbsp;\"מרים /סגל-בראון/\" או \"מרים /בראון-סגל/\"</li></ul>יש לבצע מילוי זה רק אם מרים בראון החלה להשתמש בשם חדש לאחר נישואיה לאברהם סגל. במקומות מסוימים, למשל בקוויבק שבקנדה, בלתי חוקי לאישה לשנות את שמה בצורה הזו.<br /><br />גם גברים משנים לעיתים את שמם לאחר נישואיהם. בדרך כלל על ידי הוספת שם האישה עם מקף ולפעמים מאמצים את שם המשפחה של האישה.";
$pgv_lang["edit_PEDI_help"]			= "~#factarray[PEDI]#~<br /><br />השדה מתאר את הקשר של הילד/ילדה למשפחה. האפשרויות הן:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;לא ניתן לקבוע את הקשר בין הילד/ילדה למשפחה.  כאשר בוחרים באופציה זו, שדה ה-#factarray[PEDI]# לא יועתק למסד הנתונים.<br /><br /></li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;בחירה זו מציינת קשר לידה.<br /><br /></li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;בחירה זו מציינת קשר אימוץ.  עובדה זו <i>אינה</i> קובעת שאין קשר דם בין הילד/ילדה למשפחה; זה מראה שהמשפחה אימצה את הילד/ילדה לאחר הלידה.<br /><br /></li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;בחירה זו מציינת שהילד/ילדה הוא ילד אומנה במשפחה.  בדרך כלל אין קשר דם בין הילד/ילדה למשפחה.<br /><br /></li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;ילד זה חובר למשפחה <i>בברית</i> מורמונית. ברית מורמונית לילד מתבצעת כאשר ההורים באים בברית מורמונית לאחר הולדת הילד/ילדה.  ילדים שנולדים לאחר שההורים הובאו בברית מורמונית מובאים אוטומטית בברית מורמונית למשפחה.<br /><br /></li></ul>";
$pgv_lang["edit_AGNC_help"]		= "~#factarray[AGNC]#~<br /><br />הארגון, מוסד, חברה, אדם או ישות אחרת בעלת הסמכות.<br /><br />דוגמה, המעביד של אדם או בית הכנסת שעורך טקסים או מאורעות או ארגון אחראי על יצירת ו-/או גניזת רשומות.";
$pgv_lang["context_help"]			= "עזרה נוספת קיימת על ידי לחיצה על ה-<b>?</b> ליד פריטים על הדף.";
$pgv_lang["register_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />לכל אדם בבסיס הנתונים יש מספר מזהה יחיד באתר. אם אתה יודע את המספר המזהה של הרשומה האישית שלך, אנא הכנס אותה כאן. אם אינך יודע את המספר המזהה שלך, או אינך יכול למצוא אותו בגלל הגבלות פרטיות, אז עליך לספק נתונים במידה מספקת בשדה ההערה כדי שמנהלן האתר יוכל לזהותך באתר ולהגדיר את הקוד הזיהוי עבורך.<br /><br />";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />השתמש בשדה זה כדי להסביר למנהלן האתר מדוע אתה מבקש קוד משתמש ומה הקשר שלך לחקר המשפחה המוצג באתר זה. תוכל גם להוסיף כל הערה נוספת הנראית לך עבור המנהלן.<br /><br />";
$pgv_lang["utf8_ansi_help"]			= "~הסב מ-UTF-8 ל-ANSI~<br /><br />לתצוגה אופטימאלית באינטרנט PhpGedView משתמש במערך אותיות UTF-8. תוכניות כמו למשל Family Tree Maker, אינן תומכות בייבוא קובצי GEDCOM מוצפנים ב-UTF-8. בחירת התיבה תתרגם את הקובץ מ-<b>UTF-8</b> ל-<b><span dir=\"ltr\">ANSI (ISO-8859-1)</span></b>.<br /><br />המבנה הדרוש תלוי בתוכנה שבה תרצה להשתמש בקובץ ה-GEDCOM שהורד. בדוק את התיעוד של התוכנה הזאת, אם אינך בטוח.<br /><br />שים לב שכדי שסימנים מיוחדים ישמרו ללא שינוי, עליך להוריד את הקובץ ב-UTF-8 ולהסב לשיטת טיפול של התוכנית שלך בסימנים המיוחדים הללו בדרך אחרת. התייעץ עם יצרן או עורך התוכנה שלך.<br /><br />הכתבה הבאה <a href='http://he.wikipedia.org/wiki/UTF-8' target='_blank' title='כתבה של ויקיפדיה'><b>של ויקיפדיה</b></a> כוללת מידע וקישורים מקיפים על UTF-8.<br /><br />";
$pgv_lang["remove_tags_help"]		= "~הסר נתוני PGV פרטיים~<br /><br />בחירת האופציה תמחק נתונים פרטיים שאולי הוספו לרשומות ע\"י PhpGedView.<br /><br />נתונים פרטיים ש-PhpGedView משתמש בהם כוללים נתון <b><span dir=\"ltr\">_PGVU</span></b> שמסמן איזה משתמש שינה את הרשומה באון-ליין, ונתון <b><span dir=\"ltr\">_THUM</span></b> שאומר ל-PhpGedView שהתמונה תשמש כתמונה מזערית.<br /><br />נתונים פרטיים יכולים לגרום לשגיאות כאשר מייבאים את ה-GEDCOM שמיוצא לאפליקציה של חקר משפחה אחרת.<br /><br />";
$pgv_lang["download_zipped_help"]		= "~הורד GEDCOM כקובץ ZIP~<br /><br />כאשר אתה בוחר את האפשרות הזו, עותק של קובץ ה-GEDCOM ידחס למבנה ZIP לפני שההורדה מתחילה. דבר זה יצמצם במידה ניכרת  את גודלו, אבל עליך להשתמש בתוכנית פתיחת דחיסה תואמת (WinZIP, למשל) כדי לבטל את הצמצום של קובץ ה-GEDCOM שהורד לפני שניתן יהיה להשתמש בו.<br /><br />אפשרות שימושית בהורדת קובצי GEDCOM גדולים.  קיים סיכון שזמן ההורדה של קובץ שאינו דחוס יעבור את זמן העיבוד המכסימלי, ויגרום לקובצי הורדה שאינם שלמים. אפשרות ה-ZIP מקטינה את זמן ההורדה ב-75%.<br /><br />";
$pgv_lang["remember_me_help"]		= "~זכור אותי~<br /><br />בחירת התיבה בזמן התחברות מאפשרת ל-PhpGedView לזכור אותך בפעם הבאה שתבקר כך שלא תצטרך להתחבר שנית. האופציה מגדירה עוגייה (cookie) על המחשב שלך שיחזיר נתונים על ידי הדפדפן לאתר בביקורך הבא.<br /><br />כאשר תחזור לאתר תוכל לגשת לנתונים פרטיים ולדפי המשתמש, אבל כדי לערוך או לנהל, עליך להכניס שוב את קוד המשתמש והסיסמא שלך.<br /><br />אין לסמן את התיבה כאשר מתחברים ממחשב<b> ציבורי או מחשב שבו משתמשים עם אחרים; כל אחד יוכל לחזור ל-PhpGedView כאילו הוא אתה.</b>";
$pgv_lang["edit_NCHI_help"]			= "~#factarray[NCHI]#~<br /><br />הכנס את מספר הילדים של האדם הזה או של המשפחה הזו. השדה הוא שדה בחירה.<br /><br />";
$pgv_lang["edit_TIME_help"]			= "~#factarray[TIME]#~<br /><br />הכנס זמן לאירוע זה במבנה 24 שעות עם אפסים מובילים. חצות הוא 00:00. לדוגמא: 04:50 13:00 20:30.<br /><br />";
$pgv_lang["edit_NOTE_help"]			= "~#factarray[NOTE]#~<br /><br />הערות הן טכסט במבנה חופשי ותופענה בחלק הדף של פירוט העובדה.<br /><br />";
$pgv_lang["edit_SHARED_NOTE_help"]		= "~#pgv_lang[shared_note]#~<br /><br />הערות משותפות הן טכסט במבנה חופשי והן מופיעות בחלק העובדות בפרוט של הדף.<br /><br />ניתן לקשר כל הערה משותפת ליותר מאדם, משפחה, מקור או אפילו עובדה אחת.<br /><br />";
$pgv_lang["edit_CEME_help"]		= "~#factarray[CEME]#~<br /><br />הכנס את שם בית הקברות או מקום מנוחה אחר שבו האדם קבור.<br /><br />";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />הכנס קוד זיהוי של השותף ב-GEDCOM.<br /><br />";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />בחר שם קשר מהרשימה. אם בוחרים <b>סנדק</b>, המשמעות: <i>השותף הזה הוא הסנדק של האדם הנוכחי</i>.<br /><br />";
$pgv_lang["show_spouse_help"]		= "~#pgv_lang[show_spouses]#~<br /><br />כברירת מחדל התרשים אינו מראה בני זוג של הצאצאים משום שזה גורם לקשיים בקריאת והבנת התרשים. הפעלת האופציה תראה בני זוג בתרשים.<br /><br />";
$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_families]#~<br /><br />משפחות מוצגות בחוצץ  #pgv_lang[relatives]# בסדר שהם מופיעים ברשומת ה-GEDCOM של האדם.  משפחות אינן מוצגים לפי תאריך הנישואין משום שתאריך הנישואין אינו ידוע  פעמים רבות, אבל סדר הנישואין <u>כן</u> ידוע.<br /><br />האופציה הזו מאפשרת שינוי סדר המשפחות בחוצץ #pgv_lang[relatives]#. אם תרצה למיין את המשפחות לפי תאריך הנישואין, קיים כפתור שיעשה זאת עבורך.<br /><br />";
$pgv_lang["autoContinue_help"]		= "~#pgv_lang[autoContinue]#~<br /><br />כאשר PhpGedView מגלה ייבוא ה-GEDCOM דורש יותר זמן מאשר גבול הזמן המותר, הוא יציג כפתור <b>#pgv_lang[del_proceed]#</b> שעליך ללחוץ עליו כדי להמשיך את הייבוא.<br /><br />כאשר הבחירה option is set to <b>#pgv_lang[yes]#</b>, PhpGedView לוחץ בצורה אוטומטית את כפתור ה-<b>#pgv_lang[del_proceed]#</b> עבורך.  דבר זה חוסך ללחוץ את הכפתור שוב ושוב עבור ייבוא ארוך.<br /><br />";
//$pgv_lang["import_marr_names_help"]	= "~#pgv_lang[import_marr_names]#~<br /><br />אם הבחירה היא <b>#pgv_lang[yes]#</b> PhpGedView מחשב אוטומטית את שם הנישואין של כל הנשים הנשואות בקובץ שאותו מייבאים כעת.  האופציה אינה משפיעה על שמות נישואין שכבר קיימים בקובץ הקלט.<br /><br />כדוגמא, נניח ש-Jane Doe התחתנה עם John Smith.  לפני שמריצים את הפונקציה, חלק השם שלה ברשימת ה-GEDCOM שלה נראית כך:<br /><code><span dir=\"ltr\">1 NAME Jane /Doe/<br />2 GIVN Jane<br />2 SURN Doe<br /></span></code><br />אחרי שמריצים את הפונקציה רשימת השם שלה תשונה ותכלול _MARNM כך:<br /><code><span dir=\"ltr\">1 NAME Jane /Doe/<br />2 GIVN Jane<br />2 SURN Doe<br />2 _MARNM Jane /Smith/<br /></span></code><br />אם ברשומה של האדם יש כבר רשומת שם נישואין, לא יוצרים רשומה חדשה.<br /><br />האופציה מאפשרת חיפוש של הנשים לפי שמות הנישואין או שמות הנערים.<br /><br />האופציה מאפשרת גם כן להראות שמות נישואין ברשימת השמות אם תאפשר את <b>#pgv_lang[SHOW_MARRIED_NAMES]#</b> בתצורת ה-GEDCOM.<br /><br />";
$pgv_lang["firstname_i_help"]			= "~#pgv_lang[firstname_alpha_index]#~<br /><br />לשם המשפחה שבחרת יש יותר מ-#GLOBALS[SUBLIST_TRIGGER_I]# אנשים.<br /><br />כדי לעזור לך למצוא את האדם הרצוי, חלקנו את הרשימה לפי האות הראשונה של השם הפרטי של האנשים בצורה דומה לאינדקס האותיות של שמות המשפחה.<br /><ul><li>לחץ על אות כדי לראות את השמות הפרטיים שמתחילים באות זו.</li><li>בחר <b>#pgv_lang[NN]#</b> או <b>(לא ידוע)</b> כדי לרשום את האנשים שהשם הפרטי שלהם אינו ידוע.</li><li>בחירת <b>#pgv_lang[all]#</b> תראה את הרשימה של כל האנשים עם שם המשפחה הנבחר. </li></ul>מכיוון שיש הרבה שמות, יתכן שייקח הרבה זמן לבנות ולהראות את הרשימה של כולם.<br /><br />";
$pgv_lang["firstname_f_help"]			= "~#pgv_lang[firstname_alpha_index]#~<br /><br />לשם המשפחה שבחרת יש יותר מ-#GLOBALS[SUBLIST_TRIGGER_F]# אנשים.<br /><br />כדי לעזור לך למצוא את האדם הרצוי, חלקנו את הרשימה לפי האות הראשונה של השם הפרטי של האנשים בצורה דומה לאינדקס האותיות של שמות.<br /><ul><li>לחץ על אות כדי לראות את השמות הפרטיים שמתחילים באות זו.</li><li>בחר <b>#pgv_lang[NN]#</b> או <b>(לא ידוע)</b> כדי לרשום את האנשים שהשם הפרטי שלהם אינו ידוע.</li><li>בחירת <b>#pgv_lang[all]#</b> תראה את הרשימה של כל האנשים עם שם המשפחה הנבחר. </li></ul>מכיוון שיש הרבה שמות, יתכן שייקח הרבה זמן לבנות ולהראות את הרשימה של כולם.<br /><br />";
$pgv_lang["edit_TYPE_help"]			= "~#factarray[TYPE]#~<br /><br />שדה #factarray[TYPE]# מאפשר להכניס מידע נוסף על הישות. ברוב המקרים, השדה במבנה חופשי שבו ניתן להקיש טקסט חופשי.<br /><br />";
$pgv_lang["edit_TEMP_help"]			= "~#factarray[TEMP]#~<br /><br />עבור חוק המורמונים LDS, השדה רושם את המקדש שבו הפעולה בוצע.<br /><br />";
$pgv_lang["edit_STAT_help"]			= "~#factarray[STAT]#~<br /><br />השדה הזה הוא שדה סטאטוס אופציונאלי שבדרך כלל משמש את המורמונים (LDS) כאשר נתוני החוק שלהם מעובדים בתוכנת ה-TempleReady שלהם.<br /><br />";
$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />השתמש בשדה זה כדי לסמן שפריט המדיה הזה מודגש או העיקרי עבור האדם אליו הוא מחובר. התמונה העיקרית היא התמונה שמשתמשים בה בתרשימים ובדף האישי.<br /><br />";
//$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />הבחירה מאפשר דריסה של הבחירה הרגילה של תמונה מזערית. ב\"כ אין צורך להשתמש באופציה זו משום ש-PhpGedView יוצר תמונות מזעריות בצורה אוטומטית ובגודל נכון כאשר מעלים תמונה.<br /><br />ניתן להשתמש באפשרות הזו כדי להבטיח שהתמונה מוצגת בפירוט מספיק וכאשר התמונה המזערית האמיתית חסרה פירוט. תמיד תוכל ללחוץ על התמונה המזערית כדי לראות את התמונה בגודל המלא, האפשרות הזו כנראה לא כל כך שימושית.<br /><br />כאשר הבחירה היא <b>כן</b>, PhpGedView ישתמש בתמונה המוגדרת, ללא התייחסות לגודלה, כל עוד זקוקים לתמונה מזערית. אין בדיקה על גודל התמונה; ההצגה יכולה לגרום להפתעה, אם היא אינה בגודל תמונה מזערית.<br /><br />";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />הבחירה מאפשר דריסה של הבחירה הרגילה של תמונה מזערית.<br /><br />ל-GEDCOM יש אפשרות תצורה אשר מפרטת אם PhpGedView ישלח תמונה גדולה או קטנה לדפדפת בכל פעם שדף מנוכחי דורש תמונה מזערית.  אופצית &laquo;#factarray[_THUM]#&raquo; עם ערך <b>#pgv_lang[yes]#</b>, דורסת זמנית את ההגדרה של תצורת ה-GEDCOM, כך ש-PhpGedView שולח תמיד את התמונה הגדולה.  לא ניתן להכריח את PhpGedView לשלוח תמונה קטנה כאשר תצורת GEDCOM מגדירה שיש תמיד להשתמש בתמונות גדולות.<br /><br />PhpGedView אינו משנה את הגודל של התמונה הנשלחת; הדפדפן עושה את זה לפי הגדרות הדף שהוא מקבל.  לדבר זה יכולים להיות תוצאות בלתי רצויות כאשר התמונה הנשלחת אינה באמת תמונה מזערית ו-PhpGedView מצפה לשלוח תמונה קטנה.  דבר זה אינו שגיאה:  יש מצבים שיתכן שרצוי להציג תמונה גדולה במקום שבד\"כ מצפים לראות תמונה בגודל מזערי.<br /><br />רצוי להימנע מלהגדיר אופצית &laquo;#factarray[_THUM]#&raquo; כ<b>#pgv_lang[yes]#</b>.  הבחירה גורמת לשליחת כמויות מיותרות של נתונים הקשורים לתמונות לדפדפן, ואח\"כ על הדפדפן להשליך את העודף.  יתכן שטעינת הדפים, במיוחד תרשימים עם הרבה תמונות, יואט בצורה רצינית.<br />";
$pgv_lang["edit_TITL_help"]			= "~#factarray[TITL]#~<br /><br />הכנס כותרת לפריט אותו אתה עורך.  אם זו כותרת לפריט מולטימדיה, יש להכניס כותרת המזהה את הפריט למשתמש.<br /><br />";
$pgv_lang["edit_FILE_help"]			= "~#factarray[FILE]#~<br /><br />זה השדה החשוב ברשומות ישויות מולטימדיה הוא מגדיר באיזה קובץ יש להשתמש. חייבים להכניס לפחות את שם הקובץ. נתונים נוספים על מיקום הקובץ יוכלו לעזור, בתלות בתצורה שלך.<br /><br />תוכל להשתמש בקישור <b>#pgv_lang[find_media]#</b> כדי למקם את קובצי המדיה שכבר הועלו אל האתר.<br /><br />#pgv_lang[readme_help]#<br /><br />";
$pgv_lang["edit_FORM_help"]		= "~#factarray[FORM]#~<br /><br />זה שדה אופציונאלי שניתן להשתמש כדי להגדיר את צורת פריט המולטימדיה. יתכן שחלק מתוכניות חקר המשפחה משתמשות בשדה זה כדי להחליט איך לטפל בפריט המדיה. אבל, מכיוון שמדיה אינה עוברת בין מערכות מחשבים בצורה טובה, השדה אינו חשוב מאוד.<br /><br />";
$pgv_lang["generate_thumb_help"]		= "~#pgv_lang[auto_thumbnail]#~<br /><br />למערכת יש אפשרות ליצור אוטומטית תמונות מזעריות עבור סוגים מסוימים של מדיה. יתכן שיש תמיכה בקובצי BMP, GIF, JPG, ו-PNG. הסוגים בהם תומכת המערכת שלך רשומים ליד תיבת הבחירה.<br /><br />על ידי לחיצה על תיבת הבחירה הזו, אתה מסמן למערכת שאתה מעלה תמונות מהסוג הזה ושאתה רוצה שהמערכת תנסה ליצור עבורך תמונות מזעריות. השאר את התיבה ריקה אם אתה מספק בעצמך את התמונות המזעריות שלך.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />הקטע הזה מאפשר הוספת הערה לעובדה שכרגע בעריכה. הערות הן טכסט חופשי והן תופענה בקטע הפירוט של עובדות על הדף.<br /><br />";
$pgv_lang["edit_add_SHARED_NOTE_help"]		= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />הערות משותפות, כמו הערות רגילות, הן טכסט במבנה חופשי.  בניגוד להערות רגילות, ניתן לקשר כל הערה משותפת ליותר מאדם, משפחה, מקור או מאורע אחד.<br /><br />ע\"י לחיצה על הצלמית המתאימה, תוכל ליסד קישור להערה משותפת קיימת או ליצור הערה משותפת חדשה ובאותו זמן קישור אליו.  אם קישור להערה משותפת קיימת כבר נוצר, תוכל גם לערוך את התוכן של ההערה בזאת.<br /><ul><li><b>קשור להערה משותפת קיימת</b><div style=\"padding-left:20px;\">אם אתה כבר יודע את קוד הזיהוי של ההערה המשותפת הרצוייה, תוכל להכניס מספר זה ישירות בשדה.<br /><br />כאשר אתה לוחץ על צלמית <b>#pgv_lang[find_shared_note]#</b>, תוכל לחפש את הטכסט של כל ההערות המשותפות הקיימות ואח\"כ לבחור אחד מהם.  מספר קוד הזיהוי של ההערה שנבחרה יוכנס בצורה אוטומטית לתוך השדה.<br /><br />עליך ללחוץ על כפתור <b>#pgv_lang[add]#</b> כדי לעדכן את הרשומה המקורית.</div><br /></li><li><b>צור הערה משותפת חדשה</b><div style=\"padding-left:20px;\">כאשר תלחץ על צלמית <b>#pgv_lang[create_shared_note]#</b>, יפתח חלון חדש.  תוכל להכניס את הטכסט של ההערה החדשה כרצונך.  בדומה להערות רגילות, תוכל להכניס URL-ים.<br /><br />כאשר תלחץ על כפתור <b>#pgv_lang[save]#</b>, תראה הודעה עם המספר המזהה של ההערה המשותפת החדשה שנוצרה.  עליך ללחוץ על ההערה הזאת כדי לסגור את חלון העריכה וגם כדי להעתיק את המספר המזהה החדש ישירות לשדה המספר המזהה.  אם רק תסגור את החלון, המספר המזהה לא יעותק אוטומטית.<br /><br />עליך ללחוץ על כפתור <b>#pgv_lang[add]#</b> כדי לעדכן את הרשומה המקורית.</div><br /></li><li><b>ערוך הערה משותפת קיימת</b><div style=\"padding-left:20px;\">כאשר תלחץ על צלמית ה<b>#pgv_lang[edit_shared_note]#</b>, יפתח חלון חדש.  תוכל לשנות את הטכסט של ההערה המשותפת הקיימת כרצונך.  בדומה להערות רגילות, תוכל להכניס URL-ים.<br /><br />כאשר תלחץ על כפתור <b>#pgv_lang[save]#</b>, הטכסט של ההערה המשותפת יעודכן.  תוכל לסגור את החלון ואח\"כ ללחוץ שוב על הכפתור <b>#pgv_lang[save]#</b>.<br /><br />כאשר תשנה טכסט של הערה משותפת, השינוי משתקף בכל המקומות שההערה המשותפת הזאת מקושרת כרגע.  קישורים חדשים שתיצור אחרי ששינית ישתמשו גם כן בטכסט העדכני.</div></li></ul>";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />הקטע הזה מאפשר להוסיף ציטוט מקור חדש לעובדה שכעת בעריכה.<br /><br />בשדה המקור עליך להכניס את הזיהוי של המקור. לחץ על קישור <b>#pgv_lang[create_source]#</b> אם אתה זקוק למקור חדש. בשדה הפירוט של הציטוט הכנס את מספר הדף או נתון אחר שיכול לעזור לאחרים למצוא את מקום הנתון במקור. בתוך הטכסט תכניס תעתיק מתוך טכסט המקור.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# מאפשר לקשור עובדה לאדם שותף באתר. כך למשל תוכל לציין שמישהו היה סנדק של מישהו אחר .<br /><br />";
$pgv_lang["edit_QUAY_help"]			= "~#factarray[QUAY]#~<br /><br />תוכל להשתמש בשדה זה כדי לרשום את האיכות או המהימנות של הנתונים שנמצאו במקור זה. הרבה תוכנות חקר משפחה משתמשות בספרה בשדה זה. יתכן שערך <b>3</b> פירושו שמדובר במקור ראשוני, ערך <b>2</b> מקור משני וערך <b>1</b> שהמקור אינו מהימן.<br /><br />";
$pgv_lang["edit_PAGE_help"]			= "~#factarray[PAGE]#~<br /><br />בשדה פירוט הציטוט מכניסים את מספר הדף או מידע אחר שיעזור לאחרים למצוא את הנתונים מתוך המקור.<br /><br />";
$pgv_lang["edit_TEXT_help"]			= "~#factarray[TEXT]#~<br /><br />בשדה זה יש להכניס את טכסט הציטוט של המקור הזה. דוגמאות הן תעתיק מטקסט המקור או תאור חופשי של הנאמר בטכסט.<br /><br />";
$pgv_lang["edit_SOUR_help"]		= "~#factarray[SOUR]#~<br /><br />שדה זה מאפשר לך לשנות את רשומת המקור אליה מקושר מקור הציטוט. בשדה זה מכניסים קוד זיהוי של המקור. ליד השדה רשומה הכותרת של קוד הזיהוי הנוכחי של המקור. השתמש בקישור <b>#pgv_lang[find_id]#</b> כדי לחפש את קוד הזיהוי של המקור. כדי להסיר את ציטוט המקור במלואו, הכנס ערך ריק לשדה.<br /><br />";
$pgv_lang["edit_edit_raw_help"]		= "~#pgv_lang[edit_raw]#~<br /><br />דף זה מאפשר לך לערוך את רשומת ה-GEDCOM הלא מעובדת. השתמש בזהירות בדף הזה משום שיש להבין היטב את התקן GEDCOM 5.5.1. למידע נוסף על התקן GEDCOM 5.5.1, התייחס ל<b>קובץ GEDCOM</b>.<br /><br />PhpGedView מאפשר דרכים רבות להוספה ועריכה של נתונים, אבל יש מקרים בהם תרצה לערוך את התבנית הלא מעובדת של ה-GEDCOM. בכל הזדמנות שניתן, יש להשתמש בטפסים להוספת נתונים, רק במקרים שזה אינו אפשרי, השתמש בטופס הזה. בעת השמירה של הטופס יבדקו הנתונים לתאימות בסיסית לתקן ורשימת ה-CHAN תעודכן.<br /><br />";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br />PhpGedView מאפשר להעתיק עד ל-10 עובדות עם כל הפירוט שלהן ללוח הגזירים. לוח הגזירים שונה מעגלת הגזרים שבה תוכל להשתמש כדי לייצא חלקים ממאגר הנתונים שלך.<br /><br />תוכל לבחור כל נתון מלוח הגזרים ולהעתיק את העובדה הנבחרת לרשומת האדם, משפחה, מדיה, מקור או מאגר נתונים שאותו אתה עורך כעת.  אבל, לא ניתן להעתיק נתונים מסוגים שונים.  לדוגמא, אין להעתיק עובדה של נישואין למקור או אדם מכיוון שעובדת נישואין מקושרת רק עם רשומות משפחה. <br /><br />זה מאוד מועיל כאשר רוצים להוסיף עובדות דומות, כגון נתוני מפקד אוכלוסין, למספר אנשים או משפחות.<br /><br />";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />שמות מקומות יש להכניס לפי התקנים של חקר המשפחה. בחקר המשפחה רושמים מהמפורט לכללי כאשר פסיקים משמשים לסמני הפרדה בין הרמות. הרמה בה אתה רושם את נתוני המקום צריכה לייצג את הרמה של הממשל או הכנסייה בה נתונים חיוניים נשמרים עבור המקום.<br /><br />כך למשל מקום כמו סולט לייק סיטי ירשם כ\"סולט לייק סיטי, סולט לייק, יוטה, ארה\"ב\".<br /><br />הבא נבחן כל חלק של מקום זה. חלק הראשון, \"סולט לייק סיטי,\" הוא העיר או העיירה שבו האירוע התרחש. בחלק מהמדינות, יתכן שקיימות רשויות מקומיות או רבעים בתוך העיר שחשוב לציין אותם. במקרה זה הם יופיעו לפני העיר. החלק הבא, \"סולט לייק,\" הוא המחוז. \"יוטה\" היא המדינה, ו\"ארה\"ב\" המדינה. חשוב לציין כל מקום משום שרשימות חקר משפחה נשמרים ע\"י ממשלות עבור כל רמה.<br /><br />אם רמה מסוימת של המקום לא ידועה, יש להשאירה ריקה בין שני פסיקים. כך אם אין יודעים את המחוז נרשום: \"סולט לייק סיטי, ,יוטה, ארה\"ב\". נניח שיודעים רק שאדם נולד ביוטה. את העובדה יש להכניס בצורה הבאה: \", , יוטה, ארה\"ב\".<br /><br />ניתן להשתמש בקשר <b>#pgv_lang[find_place]#</b> כדי לעזור במציאת מקומות שכבר קיימים במאגר הנתונים.<br /><br />";
$pgv_lang["edit_add_parent_help"]		= "~הוסף אמא או אבא~<br /><br />בדף זה תוכל להוסיף לאדם הנבחר אם או אב חדשים. מלא את שם ההורה ונתוני הלידה והפטירה, אם הם ידועים. אם אינך יודע פרטים מסוימים, השאר את המקום ריק.<br /><br />להוספת עובדות נוספות ללידה ופטירה, יש קודם כל לשמור את השינויים המוסיפים את האדם החדש. רק אז תוכל להקיש על שם האדם בדף המשפחה המעודכן או בתג #pgv_lang[relatives]# כדי לראות את דף #pgv_lang[indi_info]# של האדם. בדף #pgv_lang[indi_info]#, תוכל להוסיף נתונים מפורטים יותר.<br /><br />";
$pgv_lang["edit_add_spouse_help"]		= "~הוסף בעל או אשה~<br /><br />בעזרת הדף הזה תוכל להוסיף בעל או אישה לאדם הנבחר. מלא את השם ונתוני הלידה והפטירה, אם הם ידועים, של האדם החדש.אם הנתונים אינם ידועים, השאר את השדה ריק.<br /><br />כדי להוסיף עובדות בנוסף לנתוני הלידה והפטירה, יש קודם כל לשמור את הנתונים של הוספת אדם. אח\"כ יש ללחוץ על שם האדם בדף המשפחה העדכני או בחוצץ #pgv_lang[relatives]# כדי לראות את דף #pgv_lang[indi_info]# של האדם. בדף #pgv_lang[indi_info]# תוכל להוסיף נתונים נוספים.<br /><br />";
$pgv_lang["edit_death_help"] 			= "~#pgv_lang[death]#~<br /><br />בקטע זה מכניסים את נתוני הפטירה של האדם שנפטר. ראשית יש להכניס את תאריך הפטירה במבנה המקובל עבור חקר משפחה <span dir=\"ltr\">(1 JAN 2004)</span>. ניתן ללחוץ על צלמית לוח השנה עבור עזרה בבחירת תאריך. אח\"כ יש להכניס את מקום הפטירה. תוכל להשתמש בקישור <b>#pgv_lang[find_place]#</b> כדי לבחור מקום שכבר קיים במאגר הנתונים.<br /><br />";
$pgv_lang["edit_birth_help"] 			= "~#pgv_lang[death]#~<br /><br />בקטע זה מכניסים את נתוני הלידה של אדם .הכנס קודם כל את תאריך הלידה במבנה המקובל עבור חקר משפחה <span dir=\"ltr\">(1 JAN 2004)</span>. ניתן ללחוץ על צלמית לוח השנה עבור עזרה בבחירת תאריך. אח\"כ הכנס את מקום הלידה. תוכל להשתמש בקישור <b>#pgv_lang[find_place]#</b> כדי לבחור מקום שכבר קיים במאגר הנתונים.<br /><br />";
$pgv_lang["edit_sex_help"]			= "~#pgv_lang[sex]#~<br /><br />בחירת המגדר מתבצעת מרשימה נגללת. האפשרות <b>בלתי ידוע</b> מציינת שהמגדר אינו ידוע.<br /><br />";
$pgv_lang["edit_name_help"]		= "~#pgv_lang[name]#~<br /><br />שדה זה של רשומת שם האדם הוא השדה החשוב.<br /><br />השדה הזה מתמלא בצורה אוטומטית כאשר ממלאים שדות אחרים, אבל הוא קיים כדי לאפשר לך לערוך את הנתונים לפי העדפתך.<br /><br />יש להכניס את השם לפי תקן GEDCOM 5.5.1 עם לוכסנים \"/\" בשני הצדדים של שם המשפחה. כדוגמא, שם \"John Robert Finlay Jr.\" יש להכניס בצורה הבאה: \"John Robert /Finlay/ Jr.\".<br /><br />";
$pgv_lang["edit_suffix_help"]		= "~#pgv_lang[suffix]#~<br /><br />בשדה רשות זה יש להכניס את סיומת השם של האדם. דוגמאות לסיומות אנגליות הן \"Sr.\", \"Jr\", ו-\"III\".<br /><br />";
$pgv_lang["edit_surname_help"]		= "~#pgv_lang[surname]#~<br /><br />בשדה זה יש להכניס את שם המשפחה של האדם. לדוגמא, בשם \"John Robert Finlay\", שם המשפחה שימולא כאן, יהיה \"Finlay\".<br /><br />אנשים להם שם משפחה מורכב, שרווח בספרד ופורטוגל, יפרידו בין השמות בפסיק. משמעות הדבר שהאדם יופיע תחת כל אחד מהשמות. למשל, שמות המשפחה  \"Cortes,Vega\" יופיעו תחת <b>C</b> וגם תחת <b>V</b>, בעוד שהשם \"Cortes Vega\" יופיע רק תחת <b>C</b>.<br /><br />";
$pgv_lang["edit_NICK_help"]			= "~#factarray[NICK]#~<br /><br />בשדה הזה מכניסים שמות חיבה/כינוי של האדם.<br />השדה הוא שדה רשות.<br /><br />דרכים להוסיף שם כינוי:<ul><li>בחר <b>ערוך שם</b> והכנס שם כינוי ולחץ שמור</li><li>בחר <b>הוסף שם</b> והכנס שם כינוי ושם ושמור</li><li>בחר <b>ערוך רשומת GEDCOM</b> כדי להוסיף מספר רשומות <span dir=\"ltr\">[2&nbsp;NICK ]</span > כפופות לרשומת <span dir=\"ltr\">[1&nbsp;NAME ]</span > הראשית.</li></ul>";
$pgv_lang["edit_given_name_help"]		= "~#pgv_lang[given_name]#~<br /><br />בשדה זה עלך להכניס שם פרטי, אחד או יותר, של האדם. לדוגמה, בשם \"John Robert Finlay\", השמות הפרטיים שעליך להכניס כאן הם \"John Robert\"<br /><br />";
$pgv_lang["edit_NPFX_help"]			= "~קידומת שם~<br /><br />שדה הרשות הזה מאפשר הכנסת קידומות של השם כמו למשל \"דר'\" או \"הרב\".<br /><br />";
$pgv_lang["edit_add_child_help"]		= "~ל#pgv_lang[add_child]#~<br /><br />בעזרת הדף הזה תוכל להוסיף ילד או ילדה למשפחה הנבחרת. מלא את שם הילד או הילדה ואת נתוני הלידה והפטירה אם הם ידועים. אם נתון מסוים אינו ידוע, השאר את השדה שלו ריק.<br /><br />כדי להוסיף עובדות נוספות לנתוני הלידה והפטירה, ראשית עליך לשמור את הנתונים הבסיסיים בהוספת ילד או ילדה חדשים. בהמשך, לחץ על שם הילד או הילדה על הדף המשפחתי העדכני או על חוצץ #pgv_lang[relatives]# כדי לראות את הדף #pgv_lang[indi_info]# של הילד או הילדה. בדף #pgv_lang[indi_info]# תוכל להוסיף עובדות נוספות.<br /><br />";
$pgv_lang["review_changes_help"]		= "~שינויים שלא אושרו~<br /><br />האזור מראה רשימה של כל הרשומות ששונו באון-ליין ושעדיין צריך לבדוק ולאשר אותם למאגר הנתונים.<br /><br />";
$pgv_lang["quick_update_name_help"] 	= "~עדכן שם~<br /><br />השתמש בשדות \"עדכן שם\" כדי לשנות את השם של האדם שאותו אתה עורך. הכנס בשדה \"שמות פרטיים\" את השם הפרטי או השמות הפרטיים של האדם. בשדה \"שם משפחה\" הכנס את שם המשפחה שלו. למשל אם ברצונך להכניס את השם \"John Robert Finlay\", הכנס \"John Robert\" בשדה \"שמות פרטיים\" ו-\"Finlay\" בשדה \"שם משפחה\".<br /><br />מילוי השדות  <u>ישנה</u> את השם של האדם; זה אינו מוסיף שם חדש.<br /><br /><i>הערה: אין להשתמש בשינוי שם זה אם השם השתנה בגלל נישואין חדשים. במקום זה, השתמש ב\"הוסף בעל חדש\" או \"הוסף אישה חדשה\".</i><br /><br />";
$pgv_lang["quick_update_fact_help"] 	= "~עדכן עובדה~<br /><br />השתמש בשדות \"עדכן עובדה\" כדי להוסיף נתוני עובדה חדשים או כדי לשנות עובדה קיימת של הרשומה שאותה אתה עורך. בחר תחילה עובדה מהרשימה הנגללת. הכנס אח\"כ את התאריך שבו העובדה התרחשה במבנה המקובל עבור חקר משפחה <span dir=\"ltr\">(1 JAN 2004)</span>. לקבלת עזרה בכתיבת תאריך יש ללחוץ על צלמית לוח השנה. הכנס את המקום שבו העובדה התרחשה. תוכל להשתמש בקישור <b>#pgv_lang[find_place]#</b> כדי לבחור מקום שכבר נמצא במאגר הנתונים.<br /><br />כמו עבור כל הנתונים האחרים בטופס זה, הנתונים שלך מחליפים את מה שכבר קיים או יוצרים כניסות חדשות לפי הצורך.<br /><br />";
$pgv_lang["quick_update_address_help"] 	= "~עדכן כתובת~<br /><br />השתמש בשדות \"עדכן כתובת\" כדי לשנות את הכתובת, מספר הטלפון או כתובת הדואר האלקטרוני של האדם שאותו אתה עורך.<br /><br />כמו עבור כל הנתונים האחרים בטופס זה, הנתונים שלך מחליפים את הקיים או יוצרים כניסות חדשות לפי הצורך.<br /><br />";
$pgv_lang["quick_update_spouse_help"] 	= "~הוסף בעל או אישה~<br /><br />השתמש בשדות הללו כאשר ברצונך להוסיף בעל או אישה חדשים לאדם  שאתה עורך עכשיו. הכנס את השם של הבעל החדש או האישה החדשה ונתוני הלידה לשדות שלהם ואח\"כ הכנס את תאריך הנישואין בנתוני הנישואין. הכנס תאריכים במבנה המקובל עבור חקר משפחה <span dir=\"ltr\">(1 JAN 2004)</span>.  לקבלת עזרה בכתיבת תאריך יש ללחוץ על צלמית לוח השנה. תוכל להשתמש בקישור <b>#pgv_lang[find_place]#</b> כדי לבחור מקום שכבר קיים במאגר הנתונים.<br /><br />השדות מוסיפות רק בן/בת זוג <i>חדש/ה</i>; הם אינם מעדכנים נתונים של בני זוג קיימים. כדי לערוך את הנתונים של אדם שכבר רשום, סגור חלון זה ולחץ על השם של האדם בחוצץ  #pgv_lang[relatives]#. לחץ אחר כך בתפריט ערוך אדם כדי לערוך את הנתונים.<br /><br />";
$pgv_lang["quick_update_marriage_help"] 	= "~עדכן נישואין~<br /><br /> תוכל להשתמש בשדות הללו במקביל להוספת בעל חדש או אישה חדשה אם ברצונך לרשום נישואין חדשים. אם לא תעשה זאת במקביל תשנה הכנסת נתונים לשדות הללו את נתוני הנישואין האחרונים של האדם. הכנס תאריכים במבנה המקובל עבור חקר משפחה <span dir=\"ltr\">(1 JAN 2004)</span>. לקבלת עזרה בכתיבת תאריך יש ללחוץ על צלמית לוח השנה. תוכל להשתמש בקישור <b>#pgv_lang[find_place]#</b> כדי לבחור מקום שכבר קיים במאגר הנתונים.<br /><br />";
$pgv_lang["quick_update_child_help"] 	= "~הוסף ילד/ה~<br /><br />השתמש בשדות הללו כאשר ברצונך להוסיף ילד או ילדה לאדם זה. הכנס תחילה את השם של הילד/ה ובחר את המגדר. אחר כך הכנס את תאריך ומקום הלידה של הילד/ה. הכנס תאריכים במבנה המקובל עבור חקר משפחה <span dir=\"ltr\">(1 JAN 2004)</span>. לקבלת עזרה  בכתיבת תאריך יש ללחוץ על צלמית לוח השנה. תוכל להשתמש בקישור <b>#pgv_lang[find_place]#</b> כדי לבחור מקום שכבר קיים במאגר הנתונים.<br /><br />השדות הללו מוסיפות רק ילד <u>חדש</u>. הם אינם מעדכנים נתונים של ילד שכבר רשום. כדי לערוך נתונים של אדם שכבר קיים במאגר הנתונים, סגור את החלון הזה ולחץ על שם של האדם בחוצץ #pgv_lang[relatives]#. לחץ אחר כך בתפריט ערוך אדם כדי לערוך את הנתונים.<br /><br />";
$pgv_lang["index_top10_pageviews_help"]	= "~אזור הפריטים הנצפים ביותר~<br /><br />האזור מציג את 10 האנשים, משפחות, או מקורות שהכי נצפו ע\"י מבקרי האתר. מנהלן האתר צריך להפעיל את מוני הפגיעות כדי שהאזור יופיע.<br /><br />";
$pgv_lang["useradmin_user_default_tab_help"]	= "~חוצץ בררת המחדל של משתמש~<br /><br />הקביעה הזו מאפשרת לך לקבוע איזה חוצץ יפתח אוטומטית כאשר משתמש ניגש אל דף #pgv_lang[indi_info]#. משתמשים הרשאים לערוך את נתוני המשתמש שלהם, יוכלו לשנות את הקביעה הזו.<br /><br />";
$pgv_lang["edituser_user_default_tab_help"]	= "~חוצץ בררת המחדל של המשתמש~<br /><br />הקביעה הזו מאפשרת לך לקבוע איזה חוצץ יפתח אוטומטית כאשר אתה ניגש אל דף #pgv_lang[indi_info]#.<br /><br />";
$pgv_lang["reorder_children_help"]		= "~מיון חדש של הילדים~<br /><br />הילדים מוצגים לפי הסדר שהם רשומים ברשומת המשפחה. הילדים אינם ממוינים לפי תאריך הלידה משום שפעמים רבות תאריכי הלידה של כמה מהילדים במשפחה אינן ידועים אך <u>כן</u> ידוע הסדר לפי הגיל.<br /><br />הבחירה הזו תאפשר לך לשנות את סדר הצגת הילדים כפי שהם רשומים ברשומת המשפחה. מכיוון שאולי תרצה למיין את הילדים לפי תאריכי הלידה שלהם, קיים כפתור שיעשה זאת עבורך בצורה אוטומטית.<br /><br />תוכל גם כן לגרור ולעזוב תיבת מידע כדי לשנות את הסדר של הילדים.  כאשר אתה מעביר את סימן העכבר מעל תיבת מידע, צורתו משתנה לחיצים משולבים בעלי ראש כפול. אם תלחץ ותחזיק את הכפתור השמאלי לפני שאתה מזיז את סימן העכבר, תיבת המידע תעבור עם סממן העכבר למעלה או למטה ברשימה.  כאשר תיבת המידע מועברת, התיבות האחרות מפנות מקום.  כאשר תשחרר את הכפתור השמאלי, תיבת המידע תקבל את מקומו החדש ברשימה.<br /><br />";
$pgv_lang["rss_feed_help"]			= "~RSS FEED SETTINGS~<br /><br />The ATOM/RSS feed available in PhpGedView allows anyone to view, using a suitable feed aggregator, the contents of your site's Welcome page without visiting the site. Most aggregators will pop up a notice letting the user know when something has changed on a page being monitored. This essentially allows anyone to monitor your PhpGedView site without needing to visit it regularly.<br /><br />The Feed block is used to customize the link to the feed, allowing specific feed types (most readers can deal with most types so this can usually be left at the default), and the specific module you would like in your feed. The language of the feed and the GEDCOM used will be based on the language and GEDCOM active in PhpGedView when you select the feed.<br /><br />The types of feed that can be generated include ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML and JavaScript. The first four types are for feed aggregators, while JavaScript and HTML are meant to enable inclusion of the feeds in other web pages.  Note that the numbers of the RSS feed indicate different styles, not a different version.<br /><br />There is an option to select authentication that will log the user in, and allow the user to view, using a suitable RSS aggregator, any information that he could normally view if logged in. Basic Authentication uses <i>Basic HTTP Authentication</i> to log the user in. Future enhancements might allow <i>Digest Authentication</i>.<br /><br />This <a href='http://en.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>Wikipedia article</b></a> contains comprehensive information and links about RSS and the various RSS formats. <i>Basic HTTP Authentication</i> is discussed in this <a href='http://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>Wikipedia article</b></a>, while <i>Digest Authentication</i> is discussed in this <a http://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>Wikipedia article</b></a>.<br /><br />"; //@#@

$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />ההגדרות של קובץ ה-GEDCOM שלך מאפשרות עד ל-#GLOBALS[MEDIA_DIRECTORY_LEVELS]# רמות של תיקיות מעל ברירת המחדל <b><span dir=\"ltr\">#GLOBALS[MEDIA_DIRECTORY]#</span></b> שבו מאוחסנים בד\"כ קובצי המדיה המועלים. דבר זה מאפשר לך ארגון קובצי המדיה שלך, ואין צורך לדאוג שלכל קובץ מדיה יהיה שם בלעדי.<br /><br />בשדה זה תגדיר את תיקיית היעד על השרת שבו יאוחסן קובץ המדיה שיועלה.  יש לשים לב לסוג האותיות (גדולות או קטנות) של מה שנכתב כאן, מכיוון ששמות התיקיות והקובצים רגישים לגודל האות.<br /><br />אם התיקייה שאתה מכניס כאן אינה קיימת, היא תיווצר בצורה אוטומטית. אם תכניס יותר רמות לתיקיות מאשר ה-#GLOBALS[MEDIA_DIRECTORY_LEVELS]# המותרים ע\"י הגדרות ה-GEDCOM שלך, הנתונים שהכנסת יקוצצו בהתאם.<br /><br />תמונות מזעריות מועלות או נוצרות במבנה תיקיות זהה כאשר הן מתחילות מ-<b><span dir=\"ltr\">#GLOBALS[MEDIA_DIRECTORY]#thumbs/</span></b>.<br /><br />";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />בשדה זה תציין במחשב המקומי שלך את מיקום ושם קובץ המדיה שאותו תרצה להעלות לשרת. תוכל להשתמש בכפתור <b>Browse</b> כדי לחפש את הקובץ הרצוי במחשב המקומי שלך.<br /><br />לקובץ שיועלה לשרת יהיה שם זהה, והוא יועלה לתיקיה אשר הגדרת בשדה <b>#pgv_lang[folder]#</b>.<br /><br /> אם אינך רואה את השדה או אינך יכול לשנותו, הגדרת קובץ ה-GEDCOM אינה מאפשרת רמות של תיקיות מעבר לברירת המחדל <b><span dir=\"ltr\">#GLOBALS[MEDIA_DIRECTORY]#</span></b> שבו הקבצים שמועלים נשמרים בדרך כלל. במקרה הזה, קובץ המדיה יועלה לתיקייה <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.<br /><br />";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br /><br />בשדה זה תציין על המחשב המקומי שלך את המיקום ושם הקובץ המזערי שאותו תרצה להעלות לשרת.  תוכל להשתמש בכפתור <b>Browse</b> כדי לחפש את הקובץ הרצוי במחשב המקומי שלך.  כאשר השדה הזה ימולא, מתעלמים מתיבת הבחירה <b>#pgv_lang[auto_thumbnail]#</b>.<br /><br />אם שדה <b>#pgv_lang[media_file]#</b> מולא, השם של הקובץ המזערי המועלה יהיה לפי תוכן השדה, ללא תלות בשמו במחשב המקומי שלך.  אם השדה יישאר ריק, יועתק הקובץ המזערי לשני מקומות על השרת, פעם לתיקייה המוגדרת בשדה <b>#pgv_lang[folder]#</b>, ופעם שניה למבנה תיקיות זהה שמתחיל ב-<b><span dir=\"ltr\">#GLOBALS[MEDIA_DIRECTORY]#thumbs/</span></b>.<br /><br />אם אינך רואה את השדה <b>#pgv_lang[folder]#</b> או אם אינך יכול לשנותו, אז אין לך די הרשאות או הגדרת קובץ ה-GEDCOM אינה מאפשרת רמות של תיקיות מעבר לברירת המחדל <b><span dir=\"ltr\">#GLOBALS[MEDIA_DIRECTORY]#</span></b> שבו הקובצים  שמועלים נשמרים בדרך כלל.<br /><br />";

//-- GENERAL
$pgv_lang["help_header"]			= "מידע על:";
$pgv_lang["privacy_error_help"]		= "נתונים אישיים<br /><br />יש מספר סיבות שיכולות לגרום לכך שתראה הודעה זו על המסך:<br /><br /><ul><li><b>הנתונים על אנשים חיים מוגדרים כ\"אישיים\"</b><br />מבקרים ומשתמשים רשומים שבכניסה לא הזדהו (Login) יכולים לראות מידע שלם רק עבור אנשים שנפטרו.  במידה והמנהלן אפשר את האופציה, מבקרים יכולים להירשם ע\"י לחיצה על כפתור ההתחברות ואח\"כ על קישור #pgv_lang[requestpassword]#.<br /></li><li><b>הנך משתמש בעל קוד משתמש וסיסמא...</b><br />אבל לא התחברת בהצלחה או לא היית פעיל זמן מה והניתוק האוטומטי פעל.<br /></li><li><b>מסיבות פרטיות</b><br />האדם לא רוצה שנתוניו יוצגו בכלל (חבוי) וביקש, אולי, מהמנהלן להגדירו כ\"אישי\". את הפרטיות ניתן להגדיר כ-:<br /><ol><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ol></li><li><b>מחוץ ל\"שביל הקשר\"</b><br />אפילו שהנך משתמש רגיל <u>וגם</u> מחובר, יתכן שתראה את ההודעה הזו, אם האדם שאת נתוניו אתה מנסה לראות אינו די קרוב אליך, לפי הגדרת מספר שלבי הקשר (אורך שביל הקשר) שמנהלן האתר הגדיר עבור GEDCOM זה.<br /><br />דוגמאות:<br />כאשר אורכו של שביל הקשר <b>1</b>, תוכל לראות נתונים רק של המשפחה הקרובה שלך: אבא, אמא, אח, אחות (אבל לא בת זוג של אחיך, בן זוג של אחותך או ילדיהם)<br /><br />כאשר אורך שביל הקשר <b>2</b>, תוכל לראות נתונים גם של אשת אחיך וילדיהם (אבל לא של בני הזוג של הילדים).<br /><br />ככל שהמספר של שביל הקשר גבוה יותר, תוכל לראות פרטים של קרוביך המרוחקים יותר.<br /></li></ul><br />אם ניראה לך שאתה עומד בדרישות לראות פרטים מסוימים שמוחבאים, פנה למנהלן האתר ע\"י לחיצה על הקישור על דף כלשהו.<br /><br />";
$pgv_lang["more_help"]			= "<br />עזרה (ספציפית) זמינה על כל דף, ודא שאופצית ה<b>#pgv_lang[show_context_help]#</b> דלוקה בתוך תפריט העזרה ולחץ על <b>?</b> ליד הנושא.<br /><br />";
$pgv_lang["more_config_help"]		= "<br /><b>עזרה נוספת</b><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["start_admin_help"]		= "+++ התחל מידע ניהולי נוסף +++";
$pgv_lang["end_admin_help"]			= "--- סיים מידע ניהולי נוסף ---";
$pgv_lang["multiple_help"]			= "<center>--- טכסט עזרה כללי עבור דפים מרובים ---</center>";
$pgv_lang["header_general_help"]		= "<div class=\"name_head\"><center><b>מידע כללי</b></center></div><br />";
$pgv_lang["best_display_help"]		= "~המסך שלך~<br />PhpGedView פותח עבור רזולוציית מסך של 1024x768 פיקסלים. רזולוציה זו הינה המינימאלית כדי שהכל יוצג היטב.<br /><br />אם הרזולוציה שלך נמוכה יותר (למשל 800x600), עליך להשתמש בפס הגלילה התחתון על חלק מהדפים.<br /><br />";
$pgv_lang["preview_help"]			= "~הדפסה~<br />לחיצה על הקישור של הגרסה הידידותית להדפסה מסירה את הפרטים שאינם נראים טוב על דף מודפס (תפריטים, תיבות הכנסת נתונים, קישורים נוספים, סימני שאלה של העזרה המקושרת, וכו').<br /><br />על דף הגרסה הידידותית להדפסה תקבל קישור <b>הדפס</b> בתחתית הדף. לחץ עליו ודף ההדפסה הרגיל שלך יצוץ. אחרי ההדפסה לחץ על קישור ה-<b>Back/חזרה</b> והדף יבנה מחדש בצורה הרגילה.<br /><br />הערה: למרות שהרבה קישורים הוסרו מ-\"הגרסה הידידותית להדפסה\", ניתן עדיין ללחוץ על הקישורים הנותרים.<br /><br />";
$pgv_lang["readme_help"]			= "ראה <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> למידע נוסף באנגלית.";
$pgv_lang["is_user_help"]			= "--- טכסט העזרה הזה זהה למה שהמשתמש (או המבקר) יראה. --- <br />--- לא הכנו טכסט מיוחד על אדמיניסטרציה עבור הנושא הזה, כדי לחסוך במקום. ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~ערוך רשומת GEDCOM לא מעובדת~<br /><br />כאשר תלחץ על הקישור יפתח חלון חדש עם נתוני GEDCOM לא מעובדים הקשורים לדף.<br /><br />תוכל לערוך נתוני ה-GEDCOM ישירות. וודא הכנסת נתונים במבנה GEDCOM 5.5.1, משום שהנתונים אינם עוברים אימות נוסף. הנתונים ששונו ו-/או התווספו יסומנו ב-PhpGedView כ\"שינויים\", ומשתמש בעל הרשאות אישור חייב לאשר אותם.<br /><br />";
$pgv_lang["RESN_help"]			= "~הגבלות על עובדות~<br /><br />בנוסף להגדרות הפרטיות הרגילות, ל-PhpGedView יש אפשרות להגדיר הגבלות להצגה או עדכון של נתוני עובדות של אנשים ומשפחות. כל מי שיכול לערוך את הנתונים, יכול גם להגדיר את ההגבלות, אלא אם הפרטיות או ההגבלות הקודמות מונעות פעולה זו.<br /><br />ניתן להשתמש בערכים הבאים:<br /><ul><li><b>#pgv_lang[none]#</b><br />מנהלני האתר, מנהלני GEDCOM ומשתמשים בעלי הרשאות עדכון, יכולים לשנות את הנתונים. את נתוני העובדות ניתן לראות לפי הגדרות הפרטיות שהוגדרו על ידי המנהלן.</li><li><b>#pgv_lang[locked]#</b><br />לאופציה הזו אין השפעה על האפשרות לראות את הנתונים של העובדות. היא מגבילה את הרשאות העדכון של מנהלני האתר ומנהלני ה-GEDCOM. אם הנתונים נוגעים למשתמש עצמו, הוא יכול גם לראות, ובהנחה שיש לו הרשאות עדכון, גם לעדכן אותם.</li><li><b>#pgv_lang[privacy]#</b><br />מנהלני האתר ומנהלני ה-GEDCOM יכולים לראות ולעדכן את הנתונים. אם הנתונים נוגעים למשתמש עצמו, גם הוא יכול לראות, ובהנחה שיש לו הרשאות עדכון, לעדכן אותם. הנתונים מוחבאים לכול יתר המשתמשים ללא תלות בסטאטוס החיבור שלהם.</li><li><b>#pgv_lang[confidential]#</b><br />רק מנהלני האתר ומנהלני ה-GEDCOM יכולים לראות ולעדכן את הנתונים. הנתונים חבויים לכל יתר המשתמשים ללא תלות בסטאטוס החיבור שלהם.</li></ul><br /><table><tr><th></th><th colspan=\"2\">אדמינ'</th><th colspan=\"2\">בעלים</th><th colspan=\"2\">אחרים</th></tr><tr><th></th><th>R</th><th>W</th><th>R</th><th>W</th><th>R</th><th>W</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" /> #pgv_lang[none]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" /> #pgv_lang[locked]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" /> #pgv_lang[privacy]#</td><th><img src=\"images/checked.gif\" alt=\"\" ></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" /> #pgv_lang[confidential]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>R : יכול לקרוא</li><li>W : יכול לערוך</li><li><img src=\"images/checked_qm.gif\" alt=\"\" /> : תלוי בהגדרות פרטיות כלליות</li></ul>";

//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]			= "~דף ברוכים הבאים~<br /><br />הדף הזה הוא דף הכניסה. הוא מברך אותך בכניסה לקובץ ה-<a href=\"#def_gedcom\">GEDCOM</a> הנבחר. תוכל לחזור לדף הזה ע\"י בחירת דף ברוכים הבאים בתפריט העליון.  אם באתר קיימים מספר GEDCOM-ים, תבחר את ה-GEDCOM מהתפריט הנגלל.<br /><br />הדף הזה כולל הסברים על:<ul><li><a href=\"#index_portal\"><b>דף ברוכים הבאים</b></a></li><li><a href=\"#header\"><b>אזור כותרת</b></a></li><li><a href=\"#menu\"><b>תפריטים</b></a></li><li><a href=\"#header_general\"><b>מידע כללי</b></a></li><li><a href=\"#def\"><b>הגדרות</b></a></li></ul><br />";

//-- Index-page Header
$pgv_lang["header_help"]			= "<div class=\"name_head\"><center><b>אזור כותרת</b></center></div><br />הכותרת מוצגת על החלק העליון של כל דף. הכותרת כוללת קישורים שימושיים לשימוש בכל האתר.<br /><br />מכיוון שלאתר הזה יכולים להיות מספר הופעות, לפי בחירת <a href=\"#def_theme\">עיצוב האתר</a>, יתכן והכותרות מושפעות והקישורים יכולים להיות שונים.<br /><br />יתכן ותמצא את הקישורים הבאים:<ul><li><a href=\"#header_search\"><b>תיבת החיפוש</b></a></li><li><a href=\"#header_lang_select\"><b>בחירת שפה</b></a></li><li><a href=\"#header_user_links\"><b>קשרים של משתמש</b></a></li><li><a href=\"#header_favorites\"><b>מועדפים</b></a></li><li><a href=\"#header_theme\"><b>שינוי עיצוב</b></a></li></ul>";
$pgv_lang["header_search_help"]		= "~אזור הכותרת: תיבת החיפוש~<br />תיבת החיפוש הזו קטנה אבל חזקה.<br />תוכל לתת ל-PhpGedView לחפש עבורך כמעט כל דבר. כאשר תילחץ על כפתור ה-<b>&gt;</b> או על<b> חפש</b>, תקושר לדף החיפוש לצפייה בתוצאות החיפוש שלך. עזרה מקיפה על החיפוש תמצא בדף החיפוש.<br /><br />";
$pgv_lang["header_lang_select_help"]	= "~אזור הכותרת: בחירת שפה~<br />אחד המאפיינים החשובים של PhpGedView הוא התמיכה בשפות רבות.<br /><br />השפה שבה PhpGedView מציג את כל הדפים נקבעת אוטומטית לפי השפה המועדפת של הדפדפן. אבל, יתכן שמנהלן האתר הגביל את הזמינות של שפות מסוימות.<br /><br />במסגרת  עיצוב האתר, יתכן שתוכל לשנות את השפה של PhpGedView ע\"י בחירה של שפה מתאימה מחלון נגלל או ע\"י לחיצה על צלמית דגל. אם אתה משתמש רשום, תוכל לעצב את PhpGedView לעבור לשפה המועדפת שלך אחרי שתתחבר, ללא תלות בשפה של הדפדפן שלך.<br /><br />";
$pgv_lang["header_user_links_help"]		= "~אזור הכותרת: קישורים של משתמש~<br />זהו אזור עם קישורים שימושיים שימצא במקום קבוע בכל הדפים. מקום הקישורים משתנה לפי העיצוב הפעיל.<br /><br />אם טרם התחברת למערכת, תראה רק קישור <b>התחבר</b>. כאשר אתה מחובר, תראה: <ul><li><b>מחובר בשם (קוד המשתמש שלך). </b>לחיצה על קישור זה מביאה אותך לנתוני המשתמש שלך.</li><li>לחיצה על <b>התנתק</b> מנתקת אותך מהאתר.</li><li>אם יש לך הרשאות של מנהלן, תראה גם <b>ניהול</b>. לחיצה על הקישור מביאה אותך ישירות לדף הניהול המרכזי.</li></ul><br />";
$pgv_lang["header_favorites_help"]		= "~אזור הכותרת: מועדפים~<br />הרשימה הנגללת של המועדפים מראה את המועדפים שבחרת בפורטל האישי שלך. היא מראה גם את המועדפים שמנהלן האתר בחר עבור ה-GEDCOM הפעיל. לחיצה על אחד המועדפים מביאה אותך ישירות לדף #pgv_lang[indi_info]# של האדם הזה.<br /><br />עזרה נוספת על הוספת מועדפים נמצאת בפורטל האישי שלך.<br /><br />";
$pgv_lang["header_theme_help"]		= "~אזור הכותרת: שנה עיצוב~<br />אם מנהלן האתר אפשר את האופציה, הרשימה הנגללת של שנה עיצוב מראה לך את כל העיצובים שתוכל להשתמש כאשר אתה מסתכל על האתר.<br /><br />בחירת עיצוב מהרשימה הנגללת תשנה את העיצוב של האתר. אם אתה מחובר, תשנה הפעולה את העיצוב האישי שלך לעיצוב שבחרת, כך שבפעם הבאה שתתחבר, העיצוב הזה יבחר אוטומטית.<br /><br />";

//-- Index-page Menu
$pgv_lang["menu_help"]			= "<div class=\"name_head\"><center><b>תפריטים</b></center></div><br />בכותרות הדפים יש תפריטים נגללים הקשורים לכל צלמית של התפריט.<br /><br />העברת סימן העכבר מעל צלמית תראה לך תת-תפריט, במידה והוא קיים עבור הפריט. לחיצה על הצלמית תעביר אותך לדף שהוא הכניסה הראשונה בתת-תפריט.<br /><br /><b>צלמיות התפריטים הבאים קיימות בדרך כלל:</b><ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /></li><li><a href=\"#menu_myged\">פורטל#pgv_lang[mygedview]#</a><br /></li><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /></li><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /></li><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /></li><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /></li><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /></li><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></li></ul><br />";
$pgv_lang["menu_famtree_help"]		= "~תפריט דף ברוכים הבאים~<br />כל מאגרי המידע של האתר רשומים בתפריט זה. לכל אחד ממאגרי המידע יש דף ברוכים הבאים מותאם דומה לדף הזה. במידה ובאתר הזה קיים רק מאגר מידע אחד, אין תפריט משני עבור הצלמית של ברוכים הבאים.<br /><br />";
$pgv_lang["menu_myged_help"]		= "~תפריט #pgv_lang[mygedview]#~<br />אם אתה מחובר לאתר, התפריט הזה יכול לכלול את הפרטים הבאים:<ol><li>פורטל#pgv_lang[mygedview]#<br />מעביר אותך לדף ההתחלה האישי שלך שניתן להתאמה.</li><li>#pgv_lang[editowndata]#<br />כאן תוכל לערוך את נתוני המשתמש שלך.</li><li>#pgv_lang[my_pedigree]#<br />מביא אותך לאילן היוחסין, כאשר אדם המוצא הוא לפי בחירתך עבור GEDCOM זה.</li><li>#pgv_lang[my_indi]#<br />קישור זה יעביר אותך לדף #pgv_lang[indi_info]# שלך. בדף זה מוצגים כל נתוני חקר שושלת היוחסין שלך ושל משפחתך.</li></ol><br />";
$pgv_lang["menu_charts_help"]		= "~תפריט תרשימים~<br />התרשימים הקיימים הם:<ol><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />מקשר אותך לתרשים אילן יוחסין של קובץ ה-GEDCOM הזה. העץ מתחיל עם האדם שהמנהלן הגדיר. כאשר אתה מחובר, אדם המוצא יהיה האדם שהגדרת בהעדפות המשתמש שלך.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />תרשים הצאצאים הוא, פחות או יותר, <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a> בסדר הפוך. ההשוואה הזו לא לגמרי נכונה, אבל בעוד שאילן יוחסין מראה לך את כל אב-אבותיו של אדם המוצא, תרשים הצאצאים מראה לך את כל הצאצאים של אדם המוצא.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />כאן תראה את המאורעות של אדם מסוים לאורך קו הזמן. מעניין להשוות את המאורעות של שניים או יותר אנשים לאורך אותו קו זמן.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />כאן ניתן לבדוק את הקשר של אדם אליך או אל אדם אחר.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />דומה מאוד ל<a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, אבל עם יותר פרטים ועם מצגות <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a> חילופיות.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />דומה מאוד ל<a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, בצורה גראפית יותר.</li></ol><br />";
$pgv_lang["menu_lists_help"]			= "~תפריט רשימות~<br />הרשימות הבאות קיימות בתפריט זה:<ol><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />בשתי הרשימות תוכל לחפש אנשים ומשפחות שמופיעים ב-GEDCOM זה.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />פריט זה מחזיר רשימה של כל המקורות שה-GEDCOM משתמש בהם.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />כאן תוכל לחפש אנשים לפי מקום. תקבל רשימה בשני טורים. האנשים רשומים מימין, המשפחות משמאל.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />תראה את פריט התפריט הזה רק אם מנהלן האתר אפשר זאת.<br />בתפריט תראה תצוגה של קישורים לכול קובצי המולטימדיה של ה-GEDCOM.</li></ol><br />";
$pgv_lang["menu_annical_help"]		= "~תפריט #pgv_lang[anniversary_calendar]#~<br />#pgv_lang[anniversary_calendar]# מציג מאורעות של GEDCOM עבור יום, חודש או שנה מסוימים.<ol><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />לחיצה על פריטי תפריט אלו מביאה אותך ל #pgv_lang[anniversary_calendar]#, שם תראה את המאורעות של היום, החודש או השנה.</li></ol><br />";
$pgv_lang["menu_clip_help"]			= "~תפריט #pgv_lang[clippings_cart]#~<br />אם מנהלן האתר שלך איפשר את האופציה, תראה את הפריט בתפריט העמוד.<br /><br />#pgv_lang[clippings_cart]# מאפשרת לך לאחסן אנשים, משפחות ומקורות בקובץ זמני שאותו ניתן אחר כך להוריד במבנה GEDCOM 5.5.<br /><br />";
$pgv_lang["menu_search_help"]		= "~תפריט חפש~<br />דף החיפוש הוא מנגנון חיפוש חזק יותר מקישור החיפוש שיתכן ותמצא בכותרת כל דף.<br /><br />";
$pgv_lang["menu_help_help"]			= "~תפריט עזרה~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>דף ברוכים הבאים</b></center></div><br />";
$pgv_lang["index_portal_help"]		= "דף ברוכים הבאים מורכב ממספר אזורים נפרדים וניתן להתאמה. באתרים בהם קיימים יותר ממאגר נתונים אחד, יתכן ותראה דף ברוכים הבאים שונה עבור כל אחד. לפי התאמת האתר ע\"י המנהלן, תוכל לראות את האזורים הבאים בדף ברוכים הבאים:<ul><li><a href=\"#index_welcome\"><b>ברוכים הבאים</b></a></li><li><a href=\"#index_login\"><b>התחברות</b></a></li><li><a href=\"#index_events\"><b>אירועים קרובים</b></a></li><li><a href=\"#index_onthisday\"><b>ביום הזה - בהיסטוריה שלך</b></a></li><li><a href=\"#index_charts\"><b>תרשימים</b></a></li><li><a href=\"#index_favorites\"><b>מועדפי GEDCOM</b></a></li><li><a href=\"#index_stats\"><b>סטטיסטיקות GEDCOM</b></a></li><li><a href=\"#index_common_surnames\"><b>שמות משפחה שכיחים</b></a></li><li><a href=\"#index_media\"><b>מדיה אקראית</b></a></li><li><a href=\"#index_loggedin\"><b>משתמשים מחוברים</b></a></li><li><a href=\"#gedcom_news\"><b>חדשות GEDCOM</b></a></li><li><a href=\"#recent_changes\"><b>השינויים האחרונים</b></a></li></ul><br />";
$pgv_lang["index_welcome_help"]		= "~אזור ברוכים הבאים~<br />אזור ברוכים הבאים מראה לך את הכותרת של מאגר הנתונים הנוכחי, את היום והשעה, ואם המנהלן מאפשר, את ספירת הפגיעות.<br /><br />את ספירת הפגיעות, תמצא רק באזור ברוכים הבאים ובדף #pgv_lang[indi_info]#. המונה סופר \"פגיעות\" של הדפים הללו. משמעות הדבר: הוא סופר כמה פעמים ביקרו בדפים האלה. המונה לא בודק את כתובת האינטרנט של המבקר, כך שכל ביקור לדף ממקום מרוחק <u>כלשהו</u> נספר כפגיעה נוספת.<br /><br />";
$pgv_lang["index_login_help"]			= "~אזור התחברות~<br />למרות שניתן להתחבר כמעט מכל דף של תוכנית זו, תרצה בדרך כלל לבצע פעולה זו מהדף הראשון, כי גישה לנתונים חסויים מותרת רק כאשר אתה מחובר.<br />תוכל להתחבר ע\"י הקלדה של <b>קוד  המשתמש</b> ו<b>הסיסמא</b> ולחיצה על כפתור התחבר.<br /><br />";
$pgv_lang["index_events_help"]		= "~אזור אירועים  קרובים~<br />האזור הזה מראה לך אירועים שיתרחשו בקרוב.<br /><br />המנהלן קובע את גבולות האזור. תוכל לעדן את התצוגה של האירועים הקרובים בעזרת בחירת מספר קבועים.<br /><br />";
$pgv_lang["todo_help"] 			= "~אזור &quot;משימות - TO DO&quot;~<br />אזור &quot;משימות - To Do&quot; עוזר לך לעקוב אחרי מטלות <span dir=\"ltr\">_TODO</span> בקובץ ה-GEDCOM שלך.  כדי להוסיף &quot;משימות - To Do&quot; לרישומים שלך, יתכן שעליך לכלול קודם <span dir=\"ltr\">_TODO</span> ברשימת העובדות בתצורת ה-GEDCOM שלך.<br /><br />";
$pgv_lang["todo_show_other_help"]     	= "הצג &quot;משימות - To Do&quot; לביצוע אשר שוייכו למשתמשים אחרים";
$pgv_lang["todo_show_unassigned_help"]	= "הצג &quot;משימות - To Do&quot; לביצוע אשר לא משוייכות לאף משתמש";
$pgv_lang["todo_show_future_help"]		= "הצג &quot;משימות - To Do&quot; לביצוע בעלות תאריך עתידי.  אחרת מוצגים רק פריטים עם תאריך בעבר.";
$pgv_lang["yahrzeit_help"]                      	="~אזור ימי שנה קרובים~<br />האזור הזה מראה לך את אירועי יום השנה שיתרחשו בקרוב.<br /><br />ימי שנה (יארצייטים) הן ימי השנה לפטירתו של אדם.  ימי השנה הללו נהוגים במסורת היהודית. הם כבר אינם בשימוש במסורות אחרות .<br /><br />המנהלן קובע את גבולות האזור. תוכל לעדן את התצוגה של אירועי יום השנה הקרובים בעזרת בחירת אופציות הגדרה .<br /><br />";
$pgv_lang["days_to_show_help"]		= "~#pgv_lang[days_to_show]#~<br /><br />הכנס את הימים שיש להראות. המספר לא יכול להיות גדול מ<b>#DAYS_TO_SHOW_LIMIT#</b>. אם תכניס ערך גדול יותר, התוכנה תשתמש בערך הגבולי.<br /><br />הערך הגבולי הוגדר ע\"י המנהלן כחלק מהגדרות ה-GEDCOM, בפסקה תצוגה ומבנה, פיסקת משנה הסתר והראה.";
$pgv_lang["random_media_persons_or_all_help"] 	= "~#pgv_lang[random_media_persons_or_all]#~<br /><br />האפשרות הזו מאפשרת לך לקבוע את סוג המדיה שמראים.<br /><br />כאשר בוחרים <b>#pgv_lang[random_media_persons]#</b>, רק מדיה הקשורה לאנשים מוצגת. בדרך כלל מדובר בתמונת האדם.  כאשר בוחרים <b>#pgv_lang[random_media_events]#</b>, רק מדיה הקשורה לעובדות או מאורעות מוצגת. יתכן שזו תעודה סרוקה.  כאשר בוחרים <b>#pgv_lang[all]#</b>, האזור מראה את כל סוגי המדיה.";
$pgv_lang["random_media_filter_help"] 	= "~#pgv_lang[filter]#~<br /><br />תוכל להגביל את מה שמותר לאזור מדיה אקראית להראות לפי סוג המדיה. כאשר תיבת בחירה מסוימת מסומנת, מותר לאזור המדיה האקראית להציג ישויות מדיה במבנה או סוג שניבחר.<br /><br />הקודים של מבנה או סוג שקיימים במאגר הנתונים שלך, אבל לא בתיבות הבחירה, מתנהגים כאילו סומנו בתיבות הבחירה שלהם. לדוגמה, אם מאגר הנתונים שלך כולל ישויות מדיה במבנה  <b><i>pdf</i></b>, מותר לאזור המדיה האקראית תמיד להציג אותם. בדומה, אם מאגר הנתונים שלך כולל ישויות מדיה מסוג <b><i>מיוחד</i></b>, מותר לאזור מדיה אקראית תמיד להציג אותם.";
$pgv_lang["basic_or_all_help"]		= "~#pgv_lang[basic_or_all]#~<br /><br />האפשרות הזו מאפשרת לך לסלק חלק מהאירועים עם תאריכים. למשל, #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, וכו' אמורים להופיע עם תאריך.<br /><br />כאשר תבחר <b>כן</b>, רק לידות, פטירות וחתונות יוצגו. כאשר תבחר <b>לא</b>, כל האירועים עם תאריכים יוצגו.";
$pgv_lang["style_help"]			= "~#pgv_lang[style]#~<br /><br />האפשרות הזו קובעת איך הנתונים מוצגים.<br /><br />כאשר תבחר <b>#pgv_lang[style1]#</b>, המידע מוצג במבנה טכסט, בדומה למה שתראה בתיבות של התרשימים השונים. המבנה מתאים במיוחד לאזורים המודפסים בצד הימני של הדף.<br /><br />כאשר תבחר <b>#pgv_lang[style2]#</b>, הנתונים מוצגים במבנה שמאורגן בצורת טבלה, המתאים יותר לאזורים הגדולים יותר בצד שמאל של הדף.";
$pgv_lang["sort_style_help"]			= "~#pgv_lang[sort_style]#~<br /><br />האפשרות הזו שולטת באיך המידע ממויין.<br /><br />כאשר תבחר <b>#pgv_lang[by_alpha]#</b>, המידע מוצג בסדר אלפא-בתי. כאשר תבחר <b>#pgv_lang[by_anniv]#</b>, המידע ממויין לפי יום שנה, עם ימי השנה האחרונים ביותר כראשונים.";
$pgv_lang["cal_dowload_help"]		= "~#pgv_lang[cal_download]#~<br /><br />האפשרות הזו קובעת אם להראות למשתמשים מחוברים צלמית להורדת אירועי לוח שנה. ניתן לייבא את הקובץ שהורד לתוכניות כמו Microsoft Outlook כדי למשל ליצור תזכורות דואר אלקטרוני אוטומטיות של ימי שנה.<br /><br />כאשר הערך <b>#pgv_lang[no]#</b>, המשתמשים המחוברים אינם יכולים להוריד קובץ לוח שנה.  כאשר הערך <b>#pgv_lang[yes]#</b>, צלמית ההורדה מוצגת. משתמשים שאינם מחוברים לא רואים את הצלמית אף פעם.";
$pgv_lang["index_charts_help"]		= "~#pgv_lang[charts_block]#~<br />האזור כולל בתוכו תרשים אילן יוחסין או צאצאים או שעון חול בדף הפורטל של ברוכים הבאים או MyGedView. בשל מגבלות מקום, יש למקם את התרשים רק בצד שמאל של הדף .המנהלנים יכולים לבחור את אדם המוצא וסוג התרשים בדף ברוכים הבאים.<br /><br />התרשים מתנהג כמו תרשימים אחרים באתר זה. לחץ על תיבה של אדם כדי לראות עליו נתונים נוספים.<br /><br />";
$pgv_lang["index_onthisday_help"]		= "~אזור ביום הזה - בהיסטוריה שלך~<br />אזור זה עובד בצורה דומה לאזור \"אירועים קרובים\", בהבדל שכאן מוצגים האירועים של היום.<br /><br />";
$pgv_lang["index_favorites_help"]		= "~אזור מועדפי GEDCOM~<br />אזור המועדפים של ה-GEDCOM דומה ל\"המועדפים שלי\" של #pgv_lang[mygedview]#. אבל כאן רק המנהלן של האתר או משתמשים עם זכויות מנהלן, יכולים להוסיף, להוריד או לשנות את המועדפים באזור הזה.<br /><br />הכוונה של אזור מועדפי ה-GEDCOM היא למשוך את תשומת הלב של המבקרים לאנשים בעלי עניין מיוחד. המועדפים של ה-GEDCOM זמינים לבחירה מרשימה נגללת בכותרת כל דף.<br /><br />לחיצה על אחד מהמועדפים הרשומים תעביר אותך לדף #pgv_lang[indi_info]# שלו.<br /><br />";
$pgv_lang["index_add_favorites_help"]	= "~הוסף מועדף~<br />הטופס מאפשר הוספת מועדף לרשימת המועדפים שלך.<br /><br />עליך להכניס את קוד הזיהוי של האדם, המשפחה או המקור שאותו תרצה לשמור כמועדף, או עליך להכניס URL וכותרת. שדה ההערות הוא שדה רשות ובו ניתן לשמור תאור של המועדף. תוכן שדה תאור המועדף יוצג באזור המועדפים אחרי המועדף.<br /><br />";
$pgv_lang["index_stats_help"]			= "~אזור סטטיסטיקות GEDCOM~<br />באזור זה תיראה סטטיסטיקות על קובץ ה-GEDCOM הנוכחי.<br />להסברים נוספים תוכל לשלוח הודעה לאיש הקשר בתחתית הדף.<br /><br />";
$pgv_lang["index_common_names_help"]	= "~שמות משפחה שכיחים~<br />האזור מציג רשימה של שמות המשפחה השכיחים במאגר הנתונים הזה. על שם המשפחה להופיע לפחות #COMMON_NAMES_THRESHOLD# פעמים כדי שהוא יופיע ברשימה זו. מנהלן האתר יכול לשנות את הסף הזה.<br /><br />ניתן ללחוץ על השמות ברשימה זו. כאשר לוחצים על שם, מועברים ל#pgv_lang[individual_list]#, ומקבלים מידע נוסף על השם.<br /><br />";
$pgv_lang["index_common_given_names_help"]		= "~שמות פרטיים שכיחים~<br />האזור מציג רשימה של השמות הפרטיים השכיחים במאגר הנתונים הזה. ניתן להגדיר את מספר השמות שיופיעו ברשימה.<br /><br />";
$pgv_lang["index_media_help"]		= "~אזור מדיה אקראית~<br />באזור הזה PhpGedView בוחר בצורה אקראית קובץ מדיה שאותו הוא מראה בכל ביקור בדף הזה.<br /><br />לחיצה על התמונה מראה את התמונה בגודלה המלא. לחיצה על כותרת התמונה מראה לך את דף ה-#pgv_lang[media_list]# של התמונה. מתחת לתמונה יש קישורים לאדם שקשור לתמונה. לחיצה על שם האדם, מעבירה אותך לדף #pgv_lang[indi_info]# של האדם.<br /><br />";
$pgv_lang["index_loggedin_help"]		= "~אזור משתמשים מחוברים~<br />האזור הזה מראה את המשתמשים המחוברים ברגע זה למערכת.<br /><br />אם אינך מנהלן רשימת המשתמשים המוצגת תוגבל לאלה שבחרו להיות מוצגים כאשר הם מחוברים. עליך גם לבחור שאתה תהייה מוצג כאשר אתה מחובר. משתמשים שאינך רואה נספרים כבלתי ידועים.<br /><br />";
$pgv_lang["index_gedcom_news_help"]	= "~אזור חדשות GEDCOM~<br />אזור החדשות הוא כמו לוח המודעות של ה-GEDCOM הזה. מנהלן האתר יכול לשים כאן הודעות חשובות או חדשות מעניינות.<br /><br />אם יש לך משהו מעניין להציג, נא התקשר למנהלן האתר והוא יוכל לשים את הודעתך על לוח המודעות.<br /><br />";
$pgv_lang["recent_changes_help"]		= "~אזור שינויים אחרונים~<br />האזור מראה לך את השינויים שנעשו ל-GEDCOM כפי שרשום בנתון CHAN של ה-GEDCOM.<br /><br />";
$pgv_lang["gedcom_news_limit_help"]	= "ניתן להגביל את מספר כתבות החדשות אשר מוצגות ובכך להקטין את הגובה של אזור החדשות של ה-GEDCOM.<br /><br />האופציה קובעת אם יש להפעיל הגבלות או אם ההגבלה תהייה לפי גיל הכתבה או לפי מספר הכתבות.<br /><br />";
$pgv_lang["gedcom_news_flag_help"]	= "הכנס כאן את ערך הגבול.<br /><br />אם בחרת להגביל את תצוגת כתבות החדשות לפי גיל, כתבות ישנות יותר ממספר הימים שהוכנס כאן יוסתרו מהתצוגה. אם בחרת להגביל את תצוגת כתבות החדשות לפי מספר, רק המספר הנבחר של הכתבות האחרונות יוצג בסדר הגילים. יתר הכתבות יוסתרו מהתצוגה.<br /><br />אפסים שימולאו כאן יפסיקו את ההגבלה ויגרמו לכל כתבות החדשות להיות מוצגות.<br /><br />";
$pgv_lang["gedcom_news_archive_help"]	= "המנהלן החביא כתבות, כדי להקטין את גובה אזור החדשות כתבות. תוכל לגלות את הכתבות החבויות הללו ע\"י לחיצה על קישור <b>#pgv_lang[gedcom_news_archive]#</b>.<br /><br />";
$pgv_lang["index_htmlplus_help"]		= "~אזור HTML מתקדם~<br />האזור מאפשר למנהלן להוסיף מידע לדף האינדקס או דף הפורטל. מטרתו דומה לאזורי HTML, חדשות וסטטיסטיקות של ה-GEDCOM, אבל למנהלן יש יותר שליטה על המראה שלו<br /><br />";
$pgv_lang["index_htmlplus_title_help"]	= "הטכסט הזה צריך להיות ריק או קצר מאוד.  כאשר הוא ריק, אזור ה-HTML המתקדם יוצג על דף האינדקס או הפורטל כאזור פשוט, בדומה לאזור ה-HTML. כאשר הוא כולל טכסט, אזור ה-HTML המתקדם יוצג כמו יתר האזורים, שלם עם פס כותרת של האזור שכולל את הטכסט שהכנסת כאן.";
$pgv_lang["index_htmlplus_template_help"]	= "כדי לסייע לך להתחיל עם המסגרת הזו, יצרנו מספר תבניות סטנדרטיות. כאשר תבחר  תבנית מסוימת, האזור יכלול העתק שאותו תוכל לשנות כך שיתאים לדרישות האתר שלך.";
$pgv_lang["index_htmlplus_content_help"]	= "בניגוד לאזורים HTML, חדשות וסטטיסטיקות ה-GEDCOM, יש לך שליטה מלאה על מראה האזור שלך.  תוכל להשתמש בתוויות HTML, והאזור ישתמש בסגנון CSS של העיצוב הפעיל.  בטכסט ניתן לכלול מידע מקובץ חקר המשפחה הפעיל.<br /><br />התייחסויות למאגרי מידע מסומנות בתוך הטכסט ע\"י הקפת מילות מפתח בזוגות של סימני <b>&#35;</b>. למשל, <b>&#35;totalFamilies&#35;</b> מייצג את מספר המשפחות במאגר הנתונים.  לפעמים תרצה להשתמש בהתייחסות למאגר הנתונים כטכסט במקום במשמעותו האמיתית.  לשם כך יש להחליף את סימני ה-<b>&#35;</b> אשר מקיפים את מילת המפתח בערך הסמלי השקול שלהם.  למשל, אם הטכסט כולל <b><span dir=\"ltr\">&amp;&#35;35;totalFamilies&amp&#35;35;</span></b> הוא יודפס כ-<b>&#35;totalFamilies&#35;</b> במקום שתהיה הפנייה למאגר הנתונים.<br /><br />לדוגמה שלמה של השימוש באזור זה, נא לבדוק את &quot;#pgv_lang[gedcom_stats_block]#&quot; תבנית בתיקיית ה-blocks/ , הוא משתמש ברוב הסיגנונות של תווים, כולל שפה וקישורי טכסט עזרה.<br /><br />\nלרשימה אפשרית מלאה לחץ על הכפתור &quot;<b><a href=\"javascript:;\" onclick=\"window.open('index.php?mod=gedstats&method=tagList', '_blank', 'top=50,left=10,width=600,height=600,scrollbars=1,resizable=1');\">#pgv_lang[htmlplus_block_taglist]#</a></b>&quot;.<br /><br />";
$pgv_lang["index_htmlplus_compat_help"]	= "סמן כאן עבור תאימות עם ורסיות ישנות של האזור הזה. דבר זה מאפשר שימוש במבנה ישן יותר על חשבון השפעה מועטה על המהירות.<br /><br />שימוש בצורה זו אינה מומלץ.<br /><br />";
$pgv_lang["index_htmlplus_gedcom_help"] 	= "~#pgv_lang[htmlplus_block_gedcom]#~<br />בחר את מאגר הנתונים שאליו שייכות מילות המפתח.<br /><br />האתר שלך תומך במספר מאגרי נתונים.  מילות מפתח כגון <b>&#35;totalFamilies&#35;</b> יכולות להתייחס רק למאגר אחד.  תוכל לזהות את מאגר הנתונים שבו משתמשים עם מילות המפתח הללו.  כל אזור #pgv_lang[htmlplus_block_name]# יכול לגשת רק למאגר אחד.<br /><br />";
$pgv_lang["showUnknown_help"]		= "~#pgv_lang[showUnknown]#~<br />הראה או החבא רשימת שמות פרטיים של אנשים שמינם לא ידוע.<br /><br />האזור #pgv_lang[block_givn_top10]# תמיד יחביא רשימות של שמות פרטיים אם במאגר הנתונים שלך אין אנשים בעלי מין זה. האופציה הזו מאפשר לך להחביא רשימת האנשים שמינם אינו ידוע אפילו כאשר אנשים כאלה קיימים במאגר הנתונים שלך.<br /><br />";

//-- Index-Page Help
$pgv_lang["help_help"]			= "היה מושלם אם התוכנית הייתה כל כך פשוטה לשימוש שלא היה צורך בשום הסברים; היא הייתה צריכה להיות כמו קריאה בספר.<br /><br />אפילו ש-PhpGedView מאוד מורכבת, לא תרגיש זאת כאשר אתה משתמש בה. ניתן לבצע כמעט הכל ללא הסברים נוספים. אבל, מכיוון שיש לנו הרבה מבקרים ומשתמשים שלא כל כך מנוסים בשימוש במחשב או באינטרנט, אנחנו מציעים עזרה במקומות מסוימים.<br /><br />בתפריט העזרה תימצא את הפריטים הבאים:";
$pgv_lang["help_page_help"]			= "<dl><dt><b>עזרה לדף הזה</b></dt><dd>לכל הדפים קיימת \"עזרה לדף הזה\". תוכל ללחוץ על \"עזרה לדף\" מתוך התפריט, ותראה מידע הקשור לדף הזה.<br /><br />ברוב המקרים העזרה לדף הזה קצרה. אם תזדקק לעזרה או מידע נוספים על פריט מסוים של הדף מעבר למה שהעזרה לדף מספקת, תוכל להשתמש במאפיין \"עזרה  מקושרת\".</dd></dl>";
$pgv_lang["help_content_help"]		= "<dl><dt><b>תוכן העזרה</b></dt><dd>לחיצה על פריט תפריט זה נותנת לך דף עזרה שמראה אינדקס של הנושאים הראשיים של עזרה. כמות העזרה גדלה עם הזמן.</dd></dl>";
$pgv_lang["help_faq_help"]			= "<dl><dt><b>רשימת FAQ</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]			= "<dl><dt><b>הראה/הסתר עזרה מקושרת</b></dt><dd>יתכן והערך אחרון בתפריט, הוא השימושי ביותר עבורך. לחיצה על קישור זה מפעילה או מכבה את ה\"עזרה המקושרת\".<br /><br />כאשר העזרה המקושרת מופעלת, תימצא צלמית סימן שאלה או צלמית דומה ליד קישורים, תיבות הנגללות או כפתורים מסוימים. לחיצה על הצלמית הזה תגרום לחלון עזרה לצוץ. בחלון תראה מסך עזרה קטן עם מידע נוסף על הישות.<br /><br />כמובן, אם תלחץ על \"הסתר עזרה מקושרת\", כל סימני השאלה יוחבאו עד שתלחץ שוב על \"הראה ...\".</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]				= "<div class=\"name_head\"><center><b>#pgv_lang[definitions]#</b></center></div><br />להלן הגדרות של מספר מילים בהן משתמש טכסט העזרה הזה:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>תאריכים</b></a></li><li><a href=\"#def_pdf_format\"><b>מבנה קובץ PDF</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>פורטל</b></a></li><li><a href=\"#def_theme\"><b>עיצוב</b></a></li></ul><br />";
$pgv_lang["def_portal_help"]			= "~פורטל~<br />באתר זה הפורטל דומה לכניסה למסעדה או לספריה ציבורית. זה המקום שגם נכנסים בו וגם ניתן למצוא בו מידע חשוב כמו הסברים, תפריטים וכו'.<br /><br />";
$pgv_lang["def_gedcom_help"]		= "~קובץ GEDCOM~<br />ציטוט מהמבוא לתקן GEDCOM 5.5.1:<div class=\"list_value_wrap ltr\">GEDCOM was developed by the Family History Department of The Church of Jesus Christ of Latter-day Saints (LDS Church) to provide a flexible, uniform format for exchanging computerized genealogical data.&nbsp; GEDCOM is an acronym for <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication.&nbsp; Its purpose is to foster the sharing of genealogical information and the development of a wide range of inter-operable software products to assist genealogists, historians, and other researchers</div><br />ניתן להוריד, במבנה PDF, <u>טיוטת</u> תקן GEDCOM 5.5.1 ש-PhpGedView מוגדר לפיה:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">תקן GEDCOM 5.5.1.</a> התקן קיים רק באנגלית.<br /><br />קובץ ה-GEDCOM הוא הקובץ המכיל את כל המידע על המשפחה.&nbsp;כל העובדות, התאריכים, המאורעות וכו' שמורים כאן.&nbsp;לקובץ GEDCOM חוקים נוקשים מכיוון שניתן להעביר אותו בין הרבה תוכניות ללא תלות בסביבה ו-/או במערכות הפעלה.<br /><br />";
$pgv_lang["def_gedcom_date_help"]		= "~תאריכים בקובץ GEDCOM~<br />למרות ששדה תאריך הוא שדה חופשי (כלומר ניתן למלא כל טכסט בשדה), ישנם חוקים איך להקיש תאריכים לפי תקן GEDCOM 5.5.1.<ol><li>תאריך מלא מוכנס במבנה DD MMM YYYY, לדוגמא: <b><span dir=\"ltr\">01&nbsp;MAR&nbsp;1801</span></b> או <b><span dir=\"ltr\">14&nbsp;DEC&nbsp;1950</span></b></li><li>אם חסר לך חלק מהתאריך, תוכל לדלג עליו, לדוגמא: <b>MAR&nbsp;1801</b> או <b><span dir=\"ltr\">14&nbsp;DEC</span></b>.</li><li>אם אינך בטוח בתאריך או התאריך לא אומת, תוכל להקיש:<br />(בערך&nbsp;=&nbsp;<b>ABT&nbsp;MAR&nbsp;1801</b> (ABT&nbsp;=&nbsp;about, (לפני&nbsp;=&nbsp;<b><span dir=\"ltr\">BEF 20&nbsp;DEC&nbsp;1950</span></b> (BEF&nbsp;=&nbsp;before, (אחרי&nbsp;=&nbsp;<b><span dir=\"ltr\">AFT&nbsp;1949</span></b> (AFT&nbsp;=&nbsp;after</li><li>תחום תאריכים מוכנס כ-<b><span dir=\"ltr\">FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</span></b> או כ-(בין&nbsp;=&nbsp;<b><span dir=\"ltr\">BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</span></b> (BET&nbsp;=&nbsp;between<br /><br />מבנה ה-<b>FROM</b> מסמן שהאירוע שאותו מתארים התרחש ברציפות בין התאריכים המצויינים המשמשים למשל לאירועים של תעסוקה. מבנה <b>BET</b> מסמן התרחשות בודדת של אירוע, מתישהו בין התאריכים המצויינים ומשמש למשל באירועים של לידה.<br /><br />תאריכים לא מדוייקים, שבהם היום בחודש או החודש חסרים, מפורשים תמיד כתאריך האפשרי הראשון או האחרון, בתלות אם התאריך הלא מדוייק מופיע לפני או אחרי מילת הפרדה.  לדוגמא, <b>FEB&nbsp;1804</b> מתורגם כ-<b><span dir=\"ltr\">01&nbsp;FEB&nbsp;1804</span></b> כאשר הוא מופיע לפני ה-TO או AND, וכ-<b><span dir=\"ltr\">29&nbsp;FEB&nbsp;1804</span></b> כאשר הוא מופיע אחרי ה-TO או AND.</li></ol><b>עליך להכניס את התאריכים והקיצורים ב<u>אנגלית</u>, </b>כי אז ניתן להשתמש בנתוני ה-GEDCOM בתוכניות השונות ו-PhpGedView יתרגם את התאריכים והקיצורים היטב לשפה הפעילה. כמו כן, PhpGedView מבצע חישובים על סמך התאריכים. אם יוכנסו התאריכים לקובץ GEDCOM בצורה שגויה, PhpGedView לא יוכל לבצע את החישובים בצורה נכונה.<br /><br />לחץ על צלמית לוח-השנה כדי לקבל עזרה בבחירת תאריך.<br /><br />";
$pgv_lang["def_gramps_help"]		= "~קובץ מאגר נתוני GRAMPS XML~<br />ציטוט מפרויקט GRAMPS: <div class=\"list_value_wrap ltr\">GRAMPS helps you track your family tree. It allows you to store, edit, and research genealogical data. GRAMPS attempts to provide all of the common capabilities of other genealogical programs, but, more importantly, to provide an additional capability of integration not common to these programs. This is the ability to input any bits and pieces of information directly into GRAMPS and rearrange/manipulate any/all data events in the entire data base (in any order or sequence) to assist the user in doing research, analysis and correlation with the potential of filling relationship gaps.</div><br /><a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">כאן ניתן למצוא</a> עותק של מבנה GRAMPS XML v1.1.0 במבנה RELAX NG Schema ובמבנה DTD.<br /><br />למידע נוסף על פרויקט ה-GRAMPS ניתן לבקר ב-<a href=\"http://gramps-project.org/\" target=\"_blank\"><span dir=\"ltr\">http://gramps-project.org/</span></a>";

$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br />PhpGedView (או PGV) היא תוכנה דינאמית וניתנת להתאמה בדרכים רבות; היא אינה מסתפקת רק בהצגת דפים קבועים על האינטרנט.<br /><br />PhpGedView היא תוכנה שג'והן פינליי (John Finlay) יצר להצגת קובצי GEDCOM בצורה מקוונת (on line). ג'והן התחיל את הפיתוח לבדו. צוות בינלאומי של מפתחים ומתרגמים הצטרף אליו כדי לשפר את התוכנה. בין המאפיינים המשמעותיים יותר שהוספו או שופרו היא התמיכה המקיפה בשפות נוספות לאנגלית, והאפשרות להוסיף או לערוך מאורעות בצורה מקוונת.<br /><br />";
$pgv_lang["def_theme_help"]			= "~עיצוב~<br />לאתר זה יש כמה \"אפשרויות מופע\" שונות, הנקראות עיצובים (Themes).<br /><br />מנהלן האתר בוחר עיצוב ברירת מחדל שכל מי שנכנס לאתר יראה תחילה. אם המנהלן הגדיר את האתר בצורה המאפשרת למשתמש שנכנס לאתר לבחור בעצמו את העיצוב שלו, הוא יוכל לבחור את העיצוב שלו. PhpGedView זוכר את העיצוב האחרון של כל משתמש מחובר, כך שהמשתמש יראה את העיצוב האחרון בפעם הבאה שיתחבר לאתר. ניתן להשתמש בעיצובים שונים עבור מאגרי מידע שונים של האתר. ניתן להגדיר כל מאגר מידע עם עיצוב שונה.<br /><br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br />זהו דף #pgv_lang[mgv]# האישי שלך.<br /><br />תמצא כאן קישורים קלים כדי לגשת אל נתוניך האישיים כמו אל <b>המשתמש שלי</b>, <b>הנתונים האישיים שלי</b> (דף #pgv_lang[indi_info]# ) ו<b>אילן היוחסין שלי</b>. בנוסף יתכן שיהיה לך אזור עם <b>הודעות</b>, <b>יומן</b> (כמו Notepad) ואזורים רבים נוספים.<br /><br />המבנה של הדף דומה לדף ברוכים הבאים שאותו אתה רואה כאשר אתה נכנס לאתר. בעוד שהחלקים של דף ברוכים הבאים נבחרים על ידי מנהלן האתר, תוכל לבחור בעצמך איזה חלקים לכלול בדף הזה המותאם אישית. תמצא קישור להתאמת הדף באזור ברוכים הבאים או בנפרד כאשר אזור ברוכים הבאים אינו נמצא.<br /><br />תוכל לבחור מבין האזורים הבאים:<ul><li><a href=\"#mygedview_welcome\"><b>ברוכים הבאים</b></a></li><li><a href=\"#mygedview_customize\"><b>התאם אישית את MyGedView</b></a></li><li><a href=\"#mygedview_message\"><b>הודעות</b></a></li><li><a href=\"#mygedview_events\"><b>אירועים קרובים</b></a></li><li><a href=\"#mygedview_onthisday\"><b>ביום הזה בהיסטוריה שלך</b></a></li><li><a href=\"#mygedview_charts\"><b>תרשימים</b></a></li><li><a href=\"#mygedview_favorites\"><b>המועדפים שלי</b></a></li><li><a href=\"#mygedview_stats\"><b>סטטיסטיקות GEDCOM</b></a></li><li><a href=\"#mygedview_myjournal\"><b>היומן שלי</b></a></li><li><a href=\"#mygedview_media\"><b>מדיה אקראית</b></a></li><li><a href=\"#mygedview_loggedin\"><b>משתמשים מחוברים</b></a></li><li><a href=\"#mygedview_recent_changes\"><b>שינויים אחרונים</b></a></li></ul><br />";
$pgv_lang["mygedview_customize_help"]	= "~התאם אישית את #pgv_lang[mygedview]#~<br />כאשר נכנסת לכאן בפעם הראשונה, היו לך כבר כמה אזורים בדף הזה. אם תרצה, תוכל להתאים את הפורטל הזה לפי רצונך.<br /><br />לחיצה על קישור זה תביא אותך לטופס ובו תוכל להוסיף, להוריד או להעביר אזורים. הסברים נוספים קיימים על הטופס.<br /><br />";
$pgv_lang["mygedview_message_help"]	= "~אזור הודעות~<br />באזור זה תימצא הודעות שנשלחו אליך ממשתמשים אחרים או מהמנהלן. גם אתה תוכל לשלוח הודעותיך למשתמשים אחרים או למנהלן.<br /><br />מערכת הדואר של PhpGedView תוכננה להגן על פרטיותך. אין צורך להשאיר כאן את כתובת הדואר האלקטרוני שלך, ואחרים לא יוכלו לראות את כתובת הדואר האלקטרוני שלך.<br /><br />לחץ על נושא ההודעה או על סימן ה-\"<b>+</b>\" על ידו. תוכל למחוק מספר הודעות ע\"י בחירת התיבות ליד ההודעות שאותן ברצונך למחוק וע\"י לחיצה על כפתור <b>מחק הודעות נבחרות</b>.<br /><br />";
$pgv_lang["mygedview_favorites_help"]	= "~אזור המועדפים שלי~<br />המועדפים שלי מתפקד כמו סימניות.<br /><br />נניח שיש לך מישהו באילן היוחסין שתרצה לבדוק את רישומיו באופן סדיר. עבור לדף #pgv_lang[indi_info]# של האדם ובחר <b>הוסף למועדפים שלי</b> מרשימה הנגללת של המועדפים. אדם זה יסומן מעכשיו ויתווסף לרשימת המועדפים שלך.<br /><br />בכל מקום באתר זה תוכל ללחוץ על שם מתוך הרשימה הנגללת \"המועדפים שלי\" בכותרת. דבר זה מעביר אותך לדף #pgv_lang[indi_info]# של האדם.<br /><br />";
$pgv_lang["mygedview_myjournal_help"]	= "~אזור היומן שלי~<br />תוכל להשתמש ביומן זה כדי לכתוב הערות או תזכורות לשימושך האישי. כאשר תכין הערה, היא תהיה עדיין שם בפעם הבאה שתבקר באתר.<br /><br />ההערות הללו הן פרטיות ואחרים לא יוכלו לראות אותם.<br /><br />";
$pgv_lang["mygedview_welcome_help"]	= "~אזור ברוכים הבאים~<br />אזור ברוכים הבאים הזה מראה לך את:<ul><li>קובץ ה-GEDCOM הנוכחי</li><li>היום והזמן</li><li>הקישורים ל-:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]# (ראה הערה)</li><li>#pgv_lang[my_indi]# (ראה הערה)</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>הערה</b><br />תראה את הקישורים ל<b>המשתמש שלי</b> ול<b>אילן היוחסין שלי</b> רק אם אתה ידוע בקובץ ה-GEDCOM הנוכחי. יתכן שבקובץ אחד קיימת רשומה ותראה את הקישורים <b>המשתמש שלי</b> ו<b>אילן היוחסין שלי</b>, ואילו בקובץ GEDCOM אחר אין לך רשומה ולכן הקישוריות אינן מוצגים.<br /><br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]		= "~דף אילן יוחסין~<br />אילן היוחסין הוא רישום של כל האב-אבות של האדם המוצג בתחילת העץ. משתמשים שאינם מחוברים לאתר רואים את אילן היוחסין כאשר הוא מתחיל מאדם  (אדם מוצא) שנבחר ע\"י המנהלן. משתמשים מחוברים לאתר יכולים בעצמם לבחור את האדם המוצא.<br /><br />ובכן, \"כל האב-אבות\" הם אבא ואמא, הוריהם וכן הלאה. אילן היוחסין מוצג בצורה גראפית; אין צורך להתמודד עם דפים רבים של טכסט כדי לגלות את אב-אבותיך.<br /><br />כל האנשים מוצגים בתיבות השם על המסך.<br /><ul><li><b>תיבות השם באילן היוחסין</b><br />אם דף אילן היוחסין מוגדר להצגת פרטים, תראה את שם האדם ואת תאריכי הלידה והפטירה. תוכל ללחוץ על שם האדם ותועבר ישירות לדף #pgv_lang[indi_info]# של האדם.<br /><br />כאשר <b>הצג פרטים</b> פועל, מוצגות שתי צלמיות בתוך תיבת השם.</li><li><b>צלמית אילן יוחסין בתוך תיבת השם</b><br />כאשר <b>הצג פרטים</b> פועל, אתה רואה את הצלמית של אילן היוחסין בתוך תיבת השם. הגדרת האתר משפיעה האם יש לרחף מעל הקישור או ללחוץ עליו. לאחר שלוחצים או מרחפים על הצלמית הזו, מופיע תת-תפריט קטן.<br /><br />הפריטים <b>#pgv_lang[index_header]#</b> ו<b>#pgv_lang[descend_chart]#</b>  דומים לפריטים הללו, המופיעים בתפריט הראשי, בהבדל שהאדם בתיבת השם יהיה האדם בתחילת התרשים כפי שרשום בתיבת השם. תראה גם <b>#pgv_lang[as_spouse]#</b>. מתחתיו תראה את השם של בן או בת הזוג ואחריו את שמות הילדים. ניתן ללחוץ על כל השמות.</li><li><b>זכוכית מגדלת בתוך תיבת השם</b><br />תלוי בהגדרות האתר אם עליך לרחף או ללחוץ עליה. דבר זה מגדיל את תיבת השם כך שנתונים נוספים מוצגים.<br />תראה עוד תאריכים ואירועים. ניתן ללחוץ על השמות.</li><li><b>החצים</b><br />יתכן שתראה חצים מימין או משמאל לתיבות הימניות או השמאליות ביותר. לחיצה על החצים הללו מזיזה את צוגת המסך לכיוון החץ.</li></ul><br />#pgv_lang[context_help]#<br/ ><br />";
$pgv_lang["show_full_help"]			= "~הצג או הסתר פרטים~<br /><br />תוכל להציג או להסתיר את הפרטים בתיבות השם. כאשר הפרטים מוסתרים תוכל להציג יותר תיבות על מסך אחד.<br /><br />כאשר בחרת להסתיר את הפרטים, צלמית זכוכית המגדלת (זום) המוסברת למטה אינה מוצגת. אבל, אם המנהלן אפשר את פונקצית הזום, כל התיבה משמשת כצלמית זום ומראה את הנתונים השלמים על האדם.<br /><br />כאשר הפרטים אינם מוסתרים ופונקצית הזום, המזוהה ע\"י צלמית זכוכית המגדלת, אופשרה ע\"י המנהלן, תוכל לחשוף נתונים נוספים על האדם. אם בדרך כלל אתה צריך ללחוץ על זכוכית המגדלת כדי לקרב, תוכל לחשוף את הפרטים ע\"י לחיצה על הצלמית. בדומה, אם בדרך כלל אתה מקרב ע\"י רחיפה מעל לזכוכית המגדלת, אז תוכל לראות את הפרטים ע\"י רחיפה מעל לתיבת הצלמית.<br /><br />אם לחצת על צלמית הזום כדי לראות פרטים נוספים, לחיצה נוספת על הצלמית תגרום להקטנה חזרה למצב הראשוני. אם חשפת נתונים נוספים ע\"י העברת סימן העכבר מעל לצלמית הזום, תוחזר התיבה לגודלה הרגיל כאשר תרחיק את סממן העכבר מצלמית הזום.<br /><br />";
$pgv_lang["talloffset_help"]			= "~צורת תצוגה PAGE LAYOUT~<br /><br />עם האופציה הזו תוכל לקבוע את צורת התצוגה על המסך.<br /><br />יתכן ששינוי ההגדרה יהיה שימושי אם תרצה להדפיס את הדף או אם יש לך מסך שונה have a different type of screen.<ul><li>צורת <b>#pgv_lang[portrait]#</b> גורמת לעץ גבוה יותר, כך שתרשים של 4 דורות יודפס על דף אחד במבנה תמונה (portrait) אנכית.</li><li>צורת <b>#pgv_lang[landscape]#</b> מכינה עץ רחב יותר שיודפס על דף אחד בצורת נוף (landscape). </li><li>צורת <b>#pgv_lang[landscape_top]#</b> מסובבת את התרשים, אבל לא את תיבותיו, ב-90 מעלות נגד השעון, כך שהדור המבוגר יותר יהיה בראש התרשים.</li><li>צורת <b>#pgv_lang[landscape_down]#</b> מסובבת את התרשים, אבל לא את תיבותיו, ב-90 מעלות בכיוון השעון, כך שהדור המבוגר יותר יהיה בתחתית התרשים.</li></ul<br />";
$pgv_lang["rootid_help"]			= "~אדם מוצא חדש~<br /><br />אם אתה רוצה לראות את נתוני התרשים עבור אדם מוצא חדש, עליך להכניס את קוד הזיהוי של האדם החדש בתיבה זו.<br /><br />אם אינך יודע את קוד הזיהוי של האדם, השתמש בקישור <b>מצא קוד זיהוי</b>.<br /><br /><b>קוד זיהוי</b><br />מספרי קוד זיהוי בתוך PhpGedView הם <u>אינם</u> מספרי זיהוי ממשלתיים (למשל, תעודת זהות, רישיון נהיגה או דרכון). מספר קוד זיהוי הוא פשוט מספר של מאגר הנתונים והוא משמש לזיהוי חד-ערכי של כל אדם; הוא הוגדר ע\"י תוכנת השושלת שיצרה את קובץ ה-GEDCOM שהובא לתוך PhpGedView.<br /><br />";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~מספר דורות~<br /><br />כאן תוכל להגדיר את מספר הדורות שיוצגו על דף זה.<br /><br />הערך הנכון עבורך תלוי בגודל המסך שלך ובאם תציג פרטים או לא. זמן העיבוד גדל כאשר תגדיל את מספר הדורות.<br /><br />";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~דף ההתחברות~<br /><br />בדף הזה תוכל להתחבר למערכת, לבקש סיסמא חדשה או לבקש קוד משתמש חדש.<br />";
$pgv_lang["username_help"]			= "~קוד משתמש~<br /><br />בתיבה זו מכניסים את קוד המשתמש.<br /><br />יש להקפיד על השפה ועל אותיות לועזיות קטנות וגדולות או על אותיות עבריות. משמעות הדבר ש-<b>MyName</b> <u>אינו</u> זהה ל-<b>myname</b> או ל-<b>MYNAME</b>.<br /><br />";
$pgv_lang["password_help"]			= "~סיסמא~<br /><br />בתיבה זו מכניסים סיסמא.<br /><br />יש להקפיד על השפה ועל אותיות לועזיות קטנות וגדולות. -<b>MyPassword</b> <u>אינו</u> זהה ל-<b>mypassword</b> או ל-<b>MYPASSWORD</b>.<br /><br />";
$pgv_lang["login_buttons_help"]		= "~כפתורי התחברות~<br /><br />כאן אתה רואה שני כפתורים כדי להתחבר למערכת.<br /><br />הדף שאליו תועבר תלוי בכפתור שתלחץ, לאחר הכנסת קוד המשתמש והסיסמא.<br /><ul><li>כפתור <b>#pgv_lang[login]#</b><br />אם תלחץ על כפתור זה, תוחזר לדף ממנו באת, אבל עם הרשאות גישה של מי שהתחבר.<br /><br />לדוגמה, אם לחצת על  <b>#pgv_lang[login]#</b> מדף אילן יוחסין, תחזור לדף הזה. אם תלחץ על הכפתור כאשר היית על דף ברוכים הבאים הראשי, תועבר לדף #pgv_lang[mygedview]#.</li><li>כפתור <b>#pgv_lang[admin]#</b><br />אם יש לך הרשאות של מנהלן, תוכל ללחוץ על כפתור זה ותועבר ישירות לדף הניהול הראשי.</li></ul><br />";
$pgv_lang["login_buttons_aut_help"]		= "~כפתורי התחברות במצב אימות~<br /><br />כאן אתה רואה שני כפתורים כדי להתחבר למערכת.<br /><br />הדף שאליו תועבר תלוי בכפתור שתלחץ, לאחר הכנסת קוד המשתמש והסיסמא.<br /><ul><li>כפתור <b>pgv_lang[login]#</b><br />אם תלחץ על כפתור זה, תחובר למערכת ותועבר ישירות לדף #pgv_lang[mygedview]# שלך, שבו תוכל לערוך את ההגדרות שלך, להוסיף או לערוך מועדפים, לשלוח ולקבל הודעות וכו'.</li><li>כפתור <b>#pgv_lang[admin]#</b><br />אם יש לך הרשאות של מנהלן, תוכל ללחוץ על כפתור זה ותועבר ישירות לדף הניהול הראשי.</li></ul><br />";
$pgv_lang["new_password_help"]		= "~בקש סיסמא חדשה~<br /><br />אם שכחת את הסיסמא שלך, תוכל ללחוץ על קישור זה כדי לבקש סיסמא חדשה.<br /><br />תועבר לדף \"בקשת סיסמא אבודה.<br /><br />";
$pgv_lang["new_user_help"]			= "~בקש קוד משתמש חדש~<br /><br />אם אתה מבקר באתר זה ואתה רוצה לבקש קוד משתמש, לחץ על קישור זה.<br /><br />תועבר לדף בקשת \"קוד משתמש חדש\".<br /><br />";
$pgv_lang["mygedview_login_help"]		= "כדי שתהיה לך גישה לדף #pgv_lang[mygedview]#, אתה חייב להיות משתמש רשום במערכת. בדף #pgv_lang[mygedview]# אתה יכול לשמור קישור לאנשים המועדפים שלך, להחזיק יומן משתמשים, לנהל הודעות, לראות את המשתמשים המחוברים האחרים ולהתאים אישית את מראות של דפי PhpGedView.<br /><br />הכנס את קוד המשתמש והסיסמא שלך בשדות המתאימים כדי להתחבר ל-#pgv_lang[mgv]#.<br /><br />";
$pgv_lang["new_user_firstname_help"]	= "~#pgv_lang[fullname]#~<br /><br />עלך להקליד בתיבה זו את השם הפרטי שלך.<br /><br />אנחנו זקוקים לשמך הפרטי ולשמך המשפחה כדי לקבוע אם אתה זכאי לקוד משתמש באתר, ואיזה זכויות לתת למשתמש שלך. את השמות האלה יראו בני משפחה  ומשתמשים אחרים כאשר הם מחוברים.<br /><br />";
$pgv_lang["new_user_lastname_help"]	= "~#pgv_lang[fullname]#~<br /><br />עליך להקליד בתיבה זו את שם המשפחה שלך.<br /><br />אנחנו זקוקים לשמך הפרטי ולשמך המשפחה כדי לקבוע אם אתה זכאי לקוד משתמש באתר, ואיזה זכויות לתת למשתמש שלך. את השמות האלה יראו בני משפחה  ומשתמשים אחרים כאשר הם מחוברים.<br /><br />";
$pgv_lang["register_info_01"]			= "~בקשת קוד משתמש חדש~<br /><br />יתכן שכמות המידע שניתן לראות בגלוי באתר זה מוגבלת בהתאם לחוקים הקשורים להגנת הפרטיות. אנשים רבים אינם רוצים שנתונים אישיים שלהם יהיו ניתנים לצפייה בגלוי באינטרנט. יתכן שיעשה שימוש לרעה בנתונים אישיים או גניבת זהות.<br /><br />כדי לקבל גישה לנתונים פרטיים, עליך להיות בעל קוד משתמש. לאחר בדיקת נתוניך על ידי המנהלן ואישור בקשת קוד המשתמש, תוכל להתחבר למערכת.<br /><br />אם תופעל פרטיות של קרובי משפחה, תוכל לצפות, לאחר שתתחבר, רק בנתוני קרובי המשפחה שלך. המנהלן יכול לאפשר עדכון מאגר הנתונים למשתמשים מסוימים, כך שהם יכולים לשנות או להוסיף נתונים.<br /><br />אם הנך זקוק לסיוע נוסף, השתמש בקישור שלמטה כדי להתקשר למנהלן.<br /><br />";
$pgv_lang["register_info_02"]			= "~בקשת קוד משתמש חדש~<br /><br />יתכן שכמות המידע שניתן לראות בגלוי באתר זה מוגבלת בהתאם לחוקים הקשורים להגנת הפרטיות. אנשים רבים אינם רוצים שנתונים אישיים שלהם יהיו ניתנים לצפייה בגלוי באינטרנט. יתכן שיעשה שימוש לרעה בנתונים אישיים או גניבת זהות.<br /><br />גישה לאתר זה מותרת למשתמשים <u>מורשים</u> בלבד. לאחר בדיקת נתוניך על ידי המנהלן ואישור בקשת קוד המשתמש, תוכל להתחבר למערכת ולצפות בנתונים פרטיים.<br /><br />אם תופעל פרטיות של קרובי משפחה, תוכל לצפות, לאחר שתתחבר, רק בנתוני קרובי המשפחה שלך. המנהלן יכול לאפשר עדכון מאגר הנתונים למשתמשים מסוימים, כך שהם יכולים לשנות או להוסיף נתונים.<br /><br />אם הנך זקוק לסיוע נוסף, השתמש בקישור שלמטה כדי להתקשר למנהלן.<br /><br />";
$pgv_lang["register_info_03"]			= "~בקשת קוד משתמש חדש~<br /><br />יתכן שכמות המידע שניתן לראות בגלוי באתר זה מוגבלת בהתאם לחוקים הקשורים להגנת הפרטיות. אנשים רבים אינם רוצים שנתונים אישיים שלהם יהיו ניתנים לצפייה בגלוי באינטרנט. יתכן שיעשה שימוש לרעה בנתונים אישיים או גניבת זהות.<br /><br />גישה לאתר זה מותרת <u>לבני משפחה בלבד</u>. לאחר בדיקת נתוניך על ידי המנהלן ואישור בקשת קוד המשתמש, תוכל להתחבר למערכת.<br /><br />אם תופעל פרטיות של קרובי משפחה, תוכל לצפות, לאחר שתתחבר, רק בנתוני קרובי המשפחה שלך. המנהלן יכול לאפשר עדכון מאגר הנתונים למשתמשים מסוימים, כך שהם יכולים לשנות או להוסיף נתונים.<br /><br />אם הנך זקוק לסיוע נוסף, השתמש בקישור שלמטה כדי להתקשר למנהלן.<br /><br />";

//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~דף תרשים צאצאים~<br /><br />הדף הזה מראה את הצאצאים של האדם.<br /><br />תוכל לבחור את האדם המוצא עבור תרשים הצאצאים על דף זה, או שתועבר לדף הזה מדף אחר ע\"י לחיצה על הקישור <b>#pgv_lang[descend_chart]#</b>. לחץ על צלמיות החץ כדי לנווט בעץ בכיוון החץ. לחץ על צלמית התרשימים בתיבה האישית כדי להציג את התרשים כאשר האדם הזה נמצא כאדם המוצא.<br /><br />";
$pgv_lang["desc_rootid_help"]		= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";
//-- show_full is used from pedigree

//-- Time line-page
$pgv_lang["help_lifespan.php"]                  	= "~דף תוחלת חיים~<br /><br />בתרשים זה ניתן להציג אדם אחד או יותר לאורך קו זמן אופקי. התרשים מאפשר לך לראות חפיפה בתקופת החיים של אנשים שונים.<br /><br /> ניתן להוסיף לתרשים אנשים בודדים או משפחות לפי קוד הזיהוי שלהם. הרשימה הקודמת נשמרת כאשר מוסיפים אנשים נוספים לתרשים. בכל עת ניתן לנקות את התרשים בעזרת כפתור <b>נקה תרשים</b>.<br /><br />ניתן גם  להוסיף אנשים לתרשים ע\"י חיפוש לפי טווח תאריכים או לפי אזור.<br /><br />";
$pgv_lang["lifespan_add_person_help"]         = "#pgv_lang[add_person_help]#~תיבת בחירה כלול משפחה קרובה~<br />כלול משפחה קרובה מסומנת כברירת מחדל.  השאר אותה מסומנת כדי לראות על קו הזמן את האב, האם, בן/בת הזוג, אחים ואחיות וילדים של האדם על קו הזמן. הסר את הסימון אם אינך רוצה לראות את המשפחה הקרובה על התרשים.<br /><br />";
$pgv_lang["help_timeline.php"]		= "~דף תרשים קו הזמן~<br /><br />בדף הזה תוכל להציג אדם אחד או יותר לאורך קו הזמן. כך תוכל, למשל, להמחיש מצב שני אנשים או יותר בנקודת זמן מסוימת.<br /><br />אם תלחץ על קישור <b>קו הזמן</b> בדף אחר, אדם אחד כבר יופיע על קו הזמן. אם בחרת <b>קו הזמן</b> מהתפריט בכותרת של דף, אזי עליך להכניס קודם כל את קוד הזיהוי של אדם המוצא.<br /><br />";
$pgv_lang["add_person_help"]		= "~הוסף אדם לתרשים~<br /><br />ניתן להציג נתוני מספר אנשים על תרשים קו הזמן.<br /><br />השתמש בתיבה זו כדי למלא את קוד הזיהוי של כל אדם. אם אינך יודע את קוד הזיהוי של האדם, תוכל להשתמש בקישור <b>מצא קוד זיהוי</b> ליד התיבה.<br /><br />";
$pgv_lang["remove_person_help"]		= "~הסר אדם מהתרשים~<br /><br />לחץ על הקישור הזה כדי להסיר אדם מתרשים קו הזמן.<br /><br />";
$pgv_lang["show_age_marker_help"]	= "~הראה נקודת ציון של גיל~<br /><br />אם תבחר תיבה זו, תראה סימן גיל.<br /><br />תוכל להחליק את סימן הגיל הזה למעלה ולמטה לאורך קו הזמן. סימן הגיל המחליק הוא כלי נחמד לבדוק את הגיל של האדם בזמן מאורע מסוים. תוכל לאפשר או למנוע את סימן הגיל בנפרד לכל אדם בתרשים.<br /><br />";
$pgv_lang["timeline_control_help"] 		= "~בקרות תוחלת חיים~<br /><br />~מהירות~<br />לחץ על החלון הנגלל כדי לשנות את מהירות הגלגול של קו הזמן .<br /><br />~שנת התחלה~<br />הכנס את השנה שממנה תרצה להתחיל לחפש מאורעות.<br /><br />~שנת סיום~<br />הכנס את שנת הסיום שעד אליה תרצה לחפש מאורעות.<br /><br />~חפש~<br />לחץ על כפתור חיפוש כדי להתחיל לחפש מאורעות בשנים שמילאת בשדות שנת התחלה ושנת סיום.<br /><br />";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~דף קירבה משפחתית~<br /><br />בדף הזה תוכל להציג את הקשר בין שני אנשים. שני האנשים לא חייבים להיות קרובים בקשר דם; כל הקרובים ימצאו.<br /><br />";
$pgv_lang["relationship_id_help"]		= "~קודי זיהוי של אדם א' ואדם ב'~<br /><br />אם הגעת לדף זה מדף אחר ע\"י לחיצה על הקישור <b>קירבה אלי</b>, אז תיראה כאן את הקשר בינך לבין האדם השני.<br /><br />אם הגעת לדף הזה דרך כניסת <b>קירבה משפחתית</b> בתפריט בכותרת דף כלשהו, יהיה עליך להכניס את קודי הזיהוי של שני האנשים שאתה רוצה לדעת את הקשר ביניהם. אם אינך יודע את קוד הזיהוי של האנשים, תוכל להשתמש בקישור <b>מצא קוד זיהוי</b>.<br /><br />";
$pgv_lang["next_path_help"]			= "~מצא הנתיב הבא~<br /><br />תוכל ללחוץ על כפתור זה כדי לבדוק אם קיים נתיב קירבה אחר בין שני האנשים. תוכל להציג את הנתיב הקודם ע\"י לחיצה על הקישור עם מספר הנתיב.<br /><br />";
$pgv_lang["follow_spouse_help"]		= "~תיבת בחירה - בדוק קירבת נישואין~<br /><br />כאשר תיבת בחירה זו <b>לא</b> נבחרה, בודקים את הקשרים רק בין אנשים בעלי קירבת דם. כאשר התיבה נבחרה, בודקים גם קירבת נישואין. יש להניח שתמצא יותר קשרים אם תבחר את התיבה.<br /><br />";
$pgv_lang["line_up_generations_help"]	= "~תיבת בחירה - סדר בשורה לפי דורות~<br /><br />כאשר תיבת הבחירה נבחרת, התרשים יוצג עם כל דור מסודר בצורה אופקית על הדף. כאשר התיבה אינה נבחרת, הדורות יורדים לאורך הדף ללא תלות אם מדובר ביחס של הורה או ילד.<br /><br />";
$pgv_lang["oldest_top_help"]          		= "~תיבת בחירה - הראה הישן למעלה~<br /><br />כאשר התיבה נבחרת, האנשים המבוגרים יוצגו למעלה. כאשר התיבה אינה נבחרת, האנשים הצעירים יוצגו למעלה.<br /><br />הערה: הבחירה אפשרית רק אם <b>#pgv_lang[line_up_generations]#</b> נבחרה.<br /><br />";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]		= "~דף #pgv_lang[ancestry_chart]#~<br /><br />תרשים שושלת דומה מאוד ל<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, אבל עם יותר פרטים ומספר מצגות <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.<br /><br />כל אב-אבות מוצג עם מספר יחיד, מחושב לפי שיטת <i>Sosa-Stradonitz</i>:<div style=\"padding-right:30px;\">מספרים <b>זוגיים</b> עבור גברים (ילד*2)<br /> מספרים <b>אי-זוגיים </b>לנשים (בעל+1) חוץ מאשר <b>1</b></div><br />לדוגמא:<br /><div style=\"padding-right:30px;\">אדם המוצא הוא תמיד <b>1</b>, ללא תלות במגדר.<br />ל-<b>1</b> - האבא הוא <b>2</b> (<b>1</b> * 2), האמא היא <b>3</b> (<b>2</b> + 1).<br />ל-<b>2</b> - האבא הוא <b>4</b> (<b>2</b> * 2), האמא היא <b>5</b> (<b>4</b> + 1).<br />ל-<b>3</b> - האבא הוא <b>6</b> (<b>3</b> * 2), האמא היא <b>7</b> (<b>6</b> + 1).<br />ל-<b>7</b> - האבא הוא <b>14</b> (<b>7</b> * 2), האמא היא <b>15</b> (<b>14</b> +1).<br />וכו'</div><br />";
$pgv_lang["box_width_help"]			= "~רוחב התיבה של #pgv_lang[ancestry_chart]#~<br /><br />תוכל לשנות את רוחב התיבה מ-50% עד 300%. ב-100% רוחב כל תיבה כ-270 פיקסלים.<br /><br />";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[chart_style]#~<br />שני סוגי תרשימים קיימים:<ul><li><b>#pgv_lang[chart_list]#</b><br />עץ אופקי עם משפחות מתקפלות/מתרחבות.</li><li><b>#pgv_lang[chart_booklet]#</b><br />משפחה לדף עם הורים, סבים וסבתות וכל הילדים הרשומים.<br /><br />המבנה הזה קל להדפסה כדי למסור לקרוביך.</li></ul><br />";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]		= "~דף -#pgv_lang[fan_chart]# ~<br /><br />תרשים המניפה דומה מאוד ל<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, אבל הוא בעל צורה יותר גראפית.<br /><br />אדם המוצא של התרשים מוצג במרכז, הוריו במעגל הראשון, סבים וסבתות במעגל השני וכן הלאה...<br /><br />שנות הלידה והפטירה מוצגות מתחת לשם, כאשר הן ידועות.<br /><br />לחיצה על שם בתרשים פותחת תפריט קישוריות אישי לאדם הזה. מתפריט זה תוכל למרכז את תרשים המניפה על האדם או על אחד הקרובים של האדם, או לעבור לדף #pgv_lang[indi_info]# של האדם, או לתרשים אחר של האדם.<br /><br />";
$pgv_lang["fan_width_help"]			= "~רוחב #pgv_lang[fan_chart]#~<br /><br />תוכל לשנות את רוחב התיבה מ-50% עד 300%.<br />הערך הרגיל הוא 100% יוצר תמונת פלט ברוחב של כ-640 פיקסלים.<br /><br />";
$pgv_lang["fan_style_help"]			= "~סיגנון #pgv_lang[fan_chart]#~<br /><br />האופציה שולטת בהצגה של תרשים המניפה ב<ul><li><b>1/2</b><br />תרשים של חצי מעגל 180&deg;</li><li><b>3/4</b><br />תרשים של שלושת-רבעי מעגל 270&deg;, נקרא לפעמים <i>כנפי מלאך</i></li><li><b>4/4</b><br />תרשים של מעגל שלם 360&deg;</li></ul><br />";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]		= "~#pgv_lang[hourglass_chart]#~<br /><br />תרשים שעון החול מראה בתרשים אחד את האבות והצאצאים של אדם המוצא. התרשים מהווה תערובת בין תרשים צאצאים ותרשים אילן היוחסין.<br /><br />אדם המוצא יוצג באמצע הדף עם צאצאיו מימין ואבותיו משמאל. בתצוגה הזו כל דור ערוך בשורה לאורך הדף, בתחילה הדור המוקדם ביותר ובסיום הדור האחרון.<br /><br />במידה וקיים חץ לכיוון מטה מתחת לאדם המוצא, לחיצה עליו תציג רשימה של קרובי משפחה של אדם המוצא לשימוש ניווט לעורך התרשים.  בחירת שם מהרשימה תציג את התרשים שנית עם האדם הנבחר כאדם מוצא חדש.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]		= "~#pgv_lang[familybook_chart]#~<br /><br />התרשים הזה דומה מאוד לתרשים שעון החול.  הוא מראה את האבות והצאצאים של אדם המוצא שניבחר על אותו התרשים.  הוא מראה גם כן את הצאצאים של אדם המוצא במבנה שעון החול.<br /><br />אדם המוצא יוצג באמצע הדף עם צאצאיו מימין ואבותיו משמאל. בתצוגה הזו כל דור ערוך בשורה לאורך הדף, בתחילה הדור המוקדם ביותר.  בהצגה הזו כל דור מסודר לרוחב הדף כאשר הדור המוקדם יותר בהתחלה והדור האחרון בסוף.<br /><br />כל צאצא של אדם המוצא יהיה אדם מוצא של תרשים שעון חול נוסף שיודפס על אותו הדף.  התהליך ממשיך עד שמספר הדורות הנבחר יודפס.";
$pgv_lang["fambook_descent_help"]		= "~#pgv_lang[descent_steps]#~<br /><br />ערך זה קובע את מספר הדורות של צאצאי אדם המוצא שעבורם מדפיסים תרשים במבנה שעון חול.<br /><br />";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~רשימת השמות~<br /><br />בדף הזה תוכל להציג רשימה של שמות. השמות מוצגים לפי שם המשפחה וממוינים על פי סדר האלף-בית.<br /><br />תכולת רשימת השמות תלויה ב-:<ol><li>האות שלחצת באינדקס האלף-בית.</li><li>לחצת על \"דלג על\" או \"הצג\" רשימת שמות המשפחה.</li></ol>#pgv_lang[context_help]#<br /><br />";
$pgv_lang["alpha_help"]			= "~אינדקס אלף-בית~<br /><br />לחיצה על תו בתוך אינדקס אלף-בית תציג רשימה של שמות המתחילים בתו שלחצת עליו.<br /><br />יתכן שהבחירה לפני האחרונה באינדקס אלף-בית היא <b>(לא ידוע)</b> או <b>#pgv_lang[NN]#</b>. הבחירה הזו מוצגת אם במאגר הנתונים יש אנשים ששם משפחתם לא רשום או מכיל תווים שאינם מוכרים. שמות משפחה לו ידועים רשומים לעיתים כ-<b>?</b>, וה\"שמות\" הללו יוצגו כ<b>(לא ידוע)</b> או כ-<b>#pgv_lang[NN]#</b>. דבר זה קורה גם אם האדם אינו ידוע.<br /><br /><b>שים לב</b><br /> אם שמות המשפחה רשומים למשל בצורה הבאה: <b>לא ידוע</b>, <b>בלתי ידוע</b> או <b>Unknown</b>, אז שמו של האדם <b>לא</b> יוצג כאשר לוחצים על רשימת <b>(לא ידוע)</b>. תמצא את האנשים הללו ע\"י לחיצה על <b>ל</b>, <b>ב</b> או <b>U</b> (עבור הדוגמאות הקודמות). הסיבה לכך היא שהתוכנית מחפשת אם קיים שם משפחה עבור האדם. האותיות הללו הן האות הראשונה של ה\"שמות\" הללו. PhpGedView לא יכול לטפל בכל הדרכים האפשריות של הכנסת שמות משפחה בלתי ידועים, אין מוסכמה איך לסמן בלתי ידוע.<br /><br />בסוף אינדקס האלף-בית תראה <b>הכל</b>. לחיצה עליו תציג רשימה של כל שמות המשפחה במאגר הנתונים.<br /><br /><b>אותיות חסרות</b><br />יתכן שאות או יותר חסרות באינדקס האותיות. משמעות הדבר שאין שם משפחה שמתחיל באות החסרה.<br /><br />";
$pgv_lang["name_list_help"]			= "~רשימת שמות~<br /><br />התיבה מציגה רשימת שמות משפחה או שמות מלאים. בשני המקרים כל שמות המשפחה מתחילים באות שלחצת באינדקס האותיות, ובלבד שלא לחצת על <b>הכל</b>.<br /><br />אם אתה רואה רשימת שמות משפחה או רשימה שלמה תלוי במצב הקישור <b>הראה/הסתר רשימת שמות משפחה</b> מתחת לתיבה.<br /><br />";
$pgv_lang["skip_sublist_help"]		= "~דלג על רשימת שמות המשפחה~<br /><br />האזור הרגיל מביא לך תת-רשימה של שמות משפחה לאחר לחיצה על אות באינדקס אלף בית. אם תלחץ על קישור זה תקבל את כל השמות שמתחילים באות המבוקשת. לאחר מכן, כל פעם שתלחץ על אות, תקבל את רשימת שמות האנשים המתאימה.<br /><br />כדי לבטל פעולה זו, לחץ על הקישור #pgv_lang[show_surnames]# בתחתית של דף #pgv_lang[individual_list]#.<br /><br />";
$pgv_lang["show_marnms_help"]		= "~כלול/הוצא שמות נישואין~<br /><br />רשימות השמות והמשפחות יכולות או לכלול או לא לכלול שמות נישואין.  האפשרות יכולה לעזור כאשר מחפסים אנשים או משפחות ורק שם הנישואין ידוע. ניתן לכלול שמות נישואין רק אם הם כבר קיימים במאגר הנתונים.<br /><br />ברירת המחדל של ערך זה תהיה לא לכלול שמות משפחה ברשימת המשפחות. ברירת המחדל עבור רשימת השמות נקבעת בדף ההגדרות של קובץ ה-GEDCOM.<br /><br />כאשר הנך משנה את האופציה, בחירתך נשמרת עד שתצא או עד שתסיים לעבוד.<br /><br />";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~רשימת המשפחות~<br /><br />בדף הזה תוכל להציג רשימה של משפחות. השמות מוצגים לפי שם המשפחה וממוינים על פי סדר האלף-בית.<br /><br />תכולת רשימת השמות תלויה ב-:<ol><li>האות שלחצת באינדקס האלף-בית.</li><li> אם לחצת על \"דלג על\" או \"הצג\" רשימת שמות המשפחה.</li></ol>תוכל לחפש לפי שם המשפחה של הבעל או של האישה; שניהם נכללים ברשימה.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["help_family.php"]			= "~דף פירוט של משפחה~<br /><br />הדף מראה לך סקירה כללית של המשפחה שבחרת בדף הקודם.<br /><br />מלמעלה למטה תראה תיבות עם נתונים אישיים של הבעל והוריו, האישה והוריה והילדים.<br /><br />המבנה והתוכן של התיבות האישיות זהים לתוכן התיבות המוכרות מדף אילן היוחסין או מדף הצאצאים.<br /><br />משמאל לתיבות של ההורה יתכן שתראה חץ אם קיימים אב-אבות נוספים בקובץ. לחיצה על החץ, תעביר אותך דור אחד למעלה לדף משפחה חדש כאשר ההורים רשומים כבעל ואישה.<br /><br />בצד שמאל בתוך תיבת השם יתכן שתראה צלמית זום (זכוכית מגדלת) שתראה מידע נוסף על האדם. לחיצה על השם תעביר אותך לדף #pgv_lang[indi_info]# של האדם.<br /><br />בצד שמאל תמצא תפריט קטן שיוכל להביא אותך לדפים עם תרשימים או להביא מידע נוסף. לחלק מפריטי התפריט הללו יש תת-תפריטים שיופיעו כאשר סימן העכבר מתקרב לפריט האב.<br /><br />נתוני קבוצת המשפחה מראים את כל העובדות והמידע הידועים על המשפחה, כמו חתונה, פרטי מדיה והערות. בעובדות, לחיצה על מקום, תעביר אותך לרשימת המקומות שבה תוכל לראות את כל המשפחות או האנשים האחרים הקשורים לאותו מקום. לחיצה על תאריך כלשהו מעבירה אותך ללוח יום השנה, בו תוכל לראות את כל המאורעות שהתרחשו בעבר באותו יום וחודש. ניתן ללחוץ על ישויות מולטימדיה. חלון חדש יפתח ובו ניתן לראות את הישות. לחיצה על כותרת התמונה מראה לך את דף #pgv_lang[media_list]# של התמונה. לחיצה על קישור מקור תראה פרוט על דף המקור.<br /><br />מתחת לתיבות השם של הילדים תמצא קישור אל <b>הוסף ילד/ה למשפחה</b>.<br />על יד תיבות השם של הילדים תראה קישור <b>נתוני קבוצת המשפחה</b> במידה ויש לך מספיק הרשאות, תוכל כאן לערוך, למחוק ולהוסיף מידע ועובדות.<br /><br />כמו על דף #pgv_lang[indi_info]#, תראה בצד שמאל של המסך תפריט. כניסות בתפריט זה ייקחו אותך אל דפים שבהם תקבל מידע על המשפחה או תוכל לבצע פעילויות אחרות הקשורות למשפחה זו.#pgv_lang[more_help]#";
$pgv_lang["add_child_help"] 			= "~הוסף ילד/ה למשפחה~<br /><br />ניתן להוסיף ילד או ילדה למשפחה הזו ע\"י לחיצה על הקישור הזה.<br /><br />קל להוסיף ילד או ילדה: לוחצים על הקישור, ממלאים את התיבות במסך שצץ וזה הכל.<br /><br />";
$pgv_lang["show_fam_gedcom_help"]	= "~הצג מידע מרשומת ה-GEDCOM~<br /><br />לחיצה על הקישור מציגה בחלון שיצוץ מידע ממאגר הנתונים. נתוני GEDCOM המוצגים הם גולמיים, לא מעובדים.<br /><br />";
$pgv_lang["add_fam_clip_help"]		= "~הוסף המשפחה לעגלת גזירי העץ~<br /><br />ניתן להוסיף ל#pgv_lang[clip_cart]# שלך מידע שלם או חלקי על המשפחה. בדף הבא תוכל לבחור את המידע המדויק שברצונך להוסיף: <ol><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ol><br />";
$pgv_lang["show_fam_timeline_help"]	= "~הצג זוג על תרשים קו הזמן~<br /><br />לחיצה על הקישור יקפיץ אותך לדף תרשים קו הזמן עם הצגה של כל העובדות של הזוג בקנה מידה של קו הזמן.<br /><br />";
//-- same variable as individuals page

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~דף רשימת מקורות~<br /><br />בדף הזה מוצגת רשימה של מקורות.<br />בניגוד לדף #pgv_lang[indi_info]# ולדף המשפחות אין למעלה אינדקס אותיות.<br /><br />מקורות יכולים להיות אדם, מאגר מידע ציבורי, מוסד או אמצעי אינטרנטי  וכו'. משמעות הדבר, שקשה למצוא מפתח למיון משותף משום שהמקורות של חקר המשפחה הם אקראיים. PhpGedView <u>כן</u> ממיין את השמות של המקורות בסדר האלף-בית.<br /><br /><b>מקורות</b><br />ללא מקורות לא ניתן לבנות מאגר מידע, משום שלכל המידע במאגר המידע יש מקור. הוא יכול להיות קרוב משפחה של האדם, מוסד,  מאגר מידע ציבורי, ממשלה או רישום פרטי, נתון מאינטרנט וכו' וכו'.<br /><br />ניתן לקשר מקור למספר אנשים. מצד שני, ניתן גם לקשר אדם מסוים למספר מקורות. יתכן שיש מקור שונה לכל מאורע, יהיו אלה לידה, מקצוע, נישואין, ילדים וכו'.<br /><br />";
$pgv_lang["sourcelist_listbox_help"]		= "~תיבת רשימת מקורות~<br /><br />בתיבה זו תראה את שמות המקור כפי שהם מוצגים ב-GEDCOM.<br /><br />השמות מוצגים בסדר האלף-בית. כאשר תלחץ על שם ברשימה, תועבר לדף המקור שבו מוצגת רשימה עם האנשים ו-/או המשפחות הקשורים למקור זה.<br /><br />";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~דף פרטי מקור~<br /><br />בדף הזה מוצגים הנתונים על המקורות. מקורות הם חשובים לחוקר נתוני המשפחה ומאפשרים לעקוב אחרי העקיבות של חוקר אחר כאשר הוא מצא את הנתונים.<br /><br />תוכל לראות נתונים על הכותרת, היוצר, הפרסום והמאגר היכן התגלה המקור. בגלל הסוגים הרבים של מקורות, לחלקם יש יותר מידע מאשר לאחרים.<br /><br />אם פריט מולטימדיה כמו מסמך סרוק קשור למקור, תוכל לעיין בפריט זה ע\"י לחיצה על הפריט. כאשר תלחץ על שם הפריט, תראה את הפריט בדף #pgv_lang[media_list]#.<br /><br />בהמשך לפרטי המקור יש רשימת שמות של אנשים ומשפחות הקשורים למקור הזה. הדבר מאפשר זיהוי של כל הפריטים שהתקבלו ממקור הנתונים ההוא.<br /><br />אם מנהלן האתר אפשר את האופציה, תראה צלמית אחת או יותר על הדף:<ol><li><b>#pgv_lang[view_gedcom]#</b><br />אשר מציג מידע במבנה GEDCOM.</li><li><b>#pgv_lang[add_to_cart]#</b><br />אשר מאפשר שמירת הנתונים ב-#pgv_lang[clip_cart]# שלך כדי להוריד ולייבא אותה לתוכנת חקר המשפחה שלך.</li></ol><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["sources_listbox_help"]		= "~הנתונים הקשורים למקור זה~<br /><br />בתיבה זו תראה את השמות של האנשים והמשפחות הקשורים למקור.<br /><br />השמות מוצגים בסדר האלף-בית. כאשר תלחץ על שם מתוך הרשימה, תועבר לדף הפרטים הרלוונטי.<br /><br />";
$pgv_lang["show_source_gedcom_help"]	= "~הצג מידע מרשומת ה-GEDCOM~<br /><br />ע\"י לחיצה על הקישור, הנתונים על המקור יוצגו במבנה לא מעובד של מאגר המידע.<br /><br />";
$pgv_lang["add_source_clip_help"]		= "~הוסף מקור לעגלת גזרי העץ~<br /><br />ע\"י לחיצה על קישור זה, תוכל להוסיף את נתוני המקור ל#pgv_lang[clip_cart]# שלך כדי להוריד ולייבא אותם תוכנת חקר המשפחה שלך.<br /><br />";
$pgv_lang["delete_source_help"]		= "~מחק המקור מ-GEDCOM~<br /><br />לחיצה על האפשרות מסמנת את המקור למחיקה ממאגר הנתונים.<br /><br />מה זה אומר?<br />נניח שיש לך סיבה טובה למחוק מקור זה ממאגר המידע. אתה לוחץ על הקישור. תתבקש לאשר את המחיקה. אם אתה ממשיך למחוק את המקור יעבור זמן מה עד שתראה הודעה שהמקור נימחק.<br /><br />כאשר אתה ממשיך את ביקורך באתר, תוכל לשים לב שהמקור עדיין זמין וניתן לשימוש כאילו שלא נימחק.<br /><br /><b />זו <u>אינה</u> שגיאה.</b />מנהלן האתר יקבל הודעה שבוצע שינוי במאגר הנתונים ושמחקת את המקור.<br />המנהלן יכול לקבל או לדחות את השינוי שלך. רק אחרי שהמנהלן יאשר את השינוי שלך המחיקה קורה בפועל ובצורה <u>בלתי פיכה</u>. במקרה של ספק המנהלן יתקשר אליך.<br /><br />";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]		= "~היררכית המקומות~<br />(או אנשים במקום)<br /><br />הדף הזה מראה את ההיררכיה של המקומות של ה-GEDCOM ואלו אנשים או משפחות קשורים למקום.<br /><br />במידה ויש קשר בין אדם או משפחה לבין אירוע במקום מסוים, PhpGedView ימצא אותו עבורך.<br /><br />התוצאות מוצגות ברשימה בת שתי עמודות, אחת עבור אנשים והשנייה עבור משפחות.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~מבנה סדר המקומות~<br /><br /><b>ברירת מחדל</b><br />אם בקובץ ה-GEDCOM לא נמצא מבנה מוגדר של מקומות, המקומות מוצגים בסדר של ברירת המחדל.<br /><br />אם היה מוגדר סדר אחר, היינו מציגים אותו בין <b>(</b> ו-<b>)</b> בסוף השורה.<br /><br />";
$pgv_lang["ppp_match_one_help"]		= "~סדר המקומות~<br /><br />GEDCOM סדר<br />מניחים שהמקומות רשומים לפי המבנה המוגדר בקובץ ה-GEDCOM.<br />דבר זה מבטל את סדר ברירת המחדל.";
$pgv_lang["ppp_numfound_help"]		= "~קשרים נמצאו למקום~<br /><br />כאן מציגים את מספר ההתאמות שנמצאו. אם אתה רואה עדיין תיבה של רשימת מקומות, המשמעות שעדיין לא הגעת לרמה התחתונה.<br /><br />תוכל לבחור לראות את כל הרשומות של המקום או תוכל לעדן את החיפוש ע\"י בחירת מקום אחר.<br /><br />";
$pgv_lang["ppp_levels_help"]			= "~רמת מקומות~<br /><br />נתון זה מראה את הרמות שמוצגות עכשיו. תיבת הרשימה שמראה את המקומות, היא למעשה רשימה חלקית של הרמה העליונה.<br /><br />לדוגמה:<br />סדר מיון ברירת מחדל הוא: #pgv_lang[default_form]#<br />מאגר הנתונים.<br />אם הרמה הנוכחית מראה \"ארה\"ב, רמה עליונה\", אז התיבה תציג את המדינות של ארה\"ב.<br />וכו'<br /><br />תוכל ללחוץ על רמה, כדי לחזור שלב אחד או יותר.<br /><br />";
$pgv_lang["ppp_placelist_help"]		= "~היררכית מקום~<br /><br />ברשימה זו תראה מקומות שנמצאו מתחת לרמה הנוכחית שבחרת. אם עדיין לא בחרת מקום, תראה רשימה של המקומות ברמה העליונה (כלומר ארצות ומדינות).<br /><br />ניתן ללחוץ על השמות של המקומות ברשימה; לחיצה על מקום עובדת כמסנן. הפעולה מורידה אותך רמה אחת למטה.<br /><br />";
$pgv_lang["ppp_placelist_help2"]		= "~רשימת מקומות ~<br /><br />ברשימה זו תראה מקומות שנמצאו עד לשלב הזה.<br /><br /> ארצות או מדינות).<br />ניתן ללחוץ על שמות המקומות; לחיצה עובדת כמסנן ותעביר אותך רמה אחת כלפי מטה.<br /><br />רק ברמה העליונה לא תראה רשימת שמות. ברמות מתחת תקבל רשימה של אנשים ומשפחות הקשורות למקום ההוא.<br /><br />";
$pgv_lang["ppp_view_records_help"]	= "~ראה את כל הרשומות~<br /><br />לחיצה על קישור זה יראה רשימה של כל האנשים והמשפחות שיש להם מאורעות שהתרחשו במקום זה. כאשר מגיעים לסוף היררכית המקומות, בדרך כלל לעיר או עיירה, תראה מיידית את רשימת השמות.<br /><br />";
$pgv_lang["ppp_name_list_help"]		= "~רשימת שמות~<br /><br />תיבה זו מציגה רשימה שלמה של אנשים ו-/או משפחות הקשורים למקום זה.<br /><br />ניתן ללחוץ על השמות. כאשר תלחץ על שם, תועבר לדף הפרטים הרלוונטי. תוכל גם לשנות את בחירתך ע\"י לחיצה על מקום בראש הרשימה.<br /><br />";

//-- Mulitmedia-page
$pgv_lang["help_medialist.php"]		= "~רשימת מולטימדיה~<br /><br />הדף רשימת מולטימדיה מציג את כל ישויות המולטימדיה שנמצאים במאגר הנתונים.<br /><br />עבור כל ישות מדיה יתכן שתמצא את הכותרת או את שם הקובץ של הישות, שמות האנשים או המשפחות הקשורים לישות והערות בקשר לישות.<br /><br />לחיצה על הכותרת או על שם הקובץ גורמת לתוצאה זהה ללחיצה על התמונה המזערית של הישות. הישות יפתח ע\"י viewer פנימי של PhpGedView או ע\"י viewer המוגדר בהגדרות הדפדפן המקומי שלך.<br /><br />לחיצה על קישור ה \"הצג\" ליד האנשים או המשפחות תביא אותך לדף המפורט הרלונטי.<br /><br />";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~העלאת קובצי מדיה~<br /><br />העלאת הקובצים פשוטה. להלן מידע נוסף.<br /><br /> <b>תמונות ממוזערות</b><br />רצוי שרוחב התמונות הממוזערות יהיה בערך 100 פיקסלים. שם הקובץ <u>צריך</u> להיות זהה לשם הקובץ של התמונה בגודל המלא. אם המערכת שלך יכולה ליצור בצורה אוטומטית תמונות מזעריות, תראה הודעה על כך על דף העלה מדיה.<br /><br /><b>העלאה</b><br />הקובצים יועלו בצורה אוטומטית לתיקייה <span dir=\"ltr\"><b>#GLOBALS[MEDIA_DIRECTORY]#</b></span> עבור העותק הגדול ולתיקייה <span dir=\"ltr\"><b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b></span> עבור התמונות המזעריות.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]		= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>מידע כללי</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>אירוע</b></a></li><li><a href=\"#calendar_button\"><b>כפתורי הצג יום / הצג חודש / הצג שנה  </b></a></li><li><a href=\"#calendar_tip\"><b>עצה</b></a></li></ul><br /><a name=\"calendar_general\"></a>#pgv_lang[anniversary_calendar]# מראה אנשים ומשפחות הקשורים ליום או חודש מסוימים או לתקופה מסוימת. ישנה מערכת סינון מתקדמת כדי לבחור את המאורעות הנכונים עבור התאריך או התקופה.<dl><dt><b>הראה <a href=\"#calendar_day\">יום</a></b></dt><dd>מראה מאורעות של יום מסוים, ללא תלות בשנה הנבחרת. הפלט הוא רשימה פשוטה של שמות אנשים או משפחות, או רשימה בעלת שני טורים בה אנשים בצד אחד ומשפחות בצד השני.</dd><dt><b>הראה <a href=\"#calendar_month\">חודש</a></b></dt><dd>בלוח יום השנה שמות של אנשים ושמות של משפחות מוצגים בתוך תיבות יום. לוח השנה מוצג כפי שהוא היה בשנה שהקשת בתוך תיבת השנה. כל המאורעות שהתרחשו בעבר עד לשנה הזו מוצגים.<br /><br />אם תבחר גם באופציה \"<a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>, תקבל הצגה ריאליסטית של לוח שנה של אב-אבותך.</dd><dt><b>הצג <a href=\"#calendar_year\">שנה</a></b></dt><dd>תיראה את המאורעות של שנה מסוימת, או של מספר שנים. הפלט הוא רשימה פשוטה של שמות אנשים או משפחות, או רשימה בעלת שני טורים בה אנשים בצד אחד ומשפחות בצד השני.</dd></dl>היום והחודש המוצגים עכשיו הם בצבע מובלט בתפריט לוח יום השנה.<br /><br />ניתן ללחוץ על השמות והתאריכים. לחיצה על שם תביא אותך לדף הפרטים הרלוונטי. לחיצה על תאריך תקפיץ אותך לצורת \"היום\" או \"שנה\", שתציג את כל המאורעות של היום והחודש בתאריך שניתן ללחוץ עליו.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~בחירת יום~<br /><br />השורה העליונה של טבלת הבחירה היא <b>בחירת יום</b>. המשמעות ברורה: בוחרים <u>יום</u>.<br /><br />התוצאה של לחיצה על יום מסוים תלויה באם נמצאים בצורת <b>יום</b> או בצורת <b>חודש</b>.<br /><dl><dt><b>צורת היום</b></dt><dd>בצורה הזו, כאשר לוחצים על יום, המסך מתחדש והרשימה תוצג עבור היום שלחצת.</dd><dt><b>צורת החודש</b></dt><dd>כאשר יש לך לוח חודשי של חודש מסוים על המסך ואתה לוחץ על יום, המסך מתחדש, אבל תראה עדיין את החודש שראית מקודם על המסך. הסיבה לכך היא שתוכל עדיין להחליט לבחור חודש, שנה או מאורע שייראו  לפני שאתה לוחץ על כפתור ה<b>#pgv_lang[viewday]#</b> או ה<b>#pgv_lang[viewmonth]#</b>.<br /><br />בסוף שורת היום תראה <b>קישור מהיר</b> עם התאריך של היום. לחיצה על <b>הקישור המהיר</b> תציג רשימה של היום במבנה ה<b>יום</b>, ללא תלות באם אתה נמצא בצורת ה<b>חודש</b> או בצורת ה<b>יום</b>.</dd></dl>";
$pgv_lang["annivers_month_select_help"]	= "~בחירת חודש~<br /><br />השורה האמצעית של טבלת הבחירה היא בחירת ה<b>חודש</b>. משמעותה ברורה: בוחרים את ה<u>חודש</u>.<br /><br />התוצאה של לחיצה על חודש תלויה אם נימצאים בצורת ה<b>יום</b> או בצורת ה<b>חודש</b>.<br /><dl><dt><b>צורת היום</b></dt><dd>בצורה זו, כאשר לוחצים על חודש, המסך מתחדש ומוצגת רשימה עם תאריכים של החודש הנבחר. כל יתר הבחירות כמו היום, השנה והמאורעות יישארו כפי שהיו.</dd><dt><b>צורת החודש</b></dt><dd>כאשר יש לך לוח חודשי על המסך ואתה לוחץ על חודש בשורת ה<b>חודש</b>, יוצג לוח חודשי של החודש החדש.<br /><br />בסוף שורת החודש תראה  <b>קישור מהיר</b> עם החודש והשנה הנוכחיים. לחיצה על <b>הקישור המהיר</b> תציג את הלוח החודשי במבנה <b>חודשי</b>, ללא תלות באם אתה נמצא בצורת ה<b>חודש</b> או בצורת ה<b>יום</b>.</dd></dl>";
$pgv_lang["annivers_year_select_help"]	= "~תיבה להכנסת שנה~<br /><br />תיבת הכניסה הזו מאפשרת לשנות את השנה של לוח השנה. הקלד שנה בתיבה ולחץ <b>הכנס</b> כדי לשנות את לוח השנה לשנה הזו.<br /><br /><b>מאפיינים מתקדמים</b> עבור <b>#pgv_lang[viewyear]#</b><dl><dt><b>יותר משנה אחת</b></dt><dd>תוכל לחפש תאריכים בתחום של שנים.<br /><br />תחומי השנה הם <u>כוללים</u>. משמעות הדבר שתחום התאריך הוא מ-1 בינואר של השנה הראשונה עד ל-31 בדצמבר בשנה האחרונה המוזכרת. מובאות כאן מספר דוגמאות לתחום השנים:<br /><br /><b>1992-5</b> עבור כל האירועים מ-1992 עד 1995.<br /><b>1972-89</b> עבור כל האירועים מ-1972 עד 1989.<br /><b>1610-759</b> עבור כל האירועים מ-1610 עד 1759.<br /><b>1880-1905</b> עבור כל האירועים מ-1880 עד 1905.<br /><b>880-1105</b> עבור כל האירועים מ-880 עד 1105.<br /><br /> כדי לראות את כל המאורעות של העשור או מאה, ניתן להשתמש ב-<b>?</b> במקום הספרות האחרונות. לדוגמא,<b><span dir=\"ltr\">197?</span></b> לכל המאורעות מ-1970 עד 1979 או <b><span dir=\"ltr\">16??</span></b> לכל המאורעות מ-1600 עד 1699.<br /><br />בחירת תחום שנים ישנה את לוח השנה למצגת של שנה.</dd></dl>";
$pgv_lang["annivers_show_help"]		= "~הראה מאורעות של...~<br />האפשרויות הבאות קיימות:<br /><ol><li><b>כל האנשים</b><br />באפשרות זו מוצגים נתוני כל האנשים והמשפחות.</li><li><b>אירועים ב-100 השנים האחרונות</b><br />באפשרות זו תראה את כל האירועים שהתרחשו ביום או חודש הנבחר, אבל לא מאורעות לפני יותר מ-100 שנה.</li><li><b> אנשים חיים</b><br />כאשר אפשרות זו נבחרה, מציגים רק אנשים חיים. אם המנהלן לא עיצב את PhpGedView בצורה המראה נתוני אנשים חיים לכולם, תראה את האפשרות הזו רק אם התחברת למערכת.</li></ol>כל בחירת אפשרית תגרום שמאורעות יוצגו לפי בחירתך.<br /><br />ההגדרה של היום, החודש והשנה וצורת ה<b>יום</b> או ה<b>חודש</b> נשארים כפי שהיו.<br /><br />";
$pgv_lang["annivers_sex_help"]		= "~בחירת מגדר~<br />כאשר אתה מחובר למערכת או אם המנהלן פסל את אופציית הפרטיות, תוכל לבחור בין האפשרויות:<ol><li>צלמית <b>הכל</b><br />אפשרות זו היא אפשרות ברירת מחדל. המאורעות של כל האנשים ומשפחות מוצגים.</li><li>צלמית <b>זכר</b><br />כאן מוצגים רק המאורעות של זכרים. רק בני משפחה זכריים יוצגו עם מאורעות משפחתיים.</li><li>צלמית <b>נקבה</b><br />כאן מוצגים רק המאורעות של נקבות. רק בני משפחה שהן נקבות יוצגו עם מאורעות משפחתיים.</li></ol>לחיצה על אופציה מציגה את המאורעות שבחרת.<br /><br />ההגדרה של היום, החודש והשנה וצורת ה<b>יום</b> או ה<b>חודש</b> נשארים כפי שהיו.<br /><br />";
$pgv_lang["annivers_event_help"]		= "~בחירת מאורע~<br />תוכל לבחור את כל המאורעות של אנשים ומשפחות או רק את המאורע הנבחר. לא ניתן לבחור יותר מאירוע ספציפי אחד.<br /><br />לחיצה על האופציה מציגה את המאורע הנבחר.<br /><br />הערכים האחרים של יום, חודש, שנה, ומאורעות וה<b>יום</b> או ה<b>חודש</b> נשארים כפי שהיו.<br /><br />";
$pgv_lang["annivers_tip_help"]		= "~עצה~<br />התאם את תאריך הבחירה לתאריך כלשהו בעבר.<br /><br />אם תלחץ על אחד מכפתורי הצג, תראה רשימה או כניסת לוח חודשי עבור היום הזה. כל הגילים, המאורעות וכו' מחושבים מחדש מהתאריך שבחרת. למעשה תראה את הרשימה או לוח יום השנה כפי שהקרוב שלך היה רואה לפני שנים.<br /><br />";
$pgv_lang["day_month_help"]			= "~כפתורי הצג יום / הצג חודש / הצג שנה~<br /><ul><li>כפתור<b>הצג יום</b> תגרום להצגת האירועים שהתרחשו ביום הנבחר. כל השנים נסרקות, כך שניתן לקבוע רק את היום והחודש. שינוי השנה אינו משפיע על ההצגה. תוכל להגביל את ההצגה ע\"י בחירת <b>אירועים בשנים האחרונות</b> או <b>אנשים חיים</b>.<br /><br />הגילים ברשימה מחושבים לפי השנה הנוכחית.</li><li>כפתור <b>הצג חודש</b> מציג לוח חודשי של החודש והשנה הנבחרים. גם כאן תוכל להגביל את הרשימות ע\"י אפשרות <b>אירועים בשנים האחרונות</b> או <b>אנשים חיים</b>.<br /><br />בחירת שנה בעבר בצירוף <b>אירועים בשנים האחרונות</b> נותנת לך תמונה ריאליסטית של הלוח החודשי שהוצג על קיר אב אבותיך. הגילים בלוח החודשי מחושבים לפי השנה בתיבת בחירת השנה.</li><li>כפתור <b>הצג שנה</b> מציג ברשימה את האירועים של השנה הנבחרת. שוב תוכל להגביל את הרשימה ע\"י אפשרות <b>אירועים בשנים האחרונות</b> או <b>אנשים חיים</b>.<br /><br />ניתן להראות את האירועים של יותר משנה אחת. תוכל להקליד את הספרה האחרונה של השנה השנייה אחרי השנה הראשונה כאשר סימן <b>-</b> מפריד ביניהם. למשל:<br /><b>1992-4</b> עבור כל המאורעות בין 1992 ועד ל-1994<br /><b>1976-1984</b> עבור כל המאורעות בין 1976 ועד ל-1984<br /><br />כדי לראות את כל המאורעות של העשור או מאה, ניתן להשתמש ב-<b>?</b> במקום הספרות האחרונות. לדוגמא, <b><span dir=\"ltr\">197?</span></b> לכל המאורעות מ-1970 עד 1979 או <b><span dir=\"ltr\">16??</span></b> לכל המאורעות מ-1600 עד 1699.</li></ul>כאשר רוצים <b>לשנות את השנה חייבים </b> להשתמש באחד מהכפתורים הלל.  ההגדרות האחרות נשארות כפי שהיו.<br /><br />";

//-- Clipping Cart-page
$pgv_lang["help_clippings.php"]		= "~עגלת גזירי העץ~<br />#pgv_lang[clip_cart]# מאפשרת לקיחת קטעים (\"גזירות\") מאילן יוחסין זה וקשירתם ביחד בקובץ אחד להורדה ולאחר מכן לייבא לתוכנת עץ המשפחה שלך. הקובץ שיורד הוא במבנה GEDCOM.<br /><ul><li>איך גוזרים?<br />הפעולה קלה. בכל מקום שתראה שם שניתן ללחוץ עליו (אדם, משפחה או מקור) תוכל לעבור לדף מפורט של השם הזה. משם תיראה אפשרות <b>#pgv_lang[add_to_cart]#</b>. לחיצה על קישור זה תעביר אותך לדף עם מספר אפשרויות הורדה.</li><li>איך מורידים?<br />אחרי שיש לך פריטים בעגלה, תוכל להוריד אותם ע\"י לחיצה על הקישור <b>הורד עכשיו</b>. יש לעקוב אחר ההנחיות והקישורים.</li></ul><br />";
$pgv_lang["clip_download_help"]		= "~הורד גזירות~<br /><br />לחיצה על הקישור הזה תעביר אותך לדף הבא. אם יש גזירים בעגלתך שקשורים לישויות מולטימדיה , הם מוצגים על הדף.<br /><br />יש רק לעקוב אחר ההנחיות.<br /><br />";
$pgv_lang["empty_cart_help"]			= "~רוקן עגלה~<br /><br />ע\"י לחיצה על קישור זה, #pgv_lang[clip_cart]# שלך תרוקן לחלוטין.<br /><br />אם אינך רוצה להוריד את כל האנשים, משפחות וכו' מ#pgv_lang[clip_cart]#, תוכל להוריד פריטים פריט אחר פריט ע\"י לחיצה על הקישור <b>הסר</b> בתוך תיבות השם. <u>אין</u> תיבת אישור, כאשר תלחץ את הקישוריות הללו; המחיקה תתבצע מידית.<br /><br />";
$pgv_lang["add_by_id_help"]			= "~הוסף לעגלת גזירי עץ לפי קוד זיהוי~<br /><br />תיבת הקלט הזו מאפשרת הכנסת קודי זיהוי של אנשים כך שהם מתווספים לעגלת הגזירים. לאחר שהם התווספו תוצע אפשרות לקשר את קרובי האנשים הללו לעגלת הגזירים שלך.<br /><br />אם אינך יודע את קוד הזיהוי של אדם, תוכל לבצע חיפוש לפי שם ע\"י לחיצת הצלמית האישית שליד כפתור הוסף.<br /><br />";
$pgv_lang["zip_help"]				= "~זיפ לגזירות~<br /><br />בחר ברירה זו כדי לשמור את הגזירות בקובץ זיפ. למידע נוסף על קובצי זיפ, נא בקר <a href=\"http://www.winzip.com\" target=\"_blank\">http://www.winzip.com</a>.";
$pgv_lang["include_media_help"]		= "~כלול מדיה~<br /><br />בחר בברירה הזו כדי לכלול קובצי מדיה הקשורים לרשומות בעגלת הגזירים שלך. בחירה זו יוצרת אוטומטית את הקובצים במבנה זיפ בזמן ההורדה.<br /><br />";
$pgv_lang["clip_cart_help"]			= "~עגלת גזירה~<br /><br />תיבת הרשימה הזו מראה את התוכן של עגלת הגזירים שלך. עמודת ה<u>סוגים</u> מציינת את הסוג של כל כניסה. הערכים יכולים להיות אדם-<span dir=\"ltr\">Individual (INDI)</span>, משפחה-<span dir=\"ltr\">Family (FAM)</span>, מקור-<span dir=\"ltr\">Source (SOUR)</span>, מאגר-<span dir=\"ltr\">Repository (REPO)</span>, הודעה-<span dir=\"ltr\">Note (NOTE)</span>, וישויות מדיה-<span dir=\"ltr\">Media (OBJE)</span>. כל אחד מוצג ע\"י הצלמית שלו. <u>קוד הזיהוי</u> הוא קוד הזיהוי של ישות מהסוג הספציפי הזה. טור ה<u>שם / תאור</u> נותן או את השם של המשפחה או את השם של האדם או תאור של הפריט. כפתור הסר יסיר את הרשומה מעגלת הגזירים, <b>שים לב ש<u>אין</u> בקשה לאישור ההורדה.</b><br /><br />";

//-- GEDCOM Edit Utillity
$pgv_lang["show_changes_help"]		= "~הראה את השינויים ל-GEDCOM.~<br /><br />כאשר תראה הודעה זו משמעות הדבר:<ol><li>מישהו שינה את ה-GEDCOM<br />יתכן שהוסיפו, הורידו או שינו רשומות.</li><li>השינויים עדיין לא אושרו ע\"י המנהלן.<br />אחרי שהמנהלן מאשר או דוחה את השינויים, לא תראה הודעה זו יותר.</li></ol>תוכל לראות את השינויים ע\"י לחיצה על הקישור. אם תגלה שהשינוי לא נכון, נא יידע את מנהלן.<br /><br />";

//-- Search-page
$pgv_lang["help_search.php"]			= "~דף החיפוש~<br /><br /> למרות שהדף הזה נראה פשוט, מאחורי שתי אפשרויות הבחירה שלו קיים מנגנון חיפוש חזק. רוב אתרי חקר שושלת היוחסין מאפשרים חיפוש רק לפי שם. PhpGedView נותן לחפש כמעט כל דבר.<br /><br />תיבת החיפוש בצד ימין של המסך זהה לתיבת החיפוש בכותרת.<br /><br />אם אתה מחפש אנשים הקשורים לשנה מסוימת, הקלד רק את השנה. התוכנית תמצא את הקשרים.<br /><br />מחפש שם או מקום? הקלד את השם או המקום בשלמות או חלק ממנו, ו-PhpGedView עושה את היתר.<br /><br /><b>חיפוש לפי סאונדקס</b>.<br />ע\"י שימוש בתיבה בצד השמאלי תוכל לחפש שמות לועזיים של אנשים או מקומות גם אם אינך יודע איך מאייתים את השם במדויק.<br /><br />אם באתר יש יותר ממאגר נתונים אחד והמנהלן אפשר מעבר בניהם, החיפוש יחזיר תוצאות מכל הקובצים.<br /><br />תמצא עזרה נוספת על שתי התיבות ע\"י לחיצה על ה-\"<b>?</b>\" מעל לתיבות.<br /><br />";
$pgv_lang["search_enter_terms_help"]	= "~הכנס תנאי חיפוש~<br /><br />בתיבת חיפוש זו תוכל להכניס נתונים כמו תאריכים, שמות פרטיים, שמות משפחה, מקומות, מולטימדיה וכו'.<br /><br /><b>ג'וקרים</b><br />הג'וקרים, המוכרים (*, ? ) אינם נתמכים, אבל התוכנה מניחה שמשתמשים בג'וקרים.<br /><br />נניח שאתה מקיש בתיבת החיפוש <b>הרצ</b> התוצאה תהייה, בתנאי שהכניסות קיימות בקובץ :<div style=\"padding-right:30px;\"><b>הרצ</b>ל לוי<br /><b>הרצ</b>ליה כהן<br />לוני <b>הרצ</b>יקוביץ<br />מישהו שנולד ב<b>הרצ</b>ליה<br />וכו'</div><br /><b>תאריכים</b><br />הקלדת שנה בתיבת החיפוש תחזיר את השמות של כל האנשים שבצורה זו או אחרת קשורים לשנה זו.<br /><br />אם תקיש <b>1950</b>, התוצאה תהייה האנשים בעלי אירועים ב-1950. האירועים יכולים להיות לידה, חתונה, פטירה, בר מצווח, הסמכת מורמונים וכו'.<br /><br />אם תקיש \"<span dir=\"ltr\">4 Dec</span>\", כל האנשים הקשורים לאירוע ב-4 בדצמבר, בשנה כלשהי, יוצגו. אבל גם אנשים קשורים לתאריכים של 14 בדצמבר או 24 בדצמבר יוצגו. כפי שאתה רואה, התוכנה הוסיפה ג'וקרים, כך שאין צורך להקיש אותם. לפעמים התוצאות מפתיעות.<br /><br /><b>מבנה תאריך</b><br />PhpGedView מחפש נתונים כפי שהם רשומים בקובץ GEDCOM. כך שאם אתה רוצה לחפש אירוע ב-14 לדצמבר, עליך להקיש <br /><b><span dir=\"ltr\"> 14&nbsp;dec</span></b><br />מכיוון שכך רשום תאריך</b> במאגר הנתונים.<br /><br />אבל, אם תקיש, למשל, <b>dec&nbsp;14</b>, התוצאה יכולה לכלול אדם הקשור לאירוע ב-08&nbsp;לדצמבר&nbsp;18<b>14</b>. שוב הנתונים יכולים להיות מפתיעים.<br /><br />תוכל להשתמש בביטויים רגילים בחיפושיך אם הם מוכרים לך. למשל, אם אתה רוצה למצוא את כל האנשים שיש להם תאריכים במאה ה-20, תוכל למלא בתנאי חיפוש <b>19<span dir=\"ltr\">[0-9][0-9]</span></b> ותראה את כל האנשים עם תאריכם בין 1900 לבין 1999.<br /><br />#pgv_lang[soundex_search_help]# #pgv_lang[search_replace_help]#";
$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br /><br />כאן ניתן לחפש שגיאת כתיב או מידע לא מדויק אחר ולהחליף אותו במידע נכון.<br /><br /><b>חיפוש</b><br />מאפיין זה מבצע חיפוש כמו  <a href=\"help_text.php?help=search_enter_terms_help\">חיפוש רגיל</a>.<br /><br /><b>החלפה</b><br />כל הטכסטים שנימצאו בחלק החיפוש על מאגר הנתונים, יוחלפו ע\"י טכסט ההחלפה.<br /><br /><b>לדוגמא...</b><br />נניח שבטעות שגית בכתיב השם של סבא רבא מיכאל שלך. רשמת בטעות 'מיכייל'.<br /><br />הקש בתיבת החיפוש: <b>מיכייל</b>.  ובתיבת ההחלפה הקש: <b>מיכאל</b><br />כל מופע של \"מיכייל\" יוחלף ב-\"מיכאל\"<br /><br /><b>חפש...</b><br />בחר מה שתרצה לחפש. ניתן לחפש רק שמות, רק מקומות או ללא הגבלה (חפש הכל). אופצית <i>#pgv_lang[search_place_word]#</i> תחפש את הטכסט שלך במקומות כמילה שלמה.  המשמעות היא שחיפוש <i>UT</i> יחזיר רק <b>UT</b> ולא <i>UT</i> במילים אחרות כמו  Connectic<b>ut</b>.<br /><br />אל תחשוש, אם בטעות החלפת משהו שאינך רוצה להחליף. עליך רק ללחוץ על הקישור \"קבל/דחה שינויים\" בתחתית הדף כדי לאשר את השינויים שאתה רוצה לאשר ולדחות את השינויים שאתה לא רוצה לאשר.<br /><br />תודיע לנו אם אתה זקוק לעזרה נוספת לגבי מערכת החיפוש הזו, כך שנוכל להרחיב את קובץ העזרה הזה .<br /><br />";
$pgv_lang["soundex_search_help"]		= "~#pgv_lang[soundex_search]#~<br /><br />סאונדקס היא שיטת קידוד מילים לפי הצליל שלהם. דבר זה מאפשר לחפש שמות ומקומות במאגר הנתונים כאשר אינך יודע בדיוק את הכתיב שלהם. PhpGedView תומך בשתי שיטות סאונדקס שונות שיוצרות תוצאות שונות.<ul><li><b>בסיסי</b><br />השיטה הזו המוגנת ע\"י פטנט של ראסל משנת 1918, פשוטה מאוד וניתן לחשבה גם ביד.<br /><br />משום שהשיטה הבסיסית שומרת על אות הראשונה של השם כחלק מהקוד, היא אינה עוזרת כאשר אינך בטוח באות הראשונה. הנוסחה הבסיסית אינה מתאימה לשמות שמקורם אינו אנגלית וגם לשמות אנגליים התוצאות מפתיעות. למשל, החיפוש הבסיסי של <b>Smith</b> יחזיר לא רק <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, שהן וריאציות של השם <b>Smith</b>, אלא גם  <b>Smead, Sneed, Smoote, Sammett, Shand,</b> ו-<b>Snoddy</b>.<br /><br /></li><li><b>דאיטש-מוקוטוף</b><br />השיטה שפותחה ב-1985 היא הרבה יותר מורכבת מאשר השיטה הבסיסית ולא ניתן לחשבה בקלות בצורה ידנית.<br /><br />חיפוש סאונדקס בשיטה זו מחזיר תוצאות יותר מדויקות.</li></ul>לפרטים על שתי שיטות הסאונדקס בקר בדף  <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a>.<br /><br />";
$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />בחירת <b>#pgv_lang[search_tagfon]#</b> גורמת לפונקצית חיפוש להתעלם מתגי GEDCOM הבאים:<div style=\"padding-left:30px;\"><b>PGVU_</b> - שינוי אחרון ע\"י<br /><b>CHAN</b> - תאריך השינוי האחרון<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />בנוסף לתגים האופציונליים הללו, פונקצית החיפוש מתעלמת תמיד מהתגים הבאים:<div style=\"padding-left:30px;\"><b>UID_</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div><br /><br />";
$pgv_lang["search_include_ASSO_help"]   	= "~#pgv_lang[search_asso_label]#~<br /><br />הבחירה גורמת ל-PhpGedView להראות את כל האנשים שלאדם או למשפחה שנמצאו ישירות בחיפוש יש קשר שותפות.  ההפך, שיראה את כל האנשים או המשפחות מוצגים כאשר לאדם הנימצא בחיפוש ישיר יש קשר שותפות לאנשים האחרים או למשפחות האחרות הללו, אינו אפשרי.<br /><br />לדוגמא, נניח שאדם <b>א</b> הוא סנדק של אדם <b>ב</b>.  הקשר הזה נרשם ברשומת GEDCOM של אדם <b>ב</b> ע\"י תג ASSO.  לא קיים תג מתאים ברשומת ה-GEDCOM של אדם <b>א</b>.<br /><br />כאשר האופציה מסומנת כ<b>#pgv_lang[yes]#</b> ורשימת תוצאות החיפוש כוללת את <b>ב</b>, <b>א</b> יכלל אוטומתית בגלל תג ASSO ברשומת ה-GEDCOM של <b>ב</b>.  מצד שני, אם תוצאת החיפוש כוללת את <b>א</b>, <b>ב</b> לא יכלל אוטומטית משום ששום תג ASSO מתאים לא קיים ברשומת ה-GEDCOM של אדם <b>א</b>.<br /><br />";

//-- Individual Information-page
$pgv_lang["help_individual.php"]		= "~דף #pgv_lang[indi_info]#~<br /><br />בדף הזה מוצגים כל פרטי האדם.<br /><br />אם קיימת תמונה, היא תופיע למעלה בצד ימין. ליד התמונה תראה את שמות האדם.<br /><br />יתכן ולשמות מקושרים הערות ומקורות. אם לשם יש הערות או מקורות, תראה אותם מתחת לאותם השמות אליהם הם מתייחסים.<br /><br />יתכן שלאדם יש שמות כינוי (אולי הוא מוכר בשם אחר). במקרה כזה הכינוי יוצג.<br /><br />אם יש לך הרשאות לעדכן אדם זה, תוכל לראות קישורי <b>עדכון</b> ו<b>מחיקה</b> ליד הנתונים שניתן לעדכן אותם.<br /><br />על הדף תראה חוצצים עבור <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, ו<b>#pgv_lang[relatives]#</b>. בחוצצים הללו תוכל למצוא את כל המידע השמור במאגר הנתונים.<br /><ul><li>החוצץ <b>#pgv_lang[personal_facts]#</b> יראה לך את העובדות והפרטים על האדם ועל נישואיו. לחיצה על תאריך כלשהו מעבירה אותך ל #pgv_lang[anniversary_calendar]# עבור היום, כך שתוכל לראות מאורעות אחרים שהתרחשו באותו יום. לחיצה על מקום, תעביר אותך לרשימת המקומות שבה תוכל לראות את האנשים האחרים שהיו להם מאורעות באותו המקום. לנישואין ולמאורעות אחרים הקשורים למשפחה, השם של בן/בת הזוג זמין כך שתוכל לראות את נתוניו, כמו כן מוצע קישור לרשום המשפחה.</li><li>החוצץ <b>#pgv_lang[notes]#</b> מראה הערות כלליות הקשורות לאדם זה.#pgv_lang[help_individual.php_part2]#";
$pgv_lang["help_individual.php_part2"]	= "</li><li>החוצץ <b>#pgv_lang[ssourcess]#</b> מראה לך את כל המקורות <u>הכלליים</u> של האדם. מקורות אלו <u>אינם</u> מקושרים לעובדות מסוימות, אפילו לא לשם האדם; הן כן מקושרות לאדם עצמו. לחיצה על כותרת של מקור תעביר אותך לדף מפורט יותר של המקור ובו תראה את האנשים האחרים הקשורים לאותו מקור.</li><li>על החוצץ <b>#pgv_lang[media]#</b> נמצאים כל התמונות ופרטי מדיה אחרים הקשורים לאדם זה. לחיצה על התמונה הממוזערת תפתח מצג גדול יותר של התמונה. לחיצה על כותרת התמונה, תראה את התמונה על דף #pgv_lang[media_list]#.</li><li>על החוצץ <b>#pgv_lang[relatives]#</b> מוצגים הוריו, אחיו ואחיותיו וכל בנות/בני הזוג והילדים שהיו לאדם. האנשים מוצגים בתיבות דומות לתרשימים שכבר ראית.</li></ul>בצד השמאלי של הדף תמצא תיבה ובה קישורים. הרבה מהקישורים בתיבה זהים לקישורים בתפריטים. למשל, לחיצה על הקישור <b>#pgv_lang[pedigree_chart]#</b> תיקח אותך לתרשים אילן היוחסין עבור אדם זה. דבר זה שונה מהקישור בתפריט, כי לחיצה על הקישור <b>#pgv_lang[pedigree_chart]#</b> מהתפריט תחזיר אותך לברירת המחדל של אילן היוחסין של מאגר הנתונים הזה.<br /><br />אחד הקישורים שיתכן ויופיע ברשימה זו, אם המנהלן אפשר אותו, הוא הקישור <b>#pgv_lang[view_gedcom]#</b>. הקישור יראה לך את רשומת ה-GEDCOM הלא מעובדת של אדם זה.<br /><br />אם #pgv_lang[clip_cart]# אופשרה ע\"י מנהלן האתר, יהיה לך קישור המאפשר הוספת אדם זה ב#pgv_lang[clip_cart]# שלך.<br /><br />הקישור <b>#pgv_lang[relationship_to_me]#</b> יופיע רק אם אתה מחובר למערכת  ובעל מספר מזהה בקובץ ה-GEDCOM. הקישור יקח אותך לתרשים אילן היוחסין ויראה איך אתה מקורב לאדם הזה.<br /><br >#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_person_help"]		= "~הסר אדם מ-GEDCOM~<br /><br />לחיצה על האפשרות מסמנת את האדם להסרה ממאגר הנתונים.<br /><br />מה פרוש הדבר?<br />נניח שיש לך סיבה טובה להסיר אדם זה ממאגר הנתונים. אתה לוחץ על הקישור ותתבקש לאשר את בקשת המחיקה שלך. אם תחליט להמשיך, יתכן ויעבור זמן מה עד שתקבל הודעה שהאדם הוסר.<br /><br />כאשר תמשיך את ביקורך באתר יתכן ותשים לב שהאדם עדיין קיים באתר כמו קודם כאילו שלא נמחק.<br /><br /><b>זו <u>לא </u> שגיאה</b>. מנהלן האתר יקבל הודעה שבוצע שינוי למאגר הנתונים, ושאתה הסרת את האדם.<br />המנהלן יקבל (או ידחה) את השינוי שלך.  תהליך ההסרה יקבל תוקף רק לאחר אישור המנהלן לשינוי שלך והוא <u>בלתי הפיך</u>. במקרה של ספק, המנהלן יתקשר אתך.<br /><br />";
$pgv_lang["delete_name_help"]		= "~ערוך או מחק שם מ-GEDCOM~<br /><br /><b>ערוך שם</b><br />לחיצה על הקישור תפתח חלון נוסף, שם תוכל לערוך את שם האדם. עליך להקיש את השינויים בתיבות וללחוץ על הכפתור ולסגור את החלון.<br /><br /><b>מחק שם</b><br />הקשה על האפשרות הזו מסמנת את השם הזה כמועמד למחיקה מאגר הנתונים. יש לשים לב שמחיקת שם והסרת אדם הן פעילויות שונות לגמרי. מחיקת שם מוציאה את השם הזה מהאדם. האדם <u>אינו</u> נמחק. אם אתה רוצה למחוק 'ידוע בשם' לאדם יישארו עדיין שם או שמות נוספים. אם אתה רוצה למחוק <u>רק</u> את השם, האדם לא ימחק, אלא יישאר במאגר כ<b>(לא ידוע)</b> או כ-<b>#pgv_lang[NN]#</b>. האדם נישאר קשור לכל הקרובים שלו, למקורות, הערות וכו'.<br /><br />איך זה פועל?<br />תתבקש לאשר את בקשת המחיקה שלך. אם תחליט להמשיך, יתכן ויעבור זמן מה עד שתקבל הודעה שהשם הוסר.<br /><br />כאשר תמשיך את ביקורך באתר יתכן ותשים לב שהשם עדיין קיים באתר כמו קודם כאילו שלא נמחק.<br /><br /><b>זו <u>לא </u> שגיאה</b>. מנהלן האתר יקבל הודעה שבוצע שינוי למאגר הנתונים, ושאתה הסרת את השם.<br />המנהלן יקבל (או ידחה) את השינוי שלך.  תהליך ההסרה יקבל תוקף רק לאחר אישור המנהלן לשינוי שלך והוא <u>בלתי הפיך</u>. במקרה של ספק, המנהלן יתקשר אתך.<br /><br />";
$pgv_lang["add_name_help"]			= "~הוסף שם חדש~<br /><br />הקשר מאפשר הוספת שם נוסף לאדם זה. לפעמים אנשים מוכרים בשמות נוספים או בשמות כינוי. הקישור מאפשר הוספת שמות לאדם מבלי לשנות את השם הישן.<br /><br />";
$pgv_lang["add_sibling_help"] 		= "~#pgv_lang[add_sibling]#~<br /><br />לחיצה על הקישור מאפשרת לך להוסיף ילד או ילדה למשפחה.<br />\"המשפחה\", במקרה זה, היא האבא והאמא של האדם העיקרי של המסך הזה.<br /><br />יש לזכור, שמוסיפים אח או אחות לאדם זה. הוספת אח או אחות היא פעולה פשוטה: לחץ על הקישור, מלא תיבות במסך שצץ וזה הכל.<br /><br .<br /><br />הוספת בן או בת לאדם העיקרי נעשית למטה יותר בקישור \"#pgv_lang[as_spouse]#\".<br /><br />";
$pgv_lang["add_son_daughter_help"] 	= "~#pgv_lang[add_son_daughter]#~<br /><br />לחיצה על קישור זה מאפשרת להוסיף ילד או ילדה למשפחה.<br />\"המשפחה\", במקרה זה, היא האדם העיקרי של המסך ובן/בת הזוג.<br /><br />יש לזכור, שמוסיפים בן או בת לאדם זה. הוספת בן או בת היא פעולה פשוטה: לחץ על הקישור, מלא תיבות במסך שצץ וזה הכל.<br /><br />הוספת אח או אחות לאדם העיקרי נעשית למעלה יותר בקישור \"#pgv_lang[as_child]#\".<br /><br />";
$pgv_lang["link_child_help"] 			= "~#pgv_lang[link_as_child]#~<br /><br />ע\"י לחיצה על קישור זה תוכל לקשר אדם זה כילד למשפחה קיימת.<br /><br />נניח שהוריו של האדם לא היו ידועים וגילית שהם (ההורים) קיימים במאגר הנתונים הזה.<br /><br />לחץ על הקישור, הוסף קוד הזיהוי של המשפחה ובזה סיימת את המשימה. אם אינך יודע את הקוד, ניתן לחפש אותו.<br /><br />";
$pgv_lang["link_husband_help"]		= "~#pgv_lang[link_as_husband]#~<br /><br />האופציה מאפשרת, על ידי לחיצה על הקישור, לקשור את האדם הנוכחי כבעל למשפחה קיימת במאגר הנתונים, משפחה שעד עכשיו אין לה בעל. האדם הנוכחי ירשם במקום האדם הלא ידוע. כל האירועים, נתוני החתונה וילדים ישמרו את הקישורים הקיימים למשפחה.<br /><br />לחץ על הקישור, הכנס את קוד הזיהוי של המשפחה (אם הקוד אינו ידוע, תוכל לחפש אותו בחלון שיצוץ), וסיימת את המשימה. זו בחירת עדכון מתקדמת שיש להשתמש בה רק אם המשפחה שאליה רוצים לקשר כבר קיימת. אם ברצונך רק להוסיף משפחה <u>חדשה</u>, השתמש בקישור <b>#pgv_lang[add_new_wife]#</b>.<br /><br />";
$pgv_lang["add_husband_help"] 		= "~#pgv_lang[add_new_husb]#~<br /><br />לחיצה על קישור זה מוסיפה אדם <u>חדש</u> ממגדר זכר וקושרת אותו לאדם העיקרי (אישה) כבעל חדש.<br /><br />לחץ על הקישור ויצוץ חלון. בחלון זה ניתן להוסיף את האדם החדש. מלא פרטים נוספים ככל שידוע לך על האדם שהתווסף ולחץ על כפתור <b>שמור</b><br /><br />זה הכל.<br /><br />";
$pgv_lang["link_new_husb_help"]		= "~#pgv_lang[link_new_husb]#~<br />לחיצה על קישור זה מוסיפה אדם קיים כבעל חדש לאדם זה. הפעולה תיצור משפחה חדשה עם הבעל שתבחר. יש גם אפשרות לציין נישואין של המשפחה החדשה הזו.<br /><br />";
$pgv_lang["add_opf_child_help"]		= "~#pgv_lang[add_opf_child]#~<br /><br />ע\"י לחיצה על קישור זה ניתן להוסיף ילד <u>חדש</u> לאדם זה, ע\"י יצירת משפחה חד-הורית.<br /><br />לחץ על הקישור ותועבר לחלון שבו תוכל להוסיף את האדם החדש.  מלא את התיבות שביכולתך למלא ולחץ על כפתור <b>שמור</b>.<br /><br />זה הכל.<br /><br />";
$pgv_lang["link_wife_help"] 			= "~#pgv_lang[link_as_wife]#~<br /><br />האופציה מאפשרת, על ידי לחיצה על הקישור, לקשור את האדם הנוכחי כאישה למשפחה קיימת במאגר הנתונים, משפחה שעד עכשיו אין לה אישה. האדם הנוכחי ירשם במקום האדם הלא ידוע. כל האירועים, נתוני החתונה וילדים ישמרו את הקישורים הקיימים למשפחה.<br /><br />לחץ על הקישור, הכנס את קוד הזיהוי של המשפחה (אם הקוד אינו ידוע, תוכל לחפש אותו בחלון שיצוץ), וסיימת את המשימה. זו בחירת עדכון מתקדמת שיש להשתמש בה רק אם המשפחה שאליה רוצים לקשר כבר קיימת. אם ברצונך רק להוסיף משפחה <u>חדשה</u>, השתמש בקישור <b>#pgv_lang[add_new_husb]#</b>.<br /><br />";
$pgv_lang["add_wife_help"] 			= "~#pgv_lang[add_new_wife]#~<br /><br />לחיצה על קישור זה מוסיפה אדם <u>חדש</u> ממגדר נקבה וקושרת אותו לאדם העיקרי (בעל) כאישה חדשה.<br /><br />לחץ על הקישור ויצוץ חלון. בחלון זה ניתן להוסיף את האדם החדש. מלא פרטים נוספים ככל שידוע לך על האדם שהתווסף ולחץ על כפתור <b>שמור</b><br /><br />זה הכל.<br /><br />";
$pgv_lang["link_new_wife_help"]		= "~#pgv_lang[link_new_wife]#~<br />לחיצה על קישור זה מוסיפה אדם קיים כאישה חדשה לאדם זה. הפעולה תיצור משפחה חדשה עם האישה שתבחר. יש גם אפשרות לציין נישואין של המשפחה החדשה הזו.<br /><br />";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br /><b>הוסף אבא חדש או אמא חדשה</b><br /><br />כמובן שיהיו הרבה אנשים ב-GEDCOM ללא רשומות אבא או אמא.<br /><br />במקרה כזה תימצא בדף <b>#pgv_lang[indi_info]#</b>, בחוצץ <b>#pgv_lang[relatives]#</b> בטבלת <b>#pgv_lang[as_child]#</b> קישור להוספת אבא או אמא <b>חדשים</b> לאדם.<br /><br />שים לב שקישורים אלו נועדים להוספת אבא ו-/או אמא <u>חדשים</u>. אם לאבא או לאמא יש כבר רשומה במאגר הנתונים הזה, אז עליך להשתמש בקישור: <b>#pgv_lang[link_as_child]#</b>, שגם אותו תימצא על דף <b>#pgv_lang[indi_info]#</b> מתחת לטבלה הקודמת,.<br /><br />";
$pgv_lang["show_fact_sources_help"]	= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br />כאשר האופציה הזו נבחרת, תראה את כל רשומות המקור או ההערות של אדם זה.  כאשר האופציה אינה נבחרת, רשומות המקור או ההערות המקושרות לעובדות אחרות של אדם זה לא תוצגנה.<br /><br />";
$pgv_lang["age_differences_help"]		= "~#pgv_lang[age_differences]#~<br />כאשר האופציה הזו נבחרת, חוצץ «#pgv_lang[relatives]#» יראה הפרשי תאריך כדלהלן:<br /><ul><li>תאריכי לידה של בני-זוג.<br />ערך שלילי מציין שבן-הזוג השני מבוגר מהראשון.<br /><br /></li><li>תאריך נישואין ולידה של הילד הראשון.<br />ערך שלילי כאן מציין שהילד נולד לפני תאריך הנישואין או שתאריך הנישואין או תאריך הלידה מוטעה.<br /><br /></li><li>תאריכי לידה של אחים.<br />ערך שלילי כאן מציין שסדר הילדים מוטעה או אחד מתאריכי הלידה שגוי.</li></ul><br /><br />";

//-- Add Facts
$pgv_lang["add_facts_help"]			= "~הוסף עובדות חדשות~<br /><br />כאן תוכל להוסיף עובדה לרשומה שאותה אתה עורך.<br /><br />בחר קודם כל עובדה מהרשימה הנגללת, לחץ אח\"כ על הכפתור <b>הוסף</b>. הרשימה הנגללת כוללת כבר את כל העובדות שניתן להוסיף למאגר הנתונים.<br /><br />";
$pgv_lang["add_custom_facts_help"]		= "~הוסף מאורע מותאם~<br />אם אינך מוצא את העובדה שאתה רוצה להוסיף ברשימת עובדות  GEDCOM, תוכל להכניס <b>מאורע מותאם</b>.<br /><br />הכנסת מאורע מותאם קלה כמו הכנסת עובדה מוגדרת מראש. ההבדל היחיד הוא שעליך לרשום את שם העובדה בנוסף לנתונים האחרים במקום לבחור אותן מרשימה. דבר זה נעשה בשדה העליון: <b>#pgv_lang[type]#</b><br /><br />";
$pgv_lang["add_note_help"]			= "#pgv_lang[multiple_help]#<br />~הוסף הערה~<br />אם ברצונך להוסיף הערה לרשומה זו, כאן המקום.<br /><br />לחץ על הקישור, יפתח חלון ותוכל להקליד את הערתך. כאשר סיימת להקליד את ההערה, לחץ על הכפתור מתחת לתיבה, סגור את החלון, וזה הכל.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]	= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br />כאשר תלחץ על הקישור <b>#pgv_lang[add_shared_note]#</b>, נפתח חלון חדש.  תוכל לבחור לקשר להערה משותפת קיימת, או תוכל ליצור הערה משותפת חדשה ובאותו זמן ליצור קישור אליו.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]		= "#pgv_lang[multiple_help]#<br />~הוסף ציטוט של מקור~<br />כאן ניתן להוסיף <b>ציטוט</b> מקור לרשומה זו.<br /><br />לחץ על הקישור, יפתח חלון ותוכל לבחור את המקור מתוך רשימה (מצא קוד זיהוי) או צור מקור חדש והוסף לאחר מכן את הציטוט.<br /><br />הוספת מקורות היא חלק חשוב של חקר המשפחה משום שזה מאפשר לחוקרים אחרים לוודא מהיכן השגת את נתוניך.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]			= "~#pgv_lang[add_media]#~<br /><br />הוספת קובצי מולטימדיה (ממ) ל-GEDCOM היא מאפיין נחמד מאוד. למרות שלתוכנה זו יש מראה נהדר ללא מדיה, הוספת תמונות או ממ אחר לקרוביך משפרת אותו.<br /><br /><b>מה צריך להבין לגבי ממ?</b><br />קיימים אין ספור מבנים של ממ. למרות ש-PhpGedView יכול לטפל ברובם, יש מספר דברים שיש לקחת בחשבון.<br /><ul><li><b>מבנים</b><br />ניתן לערוך ולשמור תמונות במבנים שונים. למשל -  jpg .png .bmp .gif. וכו'. לכל התמונות בדוגמה יש גודל מסך זהה כאשר מסתכלים עליהם, אבל יש הבדל משמעותי בגודל הקובצים. בדרך כלל קובצי jpg נחשבים לחסכוניים מכולם במונחי נפח אכסון.</li><li><b>גודל תמונה</b><br /><br />ככל שהתמונה המקורית גדולה יותר כן הקובץ המתקבל גדול יותר. על התמונה להתאים על המסך ללא פס גלילה, הרוחב והגובה המכסימליים צריכים לא להיות יותר מאשר הרוחב והגובה של המסך של מסכים של 1024x768 פיקסלים, אבל לא כל המסך הזה פנוי להראות תמונה. את גודל התמונה יש לקבוע בהתאם. תמונות קטנות יותר עדיפות מבחינת הקטנת גודל הקובץ.</li><li><b>רזולוציה</b><br />הרזולוציה של תמונות מוגדרת בדרך כלל כנקודות לאינטש - \"dpi\"&nbsp;-&nbsp;dots/inch&nbsp;, אבל זה בר-תוקף רק עבור תמונות מודפסות. לגבי תמונות על מסך, יש להשתמש בסה\"כ נקודות או פיקסלים. כאשר תמונה מודפסת, יתכן והרזולוציה שלה 150-300 dpi או יותר, תלוי במדפסת. הרזולוציה על המסך אינו בדרך כלל יותר מאשר 50 פיקסלים לאינטש. אם תמונתך לא תודפס לעולם, תוכל להקטין את הרזולוציה שלה (וכתוצאה מכך את גודל הקובץ שלה) מבלי להשפיע על איכות התמונה. אם מדפיסים תמונה בעלת רזולוציה נמוכה עם הגדלה גדולה מדי, האיכות שלה נפגעת, היא תראה גרגרית.#pgv_lang[add_media_help_part2]#";
$pgv_lang["add_media_help_part2"]		= "</li><li><b>עומק הצבע</b><br />דרך אחרת לשמור את הקובץ קטן היא להפחית את מספר הצבעים שמשתמשים בהם. מספר הצבעים יכול להשתנות משחור לבן (שני צבעים) עד לצבעים אמיתיים (מיליוני צבעים) וכל מצבי הביניים. ככל שיש יותר צבעים - הקובץ גדול יותר.</li></ul><b>למה חשוב שגודל הקובץ יהיה קטן?</b><br /><ul><li>קודם כל: נפח האכסון בשרת (webspace) שלנו מוגבל. ככל שהקובצים גדולים יותר - נדרש יותר מקום אכסון על השרת. ככל שצריך יותר נפח - יש לשלם עליו יותר.</li><li>רוחב פס (Bandwidth). ככל שהשרת צריך לשלוח נתונים למקום רחוק (אליך), כך יש לשלם יותר. הסיבה נעוצה בכך שהיכולת של השרת לשלוח נתונים לאינטרנט מוגבלת והקישוריות הזו משותפת (יש לשלם על כך) לכול התוכנות הרצות על השרת. PhpGedView היא אחת מהתוכנות הרבות המתחלקות בשרת. העלות, בדרך כלל, יחסית לכמות הנתונים הנשלחת ומתקבלת על ידי כל תוכנה.</li><li>זמן הורדה. אם יש לך קובצים גדולים, המשתמשים (וגם אתה) צריכים להמתין יותר זמן להורדת הדף מהשרת. לא כל אחד מחובר חיבור מהיר לאינטרנט באמצעות כבלים, פס רחב או מודם DSL.</li></ul><b>איך מעלים את ה-ממ לשרת?</b><br />יש שתי דרכים להעלאת מדיה לאתר. אם יש לך הרבה פריטי מדיה להעלות לשרת עליך להתקשר עם מנהלן האתר ולדון איתו לגבי הדרכים הטובות ביותר. במידה ומנהלן האתר שלך אפשר, תוכל להשתמש בהעלאת המדיה בתפריט  #pgv_lang[mgv]#  שלך.  תוכל גם כן להשתמש באופציית העלה על דף המולטימדיה כדי להעלות פרטי מדיה.<br /><br />";
$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br />האופציה יוצרת תמונות מזעריות לכל הקבצים בתיקייה הנוכחית שאין להם עדיין תמונות מזעריות.  זה הרבה יותר נח מאשר לחיצה על קישור <b>#pgv_lang[gen_thumb]#</b> עבור כל קובץ כזה.<br /><br />אם הנך רוצה לשמור על שליטה לאיזה קבצים צריך שתהיה תמונה מזערית מותאמת, אין עליך להשתמש באופציה זו.  במקום זה לחץ על קישורי  <b>#pgv_lang[gen_thumb]#</b> המתאימים.<br /><br />";
$pgv_lang["add_facts_general_help"]		= "~מידע כללי על הוספה~<br />כאשר הוספת עובדה, הערה, מקור או קובץ מולטימדיה לרשומה במאגר הנתונים, משתמש בעל הרשאות אישור צריך עדיין לאשר את התוספת.<br /><br />עד לאישור, השינויים מוצגים על הדף כממתינים לאישור ומזוהים על ידי סימון בגבולות צבעוניים. כל המשתמשים בעלי הרשאות עדכון יכולים לראות את השינויים יחד עם הנתונים המקוריים. משתמשים ללא זכויות עריכה רואים רק את הנתונים המקוריים. לאחר שהשינוי יאושר, הגבולות ייעלמו והנתונים החדשים יוצגו בצורה הרגילה. גם משתמשים ללא הרשאות יראו את הנתונים החדשים.<br /><br />";

//-- Edit user
$pgv_lang["edituser_my_account_help"]	= "בדף הזה תוכל לשנות את ההגדרות ואת ההעדפות שלך.<br /><br />תוכל לשנות את קוד המשתמש, השם המלא, הסיסמא, השפה, כתובת הדואר האלקטרוני, עיצוב האתר (צורת ההצגה) וצורת התקשורת המועדפת על ידך.<br /><br />הפריט שלא תוכל לשנות בעצמך הוא קוד הזיהוי שלך בקובץ ה-GEDCOM. את זה רק המנהלן יוכל לשנות";
$pgv_lang["edituser_username_help"]	= "~#pgv_lang[username]#~<br /><br />בתיבה זו תוכל לשנות את קוד המשתמש שלך. אם אינך רוצה עוד, מסיבה כלשהי, את קוד המשתמש שלך, תוכל לשנותו. בהשתמשך בטופס הזה.<br /><br />קוד המשתמש <u>רגיש לאותיות הלועזיות הקטנות והגדולות</u>. המשמעות ש-<b>John</b> שונה מ-<b>john</b> ומ-<b>JOHN</b>.<br /><br />יש להשתמש <u>רק</u> בתווים מהשפות ש-PhpGedView תומכת בהם. תוכל להשתמש באותיות לועזיות קטנות וגדולות ואותיות עבריות, עם או בלי אותיות מיוחדות בעלות סימנים דיאקריטיים, ספרות, מקף (-), וקו תחתון (_).<br /><br /><u>אין</u> להשתמש בסימני פיסוק, רווחים.<br /><br />";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />בתיבה הזו תוכל לשנות את השם הפרטי שלך.  זה השם שאחרים רואים כאשר אתה מחובר למערכת.<br /><br />למרות שאתה בוחר מה למלא בשדה זה, רצוי שתיידע את המנהלן כאשר אתה משנה אותו.  יתכן שאחרים מתפלאים ושואלים שאלות כאשר הם רואים אדם לא מוכר המחובר למערכת. המנהלן יכול לגלות זאת מבלי שהוא מקבל הודעה ממך, אבל רצוי שתחסוך ממנו את העבודה המיותרת הזו.<br /><br />";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />בתיבה הזו תוכל לשנות את שם המשפחה שלך.  זה השם שאחרים רואים כאשר אתה מחובר למערכת.<br /><br />למרות שאתה בוחר מה למלא בשדה זה, רצוי שתיידע את המנהלן כאשר אתה משנה אותו.  יתכן שאחרים מתפלאים ושואלים שאלות כאשר הם רואים אדם לא מוכר המחובר למערכת. המנהלן יכול לגלות זאת מבלי שהוא מקבל הודעה ממך, אבל רצוי שתחסוך ממנו את העבודה המיותרת הזו.<br /><br />";
$pgv_lang["edituser_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />זה קוד הזיהוי הפנימי שלך המקשר אותך לנתוניך במאגר הנתונים.<br /><br />אינך יכול לשנות קוד זיהוי זה; הוא מוגדר ע\"י המנהלן. אם אתה חושב שקוד הזיהוי שגוי, התקשר עם המנהלן כדי שהוא יתקנו.<br /><br />";
$pgv_lang["edituser_rootid_help"]		="~#pgv_lang[rootid]#~<br /><br />זהו קוד זיהוי של האדם ההתחלה (מוצא) של כל התרשימים שלך.<br /><br />אם תלחץ, למשל, על קישור לאילן היוחסין, תראה את האדם הזה בתיבה השמאלית הקיצונית. האדם בתחילת התרשים לא חייב להיות אתה; תוכל להתחיל מאדם כלשהו (סבך או הדודה של אמך, למשל) כל עוד יש לך הרשאות לראות את האדם.<br /><br />ברוב התרשימים תוכל לשנות את אדם המוצא, אבל השינוי הוא רק עבור הדפים המסוימים הללו.<br /><br />";
$pgv_lang["edituser_password_help"]	= "~#pgv_lang[password]#~<br /><br />שינוי סיסמא באופן סדיר הוא מנהג טוב. יש לזכור שכל מי שיודע את קוד המשתמש שלך ואת הסיסמא שלך, תהיה לו גישה לנתונים שלך.<br /><br />הגדר סיסמא של לפחות 6 תווים. ככל שהסיסמא ארוכה יותר כן ייטב. תוכל להשתמש באותיות הגדולות או הקטנות של האלף-בית הלועזי עם או בלי סימנים דיאקריטיים, בספרות, במקף (-) ובקו תחתון (_). <u>אין</u> להשתמש בסימני פיסוק ורווחים. השתמש בצירוף של אותיות לועזיות גדולות וקטנות, באותיות עבריות, בספרות ובסימנים אחרים. כדוגמא: <b>5Z_q\$P4=ז9rטk3</b>.<br /><br />בדומה לקוד המשתמש, הסיסמא <u>רגישה לגודל האותיות</u>. משמעות הדבר ש-<b>Secret.Password!#13</b> שונה מ-<b>secret.password!#13</b>  ומ-<b>SECRET.PASSWORD!#13</b><br /><br />.";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />אם שינית את סיסמתך, עליך גם לאשר אותה. האישור חשוב כדי לוודא שלא חלה טעות הקלדה בסיסמא.<br />אם התוכנה מגלה שהסיסמא והאישור שונים, תקבל הודעת שגיאה: <b>#pgv_lang[password_mismatch]#</b>.<br />שדה הסיסמא ושדה האישור ינוקו ועליך להקיש שוב את הסיסמא החדשה בשני השדות.<br /><br />";
$pgv_lang["edituser_change_lang_help"]	= "~#pgv_lang[change_lang]#~<br /><br />כאן ניתן לשנות את השפה שבה PhpGedview יציג את הדפים וההודעות אחרי שתתחבר.<br /><br />בתחילה כאשר תיגש לאתר, PhpGedView מניח שתרצה לראות הכל בשפה שמוגדרת כשפה המועדפת שלך בדפדפן שלך. אם ההנחה אינה נכונה, תאכוף את זה כאן. למשל, יתכן שהדפדפן שלך מוגדר באנגלית משום שזו השפה השכיחה על האינטרנט. אבל יתכן שהייתה מעדיף לראות הכל בפינית או בעברית, לצרכי חקר משפחה. כאן תעשה את זה.<br /><br />המנהלן שולט בבחירת השפות הזמינות עבורך. אם הבחירה שלך אינה רשומה, עליך להתקשר עם המנהלן.<br /><br />זכור ש-PhpGedView הוא פרויקט מאויש ע\"י צוות בין-לאומי של מתנדבים שאינם מקבלים תשלום. מומחים באים והולכים. כתוצאה, התמיכה בשפות האחרות מאנגלית אינה לעתים טובה כפי שהייתה צריכה להיות.<br /><br />אם תראה משהו שלא תורגם, תורגם בצורה שגויה, או ניתן לנסח בצורה טובה יותר, אנא ידע את המנהלן שלך. המנהלן יודע איך להשיג את צוות הפיתוח של PhpGedView כדי שהדאגה שלך תטופל. עדיף, שתתרום מזמנך. אנחנו יכולים להשתמש בעזרה.<br /><br />";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />חשובה לנו כתובת דואר אלקטרוני נכונה שלך  כדי לשמור איתך על קשר.<br /><br />אם תקבל כתובת דואר אלקטרוני חדשה, למשל משום שהחלפת את הספק שלך, אנא אל תשכח לעדכן את הכתובת שלך גם כאן. לא תקבל מהאתר הזה אישור על שינוי הכתובת הזו, אבל כל ההודעות העתידיות שישלחו אליך יועברו לכתובת החדשה הזו.<br /><br />";
$pgv_lang["edituser_user_theme_help"]	= "~#pgv_lang[user_theme]#~<br /><br />לאתר זה יש מספר עיצובים או הופעות. יש תוכניות שקוראות לזה \"עורות\", אבל כאן הם נקראים \"עיצובים/themes\".<br /><br />אותם הנתונים מוראים בכל העיצובים, רק צורתו או אפילו מיקומו על המסך שונה אולי. הדבר דומה לתמונה במסגרת שונה ובנוסף גם בתליית התמונה בחדר אחר. התמונה לא משתנה, אבל היא נראית שונה לגמרי.<br /><br />נסה. הגדר עיצוב אחר. הבט בו, נסה שנית. בסוף בחר את העיצוב שיצא חן בעינך. בכל פעם שתתחבר, התוכנית תיתן את העיצוב שבחרת בפעם הקודמת. אין צורך לעבור לדף העיצוב הזה כדי לשנות את העיצוב המועדף.<br /><br />";
$pgv_lang["edituser_contact_meth_help"]	= "~#pgv_lang[user_contact_method]#~<br />מערכת הדואר של PhpGedView מאפשרת מספר דרכי קשר שונות. דרך הקשר לשלוח דואר למנהלן מוגדרת ע\"י המנהלן ולא תוכל לשנות אותה. אתה יכול לשנות את דרך הקשר <u>לקבלת דואר</u>. הגדרות האתר קובעות איזה שיטות זמינות עבורך.<br />";
$pgv_lang["mail_option1_help"]		= "בבחירה זו משתמשים במערכת הדיווח הפנימית של PhpGedView ושום דואר אלקטרוני לא נשלח.<br /><br />בדרך זו תקבל רק  <u>הודעות פנימיות</u> ממשתמשים אחרים.<br />כאשר משתמש אחר שולח לך הודעה מאתר זה, ההודעה תופיע באזור ההודעות שעל הדף האישי שלך #pgv_lang[mygedview]#. אם הורדת את האזור מהדף #pgv_lang[mygedview]# שלך לא תראה הודעות. הן תופענה מיד לאחר שתגדיר את דף אזור ההודעות על #pgv_lang[mygedview]#<br /><br />";
$pgv_lang["mail_option2_help"]		= "הבחירה הזו דומה ל#pgv_lang[messaging]#, בתוספת אחת. נשלח גם עותק נוסף לכתובת הדואר האלקטרוני שלך, כפי שמוגדרת עבור קוד המשתמש שלך על דף המשתמש שלך.<br /><br />שיטת קשר זו היא ברירת המחדל.<br /><br />";
$pgv_lang["mail_option3_help"]		= "בבחירה הזו תקבל רק הודעות לכתובת הדואר האלקטרוני שלך שמוגדרת על דף המשתמש שלך. מערכת ההודעות הפנימית ל-PhpGedView לא תהיה כלל בשימוש, ובאזור ההודעות על דף #pgv_lang[mygedview]# האישי שלך לא תהיינה שום הודעות.<br /><br />";
$pgv_lang["mail_option4_help"]		= "בבחירה הזו לא תקבל שום הודעות. אפילו המנהלן לא יכול להגיע אליך.<br /><br />";

//-- Add user
//$pgv_lang["help_adduser.php"]		= "#pgv_lang[sorry]#";

//-- Admin
$pgv_lang["admin_help"]			= "בדף הזה תמצא את כל הקישורים לדפי תצורה, ניהול, תעוד וקובצי log.<br /><br />#pgv_lang[system_time]#</b>, מתחת לכותרת הדף, תראה את הזמן של מחשב השרת שלך. שבו האתר שלך רץ. משמעות הדבר שאם השרת בניו יורק ואתה בצרפת, הזמן יהיה שש שעות פחות מזמן המקומי שלך, אלא, כמובן, אם השרת רץ עם זמן גריניץ' (Greenwich Mean Time - GMT). הזמן שמוצג הוא זמן פתיחת הדף או חידושו.<br /><br /><b>אזהרה</b><br />כאשר תראה הודעת אזהרה אדומה מתחת לזמן המערכת, משמעות הדבר שעדיין ניתן לכתוב על ה-<i>config.php</i> שלך. אחרי שתגדיר את תצורת האתר שלך, רצוי, מסיבות <b>ביטחון</b>, לשנות בחזרה את ההרשאה של קובץ זה לקריאה בלבד. עליך לבצע פעולה זו <u>ידנית</u>, משום ש-PhpGedView אינו יכול לבצע פעולה זו עבורך.<br /><br />";

//-- User Admin
$pgv_lang["useradmin_help"]			= "~ניהול המשתמשים~<br /><br />בדף הזה תוכל לנהל את המשתמשים הקיימים ולהוסיף משתמשים חדשים.<br /><br /><b>#pgv_lang[current_users]#</b><br />בטבלה זו מוצגים המשתמשים הקיימים, מצבם וזכויותיהם. תוכל <b>למחוק</b> או <b>לערוך</b> משתמשים.<br /><br /><b>#pgv_lang[add_user]#</b><br />הטופס הזה כמעט זהה למה שאתה מכיר מדף <b>#pgv_lang[editowndata]#</b>.<br /><br />לנושאים רבים לא הוכן טכסט עזרה מיוחד עבור מנהלן. במקרים אלו תראה את ההודעה הבאה:";
$pgv_lang["useradmin_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />#pgv_lang[gedcomid]#  מזהה את המשתמש. הוא מוגדר ע\"י המנהלן.<br />הוא מזהה את המשתמש על דפים רבים כמן <b>#pgv_lang[my_indi]#</b> ו<b>#pgv_lang[my_pedigree]#</b>.<br /><br  />תוכל להגדיר את קוד הזיהוי של ה-GEDCOM עבור המשתמש לכל קובץ GEDCOM בו משתמשת התוכנית. אם למשתמש אין רשומה ב-GEDCOM, יש להשאיר את תיבת הטכסט ריקה.<br /><br />";
$pgv_lang["useradmin_rootid_help"]		= "~אדם ההתחלה באילן היוחסין ~<br /><br />לכל מאגר מידע של חקר משפחה, תוכל להגדיר <b>אדם מוצא</b> עבור המשתמש.<br /><br />אדם המוצא לא חייב להיות המשתמש עצמו; הוא יכול להיות כל אחד. יתכן שהמשתמש ירצה שהתוכנית תתחיל עם אילן היוחסין שלו. הבחירה נעשית כאן והיא בידיך, וכן לגבי אדם מוצא ברירת מחדל בתרשימים אחרים.<br /><br />אם למשתמש יש הרשאות עריכה, הוא יכול לשנות את ההגדרה הזו בעצמו.<br /><br />";
$pgv_lang["useradmin_can_admin_help"]	= "~תיבת בחירה #pgv_lang[can_admin]#~<br /><br />אם התיבה הזו מסומנת, למשתמש יהיו זכויות דומות לזכויותיך.<dl><dt>ההרשאות כוללות:</dt><dd>הוסף / הורד / ערוך משתמשים</dd><dd>לשלוח הודעות לכל המשתמשים בבת אחת</dd><dd>לערוך הודעות ברוכים הבאים</dd><dd>לערוך ולשנות תצורה של קובצי השפות</dd><dt></dt><dd>לשדרג PhpGedView</dd><dd>לשנות תצורה של התוכנה ושל GEDCOM</dd><dd>לנהל GEDCOM-ים</dd><dd>לשנות את הגדרות הפרטיות</dd><dd>וכל דבר אחר שלא מוזכר כאן.</dd></dl>המשתמש <u>אינו</u> יכול לשנות את ההגדרות של האתר שלך מחוץ ל-PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"]	= "~תיבת בחירה #pgv_lang[sync_gedcom]#~<br /><br />אם התיבה הזו מסומנת, ולמשתמש יש קוד זיהוי המשויך לו ב-GEDCOM, אז נתוני המשתמש שלו יסונכרנו אוטומטית עם נתוני רשומות ה-GEDCOM שלו. משמעות הדבר שכאשר עורכים את נתוני ה-GEDCOM של המשתמש, חלק מהנתונים כגון כתובת הדואר האלקטרוני והשם יועתקו לרשומת המשתמש שלו. כאשר עורכים את רשומת המשתמש, נתונים מתאימים יועתקו לרשומת ה-GEDCOM.";
$pgv_lang["useradmin_can_edit_help"]	= "~#pgv_lang[can_edit]#~<br /><br /> למשתמש יכולות להיות הרשאות גישה ועריכה שונות לכול מאגר הנתונים של חקר המשפחה במערכת.<ul><li><b>#pgv_lang[none]#:</b> למשתמש אין גישה לנתונים פרטיים ב-GEDCOM זה.</li><li><b>#pgv_lang[access]#:</b> המשתמש לא יכול לערוך או לאשר נתונים למאגר הנתונים אבל יכול לראות נתונים פרטיים.</li><li><b>#pgv_lang[edit]#:</b> המשתמש יכול לערוך נתונים, אבל משתמש אחר בעל הרשאת <b>#pgv_lang[accept]#</b> צריך לאשר את השינויים לפני שהם מתווספים למאגר הנתונים ולפני שהנתונים מתפרסמים.</li><li><b>#pgv_lang[accept]#:</b> המשתמש יכול לערוך וגם לאשר שינויים של אחרים.</li><li><b>#pgv_lang[admin_gedcom]#:</b> המשתמש יכול לערוך ולאשר שינויים של משתמשים אחרים.  המשתמש יכול לערוך נתוני תצורה ופרטיות של GEDCOM <u>זה</u>.</li></ul>מנהלנים שניתנים לזיהוי ע\"י תיבת בחירה <b>#pgv_lang[can_admin]#</b>, מקבלים בצורה אוטומטית הרשאות <b>#pgv_lang[admin_gedcom]#</b>.<br /><br />.";
$pgv_lang["useradmin_verified_help"]	= "~#pgv_lang[verified]#~<br /><br /><b>רישום עצמי</b><br />משתמש יכול לבקש קוד משתמש חדש ע\"י שימוש במודול <b>רישום עצמי</b>.<br /><br />אם הוא עושה כך, הוא יקבל דואר אלקטרוני עם קישור כדי לאשר את בקשתו. אחרי שהמבקש פעל לפי ההנחיות בדואר האלקטרוני, תראה את התיבה הזו מסומנת, ותוכל להמשיך בשלב הבא, <b>#pgv_lang[verified_by_admin]#</b>. עליך להמתין עם אישורך עד שהתיבה מסומנת.<br /><br /><b>הוסף משתמש ידנית</b><br />אם אתה משתמש בטופס כדי להוסיף משתמש ידנית, תמצא שהתיבה כבר מסומנת.<br /><br />";
$pgv_lang["useradmin_verbyadmin_help"]	="~#pgv_lang[verified_by_admin]#~<br /><br />אם משתמש השתמש בתת המערכת של רישום עצמי ואישר את עצמו, אז הפעולה האחרונה, לפני שקוד המשתמש שלו יהיה פעיל, תהיה האישור שלך.<br /><br />אחרי שאישרת  את הבקשה של המשתמש לקוד משתמש חדש, המשתמש יקבל הודעה בדואר אלקטרוני. ההודעה תודיע למשתמש שקוד המשתמש שלו פעיל עכשיו. הוא יכול להתחבר עם קוד המשתמש והסיסמא שהוא סיפק בזמן שביקש את המשתמש החדש שלו.<br /><br />";
$pgv_lang["useradmin_edit_user_help"] 	= "~#pgv_lang[update_user]#~<br /><br />הטופס הזה משמש את המנהלן כאשר הוא רוצה לשנות נתוני משתמש.<br /><br />הטופס דומה לטפסים <b>#pgv_lang[add_user]#</b> ול<b>#pgv_lang[update_myaccount]#</b>.<br /><br />.";
$pgv_lang["useradmin_visibleonline_help"]	= "~גלוי כמחובר~<br /><br />תיבת הבחירה הזו שולטת אם משתמשים אחרים רואים אותך כאשר אתה מחובר. היא שולטת גם אם אתה יכול ליראות משתמשים מחוברים שהוגדרו כנראים.<br /><br />כאשר התיבה אינה נבחרת, אחרים לא יראו אותך, ואתה לא תוכל לראות משתמשים מחוברים אחרים. כאשר התיבה מסומנת, ההפך נכון. אחרים יראו אותך ואתה תראה את האחרים שהוגדרו כנראים.<br /><br />";
$pgv_lang["useradmin_editaccount_help"]	= "~ערוך נתוני משתמש~<br /><br />אם התיבה מסומנת, המשתמש אינו יכול לערוך את המשתמש שלו. למרות שבדרך כלל לא מומלץ, תוכל להגדיר קוד משתמש וסיסמא יחידים עבור מספר משתמשים. הבחירה מונעת מהמשתמשים עריכה של נתוני המשתמש המשותף שלהם.<br /><br />";
$pgv_lang["useradmin_relation_priv_help"]	= "~#pgv_lang[user_relationship_priv]#~<br /><br />אם התיבה נבחרה, המשתמש יכול לגשת רק אל האנשים החיים שהם קרוביו. הוא יכול לראות את נתוני האנשים שהם במרחק שביל הקרבה כפי שמוגדר בהגדרות <i>#pgv_lang[user_path_length]#</i> שלו. ניתן לבקש הגדרת פרטיות הקרבה לכול המשתמשים ע\"י בחירת האופציה הגלובלית בהגדרות הפרטיות של ה-Gedcom.<br /><br />ההגדרה הזו דורשת שהמשתמש מקושר לקוד זיהוי של ה-Gedcom לפני שהוא יכול לראות אנשים חיים.";
$pgv_lang["useradmin_path_length_help"]	= "~#pgv_lang[user_path_length]#~<br /><br />אם <i>#pgv_lang[user_relationship_priv]#</i> אופשר, המשתמש הזה יכול לראות או לערוך אנשים חיים בתחום מספר השלבים של המספר הזה.<br />";
$pgv_lang["useradmin_auto_accept_help"]	= "~#pgv_lang[user_auto_accept]#~<br /><br />בחירת התיבה מאפשרת למערכת לאשר בצורה אוטומטית את השינויים שמשתמש זה עשה. למשתמש חייבת להיות הרשאת אשר ב-GEDCOM כדי שההגדרה הזו תתבצע.<br /><br />";

//-- Manage Sites
$pgv_lang["help_managesites"] 		= "~נהל אתרים~<br /><br />על דף זה תוכל להוסיף אתרים מרוחקים ולאסור כתובות IP.<br /><br />ניתן להוסיף אתרים מרוחקים ע\"י הספקת כותרת האתר, URL, קוד זיהוי של המאגר הנתונים (אופציונאלי), ושם משתמש וסיסמא עבור שרות האינטרנט המרוחק.<br /><br />איסור כתובות IP  מבוצע ע\"י הספקת תחום כתובות IP תקף. למשל, <span dir=\"ltr\">212.10.*.*</span>  אתרים מרוחקים שכתובת ה-IP שלהם בתחום כתובות IP ברשימה האסורה לא יוכלו לגשת לשרות האינטרנט המרוחק שלך. ניתן גם לאסור כתובות IP ספציפיות.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]		= "~הוספת אתרים מרוחקים~<br /><br />כדי להוסיף אתר מרוחק, ספק כותרת האתר, URL של שרות האינטרנט המרוחק, קוד זיהוי של המאגר הנתונים (אופציונאלי), ושם משתמש וסיסמא עליך ללחץ על כפתור הוסף כדי לסיים את התהליך.  אם האתר המרוחק מאפשר אמות בלתי ידוע, עליך להשאיר את שם המשתמש והסיסמא ריקים.";
//-- IP Address Banning
$pgv_lang["help_banning"]			= "~איסור כתובת IP~<br /><br />כדי למנוע מאתר מרוחק גישה לשרות האינטרנט שלך, עליך לספק כתובת IP ספציפית או תחום כתובות IP תקפים, למשל, <span dir=\"ltr\">212.10.*.*</span> ולחץ על כפתור הגש.";
$pgv_lang["help_manual_search_engines"]    = "~Manual Search Engine Spider Marking~<br /><br />PhpGedView automatically provides search engines with smaller data files with fewer links.  The data is limited to the individual and immediate family, without adding information about grand parents or grand children.  Many reports and server-intensive pages like the calendar are off limits to the spiders.<br /><br />If a search engine is not automatically recognized and you wish to provide it data to index, you can list it here.  If you do not want to provide it data, you list it below in the banned IP section.<br /><br />If you wish to see what data is provided to search engines to index, list your own IP address here.  <font color=\"red\">WARNING:</font> This will lock you out of the admin interface, and you must remove the IP by logging in from a different machine or manually editing the <i>/index/search_engines.php</i> file.<br /><br />To manually mark a remote site as a search engine spider, provide a specific IP address or a valid IP address range, for example, 212.10.*.* and click the Submit button.  Many popular search engines like Google and Yahoo will be detected automatically."; //-- @#@

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]	= "~Search Engine Detected~<br /><br />PhpGedView automatically provides search engines with smaller data files with fewer links.  The data is limited to the individual and immediate family, without adding information about grand parents or grand children.  Many reports and server-intensive pages like the calendar are off limits to the spiders.<br /><br />Attempts by the spiders to go to those pages result in showing this page.  If you are seeing this text, the software believes you are a search engine spider.  Below is the list of pages that are allowed to be spidered and will provide the abbreviated data.<br /><br />Real users who follow search engine links into this site will see the full pages and data, and not this page.";
//--@#@

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]	= "~הוספת GEDCOM לעומת העלאתו~<dl><dt><b>העלאת קובצי GEDCOM</b></dt><dd>ניתן לבצע את העלאת הקובצים בצורה מקוונת - on line. ניתן להעלות את הקובצים מכל מקום, ללא צורך בתוכנית ftp.</dd><dt><b>הוספת קובצי GEDCOM</b></dt><dd>אם קובץ נמצא עדיין בתיקיית ה-GEDCOM שלך, תוכל להשתמש בו שוב ללא העלאה נוספת. לפעמים חייבים להשתמש ב\"הוסף במקום\"בהעלה, בגלל גודל הקובץ או מגבלות ההעלאה.</dd></dl>את שני התהליכים, הוספה והעלאה, ניתן לסיים ב-4 שלבים פשוטים. רק השלב הראשון שונה בשני התהליכים.<br /><br />";
$pgv_lang["gedcom_configfile_help"]		= "~קובץ תצורה של GEDCOM~<br /><br />זהו הקובץ שבו שומרים את כל ההגדרות הבסיסיות של מאגר בנתוני חקר המשפחה. קיים קובץ נפרד לכל מאגר נתונים כזה.<br /><br />השביל ושם קובץ התצורה מוצגים בטבלת <b>#pgv_lang[current_gedcoms]#</b> על דף <b>#pgv_lang[gedcom_adm_head]#</b>.<br /><br />";
$pgv_lang["default_gedcom_help"]		= "~ברירת מחדל GEDCOM~<br /><br />אם יש לך יותר מאגר נתוני חקר משפחה אחד, תוכל כאן להגדיר איזה מהם יהיה ברירת המחדל.<br /><br />ברירת המחדל הזו תוצג לכול המבקרים ולמשתמשים שטרם התחברו.<br /><br />משתמשים שיכולים לעדכן את הגדרות המשתמש שלהם יכולים לשנות את ברירת המחדל הזו. במקרה הזה, מאגר הנתונים המועדף על המשתמש יוצג אחרי ההתחברות.<br /><br />";
$pgv_lang["delete_gedcom_help"]		= "~מחק GEDCOM~<br /><br />PhpGedView מייבא רשומות מקובץ GEDCOM שהועלה קודם. כאשר אתה בוחר <b>מחק</b>, התוכנית מוחקת את הרשומות מהחלק הזה של מאגר הנתונים. עליך לאשר את בקשת המחיקה.<br /><br />קובץ ה-GEDCOM המקורי ישמר בתיקייה שאליה העלית אותו, אלא אם מחקת אותו בכוונה. אם תרצה מאוחר יותר לעבוד שוב עם ה-GEDCOM, אין צורך להעלות את הקובץ שנית. במקום זאת תוכל לבחור את הפונקציה  <b>#pgv_lang[add_gedcom]#</b>.<br /><br />";
$pgv_lang["add_gedcom_help"]		= "~#pgv_lang[add_gedcom]#~<br /><br />כאשר אתה משתמש באפשרות <b>#pgv_lang[add_gedcom]#</b>, מניחים שכבר העלית את קובץ ה-GEDCOM על השרת שלך, ע\"י שימוש בתוכנה או שיטה <u>חיצונית</u> ל-PhpGedView, למשל <i>ftp</i> או <i>קשר של תקשורת</i>. יתכן שהקובץ שאותו תרצה להוסיף הותר מתהליך <b>#pgv_lang[upload_gedcom]#</b> קודם.<br /><br />אם קובץ קלט GEDCOM עדיין לא נמצא על השרת, <u>עליך</u> לבצע את ההעלאה לשם, לפני שתוכל להתחיל עם ההוספה.<br /><br />במקום להעלות קובץ GEDCOM, ניתן גם כן להעלות קובץ ZIP שכולל את קובץ ה-GEDCOM, או ע\"י PhpGedView, או ע\"י שימוש בתוכנה חיצונית. PhpGedView יזהה בצורה אוטומטית את קובץ ה-ZIP ויוציא את קובץ ה-GEDCOM ושם הקובץ מקובץ ה-ZIP.<br /><br />אם קובץ GEDCOM בעל שם זהה כבר קיים ב-PhpGedView, הוא יידרס. אולם, כל ההגדרות הקודמות של ה-GEDCOM תשמרנה.<br /><br />תודרך דרך התהליך שלב אחרי שלב.<br /><br />";
$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />ניתן להקים מאגר נתוני חקר משפחה חדש ללא שימוש במאגר קיים.<br /><br />התהליך דורש רק מספר שלבים פשוטים. השלב הראשון שונה מתהליך העלאה והוספה. יתר השלבים יהיו מוכרים.<ol><li><b>מתן שם ל-GEDCOM החדש</b><br />הקלד את שם ה-GEDCOM החדש <u>ללא</u> סיומת <b>.ged</b>. הקובץ החדש יבנה בתיקיה כפי שצוין מעל לשדה הטכסט להוספת השם. לחץ על <b>הוסף</b>.</li><li><b>דף עיצוב התצורה</b><br />הדף הזה הוא דף מוכר לך; הנך מגדיר את התצורה של קובץ ה-GEDCOM.</li><li><b>אמת</b><br />הדף הזה מוכר לך; ה-GEDCOM החדש ניבדק. מכיוון והוא ריק, הוא יהיה תקין.</li><li><b> ייבוא רשומות</b><br />מכיוון שקיימת רק רשומה אחת לייבא, הפעולה מסתיימת מהר מאוד.</li></ol>זהו זה. עכשיו תוכל לעבור לתרשים אילן היוחסין כדי לראות את אדם המוצא ב-GEDCOM החדש. לחץ על השם והתחל בעריכה. אחר כך תוכל להוסיף אנשים נוספים לאדם המוצא.<br /><br />";
$pgv_lang["download_gedcom_help"]	= "~#pgv_lang[download_gedcom]#~<br /><br />את מאגר המידע של חקר המשפחה שלך במבנה תוכל להוריד בדף הזה קובץ GEDCOM. יתכן שתרצה לייבא את הנתונים לתוכנה אחרת של חקר משפחה, או שתרצה לחלוק את הנתונים עם אחרים .<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br /><#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]		= "~#pgv_lang[gedcom_adm_head]#~<br /><br />#pgv_lang[gedcom_adm_head]# הוא מרכז הבקרה של מאגרי הנתונים של חקר המשפחה שלך.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />בכותרת של טבלת <b>#pgv_lang[current_gedcoms]#</b>, תראה מלבן עם ארבעה קישורים.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul>בטבלה <b>#pgv_lang[current_gedcoms]#</b> רשום כל מאגר נתוני חקר המשפחה בנפרד, קיימות הברירות הבאות:<ul><li>ייבא GEDCOM</li><li>מחק GEDCOM</li><li>ערוך תצורת GEDCOM</li><li>ערוך פרטיות GEDCOM</li><li>קובצי לוג של החיפוש</li></ul>עריכת הפרטיות של ה-GEDCOM נמצאת כאן משום שלכל GEDCOM יש קובץ פרטיות משלו.<br /><br />כל שורה בטבלה זו אמורה להיות מובנת מעליה. ניתן לעצב את PhpGedView לרשום את כל החיפושים במאגר הנתונים. ניתן לבדוק את קובצי הלוג בעזרת קישורים שקיימים בדף הזה.<br />#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]	= "~עצב GEDCOM~<br /><br />לכל מאגר נתוני חקר המשפחה שמשמש את PhpGedView יש <b>קובץ תצורה</b> משלו.<br /><br />בטופס זה תגדיר מאפיינים רבים כגון כותרת מאגר הנתונים, שפה, מבנה לוח שנה, אפשרויות דואר אלקטרוני, שמירת חיפושים במאגר הנתונים, כותרות HTML META, הורדת שמות משפחה מרשימת שמות המשפחה השכיחים של מאגר הנתונים, וכו'.<br /><br />";
$pgv_lang["import_gedcom_help"]		= "~ייבא GEDCOM~<br /><br />ברוב המקרים ייבוא GEDCOM שנבנה מחוץ למערכת, הוא שלב בתהליך העדכונים הגדולים של מאגר נתוני חקר משפחה.<br /><br />השלבים מבוצעים בסדר לוגי ויש לסיים אותם כדי לעבוד עם מאגר הנתונים.<br /><br />אם לא סיימת את השלבים בסדר הנכון, תראה הודעת <u>התראה</u> שה-GEDCOM עדיין לא יובא. לחיצה על הקישור <b>ייבא GEDCOM</b> מייבאת (מחדש) את הקובץ ומתקנת את הבעיה.<br /><br />ייבוא מחדש אינו משנה את התצורה (הגדרות) של ה-GEDCOM. הנתונים החדשים דורסים את הישנים.<br /><br />";
$pgv_lang["upload_gedcom_help"]		= "~#pgv_lang[upload_gedcom]#~<br /><br />בשונה מהאפשרות <b>#pgv_lang[add_gedcom]#</b>, אין חובה שקובץ ה-GEDCOM שברצונך להוסיף למאגר המידע שלך ימצא על השרת שלך.<br /><br />בשלב 1 אתה בוחר קובץ GEDCOM מהמחשב המקומי שלך. הקלד את השביל המלא ואת שם הקובץ בתיבת הטכסט, או השתמש בכפתור <b>Browse</b> שעל הדף.<br /><br />בפונקציה זו ניתן גם להעלות קובץ ZIP שכולל את קובץ ה-GEDCOM. PhpGedView יזהה את קובץ ה-ZIP וישלוף ממנו את הקובץ ושם הקובץ בצורה אוטומטית.<br /><br />אם קובץ GEDCOM בעל שם זהה קיים כבר ב-PhpGedView, הוא יידרס, אחרי אישורך. אך כל ההגדרות הישנות תשמרנה.<br /><br />תמצא עזרה נוספת בדפים האחרים של התהליך.<br /><br />";
$pgv_lang["validate_gedcom_help"]		= "~אמת GEDCOM~<br /><br />זה השלב השלישי בתהליך ההוספה של נתוני GEDCOM, שנוצרו חיצונית, למאגר נתוני חקר המשפחה שלך.<br /><br />PhpGedView בודק את הקובץ לגבי שימוש נכון של מבנה תאריך, מבנה מקום, סוג האותיות וכו'. חלק מהסטיות מתקן 5.5.1 של GEDCOM, שהתוכנה עובדת לפיו, יתוקנו בצורה אוטומטית. דוגמאות הן סיומות שורה של מקינטוש ושימוש שגוי של מבנה מקום. במקרים הללו תראה הודעה שהתוכנית שינתה נתונים. עבור חריגות אחרות תקבל התראה עם פיתרון מוצע.<br /><br /><b>כלי רשות</b><br />כרגע קיים רק כלי נוסף אחד:<br /><b>שנה קוד זיהוי אישי ל-...</b>.<br />#pgv_lang[more_config_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]		= "~הסב ANSI ל-UTF-8~<br /><br />כדי להבטיח שהתוכנית מטפלת בקובצי ה-GEDCOM הקלט שלך בצורה נכונה, הקובצים צריכים להיות במבנה UTF-8.<br /><br />לחלק מתוכנות חקר שושלת היוחסין החדשות יותר יש יכולת לייצא קובצי GEDCOM במבנה UTF-8. לתוכניות ישנות יותר אין בדרך כלל את האפשרות הזו. אם לתוכנית שאתה משתמש אין אפשרות כזו, PhpGedView יכול להסב את הקובץ עבורך.<br /><br />כאשר PhpGedview מאמת את קובץ הקלט, הוא יגלה את מבנה הקובץ וייעץ לך בהתאם.<br /><br />";
$pgv_lang["detected_ansi2utf_help"]		= "~גילינו קוד ANSI~<br /><br />קובץ ה-GEDCOM שעובר בדיקות אימות כרגע נכתב בשיטת ANSI. מומלץ להסב את הקובץ לשיטת UTF-8.<br /><br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]		= "~התגלה מבנה תאריך שגוי:~<br /><br /><b>מבנה התאריך ישונה</b><br /><br />המבנה התקני של התאריכים ב-PhpGedview וגם לפי תקן GEDCOM 5.5.1 הוא: <b>DD&nbsp;MMM&nbsp;YYYY</b> לדוגמא <span dir=\"ltr\">(1&nbsp;JAN&nbsp;2004)</span><br /><br />אם תראה, לאחר שקובץ  ה-GEDCOM שלך אומת,  הודעה שהתגלה מבנה שגוי של תאריכים, PhpGedView יסב את התאריכים למבנה התקני.<br /><br />תוכל להחליט על מבנה של  \"<b>יום</b> לפני החודש\" (DD&nbsp;MMM&nbsp;YYYY), או \"<b>חודש</b> לפני היום\" (MMM&nbsp;DD&nbsp;YYYY).<br /><br />המלצתנו להשאיר את המבנה הראשון (יום לפני חודש).<br /><br />";
$pgv_lang["change_indi2id_help"]		= "~שנה קוד זיהוי אישי ל-....~<br /><br />הכלי הזה פותח עבור משתמשים שהתוכנה של חקר שושלת היוחסין שלהם משתמשת בקוד זיהוי של GEDCOM שונה עבור אנשים בכל פעם שה-GEDCOM מיוצא. למשל, בפעם הראשונה קוד הזיהוי של אדם מסוים יהיה I100 אבל בפעם הבאה כאשר ה-GEDCOM ייוצא, קוד הזיהוי של אותו אדם יהיה I234. הקודים המשתנים מקשים על ניהול PhpGedView משום שקוד הזיהוי הוא הקישור לאנשים.<br /><br />אולם, רוב תוכניות חקר שושלת היוחסין משתמשות גם בתו RIN או ב-REFN כדי להגדיר מזהה ייחודי שישמש לזיהוי האדם. הכלי הזה יחליף את קוד הזיהוי של כל האנשים בקובץ ה-GEDCOM בערך שיילקח משדה אחר לפי הגדרתך. תוכל לבחור את שדות ה-RIN או ה-REFN כמחליפים את קוד הזיהוי.<br /><br />";
$pgv_lang["edit_privacy_help"]		= "בדף הזה תוכל להגדיר את כל הגדרות הפרטיות עבור GEDCOM ניבחר.<br /><br />תוכל לבדוק מתחת לכותרת הדף שאתה עורך את קובץ הפרטיות הנכון. הוא מוצג בצורה הבאה: (path/nameofyourgedcom_priv.php)<br /><br />אם אתה צריך הגדרות נוספות, תוכל לבצע את השינויים ידנית בקובץ הפרטיות. תוכל לקרוא על כך באתר האינטרנט של PhpGedView.<br /><br />";
$pgv_lang["BOM_detected_help"]		= "~Byte Order Mark (BOM) detected~<br /><br />The GEDCOM file you are importing has a special 3-byte code at the beginning.  This special code is used by some programs to indicate that the file has been recorded in the UTF-8 character set.<br /><br />Although this special code is not really an error, PhpGedView will not work properly when the input file contains the code.  You should let PhpGedView remove the code.<br /><br />"; //@#@
$pgv_lang["invalid_header_help"]		= "~כותרת GEDCOM שגויה~<br /><br />קובץ GEDCOM חייב להתחיל עם <b>0&nbsp;HEAD</b> בשורה הראשונה. PhpGedView גילה שקובץ ה-GEDCOM שלך, שאותו אתה מייבא, לא מתחיל ב-<b>0&nbsp;HEAD</b>. אחרי שתלחץ על כפתור הניקוי, השורות לפני שורת ה-<b>0&nbsp;HEAD</b>הראשונה תמחקנה.<br /><br />משמעות השגיאה, בדרך כלל, שהתוכנית שיצרה את ה-GEDCOM שלך לא עבדה בצורה נכונה או שלא מדובר בקובץ GEDCOM. עליך לבדוק שהעלית את הקובץ הנכון, ושהוא מתחיל בשורת <b>0&nbsp;HEAD</b> ומסתיים בשורת <b>0&nbsp;TRLR</b>.<br /><br />";
$pgv_lang["macfile_detected_help"]		= "~קובץ מקינטוש התגלה~<br /><br />PhpGedView גילה שקובץ ה-GEDCOM שלך נוצר על מחשב Macintosh.<br /><br />קובצי Macintosh מסיימים שורה עם תו בקרה CR. CR הוא Ctrl+M.<br />קובצי Unix מסיימים את השורה עם תו בקרה LF. LF הוא Ctrl+J.<br />חלונות ו-DOS משתמשים ברצף של שני תווים, CR ואחריו LF.<br /><br />PhpGedView דורשת שכל הקובצים ישתמשו בסיומת Unix או DOS. כאשר תלחץ על כפתור ניקיון, סיומות השורה שלך יוסבו בהתאם.<br /><br />";
$pgv_lang["cleanup_places_help"]		= "~ניקוי מקומות~<br /><br />PhpGedView גילה מקומות עבור תגי GEDCOM שאמורים להופיע ללא מקומות.<br /><br />תוכניות רבות של שושלת עץ המשפחה, כמו Family Tree Maker, יוצרות קובצי GEDCOM כאלה. PhpGedView עובד עם קובצים כאלה, אבל מקומות שגויים יופיעו בהיררכית המקומות שלך.<br /><br />יתכן למשל שב-GEDCOM שלך קיימות הרשומות הבאות:<br />1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC תוכניתן<br /><br />לפי תקן GEDCOM 5.5.1 זה היה צריך להירשם בצורה הבאה<br />1 SSN 123-45-6789<br />1 OCCU תוכניתן<br /><br />אם תבחר <b>כן</b>, PhpGedView יגלה ויתקן בצורה אוטומטית את השגיאות הללו של מבנה הקובץ.<br /><br />";
$pgv_lang["empty_lines_detected_help"]	= "~שורות ריקות התגלו~<br /><br />PhpGedView גילה שורות ריקות בקובץ הקלט שלך. יתכן והשורות תגרומנה לבעיות וימחקו מהקובץ לפני שהוא ייובא.<br /><br />";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~עצב PhpGedView~<br /><br />בדף הזה עליך לעצב את הנתונים הכלליים של  PhpGedView כאשר אתה מריץ אותו בפעם הראשונה לאחר שהתקנת את PhpGedView.<br /><br />#pgv_lang[review_readme]# משום שהתצורה הזו היא  <b>כללית</b>, היא מוגדרת עבור כל התוכנית ועבור כל מאגרי המידע של חקר שושלת היוחסין שאתה משתמש בהם ב-PhpGedView.<br /><br />תוכל להגדיר תצורה שונה לנתונים אחרים עבור כל אחד ממאגרי הנתונים, אחרי שתלחץ על הקישור <b>#pgv_lang[admin_gedcoms]#</b> בדף הזה.<br /><br />תוכל גם לגשת לפונקציה #pgv_lang[gedcom_adm_head]# מדף הניהול הראשי שהקישור שלה נמצא מתחת לצלמית  #pgv_lang[mgv]# או בכותרת של רוב הדפים. הקישור הרלוונטי הוא <b>#pgv_lang[manage_gedcoms]# על דף האדמיניסטרציה.</b><br /><br />";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />דף זה מאפשר לך למזג שתי רשומות GEDCOM מאותו קובץ GEDCOM.<br /><br />דבר זה שימושי למי שמיזג קובצי GEDCOM ולאחר המיזוג יש לו מספר אנשים, משפחות ומקורות שהם זהים.<br /><br />הדף מורכב משלשה שלבים.<br /><ol><li>הכניס שני קודי זיהוי של נתוני GEDCOM. שני קודי הזיהוי <u>חייבים</u>להיות מאותו סוג. למשל, לא ניתן למזג אדם עם משפחה או משפחה עם מקור.<br />בשדה <b>#pgv_lang[merge_to]#</b> הכנס את קוד הזיהוי של הרשומה שתיווצר לאחר המיזוג.<br />בשדה <b>#pgv_lang[merge_from]#</b> הכנס את קוד הזיהוי של הרשומה שתמוזג לרשומת #pgv_lang[merge_to]#. הרשומה הזו תמחק לאחר המזוג.</li><li>בחר את העובדות משתי הרשומות שברצונך לשמור לאחר מיזוגן לרשומה אחת. סמן בתיבת הסימון המתאימה את העובדות שברצונך לשמור.</li><li>בדוק את תוצאות המיזוג, בדומה לכל השינויים שנעשים בצורה מכוונת.</li></ol>על מישהו עם הרשאות אישור לאשר את השינויים שלך כדי להפוך אותם לקבועים.</li></ul><br />";

//-- report engine
$pgv_lang["help_reportengine.php"]		= "~דו\"חות~<br /> לחיצה על הפריטים בתפריט הדו\"חות יוצרת דו\"חות PDF עבור הדפסה.<br /><br />השלב הראשון הוא בחירת הדו\"ח שרוצים להריץ. אחרי שתבחר דו\"ח להרצה, המערכת תבקש שתמסור מידע ספציפי לדו\"ח הזה, כגון מאיזה אדם או משפחה להתחיל והאם יש להציג תמונות. כאשר אתה מוכן להריץ את הדו\"ח, לחץ על כפתור <b>#pgv_lang[download_report]#</b> כדי להוריד את הדו\"ח למחשב שלך.<br /><br />#pgv_lang[help_xml_reports]#<br />#pgv_lang[def_pdf_format_help]#<br />#pgv_lang[help_ahnentafel.xml]#<br />#pgv_lang[help_birthlist.xml]#<br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]		= "~מבנה קובץ PDF~<br />מנוע הדיווח של PhpGedView יוצר דוח\"חות שניתנים להורדה במבנה  Adobe&reg; PDF. גם תקן ה-GEDCOM 5.5.1, שהוזכר בעזרה אחרת, ניתן להורדה כקובץ PDF. PDF הוא ראשי תיבות ל-<b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.<br /><br />לא ניתן לראות או להדפיס קובצי PDF על ידי תוכנה בסיסית על המחשב האישי שלך. אם יש לך כבר Acrobat Reader (הוא מסופק כתוכנה נלווית לתוכנות אחרות), אז אין צורך להחליף או לשדרג אותו כדי לטפל בקובצי הדו\"חות ש-PhpGedView יוצר.<br /><br />תוכנת הצגה והדפסה לקובצים הללו, ניתן לקבל בחינם מ-Adobe Systems Inc. ה-Adobe&reg; Acrobat Reader, שאינו עולה כסף, ניתנת להורדה מאתר האינטרנט של-<a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Adobe Systems Inc.</b></a>. ניתן למצוא עותקים של \"Acrobat Reader\" להורדה באתרי אינטרנט אחרים, אבל אנחנו ממליצים בחום לסמוך <u>רק</u> על האתר של Adobe Systems Inc.<br /><br />Acrobat Reader קיימת עבור מערכות הפעלה שונות, כולל מיקרוסופט/Microsoft&reg; חלונות/Windows ו-אפל/Apple&reg; מקינטוש/Macintosh. היא זמינה בשפות רבות בנוסף לאנגלית. אם לך יש מערכת חלונות/Windows 95, הורד את Acrobat Reader גרסה 5.0.5.  גרסאות חדשות יותר אינן ניתנות להתקנה נכונה על מערכות חלונות/Windows 95.<br /><br /><a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=_blank><b>הורד כאן את Adobe Reader</b></a><br /><br />";
$pgv_lang["help_ahnentafel.xml"]		= "~#pgv_lang[ahnentafel_report]#~<br />זהו דו\"ח של האדם הנבחר ואבותיו, מודפס במבנה ספרון. הוא מתחיל מהאדם הראשון וממשיך עם הוריו וסבים וסבתות שלו, וכו'.<br /><br />שים לב שדו\"ח ה-Ahnentafel קיים בינתיים רק באנגלית.<br /><br />";
$pgv_lang["help_birthlist.xml"]			= "~#pgv_lang[birth_report]#~<br />בעזרת דו\"ח הזה תוכל לרשום את כל האנשים שנולדו בזמן או במקום מסוים.<br /><br />";
$pgv_lang["help_relativelist.xml"]		= "~#pgv_lang[relatives_report]#~<br />הדו\"ח הזה רושם את כל הקרובים של האדם הנבחר. תוכל לבחור איזה קרובים של האדם להציג בדו\"ח.<ul><li><b>#pgv_lang[child-family]#</b> יציג את האדם הנבחר, הוריו, אחיו ואחיותיו.</li><li><b>#pgv_lang[spouse-family]#</b> יציג את האדם עם בני/בנות זוגו וילדיהם.</li><li><b>#pgv_lang[direct-ancestors]#</b> יציג את האדם, הוריו, סבים וסבתות, הורי סבים וסבתות, וכן הלאה במעלה העץ להורי האב אבות.</li><li><b>#pgv_lang[ancestors]#</b> יציג את כל האנשים מרשימת ה#pgv_lang[direct-ancestors]# וכולל גם כן דודים ודודות ודודים ודודות של ההורים, כך שהוא כולל את כל הצאצאים של אב אבותיו של האדם הזה. הוא אינו כולל את הילדים של האחים והאחיות (בני/בנות הדוד).</li><li><b>#pgv_lang[descendants]#</b> יציג את כל צאצאיו של האדם (ילדים, נכדים, נינים וכו').</li><li><b>#pgv_lang[all]#</b> הבחירה היא הצירוף של ה#pgv_lang[descendants]# וה#pgv_lang[ancestors]# בדו\"ח אחד.</li></ul><br /><br />";
$pgv_lang["help_xml_reports"]		 = "~מנוע דו\"חות~<br />מנוע הדו\"חות של PhpGedView משתמש בקובצי תבניות XML כדי ליצור בצורה אוטומטית דו\"חות PDF.<br /><br />הדו\"חות הזמינים ברשימת <b>#pgv_lang[select_report]#</b> נוצרים מקובצי XML של דו\"ות שנמצאים בתיקיית ה\"reports\". תוכל ליצור דו\"חות פרטיים ע\"י העתקה מהתבניות שסופקו וע\"י שינוי ה- XML של התבנית. כדי להוסיף את הדו\"ח הפרטי שלך למערכת, עליך לשים אותו בתיקיית \"reports\" וה-PhpGedView יבחין בו בצורה אוטומטית ויוסיף אותו לרשימה הנגללת <b>#pgv_lang[select_report]#</b>.<br /><br />";

//-- Help Contents
$pgv_lang["help_contents_head_help"]	= "<b>תוכן העזרה</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]	= "מידע מ-GEDCOM";
$pgv_lang["help_contents_gedcom_places"]	= "מקומות ב-GEDCOM";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"] = "<b>תוכן העזרה<br /><br />פרטי העזרה למנהלן</b> התווספו לתחילת הרשימה.<br /><br />";
$pgv_lang["ah2_help"]				= "_עצב PhpGedView";
$pgv_lang["ah3_help"]				= "_GEDCOM: הוסף לעומת העלה";
$pgv_lang["ah4_help"]				= "_GEDCOM: קובץ תצורה";
$pgv_lang["ah5_help"]				= "_GEDCOM: ברירת מחדל";
$pgv_lang["ah6_help"]				= "_GEDCOM: מחק";
$pgv_lang["ah7_help"]				= "_GEDCOM: הוסף";
$pgv_lang["ah8_help"]				= "_GEDCOM: בנה חדש";
$pgv_lang["ah9_help"]				= "_GEDCOM: הורד";
$pgv_lang["ah10_help"]			= "_GEDCOM: דף ניהול";
$pgv_lang["ah11_help"]			= "_GEDCOM: עצב";
$pgv_lang["ah12_help"]			= "_GEDCOM: ייבא";
$pgv_lang["ah13_help"]			= "_GEDCOM: העלה";
$pgv_lang["ah14_help"]			= "_GEDCOM: אמת";
$pgv_lang["ah15_help"]			= "_GEDCOM: הסב ANSI ל-UTF-8 - ליוניקוד";
$pgv_lang["ah16_help"]			= "_GEDCOM: הגדרת פרטיות";
$pgv_lang["ah17_help"]			= "_ניהול משתמשים";
$pgv_lang["ah18_help"]			= "_ניהול";
$pgv_lang["ah19_help"]			= "_GEDCOM: כלי מדיה";
$pgv_lang["ah20_help"]			= "_GEDCOM: שנה קוד זיהוי אישי ל-...";
$pgv_lang["ah21_help"]			= "_כלי מתרגם";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]			= "_עצב את השפות הנתמכות";
$pgv_lang["ah24_help"]			= "_הסבת נתוני משתמשים (SQL &lt;&lt;-- אינדקס)";
$pgv_lang["ah25_help"]			= "_גיבוי PhpGedView";
$pgv_lang["ah26_help"]			= "_רשימת FAQ: ערוך";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"] 		= "~תרשים סטטיסטי~<br /><br />זהו דף תוצאות המראה תרשים גרפי של הסטטיסטיקות ממאגר הנתונים שלך כפי שהם הוגדרו בקלט על דף הקודם.<br /><br />";
$pgv_lang["help_statistics.php"] 		= "~תרשים סטטיסטי~<br /><br />הדף הזה מאפשרת לך לקבוע קריטריונים להפקת מצגת גראפית עבור סטטיסטיקות שונות ממאגר הנתונים שלך.<br /><br />";
$pgv_lang["stat_help"]				= "~בחירות לתרשימים סטטיסטיים~<br /><br />ניתן ליצור מספר תרשימים סטטיסטיים ממאגר הנתונים שלך.<br /><br />בחר את התרשים ואח\"כ את הפרמטרים מתיבות נגללות.<br /><br />המספרים עבור התרשימים תלויים בנתונים קיימים. למשל, לא ניתן לכלול אנשים ללא חודש לידה (למשל רק '1856') בתרשים של לידות לפי חודש.<br /><br />";
$pgv_lang["stat_help_x"]			= "~בחירות לתרשימים סטאטיסטיים ~<br /><br />~ציר ה-X~<br />האופציות הבאות קיימות עבור ציר ה-X (האופקי). כל אחד יוצג לפי אופציות המוגדרות עבור צירי Y ו-Z.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;אנשים שנולדו בחודש מסויים.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;אנשים שנפטרו בחודש מסויים.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;נישואין שהתרחשו בחודש מסויים.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;מספר המשפחות בהן הילד הראשון נולד בחודש מסוים.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;מספר נישואין ראשונים לפי חודש.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;מספר חודשים מהנישואים ועד לידת התינוק הראשון של הזוג.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;גיל בפטירה ביחס לתקופת זמן ששנת הלידה נכללת בו.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;גיל בפטירה ביחס לתקופת זמן ששנת הפטירה נכללת בו.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;הגיל הממוצע של האנשים בזמן הנישואים.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;הגיל הממוצע של האנשים בזמן הנישואין הראשונים שלהם.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;גדלי משפחה ממוצעים.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;מיקום כל האנשים או האנשים עם שם מסויים, לפי הארץ.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;ארץ לידה.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp; ארץ נישואין.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;ארץ פטירה.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;תרשים עוגה של אנשים עם מקורות.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;תרשים עוגה של משפחות עם מקורות.</p><br /><br />";
$pgv_lang["stat_help_y"]			= "~בחירות לתרשימים סטטיסטיים ~<br /><br />~ציר ה-Y~<br />האופציות הבאות קיימות עבור ציר ה-y (ניצב). האופציות משנות את הדרך שהפריטים מוצגים על ציר ה-x.<p style=\"padding-left: 25px\"><b>מונה</b>&nbsp;&nbsp;מציג את מספר האנשים בכל סוג שמוגדר בציר ה-x.<br /><b>אחוז</b>&nbsp;&nbsp;מחשב ומציג את היחס של כל פריט בסוגי ציר ה-x.</p><br /><br />";
$pgv_lang["stat_help_z"]			= "~בחירות לתרשים סטטיסטי ~<br /><br />~ציר ה-Z~<br />האופציות הבאות קיימות עבור ציר ה-z. האופציות הללו מספקות תת-חלוקה של הסוגים שנבחרו עבור ציר ה-x.<p style=\"padding-left: 25px\"><b>כלום</b>&nbsp;&nbsp;מציג את הפריטים בעמודה יחידה לכל סוג של ציר ה-x.<br /><b>מין</b>&nbsp;&nbsp;מציג את הפריטים ב-2 עמודות (זכר ונקבה) עבור כל סוג של ציר ה-x.<br /><b>תקופות</b>&nbsp;&nbsp;מציג את הפריטים במספר עמודות לפי תקופות זמן אשר מוגדרות בחלק הבא עבור כל סוג של ציר ה-x.</p><br /><br />";
$pgv_lang["stat_help_gwx"]		= "~בחירות לתרשימים סטטיסטיים~<br /><br />~גבולות עבור ציר ה-X~<br />בחר את מרווח הגיל הרצוי.<br /><br />למשל, <b>#pgv_lang[aft_marr]#</b> מציין את תחומי החודשים הבאים:<div style=\"padding-left:30px;\">לפני הנשואין<br />מהנישואין עד ל-8 חודשים אחרי הנישואין<br />מ-8 עד 12<br />מ-12 עד 15<br />מ-15 עד 18<br />מ-18 עד 24<br />מ-24 עד 48<br />מעל 48 חודשים אחרי הנשואין</div><br /><br />כאשר ברצונך להציג רבעונים עליך לבחור: <b>רבעונים</b>.<br /><br />";
$pgv_lang["stat_help_gax"]		= "~בחירות לתרשימים סטטיסטיים~<br /><br />~גבולות עבור ציר ה-X~<br />בחר את מרווח הגיל הרצוי.<br /><br />למשל, <b>מרווח 10 שנים</b> מתאר את תחומי גיל הבאים:<div style=\"padding-left:30px;\">צעיר משנה<br />משנה עד 5 שנים<br />מ-6 עד 10<br />מ-11 עד 20<br />מ-21 עד 30<br />מ-31 עד 40<br />מ-41 עד 50<br />מ-51 עד 60<br />מ-61 עד 70<br />מ-71 עד 80<br />מ-81 עד 90<br />מ-91 עד 100<br />מעל 100 שנים</div><br /><br />";
$pgv_lang["stat_help_gbx"]		= "~בחירות לתרשימים סטטיסטיים~<br /><br />~גבולות עבור ציר ה-X~<br />בחר את מרווח הגיל הרצוי.<br /><br />למשל, <b>מרווח דו שנתי</b> מתאר את תחומי גיל הבאים:<div style=\"padding-left:30px;\">צעיר מ-16 שנה<br />מ-16 עד 18<br />מ-19 עד 20<br />מ-21 עד 22<br />מ-23 עד 24<br />מ-25 עד 26<br />מ-27 עד 28<br />מ-29 עד 30<br />מ-31 עד 32<br />מ-33 עד 35<br />מ-36 עד 40<br />מ-41 עד 50<br />מעל ל-50 שנה</div><br /><br />";
$pgv_lang["stat_help_gcx"]		= "~בחירות לתרשימים סטטיסטיים~<br /><br />~גבולות עבור ציר ה-X~<br />בחר את מרווח המנייה הרצוי.<br /><br />למשל, <b>מרווח ילד אחד</b> מתאר את תחומי מספר הילדים הבאים:<div style=\"padding-left:30px;\">ללא ילדים<br />ילד אחד<br />שני ילדים<br />3, 4, 5, 6, 7, 8, 9, 10 ילדים<br />יותר מ-10 ילדים</div><br /><br />";
$pgv_lang["stat_help_gwz"]		= "~בחירות לתרשימים סטטיסטיים~<br /><br />~גבולות עבור ציר ה-Z~<br />בחר את שנת ההתחלה והמרווח  הרצויים.<br /><br />למשל, <b>החל מ-1700 במרווח של 50 שנה</b> מתאר את תחומי התאריכים הבאים:<div style=\"padding-left:30px;\">לפני 1700<br />מ-1700 עד 1749<br />מ-1750 עד 1799<br />מ-1800 עד 1849<br />מ-1850 עד 1899<br />מ-1900 עד 1949<br />מ-1950 עד 1999<br />2000 או מאוחר יותר</div><br /><br />";
$pgv_lang["chart_type_help"]	= "~בחירות לתרשימים סטטיסטיים~<br /><br />בחר מה שתרצה לראות על תרשים המפה. תוכל לבחור:<p style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;מראה את הארצות שבהן מופיעים אנשי מאגר הנתונים הזה.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;מראה את הארצות בהם מופיעים אנשי מאגר הנתונים בעלי שם ספציפי.</p><br /><br />";
$pgv_lang["google_chart_surname_help"]	= "~בחירות לתרשימים סטטיסטיים ~<br /><br />על המפה מציגים מספר מופעים של השם המצויין. אם תשאיר שדה זה ריק, משתמשים באנשים עם השמות השכיחים ביותר.<br /><br />";
$pgv_lang["chart_area_help"]	= "~בחירות לתרשימים סטטיסטיים~<br /><br />בחר את האזור הגיאוגרפי שתרצה לראות על המפה. תוכל לבחור:<p style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;מציג את כל היבשות.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;מציג אירופה.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;מציג דרום אמריקה.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;מציג אסיה.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;מציג מזרח התיכון.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;מציג אפריקה.</p><br /><br />";

//-- Find Media Help
$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br /><br />על הדף הזה ניתן לנהל את קובצי ותיקיות המדיה שלך.<br /><br />כאשר אתה יוצר תת-תיקיות חדשות, PhpGedView מבטיח שמבנה תיקיות זהה יהיה קיים בתיקיית <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b>.  כאשר אתה מעלה קובצי מדיה חדשים, PhpGedView יכול ליצור עבורך אוטומטית קובץ מזערי.<br /><br />ליד כל אימז' ברשימת המדיה שלך תימצא את האופציות הבאות.  האופציות שתראה תלויות בסטאטוס הנוכחי של קובץ המדיה.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;כאשר תלחץ על האופציה הזו, תראה דף שבו תוכל לשנות את הכותרת של המדיה.  אם המדיה עדיין לא קשורה לאדם, משפחה או מקור במאגר הנתונים הפעיל עכשיו, תוכל לבצע כאן את הקישור.  תוכל לשנות את שם הקובץ, או אפילו לשנות את מיקומו בתוך מבנה התיקיות של <span dir=\"ltr\"><b>#GLOBALS[MEDIA_DIRECTORY]#</b></span>.  לפי הצורך, PhpGedView יוצר בצורה אוטומטית את תתי-התיקיות הדרושות או התמונות המזעריות ההסרות.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;האופציה זמינה רק אם המנהלן איפשר אותה.  תוכל לראות או לעדכן נתוני GEDCOM גולמיים הקשורים למדיה.  צריך להיות זהיר מאוד כאשר משתמשים באופציה.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;האופציה מאפשרת מחיקת כל המידע של קובץ מדיה ממאגר נתונים. יתר המאגרים אינם מושפעים.  אם קובץ המדיה הזה אינו מוזכר בשום מאגר נתונים אחר, הוא והתמונה המזערית הקשורה ימחקו</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp; האופציה מאפשרת מחיקת כל המידע של קובץ מדיה ממאגר נתונים. יתר המאגרים אינם מושפעים.  קובץ המדיה אינו נימחק, וישות המדיה שלפיו הקובץ מוכר במאגר הנתונים הנוכחי ישמר.  מאגרים אחרים אינם מושפעים.  קובץ המדיה והקובץ המזערי הקשור אליו, לא ימחקו.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;האופציה מאפשרת הסרת כל הקישורים לישות מדיה ממאגר הנתונים הנוכחי.  הקובץ לא נימחק וישות המדיה שלפיו הקובץ מוכר במאגר הנתונים הנוכחי ישמר.  מאגרי נתונים אחרים אינם מושפעים.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;האופציה מאפשרת ליצור קישור בין קובץ המדיה ואנשים, משפחות או מקורות במאגר הנתונים הנוכחי.  לפי הצורך, PhpGedView יוצר גם כן את ישות המדיה שלפיו קובץ המדיה מוכר במאגר הנתונים.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;כאשר תבחר באופציה זו, PhpGedView יוצר את התמונה המזערית החסרה.</li></ul><br /><br />";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />מסנן חיפוש פשוט המבוסס על הנתונים שהוקשו, ג'וקרים אינם מתקבלים.<br /><br />";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />תמונות מזעריות יוצגו אם תסמן תיבה זו.<br /><br />";
$pgv_lang["new_dir_help"]			= "~#pgv_lang[add_directory]#~<br /><br />כמשתמש אדמיניסטראטור תוכל ליצור מבנה תיקיות לפי הצורך, כדי לשמור את קובצי המדיה בצורה מסודרת. יצירת תיקיות בדף הזה מבטיחה שהתיקיות של התמונות המזעריות נוצרות עבור כל תיקייה וש-index.php מתאים נוצר בכל תיקייה.<br /><br />לחץ על הקישור כדי להכניס את שם התיקייה שתרצה ליצור.<br /><br />";
$pgv_lang["find_media_help"]			= "~#pgv_lang[find_media]#~<br /><br />אופציה זו מאפשרת חיפוש במערכת הקובצים כדי למצוא את המדיה שאליה תרצה קישור.<br /><br />";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]		= "~קוד זיהוי של קישור~<br /><br />יש לשייך כל מדיה לאדם, משפחה או מקור אחד או יותר במאגר הנתונים שלך.<br /><br />כדי ליצור קישור כזה, ניתן להכניס או לחפש את קוד הזיהוי של האדם, המשפחה או המקור בו זמנית עם יצירת המדיה.  תוכל גם ליצור את הקישור מאוחר יותר ע\"י שימוש באופציית העריכה בדף נהל מולטימדיה או ע\"י הוספת מדיה דרך הקישור הוסף מדיה שקיימת בדפי הפירוט של אנשים, משפחות או מקורות.<br /><br />";
$pgv_lang["upload_server_file_help"]		= "~#pgv_lang[server_file]#~<br /><br />ניתן, וכנראה רצוי, ששם הקובץ שאותו אתה מעלה יהיה בעל שם שונה על השרת מאשר על המחשב המקומי שלך. הסיבה היא שלשם המקומי יש משמעות לך אבל הוא הרבה פחות משמעותי לאחרים שמבקרים באתר. יש גם לקחת בחשבון את האפשרות שאתה ומישהו אחר מנסים להעלות קובצים שונים הנקראים \"granny.jpg\".<br /><br />בשדה זה תציין את השם החדש של הקובץ שאתה מעלה. השם שאתה מכניס כאן ישמש גם כשם של הקובץ המזערי, שאותו ניתן להעלות בנפרד או ליצור בצורה אוטומטית.  אין צורך למלא את סיומת שם הקובץ (jpg, gif, pdf, doc, וכו'.)<br /><br />השאר שדה זה ריק כדי לשמור על השם המקורי של הקובץ שלך שאותו אתה מעלה מהמחשב המקומי שלך.<br /><br />";
$pgv_lang["upload_server_folder_help"] 	= "~#pgv_lang[server_folder]#~<br /><br />המנהלן אפשר עד #GLOBALS[MEDIA_DIRECTORY_LEVELS]# רמות של תיקיות מתחת לברירת המחדל <b><span dir=\"ltr\">#GLOBALS[MEDIA_DIRECTORY]#</span></b>. דבר זה עוזר בארגון קובצי המדיה ומקטין את האפשרות להתנגשות בשמות.<br /><br />בשדה זה תציין את תיקיית היעד שבה יש לאחסן את קובץ המדיה. הקובץ המזערי התואם, שיועלה בנפרד או שייווצר אוטומטית, יאוחסן במבנה תיקיות דומה המתחיל ב-<b><span dir=\"ltr\">#GLOBALS[MEDIA_DIRECTORY]#thumbs/</span></b> במקום ב-<b><span dir=\"ltr\">#GLOBALS[MEDIA_DIRECTORY]#</span></b>. אין צורך להכניס את חלק ה-<b><span dir=\"ltr\">#GLOBALS[MEDIA_DIRECTORY]#</span></b> של שם תיקיית היעד.<br /><br />אם אינך בטוח מה להכניס כאן, עליך להתקשר עם מנהלן האתר שלך כדי לקבל סיוע.<br /><br />";
$pgv_lang["view_server_folder_help"] 	= "~#pgv_lang[server_folder]#~<br /><br />המנהלן איפשר עד #GLOBALS[MEDIA_DIRECTORY_LEVELS]# רמות של תיקיות מתחת לברירת המחדל <b><span dir=\"ltr\">#GLOBALS[MEDIA_DIRECTORY]#</span></b>.  דבר זה עוזר בארגון קובצי המדיה ומקטין אפשרות של התנגשויות אפשריות של שמות.<br /><br />בשדה זה תבחר את תיקיית המדיה שאת התוכן שלו תרצה לראות.  אם תבחר <b>#pgv_lang[all]#</b>, יוצגו כל קובצי המדיה ללא התייחסות לתיקייה שבה הן מאוחסנים.  יתכן ודבר זה ייצור רשימה ארוכה מאוד של עצמי מדיה.<br /><br />";

//--Repository Help
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />בדף הזה מוצגת רשימת מאגרים.<br /><br />שמות המאגרים ממוינים בסדר אלף בית.<br /><br /><b>מאגרים</b><br />לא ניתן לבנות את מאגר המידע שלנו ללא מאגרים. משום שלכל המידע השמור במאגר הנתונים יש מקור, והמקור הזה שמור בתוך מאגר. המאגר יכול להיות ארכיון פרטי של אדם, מוסד, מאגר נתונים ציבורי, משרד רישום של ממשלה או כנסיה, אמצעי אינטרנטי וכו'. כדי לקבל גישה למקור עלינו לדעת היכן הוא נמצא. כל המידע הדרוש כדי להשיג מקור הייה צריך להימצא ברשומת המאגר.<br /><br />ניתן לקשר מאגר מקורות רבים.<br /><br />";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#ר~<br /><br /> פרטי המאגר מוצגים על הדף הזה. בצרוף המקור. המאגרים חשובים מאוד לחוקר המשפחה. נתוני מקור ומאגרים מדויקים מאפשרים להתקדם לפי השביל שחוקר אחר עבר כאשר מצא את הנתונים. אתה צריך להיות מסוגל למצוא את אותם הנתונים שנית.<br /><br />על הדף הזה תוכל לראות מידע על כותרת, כתובת, דואר אלקטרונית וכתובת האינטרנט של המאגר.<br /><br />אחרי פרוט המאגר תמצא רשימת כל המקורות הקשורים למאגר הזה. דבר זה מאפשר לך לראות את כל המידע שהושג ממאגר מסוים.<br /><br />אם מנהלן האתר אפשר, תראה על הדף צלמית או שתיים של תפריטים:<br /><b>#pgv_lang[view_gedcom]#</b>,  מראה את המידע במבנה של GEDCOM.<br /><b>#pgv_lang[add_to_cart]#</b>, מאפשר לך לשמור מידע זה ב#pgv_lang[clip_cart]# שלך. משם תוכל להוריד את המידע במבנה קובץ GEDCOM ולייבא אותו לתוכנת חקר המשפחה שלך.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_repo_help"]		= "~#pgv_lang[delete_repo]#~<br /><br />לחיצה על אופציה זו תסמן את המאגר למחיקה מה-GEDCOM.<br /><br />מה זה אומר?<br />נניח שיש לך סיבה טובה למחוק את המאגר. אתה לוחץ על הקישור, ותתבקש לאשר את המחיקה. אם תמשיך להוריד את המאגר, יתכן שייקח קצת זמן עד שתקבל חלון צץ עם הודעה שהמאגר נמחק.<br /><br />כאשר תמשיך את ביקורך, תשים לב שהמאגר עדיין נראה וניתן אפילו לשימוש כמו מקודם כאילו שלא נימחק.<br /><br />זו <b>אינה</b> שגיאה. מנהלן האתר יקבל הודעה שנעשה שינוי למאגר הנתונים, ושמחקת את המאגר.<br />המנהלן יקבל (או ידחה) את השינוי שלך. רק אחרי שהמנהלן אישר את השינוי שלך המחיקה תתבצע בצורה <u>בלתי הפיכה</u>.<br />המנהלן יתקשר איתך אם יהיו לו ספקות לגבי השינוי שלך.<br /><br />";
$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />לחיצה על הקישור מציגה בחלון צץ את הנתונים על המאגר, כפי שהם שמורים התוך ה-GEDCOM.<br /><br />";
$pgv_lang["add_repository_clip_help"]	= "~#pgv_lang[add_to_cart]#~<br /><br /> כאשר תלחץ על קישור זה תוכל להוסיף את המאגר, כפי שהוא מופיע ב-GEDCOM, ל#pgv_lang[clip_cart]# שלך.<br /><br />";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />בתיבה הזו תראה שמות המאגרים, כפי שהם שמורים במאגר הנתונים.<br /><br />השמות מוצגים בסדר אלף בית.<br /><br />כאשר תלחץ על שם ברשימה, תועבר לדף #pgv_lang[repo_info]# שבו מוצגת רשימת המקורות הקשורים למאגר.<br /><br />";
$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />בתיבה הזו תראה את שמות המקורות הקשורים למאגר.<br /><br />השמות מוצגות בסדר אלפביתי.<br /><br />כאשר תלחץ על שם בתוך הרשימה, תעבור לדף המפורט של המקור.<br /><br />";

// Index-Edit
$pgv_lang["block_move_up_help"]		= "~העבר כניסות~<br /><br />השתמש בכפתורים הללו כדי לשנות את הסדר של הכניסות ברשימה. האזורים יודפסו בסדר כפי שהם רשומים.<br /><br />הדגש את הכניסה שברצונך להעביר, לחץ אחר כך בכפתור כדי להעביר את הכניסה למעלה או למטה.<br /><br />";
$pgv_lang["block_move_right_help"]		= "~העבר כניסות~<br /><br />השתמש בכפתורים הללו כדי להעביר כניסות מרשימה לאחרת.<br /><br />הדגש את הכניסה שברצונך להעביר, ולחץ אחר כך על הכפתור כדי להעביר את הכניסה לכיוון החץ. השתמש בכפתורי <b>&raquo;</b> ו-<b>&laquo;</b> כדי להעביר את הכניסה המודגשת מהרשימה השמאלית לימנית או להפך. השתמש בכפתורי <b>&gt;</b> ו-<b>&lt;</b> כדי להעביר את הכניסה המודגשת בין הרשימה ה#pgv_lang[available_blocks]# והרשימה משמאלו או מימינו.<br /><br />הכניסות ברשימת #pgv_lang[available_blocks]# אינן משתנות בעקבות מה שעושים בכפתורי #pgv_lang[move_right]# ו#pgv_lang[move_left]#. הסיבה לכך היא שאותו אזור יכול להופיע מספר פעמים על הדף. אזור ה-HTML הוא דוגמה טובה לסיבה למה אולי תרצה לבצע זאת.<br /><br />";
$pgv_lang["block_default_index"]		= "~אזורי ברירת מחדל על דף #pgv_lang[welcome]#~<br /><br />כאשר תסיר את כל הכניסות מרשימות pgv_lang[main_section]# ו#pgv_lang[right_section]#, או אם תלחץ על כפתור ה<b>#pgv_lang[reset_default_blocks]#</b>, רשימת האזורים מוגדרת בצורה הבאה:<br /><br /><center><table border=\"1\"></tr><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["block_default_portal"]		= "~אזורי ברירת מחדל על דף #pgv_lang[mygedview]#~<br /><br />כאשר תסיר את כל הכניסות מרשימות #pgv_lang[main_section]# ו#pgv_lang[right_section]#, או אם תלחץ על כפתור ה<b>#pgv_lang[reset_default_blocks]#</b>, רשימת האזורים מוגדרת בצורה הבאה:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";

// accesskey help
$pgv_lang["accesskey_viewing_advice_help"]	= "~#pgv_lang[accesskeys]#~<br />קיצורי לוח המקשים נועדים לעזור למשתמשים שיש להם קשיים עם אמצעי הצבעה כגון עכבר. השימוש בקיצורים שונה בהתאם לדפדפן שלך:<ul><li><span dir=\"ltr\">Internet&nbsp;Explorer&nbsp;5+</span>: לחץ על מקש ALT כאשר אתה מקליד על הסימן/אות הרצוי, ואח\"כ הקש ENTER.</li><li><span dir=\"ltr\">Firefox&nbsp;2+</span>: לחץ על מקש SHIFT ו-ALT כאשר אתה מקליד על הסימן/אות הרצוי. אין ללחוץ ENTER לסיום.</li><li><span dir=\"ltr\">Firefox 1, 1.5</span> ו-<span dir=\"ltr\">Netscape&nbsp;6+</span>: לחץ על מקש ALT כאשר אתה מקליד על הסימן/אות הרצוי. אין ללחוץ ENTER לסיום.</li><li>Opera: לחץ על מקשי SHIFT ו-ESC כאשר אתה מקליד על הסימן/אות הרצוי. אין ללחוץ ENTER לסיום.</li><li><span dir=\"ltr\">Internet&nbsp;Explorer&nbsp;5+</span> עבור <span dir=\"ltr\">Mac&nbsp;/&nbsp;Safari&nbsp;1.2+</span>: לחץ על מקש CTRL כאשר אתה מקליד על הסימן/אות הרצוי. אין ללחוץ ENTER לסיום.</li></ul><br />קיימים הקיצורים הבאים: <ul><li>כל הדפים <ul><li><b>אפס</b> - מידע על קיצורי לוח המקשים</li><li><b>אחד</b> - #pgv_lang[welcome_page]#</li><li><b>#pgv_lang[accesskey_help_content]#</b> - #pgv_lang[help_contents]#</li><li><b>#pgv_lang[accesskey_help_current_page]#</b> - #pgv_lang[help_for_this_page]#</li><li><b>#pgv_lang[accesskey_contact]#</b> - קשר </li><li><b>#pgv_lang[accesskey_skip_to_content]#</b> - עבור לתוכן</li><li><b>#pgv_lang[accesskey_search]#</b> - #pgv_lang[search]# </li></ul></li><li>דף אישי<ul><li><b>#pgv_lang[accesskey_individual_details]#</b> - הצג חוצץ #pgv_lang[personal_facts]# </li><li><b>#pgv_lang[accesskey_individual_notes]#</b> - הצג חוצץ #pgv_lang[notes]# </li><li><b>#pgv_lang[accesskey_individual_sources]#</b> - הצג חוצץ #pgv_lang[ssourcess]# </li><li><b>#pgv_lang[accesskey_individual_media]#</b> - הצג חוצץ #pgv_lang[media]# </li><li><b>#pgv_lang[accesskey_individual_relatives]#</b> - הצג חוצץ #pgv_lang[relatives]# </li><li><b>#pgv_lang[accesskey_individual_research_log]#</b> - הצג חוצץ #pgv_lang[research_assistant]# </li><li><b>#pgv_lang[accesskey_individual_pedigree]#</b> - הצג תרשים  #pgv_lang[pedigree_chart]# אישי</li><li><b>#pgv_lang[accesskey_individual_descendancy]#</b> - הצג  #pgv_lang[descend_chart]# אישי</li><li><b>#pgv_lang[accesskey_individual_timeline]#</b> - הצג  #pgv_lang[timeline_chart]# אישי</li><li><b>#pgv_lang[accesskey_individual_relation_to_me]#</b> - הצג תרשים #pgv_lang[relationship_to_me]#  אישי</li><li><b>#pgv_lang[accesskey_individual_gedcom]#</b> - #pgv_lang[view_gedcom]#</li></ul></li><li>דפי משפחה <ul><li><b>#pgv_lang[accesskey_family_parents_timeline]#</b> - #pgv_lang[parents_timeline]#</li><li><b>#pgv_lang[accesskey_family_children_timeline]#</b> - #pgv_lang[children_timeline]#</li><li><b>#pgv_lang[accesskey_family_timeline]#</b> - #pgv_lang[family_timeline]#</li><li><b>#pgv_lang[accesskey_family_gedcom]#</b> - #pgv_lang[view_gedcom]#</li></ul></li></ul><br />";

// FAQ page
$pgv_lang["help_faq.php"] 			= "~שאלות נפוצות~<br />#pgv_lang[text_faq_help]#<br />";
$pgv_lang["text_faq_help"] 			= "דף השאלות הנפוצות (FAQ - Frequently Asked Questions) יכול לכלול סקירה כללית או רשימת שאלות ותשובות על השימוש באתר חקר שושלת היוחסין הזה.<br /><br />מנהלן האתר יחליט מה השימוש של דף ה-FAQ. מנהלן האתר שולט בתוכן כל ישות וגם בסדר ההופעה של הישויות על הדף.";

// Help search
$pgv_lang["hs_title_help"] 			= "<center>~#pgv_lang[hs_title]#~</center><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "ניתן לחפש במערכת העזרה של PhpGedView. מאפיין #pgv_lang[hs_title]# נותן לך שליטה גבוהה על תפקוד החיפוש; מציאת מה שאתה מחפש אמורה להיות קלה.";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br />הכנס את המילים או הביטויים שברצונך למצוא.<br /><br />החיפוש אינו מבדיל בין אותיות לועזיות קטנות או גדולות של הביטוי או הטכסט שאותו בודקים  כלומר, אם מחפשים <b>Individual</b>, מוציאים טכסטים שכוללים <b>Individual</b>, <b>individual</b>, או <b>INDIVIDUAL</b>.  מוצאים גם טכסטים הכוללים <b>individuals</b>, וכו'. מכיוון שהחיפוש מחפש רצף אותיות ולא מילים.<br /><br />ניתן לחפש מספר מילים בבת אחת.  הכנס את כל המילים מופרדות ע\"י רווח, בצורה הבאה: <b>אדם&nbsp;משפחה&nbsp;ילד</b>.  כאשר מכניסים יותר ממילה אחת, משמעות ההקשה מובהרת בשדה #pgv_lang[hs_searchhow]#.<br />";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br />כאן מגדירים את היקף החיפוש.<br /><br />מנהלנים יכולים לחפש בתוך העזרה למשתמשים ובתוך העזרה בהגדרות התצורה או בשניהם.  למשתמשים הברירה הזו אינה קיימת; מכיוון שאין להם גישה למאפייני הגדרות, הם יכולים לחפש רק בקובץ העזרה של המשתמשים.<br /><br />קובץ העזרה כולל בנוסף לטכסטי עזרה גם מחרוזות שמשמשות בבניית טופסי קלט וחומר אחר.  הברירה מאפשרת שליטה אם יש לבדוק את כל קובץ העזרה או רק את טכסטי העזרה.<br />";
$pgv_lang["hs_searchhow_advice"]		= "~#pgv_lang[hs_searchhow]#~<br />ניתן לבחור את מה שהוכנס לשדה  #pgv_lang[hs_keyword]# ע\"י בחירה מהאפשרויות הבאות.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>אם הכנסת <b>אדם&nbsp;משפחה&nbsp;ילד</b>, האופציה תחזיר טכסט עזרה שכולל מילה אחת מהרשימה. לסדר המילים אין השפעה.  משמעות החיפוש הינה: \"מצא טכסט עזרה שכולל <b>אדם</b> <u>או</u> <b>משפחה</b> <u>או</u> <b>ילד</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>אם הכנסת <b>אדם&nbsp;משפחה&nbsp;ילד</b>, האופציה תחזיר טכסט עזרה שכולל את כל המילים הרשומות.  לסדר המילים אין השפעה.  משמעות החיפוש הינה: \"מצא טכסט עזרה שכולל <b>אדם</b> <u>וגם</u> <b>משפחה</b> <u>וגם</u> <b>ילד</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>אם הכנסת <b>אדם&nbsp;משפחה&nbsp;ילד</b>, האופציה תחזיר טכסט עזרה שכולל את כל המילים הרשומות בסדר הרשום.  משמעות החיפוש הינה: \"מצא טכסט עזרה שכולל את המילים  <b>אדם&nbsp;משפחה&nbsp;ילד</b> בסדר זה ללא מילים או סימנים נוספים ביניהם\".  יש להניח שלא תימצא את הביטוי הזה בשום טכסט עזרה.<br /><br />ישנם מספר מגבלות בחיפוש כזה.  סימנים מיוחדים כגון <b>&quot; &lt; &gt;</b> וכו' הם חלק מטכסט העזרה בצורה סימבולית ולא כלולים בחלק הטופס שבו מכניסים את טכסט החיפוש. חלק מטכסטי העזרה כוללים רווח מיוחד שרשום כ<b><span dir=\"ltr\">&amp;nbsp;</span></b> ולא תימצא ביטויים הכוללים סימן זה.</dd></dl>";

?>
