<?php
/**
 * Hebrew Language Help-file
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Meliza Amity
 * @version $Id: lang.he.php 6618 2009-12-24 17:58:56Z meliza $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["gedcomid"]			= "קוד זיהוי של אדם ב-GEDCOM";
$pgv_lang["sortby"]				= "סדר";
$pgv_lang["exact"]				= "בדיוק";
$pgv_lang["begins_with"]			= "מתחיל ב-";
$pgv_lang["contains"]				= "כולל";
$pgv_lang["sounds_like"]			= "נשמע כמו";
$pgv_lang["advanced_search"] 		= "חיפוש מתקדם";
$pgv_lang["more_fields"]			= "הוסף עוד שדות";
$pgv_lang["install_step_8"] 			= "התחל";
$pgv_lang["parent_family"]			= "משפחה של הורים";
$pgv_lang["step_parent_family"]		= "משפחה של הורה חורג";
$pgv_lang["immediate_family"]		= "משפחה מידית";

$pgv_lang["load_full_tree"]			= "הצג עץ זה כעץ אינטראקטיבי על דף שלם";
$pgv_lang["hide_show_spouses"]		= "הראה או החבא ריבוי בני זוג";
$pgv_lang["interactive_tree"]			= "עץ אינטראקטיבי";
$pgv_lang["example"]				= "דוגמא:";
$pgv_lang["tree"]				= "עץ";
$pgv_lang["ellipsis"]				= "\xE2\x80\xA6";
$pgv_lang["showUnknown"]			= "הראה מין לא ידוע";
$pgv_lang["count"]				= "ספירה";
$pgv_lang["age_differences"]			= "הראה הפרשי תאריכים";
$pgv_lang["multi_site_search"] 		= "חיפוש רב אתרים";
$pgv_lang["switch_lifespan"]			= "הראה תרשים תוחלת חיים";
$pgv_lang["switch_timeline"]			= "הראה תרשים קו הזמן";
$pgv_lang["differences"]			= "הפרשים";
$pgv_lang["charts_block"]			= "אזור תרשימים";
$pgv_lang["charts_block_descr"]		= "אזור התרשימים מאפשר לשים תרשים על הדף ברוכים הבאים או על הפורטל MyGedView.  ניתן לקנפג את האזור כך שיראה אב-אבות, צאצאים או שעון חול.  אפשר גם לבחור את אדם המוצא של התרשים.";
$pgv_lang["charts_click_box"]			= "לחץ על התיבה כדי לקבל נתונים נוספים על האדם.";
$pgv_lang["chart_type"]			= "סוג תרשים";
$pgv_lang["changedate1"]			= "סוף התחום של תאריכי שינוי";
$pgv_lang["changedate2"]			= "תחילת התחום של תאריכי שינוי";
$pgv_lang["search_place_word"]		= "מילים שלמות בלבד";
$pgv_lang["invalid_search_input"] 		= "הכנס בבקשה שם פרטי, שם משפחה או מקום בנוסף לשנה";
$pgv_lang["duplicate_username"]		= "קוד משתמש כפול. משתמש עם קוד זה מוגדר כבר. נא בחר קוד משתמש אחר.";
$pgv_lang["cache_life"]			= "חיי קובץ ה-Cache";
$pgv_lang["genealogy"]			= "חקר שושלות יוחסין";
$pgv_lang["activate"]				= "הפעל";
$pgv_lang["deactivate"]			= "נטרל";
$pgv_lang["play"]				= "הפעל";
$pgv_lang["stop"]				= "עצור";
$pgv_lang["random_media_start_slide"]	= "התחל מצגת שקופיות כאשר הדף נטען?";
$pgv_lang["random_media_ajax_controls"]	= "הראה כפתורי בקרה של מצגת שקופיות?";
$pgv_lang["description"]			= "תאור";
$pgv_lang["current_dir"]			= "התיקייה הנוכחית";
$pgv_lang["SHOW_ID_NUMBERS"]		= "הראה קודי זיהוי ליד שמות";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "הראה תמונות מודגשות בתיבות של אנשים";
$pgv_lang["view_img_details"]		= "הצג פירטי האימג'";
$pgv_lang["server_folder"]			= "שם התיקייה על השרת";
$pgv_lang["medialist_recursive"]		= "הצג קבצים בתיקיות משנה";
$pgv_lang["media_options"]			= "אופציות מדיה";
$pgv_lang["confirm_password"]		= "עליך לאשר את הסיסמא.";
$pgv_lang["enter_email"]			= "עליך להכניס כתובת דואר אלקטרוני.";
$pgv_lang["enter_fullname"] 			= "עליך למלא שם פרטי ושם משפחה.";
$pgv_lang["name"]				= "שם";
$pgv_lang["names"]				= "שמות";
$pgv_lang["children"]				= "ילדים";
$pgv_lang["lchildren"]				= "ילדים";
$pgv_lang["child"]				= "ילד/ה";
$pgv_lang["grandchildren"]			= "נכדים";
$pgv_lang["family"]				= "משפחה";
$pgv_lang["as_child"]				= "משפחה עם הורים";
$pgv_lang["shared_note_menu"]		= "בחירות עבור הערה משותפת";
$pgv_lang["source_menu"]			= "בחירות עבור מקור";
$pgv_lang["repo_menu"]			= "בחירות עבור מאגר";
$pgv_lang["other_records"]			= "הנתונים הקשורים למקור זה:";
$pgv_lang["other_repo_records"]		= "רשומות קשורות למאגר זה:";
$pgv_lang["repo_info"]			= "נתוני מאגר";
$pgv_lang["enter_terms"]			= "הכנס תנאי חיפוש";
$pgv_lang["search_asso_label"]		= "שותפים";
$pgv_lang["search_asso_text"]		= "הראה אנשים/משפחות קשורים";
$pgv_lang["search_DM"]			= "דאיטש-מוקוטוף";
$pgv_lang["search_fams"]			= "משפחות";
$pgv_lang["search_gedcom"]			= "חפש מאגרי נתונים";
$pgv_lang["search_geds"]			= "מאגרי נתונים בהם יש לחפש";
$pgv_lang["search_indis"]			= "אנשים";
$pgv_lang["search_notes"]			= "הערות משותפות";
$pgv_lang["search_inrecs"]			= "חפש";
$pgv_lang["search_prtall"]			= "כל השמות";
$pgv_lang["search_prthit"]			= "שמות שנמצאו";
$pgv_lang["results_per_page"]		= "ישויות מדיה לדף";
$pgv_lang["firstname_search"]		= "פרטי";
$pgv_lang["search_prtnames"]		= "שמות אנשים<br />להדפסה:";
$pgv_lang["other_searches"]			= "חיפושים אחרים";
$pgv_lang["add_to_cart"]			= "הוסף לעגלת גזירים";
$pgv_lang["view_gedcom"]			= "הצג מידע מ-GEDCOM";
$pgv_lang["welcome"]				= "ברוך הבא";
$pgv_lang["son"]				= "בן";
$pgv_lang["daughter"]				= "בת";
$pgv_lang["welcome_page"]			= "דף ברוכים הבאים";
$pgv_lang["editowndata"]			= "המשתמש שלי";
$pgv_lang["user_admin"]			= "ניהול משתמשים";
$pgv_lang["manage_media"]			= "נהל מולטימדיה";
$pgv_lang["search_general"]			= "חיפוש כללי";
$pgv_lang["clipping_privacy"]			= "לא ניתן להוסיף חלק מהפריטים בגלל הגבלת פרטיות";
$pgv_lang["chart_new"]			= "תרשים אילן יוחסין";
$pgv_lang["loading"]				= "טוען...";
$pgv_lang["clear_chart"]			= "נקה תרשים";
$pgv_lang["file_information"]			= "מידע על קובץ";
$pgv_lang["choose_file_type"]		= "סוג קובץ";
$pgv_lang["add_individual_by_id"]		= "הוסף אדם לפי קוד זיהוי";
$pgv_lang["advanced_options"]		= "אופציות מתקדמות";
$pgv_lang["zip_files"]				= "קובץ/קובצי זיפ";
$pgv_lang["include_media"]			= "כלול מדיה (יוצר קובצי זיפ אוטומטית)";
$pgv_lang["roman_surn"]			= "שם משפחה לועזי";
$pgv_lang["roman_givn"]			= "שמות פרטיים לועזיים";
$pgv_lang["include"]				= "כלול:";
$pgv_lang["page_x_of_y"]			= "דף #GLOBALS[currentPage]# מתוך #GLOBALS[lastPage]#";
$pgv_lang["options"]				= "אפשרויות:";
$pgv_lang["config_update_ok"]		= "קובץ התצורה עודכן בצורה מוצלחת.";
$pgv_lang["page_size"]			= "גודל הדף";
$pgv_lang["font"]				= "גופן";
$pgv_lang["use_colors"]			= "השתמש בצבעים";
$pgv_lang["record_not_found"]		= "רשומת ה-GEDCOM המבוקשת לא נמצאה. הסיבה יכולה להיות קישור לאדם לא תקין או קובץ GEDCOM פגום.";
$pgv_lang["result_page"]			= "דף תוצאה";
$pgv_lang["edit_media"]			= "ערוך פריט מדיה (#GLOBALS[pid]#)";
$pgv_lang["wiki_main_page"]			= "דף ראשי של ויקי";
$pgv_lang["wiki_users_guide"]		= "מדריך למשתמש של ויקי";
$pgv_lang["wiki_admin_guide"]		= "מדריך למנהלן של ויקי";
$pgv_lang["no_search_for"]			= "וודא בחירת אופציה לחיפוש.";
$pgv_lang["no_search_site"]			= "ודא בחירת אתר מרוחק אחד לפחות.";
$pgv_lang["search_sites"] 			= "אתרים לחיפוש";
$pgv_lang["site_list"]				= "אתר: ";
$pgv_lang["site_had"]				= " הכיל";
$pgv_lang["label_search_engine_detected"]  = "התגלה עכביש של מנוע חיפוש";

$pgv_lang["ex-spouse"] 			= "בן זוג לשעבר";
$pgv_lang["ex-wife"] 				= "אישה לשעבר";
$pgv_lang["ex-husband"] 			= "בעל לשעבר";
$pgv_lang["noemail"] 				= "כתובות ללא דואר אלקטרוני";
$pgv_lang["onlyemail"] 			= "רק כתובות עם דואר אלקטרוני";
$pgv_lang["maxviews_exceeded"]		= "עברת את קצב הצפייה המותר #GLOBALS[MAX_VIEWS]# במשך #GLOBALS[MAX_VIEW_TIME]# שניות.";
$pgv_lang["broadcast_not_logged_6mo"]	= "שלח הודעה למשתמשים שלא התחברו למערכת ב-6  החודשים האחרונים";
$pgv_lang["broadcast_never_logged_in"]	= "שלח הודעה למשתמשים שעדיין לא התחברו למערכת ";
$pgv_lang["stats_to_show"]			= "בחר את הנתונים הסטטיסטיים שיוצגו באזור זה";
$pgv_lang["stat_avg_age_at_death"]		= "הגיל הממוצע בזמן הפטירה";
$pgv_lang["stat_longest_life"]			= "האדם אשר חי הכי הרבה זמן";
$pgv_lang["stat_most_children"]		= "משפחה עם הכי הרבה ילדים";
$pgv_lang["stat_average_children"]		= "מספר ממוצע של ילדים למשפחה";
$pgv_lang["stat_events"]			= "סה\"כ עובדות";
$pgv_lang["stat_surnames"]			= "סה\"כ שמות משפחה";
$pgv_lang["stat_media"]			= "ישויות מדיה";
$pgv_lang["stat_users"]			= "סה\"כ משתמשים";
$pgv_lang["no_family_facts"]			= "אין עובדות למשפחה זו.";
$pgv_lang["stat_males"]			= "זכרים";
$pgv_lang["stat_females"]			= "נקבות";
$pgv_lang["stat_unknown"]			= "לא ידוע";
$pgv_lang["stat_link"]				= "ראה תרשימים סטטיסטיים";
$pgv_lang["print_stat_link"]			= "הראה קישור לתרשימים סטטיסטיים?";

$pgv_lang["sunday_1st"]		= "א";
$pgv_lang["monday_1st"]		= "ב";
$pgv_lang["tuesday_1st"]		= "ג";
$pgv_lang["wednesday_1st"]		= "ד";
$pgv_lang["thursday_1st"]		= "ה";
$pgv_lang["friday_1st"]		= "ו";
$pgv_lang["saturday_1st"]		= "ש";

$pgv_lang["jan_1st"]			= "ינואר";
$pgv_lang["feb_1st"]			= "פברואר";
$pgv_lang["mar_1st"]			= "מרץ";
$pgv_lang["apr_1st"]			= "אפריל";
$pgv_lang["may_1st"]			= "מאי";
$pgv_lang["jun_1st"]			= "יוני";
$pgv_lang["jul_1st"]			= "יולי";
$pgv_lang["aug_1st"]			= "אוגוסט";
$pgv_lang["sep_1st"]			= "ספטמבר";
$pgv_lang["oct_1st"]			= "אוקטובר";
$pgv_lang["nov_1st"]			= "נובמבר";
$pgv_lang["dec_1st"]			= "דצמבר";

$pgv_lang["edit_source"]		= "ערוך מקור";
$pgv_lang["edit_shared_note"]	= "ערוך הערה משותפת";
$pgv_lang["familybook_chart"]		= "תרשים ספר משפחה";
$pgv_lang["family_of"]			= "משפחה של:&nbsp;";
$pgv_lang["descent_steps"]		= "רמות צאצאים";

$pgv_lang["cancel"]			= "בטל";
$pgv_lang["cookie_help"]		= "עוגיות (Cookies) דרושות כדי להתחבר לאתר זה. ניראה שהדפדפן שלך אינו מאפשר עוגיות.<br /><br />נא אפשר עוגיות עבור אתר זה לפני המשכת תהליך החיבור. ניתן לעיין בתיעוד העזרה של הדפדפן שלך איך מאפשרים עוגיות.";
//new stuff
//Individual
$pgv_lang["indi_is_remote"]		= "נתוני אדם זה מקושרים מאתר מרוחק.";
$pgv_lang["link_remote"]            	= "קשר אדם מרוחק";
//Add Remote Link
$pgv_lang["title_search_link"]      	= "הוסף קישור מקומי";
$pgv_lang["label_site_url2"]        	= "כתובת URL של האתר";
//new stuff

$pgv_lang["delete_family_confirm"]	= "מחיקת המשפחה תבטל את הקשר בין כל האנשים אבל משאירה את האנשים במקום. האם אתה בטוח שברצונך למחוק את המשפחה?";
$pgv_lang["delete_family"]		= "מחק משפחה";
$pgv_lang["add_favorite"]		= "הוסף מועדף חדש";
$pgv_lang["url"]			= "URL";
$pgv_lang["add_fav_enter_note"]	= "הכנס הערת בחירה על המועדף הזה";
$pgv_lang["add_fav_or_enter_url"]	= "או<br />\nהכנס URL וכותרת";
$pgv_lang["add_fav_enter_id"]	= "הכנס קוד של אדם, משפחה או מקור";
$pgv_lang["next_email_sent"]		= "התזכורת הבאה תשלח בדואר אלקטרוני ב-";
$pgv_lang["last_email_sent"]		= "התזכורת האחרונה נשלחה בדואר אלקטרוני ב-";
$pgv_lang["remove_child"]		= "הסר ילד זה מהמשפחה";
$pgv_lang["link_new_husb"]		= "הוסף בעל ע\"י שימוש באדם קיים";
$pgv_lang["link_new_wife"]		= "הוסף אישה ע\"י שימוש באדם קיים";
$pgv_lang["address_labels"]		= "מדבקות כתובת";
$pgv_lang["filter_address"]		= "הראה כתובות המכילות:";
$pgv_lang["address_list"]		= "רשימת כתובות";
$pgv_lang["index_edit_advice"]	= "הדגש שם אזור ולחץ על אחד מצלמיות החץ כדי להעביר את האזור המודגש לכיוון המוצבע.";
$pgv_lang["changelog"]		= "שינויי מהדורה #VERSION#";
$pgv_lang["html_block_descr"]		= "זהו אזור HTML פשוט שתוכל לשים על הדף שלך ולהוסיף בו כל הודעה שתרצה.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>הכנס את הכותרת שלך כאו</b></p><br /><p>לחץ על כפתור הגדרת התצורה";
$pgv_lang["html_block_sample_part2"]	= "כדי לראות מה שמודפס כאן.</p>";
$pgv_lang["html_block_name"]		= "HTML";
$pgv_lang["htmlplus_block_name"]	= "HTML מתקדם";
$pgv_lang["htmlplus_block_descr"]	= "זהו אזור HTML שתוכל לשים בדף שלך כדי להוסיף הודעה כלשהיא. ניתן להניס הפניות קישור למידע מקובץ ה-GEDCOM שלך לתוך טכסט ה-HTML.";
$pgv_lang["htmlplus_block_templates"] 	= "תבניות";
$pgv_lang["htmlplus_block_content"] 	= "תוכן";
$pgv_lang["htmlplus_block_narrative"] 	= "סגנון סיפורי (רק באנגלית)";
$pgv_lang["htmlplus_block_custom"]	= "מותאם";
$pgv_lang["htmlplus_block_keyword"]	= "דוגמאות של מילות מפתח (רק באנגלית)";
$pgv_lang["htmlplus_block_taglist"]	= "רשימת תווים";
$pgv_lang["htmlplus_block_compat"]	= "צורת תאימות";
$pgv_lang["htmlplus_block_ui"]	= "מקשר מורחב";
$pgv_lang["htmlplus_block_current"]	= "נוכחי";
$pgv_lang["htmlplus_block_default"]	= "ברירת מחדל";
$pgv_lang["htmlplus_block_gedcom"]	= "אילן יוחסין";
$pgv_lang["htmlplus_block_birth"]	= "לידה";
$pgv_lang["htmlplus_block_death"]	= "מות";
$pgv_lang["htmlplus_block_marrage"]	= "נישואין";
$pgv_lang["htmlplus_block_adoption"]	= "אימוץ";
$pgv_lang["htmlplus_block_burial"]	= "קבורה";
$pgv_lang["htmlplus_block_census"]	= "הוסף מרשם אוכלוסין";
$pgv_lang["num_to_show"]		= "מספר פריטים להצגה";
$pgv_lang["days_to_show"]		= "מספר הימים שיש להציג";
$pgv_lang["before_or_after"]		= "שים מונים לפני או אחרי השם?";
$pgv_lang["before"]			= "לפני";
$pgv_lang["after"]			= "אחרי";
$pgv_lang["config_block"]		= "עצב";
$pgv_lang["enter_comments"]		= ".אנא הכנס את הקשר שלך אל הנתונים בשדה ההערה";
$pgv_lang["comments"]		= "הערות";
$pgv_lang["child-family"]		= "הורים ואחים ואחיות";
$pgv_lang["spouse-family"]		= "בן/בת זוג וילדים";
$pgv_lang["direct-ancestors"]		= "אב-אבות בקו ישיר";
$pgv_lang["ancestors"]		= "אב-אבות בקו ישיר ומשפחותיהם";
$pgv_lang["descendants"]		= "צאצאים";
$pgv_lang["choose_relatives"]	= "בחר קרובים";
$pgv_lang["relatives_report"]		= "רשימת קרובים";
$pgv_lang["total_unknown"]		= "לא ידוע";
$pgv_lang["total_living"]		= "חיים";
$pgv_lang["total_dead"]		= "מתים";
$pgv_lang["total_not_born"]		= "שנולדו מתים";

$pgv_lang["remove_custom_tags"]	= "הסר נתוני PGV הפרטיים? (למשל <span dir=\"ltr\">_PGVU, _THUM</span>)";
$pgv_lang["cookie_login_help"]	= "האתר זכר אותך מהתחברות קודמת. הדבר מאפשר גישה לנתונים פרטיים ומאפיינים התלויים במשתמש, אבל כדי לערוך או לנהל את האתר,עליך להתחבר שנית - מסיבות פרטיות.";
$pgv_lang["remember_me"]		= "זכור אותי בגישה ממחשב זה?";
$pgv_lang["fams_with_surname"]	= "משפחות עם שם משפחה #surname#";
$pgv_lang["support_contact"]		= "קשר לסיוע טכני";
$pgv_lang["genealogy_contact"]	= "קשר לנתוני חקר המשפחה";
$pgv_lang["common_upload_errors"]	= "משמעות השגיאה הזו היא שכפי הנראה העלאת הקובץ עברה את הגבול המוגדר ע\"י השרת שלך. ברירת המחדל של PHP היא 2MB. תוכל להתקשר עם קבוצת התמיכה של השרת שלך כדי שהם יגדילו את הגבול בקובץ php.ini, או תוכל להעלות את הקובץ ע\"י שימוש ב-FTP. השתמש בדף <a href=\"uploadgedcom.php?action=add_form\"><b>הוסף GEDCOM</b></a> כדי להעלות קובץ GEDCOM ע\"י שימוש ב-FTP.";
$pgv_lang["total_memory_usage"]	= "סה\"כ שימוש בזיכרון:";
$pgv_lang["mothers_family_with"]	= "משפחת אם עם ";
$pgv_lang["fathers_family_with"]	= "משפחת אב עם ";
$pgv_lang["family_with"]		= "משפחה עם";
$pgv_lang["halfsibling"]		= "אח/ות למחצה";
$pgv_lang["halfbrother"]		= "אח-למחצה";
$pgv_lang["halfsister"]			= "אחות-למחצה";
$pgv_lang["family_timeline"]		= "הראה משפחה על תרשים קו הזמן";
$pgv_lang["children_timeline"]		= "הראה ילדים על תרשים קו הזמן";
$pgv_lang["other"]			= "אחר";
$pgv_lang["others"]			= "אחרים";
$pgv_lang["sort_by_marriage"]	= "מיין לפי תאריך נישואין";
$pgv_lang["reorder_families"]		= "סדר מחדש את המשפחות";
$pgv_lang["indis_with_surname"]	= "אנשים עם שם משפחה #surname#";
$pgv_lang["first_letter_name"]		= "בחר אות כדי להציג משפחות שהשם שלהם מתחיל באות זו.";
$pgv_lang["first_letter_sfname"]	= "בחר אות כדי להציג משפחות שהשם הפרטי של אחד מבני הזוג מתחיל באות זו.";
$pgv_lang["first_letter_iname"]	= "בחר אות כדי להציג אנשים ששם המשפחה שלהם מתחיל באות זו.";
$pgv_lang["first_letter_fname"]	= "בחר אות כדי להציג אנשים ששמם הפרטי מתחיל באות זו.";
$pgv_lang["total_names"]		= "סה\"כ שמות";
$pgv_lang["total_changes"]		= "סה\"כ שינויים";
$pgv_lang["total_links"]		= "סה\"כ קישורים";
$pgv_lang["top10_pageviews_nohits"]	= "כרגע אין פגיעות שניתן להציג.";
$pgv_lang["top10_pageviews_msg"]	= "יש להפעיל את המונים בתצורת קובץ ה-GEDCOM, בחלק תצוגה ומבנה, קבוצת הסתר והראה.";
$pgv_lang["review_changes_descr"]	= "אזור השינויים שלא התקבלו מראה למשתמשים בעלי הרשאת עדכון את הרשומות ששונו באון ליין ושיש עדיין לבדוק ולאשר אותן. השינויים ממתינים לאישור או דחייה.<br /><br />אם האזור פעיל, אז המשתמשים בעלי הרשאת אישור יקבלו דואר אלקטרוני פעם ביום עם הודעה שיש שינויים לבדיקה.";
$pgv_lang["review_changes_block"]	= "שינויים תלויים ועומדים";
$pgv_lang["review_changes_email"]	= "שלח תזכורת בדואר אלקטרוני?";
$pgv_lang["review_changes_email_freq"]  = "תדירות (ימים) תזכורת בדואר אלקטרוני";
$pgv_lang["review_changes_subject"]	= "PhpGedView - סקור שינויי";
$pgv_lang["review_changes_body"]	= "שינויי און-ליין נעשו במאגר חקר המשפחה. את השינויים יש לבדוק ולאשר כדי שכל המשתמשים יראו אותם. השתמש בכתובת URL למטה כדי להיכנס לאתר ה-PhpGedView הזה להתחברות ובדיקת השינויים.";
$pgv_lang["show_spouses"]		= "הצג בני זוג";
$pgv_lang["show_pending"]		= "הראה שינויים שממתינים לאישור";
$pgv_lang["quick_update_title"] 	= "עדכון מהיר";
$pgv_lang["quick_update_instructions"] = "הדף מאפשר עדכון מהיר של נתוני אדם. עליך למלא נתונים חדשים או נתונים שהשתנו לעומת הקיים באתר. לאחר שהשינויים שלך ישודרו, המנהלן יבדוק אותם לפני שכולם יוכלו לראותם באתר.";
$pgv_lang["update_name"] 		= "עדכן שם";
$pgv_lang["update_fact"] 		= "עדכן עובדה";
$pgv_lang["update_fact_restricted"] 	= "עדכון של עובדה זו מוגבל:";
$pgv_lang["select_fact"] 		= "בחר עובדה...";
$pgv_lang["update_address"] 		= "עדכן כתובת";
$pgv_lang["top10_pageviews_descr"] = "אזור זה מציג את עשרת הרשומות הכי נצפות. מונה הפגיעות בהגדרת התצורה של ה-GEDCOM חייב לפעול כדי שהאזור יהיה פעיל.";
$pgv_lang["top10_pageviews"]	= "הפריטים הנצפים ביותר";
$pgv_lang["top10_pageviews_block"]	= "הפריטים הנצפים ביותר";
$pgv_lang["stepparent"]		= "הורה חורג";
$pgv_lang["stepdad"]			= "אב חורג";
$pgv_lang["stepmom"]		= "אם חורגת";
$pgv_lang["stepsister"]		= "אחות חורגת";
$pgv_lang["stepbrother"]		= "אח חורג";
$pgv_lang["fams_charts"]		= "אפשרויות עבור משפחה";
$pgv_lang["indis_charts"]		= "אפשרויות של אדם";
$pgv_lang["none"]			= "אין";
$pgv_lang["facts"]			= "עובדות";
$pgv_lang["locked"]			= "אין לשנות";
$pgv_lang["privacy"]			= "אישי";
$pgv_lang["number_sign"]		= "#";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]		    	= "?";
$pgv_lang["qm_ah"]			= "?";
$pgv_lang["page_help"]		= "עזרה";
$pgv_lang["help_for_this_page"]	= "עזרה לדף הזה";
$pgv_lang["help_contents"]		= "תוכן העזרה";
$pgv_lang["show_context_help"]	= "הראה עזרה מקושרת";
$pgv_lang["hide_context_help"]	= "הסתר עזרה מקושרת";
$pgv_lang["sorry"]			= "<b>מצטערים, טכסט עזרה לדף או פריט זה עדיין לא מוכן</b>";
$pgv_lang["help_not_exist"]		= "<b>טכסט עזרה לדף או פריט זה עדיין לא מוכן.</b>";
$pgv_lang["var_not_exist"]		= "<span style=\"font-weight: bold\">משתנה השפה לא קיים. דווח על כך, מכיוון שזו שגיאה.</span>";
$pgv_lang["resolution"] 		= "רזולוציית המסך";
$pgv_lang["menu"]			= "תפריטים";
$pgv_lang["header"]			= "כותרת";
$pgv_lang["imageview"]		= "מציג מדיה";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"]		= "PhpGedView התחברות משתמש";
$pgv_lang["for_support"]		= " לעזרה טכנית נא להתקשר אל";
$pgv_lang["for_contact"]		= "לשאלות בקשר לשושלת יוחסין נא להתקשר אל";
$pgv_lang["for_all_contact"]		= "לעזרה טכנית או שאלות בקשר לשושלת יוחסין נא להתקשר אל";
$pgv_lang["choose_username"]	= "קוד משתמש רצוי";
$pgv_lang["username"]		= "קוד משתמש";
$pgv_lang["invalid_username"]	= "קוד המשתמש מכיל סימנים לא חוקיים";
$pgv_lang["firstname"]			= "שם פרטי";
$pgv_lang["lastname"]			= "שם משפחה";
$pgv_lang["choose_password"]	= "סיסמא רצויה";
$pgv_lang["password"]		= "סיסמא";
$pgv_lang["confirm"]			= "אשר סיסמא";
$pgv_lang["login"]			= "התחבר";
$pgv_lang["logout"]			= "התנתק";
$pgv_lang["admin"]			= "ניהול";
$pgv_lang["logged_in_as"]		= "מחובר בקוד";
$pgv_lang["my_pedigree"]		= "אילן היוחסין שלי";
$pgv_lang["my_indi"]			= "נתונים אישיים שלי";
$pgv_lang["yes"]			= "כן";
$pgv_lang["no"]			= "לא";
$pgv_lang["change_theme"]		= "שנה עיצוב";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "אילן יוחסין";
$pgv_lang["gen_ped_chart"]		= "תרשים אילן יוחסין עבור #PEDIGREE_GENERATIONS# דורות";
$pgv_lang["generations"]		= "דורות";
$pgv_lang["view"]			= "הצג";
$pgv_lang["fam_spouse"]		= "משפחה עם בן/בת זוג";
$pgv_lang["rootid"]			= "אדם ההתחלה באילן היוחסין";
$pgv_lang["root_person"]		= "קוד הזיהוי של אדם המוצא";
$pgv_lang["hide_details"]		= "הסתר פרטים";
$pgv_lang["show_details"]		= "הצג פרטים";
$pgv_lang["person_links"]		= "קישורים לתרשימים, משפחות וקרובי משפחה של אדם זה. יש ללחוץ על הצלמית הזו להצגת העמוד כאשר אדם זה בתחילתו.";
$pgv_lang["zoom_box"]		= "קרב / הרחק";
$pgv_lang["orientation"]		= "כוון";
$pgv_lang["portrait"]			= "תצוגה צפופה";
$pgv_lang["landscape"]		= "תצוגה מרווחת";
$pgv_lang["landscape_top"]		= "המבוגרים ביותר למעלה";
$pgv_lang["landscape_down"]		= "המבוגרים ביותר למטה";
$pgv_lang["start_at_parents"]		= "התחל מההורים";
$pgv_lang["charts"] 			= "תרשימים";
$pgv_lang["lists"] 			= "רשימות";
$pgv_lang["box_width"] 		= "רוחב התיבה";
$pgv_lang["random_surn"]		= "שם משפחה אקראי";
$pgv_lang["generation_number"]	= "דורות";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "לא נמצאת משפחה עם קוד זיהוי";
$pgv_lang["unable_to_find_record"]	= "לא נמצאת רשומה עם קוד זיהוי";
$pgv_lang["title"]			= "כותרת/תאור";
$pgv_lang["living"]			= "חי";
$pgv_lang["private"]			= "אישי";
$pgv_lang["birth"]			= "לידה:";
$pgv_lang["death"]			= "פטירה:";
$pgv_lang["descend_chart"]		= "תרשים צאצאים";
$pgv_lang["individual_list"]		= "אנשים";
$pgv_lang["family_list"]		= "משפחות";
$pgv_lang["branch_list"]		= "ענפים";
$pgv_lang["source_list"]		= "מקורות";
$pgv_lang["shared_note_list"]		= "הערות משותפות";
$pgv_lang["place_list"]		= "היררכית המקומות";
$pgv_lang["place_list_aft"] 		= "היררכית המקומות אחרי";
$pgv_lang["media_list"]		= "מולטימדיה";
$pgv_lang["repo_list"]			= "מאגרים";
$pgv_lang["search"]			= "חפש";
$pgv_lang["clippings_cart"]		= "עגלת גזירי העץ";
$pgv_lang["print_preview"]		= "גרסה ידידותית להדפסה";
$pgv_lang["cancel_preview"]		= "בחזרה לגרסה הרגילה";
$pgv_lang["change_lang"]		= "החלף שפה";
$pgv_lang["print"]			= "הדפס";
$pgv_lang["total_queries"]		= "סה\"כ מספר השאילתות על מסד הנתונים:";
$pgv_lang["total_privacy_checks"]	= "סה\"כ מספר בדיקות הפרטיות: ";
$pgv_lang["back"]			= "חזור";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"] 			= "ידוע גם בשם";
$pgv_lang["male"]			= "זכר";
$pgv_lang["males"]			= "זכרים";
$pgv_lang["female"]			= "נקבה";
$pgv_lang["females"]			= "נקבות";
$pgv_lang["temple"]			= "מקדש מורמונים ";
$pgv_lang["temple_code"]		= "קוד של מקדש מורמונים:";
$pgv_lang["status"]			= "מצב";
$pgv_lang["source"]			= "מקור";
$pgv_lang["text"]			= "טקסט מקור:";
$pgv_lang["note"]			= "הערה";
$pgv_lang["NN"]			= "(לא-ידוע)";
$pgv_lang["PN"]			= "(לא-ידוע)";
$pgv_lang["NNhebrew"] 		= "(לא-ידוע)";
$pgv_lang["PNhebrew"] 		= "(לא-ידוע)";
$pgv_lang["NNarabic"] 		= "(غير-معروف)";
$pgv_lang["PNarabic"] 		= "(غير-معروف)";
$pgv_lang["NNgreek"] 			= "(άγνωστος/η)";
$pgv_lang["PNgreek"] 			= "(άγνωστος/η)";
$pgv_lang["NNrussian"] 		= "(неопределено)";
$pgv_lang["PNrussian"] 		= "(неопределено)";
$pgv_lang["NNchinese"] 		= "(未知)";
$pgv_lang["PNchinese"] 		= "(未知)";
$pgv_lang["NNvietnamese"] = "(vô danh)";
$pgv_lang["PNvietnamese"] = "(không biết tuổi)";
$pgv_lang["NNthai"] 			= "(unknown)";
$pgv_lang["PNthai"] 			= "(unknown)";
$pgv_lang["NNother"] 			= "(unknown)";
$pgv_lang["PNother"] 			= "(unknown)";
$pgv_lang["unrecognized_code"]	= "קוד GEDCOM לא מוכר";
$pgv_lang["unrecognized_code_msg"]	= "זו שגיאה שברצוננו לתקן. דווח לנו על השגיאה הזו.";
$pgv_lang["indi_info"]			= "מידע אישי";
$pgv_lang["pedigree_chart"]		= "אילן יוחסין";
$pgv_lang["individual"]			= "אדם";
$pgv_lang["as_spouse"]		= "משפחה עם בן/בת זוג";
$pgv_lang["privacy_error"]		= ".הנתונים הם פרטיים ולא ניתן להראות אותם";
$pgv_lang["more_information"]	= "לפרטים נוספים נא להתקשר אל ";
$pgv_lang["given_name"]		= "שם פרטי:";
$pgv_lang["surname"]			= "שם משפחה:";
$pgv_lang["suffix"]			= "סיומת:";
$pgv_lang["sex"]			= "מגדר";
$pgv_lang["personal_facts"]		= "עובדות אישיות בפרוט";
$pgv_lang["type"]			= "סוג";
$pgv_lang["parents"] 			= "הורים";
$pgv_lang["siblings"] 			= "אחים/אחיות";
$pgv_lang["father"] 			= "אב";
$pgv_lang["mother"] 			= "אם";
$pgv_lang["parent"] 			= "הורה";
$pgv_lang["parent_age"] 		= "גיל ההורה";
$pgv_lang["father_age"]		= "גיל האב";
$pgv_lang["mother_age"]		= "גיל האם";
$pgv_lang["self"] 			= "האדם עצמו";
$pgv_lang["relatives"]		= "קרובי משפחה";
$pgv_lang["relatives_events"]	= "אירועים של קרובי משפחה";
$pgv_lang["historical_facts"]	= "עובדות היסטוריות";
$pgv_lang["partner"] 		= "שותף";
$pgv_lang["spouse"]		= "בן/בת זוג";
$pgv_lang["spouses"] 		= "בני זוג";
$pgv_lang["surnames"]	= "שמות משפחה";
$pgv_lang["adopted"]		= "אימוץ";
$pgv_lang["foster"]		= "אומנה";
$pgv_lang["sealing"]		= "אישור";
$pgv_lang["challenged"]	= "אותגר";
$pgv_lang["disproved"]	= "הופרך";
$pgv_lang["infant"]		= "תינוק";
$pgv_lang["stillborn"]		= "נולד מת";
$pgv_lang["deceased"]	= "נפטר";
$pgv_lang["link_as_wife"]	= "קשר אדם זה למשפחה קיימת בתור אישה";
$pgv_lang["no_tab1"]		= "לאדם זה אין עובדות.";
$pgv_lang["no_tab2"]		= "לאדם זה אין הערות.";
$pgv_lang["no_tab3"]		= "לאדם זה אין מקורות.";
$pgv_lang["no_tab4"]		= "לאדם זה אין מדיה.";
$pgv_lang["no_tab5"]		= "לאדם זה אין קרובי משפחה.";
$pgv_lang["no_tab6"]		= "לאדם זה אין תוספת יומן מחקר.";
$pgv_lang["show_fact_sources"]	= "הראה את כל המקורות";
$pgv_lang["show_fact_notes"]	= "הראה את כל ההערות";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "נתוני משפחה";
$pgv_lang["family_group_info"]	= "נתוני קבוצת משפחה";
$pgv_lang["husband"]			= "בעל";
$pgv_lang["wife"]			= "אישה";
$pgv_lang["marriage"]			= "נישואין:";
$pgv_lang["lds_sealing"]		= "אישור המורמונים:";
$pgv_lang["marriage_license"]	= "רישיון נישואין:";
$pgv_lang["no_children"]		= "אין ילדים באתר";
$pgv_lang["childless_family"]		= "המשפחה רשומה ללא ילדים";
$pgv_lang["parents_timeline"]		= "הצג הזוג על תרשים קו הזמן";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "עגלת גזירי העץ";
$pgv_lang["which_links"]		= "איזה קשרים ברצונך להוסיף ממשפחה זו?";
$pgv_lang["just_family"]		= "הוסף רק את רשומת המשפחה הזו.";
$pgv_lang["parents_and_family"]	= "הוסף רשומות הורים לרשומת המשפחה הזו.";
$pgv_lang["parents_and_child"]	= "הוסף רשומות הורים וילדים לרשומת המשפחה הזו.";
$pgv_lang["parents_desc"]		= "הוסף רשומות הורים וכל הצאצאים למשפחה זו.";
$pgv_lang["continue"]			= "המשך להוסיף";
$pgv_lang["which_p_links"]		= "איזה קשרים ברצונך להוסיף לאדם זה?";
$pgv_lang["just_person"]		= "הוסף רק אדם זה.";
$pgv_lang["person_parents_sibs"]	= "הוסף אדם זה ואחיו ואחיותיו.";
$pgv_lang["person_ancestors"]	= "הוסף אדם זה ואב-אבותיו הישירים.";
$pgv_lang["person_ancestor_fams"]	= "הוסף אדם זה ואב-אבותיו הישירים ומשפחותיהם.";
$pgv_lang["person_spouse"]		= "הוסף אדם זה, בן/בת זוגו וילדיו.";
$pgv_lang["person_desc"]		= "הוסף אדם זה, בן/בת זוגו ואת כל הצאצאים.";
$pgv_lang["which_s_links"]		= "איזה רשומות הקשורות למקור הזה יש להוסיף?";
$pgv_lang["just_source"]		= "הוסף רק את המקור הזה.";
$pgv_lang["linked_source"]		= "הוסף את המקור והמשפחות/האנשים הקשורים אליו.";
$pgv_lang["person_private"]		= "נתוני אדם זה אישיים. נתונים אישיים אינם נכללים.";
$pgv_lang["family_private"]		= "נתוני המשפחה הזו אישיים. נתוני המשפחה אינם נכללים.";
$pgv_lang["media_private"] 		= "הפירוט של המדיה הזה פרטי. פירוט המדיה לא יכלול.";
$pgv_lang["download"]		= "קליק ימני (קונטרול-קליק על מק) על הקישורים שמתחת ובחר \"Save Target As ...\" כדי להוריד הקבצים.";
$pgv_lang["cart_is_empty"]		= "עגלת הגזרים שלך ריקה.";
$pgv_lang["id"]				= "קוד זיהוי";
$pgv_lang["ID"]				= "קוד זיהוי";
$pgv_lang["name_description"]	= "שם / תאור";
$pgv_lang["remove"]			= "הסר";
$pgv_lang["empty_cart"]		= "רוקן עגלה";
$pgv_lang["download_now"]		= "הורד עכשיו";
$pgv_lang["download_file"]		= "הורד קובץ #GLOBALS[whichFile]#";
$pgv_lang["indi_downloaded_from"]	= "האדם הורד מהאתר:";
$pgv_lang["family_downloaded_from"]	= "המשפחה הורדה מהאתר:";
$pgv_lang["source_downloaded_from"]	= "המקור הורד מהאתר:";
$pgv_lang["enter_person_generations"] 	= "מספר דורות:";
$pgv_lang["convertPath"]			= "המר נתיב המדיה ל-"; 
$pgv_lang["convertSlashes"]			= "המר את המפרידים של תיקיית המדיה ל-"; 
$pgv_lang["forwardSlashes"]			= "לוכסן קדמי : /";
$pgv_lang["backSlashes"]			= "לוכסן אחורי : \\";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "קשרים נמצאו למקום";
$pgv_lang["top_level"]			= "רמה עליונה";
$pgv_lang["form"]			= "המקומות רשומים במבנה: ";
$pgv_lang["default_form"]		= "עיר, מחוז, אזור/מדינה, ארץ";
$pgv_lang["default_form_info"]	= "(ברירת המחדל)";
$pgv_lang["unknown"]			= "לא ידוע";
$pgv_lang["individuals"]		= "אנשים";
$pgv_lang["view_records_in_place"]	= "התבונן בכל הרשומות הנמצאות במקום הזה";
$pgv_lang["place_list2"] 		= "רשימת מקומות";
$pgv_lang["show_place_hierarchy"]	= "הראה מקומות בצורה היררכית";
$pgv_lang["show_place_list"]		= "הראה את כל המקומות ברשימה";
$pgv_lang["total_unic_places"]	= "סה\"כ מקומות שונים";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["external_objects"]		= "ישויות חיצוניות";
$pgv_lang["multi_title"]			= "ישויות מולטימדיה";
$pgv_lang["media_found"]		= "ישויות מולטימדיה נמצאו";
$pgv_lang["view_person"]		= "הצג אדם";
$pgv_lang["view_family"]		= "הצג משפחה";
$pgv_lang["view_source"]		= "הצג מקור";
$pgv_lang["view_object"]		= "הצג ישות מדיה";
$pgv_lang["prev"]			= "הקודם &gt;";
$pgv_lang["next"]			= "&lt; הבא";
$pgv_lang["next_image"]		= "האימז' הבא";
$pgv_lang["file_not_found"]		= "הקובץ לא נימצא";
$pgv_lang["medialist_show"]             	= "הראה";
$pgv_lang["per_page"]                   	= "ישויות מדיה לדף";
$pgv_lang["media_format"]		= "מבנה המדיה";
$pgv_lang["image_size"]		= "מימדי התמונה";
$pgv_lang["media_id"]			= "קוד זיהוי של מדיה";
$pgv_lang["invalid_id"]			= "קוד זיהוי כזה לא קיים בקובץ GEDCOM הזה.";
$pgv_lang["record_updated"]		= "רשומת #pid# עודכנה בהצלחה.";
$pgv_lang["record_not_updated"]	= "לא ניתן לעדכן את רשומת #pid#.";
$pgv_lang["record_removed"]		= "רשומת #xref# נמחקה בהצלחה מה-GEDCOM.";
$pgv_lang["record_not_removed"]	= "לא ניתן להסיר את רשומת #xref# מה-GEDCOM.";
$pgv_lang["record_added"]		= "רשומת ה-#xref# הוספה בהצלחה לקובץ ה-GEDCOM.";
$pgv_lang["record_not_added"]	= "לא ניתן להוסיף את רשומת ה-#xref# לקובץ ה-GEDCOM.";

//-- SEARCH FILE MESSAGES
$pgv_lang["soundex_search"] 	= "חפש לפי האיות שאתה משער (סאונדקס)";
$pgv_lang["sources"]			= "מקורות";
$pgv_lang["shared_notes"]		= "הערות משותפות";
$pgv_lang["lastname_search"]	= "משפחה";
$pgv_lang["search_place"]		= "מקום";
$pgv_lang["search_year"]		= "שנה";
$pgv_lang["no_results"]		= "לא נמצאו תוצאות";
$pgv_lang["search_soundex"]		= "חיפוש סאונדקס";
$pgv_lang["search_replace"]		= "חפש והחלף";
$pgv_lang["search_sources"]		= "מקורות";
$pgv_lang["search_shared_notes"]	= "הערות משותפות";
$pgv_lang["search_more_chars"]        = "נא הכנס יותר מתו אחד";
$pgv_lang["search_soundextype"]	= "סוג סאונדקס:";
$pgv_lang["search_russell"]                 = "בסיסי";
$pgv_lang["search_tagfilter"]		= "פילטר סינון";
$pgv_lang["search_tagfon"]		= "סנן חלק מהנתונים שאינם של חקר המשפחה";
$pgv_lang["search_tagfoff"]		= "ללא פילטר";
$pgv_lang["associate"]		= "שותף";
$pgv_lang["search_record"]		= "רשומה שלמה";
$pgv_lang["search_to"]		= "עד";
 
//-- SOURCELIST FILE MESSAGES
$pgv_lang["titles_found"]		= "כותרות";
$pgv_lang["find_source"]		= "מצא מקור";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repository"] 		= "מאגר";
$pgv_lang["repos_found"]		= "נמצאו מאגרים";
$pgv_lang["find_repository"]		= "מצא מאגר";
$pgv_lang["total_repositories"]	= "סה\"כ מאגרים";
$pgv_lang["confirm_delete_repo"]	= "האם באמת למחוק את המאגר הזה?";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "נתוני מקור";
$pgv_lang["people"]			= "אנשים";
$pgv_lang["families"]			= "משפחות";
$pgv_lang["total_sources"]		= "סה\"כ מקורות";

//-- SHARED NOTE FILE MESSAGES
$pgv_lang["shared_note"]		= "הערה משותפת";
$pgv_lang["shared_notes_found"]	= "נמצאו הערות משותפות";
$pgv_lang["find_shared_note"]	= "מצא הערה משותפת";
$pgv_lang["shared_note_info"]	= "מידע על הערה משותפת";
$pgv_lang["total_shared_notes"]	= "סה\"כ הערות משותפות";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["invalid_gedformat"]	= "מבנה GEDCOM שגוי";
$pgv_lang["exec_time"]		= "זמן העיבוד:";
$pgv_lang["unable_to_create_index"]	= "לא ניתן ליצור קובץ אינדקסים. וודא שקיימות הרשאות לתיקייה PhpGedView. את ההרשאות ניתן לשנות אחרי שקובצי האינדקס יכתבו.";
$pgv_lang["changes_present"]	= "שינויים לא מאושרים קיימים עבור ה-GEDCOM הנוכחי. אם תמשיך בייבוא זה, השינויים שממתינים לאישור יבוטלו. עליך לעיין בשינויים הממתינים לפני שתמשיך בייבוא.";

$pgv_lang["sec"]			= "שניות.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]		= "מספר המשפחות";
$pgv_lang["total_indis"]		= "מספר האנשים";
$pgv_lang["notes"]			= "הערות";
$pgv_lang["ssourcess"]		= "מקורות";
$pgv_lang["media"]			= "מדיה";
$pgv_lang["name_contains"]		= "השם מכיל:";
$pgv_lang["filter"]			= "פילטר";
$pgv_lang["apply_filter"]		= "הרץ פילטר";
$pgv_lang["find_individual"]		= "מצא קוד זיהוי";
$pgv_lang["find_familyid"]       		= "מצא קוד זיהוי של המשפחה";
$pgv_lang["find_sourceid"]		= "מצא את המקור";
$pgv_lang["find_specialchar"]		= "מצא סימנים מיוחדים";
$pgv_lang["magnify"]			= "הגדל";
$pgv_lang["skip_surnames"]		= "דלג על רשימות שמות המשפחה";
$pgv_lang["show_surnames"]		= "הצג רשימות שמות המשפחה";
$pgv_lang["skip_marnms"]		= "הוצא שמות נישואין";
$pgv_lang["show_marnms"]		= "כלול שמות נישואין";
$pgv_lang["all"]			= "הכול";
$pgv_lang["hidden"]			= "חבויים";
$pgv_lang["confidential"]		= "סודי";
$pgv_lang["alpha_index"]		= "אינדקס אלף בית";
$pgv_lang["name_list"] 		= "רשימת שמות";
$pgv_lang["firstname_alpha_index"] 	= "אינדקס אלף בית של שמות פרטיים";
$pgv_lang["roots"]		 	= "שורשים";
$pgv_lang["leaves"] 			= "עלים";
$pgv_lang["widow"] 			= "אלמנה";
$pgv_lang["widower"] 			= "אלמן";
$pgv_lang["show_parents"] 		= "הראה הורים";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "גיל";
$pgv_lang["husb_age"]		= "גיל הבעל";
$pgv_lang["wife_age"]			= "גיל האישה";
$pgv_lang["year1"]			= "שנה";
$pgv_lang["years"]			= "שנים"; // >2 שנים
$pgv_lang["years2"]			= "שנים";	// 2 שנים
$pgv_lang["month1"]			= "חודש";
$pgv_lang["months"]			= "חודשים";
$pgv_lang["week1"]			= "שבוע";
$pgv_lang["weeks"]			= "שבועות";
$pgv_lang["day1"]			= "יום";
$pgv_lang["days"]			= "ימים";
$pgv_lang["after_death"]        		= "לאחר הפטירה";
$pgv_lang["at_death_day"]      	= "ביום הפטירה";
$pgv_lang["timeline_title"]		= "תרשים קו הזמן של PhpGedView";
$pgv_lang["timeline_chart"]		= "תרשים קו הזמן";
$pgv_lang["remove_person"]		= "הסר אדם";
$pgv_lang["show_age"]		= "הראה נקודת ציון של גיל";
$pgv_lang["add_another"]		= "הוסף אדם לתרשים:<br >קוד זיהוי אדם:";
$pgv_lang["find_id"]			= "מצא קוד זיהוי";
$pgv_lang["show"]			= "הצג";
$pgv_lang["year"]			= "שנה:";
$pgv_lang["timeline_instructions"]	= "ברוב תוכנות הגלישה החדשות ניתן להקיש ולגרור קופסאות על התרשים.";
$pgv_lang["zoom_in"]			= "קרב";
$pgv_lang["zoom_out"]		= "הרחק";
$pgv_lang["timeline_beginYear"] 	= "שנת התחלה";
$pgv_lang["timeline_endYear"] 	= "שנת סיום";
$pgv_lang["timeline_scrollSpeed"] 	= "מהירות";
$pgv_lang["timeline_controls"] 	= "הגדרות קו הזמן";
$pgv_lang["include_family"] 		= "כלול משפחה קרובה";
$pgv_lang["lifespan_chart"] 		= "תרשים תוחלת חיים";

// calendar conversion options
$pgv_lang["cal_none"]                 	= "אין תרגום מבנה תאריך";
$pgv_lang["cal_gregorian"]            	= "גרגוריאני";
$pgv_lang["cal_julian"]               	= "יוליאני";
$pgv_lang["cal_french"]               	= "צרפתי";
$pgv_lang["cal_jewish"]               	= "יהודי";
$pgv_lang["cal_hebrew"]               	= "עברי";
$pgv_lang["cal_jewish_and_gregorian"] = "יהודי וגרגוריאני";
$pgv_lang["cal_hebrew_and_gregorian"] = "עברי וגרגוריאני";
$pgv_lang["cal_hijri"]                		= "לוח שנה מוסלמי";
$pgv_lang["cal_arabic"]               	= "ערבי";

// some religious dates
$pgv_lang["easter"]     			= "פסחא";
$pgv_lang["ascension"]  		= "עליה";
$pgv_lang["pentecost"]  		= "שבועות הנוצרי";
$pgv_lang["assumption"] 		= "עלית מריה השמיימה";
$pgv_lang["all_saints"] 		= "יום כל הקדושים";
$pgv_lang["christmas"]  		= "חג המולד";

// am/pm suffixes for 12 hour clocks
$pgv_lang["a.m."]         		= "לפנה\"צ";
$pgv_lang["p.m."]         		= "אחה\"צ";
$pgv_lang["noon"]         		= "צהריים";
$pgv_lang["midn"]         		= "חצות";

//-- MONTH NAMES
$pgv_lang["jan"]			= "ינואר";
$pgv_lang["feb"]			= "פברואר";
$pgv_lang["mar"]			= "מרץ";
$pgv_lang["apr"]			= "אפריל";
$pgv_lang["may"]			= "מאי";
$pgv_lang["jun"]			= "יוני";
$pgv_lang["jul"]			= "יולי";
$pgv_lang["aug"]			= "אוגוסט";
$pgv_lang["sep"]			= "ספטמבר";
$pgv_lang["oct"]			= "אוקטובר";
$pgv_lang["nov"]			= "נובמבר";
$pgv_lang["dec"]			= "דצמבר";

$pgv_lang["vend"]         		= "ונדמיר";
$pgv_lang["brum"]         		= "ברימר";
$pgv_lang["frim"]         			= "פרימר";
$pgv_lang["nivo"]         			= "ניבוז";
$pgv_lang["pluv"]         			= "פליביוז";
$pgv_lang["vent"]         		= "ונטוז";
$pgv_lang["germ"]         		= "ז'רמינאל";
$pgv_lang["flor"]         			= "פלוראל";
$pgv_lang["prai"]         			= "פריריאל";
$pgv_lang["mess"]         		= "מסידור";
$pgv_lang["ther"]         			= "תרמידור";
$pgv_lang["fruc"]         			= "פרוקטידור";
$pgv_lang["comp"]         		= "ימים משלימים";

$pgv_lang["tsh"]          			= "תשרי";
$pgv_lang["csh"]          		= "חשוון";
$pgv_lang["ksl"]          			= "כסלו";
$pgv_lang["tvt"]          			= "טבת";
$pgv_lang["shv"]          			= "שבט";
$pgv_lang["adr"]          			= "אדר";
$pgv_lang["adr_leap_year"]		= "אדר א'";
$pgv_lang["ads"]          		= "אדר ב'";
$pgv_lang["nsn"]          		= "ניסן";
$pgv_lang["iyr"]          			= "אייר";
$pgv_lang["svn"]          			= "סיוון";
$pgv_lang["tmz"]          		= "תמוז";
$pgv_lang["aav"]          			= "אב";
$pgv_lang["ell"]          			= "אלול";

$pgv_lang["muhar"]        		= "מוחרם";
$pgv_lang["safar"]        		= "צפר";
$pgv_lang["rabia"]        		= "רביע אל-אוול";
$pgv_lang["rabit"]        			= "רביע א-ת'אני";
$pgv_lang["jumaa"]        		= "ג׳ומאדא אל-אוואל";
$pgv_lang["jumat"]        		= "ג׳ומאדא אל-ת'אניה";
$pgv_lang["rajab"]        		= "רג׳ב";
$pgv_lang["shaab"]        		= "שעבאן";
$pgv_lang["ramad"]        		= "רמדאן";
$pgv_lang["shaww"]        		= "שוואל";
$pgv_lang["dhuaq"]        		= "ז'ו אל-קעדה";
$pgv_lang["dhuah"]        		= "זו אל-חיג׳ה";

$pgv_lang["b.c."]         			= "לפנה\"ס";

$pgv_lang["abt"]			= "בערך";
$pgv_lang["aft"]			= "אחרי";
$pgv_lang["and"]			= "ו-";
$pgv_lang["bef"]			= "לפני";
$pgv_lang["bet"]			= "בין";
$pgv_lang["cal"]			= "מחושב";
$pgv_lang["est"]			= "מוערך";
$pgv_lang["from"]			= "מ-";
$pgv_lang["int"]			= "פרשנות";
$pgv_lang["to"]			= "עד";
$pgv_lang["cir"]			= "בערך";
$pgv_lang["apx"]			= "בערך";

//-- Admin File Messages
$pgv_lang["password_mismatch"]	= "הסיסמאות אינן מתאימות.";
$pgv_lang["enter_username"]		= ".יש למלא קוד משתמש";
$pgv_lang["enter_password"]		= ".יש למלא סיסמא";
$pgv_lang["save"]			= "שמור";
$pgv_lang["saveandgo"]		= "שמור ועבור לרשומה חדשה";
$pgv_lang["delete"]			= "מחק";
$pgv_lang["edit"]			= "ערוך";
$pgv_lang["no_login"]			= "לא ניתן לאשר משתמש.";
$pgv_lang["basic_realm"]		= "מערכת אימות של PhpGedView";
$pgv_lang["basic_auth_failure"]	= "עליך להכניס קוד משתמש וסיסמא תקפים כדי להיכנס למשאב זה";
$pgv_lang["basic_auth"]		= "אימות בסיסי";
$pgv_lang["digest_auth"]		= "אימות Digest Authentication"; //not used in code yet
$pgv_lang["no_auth_needed"]		= "אין אימות";
$pgv_lang["file_not_exists"]		= "לא קיים קובץ בשם הזה.";
$pgv_lang["research_assistant"]	= "עוזר מחקר";
$pgv_lang["utf8_to_ansi"]		= "הסב מ-UTF-8 ל-(ANSI (ISO-8859-1?";
$pgv_lang["media_linked"]		= "המדיה הזו מקושרת ל-";
$pgv_lang["media_not_linked"]	= "המדיה הזו אינה מקושרת לשום רשומת GEDCOM.";
$pgv_lang["media_dir_1"]		= "ישות המדיה הזו נמצאת על שרת חיצוני";
$pgv_lang["media_dir_2"]		= "ישות המדיה הזו נמצאת בתיקיית המדיה הרגילה";
$pgv_lang["media_dir_3"]		= "ישות המדיה הזו נמצאת בתיקיית המדיה המוגנת";
$pgv_lang["thumb_dir_1"]		= "התמונה הממוזערת הזו נמצאת על שרת חיצוני";
$pgv_lang["thumb_dir_2"]		= "התמונה הממוזערת הזו נמצאת בתיקיית המדיה הרגילה";
$pgv_lang["thumb_dir_3"]		= "התמונה הממוזערת הזו נמצאת בתיקיית המדיה המוגנת";
$pgv_lang["moveto_2"]		= "העבר לתיקייה מוגנת";
$pgv_lang["moveto_3"]		= "העבר לתיקייה רגילה";
$pgv_lang["move_standard"]		= "העבר לרגיל";
$pgv_lang["move_protected"]		= "העבר למוגן";
$pgv_lang["move_mediadirs"]		= "העבר תיקיות מדיה";
$pgv_lang["setperms"]		= "הגדר הרשאות של המדיה";
$pgv_lang["setperms_fix"]		= "הרשאות נכונות לקריאה/כתיבה/ביצוע";
$pgv_lang["setperms_success"]	= "ההרשאות הוגדרו";
$pgv_lang["setperms_failure"]		= "ההרשאות לא הוגדרו";
$pgv_lang["setperms_time_exceeded"]	= "גבול זמן העיבוד הושג.  נסה את הפקודה שנית על תיקייה קטנה יותר.";
$pgv_lang["move_time_exceeded"]	= "גבול זמן העיבוד הושג. נסה את הפקודה שנית כדי להעביר את יתר הקבצים.";
$pgv_lang["media_firewall_rootdir_no_exist"]			= " ספריית השורש של חומת האש של מדיה שביקשת אינה קיימת. עליך ליצור אותה תחילה.";
$pgv_lang["media_firewall_protected_dir_no_exist"]		= "לא ניתן ליצור את הספרייה המוגנת בספריית השורש של חומת האש.  נא צור את הספרייה והפוך אותה לניתנת לכתיבה עולמית.";
$pgv_lang["media_firewall_protected_dir_not_writable"]	= "ספריית המדיה המוגנת הנמצאת בספריית השורש של חומת האש אינה ניתנת לכתיבה עולמית.";
$pgv_lang["media_firewall_invalid_dir"]	= "שגיאה: חומת האש הופעלה מתיקיה שונה מתיקית המדיה";

//-- Relationship chart messages
$pgv_lang["view_fam_nav_details"]	= "הצג הערות עבור ...";
$pgv_lang["view_fam_nav_notes"]	= "הצג הערות עבור ...";
$pgv_lang["view_fam_nav_sources"]	= "הצג מקורות עבור ...";
$pgv_lang["view_fam_nav_media"]	= "הצג מדיה עבור ...";
$pgv_lang["view_fam_nav_album"]	= "הצג אלבום עבור ...";
$pgv_lang["view_fam_nav_relatives"]	= "הצג קרובים עבור ...";
$pgv_lang["view_fam_nav_tree"]	= "הצג עץ עבור ...";
$pgv_lang["view_fam_nav_research"]	= "הצג מחקר עבור ...";
$pgv_lang["view_fam_nav_map"]	= "הצג מפה עבור ...";
$pgv_lang["view_fam_nav_spare"]	= "הצג נתונים חלופיים עבור ...";
$pgv_lang["navigator"]			= "נווט";
$pgv_lang["fam_navigator"]		= "נווט משפחה";

$pgv_lang["relationship_great"]	= "Great"; //--@#@ ??
$pgv_lang["relationship_chart"]	= "קירבה משפחתית";
$pgv_lang["person1"]			= "אדם א'";
$pgv_lang["person2"]			= "אדם ב'";
$pgv_lang["no_link_found"]		= "לא נמצא קשר בין שני האנשים.";
$pgv_lang["no_other_link_found"]	= "לא נמצא קשר אחר בין שני האנשים."; 
$pgv_lang["sibling"]			= "אח/ות";
$pgv_lang["follow_spouse"]		= "בדוק קירבה באמצעות נישואין";
$pgv_lang["timeout_error"]		= "החיפוש ארך יותר מידי זמן.";
$pgv_lang["grandchild"]		= "נכד/ה";
$pgv_lang["grandson"]			= "נכד";
$pgv_lang["granddaughter"]		= "נכדה";
$pgv_lang["greatgrandchild"]		= "שלש/ה";
$pgv_lang["greatgrandson"]		= "שלש";
$pgv_lang["greatgranddaughter"]	= "שלשה";
$pgv_lang["brother"]			= "אח";
$pgv_lang["sister"]			= "אחות";
$pgv_lang["aunt"]			= "דודה";
$pgv_lang["uncle"]			= "דוד";
$pgv_lang["nephew"]			= "אחיינית";
$pgv_lang["niece"]			= "אחיין";
$pgv_lang["firstcousin"]		= "דודן/דודנית מדרגה ראשונה";
$pgv_lang["femalecousin"]		= "דודנית";
$pgv_lang["malecousin"]		= "דודן";
$pgv_lang["cousin_in_law"]		= "דודן/דודנית באמצעות נישואין";
$pgv_lang["m_cousin_in_law"]	= "דודן באמצעות נישואין";
$pgv_lang["f_cousin_in_law"]		= "דודנית באמצעות נישואין";
$pgv_lang["relationship_to_me"]	= "קירבה אלי";
$pgv_lang["rela_husb"]		= "קירבה לבעל";
$pgv_lang["rela_wife"]			= "קירבה לאישה";
$pgv_lang["next_path"]		= "מצא הנתיב הבא";
$pgv_lang["show_path"]		= "הראה את הנתיב";
$pgv_lang["line_up_generations"]	= "סדר בשורה לפי דורות";
$pgv_lang["oldest_top"]             	= "הראה את הישן למעלה";

// %1\$s replaced by first person, %2\$s by the relationship and %3\$s by the second person.
$pgv_lang["relationship_male_1_is_the_2_of_3"] = "%1\$s הוא %2\$s של %3\$s";
$pgv_lang["relationship_female_1_is_the_2_of_3"] = "%1\$s היא %2\$s של %3\$s";

$pgv_lang["mother_in_law"]		= "חמות";
$pgv_lang["father_in_law"]		= "חם";
$pgv_lang["brother_in_law"]		= "גיס";
$pgv_lang["sister_in_law"]		= "גיסה";
$pgv_lang["brothers_wife"]		= "גיסה";
$pgv_lang["son_in_law"]		= "חתן";  // the husband of your daughter
$pgv_lang["daughter_in_law"]		= "כלה"; // the wife of your son
$pgv_lang["uncle_in_law"]		= "דוד באמצעות נישואין";   //Uncle-in-law";
$pgv_lang["aunt_in_law"]		= "דודה באמצעות נישואין"; //Aunt-in-law";

$pgv_lang["step_son"]			= "בן חורג";
$pgv_lang["step_daughter"]	    	= "בת חורגת";

// the bosa_brothers_offspring name is used for fraternal nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_brothers_offspring_2"] = "נכדן";              // brother's son
$pgv_lang["bosa_brothers_offspring_3"] = "נכדנית";          // brother's daughter
// 2nd generation
$pgv_lang["bosa_brothers_offspring_4"] = "נכדן משנה";     // brother's son's son
$pgv_lang["bosa_brothers_offspring_5"] = "נכדנית משנה"; // brother's son's daughter
$pgv_lang["bosa_brothers_offspring_6"] = "נכדן משנה";     // brother's daughter's son
$pgv_lang["bosa_brothers_offspring_7"] = "נכדנית משנה"; // brother's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_brothers_son"]	  = "נכדנית מדרגה %1\$d";
$pgv_lang["n_x_brothers_daughter"] = "נכדנית מדרגה %1\$d";
// the bosa_sisters_offspring name is used for sisters nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_sisters_offspring_2"] = "נכדן";               // sister's son
$pgv_lang["bosa_sisters_offspring_3"] = "נכדנית";           // sister's daughter
// 2nd generation
$pgv_lang["bosa_sisters_offspring_4"] = "נכדן משנה";      // sister's son's son
$pgv_lang["bosa_sisters_offspring_5"] = "נכדנית משנה";  // sister's son's daughter
$pgv_lang["bosa_sisters_offspring_6"] = "נכדן משנה";      // sister's daughter's son
$pgv_lang["bosa_sisters_offspring_7"] = "נכדנית משנה";  // sister's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_sisters_son"]	  = "נכדנית מדרגה %1\$d";
$pgv_lang["n_x_sisters_daughter"] = "נכדנית מדרגה %1\$d";

// the bosa name is used for offspring - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_2"] 				= "בן";                // son
$pgv_lang["bosa_3"] 				= "בת";              // daughter
// 2nd generation
$pgv_lang["bosa_4"] 				= "נכד";              // son's son
$pgv_lang["bosa_5"] 				= "נכדה";            // son's daughter
$pgv_lang["bosa_6"] 				= "נכד";              // daughter's son
$pgv_lang["bosa_7"] 				= "נכדה";            // daughter's daughter
// 3rd generation
$pgv_lang["bosa_8"] 				= "שלש";     	// son's son's son
$pgv_lang["bosa_9"] 				= "שלשה";   	// son's son's daughter
$pgv_lang["bosa_10"] 			= "שלש";	// son's daughters son
$pgv_lang["bosa_11"] 			= "שלשה";   	// son's daughters daughter
$pgv_lang["bosa_12"] 			= "שלש";     	// daughter's son's son
$pgv_lang["bosa_13"] 			= "שלשה";   	// daughter's son's daughter
$pgv_lang["bosa_14"] 			= "שלש"; 	// daughter's daughters son
$pgv_lang["bosa_15"] 			= "שלשה";   	// daughter's daughters daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_grandson_from_son"]	  	= "נכד מדרגה %2\$d";
$pgv_lang["n_x_granddaughter_from_son"] 		= "נכדה מדרגה %2\$d";
$pgv_lang["n_x_grandson_from_daughter"]	  	= "נכד מדרגה %2\$d";
$pgv_lang["n_x_granddaughter_from_daughter"] 	= "נכדה מדרגה %2\$d";

// the sosa_uncle name is used for uncles - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_2"] 				= "דוד";            // father's brother
$pgv_lang["sosa_uncle_3"] 				= "דוד";            // mother's brother
// 2nd generation
$pgv_lang["sosa_uncle_4"] 				= "דוד סב";      // father's fathers brother
$pgv_lang["sosa_uncle_5"] 				= "דוד סב";      // father's mothers brother
$pgv_lang["sosa_uncle_6"] 				= "דוד סב";      // mother's fathers brother
$pgv_lang["sosa_uncle_7"] 				= "דוד סב";      // mother's mothers brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle"]			= "דוד מדרגה %1\$d";
$pgv_lang["n_x_maternal_uncle"]	    		= "דוד מדרגה %1\$d";

// the sosa_aunt name is used for aunt - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_2"] 				= "דודה";            // father's sister
$pgv_lang["sosa_aunt_3"] 				= "דודה";            // mother's sister
// 2nd generation
$pgv_lang["sosa_aunt_4"] 				= "דודה סבה";      // father's fathers sister
$pgv_lang["sosa_aunt_5"] 				= "דודה סבה";      // father's mothers sister
$pgv_lang["sosa_aunt_6"] 				= "דודה סבה";      // mother's fathers sister
$pgv_lang["sosa_aunt_7"] 				= "דודה סבה";      // mother's mothers sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt"]			= "דודה מדרגה %1\$d";
$pgv_lang["n_x_maternal_aunt"]	    		= "דודה מדרגה %1\$d";

// the sosa_uncle_bm name is used for uncles (by marriage) - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_bm_2"] 			= "דוד";            // fathers brother
$pgv_lang["sosa_uncle_bm_3"] 			= "דוד";            // mothers brother
// 2nd generation
$pgv_lang["sosa_uncle_bm_4"] 			= "דוד סב";      // fathers's fathers brother
$pgv_lang["sosa_uncle_bm_5"] 			= "דוד סב";      // fathers mothers brother
$pgv_lang["sosa_uncle_bm_6"] 			= "דוד סב";      // mothers fathers brother
$pgv_lang["sosa_uncle_bm_7"] 			= "דוד סב";      // mothers mothers brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle_bm"]			= "דוד מדרגה %1\$d";
$pgv_lang["n_x_maternal_uncle_bm"]	    		= "דוד מדרגה %1\$d";

// the sosa_aunt_bm name is used for aunt (by marriage) - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_bm_2"] 			= "דודה";            // fathers sister
$pgv_lang["sosa_aunt_bm_3"] 			= "דודה";            // mothers sister
// 2nd generation
$pgv_lang["sosa_aunt_bm_4"] 			= "דודה סבה";      // fathers's fathers sister
$pgv_lang["sosa_aunt_bm_5"] 			= "דודה סבה";      // fathers mothers sister
$pgv_lang["sosa_aunt_bm_6"] 			= "דודה סבה";      // mothers fathers sister
$pgv_lang["sosa_aunt_bm_7"] 			= "דודה סבה";      // mothers mothers sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt_bm"]			= "דודה מדרגה %1\$d";
$pgv_lang["n_x_maternal_aunt_bm"]	    		= "דודה מדרגה %1\$d";

// if a specific cousin relationship cannot be represented in a language translate as "";
$pgv_lang["male_cousin_1"]              		= "דודן";
$pgv_lang["male_cousin_2"]             		= "דודן משנה";
$pgv_lang["male_cousin_3"]              		= "דודן שילש";
$pgv_lang["male_cousin_4"]              		= "דודן מדרגה 4";
$pgv_lang["male_cousin_5"]        	      	= "דודן מדרגה 5";
$pgv_lang["male_cousin_6"]       	       	= "דודן מדרגה 6";
$pgv_lang["male_cousin_7"]       	       	= "דודן מדרגה 7";
$pgv_lang["male_cousin_8"]        	      	= "דודן מדרגה 8";
$pgv_lang["male_cousin_9"]         	     	= "דודן מדרגה 9";
$pgv_lang["male_cousin_10"]       	      	= "דודן מדרגה 10";
$pgv_lang["male_cousin_11"]    	        	= "דודן מדרגה 11";
$pgv_lang["male_cousin_12"]      	      	= "דודן מדרגה 12";
$pgv_lang["male_cousin_13"]      	       	= "דודן מדרגה 13";
$pgv_lang["male_cousin_14"]       	      	= "דודן מדרגה 14";
$pgv_lang["male_cousin_15"]        	     	= "דודן מדרגה 15";
$pgv_lang["male_cousin_16"]        	     	= "דודן מדרגה 16";
$pgv_lang["male_cousin_17"]        	     	= "דודן מדרגה 17";
$pgv_lang["male_cousin_18"]      	       	= "דודן מדרגה 18";
$pgv_lang["male_cousin_19"]         	    	= "דודן מדרגה 19";
$pgv_lang["male_cousin_20"]             		= "דודן מדרגה 20";
$pgv_lang["male_cousin_n"]      	       	= "דודן מדרגה %d";
$pgv_lang["female_cousin_1"]  	          	= "דודנית";
$pgv_lang["female_cousin_2"]            		= "דודנית משנה";
$pgv_lang["female_cousin_3"] 	          	= "דודנית שילשה";
$pgv_lang["female_cousin_4"]   	         	= "דודנית מדרגה 4";
$pgv_lang["female_cousin_5"]   	         	= "דודנית מדרגה 5";
$pgv_lang["female_cousin_6"]    	        	= "דודנית מדרגה 6";
$pgv_lang["female_cousin_7"]     	       	= "דודנית מדרגה 7";
$pgv_lang["female_cousin_8"]       	     	= "דודנית מדרגה 8";
$pgv_lang["female_cousin_9"]       	     	= "דודנית מדרגה 9";
$pgv_lang["female_cousin_10"]     		= "דודנית מדרגה 10";
$pgv_lang["female_cousin_11"]           	= "דודנית מדרגה 11";
$pgv_lang["female_cousin_12"]           	= "דודנית מדרגה 12";
$pgv_lang["female_cousin_13"]           	= "דודנית מדרגה 13";
$pgv_lang["female_cousin_14"]           	= "דודנית מדרגה 14";
$pgv_lang["female_cousin_15"]           	= "דודנית מדרגה 15";
$pgv_lang["female_cousin_16"]           	= "דודנית מדרגה 16";
$pgv_lang["female_cousin_17"]           	= "דודנית מדרגה 17";
$pgv_lang["female_cousin_18"]           	= "דודנית מדרגה 18";
$pgv_lang["female_cousin_19"]           	= "דודנית מדרגה 19";
$pgv_lang["female_cousin_20"]           	= "דודנית מדרגה 20";
$pgv_lang["female_cousin_n"]           		= "דודנית מדרגה %d";
// Only referenced from english specific functions
//@#@ SEE http://www.weinel.com/family/relations.html - ASCENDING?
$pgv_lang["removed_ascending_1"]   = " במרחק 1 עולה"; //" once removed ascending";
$pgv_lang["removed_ascending_2"]   = " במרחק 2 עולה";
$pgv_lang["removed_ascending_3"]   = " במרחק 3 עולה";
$pgv_lang["removed_ascending_4"]   = " במרחק 4 עולה";
$pgv_lang["removed_ascending_5"]   = " במרחק 5 עולה";
$pgv_lang["removed_ascending_6"]   = " במרחק 6 עולה";
$pgv_lang["removed_ascending_7"]   = " במרחק 7 עולה";
$pgv_lang["removed_ascending_8"]   = " במרחק 8 עולה";
$pgv_lang["removed_ascending_9"]   = " במרחק 9 עולה";
$pgv_lang["removed_ascending_10"]  = " במרחק 10 עולה";
$pgv_lang["removed_ascending_11"]  = " במרחק 11 עולה";
$pgv_lang["removed_ascending_12"]  = " במרחק 12 עולה";
$pgv_lang["removed_ascending_13"]  = " במרחק 13 עולה";
$pgv_lang["removed_ascending_14"]  = " במרחק 14 עולה";
$pgv_lang["removed_ascending_15"]  = " במרחק 15 עולהg";
$pgv_lang["removed_ascending_16"]  = " במרחק 16 עולה";
$pgv_lang["removed_ascending_17"]  = " במרחק 17 עולה";
$pgv_lang["removed_ascending_18"]  = " במרחק 18 עולה";
$pgv_lang["removed_ascending_19"]  = " במרחק 19 עולה";
$pgv_lang["removed_ascending_20"]  = " במרחק 20 עולה";
$pgv_lang["removed_descending_1"]  = " במרחק 1 יורד"; //" once removed descending";
$pgv_lang["removed_descending_2"]  = " במרחק 2 יורד";
$pgv_lang["removed_descending_3"]  = " במרחק 3 יורד";
$pgv_lang["removed_descending_4"]  = " במרחק 4 יורד";
$pgv_lang["removed_descending_5"]  = " במרחק 5 יורד";
$pgv_lang["removed_descending_6"]  = " במרחק 6 יורד";
$pgv_lang["removed_descending_7"]  = " במרחק 7 יורד";
$pgv_lang["removed_descending_8"]  = " במרחק 8 יורד";
$pgv_lang["removed_descending_9"]  = " במרחק 9 יורד";
$pgv_lang["removed_descending_10"] = " במרחק 10 יורד";
$pgv_lang["removed_descending_11"] = " במרחק 11 יורד";
$pgv_lang["removed_descending_12"] = " במרחק 12 יורד";
$pgv_lang["removed_descending_13"] = " במרחק 13 יורד";
$pgv_lang["removed_descending_14"] = " במרחק 14 יורד";
$pgv_lang["removed_descending_15"] = " במרחק 15 יורד";
$pgv_lang["removed_descending_16"] = " במרחק 16 יורד";
$pgv_lang["removed_descending_17"] = " במרחק 17 יורד";
$pgv_lang["removed_descending_18"] = " במרחק 18 יורד";
$pgv_lang["removed_descending_19"] = " במרחק 19 יורד";
$pgv_lang["removed_descending_20"] = " במרחק 20 יורד";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]		= " האם הנך בטוח שברצונך למחוק עובדה זו?";
$pgv_lang["access_denied"]		= "<b>גישה נאסרה</b><br />אין לך גישה למשאב זה.";
$pgv_lang["changes_exist"]		= "ה-GEDCOM הזה שונה.";
$pgv_lang["find_place"]		= "מצא מקום";
$pgv_lang["close_window"]		= "סגור חלון";
$pgv_lang["close_window_without_refresh"] = "סגור חלון ללא טעינה מחדש";
$pgv_lang["place_contains"]		= "מקום מכיל:";
$pgv_lang["add"]			= "הוסף";
$pgv_lang["custom_event"]		= "מאורע מותאם";
$pgv_lang["delete_person"]		= "מחק המידע על אדם זה";
$pgv_lang["confirm_delete_person"]	= "?האם באמת להסיר את האדם";
$pgv_lang["find_media"]		= "מצא מדיה";
$pgv_lang["set_link"]			= "הצב קישור";
$pgv_lang["delete_source"]		= "מחק המקור";
$pgv_lang["delete_shared_note"]	= "מחק הערה משותפת זו";
$pgv_lang["confirm_delete_source"]	= "האם באמת למחוק מקור זה?";
$pgv_lang["confirm_delete_shared_note"]= "האם באמת למחוק הערה משותפת זו?";
$pgv_lang["find_family"]		= "מצא משפחה";
$pgv_lang["find_fam_list"]		= "מצא רשימת משפחה";
$pgv_lang["edit_name"]		= "ערוך שם";
$pgv_lang["delete_name"]		= "מחק שם";
$pgv_lang["select_date"]		= "בחר תאריך";
$pgv_lang["user_cannot_edit"]	= "המשתמש לא יכול לערוך את הקובץ ה-GEDCOM הזה.";
$pgv_lang["ged_noshow"]		= "הדף הזה נחסם ע\"י מנהלן האתר.";

//-- calendar.php messages
$pgv_lang["bdm"]			= "לידות, פטירות, נישואין";
$pgv_lang["on_this_day"]		= "ביום הזה ...";
$pgv_lang["in_this_month"]		= "בחודש הזה ...";
$pgv_lang["in_this_year"]		= "בשנה הזו ...";
$pgv_lang["year_anniversary"]		= "יום השנה #year_var#";
$pgv_lang["today"]			= "היום";
$pgv_lang["day"]			= "יום:";
$pgv_lang["month"]			= "חודש:";
$pgv_lang["showcal"]			= "הראה:";
$pgv_lang["anniversary"]		= "יום השנה";
$pgv_lang["anniversary_calendar"]	= "לוח יום השנה";
$pgv_lang["sunday"]			= "ראשון";
$pgv_lang["monday"]			= "שני";
$pgv_lang["tuesday"]			= "שלישי";
$pgv_lang["wednesday"]		= "רביעי";
$pgv_lang["thursday"]			= "חמישי";
$pgv_lang["friday"]			= "ששי";
$pgv_lang["saturday"]			= "שבת";
$pgv_lang["viewday"]			= "הצג יום";
$pgv_lang["viewmonth"]		= "הצג חודש";
$pgv_lang["viewyear"]			= "הצג שנה";
$pgv_lang["all_people"]		= "כל האנשים";
$pgv_lang["living_only"]		= "אנשים חיים";
$pgv_lang["recent_events"]		= "אירועים ב-100 השנים האחרונות";
$pgv_lang["day_not_set"]		= "היום לא מוגדר";

//-- user self registration module
$pgv_lang["lost_password"]		= "שכחת את סיסמתך?";
$pgv_lang["no_account_yet"]		= "אין קוד משתמש?";
$pgv_lang["requestpassword"]	= "בקש סיסמא חדשה";
$pgv_lang["requestaccount"]		= "בקש קוד משתמש חדש";
$pgv_lang["emailadress"]		= "הדואר האלקטרוני";
$pgv_lang["mandatory"] 		= "שדות המסומנים עם * הם שדות חובה.";
$pgv_lang["mail01_line01"]		= "שלום <span dir=\"ltr\">#user_fullname#</span> ...";
$pgv_lang["mail01_line02"]		= "קיבלנו בקשה ב- <span dir=\"ltr\">#SERVER_NAME#</span>  ליצור קוד משתמש של PhpGedView עם הכתובת האלקטרונית שלך  <span dir=\"ltr\">#user_email# .";
$pgv_lang["mail01_line03"]		= "הנתונים על הבקשה מוצגים מתחת לקישור למטה.";
$pgv_lang["mail01_line04"]		= "לחץ על הקישור הבאה ומלא את הנתונים הדרושים כדי לאשר את קוד המשתמש וכתובת הדואר האלקטרוני שלך.";
$pgv_lang["mail01_line05"]		= "מחק הודעה זו אם לא ביקשת קוד משתמש.";
$pgv_lang["mail01_line06"]		= "לא תקבל דואר נוסף מאתר זה, מכיוון שקוד המשתמש ימחק אוטומטית לאחר שבעה ימים.";
$pgv_lang["mail01_subject"]		= "הרשמתך ב-#SERVER_NAME#";

$pgv_lang["mail02_line01"]		= "שלום המנהלן ...";
$pgv_lang["mail02_line02"]		= "משתמש פוטנציאלי נרשם ב-PhpGedView של <span dir=\"ltr\">#SERVER_NAME#</span>";
$pgv_lang["mail02_line03"]		= "המשתמש קיבל דואר אלקטרוני עם הנתונים הדרושים לאישור המשתמש המבוקש.";
$pgv_lang["mail02_line04"]		= "אחרי שהמשתמש הפוטנציאלי הזה יבצע את אישורו תקבל הודעה בדואר שלך כדי שתאפשר למשתמש להתחבר לאתר שלך. המשתמש החדש יכול להתחבר לאתר רק אחרי שתפעיל את המשתמש שלו.";
$pgv_lang["mail02_line04a"]		= "תקבל הודעה בדואר אלקטרוני אחרי שהמשתמש הפוטנציאלי הזה יאשר את עצמו. אחרי האישור, המשתמש יוכל להתחבר ללא שום פעולה נוספת שלך.";
$pgv_lang["mail02_subject"]		= "רישום חדש ב-#SERVER_NAME#";

$pgv_lang["hashcode"]		= "קוד האמות:";
$pgv_lang["thankyou"]			= "שלום <span dir=\"ltr\">#user_fullname#</span> ...<br />תודה שנרשמת.";
$pgv_lang["pls_note06"]		= "נשלח לך דואר של אישור לכתובת האלקטרונית <span dir=\"ltr\"><b>#user_email#</b></span>. עליך לאשר את בקשת קוד המשתמש שלך לפי ההוראות המופיעות בדואר של האישור. אם לא תאשר את בקשת קוד המשתמש תוך שבעה ימים,  הבקשה לקוד משתמש תדחה באופן אוטומטי ואז יהיה עליך להירשם שנית.<br /><br />אחרי שתנהג לפי ההוראות המופיעות בדואר של האישור, על המנהלן עדיין לאשר את המשתמש שלך לפני שיהיה ניתן להשתמש בקוד המשתמש שלך.<br /><br />כדי להתחבר לאתר זה, עליך לדעת קוד משתמש וסיסמא.<br /><br />";
$pgv_lang["pls_note06a"]		= "נשלח לך דואר של אישור לכתובת האלקטרונית <span dir=\"ltr\"><b>#user_email#</b></span>. עליך לאשר את בקשת קוד המשתמש שלך לפי ההוראות המופיעות בדואר של האישור. אם לא תאשר את בקשת קוד המשתמש תוך שבעה ימים,  הבקשה לקוד משתמש תדחה באופן אוטומטי ואז יהיה עליך להירשם שנית.<br /><br />אחרי שתנהג לפי ההוראות המופיעות בדואר של האישור תוכל להתחבר לאתר. כדי להתחבר לאתר זה, יש לדעת קוד משתמש וסיסמא.<br /><br />";

$pgv_lang["registernew"]		= "אישור משתמש חדש";
$pgv_lang["user_verify"]		= "אמות משתמש";
$pgv_lang["send"]			= "שלח";

$pgv_lang["pls_note07"]		= "~#pgv_lang[user_verify]#~<br /><br />כדי לאשר את הבקשה שלך לקוד משתמש, הכנס את קוד המשתמש, הסיסמא וקוד האישור שקיבלת בדואר האלקטרוני.";
$pgv_lang["pls_note08"]		= "הנתונים על המשתמש <span dir=\"ltr\"><b>#user_name#</b></span> נבדקו.";

$pgv_lang["mail03_line01"]		= "שלום המנהלן ...";
$pgv_lang["mail03_line02"]		= "המשתמש <span dir=\"ltr\">#newuser[username]# - #newuser[fullname]#</span> אישר את נתוני הרישום שלו.";

$pgv_lang["mail03_line03"]		= "השתמש בקישור מתחת כדי להתחבר לאתר שלך, לעריכת נתוני המשתמש של המבקש, ובכך לאפשר למבקש להתחבר לאתר שלך.";
$pgv_lang["mail03_line03a"]		= "לא נדרשת פעולה מצידך; המשתמש יכול עכשיו להתחבר.";
$pgv_lang["mail03_subject"]		= "משתמש חדש ב-#SERVER_NAME#";

$pgv_lang["pls_note09"] 		= "אישרת את בקשתך לקוד משתמש רשום.";
$pgv_lang["pls_note10"]		= "הודעה נשלחה למנהלן. תוכל להתחבר עם קוד המשתמש והסיסמא שלך אחרי שהמנהלן ייתן את אישורו.";
$pgv_lang["pls_note10a"]		= "תוכל עכשיו להתחבר עם קוד המשתמש והסיסמה שלך.";
$pgv_lang["data_incorrect"]		= "הנתונים אינם נכונים, נסה שנית";
$pgv_lang["user_not_found"]		= "לא ניתן לאמת את המידע שהכנסת. נסה שנית או התקשר עם מנהלן האתר למידע נוסף.";

$pgv_lang["lost_pw_reset"]		= "בקשת סיסמא אבודה";
$pgv_lang["pls_note11"]		= "כדי שנוכל לשנות את סיסמתך עליך לספק את קוד המשתמש שלך .<br /><br />נשלח לך בדואר אלקטרוני כתובת אינטרנט מיוחדת וקוד אישור עבור קוד המשתמש שלך. בביקור בכתובת האינטרנט תוכל לשנות את סיסמתך ולהתחבר לאתר. מסיבות בטחון אין למסור את קוד האישור הזה לאף אחד.<br /><br />במידה ותזדקק לסיוע ממנהלן האתר, אנא השתמש בקישור בתחתית הדף.";

$pgv_lang["mail04_line01"]		= "שלום <span dir=\"ltr\">#user_fullname#</span> ...";
$pgv_lang["mail04_line02"]		= "קיבלנו בקשה לסיסמא חדשה עבור קוד המשתמש שלך.";
$pgv_lang["mail04_line03"]		= "המלצה:";
$pgv_lang["mail04_line04"]		= "הקש על הקישור מתחת או הדבק אותו לדפדפן שלך, התחבר עם הסיסמא החדשה ושנה אותה מיידית כדי לשמור על שלמות הנתונים.";
$pgv_lang["mail04_line05"]		= "אחרי שהתחברת, בחר בקישור #pgv_lang[editowndata]# מתחת לתפריט #pgv_lang[mygedview]# ומלא את שדות הסיסמא כדי לשנות את הסיסמא שלך.";
$pgv_lang["mail04_subject"]		= "בקשת נתונים על #SERVER_NAME#";

$pgv_lang["pwreqinfo"]		= "שלום...<br /><br />דואר הכולל סיסמא חדשה נישלח לכתובת אלקטרונית <span dir=\"ltr\"><b>#user[email]#</b></span>.<br /><br />בדוק את תיבת הדואר שלך מכיוון שהדואר יתקבל תוך מספר דקות.<br /><br />המלצה:<br />אחרי שתקבל את הדואר התחבר לאתר זה עם סיסמתך החדשה ושנה את הסיסמא כדי לשמור על אבטחת הנתונים.";

$pgv_lang["myuserdata"]		= "המשתמש שלי";
$pgv_lang["user_theme"]		= "עיצוב האתר";
$pgv_lang["mgv"]			= "MyGedView";
$pgv_lang["mygedview"]		= "דף MyGedView";
$pgv_lang["passwordlength"]		= "אורך הסיסמא לפחות 6 תווים.";
$pgv_lang["welcome_text_auth_mode_1"] = "<center><b>ברוכים הבאים לאתר הזה של חקר שושלת היוחסין</b></center><br />גישה לאתר זה מותרת לכל המשתמשים בעלי קוד משתמש באתר.<br /><br />אם יש לך קוד משתמש, תוכל להתחבר למערכת באמצעות הדף הזה. אם אין לך קוד משתמש, תוכל לבקש קוד משתמש ע\"י לחיצה על הקישור המתאים מלמטה.<br /><br />מנהלן האתר יבדוק את נתוניך ויפעיל את קוד המשתמש שלך. תקבל דואר אלקטרוני אחרי שקוד המשתמש שלך יאושר.";
$pgv_lang["welcome_text_auth_mode_2"] = "<center><b>ברוכים הבאים לאתר הזה של חקר שושלת היוחסין</b></center><br />גישה לאתר זה מותרת רק למשתמשים <u>מורשים.</u><br /><br />אם יש לך קוד משתמש תוכל להתחבר למערכת באמצעות הדף הזה. אם אין לך קוד משתמש, תוכל לבקש קוד משתמש ע\"י לחיצה על הקישור מלמטה.<br /><br />מנהלן האתר יבדוק את נתוניך ויאשר או ידחה את בקשתך. תקבל דואר אלקטרוני אחרי שבקשתך תאושר.";
$pgv_lang["welcome_text_auth_mode_3"] = "<center><b>ברוכים הבאים לאתר הזה של חקר שושלת היוחסין</b></center><br />גישה לאתר זה מותרת <u>רק לבני משפחה</u>.<br />אם יש לך קוד משתמש תוכל להתחבר למערכת באמצעות הדף הזה. אם אין לך קוד משתמש, תוכל לבקש קוד משתמש ע\"י לחיצה על הקישור המתאים מלמטה.<br /><br />מנהלן האתר יבדוק את נתוניך ויאשר או ידחה את בקשתך. תקבל דואר אלקטרוני אחרי שבקשתך תאושר.";
$pgv_lang["welcome_text_cust_head"]	= "<center><b>ברוכים הבאים לאתר הזה של חקר שושלת היוחסין</b></center><br />גישה לאתר זה מותרת למשתמשים בעלי קוד משתמש וסיסמא.<br />";
$pgv_lang["acceptable_use"]			= "<div class=\"largeError\">הודעה:</div><div class=\"error\">ע\"י מילוי ושליחה של טופס זה, הנך מסכים:<ul><li>להגן על פרטיות של אנשים חיים שרשומים באתר שלנו;</li><li>ובתיבת הטכסט שלמטה, עליך להסביר למי אתה מקורב, או לספק לנו מידע על אנשים שהיו צריכים להיות רשומים באתר שלנו.</li></ul></div>";

//-- mygedview page
$pgv_lang["upcoming_events"]	= "אירועים קרובים";
$pgv_lang["living_or_all"]		= "הצג רק אירועים של אנשים חיים?";
$pgv_lang["basic_or_all"]		= "הראה רק לידות, פטירות וחתונות?";
$pgv_lang["style"]			= "סגנון תצוגה";
$pgv_lang["style1"]			= "רשימה";
$pgv_lang["style2"]			= "טבלה";
$pgv_lang["style3"]			= "ענן תגיות";
$pgv_lang["sort_style"]		= "סגנון מיון";
$pgv_lang["by_anniv"]			= "לפי יום שנה";
$pgv_lang["by_alpha"]			= "לפי אלף-בית";
$pgv_lang["cal_download"]		= "הרשה הורדת אירועי לוח שנה?";
$pgv_lang["no_events_living"]		= "אין אירוע של אנשים חיים ב-#pgv_lang[global_num1]# הימים הבאים.";
$pgv_lang["no_events_living1"]	= "אין אירוע של אנשים חיים למחר.";
$pgv_lang["no_events_all"]		= "אין אירוע ב-#pgv_lang[global_num1]# הימים הבאים.";
$pgv_lang["no_events_all1"]		= "אין אירועים למחר.";
$pgv_lang["no_events_privacy"]	= "קיימים אירועים עבור #pgv_lang[global_num1]# הימים הבאים, אבל מגבלות פרטיות מונעות ממך לראות אותם.";
$pgv_lang["no_events_privacy1"]	= "קיימים אירועים עבור מחר, אבל מגבלות פרטיות מונעות ממך לראות אותם.";
$pgv_lang["more_events_privacy"]	= "<br />קיימים אירועים נוספים עבור #pgv_lang[global_num1]# הימים הבאים, אבל מגבלות פרטיות מונעות ממך לראות אותם.";
$pgv_lang["more_events_privacy1"]	= "<br />קיימים אירועים נוספים עבור מחר, אבל מגבלות פרטיות מונעות ממך לראות אותם.";
$pgv_lang["none_today_living"]	= "אין אירוע של אנשים חיים להיום.";
$pgv_lang["none_today_all"]		= "אין אירועים להיום.";
$pgv_lang["none_today_privacy"]	= "קיימים אירועים להיום, אבל הגבלות הפרטיות מונעות ממך לראותם.";
$pgv_lang["more_today_privacy"]	= "<br />אירועים נוספים קיימים עבור היום, אבל מגבלות פרטיות מונעות ממך לראות אותם.";
$pgv_lang["chat"]			= "שיחה";
$pgv_lang["users_logged_in"]		= "משתמשים מחוברים";
$pgv_lang["anon_user"]		= "1 משתמש אלמוני מחובר";
$pgv_lang["anon_users"]		= "#pgv_lang[global_num1]# משתמשים אלמוניים מחוברים";
$pgv_lang["login_user"]		= "1 משתמש מחובר";
$pgv_lang["login_users"]		= "#pgv_lang[global_num1]# משתמשים מחוברים";
$pgv_lang["no_login_users"]		= "אין משתמשים מחוברים ואין משתמשים אלמוניים";
$pgv_lang["message"]			= "שלח הודעה";
$pgv_lang["my_messages"]		= "הודעות שלי";
$pgv_lang["date_created"]		= "תאריך שליחה:";
$pgv_lang["message_from"]		= "כתובת דואר אלקטרוני:";
$pgv_lang["message_from_name"]	= "שמך:";
$pgv_lang["message_to"]		= "הודעה אל:";
$pgv_lang["message_subject"]	= "נושא:";
$pgv_lang["message_body"]		= "גוף:";
$pgv_lang["no_to_user"]		= "לא סיפקת משתמש מקבל. לא ניתן להמשיך.";
$pgv_lang["provide_email"]		= "ספק את כתובת הדואר האלקטרוני שלך, כדאי שנוכל ליצור קשר אתך בנוגע להודעה זו. אם לא תספק את הכתובת לא נוכל להגיב לפנייתך. כתובת הדואר תשמש אך ורק לתגובה לפניה זו.";
$pgv_lang["reply"]			= "ענה";
$pgv_lang["message_deleted"]	= "ההודעה נמחקה";
$pgv_lang["message_sent"]		= "ההודעה נשלחה בהצלחה ל-#TO_USER#";
$pgv_lang["reset"]			= "ברירת מחדל";
$pgv_lang["site_default"]		= "ברירת מחדל";
$pgv_lang["mygedview_desc"]	= "דף MyGedView מאפשר לך לשמור סימניות של האנשים המועדפים שלך, לעקוב אחרי מאורעות קרובים ולשתף פעולה עם משתמשי PhpGedView אחרים.";
$pgv_lang["no_messages"]		= "אין הודעות תלויות ועומדות";
$pgv_lang["clicking_ok"] 		= ".#user[fullname]# תפתח חלון נוסף שממנו תוכל להתקשר עם OK הקשה על";
$pgv_lang["favorites"]			= "מועדפים";
$pgv_lang["my_favorites"]		= "מועדפים שלי";
$pgv_lang["no_favorites"]		= "לא בחרת מועדפים.<br /><br />כדי להוסיף אדם, משפחה או מקור לרשימת המועדפים שלך, לחץ על קישור <b>#pgv_lang[add_favorite]#</b> כדי להציג מספר שדות שבהם ניתן למלא או לחפש קוד זיהוי. במקום קוד זיהוי ניתן למלא URL וכותרת.";
$pgv_lang["add_to_my_favorites"]	= "הוסף למועדפים שלי";
$pgv_lang["gedcom_favorites"]	= "המועדפים של הקובץ הזה";
$pgv_lang["no_gedcom_favorites"]	= "כרגע אין מועדפים שנבחרו. המנהלן יכול להוסיף מועדפים שיוצגו בזמן אתחול.";
$pgv_lang["confirm_fav_remove"]	= "?האם באמת למחוק אדם זה מרשימת המועדפים שלך";
$pgv_lang["invalid_email"]		= ".הכנס כתובת דואר אלקטרוני בר תוקף";
$pgv_lang["enter_subject"]		= "הכנס נושא להודעתך";
$pgv_lang["enter_body"]		= ".מלא טכסט לפני שאתה שולח את ההודעה";
$pgv_lang["confirm_message_delete"]	= ".האם באמת למחוק הודעה זו? לא ניתן להחזיר אותה לאחר המחיקה";
$pgv_lang["message_email1"]	= "ההודעה הבאה נשלחה למשתמש ה-PhpGedView שלך מ-";
$pgv_lang["message_email2"]	= "שלחת את ההודעה הבאה למשתמש PhpGedView:";
$pgv_lang["message_email3"]	= "שלחת את ההודעה הבאה למנהלן PhpGedView:";
$pgv_lang["viewing_url"]		= "ההודעה הזו נשלחה מ-URL הבא:";
$pgv_lang["messaging2_help"]	= "לאחר שליחת הודעה זו, תקבל עותק בדואר האלקטרוני לכתובת שמסרת לנו";
$pgv_lang["random_picture"]		= "תמונה אקראית";
$pgv_lang["message_instructions"]	= "<b>שים לב:</b> נתונים אישיים של אנשים חיים נמסרים רק לקרובי משפחה וחברים קרובים. תתבקש לאשר את הקשר שלך לפני שתוכל לראות נתונים אישיים. לפעמים גם הנתונים של אנשים שנפטרו הם פרטיים מכיוון שאין מספיק מידע על האדם כדי לקבוע אם הוא חי או מת ולנו אין, כפי הנראה, מידע נוסף על האדם.<br /><br />נא בדוק את התאריכים, המקומות וקרובי המשפחה של האדם, כדי לוודא שמדובר באדם הנכון לפני פנייה אלינו. אנחנו מבקשים שתוסיף מידע על המקור שממנו השגת את הנתונים, במידה ותוסיף או תשנה נתונים.<br /><br />";
$pgv_lang["sending_to"]		= "ההודעה תשלח ל-#TO_USER#";
$pgv_lang["preferred_lang"]		= "המשתמש מעדיף לקבל הודעות בשפה #USERLANG#";
$pgv_lang["gedcom_created_using"]	= "ה-GEDCOM הזה נוצר ע\"י תוכנת <b>#CREATED_SOFTWARE# #CREATED_VERSION#</b>";
$pgv_lang["gedcom_created_on"]	= "ה-GEDCOM הזה נוצר ב-<b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_created_on2"] 	= " ב-<b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_stats"]		= "סטטיסטיקות GEDCOM";
$pgv_lang["stat_individuals"]		= "אנשים";
$pgv_lang["stat_families"]		= "משפחות";
$pgv_lang["stat_sources"]		= "מקורות";
$pgv_lang["stat_other"]		= "רשומות אחרות";
$pgv_lang["stat_earliest_birth"] 	= "שנת הלידה המוקדמת ביותר";
$pgv_lang["stat_latest_birth"] 		= "שנת הלידה המאוחרת ביותר";
$pgv_lang["stat_earliest_death"] 	= "שנת הפטירה המוקדמת ביותר";
$pgv_lang["stat_latest_death"] 	= "שנת הפטירה המאוחרת ביותר";
$pgv_lang["customize_page"]		= "MyGedView התאם אישית את הפורטל";
$pgv_lang["customize_gedcom_page"]	= "התאם אישית את דף ברוכים הבאים הזה";
$pgv_lang["upcoming_events_block"]	= "אירועים קרובים";
$pgv_lang["upcoming_events_descr"]= "אזור אירועים קרובים מראה רשימה של אירועים שיתרחשו בקרוב. תוכל לקבוע את כמות הנתונים שתראה, והמנהלן יכול לקבוע את תחום הזמן הקובע לאזור.";
$pgv_lang["todays_events_block"]	= "ביום הזה";
$pgv_lang["todays_events_descr"]	= "אזור ביום הזה - בהיסטוריה שלך ... מראה רשימה של אירועים שהתרחשו היום. אם אין אירועים, תוכל לקבוע את כמות הנתונים שתראה.";
$pgv_lang["todo_block"] 		= "&quot;משימות - To Do&quot; לביצוע";
$pgv_lang["todo_descr"] 		= "אזור &quot;משימות - To Do&quot; מציג את כל עובדות <span dir=\"ltr\">_TODO</span> שעדיין לא טופלו בקובץ ה-GEDCOM שלך.";
$pgv_lang["todo_show_other"]     	= "הראה מטלות של משתמשים אחרים";
$pgv_lang["todo_show_unassigned"]	= "הראה מטלות לא משוייכות";
$pgv_lang["todo_show_future"]    	= "הראה מטלות עתידיות";
$pgv_lang["todo_nothing"]        	= "אין &quot;משימות - To Do&quot; לביצוע.";
$pgv_lang["yahrzeit_block"]		= "ימי שנה קרובים";
$pgv_lang["yahrzeit_descr"]		= "אזור ימי שנה קרובים מראה רשימה של פטירות לפי תאריך עברי שיתרחשו בקרוב. תוכל לקבוע את התקופה שתראה, והמנהלן יכול לקבוע את תחום הזמן הקובע לאזור.";
$pgv_lang["logged_in_users_block"]	= "משתמשים מחוברים";
$pgv_lang["logged_in_users_descr"]	= "אזור משתמשים מחוברים מראה רשימה של המשתמשים המחוברים עכשיו לאתר.";
$pgv_lang["user_messages_block"]	= "הודעות המשתמש";
$pgv_lang["user_messages_descr"]	= "אזור הודעות המשתמש מראה רשימה של הודעות שנשלחו למשתמש פעיל.";
$pgv_lang["user_favorites_block"]	= "מועדפים של משתמש";
$pgv_lang["user_favorites_descr"]	= "אזור מועדפים של המשתמש מראה למשתמש רשימה של האנשים המועדפים שלו בתוך מאגר המידע כך שיוכל לעבור בקלות בעזרת הקישור אל נתוניהם.";
$pgv_lang["welcome_block"]		= "ברוכים הבאים של המשתמש";
$pgv_lang["welcome_descr"]		= "אזור ברוכים הבאים של המשתמש מראה למשתמש את היום והזמן הנוכחיים, קישורים מהירים לעדכון נתוני קוד המשתמש וקישור לתרשים אילן היוחסין שלו וקישור להתאמת דף הפורטל MyGedView.";
$pgv_lang["random_media_block"]	= "מדיה אקראית";
$pgv_lang["random_media_descr"]	= "אזור מדיה אקראית מראה בצורה אקראית תמונה או פריט מדיה אחר ממאגר הנתונים הפעיל ומציג אותו למשתמש.<br /><br />המנהלן קובע אם האזור יראה פרטי מדיה הקשורים או לאנשים או למאורעות.";
$pgv_lang["random_media_persons_or_all"] 	= "הראה רק אנשים, מאורעות, או הכול?";
$pgv_lang["random_media_persons"]	= "אנשים";
$pgv_lang["random_media_events"]	= "מאורעות";
$pgv_lang["gedcom_block"]		= "GEDCOM ברוכים הבאים";
$pgv_lang["gedcom_descr"]		= "אזור GEDCOM ברוכים הבאים פועלת בצורה דומה לאזור ברוכים הבאים של המשתמש. הוא מברך את המבקר לאתר ומראה את הכותרת של מאגר הנתונים הפעיל ואת היום והשעה הנוכחיים.";
$pgv_lang["gedcom_favorites_block"]	= "מועדפי GEDCOM";
$pgv_lang["gedcom_favorites_descr"]	= "אזור מועדפי GEDCOM מאפשר למנהלן האתר לציין אנשים במאגר הנתונים כך שכולם ימצאו אותם בקלות. זו דרך להדגיש את האנשים החשובים בהיסטורית משפחתך.";
$pgv_lang["gedcom_stats_block"]	= "סטטיסטיקות GEDCOM";
$pgv_lang["gedcom_stats_descr"]	= "אזור סטטיסטיקות GEDCOM מראה למבקרים נתונים בסיסיים על מאגר הנתונים, כמו למשל מתי הוא נוצר וכמה אנשים נכללים בו.<br /><br />הוא כולל רשימה של שמות משפחה שכיחים. ניתן לעצב את האזור לא להראות את רשימת השמות השכיחים וניתן להגדיר את ה-GEDCOM להסיר או להוסיף שמות מהרשימה. ניתן לקבוע את הסף להופעה ברשימה בהגדרת התצורה של קובץ ה-GEDCOM.";
$pgv_lang["gedcom_stats_show_surnames"] = "הראה שמות משפחה שכיחים?";
$pgv_lang["portal_config_intructions"]	= "#pgv_lang[customize_page]# <br /> #pgv_lang[customize_gedcom_page]#~<br /><br />תוכל לבצע התאמה אישית לדף ע\"י הצבת אזורים על הדף לפי רצונך.<br /><br />הדף מחולק לשני חלקים, החלק ה<b>ראשי</b> והחלק ה<b>ימני</b>. האזורים בחלק ה<b>ראשי</b> גדולים יותר ומופיעים מתחת לכותרת של הדף. החלק ה<b>ימני</b> מתחיל מימין לכותרת ויורד כלפי מטה בצד הימני של הדף.<br /><br />לכל חלק יש רשימת האזורים שלו, שיוצגו על הדף בסדר שהם רשומים. ניתן להוסיף, להוריד ולשנות את הסדר של האזורים לפי רצונך.<br /><br />אם אחת הרשימות של האזורים ריקה, האזורים הנותרים תופסים את כל רוחב הדף.<br /><br />";
$pgv_lang["login_block"]		= "התחברות";
$pgv_lang["login_descr"]		= "אזור התחברות מקבל קוד משתמש וסיסמא עבור התחברות משתמשים לאתר.";
$pgv_lang["theme_select_block"]	= "בחירת עיצוב";
$pgv_lang["theme_select_descr"]      	= "האזור לבחירת עיצוב מציג את תיבת הבחירה גם אם שינוי העיצוב אינו פעיל.";
$pgv_lang["block_top10_title"]          	= "עשרת השמות השכיחים";
$pgv_lang["block_top10"]                	= "עשרת השמות השכיחים ";
$pgv_lang["block_top10_descr"]    	= "האזור מציג טבלה של 10 שמות המשפחה השכיחים במאגר הנתונים. ניתן לשנות את המספר של שמות המשפחה שמוצגים באזור. ניתן לקבוע הגדרות בתצורת ה-GEDCOM כך ששמות מסוימים לא יופיעו ברשימה.";
$pgv_lang["block_givn_top10_title"]	= "עשרת השמות הפרטיים השכיחים";
$pgv_lang["block_givn_top10"]	= "עשרת השמות הפרטיים השכיחים";
$pgv_lang["block_givn_top10_descr"] = "האזור מציג טבלה של 10 שמות פרטיים השכיחים במאגר הנתונים. ניתן לשנות את המספר של השמות הפרטיים שמוצגים באזור.";

$pgv_lang["gedcom_news_block"]	= "חדשות GEDCOM";
$pgv_lang["gedcom_news_descr"]	= "אזור החדשות של GEDCOM מראה למבקר חדשות או כתבות שהמנהלן העלה למערכת.<br /><br />אזור החדשות הוא מקום טוב להודיע על עדכון מאגר הנתונים,  על מפגש משפחתי או על לידת ילד.";
$pgv_lang["gedcom_news_limit"]	= "הגבל את התצוגה לפי:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "אין הגבלה";
$pgv_lang["gedcom_news_limit_date"]	= "גיל הכניסה";
$pgv_lang["gedcom_news_limit_count"]	= "מספר כניסות";
$pgv_lang["gedcom_news_flag"]	= "גבול:";
$pgv_lang["gedcom_news_archive"] 	= "הצג ארכיון";
$pgv_lang["user_news_block"]	= "יומן המשתמש";
$pgv_lang["user_news_descr"]	= "אזור יומן המשתמש מאפשר למשתמש לשמור הערות או כניסות יומן בתוך המערכת.";
$pgv_lang["my_journal"]		= "היומן שלי";
$pgv_lang["no_journal"]		= "לא יצרת שום פריט יומן.";
$pgv_lang["confirm_journal_delete"]	= "האם באמת למחוק את כניסת היומן הזו?";
$pgv_lang["add_journal"]		= "הוסף כניסת יומן חדשה";
$pgv_lang["gedcom_news"]		= "חדשות";
$pgv_lang["confirm_news_delete"]	= "האם באמת למחוק את כניסת החדשות הזו?";
$pgv_lang["add_news"]		= "הוסף מאמר חדשות";
$pgv_lang["no_news"]			= "לא הגשת מאמרי חדשות.";
$pgv_lang["edit_news"]		= "הוסף/ערוך כניסת יומן/חדשות";
$pgv_lang["enter_title"]		= "נא הכנס כותרת.";
$pgv_lang["enter_text"]		= "נא מלא טכסט עבור כניסת חדשות או יומן זו.";
$pgv_lang["news_saved"]		= "כניסת יומן/חדשות נשמרה בהצלחה.";
$pgv_lang["article_text"]		= "טכסט הכניסה:";
$pgv_lang["main_section"]		= "האזורים הראשיים";
$pgv_lang["right_section"]		= "האזורים הימניים";
$pgv_lang["available_blocks"]		= "האזורים הזמינים";
$pgv_lang["move_up"]			= "העבר למעלה";
$pgv_lang["move_down"]		= "העבר למטה";
$pgv_lang["move_right"]		= "העבר שמאלה";
$pgv_lang["move_left"]		= "העבר ימינה";
$pgv_lang["broadcast_all"]		= "שדר לכל המשתמשים";
$pgv_lang["hit_count"]			= "ספירת פגיעות:";
$pgv_lang["phpgedview_message"]	= "PhpGedView הודעת";
$pgv_lang["common_surnames"]	= "שמות משפחה שכיחים";
$pgv_lang["default_news_title"]	= "ברוכים הבאים לחקר שושלת היוחסין שלך";
$pgv_lang["default_news_text"]	= "נתוני חקר שושלת יוחסין באתר זה ממונעים ע\"י <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView</a>. הדף הזה מספק הקדמה וסקירה כללית לחקר שושלת יוחסין זו.<br /><br />כדי להתחיל לעבוד על הנתונים, בחר אחד התרשימים מתפריט התרשימים, לך לרשימת שמות או חפש שם או מקום.<br /><br />במידה ויהיו לך בעיות להשתמש באתר, לחיצה על צלמית העזרה תיתן לך מידע על ה שימוש בדף שהנך רואה עכשיו.<br /><br />תודה על הביקור שלך באתר זה.";
$pgv_lang["reset_default_blocks"]	= "החזר את האזורים למצב ברירת המחדל";
$pgv_lang["recent_changes"]	= "השינויים האחרונים";
$pgv_lang["recent_changes_block"]	= "השינויים האחרונים";
$pgv_lang["recent_changes_descr"]	= "אזור השינויים האחרונים מציג את כל השינויים שנעשו למאגר המידע בחודש האחרון. האזור יעזור לך להיות מעודכן לגבי השינויים. השינויים מוצגים על סמך נתון CHAN (תאריך השינוי האחרון) שמוגדר בתקן של ה-GEDCOM.";
$pgv_lang["recent_changes_none"]	= "<b>לא היו שינויים במשך #pgv_lang[global_num1]# הימים האחרונים.</b><br />";
$pgv_lang["recent_changes_some"]	= "<b>שינויים שבוצעו תוך #pgv_lang[global_num1]# הימים האחרונים</b><br />";
$pgv_lang["show_empty_block"]	= "האם להחביא את האזור כאשר הוא ריק?";
$pgv_lang["hide_block_warn"]	= "אם תסתיר אזור ריק, לא תוכל לשנות את ההגדרות שלו כל עוד הוא ריק ומוסתר.";
$pgv_lang["delete_selected_messages"]	= "בטל את ההודעות הנבחרות";
$pgv_lang["use_blocks_for_default"]	= "האם להשתמש באזורים הללו כהגדרה של אזורי ברירת מחדל לכל המשתמשים?";
$pgv_lang["block_not_configure"]	= "לא ניתן להגדיר את האזור הזה.";

//-- validate GEDCOM
$pgv_lang["add_media_tool"]		= "כלי להוספת פרט מדיה חדש";

//-- hourglass chart
$pgv_lang["hourglass_chart"]		= "תרשים שעון חול";

//-- report engine
$pgv_lang["choose_report"]		= "בחר דו\"ח להרצה";
$pgv_lang["enter_report_values"]	= "הכנס ערכי הדו\"ח";
$pgv_lang["selected_report"]		= "דו\"ח נבחר";
$pgv_lang["select_report"]		= "בחר דו&quot;ח";
$pgv_lang["download_report"]		= "הורד דו&quot;ח";
$pgv_lang["reports"]                		= "דו\"חות";
$pgv_lang["pdf_reports"]            	= "דו\"חות PDF";
$pgv_lang["html_reports"]          	= "דו\"חות HTML";

//-- Ahnentafel report
$pgv_lang["ahnentafel_report"]	= "דו\"ח טבלת אבות";
$pgv_lang["ahnentafel_header"]	= "דו\"ח טבלת אבות עבור ";
$pgv_lang["ahnentafel_generation"]	= "דור ";
$pgv_lang["ahnentafel_pronoun_m"]	= "הוא ";
$pgv_lang["ahnentafel_pronoun_f"]	= "היא ";
$pgv_lang["ahnentafel_born_m"]	= "נולד";		// male
$pgv_lang["ahnentafel_born_f"]	= "נולדה";		// female
$pgv_lang["ahnentafel_christened_m"] 	= "הוטבל";	// male
$pgv_lang["ahnentafel_christened_f"] = "הוטבלה";		// female
$pgv_lang["ahnentafel_married_m"]	= "התחתן עם";		// male
$pgv_lang["ahnentafel_married_f"]	= "התחתנה עם";		// female
$pgv_lang["ahnentafel_married_post"]= "&nbsp;";
$pgv_lang["ahnentafel_died_m"]	= "נפטר";		// male
$pgv_lang["ahnentafel_died_f"]	= "נפטרה";	    	// female
$pgv_lang["ahnentafel_buried_m"]	= "נקבר";		// male
$pgv_lang["ahnentafel_buried_f"]	= "נקברה";		// female
$pgv_lang["ahnentafel_place"]	= " ב-";			// place name follows this
$pgv_lang["ahnentafel_no_details"]	= " אבל הפרטים אינם ידועים";
$pgv_lang["ahnentafel_on"]		= " בתאריך";

//-- Changes report
$pgv_lang["changes_report"]		= "דו\"ח שינויים";
$pgv_lang["changes_pending_tot"]	= "סה\"כ שינויים ממתינים: ";
$pgv_lang["changes_accepted_tot"]	= "סה\"כ שינויים שהתקבלו: ";

//-- Descendancy report
$pgv_lang["descend_report"]		= "דו\"ח צאצאים";
$pgv_lang["descendancy_header"]	= "דו\"ח צאצאים עבור ";
$pgv_lang["son_of"]			= "בן של";
$pgv_lang["daughter_of"]		= "בת של";
$pgv_lang["child_of"]			= "ילד/ה של ";
$pgv_lang["children_of"]		= "ילדים של ";
$pgv_lang["descendancy_pronoun_m"]	= "הוא ";
$pgv_lang["descendancy_pronoun_f"]	= "היא ";

$pgv_lang["family_group_report"]    	= "דו\"ח קבוצת המשפחה";
$pgv_lang["page"]                   		= "דף";
$pgv_lang["of"]                     		= "מתוך";
$pgv_lang["enter_famid"]            	= "הכנס קוד זיהוי של המשפחה";
$pgv_lang["show_sources"]           	= "הצג מקורות?";
$pgv_lang["show_notes"]             	= "הצג הערות?";
$pgv_lang["show_basic"]             	= "הדפס אירועים בסיסיים ריקים?";
$pgv_lang["show_photos"]		= "הראה תמונות?";
$pgv_lang["relatives_report_ext"]	= "דו\"ח קרובים מורחב";
$pgv_lang["with"]			= "עם";
$pgv_lang["on"]			= "ב-";			// for precise dates
$pgv_lang["in"]				= "ב-";			// for imprecise dates
$pgv_lang["individual_report"]		= "דו\"ח אישי";
$pgv_lang["individual_with_rela_report"] = "דו\"ח קרובים";
$pgv_lang["enter_pid"]		= "הכנס קוד זיהוי אישי";
$pgv_lang["generated_by"]		= "נוצר ע\"י";
$pgv_lang["list_children"]		= "הצג ילדים לפי תאריך לידה.";
$pgv_lang["birth_report"]		= "דו\"ח תאריכי ומקומות לידה";
$pgv_lang["birthplace"]		= "מקום הלידה כולל";
$pgv_lang["birthdate1"]		= "תחילת תחום תאריכי לידה";
$pgv_lang["birthdate2"]		= "סיום תחום תאריכי לידה";
$pgv_lang["death_report"]		= "דו\"ח תאריך ומקום פטירה";
$pgv_lang["deathplace"]		= "מקום הפטירה כולל";
$pgv_lang["deathdate1"]		= "תחילת תחום תאריך פטירה";
$pgv_lang["deathdate2"]		= "סוף תחום תאריך פטירה";
$pgv_lang["marr_report"]		= "דו\"ח תאריך ומקום נישואין";
$pgv_lang["marrplace"]		= "מקום הנישואין מכיל";
$pgv_lang["marrdate1"]		= "התחלת תחום תאריכי נישואין";
$pgv_lang["marrdate2"]		= "סיום תחום תאריכי נישואין";
$pgv_lang["sort_by"]			= "מיין לפי";
$pgv_lang["cemetery_report"]		= "דו\"ח בתי קברות";
$pgv_lang["burialplace"]		= "מקום קבורה מכיל";
$pgv_lang["fact_sources_report"]	= "מקורות של עובדות";
$pgv_lang["missing_facts_report"]	= "עובדות חסרות של קרובים";
$pgv_lang["sources_to_events"]	= "מקורות לעובדות";

$pgv_lang["cleanup"]			= "ניקיון";

//-- CONFIGURE (extra) messages for programs patriarch and statistics
$pgv_lang["statistics"] 			= "סטטיסטיקות";
$pgv_lang["show_stats_charts"]	= "הראה תרשימי סטטיסטיקות";
$pgv_lang["decade_birth"]		= "עשור של הלידה";
$pgv_lang["decade_death"]		= "עשור של הפטירה";
$pgv_lang["decade_marriage"]	= "עשור של הנשואים";
$pgv_lang["avg_age"]			= "גיל ממוצע";

//-- Merge Records
$pgv_lang["merge_same"]                   = "הרשומות אינן מסוג זהה. לא ניתן למזג רשומות מסוגים שונים.";
$pgv_lang["merge_step1"]                	= "שלב מיזוג 1 מתוך 3";
$pgv_lang["merge_step2"]                	= "שלב מיזוג 2 מתוך 3";
$pgv_lang["merge_step3"]                	= "שלב מיזוג 3 מתוך 3";
$pgv_lang["select_gedcom_records"] 	= "בחר שתי רשומות GEDCOM למיזוג. הרשומות חייבות להיות מאותו סוג.";
$pgv_lang["merge_to"]                        	= "מזג לקוד זיהוי:";
$pgv_lang["merge_from"]                    	= "מזג מקוד זיהוי:";
$pgv_lang["merge_facts_same"]        	= "העובדות הבאות זהות בשתי הרשומות וימוזגו בצורה אוטומטית.";
$pgv_lang["no_matches_found"]        	= "אין עובדות מתאימות";
$pgv_lang["unmatching_facts"]        	= "העובדות הבאות אינן זהות. בחר את המידע שברצונך לשמור.";
$pgv_lang["record"]   			= "רשומה";
$pgv_lang["adding"]        		= "מוסיף";
$pgv_lang["updating_linked"]        	= "מעדכן רשומה קשורה";
$pgv_lang["merge_more"]		= "מזג רשומות נוספות.";
$pgv_lang["same_ids"]                        	= "הכנסת קוד זיהוי זהה. לא ניתן למזג רשומה זהה.";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"] 		= "תרשים שושלת";
$pgv_lang["gen_ancestry_chart"]  	= "תרשים שושלת של #PEDIGREE_GENERATIONS# דורות";
$pgv_lang["chart_style"]    	     	= "סגנון תרשים";
$pgv_lang["chart_list"]			= "רשימה";
$pgv_lang["chart_booklet"]   		= "ספרון";
$pgv_lang["show_cousins"]		= "הראה בני דוד";
// 1st generation
$pgv_lang["sosa_2"] 		= "אבא";
$pgv_lang["sosa_3"] 		= "אמא";
// 2nd generation
$pgv_lang["sosa_4"] 		= "סבא";
$pgv_lang["sosa_5"] 		= "סבתא";
$pgv_lang["sosa_6"] 		= "סבא";
$pgv_lang["sosa_7"] 		= "סבתא";
// 3rd generation
$pgv_lang["sosa_8"] 		= "סבא רבא";
$pgv_lang["sosa_9"] 		= "סבתא רבתא";
$pgv_lang["sosa_10"]		= "סבא רבא";
$pgv_lang["sosa_11"]		= "סבתא רבתא";
$pgv_lang["sosa_12"]		= "סבא רבא";
$pgv_lang["sosa_13"]		= "סבתא רבתא";
$pgv_lang["sosa_14"]		= "סבא רבא";
$pgv_lang["sosa_15"]		= "סבתא רבתא";
// 4th generation
$pgv_lang["sosa_16"]               	= "N/A";
$pgv_lang["sosa_17"]               	= "N/A";
$pgv_lang["sosa_18"]               	= "N/A";
$pgv_lang["sosa_19"]             		= "N/A";
$pgv_lang["sosa_20"]               	= "N/A";
$pgv_lang["sosa_21"]               	= " רבתא";
$pgv_lang["sosa_22"]               	= " רבא";
$pgv_lang["sosa_23"]               	= " של ";
$pgv_lang["sosa_24"]               	= "N/A";
$pgv_lang["sosa_25"]               	= "N/A";
$pgv_lang["sosa_26"]               	= "N/A";
$pgv_lang["sosa_27"]               	= "N/A";
$pgv_lang["sosa_28"]               	= "N/A";
$pgv_lang["sosa_29"]               	= "N/A";
$pgv_lang["sosa_30"]               	= "N/A";
$pgv_lang["sosa_31"]               	= "N/A";

// for the general case of ancestors of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["sosa_paternal_male_n_generations"]	= "סבא רבא מדרגה %2\$d";
$pgv_lang["sosa_paternal_female_n_generations"]	= "סבתא רבתא מדרגה %2\$d";
$pgv_lang["sosa_maternal_male_n_generations"]	= "סבא רבא מדרגה %2\$d";
$pgv_lang["sosa_maternal_female_n_generations"]	= "סבתא רבתא מדרגה %2\$d";

//-- FAN CHART
$pgv_lang["compact_chart"]		= "תרשים קומפקטי";
$pgv_lang["fan_chart"]			= "תרשים מניפה";
$pgv_lang["gen_fan_chart"]    		= "תרשים מניפה של #PEDIGREE_GENERATIONS# דורות";
$pgv_lang["fan_width"]		= "רוחב";
$pgv_lang["gd_library"]		= "בעיית קונפיגורציה של שרת ה-PHP: תיקיית GD 2.x דרושה כדי להשתמש בפונקציות התמונה.";
$pgv_lang["gd_freetype"]		= "בעיית קונפיגורציה של שרת ה-PHP: תיקיית Freetype דרושה כדי להשתמש בפונטי TrueType.";
$pgv_lang["gd_helplink"]		= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]   		= "הפונט לא נמצא על שרת ה-PHP";
$pgv_lang["fanchart_IE"]		= "לא ניתן להדפיס את תרשים המניפה הזה מהדפדפן שלך. השתמש בקליק הימני ושמור והדפס אח\"כ.";

//-- RSS Feed
$pgv_lang["rss_descr"]		= "חדשות וקישורים מאתר ה-#GEDCOM_TITLE# ";
$pgv_lang["rss_logo_descr"]		= "ההזנה נוצרה ע\"י PhpGedView";
$pgv_lang["rss_feeds"]		= "הזנות RSS";
$pgv_lang["no_feed_title"]		= "ההזנה אינה זמינה";
$pgv_lang["no_feed"]			= "אין הזנת RSS זמינה לאתר ה-PhpGedView הזה";
$pgv_lang["feed_login"]		= "אם לך יש קוד משתמש באתר PhpGedView זה, תוכל להתחבר לשרת <a href=\"#AUTH_URL#\"> log in</a> ע\"י שימוש באימות בסיסי של HTTP כדי לראות נתונים פרטיים";
$pgv_lang["authenticated_feed"]	= "הזנה מאושרת";

//-- ASSOciates RELAtionship http://www.geocities.com/safa_ivrit/people/relatives.html
// After any change in the following list, please check $assokeys in gdbi_interface.php
$pgv_lang["attendant"] 		= "משגיח";
$pgv_lang["attending"] 		= "אחראי";
$pgv_lang["best_man"] 		= "שושבין";
$pgv_lang["bridesmaid"] 		= "שושבינה";
$pgv_lang["buyer"] 			= "קונה";
$pgv_lang["circumciser"] 		= "מוהל";
$pgv_lang["civil_registrar"] 		= "רשם אזרחי";
$pgv_lang["employee"] 		= "מעביד";
$pgv_lang["employer"] 		= "עובד";
$pgv_lang["foster_child"] 		= "ילד מאומץ";
$pgv_lang["foster_father"] 		= "אב מאמץ";
$pgv_lang["foster_mother"] 		= "אם מאמצת";
$pgv_lang["friend"] 			= "חבר/ה";
$pgv_lang["godfather"] 		= "סנדק";
$pgv_lang["godmother"] 		= "סנדק";
$pgv_lang["godparent"] 		= "סנדק";
$pgv_lang["godson"]			= "בן-סנדקאות‬";
$pgv_lang["goddaughter"] 		= "בת-סנדקאות‬";
$pgv_lang["godchild"]			= "ילד-סנדקאות‬";
$pgv_lang["guardian"]			= "אפוטרופוס";
$pgv_lang["informant"] 		= "מוסר מידע";
$pgv_lang["lodger"] 			= "דייר";
$pgv_lang["nanny"] 			= "מטפלת";
$pgv_lang["nurse"] 			= "אחות מטפלת";
$pgv_lang["owner"] 			= "בעלים";
$pgv_lang["priest"] 			= "כומר";
$pgv_lang["rabbi"] 			= "רב";
$pgv_lang["registry_officer"] 		= "ממונה על רישום";
$pgv_lang["seller"] 			= "מוכר";
$pgv_lang["servant"] 			= "משרת";
$pgv_lang["slave"] 			= "עבד";
$pgv_lang["twin"] 			= "תאום/תאומה";
$pgv_lang["twin_brother"] 		= "אח תאום";
$pgv_lang["twin_sister"] 		= "אחות תאומה";
$pgv_lang["ward"] 			= "חניך";
$pgv_lang["witness"] 			= "עד";

//-- statistics utility
$pgv_lang["stat_create"]		= "צור תרשים אישי";
$pgv_lang["statutci"]			= "לא ניתן ליצור אינדקס";
$pgv_lang["statnnames"]                	= "סה\"כ אנשים";
$pgv_lang["statnfam"]                  	= "סה\"כ משפחות";
$pgv_lang["statnmale"]                	= "סה\"כ זכרים";
$pgv_lang["statnfemale"]              	= "סה\"כ נקבות";
$pgv_lang["with_sources"]		= "עם מקורות";
$pgv_lang["without_sources"]		= "ללא מקורות";
$pgv_lang["stat_sindi"]		= "אנשים עם מקורות";
$pgv_lang["stat_sfam"]		= "משפחות עם מקורות";
$pgv_lang["statvars"]			= "מלא את הערכים הבאים עבור התרשים";
$pgv_lang["statlxa"]			= "בחר סוג תרשים:";
$pgv_lang["statlya"]			= "תוצאות:";
$pgv_lang["statlza"]			= "סוגים:";
$pgv_lang["map_type"]		= "סוג מפה";
$pgv_lang["stat_1_map"]		= "התפלגות אישית";
$pgv_lang["stat_2_map"]		= "לידה לפי ארץ";
$pgv_lang["stat_3_map"]		= "פטירה לפי ארץ";
$pgv_lang["stat_4_map"]		= "נישואין לפי ארץ";
$pgv_lang["stat_5_birth"]		= "לידות לפי מאה";
$pgv_lang["stat_6_death"]		= "פטירות לפי מאה";
$pgv_lang["stat_7_marr"]		= "נישואין לפי מאה";
$pgv_lang["stat_7_div"]		= "גרושים לפי מאה";
$pgv_lang["stat_8_fam"]		= "משפחות עם מקורות";
$pgv_lang["stat_9_indi"]		= "אנשים עם מקורות";
$pgv_lang["stat_10_none"]		= "כלום";
$pgv_lang["stat_11_mb"]		= "חודש לידה";
$pgv_lang["stat_12_md"]		= "חודש פטירה";
$pgv_lang["stat_13_mm"]		= "חודש הנישואין";
$pgv_lang["stat_14_mb1"]		= "חודש של לידת הילד/ה הראשון/נה ביחס";
$pgv_lang["stat_15_mm1"]		= "חודש הנישואין הראשונים";
$pgv_lang["stat_16_mmb"]		= "חודשים בין נישואין לילד הראשון";
$pgv_lang["stat_17_arb"]		= "גיל ביחס לשנת לידה";
$pgv_lang["stat_18_ard"]		= "גיל ביחס לשנת פטירה";
$pgv_lang["stat_18_aard"]		= "הגיל הממוצע ביחס למאת פטירה";
$pgv_lang["stat_19_arm"]		= "גיל בשנת הנישואין";
$pgv_lang["stat_19_aarm"]		= "הגיל הממוצע ביחס למאת הנישואין";
$pgv_lang["stat_20_arm1"]		= "גיל בנישואין הראשונים";
$pgv_lang["stat_21_nok"]		= "מספר ילדים";
$pgv_lang["stat_22_fwok"]		= "מספר המשפחות ללא ילדים";
$pgv_lang["stat_200_none"]		= "הכול (או ריק)";
$pgv_lang["stat_201_num"]		= "ספרות";
$pgv_lang["stat_202_perc"]		= "אחוז";
$pgv_lang["stat_300_none"]		= "כלום";
$pgv_lang["stat_301_mf"]		= "מגדר";
$pgv_lang["stat_302_cgp"]		= "תקופות - סמן הערכים של תקופות על ציר ה-x";
$pgv_lang["century"]			= "מאה";
$pgv_lang["stat_age"]			= "גיל";
$pgv_lang["no_date_fam"]		= "לא ידוע";
$pgv_lang["statar_xgp"]		= "גבולות לתקופות:";
$pgv_lang["statar_xgl"]		= "גבולות לגילים:";
$pgv_lang["statar_xgm"]		= "גבולות לחודשים:";
$pgv_lang["statar_xga"]		= "גבולות למספרים:";
$pgv_lang["statar_zgp"]		= "גבולות לתקופות:";
$pgv_lang["less"]			= "פחות מ-";
$pgv_lang["over"]			= "מעל";
$pgv_lang["interval"]			= "מרווח";
$pgv_lang["aft_marr"]			= "חודשים אחרי הנישואין";
$pgv_lang["bef_marr"]			= "חודשים לפני ואחרי הנישואין";
$pgv_lang["quarters"]			= "רבעונים אחרי הנישואין";
$pgv_lang["half_year"]			= "חצי שנה אחרי הנישואין";
$pgv_lang["one_child"]		= "מרווח ילד אחד";
$pgv_lang["two_children"]		= "מרווח שני ילדים";
$pgv_lang["statreset"]			= "ברירת מחדל";
$pgv_lang["statsubmit"]		= "הצג תרשים";
$pgv_lang["stat_largest_families"] 	= "המשפחות הגדולות";

$pgv_lang["stat_own_charts"]		= "תרשימים אישיים"; 
$pgv_lang["statnliving"]		= "סה\"כ חיים";
$pgv_lang["statndead"]		= "סה\"כ מתים";
$pgv_lang["stat_births"]		= "סה\"כ לידות";
$pgv_lang["stat_marriages"]		= "סה\"כ נישואין";
$pgv_lang["stat_divorces"]		= "סה\"כ גירושים";
$pgv_lang["stat_deaths"]		= "סה\"כ פטירות";
$pgv_lang["stat_first_birth"]		= "לידה מוקדמת";
$pgv_lang["stat_first_marriage"]	= "נישואין מוקדמים";
$pgv_lang["stat_first_divorce"]	= "גירושים מוקדמים";
$pgv_lang["stat_first_death"]		= "פטירה מוקדמת";
$pgv_lang["stat_last_birth"]		= "לידה אחרונה";
$pgv_lang["stat_last_marriage"]	= "נישואין אחרונים";
$pgv_lang["stat_last_divorce"]		= "גירושים אחרונים";
$pgv_lang["stat_last_death"]		= "פטירה אחרונה";
$pgv_lang["stat_lifespan"]		= "תוחלת החיים";
$pgv_lang["stat_lived_longest"]	= "הגיל הגבוה בפטירה";
$pgv_lang["stat_live_longest"]		= "אנשים שחיים הכי הרבה זמן";
$pgv_lang["stat_marr_age"]		= "גיל הנישואין";
$pgv_lang["stat_long_marr_age"]	= "הנישואין הארוכים";
$pgv_lang["stat_short_marr_age"]	= "הנישואין הקצרים";
$pgv_lang["stat_youngest_male"]	= "הזכר הצעיר";
$pgv_lang["stat_youngest_female"]	= "הנקבה הצעירה";
$pgv_lang["stat_oldest_male"]	= "הזכר המבוגר";
$pgv_lang["stat_oldest_female"]	= "הנקבה המבוגרת";
$pgv_lang["stat_childbirth_age"]	= "גיל בלידת בן/בת";
$pgv_lang["stat_youngest_father"]	= "האב הצעיר";
$pgv_lang["stat_youngest_mother"]	= "האם הצעירה";
$pgv_lang["stat_oldest_father"]	= "האב המבוגר";
$pgv_lang["stat_oldest_mother"]	= "האם המבוגרת";
$pgv_lang["stat_children_in_fam"]	= "הילדים במשפחה";
$pgv_lang["stat_largest_gfamilies"]	= "משפחת הסבים הגדולה";
$pgv_lang["stat_age_difference"]	= "הבדל גילים";
$pgv_lang["stat_age_siblings"]	= "גיל בין אחים";
$pgv_lang["stat_top_age_siblings"]	= "גיל הגדול בין אחים";
$pgv_lang["stat_age_mf_spouse"]	= "גיל בין בעל ואישה";
$pgv_lang["stat_age_fm_spouse"]	= "גיל בין אישה ובעל";
$pgv_lang["stat_names"]		= "שמות";
$pgv_lang["statnsurnames"]		= "סה\"כ שמות משפחה";
$pgv_lang["statngivennames"]		= "סה\"כ שמות פרטיים";
$pgv_lang["top_surnames"]		= "שמות המשפחה הנפוצים";
$pgv_lang["top_givennames"]		= "שמות הפרטיים הנפוצים";
$pgv_lang["events"]			= "אירועים";
$pgv_lang["stat_records"]		= "רשומות";
$pgv_lang["stat_notes"]		= "הערות";
$pgv_lang["stat_first_event"]		= "אירוע ראשון";
$pgv_lang["stat_last_event"]		= "אירוע אחרון";
$pgv_lang["stat_places"]		= "מקומות";
$pgv_lang["stat_birth_places"]	= "מקומות לידה";
$pgv_lang["stat_marriage_places"]	= "מקומות נישואין"; //->hatuna?
$pgv_lang["stat_death_places"]	= "מקומות פטירה";
$pgv_lang["stat_countries"]		= "אירועים בארצות";

//-- statisticsplot utility
$pgv_lang["statistiek_list"]		= "תרשים סטטיסטי";
$pgv_lang["stpl"]			= "...";
$pgv_lang["stplinfo"]			= "נתוני תרשים:";
$pgv_lang["stpltype"]			= "סוג:";
$pgv_lang["stplnoim"]			= " לא מיושם:";
$pgv_lang["stplmf"]			= " למגדר";
$pgv_lang["stplipot"]			= " בתקופת זמן";
$pgv_lang["stplmonth"]		= "חודש";
$pgv_lang["stplnumbers"]		= "ספרות";
$pgv_lang["stplnuch"]			= "ילדים";
$pgv_lang["stplage"]			= "גיל";
$pgv_lang["stplperc"]			= "אחוז";
$pgv_lang["stplnumof"]		= "מונים ";
$pgv_lang["stplmarrbirth"]		= "חודשים מהחתונה להולדת הילד הראשון";
$pgv_lang["indi_distribution_chart"]	= "תרשים התפלגות אנשים";
$pgv_lang["surname_distribution_chart"]	= "תרשים התפלגות שמות משפחה";
$pgv_lang["g_chart_high"]		= "האוכלוסיה הגדולה ביותר";
$pgv_lang["g_chart_low"]		= "האוכלוסיה הקטנה ביותר";
$pgv_lang["g_chart_nobody"]		= "אף אחד";
$pgv_lang["area_chart"]		= "אזור גוגראפי";
$pgv_lang["europe_chart"]		= "אירופה";
$pgv_lang["s_america_chart"]		= "דרום אמריקה";
$pgv_lang["asia_chart"]		= "אסיה";
$pgv_lang["middle_east_chart"]	= "מזרח התיכון";
$pgv_lang["africa_chart"]		= "אפריקה";
$pgv_lang["world_chart"]		= "עולם";
//-- alive in year
$pgv_lang["alive_in_year"]		= "רשימת חי בשנה";
$pgv_lang["is_alive_in"]		= "חי ב-#YEAR# ";
$pgv_lang["alive"]			= "חי ";
$pgv_lang["dead"]			= "מת ";
$pgv_lang["maybe"]			= "אולי ";
$pgv_lang["both_alive"]		= "שניהם חיים ";
$pgv_lang["both_dead"]		= "שניהם מתים ";

//-- Help system
$pgv_lang["definitions"]		= "הגדרות";

//-- Index_edit
$pgv_lang["block_desc"]		= "תיאורי אזורים";
$pgv_lang["click_here"]		= "לחץ כאן כדי להמשיך";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br /><br />לחץ על כפתור זה כדי לשמור את השינויים שלך.<br /><br />תוחזר לדף #pgv_lang[welcome]# או לדף #pgv_lang[mygedview]#, אבל יתכן שהשינויים שלך לא יוצגו. יתכן שעליך להשתמש בפונקצית רענון תצוגה של הדפדפן כדי שהשינויים שלך יוצגו.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br />כאן תמצא תאור קצר של כל אזור שניתן לשים על דף ה#pgv_lang[welcome]# או #pgv_lang[mygedview]#.<br /><table border='1' align='center'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#pgv_lang[block_summary_table]#</table><br /><br />";
// Built in index_edit.php
$pgv_lang["block_summary_table"]	= "&nbsp;";

//-- Find page
$pgv_lang["total_places"]		= "נמצאו מקומות";
$pgv_lang["media_contains"]		= "מדיה מכילה:";
$pgv_lang["repo_contains"]		= "מאגר מכיל:";
$pgv_lang["shared_note_contains"]	= "ההערה המשותפת מכילה:";
$pgv_lang["source_contains"]		= "מקור מכיל:";
$pgv_lang["display_all"]		= "הצג הכול";

//-- accesskey navigation
$pgv_lang["accesskeys"]				= "קיצורי לוח המקשים";
$pgv_lang["accesskey_skip_to_content"]		= "ת"; //C
$pgv_lang["accesskey_search"]			= "ח"; //S
$pgv_lang["accesskey_skip_to_content_desc"]	= "דלג לתוכן";
$pgv_lang["accesskey_viewing_advice"]		= "0";
$pgv_lang["accesskey_viewing_advice_desc"]	= "עצת הסתכלות";
$pgv_lang["accesskey_home_page"]			= "1";
$pgv_lang["accesskey_help_content"]		= "2";
$pgv_lang["accesskey_help_current_page"]		= "3";
$pgv_lang["accesskey_contact"]			= "4";

$pgv_lang["accesskey_individual_details"]		= "ע"; //I
$pgv_lang["accesskey_individual_relatives"]		= "מ"; //R
$pgv_lang["accesskey_individual_notes"]		= "ה"; //N
$pgv_lang["accesskey_individual_sources"]		= "ק"; //O

$pgv_lang["accesskey_individual_media"]		= "ד"; //A clash with IE addBookmark but not a likely problem
$pgv_lang["accesskey_individual_research_log"]	= "י";  //L
$pgv_lang["accesskey_individual_pedigree"]		= "א"; //P
$pgv_lang["accesskey_individual_descendancy"]	= "צ"; //D
$pgv_lang["accesskey_individual_timeline"]		= "ו";  //T
$pgv_lang["accesskey_individual_relation_to_me"]	= "ר"; //M

$pgv_lang["accesskey_individual_gedcom"]		= "ג"; //G clash with rarely used Netscape/Mozilla Go menu

$pgv_lang["accesskey_family_parents_timeline"]	= "א"; //P
$pgv_lang["accesskey_family_children_timeline"]	= "צ"; //D
$pgv_lang["accesskey_family_timeline"]		= "ו";  //T

$pgv_lang["accesskey_family_gedcom"]		= "ג"; //G clash with rarely used English Netscape/Mozilla English Go menu

// FAQ Page
$pgv_lang["add_faq_header"] 	= "כותרת ה-FAQ";
$pgv_lang["add_faq_body"] 		= "גוף ה-FAQ";
$pgv_lang["add_faq_order"] 		= "מיקום ה-FAQ";
$pgv_lang["add_faq_visibility"] 	= "היכן ה-FAQ פעיל";
$pgv_lang["no_faq_items"] 		= "רשימת ה-FAQ-ים ריקה.";
$pgv_lang["position_item"] 		= "מיקום ישות";
$pgv_lang["faq_list"] 			= "רשימת שאלות נפוצות (FAQ)";
$pgv_lang["confirm_faq_delete"] 	= "האם הנך בטוח שברצונך למחוק כניסת ה-FAQ הזה";
$pgv_lang["preview"] 			=  "הצגה מוקדמת";
$pgv_lang["no_id"] 			= "קוד זיהוי של FAQ לא מפורט!";

// Help search
$pgv_lang["hs_title"] 			= "חפש טכסט עזרה";
$pgv_lang["hs_search"] 		= "חפש";
$pgv_lang["hs_close"] 		= "סגור חלון";
$pgv_lang["hs_results"] 		= "נמצאו תוצאות:";
$pgv_lang["hs_keyword"] 		= "חפש את";
$pgv_lang["hs_searchin"]		= "חפש ב-";
$pgv_lang["hs_searchuser"]		= "עזרה למשתמשים";
$pgv_lang["hs_searchmodules"]	= "עזרה במודולים";
$pgv_lang["hs_searchconfig"]		= "עזרה למנהלנים";
$pgv_lang["hs_searchhow"]		= "סוג חיפוש";
$pgv_lang["hs_searchall"]		= "כל המילים";
$pgv_lang["hs_searchany"]		= "מילה כלשהיא";
$pgv_lang["hs_searchsentence"]	= "ביטוי מדויק";
$pgv_lang["hs_intruehelp"]		= "טכסט עזרה בלבד";
$pgv_lang["hs_inallhelp"]		= "כל הטכסט";

// Media import
$pgv_lang["choose"] 			= "בחר: ";
$pgv_lang["account_information"] 	= "נתוני קוד משתמש";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"] 			= "אודיו";
$pgv_lang["TYPE__book"] 			= "ספר";
$pgv_lang["TYPE__card"] 			= "כרטיס";
$pgv_lang["TYPE__certificate"] 		= "תעודה";
$pgv_lang["TYPE__coat"] 			= "שלט גיבורים";
$pgv_lang["TYPE__document"] 		= "מסמך";
$pgv_lang["TYPE__electronic"] 		= "חשמלי";
$pgv_lang["TYPE__fiche"] 			= "פיש";     //"Fiche" -> "Microfiche"
$pgv_lang["TYPE__film"] 			= "סרט";     //"..." -> "Micro..."
$pgv_lang["TYPE__magazine"] 		= "כתב עת";
$pgv_lang["TYPE__manuscript"] 		= "כתב-יד";
$pgv_lang["TYPE__map"] 			= "מפה";
$pgv_lang["TYPE__newspaper"] 		= "עיתון";
$pgv_lang["TYPE__photo"] 			= "צילום";
$pgv_lang["TYPE__tombstone"] 		= "מצבה";
$pgv_lang["TYPE__video"] 			= "וידאו";
$pgv_lang["TYPE__painting"] 			= "תמונה";
$pgv_lang["TYPE__other"] 			= "אחר";

//-- Other media suff
$pgv_lang["view_slideshow"] 		= "התבונן כמצגת שקופיות";
$pgv_lang["download_image"]	= "הורד קובץ";
$pgv_lang["no_media"]		= "לא נמצאה מדיה";
$pgv_lang["media_privacy"]		= "הגבלות פרטיות מונעות ממך לראות פריט זה";
$pgv_lang["relations_heading"]	= "האימג' קשור ל-:";
$pgv_lang["file_size"]			= "גודל הקובץ:";
$pgv_lang["img_size"]			= "גודל האימג'";
$pgv_lang["media_broken"]		= "קובץ המדיה הזה פגום ואינו ניתן לסמן אותו בסימן מים";
$pgv_lang["unknown_mime"]		= "שגיאת חומת האש של מדיה: >סוג Mime לא ידוע< עבור קובץ";

//-- Modules
$pgv_lang["module_error_unknown_action_v2"] 	= "פעולה בלתי ידועה: [פעולה].";
$pgv_lang["module_error_unknown_type"] 	= "סוג מודול בלתי ידוע.";

//-- sortable tables buttons
$pgv_lang["button_alive_in_year"] 		= "הראה אנשים חיים בשנה שצוינה.";
$pgv_lang["button_BIRT_Y100"] 		= "הראה אנשים שנולדו ב-100 השנים האחרונות.";
$pgv_lang["button_BIRT_YES"] 		= "הראה אנשים שנולדו לפני יותר מ-100 שנה.";
$pgv_lang["button_DEAT_H"] 		= "הראה זוגות שבהם רק בן הזוג נפטר.";
$pgv_lang["button_DEAT_N"] 		= "הראה אנשים חיים או זוגות שבהם שני בני הזוג חיים.";
$pgv_lang["button_DEAT_W"] 		= "הראה זוגות שבהם רק בת הזוג נפטרה.";
$pgv_lang["button_DEAT_Y"] 			= "הראה אנשים שנפטרו או זוגות שבהם שני בני הזוג נפטרו.";
$pgv_lang["button_DEAT_Y100"] 		= "הראה אנשים שנפטרו ב-100 השנים האחרונות.";
$pgv_lang["button_DEAT_YES"] 		= "הראה אנשים שנפטרו לפני יותר מ-100 שנה.";
$pgv_lang["button_MARR_DIV"] 		= "הראה זוגות שהתגרשו.";
$pgv_lang["button_MARR_U"] 		= "הראה זוגות שתאריך הנישואין שלהן אינו ידוע.";
$pgv_lang["button_MARR_Y100"] 		= "הראה זוגות שהתחתנו ב-100 שנים האחרונות.";
$pgv_lang["button_MARR_YES"] 		= "הראה זוגות שהתחתנו לפני יותר מ-100 שנה.";
$pgv_lang["button_reset"] 			= "החזר לברירת המחדל של הרשימה.";
$pgv_lang["button_SEX_F"] 			= "הראה רק נקבות.";
$pgv_lang["button_SEX_M"] 			= "הראה רק זכרים.";
$pgv_lang["button_SEX_U"] 			= "הראה רק אנשים שמינם בלתי ידוע.";
$pgv_lang["button_TREE_L"] 			= "הראה זוגות או אנשי &laquo;עלים&raquo;. מדובר באנשים שחיים אבל אין להם ילדים רשומים במאגר הנתונים.";
$pgv_lang["button_TREE_R"] 		= "הראה זוגות או אנשי &laquo;שורשים&raquo; ניתן גם לכנות את האנשים הללו &laquo;פטריארכים&raquo;.מדובר באנשים שהוריהם אינם במאגר הנתונים.";
$pgv_lang["sort_column"] 			= "מיין לפי טור זה.";
?>
