<?php
/**
 * French Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2008  PGV Development Team. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: facts.fr.php 4218 2008-11-01 16:36:36Z opus27 $
 */
if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}
// -- Define a fact array to map GEDCOM tags with their English values
$factarray["ABBR"]                      = "Abréviation";
$factarray["ADDR"]                      = "Adresse";
$factarray["ADR1"]                      = "Adresse 1";
$factarray["ADR2"]                      = "Adresse 2";
$factarray["ADOP"]                      = "Adoption";
$factarray["AFN"]                       = "N° AFN";
$factarray["AGE"]                       = "Age";
$factarray["AGNC"]                      = "Institution";
$factarray["ALIA"]                      = "Alias";
$factarray["ANCE"]                      = "Ancêtres";
$factarray["ANCI"]                      = "Interêt des ancêtres";
$factarray["ANUL"]                      = "Déclaration de nullité du mariage";
$factarray["ASSO"]                      = "Personne associée";
$factarray["AUTH"]                      = "Auteur";
$factarray["BAPL"]                      = "Baptême (SDJ)";
$factarray["BAPM"]                      = "Baptême";
$factarray["BARM"]                      = "Bar mitzvah";
$factarray["BASM"]                      = "Bas mitzvah";
$factarray["BIRT"]                      = "Naissance";
$factarray["BLES"]                      = "Bénédiction religieuse";
$factarray["BLOB"]                      = "Objet binaire";
$factarray["BURI"]                      = "Sépulture";
$factarray["CALN"]                      = "N° d'appel";
$factarray["CAST"]                      = "Caste";
$factarray["CAUS"]                      = "Cause de la mort";
$factarray["CEME"]                      = "Cimetière";
$factarray["CENS"]                      = "Recensement";
$factarray["CHAN"]                      = "Modification";
$factarray["CHAR"]                      = "Jeu de caractères";
$factarray["CHIL"]                      = "Enfant";
$factarray["CHR"]                       = "Baptême religieux enfant";
$factarray["CHRA"]                      = "Baptême religieux adulte";
$factarray["CITY"]                      = "Localité";
$factarray["CONF"]                      = "Confirmation";
$factarray["CONL"]                      = "Confirmation (SDJ)";
$factarray["COPR"]                      = "Copyright";
$factarray["CORP"]                      = "Entreprise";
$factarray["CREM"]                      = "Incinération";
$factarray["CTRY"]                      = "Pays";
$factarray["DATA"]                      = "Données";
$factarray["DATE"]                      = "Date";
$factarray["DEAT"]                      = "Décès";
$factarray["DESC"]                      = "Descendants";
$factarray["DESI"]                      = "Intérêt des descendants";
$factarray["DEST"]                      = "Destination";
$factarray["DIV"]                       = "Divorce";
$factarray["DIVF"]                      = "Divorce prononcé";
$factarray["DSCR"]                      = "Description";
$factarray["EDUC"]                      = "Études";
$factarray["EMIG"]                      = "Émigration";
$factarray["ENDL"]                      = "Dotation (SDJ)";
$factarray["ENGA"]                      = "Fiançailles";
$factarray["EVEN"]                      = "Événement";
$factarray["FAM"]                       = "Famille";
$factarray["FAMC"]                      = "Famille des parents";
$factarray["FAMF"]                      = "Fichier de la famille";
$factarray["FAMS"]                      = "Famille avec le conjoint";
$factarray["FCOM"]                      = "Première communion";
$factarray["FILE"]                      = "Fichier externe";
$factarray["FORM"]                      = "Format";
$factarray["GIVN"]                      = "Prénom(s)";
$factarray["GRAD"]                      = "Diplôme";
$factarray["HUSB"]                      = "Mari";
$factarray["IDNO"]                      = "N° identification";
$factarray["IMMI"]                      = "Immigration";
$factarray["LEGA"]                      = "Légataire";
$factarray["MARB"]                      = "Bans de mariage";
$factarray["MARC"]                      = "Contrat de mariage";
$factarray["MARL"]                      = "Autorisation légale de mariage";
$factarray["MARR"]                      = "Mariage";
$factarray["MARS"]                      = "Régime matrimonial";
$factarray["MEDI"]                      = "Type de Média";
$factarray["NAME"]                      = "Nom";
$factarray["NATI"]                      = "Nationalité";
$factarray["NATU"]                      = "Naturalisation";
$factarray["NCHI"]                      = "Nombre d'enfants";
$factarray["NICK"]                      = "Surnom";
$factarray["NMR"]                       = "Nombre de mariages";
$factarray["NOTE"]                      = "Note";
$factarray["NPFX"]                      = "Préfixe du nom";
$factarray["NSFX"]                      = "Suffixe du nom";
$factarray["OBJE"]                      = "Objet MultiMédia";
$factarray["OCCU"]                      = "Profession";
$factarray["ORDI"]                      = "Cérémonie (SDJ)";
$factarray["ORDN"]                      = "Ordination";
$factarray["PAGE"]                      = "Cote";
$factarray["PEDI"]                      = "Ascendance";
$factarray["PLAC"]                      = "Lieu";
$factarray["PHON"]                      = "Téléphone";
$factarray["POST"]                      = "Code Postal";
$factarray["PROB"]                      = "Testament validé";
$factarray["PROP"]                      = "Biens et possessions";
$factarray["PUBL"]                      = "Publication";
$factarray["QUAY"]                      = "Fiabilité des données";
$factarray["REPO"]                      = "Dépositaire";
$factarray["REFN"]                      = "Référence";
$factarray["RELA"]                      = "Relation";
$factarray["RELI"]                      = "Religion";
$factarray["RESI"]                      = "Domicile";
$factarray["RESN"]                      = "Restriction d'accès";
$factarray["RETI"]                      = "Retraite";
$factarray["RFN"]                       = "N° enregistrement fichier";
$factarray["RIN"]                       = "N° enregistrement ID";
$factarray["ROLE"]                      = "Rôle";
$factarray["SEX"]                       = "Sexe";
$factarray["SLGC"]                      = "Scellement enfant (SDJ)";
$factarray["SLGS"]                      = "Scellement conjoint (SDJ)";
$factarray["SOUR"]                      = "Source";
$factarray["SPFX"]                      = "Préfixe du nom de famille";
$factarray["SSN"]                       = "Numéro de sécurité sociale";
$factarray["STAE"]                      = "État ou région ou département";
$factarray["STAT"]                      = "Statut";
$factarray["SUBM"]                      = "Fournisseur";
$factarray["SUBN"]                      = "Données fournies";
$factarray["SURN"]                      = "Nom de famille";
$factarray["TEMP"]                      = "Temple (SDJ)";
$factarray["TEXT"]                      = "Texte";
$factarray["TIME"]                      = "Heure";
$factarray["TITL"]                      = "Titre";
$factarray["TYPE"]                      = "Type";
$factarray["WIFE"]                      = "Femme";
$factarray["WILL"]                      = "Testament";
$factarray["_EMAIL"]                    = "Adresse courriel";
$factarray["EMAIL"]                     = "Adresse courriel";
$factarray["_TODO"]                     = "Note";
$factarray["_UID"]                      = "Identificateur universel (UID)";
$factarray["_PRIM"]                     = "Image principale";
$factarray["_DBID"]                     = "Bases liées";
// These facts are used in specific contexts
$factarray["STAT:DATE"]                 = "Date de modification du statut";
//These facts are compounds for the view probabilities page
$factarray["FAMC:HUSB:SURN"]            = "Nom de famille du père";
$factarray["FAMC:WIFE:SURN"]            = "Nom de famille de la mère";
$factarray["FAMC:HUSB:BIRT:PLAC"]       = "Lieu de naissance du père";
$factarray["FAMC:WIFE:BIRT:PLAC"]       = "Lieu de naissance de la mère";
$factarray["FAMC:MARR:PLAC"]            = "Lieu de mariage des parents";
$factarray["FAMC:HUSB:OCCU"]            = "Métier du père";
$factarray[":BIRT:PLAC"]                = "Lieu de naissance";
$factarray["FAMS:MARR:PLAC"]            = "Lieu de mariage";
$factarray["FAMS:MARR:DATE"]            = "Date de mariage";
$factarray["FAMS:SPOUSE:DEAT:PLAC"]     = "Lieu de décès du conjoint";
$factarray["FAMC:HUSB:GIVN"]            = "Prénom du père";
$factarray["FAMS:SPOUSE:BIRT:PLAC"]     = "Lieu de naissance du conjoint";
$factarray["FAMC:WIFE:GIVN"]            = "Prénom de la mère";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"]  = "Prénom du grand-père paternel";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"]  = "Prénom de la grand-mère maternelle";
$factarray["FAMC:WIFE:FAMC:HUSB:GIVN"]  = "Prénom du grand-père maternel";
$factarray["FAMC:HUSB:FAMC:WIFE:GIVN"]  = "Prénom de la grand-mère paternelle";
$factarray["FAMS:CHIL:BIRT:PLAC"]       = "Lieu de naissance de l'enfant";
// These facts are all colon delimited
$factarray["BIRT:PLAC"]                 = "Lieu de naissance";
$factarray["BIRT:DATE"]                 = "Date de naissance";
$factarray["DEAT:PLAC"]                 = "Lieu de décès";
$factarray["DEAT:DATE"]                 = "Date de décès";
$factarray["CHR:PLAC"]                  = "Lieu de baptême";
$factarray["CHR:DATE"]                  = "Date de baptême";
$factarray["BAPM:PLAC"]                 = "Lieu de baptême";
$factarray["BAPM:DATE"]                 = "Date de baptême";
$factarray["BURI:PLAC"]                 = "Lieu de sépulture";
$factarray["BURI:DATE"]                 = "Date de sépulture";
$factarray["MARR:PLAC"]                 = "Lieu de mariage";
$factarray["MARR:DATE"]                 = "Date de mariage";
// These facts are specific to GEDCOM exports from Family Tree Maker
$factarray["_MDCL"]                     = "Médical";
$factarray["_DEG"]                      = "Diplôme";
$factarray["_MILT"]                     = "Service Militaire";
$factarray["_SEPR"]                     = "Séparé";
$factarray["_DETS"]                     = "Décès du conjoint";
$factarray["CITN"]                      = "Citoyenneté";
$factarray["_FA1"]                      = "Événement 1";
$factarray["_FA2"]                      = "Événement 2";
$factarray["_FA3"]                      = "Événement 3";
$factarray["_FA4"]                      = "Événement 4";
$factarray["_FA5"]                      = "Événement 5";
$factarray["_FA6"]                      = "Événement 6";
$factarray["_FA7"]                      = "Événement 7";
$factarray["_FA8"]                      = "Événement 8";
$factarray["_FA9"]                      = "Événement 9";
$factarray["_FA10"]                     = "Événement 10";
$factarray["_FA11"]                     = "Événement 11";
$factarray["_FA12"]                     = "Événement 12";
$factarray["_FA13"]                     = "Événement 13";
$factarray["_MREL"]                     = "Lien avec la mère";
$factarray["_FREL"]                     = "Lien avec le père";
$factarray["_MSTAT"]                    = "Début Mariage";
$factarray["_MEND"]                     = "Fin Mariage";
// GEDCOM 5.5.1 related facts
$factarray["FAX"]                       = "Fax";
$factarray["FACT"]                      = "Événement";
$factarray["WWW"]                       = "Page Web";
$factarray["MAP"]                       = "Carte";
$factarray["LATI"]                      = "Latitude";
$factarray["LONG"]                      = "Longitude";
$factarray["FONE"]                      = "Phonétique";
$factarray["ROMN"]                      = "Romain";
// PAF related facts
$factarray["_NAME"]                     = "Adresse Mailing";
$factarray["URL"]                       = "URL";
$factarray["_URL"]                      = "Web URL";
$factarray["_HEB"]                      = "Hébreu";
$factarray["_SCBK"]                     = "Album";
$factarray["_TYPE"]                     = "Type MultiMédia";
$factarray["_SSHOW"]                    = "Diaporama";
// Rootsmagic
$factarray["_SUBQ"]                     = "Version courte";
$factarray["_BIBL"]                     = "Bibliographie";
// Reunion
$factarray["EMAL"]                      = "Adresse courriel";
// Other common customized facts
$factarray["_ADPF"]                     = "Adoption par le père";
$factarray["_ADPM"]                     = "Adoption par la mère";
$factarray["_AKAN"]                     = "Nom d'usage";
$factarray["_AKA"]                      = "Nom d'usage";
$factarray["_BRTM"]                     = "Brit mila";
$factarray["_COML"]                     = "Mariage légal";
$factarray["_EYEC"]                     = "Couleur des yeux";
$factarray["_FNRL"]                     = "Funérailles";
$factarray["_HAIR"]                     = "Couleur des cheveux";
$factarray["_HEIG"]                     = "Taille";
$factarray["_HOL"]                      = "Holocauste";
$factarray["_INTE"]                     = "Inhumation";
$factarray["_MARI"]                     = "Promesse de mariage";
$factarray["_MBON"]                     = "Lien par mariage";
$factarray["_MEDC"]                     = "Condition médicale";
$factarray["_MILI"]                     = "Militaire";
$factarray["_NMR"]                      = "Non marié(e)";
$factarray["_NLIV"]                     = "Non vivant(e)";
$factarray["_NMAR"]                     = "Jamais marié(e)";
$factarray["_PRMN"]                     = "Numéro permanent";
$factarray["_WEIG"]                     = "Poids";
$factarray["_YART"]                     = "Yahrzeit";
$factarray["_MARNM"]                    = "Nom après mariage";
$factarray["_MARNM_SURN"]               = "Nom de famille après mariage";
$factarray["_STAT"]                     = "Statut Mariage";
$factarray["COMM"]                      = "Commentaire";
// Aldfaer related facts
$factarray["MARR_CIVIL"]                = "Mariage civil";
$factarray["MARR_RELIGIOUS"]            = "Mariage religieux";
$factarray["MARR_PARTNERS"]             = "Partenaires";
$factarray["MARR_UNKNOWN"]              = "";
$factarray["_HNM"]                      = "Nom hébreu";
// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"]                = "Décès du conjoint";
$factarray["_BURI_SPOU"]                = "Enterrement du conjoint";
$factarray["_CREM_SPOU"]                = "Crémation du conjoint";
$factarray["_BIRT_CHIL"]                = "Naissance d'un enfant";
$factarray["_CHR_CHIL" ]                = "Baptême d'un enfant";
$factarray["_BAPM_CHIL"]                = "Baptême d'un enfant";
$factarray["__BRTM_CHIL"]               = "Brit Mila d'un enfant";
$factarray["_ADOP_CHIL"]                = "Adoption d'un enfant";
$factarray["_MARR_CHIL"]                = "Mariage d'un enfant";
$factarray["_MARB_CHIL"]                = "Publication de mariage d'un enfant";
$factarray["_DEAT_CHIL"]                = "Décès d'un enfant";
$factarray["_BURI_CHIL"]                = "Enterrement d'un enfant";
$factarray["_CREM_CHIL"]                = "Crémation d'un enfant";
$factarray["_BIRT_GCHI"]                = "Naissance d'un petit-enfant";
$factarray["_CHR_GCHI" ]                = "Baptême d'un petit-enfant";
$factarray["_BAPM_GCHI"]                = "Baptême d'un petit-enfant";
$factarray["__BRTM_GCHI"]               = "Brit Mila d'un petit-enfant";
$factarray["_ADOP_GCHI"]                = "Adoption d'un petit-enfant";
$factarray["_MARR_GCHI"]                = "Mariage d'un petit-enfant";
$factarray["_MARB_GCHI"]                = "Publication de mariage d'un petit-enfant";
$factarray["_DEAT_GCHI"]                = "Décès d'un petit-enfant";
$factarray["_BURI_GCHI"]                = "Enterrement d'un petit-enfant";
$factarray["_CREM_GCHI"]                = "Crémation d'un petit-enfant";
$factarray["_BIRT_GGCH"]                = "Naissance d'un arrière-petit-enfant";
$factarray["_CHR_GGCH" ]                = "Baptême d'un arrière-petit-enfant";
$factarray["_BAPM_GGCH"]                = "Baptême d'un arrière-petit-enfant";
$factarray["__BRTM_GGCH"]               = "Brit Mila d'un arrière-petit-enfant";
$factarray["_ADOP_GGCH"]                = "Adoption d'un arrière-petit-enfant";
$factarray["_MARR_GGCH"]                = "Mariage d'un arrière-petit-enfant";
$factarray["_MARB_GGCH"]                = "Publication de mariage d'un arrière-petit-enfant";
$factarray["_DEAT_GGCH"]                = "Décès d'un arrière-petit-enfant";
$factarray["_BURI_GGCH"]                = "Enterrement d'un arrière-petit-enfant";
$factarray["_CREM_GGCH"]                = "Crémation d'un arrière-petit-enfant";
$factarray["_MARR_FATH"]                = "Mariage du père";
$factarray["_MARB_FATH"]                = "Publication de mariage du père";
$factarray["_DEAT_FATH"]                = "Décès du père";
$factarray["_BURI_FATH"]                = "Enterrement du père";
$factarray["_CREM_FATH"]                = "Crémation du père";
$factarray["_MARR_FAMC"]                = "Mariage des parents";
$factarray["_MARB_FAMC"]                = "Publication de mariage des parents";
$factarray["_MARR_MOTH"]                = "Mariage de la mère";
$factarray["_MARB_MOTH"]                = "Publication de mariage de la mère";
$factarray["_DEAT_MOTH"]                = "Décès de la mère";
$factarray["_BURI_MOTH"]                = "Enterrement de la mère";
$factarray["_CREM_MOTH"]                = "Crémation de la mère";
$factarray["_BIRT_SIBL"]                = "Naissance frère/sœur";
$factarray["_CHR_SIBL" ]                = "Baptême frère/sœur";
$factarray["_BAPM_SIBL"]                = "Baptême frère/sœur";
$factarray["__BRTM_SIBL"]               = "Brit Mila frère/sœur";
$factarray["_ADOP_SIBL"]                = "Adoption frère/sœur";
$factarray["_MARR_SIBL"]                = "Mariage frère/sœur";
$factarray["_MARB_SIBL"]                = "Publication de mariage frère/sœur";
$factarray["_DEAT_SIBL"]                = "Décès frère/sœur";
$factarray["_BURI_SIBL"]                = "Enterrement frère/sœur";
$factarray["_CREM_SIBL"]                = "Crémation frère/sœur";
$factarray["_BIRT_HSIB"]                = "Naissance demi-frère/sœur";
$factarray["_CHR_HSIB" ]                = "Baptême demi-frère/sœur";
$factarray["_BAPM_HSIB"]                = "Baptême demi-frère/sœur";
$factarray["__BRTM_HSIB"]               = "Brit Mila demi-frère/sœur";
$factarray["_ADOP_HSIB"]                = "Adoption demi-frère/sœur";
$factarray["_MARR_HSIB"]                = "Mariage demi-frère/sœur";
$factarray["_MARB_HSIB"]                = "Publication de mariage demi-frère/sœur";
$factarray["_DEAT_HSIB"]                = "Décès demi-frère/sœur";
$factarray["_BURI_HSIB"]                = "Enterrement demi-frère/sœur";
$factarray["_CREM_HSIB"]                = "Crémation demi-frère/sœur";
$factarray["_BIRT_NEPH"]                = "Naissance neveu/nièce";
$factarray["_CHR_NEPH" ]                = "Baptême neveu/nièce";
$factarray["_BAPM_NEPH"]                = "Baptême neveu/nièce";
$factarray["__BRTM_NEPH"]               = "Brit Mila neveu";
$factarray["_ADOP_NEPH"]                = "Adoption neveu/nièce";
$factarray["_MARR_NEPH"]                = "Mariage neveu/nièce";
$factarray["_MARB_NEPH"]                = "Publication de mariage neveu/nièce";
$factarray["_DEAT_NEPH"]                = "Décès neveu/nièce";
$factarray["_BURI_NEPH"]                = "Enterrement neveu/nièce";
$factarray["_CREM_NEPH"]                = "Crémation neveu/nièce";
$factarray["_DEAT_GPAR"]                = "Décès d'un grand-parent";
$factarray["_BURI_GPAR"]                = "Enterrement d'un grand-parent";
$factarray["_CREM_GPAR"]                = "Crémation d'un grand-parent";
$factarray["_DEAT_GGPA"]                = "Décès d'un arrière-grand-parent";
$factarray["_BURI_GGPA"]                = "Enterrement d'un arrière grand-parent";
$factarray["_CREM_GGPA"]                = "Crémation d'un arrière grand-parent";
$factarray["_BIRT_FSIB"]                = "Naissance frère/sœur du père";
$factarray["_CHR_FSIB" ]                = "Baptême frère/sœur du père";
$factarray["_BAPM_FSIB"]                = "Baptême frère/sœur du père";
$factarray["__BRTM_FSIB"]               = "Brit Mila frère/sœur du père";
$factarray["_ADOP_FSIB"]                = "Adoption frère/sœur du père";
$factarray["_MARR_FSIB"]                = "Mariage frère/sœur du père";
$factarray["_MARB_FSIB"]                = "Publication de mariage frère/sœur du père";
$factarray["_DEAT_FSIB"]                = "Décès frère/sœur du père";
$factarray["_BURI_FSIB"]                = "Enterrement frère/sœur du père";
$factarray["_CREM_FSIB"]                = "Crémation frère/sœur du père";
$factarray["_BIRT_MSIB"]                = "Naissance frère/sœur de la mère";
$factarray["_CHR_MSIB" ]                = "Baptême frère/sœur de la mère";
$factarray["_BAPM_MSIB"]                = "Baptême frère/sœur de la mère";
$factarray["__BRTM_MSIB"]               = "Brit Mila frère/sœur de la mère";
$factarray["_ADOP_MSIB"]                = "Adoption frère/sœur de la mère";
$factarray["_MARR_MSIB"]                = "Mariage frère/sœur de la mère";
$factarray["_MARB_MSIB"]                = "Publication de mariage frère/sœur de la mère";
$factarray["_DEAT_MSIB"]                = "Décès frère/sœur de la mère";
$factarray["_BURI_MSIB"]                = "Enterrement frère/sœur de la mère";
$factarray["_CREM_MSIB"]                = "Crémation frère/sœur de la mère";
$factarray["_BIRT_COUS"]                = "Naissance cousin(e) germain(e)";
$factarray["_CHR_COUS"]                 = "Baptême cousin(e) germain(e)";
$factarray["_BAPM_COUS"]                = "Baptême cousin(e) germain(e)";
$factarray["__BRTM_COUS"]               = "Brit Mila cousin(e) germain(e)";
$factarray["_ADOP_COUS"]                = "Adoption cousin(e) germain(e)";
$factarray["_MARR_COUS"]                = "Mariage cousin(e) germain(e)";
$factarray["_MARB_COUS"]                = "Publication de mariage cousin(e) germain(e)";
$factarray["_DEAT_COUS"]                = "Décès cousin(e) germain(e)";
$factarray["_BURI_COUS"]                = "Enterrement cousin(e) germain(e)";
$factarray["_CREM_COUS"]                = "Crémation cousin(e) germain(e)";
$factarray["_FAMC_EMIG"]                = "Émigration des parents";
$factarray["_FAMC_RESI"]                = "Domicile des parents";
//-- PGV Only facts
$factarray["_THUM"]                     = "Vignette";
$factarray["_PGVU"]                     = "par";
$factarray["SERV"]                      = "Serveur distant";
$factarray["_GEDF"]                     = "Fichier GEDCOM";
 
 
?>
