<?php
/**
 * German Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @translator Norgaz Kurt
 * @translator Peter Pluntke
 * @translator Gerd Kroll
 * @version $Id: help_text.de.php 4806 2009-01-15 19:12:07Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["help_treenav.php"]			= "~#pgv_lang[interactive_tree]#~<br />Diese Seite zeigt Ihnen den Stammbaum, in beiden Richtungen, der gewählten Person.  Das Diagramm ähnelt dem Sanduhr-Diagramm; es zeigt Ahnen und Nachfahren der gewählten Person.  Dieses Diagramm hat eine kompaktere Darstellung als das Sanduhr-Diagramm da es Ihnen Familienangaben anstatt Personenangaben zeigt.<br /><ul><li><b>Scrolling</b><br />Wenn sich der Mauszeiger in sich kreuzende Pfeile verwandelt, können Sie das Diagramm in jede Richtung verschieben um andere Teile des Diagrammes sichtbar zu machen.  Das tun Sie durch gleichzeitiges Drücken der linken Maustaste während Sie den Mauszeiger in der gewünschten Richtung bewegen.  Sie können das Diagramm so lange verschieben, als noch Generationen sichtbar gemacht werden können.<br /></li><li><b>Zoom</b><br />Mit den Zoom-Buttons an der linken Seite des Diagramms können Sie das Diagramm vergrößern oder verkleinern, um weniger oder mehr des Stammbaumes sichtbar zu machen.  Wenn Sie das Diagramm verkleinern, können unter Umständen die darin enthaltenen Informationen unlesbar werden.  Solche unlesbare Informationen werden Ihnen in lesbarer Form gezeigt, wenn Sie den Mauszeiger darüber schweben lassen.<br /></li><li><b>Mehr Details</b><br />Wenn Sie in einer beliebigen Box klicken, erhalten Sie eine größere Box mit mehr Informationen.  Diese größere Box verschwindet, wenn Sie darin klicken.  Wenn Sie den Namen einer in der vergößerten Box genannten Person klicken, gelangen Sie zu der #pgv_lang[indi_info]# Seite.  Wenn Sie das <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> Ikon in der vergrößerten Box klicken, erhalten Sie ein neues Diagramm worin die jeweilige Person als Startperson gewählt ist.  Wenn Sie das <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> Ikon klicken, gelangen Sie zu dem Diagramm dieser Familie.<br /></li><li><b>Alle Partner zeigen</b><br />Das <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> Ikon direkt unter den Zoom-Buttons bestimmt, ob alle Partner oder Gatten und Kinder gezeigt werden sollen oder nicht.  Wenn nicht, dann sehen Sie nur das letzte Verhältnis und die daraus gezeugten Kinder.<br /></li><li><b>Großer Stammbaum</b><br />Sie können das Diagramm von vielen Seiten erreichen.  Zum Beispiel, im «Stammbaum» Ordner der  #pgv_lang[indi_info]# Seite oder im «Diagramm» Block der Hauptseite.  Wenn Sie den Stammbaum auf einer dieser anderen Seiten aufrufen, erhalten Sie auch ein Stammbaum-Ikon unter den Zoom-Buttons.  Wenn Sie das <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> Ikon klicken, erreichen Sie das interaktive Baumdiagramm.</li></ul><br />";

$pgv_lang["move_mediadirs_help"]		= "~#pgv_lang[move_mediadirs]#~<br />Wenn die Medien-Feuerwand benutzt wird, können Medien-Dateien in einem Server-Verzeichnis aufbewahrt werden, das nicht über das Internet zugreifbar ist.<br /><br />Diese Buttons ermöglichen Ihnen, ganze Medien-Unterverzeichnisstrukturen zwischen dem geschützten (nicht Internet-zugreifbar) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> und dem normalen <b>#GLOBALS[MEDIA_DIRECTORY]#</b> Medien-Verzeichnis zu verlegen.<br /><br />";
$pgv_lang["setperms_help"]				= "~#pgv_lang[setperms]#~<br />Diese Option stellt Schreib- und Lese-Rechte im geschützten <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> und normalen <b>#GLOBALS[MEDIA_DIRECTORY]#</b> Verzeichnis, und in allen Unterverzeichnissen.  Sie können zwischen <b>#pgv_lang[setperms_writable]#</b> und <b>#pgv_lang[setperms_readonly]#</b> wählen.<br /><br />";
$pgv_lang["no_update_CHAN_help"] 		= "~#pgv_lang[no_update_CHAN]#~<br />Gelegentlich müssen Verwalter die Eingaben Anderer korrigieren oder ergänzen.  Zum Beispiel, es könnte sein dass Ortsangaben mit dem Land ergänzt werden müssen.  Wenn der Verwalter solche Korrekturen macht, sind auch alle Informationen über die letzte Änderung des anderen Benutzers durch diese des Verwalters ersetzt.  Das kann womöglich unerwünscht sein.<br /><br />Wenn diese Option angekreuzt ist, behaltet PhpGedView alle Informationen über die letzte Änderung, und ersetzt sie nicht mit diesen der eben vorgenommenen.  Mit dieser Option kann der Verwalter auch Informationen über die letzte Änderung ändern oder sogar löschen.<br /><br />";
$pgv_lang["edit_SOUR_EVEN_help"]		= "~#pgv_lang[source_events]#~<br />Jede Quelle enthält Einträge über bestimmte Ereignisse, im Großen und Ganzen für bestimmte Daten- und Zuständigkeitsbereiche.  Zum Beispiel, jede Volkszählung die als Quelle zitiert werden kann enthält Einträge die man als «Volkszählung» Ereignisse in die Datenbank eintragen kann.  In kirchlichen Registern sind gewöhnlich Ereignisse wie Geburten, Ehen, und Tode aufgezeichnet.<br /><br />Aus der Liste wählen Sie Ereignisse die in dieser Quelle aufgezeichnet sind.  Als Datum gibt man gewöhnlich einen Bereich wie zum Beispiel <i>FROM 1900 TO 1910</i> (bedeutet <i>VON Anfang 1900 BIS Ende 1910</i>).  Bitte beachten Sie dass alle Daten in der englischen Sprache eingetragen werden müssen.  Als Zuständigkeitsbereich gibt man gewöhnlich eine Ortschaft.  Zum Beispiel, die Eingabe «Oneida, Idaho, USA» bedeutet dass diese Quelle für Ereignisse in allen Orten in Oneida County (Idaho, USA) zuständig ist, aber nicht für Ereignisse anderer Orte.  Die Eingabe «Idaho, USA» bedeutet dass diese Quelle für Ereignisse in allen Orten im Staat Idaho (USA) zuständig ist, aber nicht für Ereignisse anderswo.<br /><br />";
$pgv_lang["cache_life_help"]			= "~#pgv_lang[cache_life]#~<br />Wegen Leistungsverbesserung wird der Inhalt dieses Blocks der PhpGedView Start-Seite als Cache-Datei gespeichert.  Sie können bestimmen, wie oft die Cache-Datei neu erstellt wird.<br /><br /><ul><li><b>-1</b> bedeutet dass die Cache-Datei niemals automatisch neu erstellt wird.  Um eine Neuerstellung zu bewirken, müssen Sie auf der Seite, wo die Start-Seite angepasst wird, den <b>#pgv_lang[clear_cache]#</b> Button klicken.</li><li><b>0</b> (Null) bedeutet dass dieser Block nie als Cache-Datei vorkommt, und dass dieser Block auf der PhpGedView Start-Seite immer neu erstellt wird.  Diese Einstellung wird für manche Blöcke, deren Inhalt sich oft ändert, automatisch benutzt.  Beispiele solcher Blöcke sind #pgv_lang[logged_in_users_block]# und #pgv_lang[random_media_block]#.</li><li><b>1</b> (Eins) bedeutet dass der Block täglich neu erstellt wird, <b>2</b> bedeutet dass der Block alle zwei Tage neu erstellt wird, <b>7</b> bedeutet eine wöchentliche Neuerstellung, usw.</li></ul><br /><br />";
$pgv_lang["clear_cache_help"]			= "~#pgv_lang[clear_cache]#~<br />Wegen Leistungsverbesserung sind einige Blöcke der PhpGedView Start-Seite im Index-Verzeichnis als Cache-Dateien gespeichert.  Diese Cache-Dateien werden normalerweise automatisch einmal am Tag neu erstellt.  Es kann jedoch vorkommen, dass Sie diese Dateien manuell neu erstellen möchten.<br /><br />Dieser Button ermöglicht eine manuelle Neuerstellung durch das Löschen der Dateien.<br /><br />";
$pgv_lang["import_options_help"] 		= "Sie können zusätzliche Optionen wählen, die die Dateneinfuhr beeinflussen.<br /><br />";
$pgv_lang["verify_gedcom_help"]			= "Sie können das Hochladen und Importieren dieser GEDCOM-Datei fortsetzen oder abbrechen.<br /><br />";
$pgv_lang["add_gedcom_instructions"]	= "Bitte geben Sie einen Namen für diese neue GEDCOM-Datei ein.  Die neue GEDCOM-Datei wird im Verzeichnis #INDEX_DIRECTORY# erstellt.<br /><br />";
$pgv_lang["random_media_start_slide_help"]	= "~#pgv_lang[random_media_start_slide]#~<br />Soll der «Diavortrag» automatisch nach dem Laden der Seite starten.<br /><br />Der «Diavortrag» ändert den Inhalt des Blocks ohne vorheriges Übertragen der Bilder vom Server und ohne volles Neuladen der Seite.<br /><br />";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br />Sie können durch diese Option die Bild-Regler verbergen.<br /><br />Diese Regler ermöglichen die Darstellung eines neuen Zufallbildes oder das automatische Abspielen einer Reihe von Zufallbildern als «Diavortrag». Der «Diavortrag» ändert den Inhalt des Blocks ohne vorheriges Übertragen der Bilder vom Server und ohne volles Neuladen der Seite.<br /><br />";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br />Mit diesem Link können Sie eine neue Quelle in Ihre Datenbank einfügen ohne sie zugleich mit anderen Datensätzen als Quellenangabe zu verbinden. Die neue Quelle taucht in Quellenlisten auf, aber ohne Erwähnung in einer Quellenangabe ist sie niemals in Diagrammen oder anderswo zu finden.<br /><br />";
$pgv_lang["link_person_id_help"]		= "~#pgv_lang[label_local_id]#~<br />In diesem Feld geben Sie die ID-Nummer der zu verbindenen Person ein (z.B. I100).<br /><br />";
$pgv_lang["link_gedcom_id_help"]		= "~#pgv_lang[label_gedcom_id]#~<br />Hier können Sie eine andere Datenbank wählen, wo Informationen über die gewünschte Person zu finden sind.<br /><br />";
$pgv_lang["link_remote_site_help"]		= "~#pgv_lang[label_site]#~<br />Hier geben Sie die Einträge die zum Zugriff zu einer fremden Datenbank notwendig sind.  Sie können die gewünschte Datenbank aus einer Liste von schon bekannten Datenbanken wählen.  Sie können auch die Daten zu einer bisher unbekannten Datenbank eingeben.<br /><br />Im Feld <b>#pgv_lang[label_site_url2]#</b> geben Sie das URL zum Zugriff auf die <i>web services description (WDSL)</i> Datei, die für PhpGedView den Zugriff zur fremden Datenbank beschreibt.  Folgend ist ein Beispiel für solches URL, wenn die fremde Datenbank auch mit PhpGedView unterstützt ist: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />Im Feld <b>#pgv_lang[label_gedcom_id]#</b> geben Sie das Datenbank-Kennzeichen das manche fremde Internet-Seiten erfordern.  Bei fremden PhpGedView Seiten ist das der Name der dortigen GEDCOM-Datei.<br /><br />Falls notwendig, geben Sie auch die Daten in die <b>#pgv_lang[label_username_id]#</b> und <b>#pgv_lang[label_password_id]#</b> Felder.<br /><br /><i><b>Bitte beachten Sie:</b> Fremde PhpGedView Seiten <u>müssen</u> mindestens Version 4.0 unterstützen; bei älteren Versionen ist diese Funktion nicht erhältlich.</i><br /><br />";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br />Durch diese Option können Sie andeuten, ob die gewünschte Person in einer anderen Datenbank auf Ihrem Server zu finden ist, oder ob sie anderswo durch das Internet zugänglich ist.<br /><br />Wenn die gewünschte Person auf Ihrem Server zu finden ist, müssen Sie die zuständige Datenbank wählen, und die ID-Nummer der Person darin eingeben. Falls die Person nur durch das Internet zugänglich ist, müssen Sie das URL der fremden Internet Seite, sowohl den Namen der dortigen Datenbank und die ID-Nummer der Person darin, eingeben.<br /><br />";
$pgv_lang["link_remote_rel_help"]		= "~#pgv_lang[label_rel_to_current]#~<br />Mit dieser Option können Sie die Beziehung zwischen der Person in der fremden Datenbank und der hiesigen Person andeuten.  Zum Beispiel, die Option <i>Vater</i> bedeutet dass die Person in der fremden Datenbank Vater der Person in dieser Datenbank ist.<br /><br />";
$pgv_lang["link_remote_help"]       	= "~#pgv_lang[link_remote]#~<br />Diese Seite ermöglicht Ihnen, Verbindungen zwischen Personen dieser Datenbank und Personen in fremden Datenbanken herzustellen.  Die fremden Datenbanken müssen entweder über das Internet oder auf diesem Server von PhpGedView zugreifbar sein.<br /><br />Um solche Verbindung herzustellen, müssen Sie zuerst die Beziehung zwischen den beiden Personen andeuten.  Danach können Sie eine bereits bekannte fremde Datenbank wählen oder die Zugangsdaten zu der neuen fremden Datenbank eingeben.  Nachdem Sie die ID-Nummer der Person in der fremden Datenbank eingegeben haben, kann PhpGedView die notwendigen Daten der Person aus der fremden Datenbank übertragen.  Diese übertragene Daten werden <u>niemals</u> in die hiesige Datenbank eingefügt, sondern nur auf den jeweiligen Seiten, wo diese Person auftritt, gezeigt.  Da diese Daten nicht in der hiesigen Datenbank sesshaft sind, ist es auch nicht möglich sie zu bearbeiten.<br /><br />Das «Hilfe-Link neben jedem Element der Seite gibt Ihnen mehr Auskunft über das Element.  Sie können sich auch an diese englische «Hilfe»-Seiten wenden: <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.<br /><br />";

//-- Edit Interface
$pgv_lang["edit_ABBR_help"]				= "~#factarray[ABBR]#~<br />Dieses Feld enthält die Abkürzung des Quellen-Titels.  Es wird zusammen mit dem vollen Quellen-Titel benutzt.  Gewöhnlich benutzt PhpGedView zuerst den vollen Titel und danach die hier eingegebene Abkürzung.<br /><br />Seite 62 des GEDCOM 5.5 Standards beschreibt dieses Feld so: «<i>This entry is to provide a short title used for sorting, filing, and retrieving source records.</i>» (Dieser Eintrag sorgt für einen kurzen Titel der dem Sortieren, Speichern, und Abfragen von Quellen dient.)<br /><br />Bei PhpGedView ist der Gebrauch von Titelabkürzungen nicht notwendig; bei anderen Programmen können diese Abkürzungen notwendig sein.<br /><br />";
$pgv_lang["edit_ROMN_help"]				= "~Romanisierte Namen~<br />In vielen Kulturen kommt es vor, dass Namen in einem dort üblichen Alphabet geschrieben werden, und dass die Namen auch einen Äquivalent in Lateinischen Buchstaben haben.<br /><br />Falls Sie die normalen Namensfelder benutzen um Namen in Alphabeten wie Hebräisch, Griechisch, Russisch, Chinesisch oder Arabisch einzugeben, können Sie die Namensäquivalente in Lateinischen Buchstaben in diesem Feld eingeben.  Beide Werte sind dann in Listen und Diagrammen sichtbar.<br /><br />Obwohl dieses Feld «#factarray[ROMN]#» genannt ist, ist es nicht für die Eingabe von Lateinischen Buchstaben reserviert.  Das heißt, Sie können hier auch Japanische oder andere Ihnen beliebige Buchstaben eintragen.<br /><br />";
$pgv_lang["edit_ROMN_GIVN_help"]		= "#pgv_lang[edit_ROMN_help]#In dieses Feld geben Sie die Vornamen.  Die Vornamen von «John Robert Finlay Jr.», die hier eingeben werden sollen sind <b>John Robert</b>.<br /><br />";
$pgv_lang["edit_ROMN_SURN_help"]		= "#pgv_lang[edit_ROMN_help]#In dieses Feld geben Sie den Nachnamen.  Der Nachname von «John Robert Finlay Jr.», der hier eingeben werden soll ist <b>Finlay</b>.<br /><br />Personen mit mehreren Familiennamen, wie in Spanien und Portugal oft der Fall ist, sollen mit Komma zwischen den Familiennamen eingetragen werden.  Zum Beispiel, der Eintrag «Cortes,Vega» wird in Nachnamenslisten unter <b>C</b> und <b>V</b> gezeigt, während der Eintrag «Cortes Vega» nur unter <b>C</b> gezeigt wird.<br /><br />";
$pgv_lang["edit__HEB_help"]				= "~Hebräische Namen~<br />In vielen Kulturen kommt es vor, dass Namen in einem dort üblichen Alphabet geschrieben werden, und dass die Namen auch einen Äquivalent in Lateinischen Buchstaben haben.<br /><br />Falls Sie die normalen Namensfelder benutzen um Namen im Lateinischen Alphabet einzugeben, können Sie die Namensäquivalente in Alphabeten wie Hebräisch, Griechisch, Russisch, Chinesisch oder Arabisch in diesem Feld eingeben.  Beide Werte sind dann in Listen und Diagrammen sichtbar.<br /><br />Obwohl dieses Feld «#factarray[_HEB]#» genannt ist, ist es nicht für die Eingabe von Hebräischen Buchstaben reserviert.  Das heißt, Sie können hier auch Japanische oder andere Ihnen beliebige Buchstaben eintragen.<br /><br />";
$pgv_lang["edit__HEB_GIVN_help"]		= "#pgv_lang[edit__HEB_help]#In dieses Feld geben Sie die Vornamen.  Die Vornamen von «John Robert Finlay Jr.», die hier eingeben werden sollen sind <b>John Robert</b>.<br /><br />";
$pgv_lang["edit__HEB_SURN_help"]		= "#pgv_lang[edit__HEB_help]#In dieses Feld geben Sie den Nachnamen.  Der Nachname von «John Robert Finlay Jr.», der hier eingeben werden soll ist <b>Finlay</b>.<br /><br />Personen mit mehreren Familiennamen, wie in Spanien und Portugal oft der Fall ist, sollen mit Komma zwischen den Familiennamen eingetragen werden.  Zum Beispiel, der Eintrag «Cortes,Vega» wird in Nachnamenslisten unter <b>C</b> und <b>V</b> gezeigt, während der Eintrag «Cortes Vega» nur unter <b>C</b> gezeigt wird.<br /><br />";
$pgv_lang["edit_SEX_help"]				= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]				= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br />Hier können Sie eine allein stehende Person eintragen.<br /><br />Alleinstehende Personen sind am Anfang mit keinen anderen Personen verbunden.  Später, wenn Sie mehr über die Verwandtschaft dieser Person wissen, können Sie sie mit einer anderen Person über den #pgv_lang[relatives]# Ordner der #pgv_lang[indi_info]# Seite verbinden.<br /><br />";
$pgv_lang["edit_URL_help"]				= "Geben Sie die URL Adresse mit <b>http://</b> ein.<br /><br />Zum Beispiel, eine gültige URL Adresse wäre: <b>http://www.phpgedview.net/</b> Das leere Feld bedeutet dass keine URL Adresse bekannt ist.<br /><br />";
$pgv_lang["edit_EMAIL_help"]			= "Geben Sie die Mail-Adresse ein.<br /><br />Zum Beispiel, eine gültige Mail-Adresse wäre: <b>name@hotmail.com</b> Das leere Feld bedeutet dass keine Mail-Adresse bekannt ist.<br /><br />";
$pgv_lang["edit_FAX_help"]				= "Geben Sie die FAX Nummer, inklusiv den internationalen und lokalen Vorwahlnummern.  Bei den lokalen Vorwahlnummern soll die erste Null nicht eingegeben werden.<br /><br />Das leere Feld bedeutet dass keine FAX Nummer vorhanden ist.<br /><br />Beispiele wären <b>+49&nbsp;561&nbsp;56&nbsp;76&nbsp;89</b> für Nummern in Deutschland oder <b>+1&nbsp;888&nbsp;555-1212</b> für Nummern in USA oder Kanada.<br /><br />";
$pgv_lang["edit_PHON_help"]				= "Geben Sie die Telefon Nummer, inklusiv den internationalen und lokalen Vorwahlnummern.  Bei den lokalen Vorwahlnummern soll die erste Null nicht eingegeben werden.<br /><br />Das leere Feld bedeutet dass keine Telefon Nummer vorhanden ist.<br /><br />Beispiele wären <b>+49&nbsp;561&nbsp;56&nbsp;76&nbsp;89</b> für Nummern in Deutschland oder <b>+1&nbsp;888&nbsp;555-1212</b> für Nummern in USA oder Kanada.<br /><br />";
$pgv_lang["edit_ADDR_help"]				= "Geben Sie die Adresse, genau wie sie auf einem Briefumschlag geschrieben wird.<br /><br />Das leere Feld bedeutet dass die Adresse nicht bekannt ist.<br /><br />";
$pgv_lang["edit_GIVN_help"]				= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]				= "~#factarray[SPFX]#~<br />Sie können Wörter eingeben oder wählen, die vor dem Hauptteil des Nachnamens genannt werden.  Zum Beispiel: <b>von</b> Braun, <b>auf der</b> Maur, <b>van der</b> Kloot, <b>de</b> Graaf, usw.<br /><br />";
$pgv_lang["edit_SURN_help"]				= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]				= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"]			= "~#factarray[_MARNM]#~<br />Geben Sie wahlweise den Ehenamen dieser Person.  Die Eingaberegeln sind denen des normalen Namens gleich.<br /><br />Zum Beispiel, wenn Maria Elisabet Braun nach ihrer Ehe mit Hans Georg Fischer ihren Namen ändert, könnte diese Eingabe (natürlich ohne Hochkommata) so sein:<ul><li>Amerikanische Gewohnheit:&nbsp;&nbsp;\"Maria Elisabet Braun /Fischer/\"</li><li>Europäische Gewohnheit:&nbsp;&nbsp;\"Maria Elisabet /Fischer/\"</li><li>Alternative Europäische Gewohnheit:&nbsp;&nbsp;\"Maria Elisabet /Braun-Fischer/\" oder \"Maria Elisabet /Fischer-Braun/\"</li></ul>Gewöhnlich ändert die Frau ihren Namen, aber manchmal ist es der Mann.<br /><br />In manchen Ländern (z.B. Quebec, Kanada) ist jede Änderung der Namen nach der Ehe verboten.<br /><br />";
$pgv_lang["edit_PEDI_help"]				= "~#factarray[PEDI]#~<br /><br />Dieses Feld beschreibt die Beziehung des Kindes zu seiner Familie.  Folgende Wahlen sind möglich:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;Die Beziehung des Kindes zu seiner Familie ist unbestimmt.  Mit dieser Wahl wird das #factarray[PEDI]# Feld nicht in die Datenbank eingetragen.<br /><br /></li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Diese Option bedeutet dass das Kind in die Familie geboren wurde.<br /><br /></li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Diese Option bedeutet dass das Kind in die Familie adoptiert wurde.  Man kann aber <i>nicht</i> dadurch schließen, dass das Kind nicht direkt mit seinen Eltern verwandt ist; diese Wahl bedeutet lediglich dass das Kind nach seiner Geburt von der Familie adoptiert wurde.<br /><br /></li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Das Kind ist ein Pflegekind der Familie.  Gewöhnlich sind Pflegekinder nicht direkt mit der Familie verwandt.<br /><br /></li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;Das Kind wurde durch eine HLT <i>Siegelung</i> Zeremonie zu seiner Familie versiegelt.  Kinder-Siegelungen werden vorgenommen, wenn seine Eltern nach dessen Geburt zueinander versiegelt sind.  Kinder, die nach der Siegelung der Eltern geboren werden, sind automatisch zu der Familie versiegelt.<br /><br /></li></ul>";
$pgv_lang["edit_AGNC_help"]				= "~#factarray[AGNC]#~<br /><br />Zuständige Organisation, Behörde, Person, Unternehmen, usw.<br /><br />Z.B., Arbeitgeber der Person, oder Kirche wo das Ereignis stattfand, oder für Urkunden zuständige Behörde.";

$pgv_lang["context_help"]				= "Mehr Informationen zu diesen Themen ist durch das Klicken des <b>?</b> neben den jeweiligen Einträgen erhältlich.<br /><br />";

$pgv_lang["register_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br />Jede Person in dieser Datenbank hat seine eigene Identifikations-Nummer (ID-Nummer).  Falls Ihre ID-Nummer Ihnen schon bekannt ist, können Sie sie hier eintragen.  Wenn Sie sie nicht wissen und eine Suche nach ihr erfolglos ist, geben Sie bitte im Kommentarfeld genügend Informationen dass der Verwalter diese ID-Nummer für Sie hier eingeben kann.<br /><br />";
$pgv_lang["register_comments_help"]		= "~#pgv_lang[comments]#~<br />Bitte benutzen Sie dieses Feld um dem Verwalter mitzuteilen warum Sie einen Zugangsantrag machen und wie Sie mit diesem Stammbaum verbunden sind.  Sie können hier auch andere Bemerkungen machen, die Sie dem Verwalter mitteilen möchten.<br /><br />";
$pgv_lang["utf8_ansi_help"]				= "~#pgv_lang[utf8_to_ansi]#~<br />PhpGedView benutzt intern den UTF-8 Zeichensatz, der das Bearbeiten von Texten in fast allen Sprachen der Welt ermöglicht.  Einige Programme, wie zum Beispiel Family Tree Maker, haben überhaupt keine Unterstützung für den UTF-8 Zeichensatz.  Wenn Sie diese Option ankreuzen, wandelt PhpGedView die Ausgabe-Datei in den <b>ANSI (ISO-8859-1)</b> Zeichensatz um.<br /><br />Ob die Ausgabe-Datei so konvertiert werden muss kommt darauf an, ob das Ziel-Programm den UTF-8 Zeichensatz unterstützt.  Im Fragefall müssen Sie sich an die Dokumentation des Programmes wenden.<br /><br />Bitte beachten Sie dass manche besondere Zeichen nicht im ANSI (ISO-8859-1) Zeichensatz vorhanden sind und Sie deshalb den UTF-8 Ausgangszeichensatz behalten sollten.  In diesem Fall müssen Sie auch eine andere Methode finden, die besonderen Zeichen in das andere Programm einzugeben.  Sie müssen sich wahrscheinlich auch an den Hersteller Ihres Programmes wenden.<br /><br />Ausführliche Informationen über UTF-8 können Sie in diesem <a href='http://de.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia Eintrag'><b>Wikipedia Eintrag</b></a> finden.<br /><br />";
$pgv_lang["remove_tags_help"]			= "~#pgv_lang[remove_custom_tags]#~<br />Wenn diese Option angekreuzt ist, werden alle Tags die speziell für PhpGedView erdacht sind und nicht dem GEDCOM-Standard entsprechen, aus der Ausgangsdatei entfernt.<br /><br />Beispiele solcher Tags sind <b>_PGVU</b> wodurch der PhpGedView-Nutzer, der die letze Änderung dieses Datensatzes vorgenommen hat, bestimmt werden kann und <b>_THUM</b> wodurch PhpGedView erkennt dass dieses Bild auch als Miniaturbild benutzt werden soll.<br /><br />Wenn die Ausgangsdatei solche nicht dem Standard entsprechende Tags enthält kann sie womöglich für andere Programme ungültig sein.<br /><br />";
$pgv_lang["download_zipped_help"]		= "~#pgv_lang[zip_files]#~<br />Diese Option ist besonders nützlich wenn große GEDCOM-Dateien übertragen werden sollen.  Wenn diese Option angekreuzt ist, erstellt PhpGedView vor dem Übertragen der GEDCOM-Datei eine komprimierte Version im ZIP-Format.  Die komprimierte Version, die gewöhnlich mindestens 75% kleiner ist, wird dann übertragen.  Das Komprimieren hat den Vorteil dass die Dateigröße wesenhaft geringer ist.  Der Nachteil ist dass die komprimierte Datei zuerst mit einem geeigneten Programm wie WinZip oder 7-Zip bearbeitet werden muss so dass sie für normale Programme gültig wird.<br /><br />Es besteht immer die Möglichkeit, dass bei unkomprimierten großen Dateien die maximale Laufzeit überschritten wird und die Übertragung deshalb vorzeitig abgebrochen wird.<br /><br />";
$pgv_lang["remember_me_help"]			= "~#pgv_lang[remember_me]#~<br />Diese Option, beim Login angekreuzt, weist PhpGedView an dass für den nächsten Zugang die gleichen Zugangsdaten (NutzerID und Kennwort) benutzt werden sollen.<br /><br />Um das zu bewirken werden Cookies benutzt.  Cookies sind kleine Dateien die auf Ihrem Computer bestehen und nach Anfrage von Ihrem Computer zu PhpGedView (oder anderen Programmen) übertragen werden.  Das Lesen der von PhpGedView erstellten Cookies ist nur PhpGedView erlaubt.<br /><br />Diese Option ermöglicht Ihnen, schnell eine Verbindung zwischen Ihrem Computer und PhpGedView zu erstellen.  Sie können danach fast alles tun als ob Sie sich wie gewöhnlich angemeldet haben.  Verwaltungs- und Editier-Rechte haben Sie aber nicht.  Solche Rechte bekommen Sie nur nachdem Sie sich durch richtiges Eingeben Ihres NutzerIDs und Kennworts korrekt indentifiziert haben.<br /><br /><b>Es wird Ihnen geraten, diese Option NICHT bei öffentlichen Computern zu benutzen.  Bei solchen Computern könnten Unbefugte sich bei PhpGedView melden als ob sie Sie wären.</b><br /><br />";
$pgv_lang["edit_NCHI_help"]				= "~#factarray[NCHI]#~<br />Geben Sie hier wahlweise die Anzahl der Kinder dieser Person oder dieser Familie.<br /><br />";
$pgv_lang["edit_TIME_help"]				= "~#factarray[TIME]#~<br />Geben Sie hier die Tageszeit, im 24-Std. Format, des Ereignisses ein.  Beispiele:  04:50 13:00 20:30.<br /><br />";
$pgv_lang["edit_NOTE_help"]				= "~#factarray[NOTE]#~<br />Notizen haben kein bestimmtes Format.  Sie werden als Einzelheiten der jeweiligen Rubrik gezeigt.<br /><br />";
$pgv_lang["edit_CEME_help"]				= "~#factarray[CEME]#~<br />Geben Sie hier den Namen des Friedhofs ein, wo diese Person beerdigt ist.<br /><br />";
$pgv_lang["edit_ASSO_help"]				= "~#factarray[ASSO]#~<br />Geben Sie hier die ID-Nummer der verbundenen Person ein.<br /><br />";
$pgv_lang["edit_RELA_help"]				= "~#factarray[RELA]#~<br />Wählen Sie eine Beziehung aus der Liste.  Zum Beispiel, die <b>Patenonkel</b> Wahl bedeutet: <i>Die beziehende Person ist Patenonkel dieser Person</i>.<br /><br />";
$pgv_lang["show_spouse_help"]			= "~#pgv_lang[show_spouses]#~<br />Standardmäßig zeigt dieses Diagramm keine Gatten.  Gatten werden normalerweise nicht gezeigt weil das das Lesen und Verstehen des Diagramms erschwert.  Bei angekreuzter Option werden Gatten in diesem Diagramm sichtbar.<br /><br />";
$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_families]#~<br />Familien im #pgv_lang[relatives]# Ordner sind in der selben Reihenfolge sichtbar wie sie im GEDCOM Datensatz dieser Person vorkommen. Standardmäßig werden Familien nicht nach den Ehedaten sortiert da oft nur die Reihenfolge der Ehen bekannt ist.<br /><br />Diese Option ermöglicht Ihnen, die Reihenfolge der Ehen zu bestimmen.  Falls Sie die Ehen nach deren Daten sortieren möchten, können Sie den dafür gedachten Button klicken.<br /><br />";
$pgv_lang["autoContinue_help"]			= "~#pgv_lang[autoContinue]#~<br /><br />Wenn PhpGedView erkennt, dass die Einfuhr der GEDCOM-Datei mehr Zeit benötigt als von der Zeitbeschränkung erlaubt ist, wird Ihnen der <b>#pgv_lang[del_proceed]#</b> Button gezeigt.  Sie müssen dann diesen Button klicken um die unterbrochene Einfuhr fortzusetzen.<br /><br />Wenn die Option auf <b>#pgv_lang[yes]#</b> gestellt ist, wird dieser Button automatisch geklickt.  Das vermeidet langweiliges Button-Klicken.<br /><br />";
$pgv_lang["firstname_i_help"]			= "~#pgv_lang[firstname_alpha_index]#~<br />Dieser Nachname hat mehr als #GLOBALS[SUBLIST_TRIGGER_I]# Einträge.<br /><br />Um das Finden des gewünschten Eintrages zu erleichtern, wurde die Liste in kleinere Listen, nach dem Anfangsbuchstaben des jeweiligen Vornamens, aufgeteilt. Diese unterstellten Listen funktionieren genau wie die Hauptlisten.<br /><ul><li>Sie klicken einen der Buchstaben, und die Liste der mit diesem Buchstaben anfangende Vornamen wird dann sichtbar.</li><li>Falls Sie <b>#pgv_lang[NN]#</b> klicken, sehen Sie alle Einträge mit unbekanntem Vornamen.</li><li>Das Klicken auf <b>#pgv_lang[all]#</b> erzeugt eine Liste aller Personen mit dem vorher gewählten Nachnamen, ohne Rücksicht auf Vornamen.</li></ul>Da solche Liste viele Namen enthält, kann es lange dauern bis sie sichtbar wird.<br /><br />";
$pgv_lang["firstname_f_help"]			= "~#pgv_lang[firstname_alpha_index]#~<br />Dieser Familienname hat mehr als #GLOBALS[SUBLIST_TRIGGER_F]# Einträge.<br /><br />Um das Finden des gewünschten Eintrages zu erleichtern, wurde die Liste in kleinere Listen, nach dem Anfangsbuchstaben des jeweiligen Vornamens, aufgeteilt. Diese unterstellten Listen funktionieren genau wie die Hauptlisten.<br /><ul><li>Sie klicken einen der Buchstaben, und die Liste der mit diesem Buchstaben anfangende Vornamen wird dann sichtbar.</li><li>Falls Sie <b>#pgv_lang[NN]#</b> klicken, sehen Sie alle Einträge mit unbekanntem Vornamen.</li><li>Das Klicken auf <b>#pgv_lang[all]#</b> erzeugt eine Liste aller Familien mit dem vorher gewählten Namen, ohne Rücksicht auf Vornamen.</li></ul>Da solche Liste viele Namen enthält, kann es lange dauern bis sie sichtbar wird.<br /><br />";
$pgv_lang["edit_TYPE_help"]				= "~#factarray[TYPE]#~<br />In diesem Feld können Sie zusätzliche Informationen eingeben.  Meistens ist dieses Feld ohne vorgesetzes Format; Sie können eingeben was und wie Sie wollen.<br /><br />";
$pgv_lang["edit_TEMP_help"]				= "~#factarray[TEMP]#~<br />Dieses Feld dokumentiert den Tempel wo HLT-Verfügungen vorgenommen wurden.<br /><br />";
$pgv_lang["edit_STAT_help"]				= "~#factarray[STAT]#~<br />Dieses Feld dokumentiert den Status der HLT-Verfügungen.<br /><br />";
$pgv_lang["edit__PRIM_help"]			= "~#factarray[_PRIM]#~<br />Dieses Feld deutet an dass das Medien-Objekt als primäres Objekt der verbundenen Person benutzt werden soll.  Als primäres Objekt wird das Bild dann auf der #pgv_lang[personal_facts]# Seite und auf allen Diagrammen benutzt.<br /><br />";
$pgv_lang["edit__THUM_help"]			= "~#factarray[_THUM]#~<br />Diese Option ermöglicht Ihnen die normale Miniaturbild-Wahl abzuschalten.  Da PhpGedView beim Hochladen der Bilder die jeweiligen Miniaturbilder automatisch erstellt, ist diese Option wahrscheinlich nicht oft nützlich.<br /><br />Mit dieser Option können Sie sicher stellen dass das jeweilige Bild mit genügend Präzision gezeigt wird wenn im Miniaturbild die Einzelheiten nur schlecht zu sehen sind.  Man kann immer das Bild in Originalgröße durch klicken des Miniaturbildes sehen.<br /><br />Mit <b>#pgv_lang[yes]#</b> benutzt PhpgGedView immer dieses Bild anstatt dem Miniaturbild, ohne Rücksicht auf die Größe des Bildes. Wenn das Bild zu groß ist kann das Resultat sehr überraschend sein.<br /><br />";
$pgv_lang["edit_TITL_help"]				= "~#factarray[TITL]#~<br />Geben Sie den Titel des Objekts das Sie bearbeiten.  Bei Multimedia-Objekten sollte der Titel das Objekt beschreiben.<br /><br />";
$pgv_lang["edit_FILE_help"]				= "~#factarray[FILE]#~<br />Dieses ist der wichtigste Eintrag des Multimedia Datensatzes.  Sie müssen mindestens den Dateinamen eingeben. Wenn andere Einstellungen es erlauben, können Verzeichnisnamen auch hilfreich sein.<br /><br />Sie können mit dem <b>#pgv_lang[find_media]#</b> Link nach Medien-Objekten, die sich schon auf dem Server befinden, suchen.<br /><br />#pgv_lang[readme_help]#<br /><br />";
$pgv_lang["edit_FORM_help"]				= "~#factarray[FORM]#~<br />Wenn Sie es möchten, können Sie hier den Datentyp des Multimedia Objektes eintragen.  Manche Programme (aber nicht PhpGedView) ermitteln durch diesen Eintrag wie das Objekt bearbeitet werden muss.  Die Richtigkeit des Eintrages ist für PhpGedView nicht wichtig.<br /><br />";
$pgv_lang["generate_thumb_help"]		= "~#pgv_lang[auto_thumbnail]#~<br />PhpGedView hat festgestellt, dass Miniaturbilder automatisch erstellt werden können.  Die unterstützten Medientypen sind neben der Box angegeben.<br /><br />Das Ankreuzen dieser Option teilt dem Programm mit, dass beim Übertragen dieser Medientypen auch Miniaturbilder automatisch angefertigt werden sollen. Wenn nicht angekreuzt, nimmt das Programm an, dass Sie Ihre eigenen Miniaturbilder auf den Server übertragen möchten.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]			= "~#pgv_lang[add_note]#~<br />Hier ist es möglich, einen neuen Bemerk an diesen Fakt anzuschließen.  Bemerke sind ohne festgestelltes Format; Sie können eingeben was und wie Sie wollen.  Bemerke sind in der «Details» Spalte des betroffenen Faktes sichtbar.<br /><br />";
$pgv_lang["edit_add_SOUR_help"]			= "~#pgv_lang[add_source]#~<br />Hier ist es möglich, ein neues Quellenzitat an diesen Fakt anzuschließen.  Im «Quelle» Feld geben Sie die ID-Nummer der Quelle ein.  Falls die zitierte Quelle noch nicht in der Datenbank eingetragen ist, können Sie das <b>#pgv_lang[create_source]#</b> Link klicken.  Sie können auch nach der zu zitierenden Quelle suchen.  Im #factarray[PAGE]# Feld geben Sie die Seite oder Details die Anderen das Finden dieses Zitats in der angedeuteten Quelle erleichtern.  Im #factarray[TEXT]# Feld können Sie, wenn notwending, das eigentliche Zitat oder eine Beschreibung des Zitates als Text eingeben.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]			= "~#pgv_lang[add_asso]#~<br />Diese Option ermöglicht Ihnen, eine Beziehung zwischen diesem Fakt und einer anderen Person zu erstellen.  Sie können, zum Beispiel, bezeichnen dass die andere Person Pate dieser Person ist.<br /><br />";
$pgv_lang["edit_QUAY_help"]				= "~#factarray[QUAY]#~<br />Dieses Feld dokumentiert die Qualität oder Zuverlässigkeit der Informationen dieser Quelle.<br /><br />Viele Programme erfordern hier eine Nummer. <b>3</b> kann bedeuten dass die Quelle völlig zuverlässig ist, <b>2</b> kann bedeuten dass die Quelle nicht ganz völlig zuverlässig ist, <b>1</b> kann bedeuten dass die Informationen nicht ganz völlig zuverlässig sind, <b>0</b> kann bedeuten dass die Quelle unzuverlässig ist.<br /><br />";
$pgv_lang["edit_PAGE_help"]				= "~#factarray[PAGE]#~<br />Im #factarray[PAGE]# Feld geben Sie die Seite oder Details die Anderen das Finden dieses Zitates in der erwähnten Quelle erleichtert.<br /><br />";
$pgv_lang["edit_TEXT_help"]				= "~#factarray[TEXT]#~<br />Im #factarray[TEXT]# Feld können Sie, wenn notwending, das eigentliche Zitat oder eine Beschreibung des Zitates als Text eingeben.<br /><br />";
$pgv_lang["edit_SOUR_help"]				= "~#factarray[SOUR]#~<br />Dieses Feld ermöglicht Ihnen, das Zitat an eine andere Quelle anzuschließen. Der Titel der jetzigen Quelle wird neben seiner ID-Nummer gezeigt.<br /><br />Wenn notwending, können Sie die ID-Nummer der anderen Quelle eingeben.  Sie können auch nach der anderen Quelle durch Klicken des <b>#pgv_lang[find_id]#</b> Links suchen.  Das leer gemachte Feld löscht das Zitat, aber NICHT die zitierte Quelle.<br /><br />";
$pgv_lang["edit_edit_raw_help"]			= "~#pgv_lang[edit_raw]#~<br />Hier können Sie den rohen GEDCOM Datensatz bearbeiten.  Sie sollten das aber mit Vorsicht tun; falls Sie den GEDCOM 5.5.1 Standard nicht völlig verstehen, wäre es besser diese besondere Bearbeitung zu unterlassen.  Der erwähnte Standard wird kurz in der «Hilfe» Rubrik <b>GEDCOM Datei</b> beschrieben.  Diese Rubrik had auch ein Link zur englischen Version des Standards.<br /><br />PhpGedView unterstützt viele verschiedene Methoden die zum Bearbeiten oder Hinzufügen von Informationen dienen, aber es gibt auch Fälle wo das Bearbeiten durch direkten Eingriff im GEDCOM Datensatz leichter voran geht.  Ihnen wird strengstens geraten, wenn möglich, die dafür erdachten Bearbeitungs-Seiten zu benutzen.<br /><br />Nachdem Sie den «#pgv_lang[save]#» Button geklickt haben, wird die Übereinstimmung Ihrer Eingaben mit dem GEDCOM-Standard geprüft, und dann wird noch ein neuer CHAN Datensatz hinzugefügt.<br /><br />";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br />PhpGedView hat die Möglichkeit, bis zu 5 Fakten, mit allen Details, einzeln in einen Sammelbehälter zu kopieren. Sie können dann später solche Fakten im «#pgv_lang[add_fact]#» Menü zur leichten und schnellen Einfügung in mehrere GEDCOM Datensätze wählen.<br /><br />";
$pgv_lang["edit_PLAC_help"]				= "~#factarray[PLAC]#~<br />Orte sollten dem üblichen Ahnenforschungs-Standard entsprechend eingegeben werden.  Das heißt, man gibt von links nach rechts immer größere Ortschaften ein, mit einem Komma zwischen jedem Ort.  Jeder so angegebene Ort sollte einem Archiv oder Standesamt entsprechen, wo Geburts-, Ehe-, und Todes-Fälle registriert werden.<br /><br />Zum Beispiel, <i>Salt Lake City</i> sollte als «Salt Lake City, Salt Lake, Utah, USA»  eingegeben werden.  <ul><li>Der erste Teil, «Salt Lake City», ist die Stadt oder Gemeinde wo das Ereignis statt fand.  Für manche Städte, London, Paris, und Berlin, zum Beispiel, ist der Stadtteil auch wichtig und wird deshalb vor dem Stadtnamen mit folgendem Komma eingegeben. In Berlin nennt man den Stadtteil gewöhnlich hinter «Berlin» (z.B. «Berlin-Tempelhof»), aber Ahnenforscher nennen den Stadtteil zuerst (z.B. «Dahlem, Berlin».</li><li>Der zweite Teil des obigen Beispiels «Salt Lake» entspricht dem Kreis (englisch: county).</li><li>Der dritte Teil «Utah» ist das Bundesland oder Provinz.</li><li>Der vierte Teil «USA» ist das Land.</li></ul>Teile der Ortsangabe die entfallen oder unbekannt sind, sollten durch leere entsprechende Eingaben angedeutet werden.  Zum Beispiel, die Eingabe «Salt Lake City,,Utah,USA» bedeutet dass Sie den Kreis worin sich Salt Lake City befindet nicht wissen.  Die Eingabe «Vaduz,,,Liechtenstein» bedeutet dass in Liechtenstein keine Kreise oder Bundesländer vorkommen.<br /><br />Mit dem <b>#pgv_lang[find_place]#</b> Link können Sie leicht Orte ermitteln, die schon in der Datenbank vorhanden sind.<br /><br />";
$pgv_lang["edit_add_parent_help"]		= "~Mutter oder Vater hinzufügen~<br />Auf dieser Seite können Sie der Datenbank bisher unbekannte Personen als Eltern hinzufügen.  Sie müssen mindestens den Namen des Vaters oder der Mutter eingeben.  Andere bekannte Informationen, wie Geburts- oder Todes-Datum können auch sofort eingegeben werden.  Unbekannte Geburts- oder Todes-Fakten sollten leer bleiben.<br /><br />Besondere Fakten wie Beruf oder Religion können erst nach dem Einfügen dieser Person bearbeitet werden.  Die Person wird durch Klicken des «#pgv_lang[save]#» Buttons eingefügt.  Alle Fakten der neu eingefügten Person können danach von dessen #pgv_lang[indi_info]# Seite bearbeitet oder aufgerufen werden.<br /><br />";
$pgv_lang["edit_add_spouse_help"]		= "~Ehepartner hinzufügen~<br />Auf dieser Seite können Sie der Datenbank bisher unbekannte Personen als Ehepartner hinzufügen.  Sie müssen mindestens den Namen dieser Person eingeben.  Andere Informationen, wie Geburts- oder Todes-Datum können auch sofort eingegeben werden.  Unbekannte Geburts- oder Todes-Fakten sollten leer bleiben.<br /><br />Besondere Fakten wie Beruf oder Religion können erst nach dem Einfügen dieser Person bearbeitet werden.  Die Person wird durch Klicken des «#pgv_lang[save]#» Buttons eingefügt.  Alle Fakten der neu eingefügten Person können danach von dessen #pgv_lang[indi_info]# Seite bearbeitet oder aufgerufen werden.<br /><br />";
$pgv_lang["edit_death_help"]			= "~#pgv_lang[death]#~<br />In dieser Feldergruppe können Sie Todes-Fakten eintragen.  Das Todesdatum wird im üblichen Format der Ahnenforschung eingegeben (z.B. 1 JAN 2004).  Das Programm hilft Ihnen, das Datum zu wählen nachdem Sie das Kalenderikon klicken.  Der Todesort soll auch im üblichen Format der Ahnenforschung (Ort,Kreis,Bundesland,Land) eingegeben werden.  Falls Sie das <b>#pgv_lang[find_place]#</b> Link klicken, können Sie einen bereits in der Datenbank vorkommenden Ort wählen.<br /><br />";
$pgv_lang["edit_birth_help"]			= "~#pgv_lang[birth]#~<br />In dieser Feldergruppe können Sie Geburts-Fakten eintragen.  Das Geburtsdatum wird im üblichen Format der Ahnenforschung eingegeben (z.B. 1 JAN 2004).  Das Programm hilft Ihnen, das Datum zu wählen nachdem Sie das Kalenderikon klicken.  Der Geburtsort soll auch im üblichen Format der Ahnenforschung (Ort,Kreis,Bundesland,Land) eingegeben werden.  Falls Sie das <b>#pgv_lang[find_place]#</b> Link klicken, können Sie einen bereits in der Datenbank vorkommenden Ort wählen.<br /><br />";
$pgv_lang["edit_sex_help"]				= "~#pgv_lang[sex]#~<br />Bitte wählen Sie das Geschlecht.  Die Option <b>#pgv_lang[unknown]#</b> bedeutet dass das Geschlecht dieser Person unbekannt ist.<br /><br />";
$pgv_lang["edit_name_help"]				= "~#pgv_lang[name]#~<br />Dieses ist die wichtigste aller Zeilen des Namens dieser Person.  Normalerweise wird sie automatisch geändert wenn Sie die anderen Namensfelder (Zeilen) bearbeiten.<br /><br />Falls notwendig können Sie auch in diesem Feld den Namen eingeben, aber Sie müssen sich dann nach den Hinweisen im GEDCOM 5.5.1 Standard richten und den Nachnamen zwischen schrägen Strichen eingeben.  Zum Beispiel, der Name «John Robert Finlay Jr.» wird so eingegeben: <b>John Robert /Finlay/ Jr.</b>.<br /><br />";
$pgv_lang["edit_suffix_help"]			= "~#pgv_lang[suffix]#~<br />In dieses Feld geben Sie den Suffix des Namens.  Falls der Namen keinen hat, soll dieses Feld leer bleiben.  Zum Beispiel, der Namens-Suffix von «John Robert Finlay Jr.» ist <b>Jr.</b>.<br /><br />";
$pgv_lang["edit_surname_help"]			= "~#pgv_lang[surname]#~<br />In dieses Feld geben Sie den Nachnamen.  Der Nachname von «John Robert Finlay Jr.», der hier eingeben werden soll ist <b>Finlay</b>.<br /><br />Personen mit mehreren Familiennamen, wie in Spanien und Portugal oft der Fall ist, sollen mit Komma zwischen den Familiennamen eingetragen werden.  Zum Beispiel, der Eintrag «Cortes,Vega» wird in Nachnamenslisten unter <b>C</b> und <b>V</b> gezeigt, während der Eintrag «Cortes Vega» nur unter <b>C</b> gezeigt wird.<br /><br />";
$pgv_lang["edit_NICK_help"]				= "~#factarray[NICK]#~<br />In dieses Feld geben Sie Spitznamen dieser Person.  Das Feld kann leer bleiben.<br /><br />Drei Methoden bestehen für das Eingeben von Spitznamen:<ol><li><b>#pgv_lang[update_name]#</b> wählen, Spitznamen eingeben, und zuletzt speichern</li><li><b>#pgv_lang[add_name]#</b> wählen, Spitznamen <u>und</u> vollen Namen eingeben, und zuletzt speichern</li><li>#pgv_lang[edit_raw]#</b> wählen, unter der ersten <b>1&nbsp;NAME</b> Zeile die gewünschten <b>2&nbsp;NICK</b> Zeilen eingeben, und zuletzt speichern</li></ol><br /><br />";
$pgv_lang["edit_given_name_help"]		= "~#pgv_lang[given_name]#~<br />In dieses Feld geben Sie die Vornamen.  Die Vornamen von «John Robert Finlay Jr.», die hier eingeben werden sollen sind <b>John Robert</b>.<br /><br />";
$pgv_lang["edit_NPFX_help"]				= "~#factarray[NPFX]#~<br /><br >Dieses Feld, das leer gelassen sein kann, enthält Namenspräfixe wie <b>Dr.</b>, <b>Prof.</b>, <b>Adm</b> usw.<br /><br />";
$pgv_lang["edit_add_child_help"]		= "~#pgv_lang[add_child]#~<br />Auf dieser Seite können Sie ein der Datenbank bisher unbekanntes Kind hinzufügen.  Sie müssen mindestens den Namen des Kindes eingeben.  Andere bekannte Informationen, wie Geburts- oder Todes-Datum können auch sofort eingegeben werden.  Unbekannte Geburts- oder Todes-Fakten sollten leer bleiben.<br /><br />Besondere Fakten wie Beruf oder Religion können erst nach dem Einfügen dieser Person bearbeitet werden.  Die Person wird durch das Klicken des «#pgv_lang[save]#» Buttons eingefügt.  Alle Fakten der neu eingefügten Person können danach von dessen #pgv_lang[indi_info]# Seite bearbeitet oder aufgerufen werden.<br /><br />";

$pgv_lang["review_changes_help"]		= "~#pgv_lang[review_changes_block]#~<br />Dieser Block zeigt alle Datensätze die mit PhpGedView bearbeitet wurden und noch nicht in die Datenbank übernommen sind.<br /><br />";
$pgv_lang["quick_update_name_help"] 	= "~#pgv_lang[update_name]#~<br />Diese Feldergruppe erleichtert das Ändern des Namens dieser Person.<br /><br />Ins «#factarray[GIVN]#» Feld geben Sie die Vornamen und ins «#factarray[SURN]#» Feld geben Sie den Nachnamen.  Zum Beispiel, die Bestandteile des Namens «John Robert Finlay» sind: <b>John Robert</b> (#factarray[GIVN]#); <b>Finlay</b> (#factarray[SURN]#)<br /><br />Ihre Eingaben <u>ändern</u> den Namen dieser Person; neue Namen werden hier <u>nicht</u> hinzugefügt. <i>Bitte beachten Sie: Falls der Name dieser Person wegen einer Ehe geändert wurde, soll der neue Ehename <u>nicht</u> auf dieser Seite eingegeben werden.</i><br /><br />";
$pgv_lang["quick_update_fact_help"] 	= "~#pgv_lang[update_fact]#~<br />Diese Feldergruppe erlaubt Ihnen, bereits bestehende Ereignisse zu löschen oder zu bearbeiten oder neue Ereignisse zu diesem Datensatz hinzuzufügen.<br /><br />Das Bearbeiten der bereits bestehenden Ereignissen wird durch einfaches Ersetzen der angegebenen Daten bewirkt.  Neue Ereignisse erfordern die Wahl des Ereignisses aus der Liste und das Eingeben des Datums im normalen Format der Ahnenforschung (d.h. englisch wie zum Beispiel <b>1 JAN 2004</b>) und des Ortes.  Wenn Sie Hilfe beim Eingeben des Datums benötigen, können Sie den Kalender klicken.  Falls Sie einen bereits bekannten Ort eingeben möchten, können Sie das <b>#pgv_lang[find_place]#</b> Link benutzen.<br /><br />";
$pgv_lang["quick_update_photo_help"]	= "~#pgv_lang[update_photo]#~<br />Diese Feldergruppe ermöglicht das Übertragen von Fotos dieser Person.  Ins «#factarray[TITL]#» Feld geben Sie beschreibenden Text.  (z.B. <b>Alfons Braun, 1890</b>)  Nachdem Sie den «Browse» Button klicken, können Sie Ihren lokalen Computer nach dem gewünschten Bild durchsuchen.  Falls schon ein Bild vorhanden ist, können Sie bestimmen ob das neue Bild das alte ersetzen soll, oder ob es hinzugefügt werden soll.  Wenn möglich und auch erlaubt, erstellt PhpGedView während des Übertragens automatisch das dazugehörende Miniaturbild.<br /><br />";
$pgv_lang["quick_update_address_help"]	= "~#pgv_lang[update_address]#~<br />In dieser Feldergruppe können Sie die Adresse, Telefon- und Fax-Nummern, sowie die Mail-Adresse dieser Person hinzufügen oder ändern.  Änderungen bewirklichen Sie durch das Ersetzen der bestehenden Daten.  Falls Sie Daten löschen möchten, müssen Sie die gewünschten Felder leeren.<br /><br />";
$pgv_lang["quick_update_spouse_help"]	= "~Neuen Ehepartner hinzufügen~<br />Dise Feldergruppe wird benutzt, wenn Sie einen neuen Ehepartner an diese Person anschließen möchten.<br /><br />Sie geben den Namen und die Geburtsdaten in die entsprechenden Felder ein.  Daten über die Ehe werden in deren entsprechende Felder eingegeben.<br /><br />Bitte beachten Sie dass Daten immer im der Ahnenforschung üblichen Format eingegeben werden sollen.  (D.h., englische Monatsabkürzung, wie zum Beispiel <b>1 JAN 2004</b>.)  Für Hilfe beim Eingeben von Daten können Sie das Kalenderikon klicken.  Falls Sie einen Ort eingeben möchten, der bereits der Datenbank bekannt ist, können Sie das <b>#pgv_lang[find_place]#</b> Link benutzen.<br /><br />Diese Felder können nur für das Eingeben von <i>neuen</i> Ehepartnern benutzt werden.  Daten über bereits bestehende Partner können hier nicht bearbeitet werden.  Für diesen Zweck müssen Sie dieses Fenster schließen und dann den #pgv_lang[relatives]# Ordner klicken. Danach können Sie das entsprechende Menü klicken.<br /><br />";
$pgv_lang["quick_update_marriage_help"]	= "~Ehe bearbeiten~<br />Sie können diese Felder, zusammen mit den Feldern der Gruppe «Neuen Ehepartner hinzufügen» benutzen, die Daten einer bisher unbekannten Ehe einzugeben.  Falls Sie nur Ehedaten eingeben ohne auch gleichzeiting einen neuen Ehepartner hinzuzufügen, werden die Daten der <i>letzten</i> Ehe geändert.<br /><br />Bitte beachten Sie dass Daten immer im der Ahnenforschung üblichen Format eingegeben werden sollen.  (D.h., englische Monatsabkürzung, wie zum Beispiel <b>1 JAN 2004</b>.)  Für Hilfe beim Eingeben von Daten können Sie das Kalenderikon klicken.  Falls Sie einen Ort eingeben möchten, der bereits der Datenbank bekannt ist, können Sie das <b>#pgv_lang[find_place]#</b> Link benutzen.<br /><br />";
$pgv_lang["quick_update_child_help"]	= "~#pgv_lang[add_new_chil]#~<br />Diese Feldergruppe wird benutzt, ein der Datenbank bisher unbekanntes Kind an diese Person anzuschließen.<br /><br />In die betreffenden Felder geben Sie den Namen des Kindes, sein Geschlecht, und sein Geburtsdatum und -Ort.<br /><br />Bitte beachten Sie dass Daten immer im der Ahnenforschung üblichen Format eingegeben werden sollen.  (D.h., englische Monatsabkürzung, wie zum Beispiel <b>1 JAN 2004</b>.)  Für Hilfe beim Eingeben von Daten können Sie das Kalenderikon klicken.  Falls Sie einen Ort eingeben möchten, der bereits der Datenbank bekannt ist, können Sie das <b>#pgv_lang[find_place]#</b> Link benutzen.<br /><br />Diese Felder sind nur für die Eingabe der Daten eines der Datenbank bisher unbekannten Kindes bestimmt.  Falls Sie die Daten einer bereits bestehenden Person bearbeiten möchten, müssen Sie dieses Fenster schließen und dann den #pgv_lang[relatives]# Ordner klicken. Danach können Sie das entsprechende Menü klicken.<br /><br />";
$pgv_lang["index_top10_pageviews_help"]	= "~#pgv_lang[top10_pageviews]# Block~<br />Dieser Block zeigt die 10 meist aufgerufenen Personen, Familien, oder Quellen.  Um das zu bewirken, müssen Sie die <b>#pgv_lang[SHOW_COUNTER]#</b> Option der <b>#pgv_lang[displ_hide_conf]#</b> Gruppe innherhalb des Abschnitts <b>#pgv_lang[displ_conf]#</b> der GEDCOM Konfiguration auf <b>#pgv_lang[yes]#</b> stellen.<br /><br />";
$pgv_lang["useradmin_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br />Mit dieser Option können Sie den Ordner bestimmen, der automatisch beim Zugriff zur #pgv_lang[indi_info]# Seite geöffnet wird.  Die Option <b>#pgv_lang[all]#</b> bestimmt dass alle vorhandenen Ordner automatisch geöffnet werden sollen.<br /><br />Falls der Benutzer seine eigenen Optionen bearbeiten darf, kann er diese Option für sich ändern.<br /><br />";
$pgv_lang["edituser_user_default_tab_help"]	= "~#pgv_lang[user_default_tab]#~<br />Mit dieser Option können Sie den Ordner bestimmen, der automatisch beim Zugriff zur #pgv_lang[indi_info]# Seite geöffnet wird.  Die Option <b>#pgv_lang[all]#</b> bestimmt dass alle vorhandene Ordner automatisch geöffnet werden sollen.<br /><br />";
$pgv_lang["reorder_children_help"]		= "~#pgv_lang[reorder_children]#~<br />Kinder dieser Familie werden in der selben Reihenfolge gezeigt, wie sie im Datensatz der Familie vorkommen.  Gewöhnlich werden Kinder nicht nach Geburtsdaten sortiert da oft nur die Reihenfolge der Geburten bekannt ist.<br /><br />Diese Option ermöglicht Ihnen, die Reihenfolge der Kinder zu bestimmen.  Falls Sie die Kinder nach deren Daten sortieren möchten, können Sie den entsprechenden Button klicken.<br /><br />Sie können auch die Reihenfolge der Kinder mit der Maus bestimmen.  Wenn der Maus-Cursor über einem der Informations-Kasten steht, verändert er sich in zwei doppelte sich kreuzende Pfeile.  Wenn Sie nun die linke Maustaste drücken und danach den Maus-Cursor nach oben oder unten verschieben, folgt der Informations-Kasten.  Die anderen Kasten der Liste machen dem sich verschiebendem Kasten eine Lücke, bis Sie die linke Maustaste loslassen, wonach er in der Lücke Platz nimmt.<br /><br />";
$pgv_lang["rss_feed_help"]				= "~#pgv_lang[rss_feeds]#~<br />Die von PhpGedView unterstützte ATOM oder RSS Versorgung ermöglicht das leichte Beobachten von Internetseiten um Änderungen darin schnell zu erkennen, ohne dass der RSS Abonnent jede beobachtete Seite direkt zugreifen muss.  Die meisten RSS-Sammler senden automatische Mails wenn in beobachteten Seiten Änderungen vorhanden sind.<br /><br />Der #pgv_lang[rss_feeds]# Block ermöglicht Ihnen, die RSS Versorgung nach Ihren Wünschen anzupassen.  Unterstützte Versorgungstypen sind ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML und JavaScript.  ATOM und RSS sind für RSS-Sammler bestimmt.  Die Standard-Einstellung (ATOM) ist für die meisten Sammler gültig. Die Nummern deuten den Stil, und NICHT Versionen. Mit HTML und JavaScript ist es möglich, den Inhalt der Hauptseite in andere Seiten einzufügen.<br /><br />Außer dem Versorgungstyp können Sie auch bestimmen, welche Blöcke der Hauptseite Sie durch RSS beobachten möchten.  Die Sprache in der diese Blöcke für Sie beobachtet werden, ist die gleiche, in der Sie eben arbeiten.  In diesem Fall ist es die deutsche Sprache.  Falls Sie zum Beispiel die französische Version der Blöcke beobachten möchten, müssen Sie PhpGedView auf Französisch umschalten bevor Sie die Hauptseite erneut aufrufen und anpassen.<br /><br />Eine Option mit der Sie die Authentifizierungsmethode wählen können ist auch vorhanden. Diese Option, falls eingeschaltet, erlaubt dem RSS Sammler die Hauptseite mit NutzerID und Kennwort zuzugreifen.  Dadurch können private Daten sichtbar werden, genau als ob ein normaler Nutzer sich mit den selben Daten angemeldet hätte. Der RSS-Sammler wird durch #pgv_lang[basic_auth]# angemeldet.  #pgv_lang[basic_auth]# benutzt die <i>Basic HTTP Authentication</i> Methode.  Wahrscheinlich wird in der Zukunft auch die #pgv_lang[digest_auth]# Methode unterstützt.<br /><br />In diesem <a href='http://de.wikipedia.org/wiki/RSS' target='_blank' alt='Wikipedia Artikel' title='Wikipedia Artikel'><b>Wikipedia Artikel</b></a> finden Sie ausführliche Informationen über RSS. <i>Einfache HTTP Authentifikation</i> ist in diesem <u>englischen</u> <a href='http://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='Wikipedia Artikel' title='Wikipedia Artikel'><b>Wikipedia Artikel</b></a> beschrieben während <i>#pgv_lang[digest_auth]#</i>in diesem <u>englischen</u> <a http://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>Wikipedia article</b></a> beschrieben ist.<br /><br />";

$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br />Ihre GEDCOM-Konfiguration erlaubt eine Unterverzeichnistiefe von #GLOBALS[MEDIA_DIRECTORY_LEVELS]#, zusätzlich zum Verzeichnis<b>#GLOBALS[MEDIA_DIRECTORY]#</b> wo übertragene Medien-Dateien standardmäßig gespeichert werden. Sie können so Ihre Medien-Dateien besser ordnen, und brauchen auch nicht mehr darauf zu achten, dass Dateinamen im ganzen PhpGedView Medien-System nur einmal vorkommen.<br /><br />In dieses Feld geben Sie die Verzeichnisstruktur wo die von Ihrem lokalen Computer übertragene Datei gespeichert werden soll.  Bitte achten Sie auf die Schreibweise (Groß- und Kleinbuchstaben) der eingegebenen Verzeichnisnamen.  Verzeichnisnamen mit Kleinbuchstaben unterscheiden sich von den selben Namen in Großbuchstaben.<br /><br />Falls die eingegebene Verzeichnisstruktur nicht existiert, wird sie vor dem Übertragen automatisch erstellt.  Falls die von Ihnen eingegebene Verzeichnisstruktur mehr als die erlaubten #GLOBALS[MEDIA_DIRECTORY_LEVELS]# Unterverzeichnisse enthält, werden die überflüssigen Verzeichnisnamen von links nach rechts aus Ihrer Eingabe gelöscht.<br /><br />Miniaturbilder werden in einer identischen Verzeichnisstruktur gespeichert, die aber vom Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> ausgeht.<br /><br />";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br />In diesem Feld geben Sie Verzeichnis und Namen der Medien-Datei die Sie auf den Server übertragen möchten.  Mit Hilfe des <b>Browse</b> Buttons können Sie Ihren lokalen Computer nach der gewünschten Datei durchsuchen.<br /><br />Die Datei wird mit dem selben Namen in das im <b>#pgv_lang[folder]#</b> Feld angegebenen Verzeichnis übertragen.<br /><br />Wenn das Feld <b>#pgv_lang[folder]#</b> nicht sichtbar ist oder Sie es nicht ändern können, haben Sie entweder nicht genügend Rechte, oder die Konfiguration hat bestimmt, dass Verzeichnisse unter dem Standard-Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#</b> nicht erlaubt sind.  In diesem Fall werden alle Medien-Dateien in das erwähnte <b>#GLOBALS[MEDIA_DIRECTORY]#</b> Verzeichnis übertragen.<br /><br />";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br />In diesem Feld geben Sie Verzeichnis und Namen der Miniaturbild-Datei die Sie auf den Server übertragen möchten.  Mit Hilfe des <b>Browse</b> Buttons können Sie Ihren lokalen Computer nach der gewünschten Datei durchsuchen.  Nur wenn Sie dieses Feld leer lassen wird die <b>#pgv_lang[auto_thumbnail]#</b> Box beachtet.<br /><br />Falls Sie auch einen Namen ins <b>#pgv_lang[media_file]#</b> Feld eingetragen haben, erhält das hochgeladene Minaturbild den gleichen Namen, ohne Rücksicht auf dessen Namen in Ihrem lokalen Computer.  Das leere <b>#pgv_lang[media_file]#</b> Feld hat zur Folge dass die Miniaturbild-Datei nach dem Übertragen in zwei verschiedenen Server-Verzeichnissen vorkommt: einmal im Medien-Unterverzeichnis dessen Namen Sie im <b>#pgv_lang[folder]#</b> Feld eingegeben haben, und das zweite Mal in der selben Verzeichnisstruktur, die aber vom Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> ausgeht. Wenn das <b>#pgv_lang[folder]#</b> Feld nicht sichtbar ist oder Sie es nicht ändern können, haben Sie entweder nicht genügend Rechte, oder die Konfiguration hat bestimmt, dass Verzeichnisse unter dem Standard-Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#</b> nicht erlaubt sind.<br /><br />";


//-- GENERAL
$pgv_lang["help_header"]				= "Informationen über:";
$pgv_lang["privacy_error_help"]			= "~PRIVATE DETAILS~<br />Es gibt verschiedene Gründe, warum Sie diese Nachricht bekommen können:<br /><br /><ul><li><b>Alle Daten lebender Personen sind als «Privat» eingestellt.</b><br />Unregistrierte oder nicht angemeldete Besucher können vollständige Informationen nur über verstorbene Personen sehen. Sofern vom Verwalter zugelassen, können Sie sich registrieren, indem Sie den Login Button klicken und anschließend das Link #pgv_lang[requestpassword]#.<br /></li><li><b>Sie sind ein Benutzer mit Benutzername und Kennwort...</b><br />aber Sie haben sich nicht erfolgreich angemeldet oder Sie haben zu lange keine Eingabe gemacht und wurden deshalb automatisch abgemeldet.<br /></li><li><b>Aus Datenschutzgründen</b><br />Manche Personen können den Verwalter gebeten haben, bestimmte Daten auf «Privat» zu setzen oder möchten überhaupt nicht in der Datenbank erscheinen.<br />Der Datenschutz kann folgende Werte annehmen:<br /><ol><li>#pgv_lang[PRIV_USER]#<br /></li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ol></li><li><b>Außerhalb des «Verwandschafts-Pfades»</b><br />Auch wenn Sie ein <b>angemeldeter</b> Benutzer sind, kann es vorkommen, dass Sie diese Nachricht erhalten, wenn Sie Daten einer Person ansehen möchten, die mit Ihnen entfernter verwandt ist als der Verwalter zugelassen hat (Verwandschafts-Pfad-Länge).<br />Beispiele:<br />Wenn die Länge des Verwandtschafts-Pfades auf <b>1</b> gesetzt ist, können Sie nur Daten Ihrer eigenen Familie, Vater, Mutter, Geschwister (aber nicht die Ehepartner oder Kinder Ihrer Geschwister) sehen.<br /><br />Wenn die Länge auf <b>2</b> eingestellt ist, können Sie auch die Daten der Ehepartner Ihrer Geschwister und deren Kindern sehen (aber nicht die Ehepartner deren Kinder).<br /><br />Je länger der Verwandtschaftspfad eingestellt ist, umso weiter entferntere Verwandte können Sie im Detail sehen.<br /></li></ul><br />Wenn Sie glauben, Sie sollten das Recht haben bestimmte private Daten zu sehen, kontaktieren Sie den Verwalter über das «Kontakt»-Link auf der Seite.<br /><br />";
$pgv_lang["more_help"]					= "<br />Wenn Sie auf allen Seiten die Kontexthilfe aktivieren möchten, stellen Sie bitte sicher, dass die <b>#pgv_lang[show_context_help]#</b> Option im Hilfe Menü aktiviert wurde und klicken Sie das <b>?</b> neben dem gewünschten Objekt.<br /><br />";
$pgv_lang["more_config_help"]			= "<br /><b>Weitere Hilfe</b><br />Weitere Hilfe finden Sie im Formular. Bitte klicken Sie das <b>?</b> neben der Beschriftung.<br /><br />";
$pgv_lang["start_admin_help"]			= "+++ Beginn zusätzliche Informationen für Verwalter +++";
$pgv_lang["end_admin_help"]				= "--- Ende zusätzliche Informationen für Verwalter ---";
$pgv_lang["multiple_help"]				= "<center>--- Dies ist ein allgemeiner Hilfetext, der mehrere Seiten betrifft ---</center>";
$pgv_lang["header_general_help"]		= "<div class=\"name_head\"><center><b>ALLGEMEINE INFORMATIONEN</b></center></div><br />";
$pgv_lang["best_display_help"]			= "~Ihr Bildschirm~<br />PhpGedView wurde für eine Bildschirmauflösung von 1024x768 Pixel entwickelt. Das ist die minimale Auflösung, in der alles optimal dargestellt werden kann. Falls Sie eine niedrigere Auflösung verwenden (z.B. 800x600 Pixel), werden Sie gelegentlich horizontal scrollen müssen, um alles zu sehen.<br /><br />";
$pgv_lang["preview_help"]				= "~Drucken~<br />Wenn Sie das «Druck-optimierte Version»-Link klicken, wird alles, was für drucken irrelevant bzw. unschön ist (Menüs, Eingabefelder, zusätzliche Links, die Fragezeichen der Kontexthilfe usw.), ausgelassen.<br /><br />In der «Druck-optimierten Version» erscheint das Link <b>Drucken</b> am unteren Seitenrand. Klicken Sie einfach darauf und das Druck-Dialogfenster öffnet sich. Nach dem Drucken klicken Sie einfach das <b>zurück</b> Link und der Bildschirm wird in der normalen Ansicht neu aufgebaut.<br /><br />Anmerkung: Die «Druck-optimierte Version» entfernt einige Links vom Bildschirm, die verbleibenden Links sind aber noch funktionsfähig.<br /><br />";
$pgv_lang["readme_help"]				= "In der Datei <a href='readme.txt' target='_blank'><b>Readme.txt</b></a> finden Sie weitere Informationen.<br /><br />";
$pgv_lang["is_user_help"]				= "--- Dieser Hilfe Text ist identisch mit dem Hilfetext für Besucher. --- <br />--- Um Platz zu sparen, gibt es zu diesem Thema keine besondere Hilfe für Verwalter. ---";
$pgv_lang["edit_raw_gedcom_help"]		= "~#pgv_lang[edit_raw]#~<br />Wenn Sie dieses Link klicken, öffnet sich ein weiteres Fenster, das die GEDCOM-Rohdaten zu den Informationen dieser Seite zeigt. Dort können Sie die GEDCOM-Rohdaten direkt bearbeiten. Achten Sie darauf, dass Ihre Eingaben dem GEDCOM 5.5 Standard entsprechen; es finden nämlich keine Gültigkeitsprüfungen für Ihre Eingaben statt.<br /><br />Die veränderten bzw. hinzugefügten Daten werden in PhpGedView als Änderungen gezeigt und müssen anschließend von einem Benutzer akzeptiert werden, der die dafür notwendigen Rechte besitzt.<br /><br />";
$pgv_lang["RESN_help"]					= "~Fakten Beschränkung~<br />Abgesehen vom allgemeinen Datenschutz besteht in PhpGedView auch noch die Möglichkeit das Zeigen oder Bearbeiten von Fakten zu beschränken.  Jeder mit Editier-Rechten kann Beschränkungen setzen, es sei denn dass Datenschutz oder vorher gesetzte Beschränkungen den Zugriff zu dem jeweiligen Fakten verbieten.<br /><br />Sie können die folgenden Beschränkungstypen setzen:<br /><ul><li><b>#pgv_lang[none]#</b><br />Verwalter und Nutzer mit Editier-Rechten dürfen die Fakt-Daten ändern.  Anderen werden die Fakt-Daten nur gezeigt, wenn die vom Verwalter bestimmten Datenschutzeinstellungen es erlauben.</li><li><b>#pgv_lang[locked]#</b><br />Bearbeiten von Fakt-Daten ist nur Verwaltern erlaubt.  Falls der Nutzer in der Datenbank mit Editier-Rechten eingetragen ist, darf er seine eigenen Fakt-Daten bearbeiten.  Anderen werden Fakt-Daten immer gezeigt.</li><li><b>#pgv_lang[privacy]#</b><br />Verwalter dürfen die Fakt-Daten sehen und bearbeiten.  Nutzer dürfen ihre eigenen Fakt-Daten sehen, und falls sie Editier-Rechte haben, dürfen sie sie auch bearbeiten.  Anderen sind die Fakt-Daten immer verborgen.</li><li><b>#pgv_lang[confidential]#</b><br />Nur Verwalter dürfen die Fakt-Daten sehen und bearbeiten.  Anderen sind die Fakt-Daten immer verborgen.</li></ul><br /><table><tr><th></th><th colspan='2'>Verwalter</th><th colspan='2'>Besitzer</th><th colspan='2'>Andere</th></tr><tr><th></th><th>L</th><th>Ä</th><th>L</th><th>Ä</th><th>L</th><th>Ä</th></tr><tr><td><img src='images/RESN_none.gif' alt='' /> #pgv_lang[none]#</td><th><img src='images/checked.gif' alt='' /></th><th><img src='images/checked.gif' alt='' /></th><th><img src='images/checked_qm.gif' alt='' /></th><th><img src='images/checked_qm.gif' alt='' /></th><th><img src='images/checked_qm.gif' alt='' /></th><th><img src='images/checked_qm.gif' alt='' /></th></tr><tr><td><img src='images/RESN_locked.gif' alt='' /> #pgv_lang[locked]#</td><th><img src='images/checked.gif' alt='' /></th><th><img src='images/checked.gif' alt='' /></th><th><img src='images/checked_qm.gif' alt='' /></th><th><img src='images/checked_qm.gif' alt='' /></th><th><img src='images/checked_qm.gif' alt='' /></th><th><img src='images/forbidden.gif' alt='' /></th></tr><tr><td><img src='images/RESN_privacy.gif' alt='' /> #pgv_lang[privacy]#</td><th><img src='images/checked.gif' alt='' /></th><th><img src='images/checked.gif' alt='' /></th><th><img src='images/checked_qm.gif' alt='' /></th><th><img src='images/checked_qm.gif' alt='' /></th><th><img src='images/forbidden.gif' alt='' /></th><th><img src='images/forbidden.gif' alt='' /></th></tr><tr><td><img src='images/RESN_confidential.gif' alt='' /> #pgv_lang[confidential]#</td><th><img src='images/checked.gif' alt='' /></th><th><img src='images/checked.gif' alt='' /></th><th><img src='images/forbidden.gif' alt='' /></th><th><img src='images/forbidden.gif' alt='' /></th><th><img src='images/forbidden.gif' alt='' /></th><th><img src='mages/forbidden.gif' alt='' /></th></tr></table><ul><li>L: Zeigen erlaubt</li><li>Ä: Ändern erlaubt</li><li><img src='images/checked_qm.gif' alt='' />: Datenschutzeinstellung befragen</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]					= "~DIE BEGRÜSSUNGS SEITE~<br />Dies ist die Begrüßungs-Seite. Sie heißt Sie auf der gewählten <a href=\"#def_gedcom\">GEDCOM</a>-Datei-Seite willkomen. Sie gelangen zurück zu dieser Seite über das Begrüßungs-Seite-Link in der oberen Menüleiste. Wenn mehrere GEDCOM-Dateien auf dieser Seite hinterlegt sind, können Sie eine davon über das Menü wählen.<br /><br /><b>Diese Seite enthält Informationen über:</b> (da dies die Haupt-Seite von PhpGedView ist)<ul><li><a href=\"#index_portal\">Begrüßungs-Seite</a></li><li><a href=\"#header\">Kopfbereich</a></li><li><a href=\"#menu\">Menüs</a></li><li><a href=\"#header_general\">Allgemeine Informationen</a></li><li><a href=\"#def\">Definitionen</a></li></ul><br />Version #VERSION# enthält einen neuen Look für <a href=\"#def_pgv\">PhpGedView</a>. Die Menüs, die Startseite und viele andere Leistungsmerkmale wurden verbessert oder erneuert.<br /><br />";

//-- Index-page Header
$pgv_lang["header_help"]				= "<div class=\"name_head\"><center><b>KOPFBEREICH</b></center></div><br />Der Kopfbereich wird im oberen Teil jeder Seite gezeigt.<br /><br />Der Kopfbereich enthält einige hilfreiche Links, die die gesamte Seite beeinflussen können. Da die Seite durch die Wahl verschiedener <a href=\"#def_theme\">Themes</a> variieren kann, enthält der Kopfbereich je nach gewähltem Theme eventuell unterschiedliche Links.<br /><br /><b>Links, die vorkommen können, sind:</b><ul><li><a href=\"#header_search\">Suche-Feld</a></li><li><a href=\"#header_lang_select\">Sprachwahl</a></li><li><a href=\"#header_user_links\">Benutzer-Links</a></li><li><a href=\"#header_favorites\">Lesezeichen</a></li><li><a href=\"#header_theme\">Theme wechseln</a></li></ul>";
$pgv_lang["header_search_help"]			= "~Kopfbereich: Suchen~<br />Obwohl diese Box klein ist, ist sie doch sehr nützlich.  Sie können damit PhpGedView befehlen, die Datenbank nach fast jedem beliebigen Etwas zu durchsuchen. Wenn Sie den <b>&gt;</b> oder <b>#pgv_lang[search]#</b> Button klicken, fordern Sie die #pgv_lang[search]#-Seite an, wo Sie die Ergebnisse Ihrer Suche sehen können.  Die selbe Seite enthält auch ausführliche Informationen über andere Such-Optionen<br /><br />";
$pgv_lang["header_lang_select_help"]	= "~Kopfbereich: Sprachauswahl~<br />Eines der wichtigsten Leistungsmerkmale dieses Programmes ist der automatische Wechsel der Sprache, passend zur Browser-Spracheinstellung des jeweiligen Besuchers.<br /><br />Manchmal kann diese automatische Einstellung aber zu einer unerwünschten Spracheinstellung führen. Der Besucher kann dann manuell mittels der <b>Sprachwahl</b> die Sprache umschalten. Die Sprachwahl kann in zwei Arten gezeigt werden:<ol><li>Liste</li><li>Eine Leiste von Nationalflaggen</li></ol>";
$pgv_lang["header_user_links_help"]		= "~Kopfbereich: Benutzerlinks~<br />Die Benutzerlinks sind eine kleine Gruppe von hilfreichen Links, die auf jeder Seite an der gleichen Stelle erscheinen, sofern das Theme nicht gewechselt wird.<br /><br />Wenn Sie noch nicht angemeldet sind, sehen Sie nur das <b>Login</b> Link. Wenn Sie angemeldet sind, erscheint: <ul><li><b>Angemeldet als (Ihr Benutzername)</b>. Klicken Sie dieses Link, um zu Ihren Benutzereinstellungen zu gelangen.</li><li>Klicken Sie <b>Logout</b>, um sich abzumelden.</li></ul>";
$pgv_lang["header_favorites_help"]		= "~Kopfbereich: Meine Lesezeichen~<br />Diese Liste zeigt Ihnen Ihre Lesezeichen, sofern Sie welche erstellt haben. Sie zeigt auch die Lesezeichen, die der Verwalter für die GEDCOM-Datei erstellt hat.<br /><br />Wenn Sie auf eines Ihrer Lesezeichen klicken, gelangen Sie zur Seite mit persönlichen Informationen zur jeweiligen Person. Weitere Hilfe zum Erstellen von Lesezeichen finden Sie unter Ihrem persönlichen Portal.<br /><br />";
$pgv_lang["header_theme_help"]			= "~Kopfbereich: Theme wechseln~<br />Sofern vom Verwalter aktiviert, zeigt die «Theme wechseln» Liste alle vorhandenen Themes, von denen Sie eines wählen können. Das Theme bestimmt das Aussehen der Seite. Wenn Sie angemeldet sind, ändern Sie mit Ihrer Wahl im Kopfbereich auch das Theme, das üblicherweise nach Ihrer Anmeldung erscheint.<br /><br />";

//-- Index-page Menu
$pgv_lang["menu_help"]					= "<div class=\"name_head\"><center><b>MENÜS</b></center></div><br />Oben auf der Seite gibt es nun verschiedene Menüpunkte. Wenn Sie mit dem Mauszeiger über die Menüpunkte fahren, öffnet sich ein Untermenü, sofern der Menüpunkt Unterpunkte enthält. Klicken Sie einen Hauptmenüpunkt, so entspricht das einem Klick des obersten Untermenüpunktes.<br /><br />Sie können aus den folgenden Haupt-Menüpunkten wählen:<ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a></li><li><a href=\"#menu_myged\">Mein GedView Portal</a></li><li><a href=\"#menu_charts\">Diagramme</a></li><li><a href=\"#menu_lists\">Listen</a></li><li><a href=\"#menu_annical\">Jahrestag Kalendar</a></li><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a></li><li><a href=\"#menu_search\">Suche</a></li><li><a href=\"#menu_help\">Hilfe</a></li></ul><br />";
$pgv_lang["menu_famtree_help"]			= "~Begrüßungs-Seite~<br />Alle verfügbaren GEDCOM-Dateien werden in diesem Menü aufgeführt.<br /><br />Jede GEDCOM-Datei hat ihre eigene Startseite, so wie diese hier. Wenn nur eine GEDCOM-Datei vorhanden ist, gibt es kein Untermenü für den Menüpunkt «Begrüßungs-Seite».<br /><br />";
$pgv_lang["menu_myged_help"]			= "~Mein GedView Portal~<br />Wenn Sie angemeldet sind, kann das Menü folgende Unterpunkte beinhalten:<dl><dt>Mein GedView Portal</dt><dd>Führt Sie zu Ihrer eigenen konfigurierbaren «Startseite».</dd><dt>Eigene Benutzerdaten bearbeiten</dt><dd>Hier können Sie Ihre persönlichen Daten einstellen.</dd><dt>Mein Stammbaum</dt><dd>Wenn Sie eine Startperson für diese GEDCOM-Datei gewählt haben, führt Sie dieses Link zum Stammbaum-Diagramm dieser Person.</dd><dt>Mein Datenblatt</dt><dd>Dieses Link führt Sie zu der Seite mit persönlichen Informationen über Sie selbst, auf der die genealogischen Daten zu Ihrer Person und Ihrer Familie dargestellt wird.</dd></dl>";
$pgv_lang["menu_charts_help"]			= "~Diagramme~<br />Alle verfügbaren Diagramme sind in diesem Menü zu finden:<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>Führt Sie zum Stammbaum-Diagramm dieser GEDCOM-Datei. Der Stammbaum geht von der Startperson der GEDCOM-Datei aus. Wenn Sie angemeldet sind, können Sie die Startperson für diesen Menüpunkt selbst wählen.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Der Nachfahrenbaum ist vergleichbar mit einem umgekehrten <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>. Dieser Vergleich hinkt zwar, aber während der Stammbaum alle Vorfahren einer Person zeigt, zeigt der Nachfahrenbaum alle Nachfahren dieser Person.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Die Erlebnisse einer Person werden entlang einer Zeitleiste dargestellt. Es kann sehr interessant sein, die Ereignisse im Leben von 2 oder mehr Personen mittels einer Zeitleiste zu vergleichen.</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Hier können Sie die Verwandtschaft einer Person zu Ihnen selbst oder zu einer anderen Person ermitteln.</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Ähnelt sehr dem <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, zeigt aber mehr Detailinformationen und verschiedene <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#en</a>.</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Ähnelt sehr dem <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, aber ist eine eher graphische Darstellung.</dd></dl>";
$pgv_lang["menu_lists_help"]			= "~Listen~<br />Dieses Menü führt Sie zu den verfügbaren Listen:<dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>In diesen beiden Listen können Sie alphabetisch nach Personen suchen.<br />Die erste zeigt eine Liste von Personen, die zweite von Familien.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Dieser Menüpunkt erstellt eine Liste aller Quellen, die in dieser GEDCOM-Datei vorkommen.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Hier können Sie nach Personen suchen, die irgend eine Verbindung mit dem jeweiligen Ort haben. Zwei Listen werden dabei erstellt: Die Personen werden zuerst aufgezählt, die Familien danach.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Dieser Menüpunkt erscheint nur, wenn der Verwalter ihn aktiviert hat.<br />Er führt zu einer Liste mit allen Multimedia-Dateien, die in dieser Datenbank vorkommen.</dd></dl>";
$pgv_lang["menu_annical_help"]			= "~Jahrestag Kalender~<br />Der Jahrestag-Kalender zeigt alle Ereignisse einer GEDCOM-Datei für ein bestimmtes Datum, einen Monat oder ein Jahr an.<dl><dt><a href=\"?help=day_month_help\">#pgv_lang[viewday]#</a></dt><dd>Klicken Sie hier, so erhalten Sie einen Jahrestagkalender, der die Ereignisse des heutigen Tages zeigt.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewmonth]#</a></dt><dd>Führt Sie zu einem Monats-Kalender, der die Ereignisse des aktuellen Monats zeigt.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewyear]#</a></dt><dd>Führt Sie zu einem Jahrestagkalender, der die Ereignisse des gewählten Jahres zeigt.</dd></dl>";
$pgv_lang["menu_clip_help"]				= "~Ausschnittsammelbehälter~<br />Sofern durch den Verwalter aktiviert, erscheint dieser Menüpunkt in der Menüleiste. Der Ausschnittsammelbehälter ermöglicht das Zusammenstellen von Daten über Personen, Familien und Quellen zum anschliessenden Download im GEDCOM 5.5 Format.<br /><br />";
$pgv_lang["menu_search_help"]			= "~Suche~<br />Die Such-Seite, zu der Sie gelangen wenn Sie dieses Link klicken, ist die leistungsfähigere Schwester des Suchfeldes im Kopfbereich.<br /><br />";
$pgv_lang["menu_help_help"]				= "~Hilfe~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>DIE BEGRÜSSUNGS-SEITE</b></center></div><br />";
$pgv_lang["index_portal_help"]			= "Die Begrüßungs-Seite besteht aus mehreren einzelnen Blöcken, die vom Verwalter zusammengestellt werden. Für jede GEDCOM-Datei auf dieser Seite, sofern hier mehrere GEDCOM-Dateien vorhanden sind, kann eine eigene Begrüßungs-Seite erstellt werden. Je nach Bestimmen des Verwalters kann die Begrüßungs-Seite eine Auswahl der folgenden Blöcke enthalten:<ul><li><a href=\"#index_welcome\"><b>Willkommen</b></a></li><li><a href=\"#index_login\"><b>Login</b></a></li><li><a href=\"#index_events\"><b>Bevorstehende Ereignisse</b></a></li><li><a href=\"#index_onthisday\"><b>An diesem Tag</b></a></li><li><a href=\"#index_charts\"><b>Diagramme</b></a></li><li><a href=\"#index_favorites\"><b>Lesezeichen</b></a></li><li><a href=\"#index_stats\"><b>Statistiken</b></a></li><li><a href=\"#index_common_surnames\"><b>Häufigste Nachnamen</b></a></li><li><a href=\"#index_media\"><b>Zufällig ausgewähltes Bild</b></a></li><li><a href=\"#index_loggedin\"><b>Angemeldete Benutzer</b></a></li><li><a href=\"#gedcom_news\"><b>Neuigkeiten</b></a></li><li><a href=\"#recent_changes\"><b>Aktuelle Änderungen</b></a></li></ul><br />";
$pgv_lang["index_welcome_help"]			= "~WILLKOMMEN~<br />Der Willkommen Block zeigt Ihnen die aktuelle GEDCOM-Datei, das Datum und die Uhrzeit und, sofern vom Verwalter aktiviert, den <b>Besucher Zähler</b>.<br /><br />Dieser Zähler wird nur im Willkommen-Block und auf der persönlichen Seite gezeigt. Der Zähler zählt die Zugriffe zu diese Seiten. Das heißt, er zeigt wie oft diese Seiten besucht wurden.<br /><br />";
$pgv_lang["index_login_help"]			= "~LOGIN~<br />Obwohl Sie sich auf fast jeder Seite anmelden können, werden Sie das üblicherweise auf der ersten Seite tun, weil Sie verborgene private Informationen eventuell nur nach der Anmeldung sehen können.<br /><br />Tragen Sie hierzu Ihren <b>Benutzernamen</b> und Ihr <b>Kennwort</b> ein und klicken Sie den Login Button.<br /><br />#pgv_lang[new_password_help]#<br />";
$pgv_lang["index_events_help"]			= "~#pgv_lang[upcoming_events_block]#~<br />Dieser Block zeigt Ereignisse vom heutigen Tag bis zu einen Monat im voraus.<br /><br />";
$pgv_lang["todo_help"]					= "~Unerledigte Aufgaben Block~<br />Dieser Block hilft Ihnen, unerledigte Aufgaben (_TODO Ereignisse) in der Datenbank zu verfolgen.<br /><br />Um solche Aufgaben der Datenbank hinzuzufügen, müssen Sie eventuell erst die GEDCOM Konfigurations-Datei ändern.  Die Listen der Ereignisse, die den verschiedenen Seiten hinzugefügt werden können, müssen <b>_TODO</b> enthalten.  Die vier Listen, die Sie im «Bearbeitungsoptionen» Abteil der GEDCOM-Konfiguration finden, je eine für die Personen-, Familien-, Quellen-, und Archivseiten, sind voneinander unabhängig.  Die Reihenfolge der Einträge in diesen Listen ist ohne weitere Bedeutung; Sie können neue Einträge vorn an die Listen hinzufügen.<br /><br />";
$pgv_lang["todo_show_other_help"]		= "Anderen Benutzern zugewiesene unerledigte Aufgaben zeigen";
$pgv_lang["todo_show_unassigned_help"]	= "Noch nicht zugewiesene unerledigte Aufgaben zeigen";
$pgv_lang["todo_show_future_help"]		= "Zeige unerledigte Aufgaben, deren Daten in der Zukunft liegen.  Normalerweise werden unerledigte Aufgaben gezeigt, deren Daten schon verlaufen sind.";
$pgv_lang["yahrzeit_help"]				="~JAHRZEITEN BLOCK~<br />Dieser Block zeigt Jahrzeiten die sich in den nächsten Tagen jähren.  Das sind die Todestage naher Verwandten.<br /><br />Jahrzeiten sind in der jüdischen Tradition im Gebrauch; in anderen Traditionen kommen sie nur noch selten vor. In der jüdischen Schreibweise kann «Jahrzeit» auch als «Yahrzeit» oder «Yartzeit» geschrieben werden.<br /><br />Der Verwalter bestimmt, wie weit in die Zukunft dieser Block nach Jahrzeiten sucht. Weitere Optionen verändern das Aussehen des Blocks.<br /><br />";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br />Geben Sie die Anzahl der Tage die in diesem Block gezeigt werden sollen.  Sie dürfen nicht mehr als <b>#GLOBALS[DAYS_TO_SHOW_LIMIT]#</b> eingeben.  Falls Sie eine größere Zahl eingeben, wird angenommen, dass Sie <b>#GLOBALS[DAYS_TO_SHOW_LIMIT]#</b> eingegeben haben.<br /><br />Die gegebene Limit ist vom Verwalter in der <b>#pgv_lang[DAYS_TO_SHOW_LIMIT]#</b> Option der <b>#pgv_lang[displ_hide_conf]#</b> Gruppe innherhalb des Abschnitts <b>#pgv_lang[displ_conf]#</b> der GEDCOM Konfiguration festgesetzt.<br /><br />";
$pgv_lang["random_media_persons_or_all_help"]	= "~#pgv_lang[random_media_persons_or_all]#~<br />Diese Option erlaubt Ihnen zu bestimmen, welche Medientypen gezeigt werden können.<br /><br />Wenn Sie <b>#pgv_lang[random_media_persons]#</b> wählen, werden nur Medien, die mit Personen verbunden sind, gezeigt. Normalerweise sind das Fotos oder Gemälde. Wenn Sie <b>#pgv_lang[random_media_events]#</b> wählen, werden nur Medien, die mit Fakten oder Ereignissen verbunden sind, gezeigt. Das könnten Abbilder von Urkunden sein. Wenn Sie <b>#pgv_lang[all]#</b> wählen, zeigt dieser Block alle Medientypen.<br /><br />";
$pgv_lang["random_media_filter_help"]	= "~#pgv_lang[filter]#~<br /><br />Sie können bestimmen, welche Medienformate und Medientypen von diesem Block gezeigt werden dürfen.  Alle markierte Formate und Typen sind zum Zeigen in diesem Block erlaubt.<br /><br />Formate und Typen, die in Ihrer Datenbank vorkommen aber nicht in diesen Listen enthalten sind, sind immer zum Zeigen erlaubt.  Zum Beispiel, falls Ihre Datenbank Medien im <b><i>pdf</i></b> Format enthält, sind sie stets zum Zeigen erlaubt.  Gleichfalls sind Medien vom Typ <b><i>special</i></b>, die in Ihrer Datenbank vorkommen, stets zum Zeigen erlaubt.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br />Mit dieser Option können Sie verursachen dass bestimmte datierte Ereignisse nicht gezeigt werden.  Zum Beispiel, #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, etc. haben gewöhnlich Daten.  Wenn Sie <b>#pgv_lang[yes]#</b> wählen, werden nur Geburten, Tode, und Ehen gezeigt. Wenn Sie <b>#pgv_lang[no]#</b> wählen, werden alle datierte Ereignisse gezeigt.<br /><br />";
$pgv_lang["style_help"]					= "~#pgv_lang[style]#~<br />Diese Option bestimmt das Format der Informations-Darstellung.<br /><br />Wenn Sie <b>#pgv_lang[style1]#</b> wählen, werden die Informationen als Text, ähnlich dem Text in Diagrammen, gezeigt. Dieses Format eignet sich gut für Blöcke die im rechten Teil der Seite gezeigt werden.<br /><br />Wenn Sie <b>#pgv_lang[style2]#</b> wählen, werden die Informationen in einer Tabelle gezeigt.  Dieses Format eignet sich besser für Blöcke die im linken Teil der Seite gezeigt werden.<br /><br />";
$pgv_lang["cal_dowload_help"]			= "~#pgv_lang[cal_download]#~<br />Diese Option bestimmt, ob der Button, der das Herunterladen von Kalender-Ereignissen betätigt, allen angemeldeten Nutzern gezeigt wird oder nicht.  Die mit Hilfe dieses Buttons übertragene Kalender-Datei kann in passende Programme wie Microsoft Outlook importiert werden, wodurch zum Beispiel automatische Erinnerungs-Mails gesendet werden können.<br /><br />Wenn Sie <b>#pgv_lang[no]#</b> wählen, können angemeldete Nutzer Kalender-Dateien nicht herunterladen. Wenn Sie <b>#pgv_lang[yes]#</b> wählen, wird der «Download» Button gezeigt. Der Button ist niemals sichtbar wenn der Nutzer sich nicht angemeldet hat.<br /><br />";
$pgv_lang["index_charts_help"]			= "~#pgv_lang[charts_block]#~<br />Der Diagramm-Block ermöglicht Ihnen, Diagramme auf der Begrüßungsseite oder auf der «#pgv_lang[mygedview]#» Seite zu zeigen.  Dieser Block ist für den linken Teil der Seite gedacht, da der rechte Teil sehr schmal ist.<br /><br />Verwalter bestimmen die ID-Nummer der Startperson und das Diagramm das auf der Begrüßungsseite dargestellt wird.  Für die «#pgv_lang[mygedview]#» Seite bestimmt der Benutzer diese Optionen.<br /><br />Die Diagramme verhalten sich hier genau wie sie sich auf anderen Seiten verhalten.  Wenn Sie den Kasten einer Person klicken, erhalten Sie Details.<br /><br />";
$pgv_lang["index_onthisday_help"]		= "~#pgv_lang[on_this_day]#~<br />Dieser Block ist dem «#pgv_lang[upcoming_events]#» Block ähnlich, nur dass Ereignisse gezeigt werden, die sich heute jähren.<br /><br />";
$pgv_lang["index_favorites_help"]		= "~#pgv_lang[gedcom_favorites]#~<br />Dieser Block entspricht im Großen und Ganzen dem «Meine Lesezeichen»-Bereich der «#pgv_lang[mygedview]#» Seite. In diesem Fall aber kann nur der Verwalter die Lesezeichen für die GEDCOM-Datei verwalten. So kann er auf besondere Personen aufmerksam machen.<br /><br />Auf jeder Seite erreichen Sie die «Stammbaum-Lesezeichen» über eine Liste im Kopfbereich. Über diese Links gelangen Sie jeweils zu der Seite mit persönlichen Informationen der geklickten Person.<br /><br />Um Platz zu sparen, werden in den Boxen nicht alle Informationen gezeigt. Rechts in der Box sehen Sie ein Lupen-Symbol, mit dem Sie weitere Informationen zeigen lassen können.<br /><br />Wenn Sie den Namen klicken gelangen Sie zu dessen #pgv_lang[indi_info]# Seite.<br /><br />";
$pgv_lang["index_add_favorites_help"]	= "~#pgv_lang[add_favorite]#~<br />Durch Eingaben in diesem Formular können Sie neue Lesezeichen zu Ihrer Liste hinzufügen.  Sie müssen ein Personen-, Familien-, oder Quellen-ID eingeben oder danach in der Datenbank suchen.  Anstatt dessen, können Sie auch eine Internet-Adresse mit Titel eingeben.  Bemerkungen über das Lesezeichen können leer bleiben.  Bemerkungen die hier eingegeben sind werden im Lesezeichen Block als Unterschrift des jeweiligen Eintrages gezeigt.<br /><br />";
$pgv_lang["index_stats_help"]			= "~#pgv_lang[gedcom_stats]#~<br />Dieser Block zeigt einige statistische Daten über die aktuelle Datenbank. Falls Sie weitere Informationen benötigen, senden Sie eine Nachricht an die Kontaktadresse am unteren Rand der Seite.<br /><br />";
$pgv_lang["index_common_names_help"]	= "~#pgv_lang[common_surnames]#~<br />Hier werden Nachnamen, die in der Datenbank häufig vorkommen, gezeigt. Die Anzahl der dargestellten Namen kann vom Verwalter festgelegt werden. Derzeit werden alle Namen gezeigt, die mindestens #GLOBALS[COMMON_NAMES_THRESHOLD]# mal in der Datei vorkommen.<br /><br />Die Namen kann man klicken. Wenn Sie einen Namen klicken, gelangen Sie zur #pgv_lang[individual_list]#, wo Sie genauere Informationen zu diesem Namen erhalten.<br /><br />";
$pgv_lang["index_common_given_names_help"]	= "~Häufig vorkommende Vornamen~<br />Hier werden Vornamen, die in der Datenbank häufig vorkommen, gezeigt. Die Anzahl der dargestellten Namen können Sie einstellen.<br /><br />";
$pgv_lang["index_media_help"]			= "~#pgv_lang[random_media_block]#~<br />Bei jedem Besuch der Seite zeigt dieser Block ein anderes Bild oder eine andere Multimedia-Datei.<br /><br />Wenn Sie das Bild oder seinen Namen klicken, erhalten Sie das Bild in Originalgröße. Unterhalb des Bildes gibt es ein Link zur Person, mit der das Bild verbunden ist. Klicken Sie den Namen dieser Person, um zur persönlichen Seite der Person zu gelangen.<br /><br />";
$pgv_lang["index_loggedin_help"]		= "~#pgv_lang[users_logged_in]#~<br />Dieser Block zeigt wie viele Benutzer zur Zeit angemeldet sind.<br /><br />";
$pgv_lang["index_gedcom_news_help"]		= "~#pgv_lang[gedcom_news_block]#~<br />Der «#pgv_lang[gedcom_news]#»-Block ist als Tafel nützlich. Der Verwalter kann wichtige Ankündigungen oder interessante Neuigkeiten hier bekanntgeben.<br /><br />Wenn Sie etwas Interessantes veröffentlichen möchten, kontaktieren Sie bitte den Verwalter, der Ihre Meldung dann in diesem Block bekanntgeben kann.<br /><br />";
$pgv_lang["recent_changes_help"]		= "~#pgv_lang[recent_changes_block]#~<br />Dieser Block zeigt Ihnen die jüngsten Änderungen in der GEDCOM-Datei, welche anhand des CHAN-tags erkannt werden.<br /><br />";
$pgv_lang["gedcom_news_limit_help"]		= "Sie können die Anzahl der dargestellten Notizen beschränken, so dass der #pgv_lang[gedcom_news_block]# Block nicht zu hoch wird.<br /><br />Diese Option bestimmt ob überhaupt Beschränkungen belegt sind, oder ob diese Beschränkungen das Alter oder die Anzal der Notizen berücksichtigen.<br /><br />";
$pgv_lang["gedcom_news_flag_help"]		= "Geben Sie den Beschränkungswert ein.<br /><br />Wenn Sie die Altersbeschränkung gewählt haben, verbirgt das Programm alle Notizen die älter als die eingegebenen Tage sind.  Wenn Sie die Anzahlbeschränkung gewählt haben, wird nur die eingegebene Anzahl von Notizen, jüngste Notizen zuerst, gezeigt.  Die restlichen Notizen sind verborgen.  Falls Sie hier <b>0</b> (null) eingeben, entfällt jede Beschränkung der Notizenanzeige.<br /><br />";
$pgv_lang["gedcom_news_archive_help"]	= "Zum Reduzieren der Höhe des #pgv_lang[gedcom_news]# Blocks sind mehrere Notizen verborgen.  Wenn Sie das <b>#pgv_lang[gedcom_news_archive]#</b> Link klicken, können Sie alle Notizen sehen.<br /><br />";
$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br />Dieser Block erlaubt dem Verwalter bestimmte Informationen auf der Hauptseite zu zeigen.  Der Zweck ähnelt den #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, und #pgv_lang[gedcom_stats_block]# Blöcken, aber der Verwalter hat über sein Aussehen weitaus mehr Einfluss.<br /><br />";
$pgv_lang["index_htmlplus_title_help"]	= "~#factarray[TITL]#~<br />Dieser Text soll leer oder sehr kurz sein.  Falls er leer ist, wird der <br />#pgv_lang[htmlplus_block_name]# Block als einfacher Block gezeigt, genau wie der #pgv_lang[html_block_name]# Block.  Wenn Sie einen kurzen Text eingeben, ändert sich das Aussehen dieses Blocks so dass er, genau wie die anderen Blöcke, auch einen Titel hat.  Der eingegebene Text wird als Titel benutzt.<br /><br />";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br />Ihnen sind einige Standard-Vorlagen zur Verfügung gestellt, damit Sie schneller mit diesem Block voran kommen.  Wenn Sie eine dieser Standard-Vorlagen wählen, wird dessen Inhalt in der Textbox gezeigt.  Sie können dann die Angaben Ihren Wünschen gemäß anpassen.<br /><br />";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br />Im Gegenteil zu den #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, und #pgv_lang[gedcom_stats_block]# Blöcken haben Sie vollen Einfluss über das Aussehen des Blocks.  In diesem Block können Sie <b>HTML tags</b> einfügen. Bitte achten Sie darauf, die Start- und End-Tags korrekt einzutragen. Dieses Programm verwendet <i>Style Sheets</i> (CSS). Jedes Theme hat seine eigene CSS-Datei. Sie können auch «Klassen» aus diesen Style-Sheets verwenden. Der Block kann Auszüge der Informationen der aktuellen Datenbank zeigen.<br /><br />Verweise auf Informationen der Datenbank sind als Stichwörter zwischen <b>&#35;</b> Zeichen erkennbar. Zum Beispiel, <b>&#35;totalFamilies&#35;</b> ist ein Verweis auf die Anzahl der Familien die sich in der Datenbank befinden.  Gelegentlich möchten Sie wahrscheinlich solche Texte nicht als Datenbank-Verweise sondern als normale Texte verwenden.  Um das zu bewirklichen, müssen Sie die <b>&#35;</b> Zeichen in ihren symbolischen Äquivalent ändern. Zum Beispiel, der Text <b>&&#35;35;totalFamilies&&#35;35;</b> wird nicht als Datenbank-Verweis erkannt, sondern wird als <b>&#35;totalFamilies&#35;</b> gezeigt.<br /><br />Ausführliche Beispiele für diesen Block finden Sie in Vorlage-Dateien die sich im «blocks/» Verzeichnis befinden. Die Vorlagen benutzen sogar Verweise auf Sprach-Dateien.<br /><br />Die <b>#pgv_lang[htmlplus_block_keyword]#</b> Vorlage enthält eine Liste aller unterstützten Datenbank-Verweise.<br /><br />";
$pgv_lang["index_htmlplus_compat_help"]	= "~#pgv_lang[htmlplus_block_compat]#~<br />Diese Option schaltet den Kompatibilitäts-Modus ein.<br /><br />Falls eingeschaltet, werden die alten sowie die neuen Datenbank-Verweise richtig erkannt.  Zum Beispiel, der Text <b>&#35;TOTAL_FAM&#35;</b> wird genau wie der Text <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> wie <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> wie <b>&#35;topTenLargestFamily&#35;</b>, usw bearbeitet.<br /><br />Ihnen wird empfohlen, diesen Modus nur wenn absolut notwendig zu benutzen.<br /><br />";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br />Bitte wählen Sie eine Datenbank.<br /><br />Bei Ihnen sind mehrere Datenbanken vorhanden.  Verweise wie <b>&#35;totalFamilies&#35;</b> können nur eine Datenbank zugreifen.  Mit dieser Option können Sie die Datenbank bestimmen, die für alle solche Verweise benutzt wird.  Jeder #pgv_lang[htmlplus_block_name]# Block kann nur eine Datenbank zugreifen.<br /><br />";
$pgv_lang["showUnknown_help"]			= "~#pgv_lang[showUnknown]#~<br />Zeige oder verberge die Vornamensliste von Personen mit unbekanntem Geschlecht.<br /><br />Der #pgv_lang[block_givn_top10]# Block verbirgt immer leere Vornamenslisten.  Durch diese Option können Sie die Vornamensliste von Personen mit unbekanntem Geschlecht immer verbergen, obwohl solche Personen in Ihrer Datenbank vorhanden sind.<br /><br />";

//-- Index-Page Help
$pgv_lang["help_help"]					= "Natürlich wäre der Idealfall ein Programm, das so einfach zu benutzen ist, dass man keine Erklärungen benötigt. Es sollte so einfach sein, wie ein Buch zu lesen.<br /><br />Obwohl dieses Programm recht kompliziert und leistungsstark ist, sollte man das am Benutzerinterface kaum bemerken. Fast alles kann ohne Erklärungen benutzt werden. Weil es sicherlich auch viele Ahnenforscher gibt, die noch wenig Erfahrung mit Computern oder dem Internet haben, steht dieses Hilfesystem bereit.<br /><br />Im Hilfe-Menü stehen folgende Punkte zur Verfügung:<br />";
$pgv_lang["help_page_help"]				= "<dl><dt><b>Hilfe zu dieser Seite</b></dt><dd>Für alle Seiten gibt es eine allgemeine «Hilfe für diese Seite».<br /><br />Wenn Sie auf einer beliebigen Seite sind, klicken Sie diesen Menüpunkt, um die Seitenhilfe zu erhalten, die Sie über die Objekte informiert, die sich auf dieser Seite befinden. Die Seitenhilfe ist in den meisten Fällen kurz gehalten.<br /><br />Falls Sie mehr Hilfe oder Informationen über ein bestimmtes Objekt auf der Seite benötigen, sollten Sie die «Kontext-bezogene Hilfe» Option des Hilfemenüs beachten.</dd></dl>";
$pgv_lang["help_content_help"]			= "<dl><dt><b>Hilfe Inhalt</b></dt><dd>Wenn Sie diesen Menüpunkt klicken, öffnet sich ein Fenster, das ein Verzeichnis der Haupt-Hilfethemen enthält.<br /><br />Dieses Verzeichnis wird voraussichtlich noch mit Hilfe-Unterthemen ergänzt.</dd></dl>";
$pgv_lang["help_faq_help"]				= "<dl><dt><b>FAQ List</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]				= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]				= "<dl><dt><b>Kontext-bezogene Hilfe zeigen/verbergen</b></dt><dd>Dieser Menüpunkt kann sehr hilfreich sein. Wenn Sie dieses Link klicken, wird die «Kontext-Hilfe» ein- bzw. ausgeschaltet.<br /><br />Was ist das? Wenn sie aktiviert ist, sehen Sie ein Fragezeichen neben den meisten Links, Boxen oder Buttons. Wenn Sie dieses <b>?</b> klicken, erscheint ein Fenster mit weiteren Informationen zu diesem Element.<br /><br />Wenn Sie «Kontext-bezogene Hilfe verbergen» klicken, werden alle diese Fragezeichen verborgen, bis Sie «Kontext-bezogene Hilfe zeigen» klicken.</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]					= "<div class=\"name_head\"><center><b>DEFINITIONEN</b></center></div><br />Einige Erklärungen zu Begriffen in diesem Hilfetext:<ul><li><a href=\"#def_gedcom\">GEDCOM</a></li><li><a href=\"#def_gedcom_date\">Daten</a></li><li><a href=\"#def_pgv\">PhpGedView</a></li><li><a href=\"#def_portal\">Portal</a></li><li><a href=\"#def_theme\">Theme</a></li></ul>";
$pgv_lang["def_portal_help"]			= "~Portal~<br />Auf dieser Webseite ist das Portal so etwas wie ein Empfang im Hotel. Es ist der Ausgangspunkt für Ihren Besuch auf dieser Seite, der auch wichtige Informationen, Erklärungen und Menüs usw. enthält.<br /><br />";
$pgv_lang["def_gedcom_help"]			= "~GEDCOM Datei~<br />Zitat aus der Einleitung zum GEDCOM 5.5.1 Standard:<div class=\"list_value_wrap\">GEDCOM was developed by the Family History Department of The Church of Jesus Christ of Latter-day Saints (LDS Church) to provide a flexible, uniform format for exchanging computerized genealogical data.&nbsp; GEDCOM is an acronym for <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication.&nbsp; Its purpose is to foster the sharing of genealogical information and the development of a wide range of inter-operable software products to assist genealogists, historians, and other researchers.</div><br />Deutsche Version:<div class=\"list_value_wrap\">GEDCOM wurde von der Abteilung für Familien-Geschichte der Kirche Jesu Christi der Heiligen der Letzten Tage (HLT Kirche) entwickelt, mit dem Ziel ein einheitliches aber auch anpaßbares Format für den Tausch von computer-liesbaren genealogischen Daten zu erstellen.&nbsp; GEDCOM ist ein Akronym von <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication.&nbsp; (Verbreitung von Daten der Ahnenforschung)&nbsp; Zum Zweck ist das Fördern des Tausches genealogischer Informationen und das Entwickeln von einer großen Reihe zusammenarbeitender Ahnenforschungs-Software für Ahnenforscher, Historiker, und andere.</div><br />Der GEDCOM 5.5.1 <u>vorläufige</u> Standard, nach dem sich PhpGedView richtet, kann als PDF-Datei von hier übertragen werden:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">GEDCOM 5.5.1 Standard</a> Bitte beachten Sie, dass dieser Standard nur in der englischen Sprache erhältlich ist.<br /><br />GEDCOM-Dateien enthalten alle Informationen über je einen Stammbaum. Alle Ereignisse, Daten, Namen usw. sind in der GEDCOM-Datei gespeichert. GEDCOM-Dateien enthalten diese Daten nach einer strengen Syntax, damit sie austauschbar bleiben, unabhängig von dem verwendeten Programm, dem Betriebssystem oder benutzten Rechner.<br /><br />";
$pgv_lang["def_gedcom_date_help"]		= "~Datumsangaben~<br />Da die Datumsangaben innerhalb einer GEDCOM-Datei internationalen Regeln folgen müssen, gibt es eine einheitliche Schreibweise dafür.<br /><br />Obwohl das Datums-Feld freie Texteingabe erlaubt, sollten Sie folgende Beschreibungen beachten:<ol><li>Genaue Daten werden immer in der Form DD MMM YYYY eingegeben.  Z.B., <b>01&nbsp;MAR&nbsp;1801</b> oder <b>14&nbsp;DEC&nbsp;1950</b>.</li><li>Bei ungenauen Daten, wo Ihnen ein Teil unbekannt ist, können Sie den unbekannten Teil weglassen.  Z.B. <b>MAR&nbsp;1801</b> oder <b>14&nbsp;DEC</b>.</li><li>Wenn Sie nicht über das Datum sicher sind, oder bei unbestätigten Daten, können Sie z.B. <b>ABT&nbsp;MAR&nbsp;1801</b> (abt = about = ungefähr), <b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> (bef = before = vor), <b>AFT&nbsp;1949</b> (aft = after = nach) eingeben.</li><li>Datenbereiche werden in folgenden Formen eingegeben: <b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b> (from = von, to = bis) oder <b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b> (bet = between = zwischen), and = und)<br /><br />Die <b>FROM</b> Form deutet an, dass das beschriebene Ereignis dauernd während diesem Zeitraum statt fand, und wird bei Ereignissen wie Berufen benutzt. Die <b>BET</b> Form deutet an, dass das beschriebene Ereignis einmal irgendwann in diesem Zeitraum statt fand, und wird bei Ereignissen wie Geburten benutzt.<br /><br />Bei ungenauen Datenangaben, wo der Tag oder der Monat fehlt, werden immer der erste oder der letze mögliche Tag angenommen, abhängig davon, ob dieses ungenaue Datum vor oder hinter den Wörtern TO oder AND vorkommt.  Z.B., <b>FEB&nbsp;1804</b> bedeutet <b>01&nbsp;FEB&nbsp;1804</b> wenn das Datum vor den Wörtern TO oder AND eingegeben wird, und <b>29&nbsp;FEB&nbsp;1804</b> wenn es hinter diesen Wörtern vorkommt.</li></ol><br />Achten Sie darauf, die Daten und die Abkürzungen in englischer Sprache einzutragen, damit die GEDCOM-Datei austauschbar bleibt und alle Programme Ihre Angaben richtig verstehen und berechnen können. Das Programm stellt mit Ihren Datumsangaben auch Berechnungen an. Wenn Daten fehlerhaft eingegeben sind, liefert das Programm falsche Berechnungen.<br /><br />";
$pgv_lang["def_gramps_help"]			= "~GRAMPS XML Dateien~<br />Zitat aus der Beschreibung des GRAMPS Projekts:<div class=\"list_value_wrap\">GRAMPS helps you track your family tree.&nbsp; It allows you to store, edit, and research genealogical data.&nbsp; GRAMPS attempts to provide all of the common capabilities of other genealogical programs, but, more importantly, to provide an additional capability of integration not common to these programs.&nbsp; This is the ability to input any bits and pieces of information directly into GRAMPS and rearrange/manipulate any/all data events in the entire data base (in any order or sequence) to assist the user in doing research, analysis and correlation with the potential of filling relationship gaps.</div><br />Deutsche Version:<div class=\"list_value_wrap\">GRAMPS hilft Ihnen, Ihrem Stammbaum zu folgen.&nbsp; Sie können genealogische Daten speichern, bearbeiten, und nachforschen.&nbsp; GRAMPS versucht, alle Funktionen, die andere genealogische Programme gemeinsam haben, zu unterstützen.&nbsp; Aber, was viel wichtiger und nicht in den meisten anderen Programmen vorhanden ist, GRAMPS versucht auch bessere Integrations-Methoden zu unterstützen.&nbsp; Mit GRAMPS können Sie Informationen teilweise in die Datenbank eingeben, und dann Ereignisse einzeln oder zusammen umsortieren oder anders bearbeiten wie Sie möchten.&nbsp; GRAMPS ermöglicht leichte Forschung, Analyse, und Beziehungsermittlung der genealogischen Daten um Lücken darin zu füllen.</div><br />Links zur Beschreibung von GRAMPS XML v1.1.0 im RELAX NG Schema und auch im DTD Format sind <b><a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">hier</a></b> zu finden. Um mehr Auskunft über das GRAMPS Projekt zu finden, sollten Sie sich an die <b><a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a></b> Hauptseite wenden. Informationen über GRAMPS sind leider nur in der englischen Sprache erhältlich.<br /><br />";
$pgv_lang["def_pgv_help"]				= "~PhpGedView~<br />PhpGedView (oder PGV) ist ein Programm, entwickelt von John Finlay, um GEDCOM Dateien über das Internet zu betrachten.<br /><br />Wie Sie sehen, liefert dieses Programm nicht nur statische Seiten ins Internet, sondern arbeitet dynamisch und kann vielen Bereichen angepasst werden.<br /><br />John begann die Entwicklung allein aber inzwischen arbeitet ein internationales Team von Entwicklern und Übersetzern zusammen, um dieses Programm zu verbessern.<br /><br />Außer dem bloßen Betrachten von GEDCOM-Dateien, können berechtigte Benutzer auch zusammen arbeiten, und Ereignisse online hinzufügen oder editieren.<br /><br />";
$pgv_lang["def_theme_help"]				= "~Theme~<br />Diese Seite kann unterschiedlich aussehen (in Bezug auf Farben, Anordnung der Elemente usw.), was durch sogenannte Themes erreicht wird.<br /><br />Der Verwalter wählt zunächst ein Standard-Theme aus. So sieht die Seite zunächst einmal für jeden Besucher gleich aus. Sofern vom Verwalter erlaubt, können Besucher aber auch ihr Lieblings-Theme aus einer Liste vorhandener Themes wählen. Wenn ein Benutzer sein bevorzugtes Theme gewählt hat, erscheint die Seite für ihn in diesem Aussehen, sobald er sich wieder angemeldet hat.<br /><br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br />Dies ist Ihre persönliche #pgv_lang[mygedview]# Seite.<br /><br />Sie finden hier Links zu Ihren persönlichen Daten wie <b>Meine Benutzerdaten, Mein Datenblatt</b> (das ist die Seite mit Informationen zu Ihrer Person), <b>Mein Stammbaum</b>. Außerdem können hier die Blöcke <b>Nachrichten</b>, <b>Journal</b> (wie ein Notizbuch) und weitere enthalten sein.<br /><br />Das Layout dieser Seite entspricht dem der Begrüßungs-Seite. Während die Begrüßungs-Seite vom Verwalter zusammengestellt wird, können Sie diese Seite selbst zusammenstellen.<br /><br />Das Link zum Anpassen dieser Seite finden Sie entweder im Willkommen-Block oder separat auf dieser Seite.<br /><br />Sie können folgende Blöcke wählen:<ul><li><a href=\"#mygedview_welcome\"><b>Willkommen</b></a></li><li><a href=\"#mygedview_customize\"><b>Mein GedView Portal anpassen</b></a></li><li><a href=\"#mygedview_message\"><b>Nachrichten</b></a></li><li><a href=\"#mygedview_events\"><b>Bevorstehende Ereignisse</b></a></li><li><a href=\"#mygedview_onthisday\"><b>An diesem Tag</b></li><li><a href=\"#mygedview_charts\"><b>Diagramme</b></li><li><a href=\"#mygedview_favorites\"><b>Meine Lesezeichen</b></li><li><a href=\"#mygedview_stats\"><b>GEDCOM Statistiken</b></a></li><li><a href=\"#mygedview_myjournal\"><b>Mein Journal</b></a></li><li><a href=\"#mygedview_media\"><b>Zufällig gewähltes Bild</b></a></li><li><a href=\"#mygedview_loggedin\"><b>Angemeldete Benutzer</b></a></li><li><a href=\"#mygedview_recent_changes\"><b>Aktuelle Änderungen</b></a></li></ul><br />";
$pgv_lang["mygedview_customize_help"]	= "~Mein GedView-PORTAL ANPASSEN~<br />Wenn Sie das erste Mal zur #pgv_lang[mygedview]# Seite kommen, sind schon einige Blöcke vorhanden.<br /><br />Wenn Sie möchten, können Sie diese Seite Ihren Wünschen anpassen. Klicken Sie dieses Link und Sie gelangen zu einem Formular in einem Fenster, in dem Sie Blöcke hinzufügen, löschen oder verlegen können.<br /><br />Weitere Hilfe finden Sie in diesem Formular.<br /><br />";
$pgv_lang["mygedview_message_help"]		= "~NACHRICHTEN~<br />In diesem Block finden Sie die Nachrichten, die Ihnen von anderen Benutzern oder vom Verwalter zugesandt wurden.<br /><br />Natürlich können Sie auch selbst Nachrichten an andere Benutzer schicken. Dieses Mail-System unterstützt den Schutz Ihrer persönlichen Daten. Da Sie Ihre Mail-Adresse nicht angeben müssen, können andere sie auch nicht sehen.<br /><br />Um eine Nachricht zu zeigen, klicken Sie die Betreffzeile oder das «+» Zeichen neben der Nachricht. Sie können mehrere Nachrichten auf einmal löschen, indem Sie die Kästchen neben den Nachrichten ankreuzen und auf «Gewählte Nachrichten löschen» klicken.<br /><br />";
$pgv_lang["mygedview_favorites_help"]	= "~MEINE LESEZEICHEN~<br />Meine Lesezeichen arbeitet genauso wie gewöhnliche Lesezeichen.<br /><br />Angenommen Sie haben jemanden in Ihrem Stammbaum, dessen Eintrag Sie regelmäßig überprüfen möchten. Gehen Sie einfach zur Seite mit den persönlichen Informationen dieser Person und wählen Sie «Lesezeichen hinzufügen» aus dem Menü «Meine Lesezeichen». Auf diese Person haben Sie nun ein Lesezeichen gesetzt, das in der Liste Ihrer Lesezeichen erscheint. Gleich auf welcher Seite in PhpGedView Sie sich befinden, können Sie immer einen Namen der Liste «Meine Lesezeichen» klicken. Dann gelangen Sie zur Seite mit persönlichen Informationen zu dieser Person.<br /><br />Um Platz zu sparen, werden die Boxen mit eingeschränkten Informationen dargestellt. An der rechten Seite der Namens-Box sehen Sie ein Lupen-Symbol, mit dem Sie weitere Informationen einblenden können. Wenn Sie den Namen klicken, gelangen Sie zur Seite mit den persönlichen Informationen dieser Person. Auf der rechten Seite befindet sich außerdem ein Menü, das Sie zu Seiten mit weiteren Informationen oder Diagrammen führt.<br /><br />";
$pgv_lang["mygedview_myjournal_help"]	= "~MEIN JOURNAL~<br />Sie können dieses Portal benutzen, um Notizen (oder Erinnerungen) für Ihren eigenen Gebrauch aufzuschreiben. Diese Notizen stehen Ihnen natürlich auch noch zur Verfügung, wenn Sie die Seite das nächste Mal besuchen. Diese Notizen sind für andere nicht sichtbar.<br /><br />";
$pgv_lang["mygedview_welcome_help"]		= "~WILLKOMMEN~<br />Der Willkommen-Block zeigt Ihnen:<ul><li>Die aktuelle GEDCOM-Datei</li><li>Das Datum und die Uhrzeit</li><li>Links zu:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]# (siehe Anmerkung)</li><li>#pgv_lang[my_indi]# (siehe Anmerkung)</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Anmerkung</b><br />Sie sehen die Links zu «Mein Datenblatt» und «Mein Stammbaum» nur, wenn Sie selbst als Person in der GEDCOM-Datei eingetragen sind. Daher kann es je nach gewählter GEDCOM-Datei vorkommen, dass diese Links vorhanden sind oder fehlen.<br /><br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~DIE STAMMBAUM SEITE~<br />Die meisten Besucher wissen was ein Stammbaum ist, aber dennoch gibt es wichtige Zusatzinformationen zu diesem Stammbaum:<br />Dieser Stammbaum ist im wesentlichen eine Aufzählung aller Vorfahren der Ausgangsperson. Wenn Sie diese Seite aus dem Hauptmenü aufrufen, sehen Sie die Startperson in der Box ganz links.  Wenn Sie angemeldet sind, können Sie diese Startperson auch ändern.<br /><br />«Alle Vorfahren» bedeutet also Vater und Mutter, deren Eltern usw. Auf dieser Seite sehen Sie den Stammbaum als graphische Darstellung. Sie müssen nicht durch Seiten voller Text blättern, um Ihre Vorfahren zu finden. Jede Person wird in einer Namens-Box dargestellt.<br /><ul><li>DIE PERSONEN BOXEN DES STAMMBAUMES<br />Wenn Sie «Details zeigen» gewählt haben, werden einige Grundinformationen, sofern bekannt, (z.B. Geburtsdatum) über jede Person in ihrer Box dargestellt. Sie können den Namen einer Person klicken, um zur Seite mit den persönlichen Details dieser Person zu gelangen. Wenn Sie «Details zeigen» gewählt haben, erscheinen zwei Symbole in der Namens-Box.<br /><br /></li><li>STAMMBAUM SYMBOL IN DER NAMENS-BOX<br />Wenn Sie «Details zeigen» gewählt haben, sehen Sie ein Stammbaum-Symbol in der Namens-Box. Je nach Einstellung müssen Sie mit der Maus darüberfahren oder darauf klicken, um ein Menü zu erhalten. Der «Stammbaum» und der «Nachfahren-Baum» entsprechen denen im Hauptmenü, wobei die Start-Person dann diejenige ist, in deren Box Sie das Symbol geklickt haben. Außerdem sehen Sie das Link «Familie mit Ehepartner». Sie sehen den Namen des Ehepartners gefolgt von den Namen der Kinder. Alle Namen können geklickt werden.<br /><br /></li><li>LUPEN-SYMBOL IN DEN BOXEN<br />Je nach Einstellung müssen Sie mit der Maus darüberfahren oder darauf klicken. Die gewählte Box wird dann vergrößert und es werden zusätzliche Informationen über die Person eingeblendet.<br /><br /></li><li> DIE PFEILE<br />Auf der linken bzw. rechten Seite der äußersten Boxen werden eventuell Pfeile gezeigt. Klicken Sie diese Pfeile, um die Ansicht in die entsprechende Richtung zu verschieben.</li></ul><br />Weitere Hilfe erhalten Sie, wenn Sie das <b>?</b> neben Boxen oder Links klicken.<br /><br />";
$pgv_lang["show_full_help"]				= "~DETAILS ZEIGEN ODER VERBERGEN~<br />Mit dieser Option können Sie alle Details in den Namen-Boxen ein- oder ausblenden. Wenn die Details ausgeblendet sind, passen mehr Boxen auf den Bildschirm.<br /><br />Wenn Sie die Details verbergen, können Sie die Details immer noch kurzfristig sehen, indem Sie das Lupen-Symbol klicken (sofern die Lupen-Funktion generell aktiviert ist). Das hängt davon ab, wie der Verwalter das Programm eingerichtet hat. Wenn Sie in der normalen Ansicht (mit Details) die Lupe klicken müssen, dann erhalten Sie in der verkürzten Ansicht alle Details, indem Sie die Personen-Box klicken.<br />Wenn Sie normalerweise den Zoom auslösen indem Sie mit der Maus nur über die Lupe fahren, dann funktioniert das in der verkürzten Ansicht ebenso, wenn Sie über die Box fahren.<br /><br />";
$pgv_lang["talloffset_help"]			= "~SEITEN LAYOUT~<br />Mit dieser Option können Sie die Seitenausrichtung anpassen.<br /><br />Verändern Sie diese Einstellung z.B. für einen Druck oder falls Sie einen Hochformat-Bildschirm haben. Im Hochformat wird der Baum etwas schmaler, so dass ein Diagramm über 4 Generationen noch auf eine Seite passen sollte. Im Querformat sollte ein Diagramm mit 4 Generationen quergedruckt auf eine einzelne Seite passen.<br /><br />";
$pgv_lang["rootid_help"]				= "~NEUE START-PERSON~<br />Wenn Sie einen Stammbaum ausgehend von einer anderen Person sehen möchten, können Sie in dieses Feld die ID-Nummer der gewünschten Person eintragen. Wenn Sie die ID-Nummer nicht kennen, benutzen Sie einfach das <b>ID suchen</b> Link.<br /><br /><b>ID NUMMER (=Identifikationsnummer)</b><br />Die ID-Nummern, die in PhpGedView benutzt werden, haben nichts zu tun mit z.B. der Personalausweisnummer oder der Führerscheinnummer! Die ID-Nummer ist nur eine Nummer, die in der GEDCOM-Datei benutzt wird und von der Genealogie-Software vergeben wird, um die GEDCOM-Datei zu erstellen.<br /><br />";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~ANZAHL DER GENERATIONEN~<br />Hier können Sie einstellen, wie viele Generationen auf dieser Seite dargestellt werden. Welche Einstellung für Sie optimal ist hängt auch von der Größe oder Auflösung Ihres Bildschirmes ab und ob z.B. die Details ein- oder ausgeblendet sind.<br /><br />";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~DIE LOGIN SEITE~<br />Auf dieser Seite können Sie sich anmelden, ein neues Kennwort beantragen, oder einen Benutzer-Zugang beantragen.<br /><br />Weitere Informationen bekommen Sie, wenn Sie die «?» neben den Feldern und Links klicken.<br /><br />";
$pgv_lang["username_help"]				= "~BENUTZERNAME~<br />Geben Sie in dieses Feld Ihren Benutzernamen ein.  Bitte beachten Sie die Groß- und Kleinschreibung.";
$pgv_lang["password_help"]				= "~Kennwort~<br />Tragen Sie hier Ihr Kennwort ein.  Bitte beachten Sie die Groß- und Kleinschreibung.";
$pgv_lang["login_buttons_help"]			= "~LOGIN BUTTON~<br />Es gibt hier einen Button, um sich anzumelden.<br /><br />Der<b> #pgv_lang[login]# </b> Button<br />Klicken Sie diesen Button, um zu der Seite zu gelangen, von welcher Sie die Login-Seite aufgerufen haben, allerdings nun mit den Ihnen zugewiesenen Zugriffs-Rechten. Wenn Sie also den «#pgv_lang[login]#» Button auf der Stammbaum-Seite geklickt haben, gelangen Sie zurück zur Stammbaum-Seite.<br /><br />";
$pgv_lang["login_buttons_aut_help"]		= "~AUTHENTICATION MODUS~<br />LOGIN BUTTON<br /><br />Es gibt hier einen Button, um sich anzumelden.<br /><br />Der<b> #pgv_lang[login]# </b> Button<br />Klicken Sie diesen Button, um zu der Seite zu gelangen, von welcher Sie die Login-Seite aufgerufen haben, allerdings nun mit den Ihnen zugewiesenen Zugriffs-Rechten. Wenn Sie also den «#pgv_lang[login]#» Button auf der Stammbaum-Seite angeklickt haben, gelangen Sie zurück zur Stammbaum-Seite.<br /><br />";
$pgv_lang["new_password_help"]			= "~#pgv_lang[requestpassword]#~<br />Wenn Sie Ihr Kennwort vergessen haben, klicken Sie dieses Link, um ein neues anzufordern. Sie werden zur Seite «#pgv_lang[requestpassword]#» weitergeleitet.<br /><br />";
$pgv_lang["new_user_help"]				= "~#pgv_lang[requestaccount]#~<br />Wenn Sie als Besucher dieser Site einen Benutzer-Zugang beantragen möchten, klicken Sie dieses Link. Sie werden zu der Seite «#pgv_lang[requestaccount]#» weitergeleitet.<br /><br />";
$pgv_lang["mygedview_login_help"]		= "Um das «#pgv_lang[mygedview]#» zu sehen, müssen Sie als Benutzer eingetragen sein.<br /><br />Mit dem «#pgv_lang[mygedview]#» können Sie Lesezeichen auf Personen setzen, die Ihnen wichtig sind, ein Journal führen, Nachrichten verwalten, andere angemeldete Benutzer sehen und PhpGedView an Ihre Bedürfnisse anpassen.<br /><br />Geben Sie Ihren Benutzernamen und Ihr Kennwort in die jeweiligen Felder ein, um sich beim «#pgv_lang[mygedview]#» anzumelden.<br /><br />";
$pgv_lang["new_user_firstname_help"]	= "~#pgv_lang[firstname]#~<br />Bitte geben Sie Ihren Vornamen.<br /><br />Ihre Vor- und Nachnamen sind notwendig um zu ermitteln welche Zugangs- und Zugriffsrechte Ihnen gestattet werden können.  Bitte beachten Sie, dass Ihr Name nachdem Sie sich angemeldet haben, auch anderen angemeldeten Benutzern gezeigt werden kann.<br /><br />";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br />Bitte geben Sie Ihren Nachnamen.<br /><br />Ihre Vor- und Nachnamen sind notwendig um zu ermitteln welche Zugangs- und Zugriffsrechte Ihnen gestattet werden können.  Bitte beachten Sie, dass Ihr Name nachdem Sie sich angemeldet haben, auch anderen angemeldeten Benutzern gezeigt werden kann.<br /><br />";
$pgv_lang["register_info_01"]			= "~#pgv_lang[requestaccount]#~<br />Die Daten, die hier öffentlich sichtbar sind, können aus gesetzlichen oder Datenschutzgründen beschränkt sein.  Viele möchten nicht, dass ihre persönliche Informationen dem Publikum gezeigt werden.  Solche Daten könnten für kriminelle Zwecke abgewendet werden.<br /><br />Zugriff zu persönlichen Daten dieser Seiten ist allen angemeldeten Benutzern gestattet.  Nachdem der Verwalter Ihren Zugangsantrag genehmigt hat, können Sie sich hier mit Ihrem Benutzer-ID und Kennwort anmelden.<br /><br />Falls vom Verwalter eingeschaltet, können Sie nachdem Sie sich angemeldet haben, nur die Persönlichen Daten Ihrer nahen Verwandten sehen.  Der Verwalter kann auch bestimmten Benutzern gestatten, Daten der Datenbank zu ändern oder neue Daten hinzuzufügen.<br /><br />Falls Sie mehr Hilfe brauchen, sollten Sie sich durch das Link am unteren Rand der Seite an den Verwalter wenden.<br /><br />";
$pgv_lang["register_info_02"]			= "~#pgv_lang[requestaccount]#~<br />Die Daten, die hier öffentlich sichtbar sind, können aus gesetzlichen oder Datenschutzgründen beschränkt sein.  Viele möchten nicht, dass ihre persönliche Informationen dem Publikum gezeigt werden.  Solche Daten könnten für kriminelle Zwecke abgewendet werden.<br /><br />Zugriff zu diesen Seiten ist nur <u>angemeldeten</u> Benutzern gestattet.  Nachdem der Verwalter Ihren Zugangsantrag genehmigt hat, können Sie sich hier mit Ihrem Benutzer-ID und Kennwort anmelden.<br /><br />Falls vom Verwalter eingeschaltet, können Sie nachdem Sie sich angemeldet haben, nur die Persönlichen Daten Ihrer nahen Verwandten sehen.  Der Verwalter kann auch bestimmten Benutzern gestatten, Daten der Datenbank zu ändern oder neue Daten hinzuzufügen.<br /><br />Falls Sie mehr Hilfe brauchen, sollten Sie sich durch das Link am unteren Rand der Seite an den Verwalter wenden.<br /><br />";
$pgv_lang["register_info_03"]			= "~#pgv_lang[requestaccount]#~<br />Die Daten, die hier öffentlich sichtbar sind, können aus gesetzlichen oder Datenschutzgründen beschränkt sein.  Viele möchten nicht, dass ihre persönliche Informationen dem Publikum gezeigt werden.  Solche Daten könnten für kriminelle Zwecke abgewendet werden.<br /><br />Zugriff zu diesen Seiten ist nur <u>Familienmitgliedern</u> gestattet.  Nachdem der Verwalter Ihren Zugangsantrag genehmigt hat, können Sie sich hier mit Ihrem Benutzer-ID und Kennwort anmelden.<br /><br />Falls vom Verwalter eingeschaltet, können Sie nachdem Sie sich angemeldet haben, nur die Persönlichen Daten Ihrer nahen Verwandten sehen.  Der Verwalter kann auch bestimmten Benutzern gestatten, Daten der Datenbank zu ändern oder neue Daten hinzuzufügen.<br /><br />Falls Sie mehr Hilfe brauchen, sollten Sie sich durch das Link am unteren Rand der Seite an den Verwalter wenden.<br /><br />";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~DER NACHFAHREN-BAUM~<br />Diese Seite zeigt die Nachfahren einer Person.<br /><br />Sie können eine Start-Person für diesen Nachfahren-Baum auf dieser Seite wählen, oder Sie können auf einer anderen Seite das Link «Nachfahrenbaum» klicken, um zu dieser Seite zu gelangen. Klicken Sie den «nach-oben»-Pfeil, um im Baum nach oben zu navigieren. Klicken Sie das Diagramme-Icon in einer Personen-Box, um diese Person als Startperson für Diagramme zu wählen.<br /><br />";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]			= "~#pgv_lang[lifespan_chart]#~<br />Auf diesem Diagramm können die Lebensspannen mehrerer Personen gezeigt werden.  Anhand einer Skala können Sie leicht erkennen, wie die Geburts- und Todesjahre verschiedener Personen sich überschneiden.<br /><br />Sie können einzelne Personen oder ganze Familien dem bereits bestehendem Diagramm hinzufügen.  Das Diagramm kann jederzeit durch das Klicken des <b>#pgv_lang[clear_chart]#</b> Buttons gelöscht werden.<br /><br />Sie können auch Personen dem Diagramm hinzufügen indem Sie die Datenbank nach bestimmten Daten oder Orten durchsuchen.<br /><br />";
$pgv_lang["lifespan_add_person_help"]	= "#pgv_lang[add_person_help]#~pgv_lang[include_famly] Box~<br/><br />Standardmäßig ist diese Option angekreuzt.  Falls angekreuzt, werden Vater, Mutter, Ehepartner, Geschwister, und Kinder sowie die erwähnte Person dem Diagramm hinzugefügt. Falls nicht angekreuzt, wird nur die erwähnte Person dem Diagramm hinzugefügt.<br/><br/>";
$pgv_lang["help_timeline.php"]			= "~#pgv_lang[timeline_chart]#~<br />Auf dieser Seite können Sie eine oder mehrere Personen auf einer Zeitleiste darstellen. So können Sie zum Beispiel veranschaulichen wie alt Personen oder deren Verwandte an bestimmten Stationen ihres Lebens waren.<br /><br />Wenn Sie das <b>#pgv_lang[timeline_chart]#</b> Link auf anderen Seiten klicken, finden Sie schon eine Person in dem Diagramm.  Wenn Sie die <br /><b>#pgv_lang[timeline_chart]#</b> Option im Menü des Kopfbereiches der Seite wählen, erscheint die vom Verwalter als Startperson bestimmte Person in dem Diagramm.<br /><br />";
$pgv_lang["add_person_help"]			= "~PERSON HINZUFÜGEN~<br />Sie können mehrere Personen auf der Zeitleiste darstellen.<br /><br />Geben Sie in dieses Feld die ID einer weiteren Person ein. Wenn Sie die ID der Person nicht kennen, benutzen Sie das Link «ID suchen» hinter dem Eingabefeld.<br /><br />";
$pgv_lang["remove_person_help"]			= "~PERSON ENTFERNEN~<br />Klicken Sie dieses Link, um die Person von der Zeitleiste zu entfernen.<br /><br />";
$pgv_lang["show_age_marker_help"]		= "~ALTERSANKER ZEIGEN~<br />Wenn Sie dieses Feld aktivieren, wird ein Alters-Feld eingeblendet, das man auf der Zeitleiste verschieben kann.<br /><br />Dieser Altersanker ist nützlich, um das Alter einer Person bei einem bestimmten Ereignis zu prüfen. Für jede Person im Diagramm kann man den Altersanker ein- oder ausschalten.<br /><br />";
$pgv_lang["timeline_control_help"]		= "~#pgv_lang[timeline_controls]#~<br/>~#pgv_lang[timeline_scrollSpeed]#~<br/>Aus dem Menü können Sie eine Ihnen passende Blättergeschwindigkeit wählen.<br/><br/>~#pgv_lang[timeline_beginYear]#~<br/>Geben Sie das Anfangsjahr des Bereiches.<br/><br/>~#pgv_lang[timeline_endYear]#~<br/>Geben Sie das Endjahr des Bereiches.<br/><br/>~#pgv_lang[search]#~<br/>Wenn Sie diesen Button klicken, wird die Datenbank nach allen Ereignissen durchsucht, die in dem gegebenen Jahresbereich statt fanden.<br/><br/>";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~VERWANDTSCHAFTSBERECHNUNGS-SEITE~<br />Auf dieser Seite kann der Verwandtschafts-Grad zwischen zwei Personen dargestellt werden.<br /><br />Dies bedeutet nicht, dass die Personen direkte Blutsverwandtschaft haben müssen. Jegliche Verwandtschaft wird gefunden.<br /><br />";
$pgv_lang["relationship_id_help"]		= "~ID von PERSON 1 und PERSON 2~<br />Wenn Sie von einer anderen Seite zu dieser weitergeleitet wurden, indem Sie z.B. das «Verwandtschaft zu mir»-Link benutzt haben, werden Sie hier den Verwandtschaftsgrad zwischen diesen Personen sehen.<br /><br />Andernfalls müssen Sie die ID-Nummern von 2 Personen eingeben, deren Verwandtschafts-Grad zueinander Sie erfahren möchten. Wenn Sie die ID-Nummern nicht kennen, klicken Sie das Link «ID suchen».<br /><br />";
$pgv_lang["next_path_help"]				= "~NÄCHSTEN PFAD SUCHEN~<br />Klicken Sie diesen Button, um zu prüfen, ob es einen weiteren Verwandtschafts-Pfad gibt, der diese beiden Personen verbindet. Zuvor gefundene Pfade können wieder gezeigt werden, indem man die entsprechende Pfad-Nummer klickt.<br /><br />";
$pgv_lang["follow_spouse_help"]			= "~ÜBERPRÜFE VERWANDTSCHAFT ANHAND DER EHEN~<br />Wenn diese Option <b>nicht</b>aktiviert ist, werden nur Blutsverwandschaften überprüft. Wenn diese Option aktiviert ist, werden auch Verwandtschaften durch Eheschließungen berücksichtigt. Es ist wahrscheinlich, dass mehr Zusammenhänge gefunden werden, wenn Sie diese Box aktivieren.<br /><br />";
$pgv_lang["line_up_generations_help"]	= "~GENERATIONEN AUF GLEICHER HÖHE DARSTELLEN~<br />Wenn Sie diese Option aktivieren, werden im Diagramm alle Personen, die der gleichen Generation angehören, nebeneinander auf einer Ebene dargestellt. Wenn diese Option nicht aktiviert ist, werden die Personen in einer Linie untereinander dargestellt, ganz gleich ob das Verhältnis zur vorigen Person Eltern oder Kind ist.<br /><br />";
$pgv_lang["oldest_top_help"]				= "~ÄLTESTE ZUOBERST~<br />Wenn diese Option aktiviert ist, werden im Diagramm die ältesten Personen zuoberst gezeigt. Andernfalls stehen die jüngsten Personen oben.<br /><br />Anmerkung: Diese Option funktioniert nur, wenn das Feld <i>#pgv_lang[line_up_generations]#</i> aktiviert ist.<br /><br />";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]			= "~#pgv_lang[ancestry_chart]# page~<br /><br />Die #pgv_lang[ancestry_chart]#-Seite ist der <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#-Seite</a> sehr ähnlich, zeigt aber mehr Details und bietet mehrere <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#en</a>.<br /><br />Jeder Vorfahre wird mit einer Nummer nach dem <i>Sosa-Stradonitz</i> System gekennzeichnet:<div style=\"padding-left:30px;\"><b>Gerade</b> Zahlen für Männer (Nummer des Kindes*2)<br /><b>Ungerade</b> für Frauen (Nummer des Partners + 1) außer bei Nummer <b>1</b></div><br />Beispiel:<br /><div style=\"padding-left:30px;\">Die Anfangsperson hat Nummer <b>1</b>, ohne Rücksicht auf Geschlecht.<br />Vater von <b>1</b> hat Nummer <b>2</b> (<b>1</b> * 2), Mutter hat Nummer <b>3</b> (<b>2</b> + 1).<br /> Vater von <b>2</b> hat Nummer <b>4</b> (<b>2</b> * 2), Mutter hat Nummer <b>5</b> (<b>4</b> + 1).<br />Vater von <b>3</b> hat Nummer <b>6</b> (<b>3</b> * 2), Mutter hat Nummer <b>7</b> (<b>6</b> + 1).<br />Vater von <b>7</b> hat Nummer <b>14</b> (<b>7</b> * 2), Mutter hat Nummer <b>15</b> (<b>14</b> +1).<br />usw.</div><br /><br />";
$pgv_lang["box_width_help"]				= "~#pgv_lang[ancestry_chart]# Box Breite~</b><br /><br />Hier können Sie die Box-Breite zwischen 50% und 300% verändern.<br />Standard-Wert ist 100%: die Box-Breite beträgt dann ca. 270 Pixel.<br /><br />";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[ancestry_chart]# Diagramm Typ~<br /><dl><dt>#pgv_lang[ancestry_list]#</dt><dd>Vertikaler Baum mit ein-/ausblendbaren Familien</dd><dt>#pgv_lang[ancestry_booklet]#</dt><dd>Eine Familie pro Seite mit Eltern, Großeltern und allen erfassten Kindern. Gut zum Druck und zur Weitergabe an Verwandte geeignet.</dd></dl>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]			= "~#pgv_lang[fan_chart]#~<br />Das #pgv_lang[fan_chart]# ist dem <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> sehr ähnlich, bietet aber eine grafische Darstellung.<br /><br />Die Startperson steht in der Mitte, deren Eltern im ersten Ring, Großeltern im zweiten Ring usw.<br /><br />Geburts- und Todesdaten erscheinen unter den Namen wenn bekannt.<br /><br />Wenn Sie einen Namen im Diagramm klicken, wird diese Person als neue Startperson festgelegt, und erscheint dann in der Mitte. Bei der Person in der Mitte ist ein Pfeil zu sehen, der beim Klicken ein Menü öffnet, mit dem Sie eines der Kinder oder Geschwister der Person als neue Startperson wählen können (gleiche Arbeitsweise wie beim <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>).<br /><br />";
$pgv_lang["fan_width_help"]				= "~#pgv_lang[fan_chart]#-Breite~</b><br /><br />Hier können Sie die Breite des Kreisdiagramms zwischen 50% und 300% verändern.<br />Standard-Wert ist 100%: die Diagramm-Breite beträgt dann ca. 640 Pixel.<br /><br />";
$pgv_lang["fan_style_help"]				= "~#pgv_lang[fan_chart]# Typ~<br /><dl><dt>1/2</dt><dd>Halbkreis (180°) Kreis-Diagramm</dd><dt>3/4</dt><dd>Drei-Viertel (270°) Kreis-Diagramm oder 'Engels-Flügel'</dd><dt>4/4</dt><dd>Vollkreis (360°) Kreis-Diagramm</dd></dl>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br />Das #pgv_lang[hourglass_chart]# zeigt Vor- und Nachfahren der Startperson im selben Diagramm.  Es ist also eine Mischung zwischen dem #pgv_lang[decendancy_chart]# und dem #pgv_lang[pedigree_chart]#.<br /><br />Die Startperson wird in der Mitte der Seite dargestellt, mit dessen Nachfahren links und Vorfahren rechts.  In dieser Darstellung sind Personen der selben Generation in Spalten aufgeführt, angefangen mit der jüngsten am linken Rand der Seite.<br /><br />Wenn Sie den unter der Startperson sichtbaren Pfeil klicken, erhalten Sie eine Liste der nahen Verwandten dieser Person.  Wenn Sie danach den Namen einer dieser nahen Verwandten klicken, erhalten Sie ein #pgv_lang[hourglass_chart]# worin diese Person als neue Startperson benutzt ist.<br /><br />";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]		= "~#pgv_lang[familybook_chart]#~<br />In diesem Diagramm sind mehrere Sanduhr-Diagramme dargestellt. Das erste #pgv_lang[hourglass_chart]# benutzt als Startperson die eingegebene Person.  Weitere Sanduhr-Diagramme benutzen als Startperson alle Nachfahren der ersten Startperson, bis alle Nachfahren-Generationen gemäß der eingegebenen Anzahl dargestellt sind.<br /><br />Jedes #pgv_lang[hourglass_chart]# zeigt Vor- und Nachfahren der Startperson im selben Diagramm.  Es ist also eine Mischung zwischen dem #pgv_lang[decendancy_chart]# und dem #pgv_lang[pedigree_chart]#.<br /><br />Die Startperson wird in der Mitte der Seite dargestellt, mit dessen Nachfahren links und Vorfahren rechts.  In dieser Darstellung sind Personen der selben Generation in Spalten aufgeführt, angefangen mit der jüngsten am linken Rand der Seite.<br /><br />Wenn Sie den unter der Startperson sichtbaren Pfeil klicken, erhalten Sie eine Liste der nahen Verwandten dieser Person.  Wenn Sie danach den Namen einer dieser nahen Verwandten klicken, erhalten Sie ein #pgv_lang[familybook_chart]# worin diese Person als neue Startperson benutzt ist.<br /><br />";
$pgv_lang["fambook_descent_help"]		= "~#pgv_lang[descent_steps]#~<br />Diese Eingabe bestimmt die Anzahl der Nachfahren-Generationen der Startperson die im Sanduhr-Format dargestellt werden.<br /><br />";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~PERSONEN SEITE~<br />Auf dieser Seite wird eine Liste von Personen gezeigt. Die Namen werden mit vorn stehendem Nachnamen, alphabetisch sortiert, gezeigt.<br /><br />Die ausgegebene Liste basiert auf folgenden Kriterien:<br /><b>1.</b> Der Buchstabe, den Sie im Alphabet-Index angeklickt haben.<br /><b>2.</b> Sie können am unteren Ende der Liste die «Nachnamen-Sprungliste» oder «Nachnamen zeigen» wählen.<br /><br />Wenn Sie weitere Hilfe benötigen, klicken Sie das «?» neben den Symbolen.<br /><br />";
$pgv_lang["alpha_help"]					= "~ALPHABET-INDEX~<br />Klicken Sie einen Buchstaben des Alphabetes und Sie erhalten eine neue Liste mit den Nachnamen des von Ihnen gewählten Buchstabens. An vorletzter Stelle sehen Sie eventuell <b>#pgv_lang[NN]#</b>.  Dies steht für Personen, deren Nachnamen nicht angegeben wurden, oder deren Nachnamen keine Buchstaben enthält. Unbekannte Namen sind oft als <b>?</b> eingetragen; solche Namen werden als #pgv_lang[NN]# erkannt, genau wie leere Namen.<br /><br /><b>Achtung</b><br />Wenn im Datensatz einer Person der Nachname z.B. mit Nn, NN, Unbekannt oder auch N.N. eingetragen ist, erscheint diese Person <b>nicht</b> in der Rubrik <b>#pgv_lang[NN]#</b>. Solche Personen finden Sie unter <b>N</b> oder <b>U</b>. Dies liegt daran, dass das Programm nur prüft, ob ein Name vorhanden ist.<br /><br />Am Ende des Alphabetes sehen Sie <b>ALLE</b>. Klicken Sie hier, um eine Liste mit allen Nachnamen zeigen zu lassen.<br /><br /><b>Fehlende Buchstaben?</b><br />Es kann sein, dass in der Alphabet-Liste einige Buchstaben fehlen. Das bedeutet, dass es keine Nachnamen mit diesen Anfangsbuchstaben gibt.<br /><br />";
$pgv_lang["name_list_help"]				= "~NAMENS LISTE~<br />In dieser Box erscheint entweder eine Liste von Nachnamen oder von einzelnen Personen. In beiden Fällen beginnen die Nachnamen mit dem Buchstaben, den Sie im Alphabet-Index geklickt haben, es sei denn, Sie haben auf «ALLE» geklickt.<br /><br />Ob Sie die Nachnamensliste oder die Liste einzelner Personen gezeigt bekommen, kommt auf den aktuellen Status des <b>Liste zeigen/überspringen</b> Links an.<br /><br />";
$pgv_lang["skip_sublist_help"]			= "~NACHNAMEN ZEIGEN~<br />Normalerweise wird eine Unterliste gruppiert nach Nachnamen gezeigt, wenn Sie einen Buchstaben des Alphabetes gewählt haben. Wenn Sie dieses Link klicken, werden die Nachnamen nicht gruppiert, sondern jede einzelne Person, deren Nachname mit diesem Buchstaben beginnt, wird gezeigt.<br /><br />";
$pgv_lang["show_marnms_help"]			= "~Ehenamen ein- oder ausschließen~<br /><br />Die Personen- und Familien-Listen können Ehenamen ein- oder ausschließen.  Diese Option kann nützlich sein, wenn Sie Personen oder Familien suchen von denen Ihnen nur der Ehename bekannt ist.  Ehenamen können nur eigeschlossen werden wenn sie schon in der Datenbank vorhanden sind.<br /><br />Diese Option ist auf der Familien-Seite normalerweise auf «ausschließen» gestellt.  Auf der Personen-Seite bestimmt die GEDCOM-Konfiguration die Standard-Einstellung.<br /><br />Ihre Wahl wird bis zum Ende der Sitzung behalten.<br /><br />";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~FAMILIEN SEITE~<br />Auf dieser Seite wird eine Liste der Familien gezeigt. Die Namen werden mit vorn stehendem Nachnamen, alphabetisch sortiert, gezeigt.<br /><br />Die ausgegebene Liste basiert auf folgenden Kriterien:<br /><b>1.</b> Der Buchstabe, den Sie im Alphabet-Index angeklickt haben.<br /><b>2.</b> Wahl der «Nachnamen-Sprungliste» oder «Nachnamen zeigen».<br /><br />Sie können sowohl nach dem Nachnamen des Ehemannes als auch nach dem der Ehefrau suchen. Beide sind in der Liste enthalten.<br /><br />Wenn Sie weitere Hilfe benötigen, klicken Sie das «?» neben den Symbolen.<br /><br />";
$pgv_lang["help_family.php"]			= "~FAMILIEN DETAIL SEITE~<br />Diese Seite zeigt Ihnen eine Übersicht der Familie, die Sie auf der vorigen Seite gewählt haben.<br /><br />Von oben nach unten sehen Sie die Detailinfo-Boxen von:<br />Der Gatte und seine Eltern, die Gattin und ihre Eltern, und die Kinder.<br /><br />Das Layout und der Inhalt der Personen-Boxen entspricht dem der Boxen, die Sie von der Stammbaum-Seite oder Nachfahren-Baum-Seite kennen. Rechts von den Namens-Boxen der Eltern sehen Sie einen Pfeil (wenn weitere Vorfahren eingetragen sind). Wenn Sie diesen Pfeil klicken, gelangen Sie eine Generation höher und Sie sehen eine neue Familien-Seite in der die Eltern der vorigen Seite nun als Gatte und Gattin gezeigt sind.<br /><br />Auf der rechten Seite <i>in</i> der Namens-Box, sehen Sie eventuell ein Lupen-Symbol, das zu weiteren Detail-Information einer Person führt. Wenn Sie den Namen klicken, gelangen Sie zur Seite mit persönlichen Informationen zur Person. Außerdem ist am rechten Rand ein kleines Menü vorhanden, das Sie zu anderen Seiten mir mehr Informationen oder zu anderen Diagrammen führt.<br /><br />Die Familiengruppen-Information zeigt alle Fakten und Daten dieser Familie, wie Ehe, Multimedia-Objekte und Bemerkungen. Wenn Sie innerhalb der Informationen einen Ort klicken, gelangen Sie zur Ortsliste, in der alle anderen Familien und Personen aufgezählt sind, die zu diesem Ort ebenfalls einen Bezug haben. Wenn Sie ein Datum klicken, gelangen Sie zum Tages-Kalender, der alle Ereignisse zeigt, die an diesem Datum in der Vergangenheit stattfanden. Multimedia-Objekte können auch geklickt werden, dann öffnet sich ein größeres Bildfenster. Wenn Sie eine Quelle klicken, erscheinen die Detailinformationen zu dieser Quelle.<br /><br />Unter den Namens-Boxen der Kinder sehen Sie eventuell das Link «Kind zu dieser Familie hinzufügen». Neben den Namens-Boxen der Kinder sehen Sie «Informationen zur Familiengruppe». Wenn Sie die nötigen Rechte haben, können Sie Ereignisse und Daten verändern, löschen oder hinzufügen.<br /><br />Am rechten Bildschirmrand sehen Sie (wenn aktiviert) Symbole und Links für:<ul><li><b>GEDCOM Daten zeigen</b>, dadurch werden die Daten im GEDCOM Rohformat dargestellt.</li><li><b>Datensatz dem Sammelbehälter hinzufügen</b>, dadurch speichern Sie die Daten in Ihrem Ausschnittsammelbehälter. Die Daten in diesem Behälter können Sie später herunterladen und in Ihre eigenes Programm importieren.</li><li><b>Ehepaar in Lebensspannen-Ansicht zeigen</b>, hiermit gelangen Sie zur Lebensspannendarstellung und die Daten des Ehepaares werden in der Zeitleiste angezeigt.</li></ul><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]				= "~EIN KIND ZU DIESER FAMILIE HINZUFÜGEN~<br />Wenn Sie dieses Link klicken, können Sie ein Kind zur Familie hinzufügen.<br /><br />Ein Kind hinzuzufügen funktioniert einfach: Klicken Sie dieses Link und füllen Sie die Felder im Formular aus.<br /><br />";
$pgv_lang["show_fam_gedcom_help"]		= "~GEDCOM DATENSATZ ZEIGEN~<br />Wenn Sie dieses Link klicken, wird die Information über diese Familie so gezeigt, wie Sie im Datensatz gespeichert ist.<br /><br />";
$pgv_lang["add_fam_clip_help"]			= "~FAMILIE DEM AUSSCHNITTSAMMELBEHÄLTER HINZUFÜGEN~<br />Klicken Sie dieses Link, um die Daten der Familie aus der GEDCOM-Datei zum Ausschnittsammelbehälter hinzuzufügen. Auf der nächsten Seite können Sie dann im Detail wählen, welche Informationen Sie hinzufügen möchten: nur die Eltern oder auch deren Eltern und/oder deren Kinder und/oder alle Nachfahren.<br /><br />";
$pgv_lang["show_fam_timeline_help"]		= "~PAAR IN DER LEBENSSPANNENANZEIGE ZEIGEN~<br />Wenn Sie dieses Link klicken, gelangen Sie zur Lebensspannendarstellung-Seite, wobei die Daten des Paares direkt in der Zeitleiste gezeigt werden.<br /><br />";

//-- Sourcelist-page
$pgv_lang["help_sourcelist.php"]		= "~QUELLEN SEITE~<br />Auf dieser Seite wird eine Liste aller Quellen gezeigt.<br /><br />Im Gegenteil zu den Personen- und Familien-Seiten gibt es keinen Alphabet-Index auf dieser Seite. Da die Quellen sowohl Personen mit unterschiedlichen Namen als auch öffentliche Datenbanken oder Institute sein können, würde eine alphabetische Unter-Gruppierung nicht viel Sinn machen. Die Namen erscheinen in der gleichen alphabetischen Reihenfolge wie sie in der GEDCOM-Datei gespeichert sind.<br /><br /><b>QUELLEN</b><br />Ohne Quellen könnte man keine Genealogie betreiben. Für jede Information in der Datenbank gibt es eine Quelle. Dies kann eine Person, ein Amt oder z.B. eine öffentliche Datenbank sein. Eine einzige Quelle kann mit vielen Personen verknüpft sein. Andererseits kann eine Person auch mit mehreren Quellen verknüpft sein. Sie können mehrere Quellen für ein Ereignis haben, gleich ob es ein Geburtstag, ein Beruf, eine Ehe usw. ist.<br /><br />";
$pgv_lang["sourcelist_listbox_help"]	= "~QUELLEN LISTE~<br />In dieser Box erscheinen die Namen der Quellen, so wie sie gespeichert sind. Die Namen erscheinen alphabetisch sortiert.<br /><br />Wenn Sie eine Quelle in der Liste klicken, gelangen Sie zur Seite dieser Quelle, wo eine Liste der mit dieser Quelle verknüpften Personen und Familien gezeigt wird.<br /><br />";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~QUELLEN DETAIL SEITE~<br />Auf dieser Seite werden die Details einer Quelle gezeigt. Quellenangaben sind für Genealogen sehr wichtig und helfen die Ergebnisse von anderen Forschern nachzuvollziehen.<br /><br />Auf dieser Seite finden Sie Informationen über den Namen der Quelle, deren Autor, Veröffentlichung und dem Archiv oder Lagerort, wo diese Quelle gefunden wurde. Da es sehr viele verschiedene Arten von Quellen gibt, finden Sie eventuell unterschiedliche Mengen von Angaben vor.<br /><br />Wenn zu einem Multimedia-Objekt eine Quelle angegeben ist (z.B. Scan eines Dokumentes), gelangen Sie zu einer größeren Ansicht, indem Sie das Objekt oder den Dateinamen daneben klicken.<br /><br />Im Anschluss an die Quellen-Details wird eine Liste gezeigt, die Personen und Familien enthält, die mit dieser Quelle verknüpft sind. So finden Sie alle Informationen, die dieser Quelle entnommen sind.<br /><br />Eventuell werden zusätzliche Symbole gezeigt, je nach Konfiguration durch den Verwalter:<br /><b>GEDCOM-Datensatz zeigen</b> - was die Daten im GEDCOM-Format zeigt.<br /><b>Datensatz dem Sammelbehälter hinzufügen</b> - was Ihnen erlaubt die Dateien in Ihrem Sammelbehälter zu speichern. Diesen «Behälter» können Sie später herunterladen und die Daten in Ihre eigenes Programm einfügen.<br /><br />Weitere Hilfe erhalten Sie, wenn Sie auf <b>?</b> klicken.<br /><br />";
$pgv_lang["sources_listbox_help"]		= "~MIT DIESER QUELLE VERBUNDENE EINTRÄGE~<br />In dieser Box erscheint eine Liste der Personen und Familien, die mit dieser Quelle verknüpft sind. Die Namen erscheinen in alphabetischer Reihenfolge.<br /><br />Wenn Sie auf einen Namen in der Liste klicken, gelangen Sie zur Detail-Seite der betreffenden Person oder Familie.<br /><br />";
$pgv_lang["show_source_gedcom_help"]	= "~GEDCOM-DATENSATZ ZEIGEN~<br />Wenn Sie dieses Link klicken, werden die Informationen über diese Quelle genau so gezeigt, wie sie in der Datei als Rohdaten gespeichert sind.<br /><br />";
$pgv_lang["add_source_clip_help"]		= "~DATENSATZ DEM SAMMELBEHÄLTER HINZUFÜGEN~<br />Wenn Sie dieses Link klicken, werden die Daten, so wie in der Datei enthalten, in Ihren Ausschnittsammelbehälter hinzugefügt.<br /><br />";
$pgv_lang["delete_source_help"]			= "~#pgv_lang[delete_source]#~<br />Wenn Sie dieses Link klicken, wird die Quelle zum Löschen markiert.<br /><br />Was bedeutet das?<br />Angenommen Sie möchten aus irgendeinem Grund eine Quelle löschen. Klicken Sie das Link, dann erscheint eine Sicherheitsabfrage zum Löschen oder Abbrechen.<br /><br />Wenn Sie mit dem Löschen fortfahren, kann es einige Zeit dauern, bis eine Bestätigungs-Nachricht erscheint.<br /><br />Bei näherem Betrachten werden Sie aber feststellen, dass die Quelle weiterhin sichtbar ist und wie zuvor gewählt werden kann.<br /><br />Dies ist <b>kein</b> Fehler.<br />Der Verwalter wird eine Nachricht bekommen, dass Änderungen an der Datenbank erwünscht sind, und dass Sie die Quelle gelöscht haben. Der Verwalter kann Ihre Änderung in die Datenbank übernehmen oder sie ablehnen. Erst danach ist die Quelle unwiderruflich gelöscht. Im Zweifelsfall wird der Verwalter Sie kontaktieren.<br /><br />";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~LISTE DER ORTE<br />(oder Personen je Ort)~<br />Auf dieser Seite sehen Sie hierarchisch, welche Personen oder Familien mit einem Ort verknüpft sind.<br /><br />Wenn eine Verbindung zwischen einer Person oder Familie und einem Ereignis an einem bestimmten Ort besteht, bekommen Sie es gezeigt.<br /><br />Die Ergebnisse werden in Listen gezeigt, eine für Personen und eine für Familien.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~ORDNUNGS-FORMAT FÜR ORTE<br />STANDARDEINSTELLUNG~<br />Das bedeutet, dass keine vorgegebene Anordnung in der GEDCOM-Datei gefunden wurde. In diesem Fall wird die Standard-Anordnung angenommen.<br /><br />Wenn ein anderes Ordnungs-Format in der GEDCOM-Datei gefunden wurde, würde das zwischen den (...) am Ende der Zeile gezeigt werden.<br /><br />";
$pgv_lang["ppp_match_one_help"]			= "~ORDNUNGS-FORMAT FÜR ORTE<br />GEDCOM-REIHENFOLGE~<br />Es wird angenommen, die Orte seien in der Ordnung, wie in der der GEDCOM-Datei vorgefunden, codiert. Diese Einstellung überschreibt die Standard-Anordnung, die benutzt würde, wenn die GEDCOM-Datei keine Ordnungs-Angabe enthält.<br /><br />";
$pgv_lang["ppp_numfound_help"]			= "~ORTS-VERBINDUNGEN GEFUNDEN~<br />Hier wird die Anzahl der Verbindungen gezeigt.<br /><br />Wenn Sie noch eine Liste mit Orten sehen, bedeutet das, dass Sie noch nicht die unterste Ebene erreicht haben. Sie können entweder alle Datensätze, die zu diesem Ort gefunden wurden, zeigen oder die Suchangaben präzisieren, indem Sie einen Ort klicken.<br /><br />";
$pgv_lang["ppp_levels_help"]			= "~ORTS-EBENE~<br />Hier werden die bisher gewählten Ortsangaben gezeigt. Die Liste in der Box stellt eine Unterliste der zuletzt gewählten Ebene.<br /><br />BEISPIEL:<br />Die Reihenfolge ist: #pgv_lang[default_form]#<br />Wenn die aktuelle Ebene die oberste ist, zeigt die Box alle Länder. Wenn als Ebene gezeigt wird: «Deutschland, zurück», dann werden in der Box alle Regionen innerhalb Deutschlands gezeigt, usw.<br /><br />Sie können in der Zeile jede beliebige Ebene klicken, um wieder eine oder mehrere Ebenen nach oben zu springen.<br /><br />";
$pgv_lang["ppp_placelist_help"]			= "~ORTS-HIERARCHIE~<br />In dieser Liste sehen Sie die Orte unter der angebenenen Ortswahl. Wenn Sie noch keinen Ort angegeben haben, sehen Sie eine Liste der obersten Ebene (z.B. Länder oder Staaten).<br /><br />Sie können die Namen der Ortsangaben in der Liste klicken. Dadurch wird der gewählte Ort als Filter aktiviert und Sie gelangen eine Ebene tiefer.<br /><br />";
$pgv_lang["ppp_placelist_help2"]		= "~ORTS-LISTE~<br />In dieser Liste sehen Sie die bisher gefunden Orte.<br /><br />Sie können die Namen der Ortsangaben in der Liste klicken. Dadurch wird der gewählte Ort als Filter aktiviert und Sie gelangen eine Ebene tiefer. Nur solange Sie in der obersten Ebene arbeiten, wird keine Namensliste gezeigt. In allen tiefer gelegenen Ebenen erhalten Sie eine Liste von Personen oder Familien, die mit diesem Ort verknüpft sind.<br /><br />";
$pgv_lang["ppp_view_records_help"]		= "~ALLE DATENSÄTZE ZEIGEN~<br />Wenn Sie dieses Link klicken, erhalten Sie eine Liste mit allen Personen und Familien, bei denen Ereignisse am zuvor ausgewählten Ort stattgefunden haben. Wenn Sie in der untersten Ebene der Ortsangabe angelangt sind (z.B. ein Dorf oder eine Stadt), wird diese Namensliste automatisch gezeigt.<br /><br />";
$pgv_lang["ppp_name_list_help"]			= "~NAMEN-LISTE~<br />Diese Box zeigt eine Liste aller Personen und Familien, die in irgendeiner Weise mit dem gewählten Ort verbunden sind.<br /><br />Sie können die Namen in der Liste klicken. Dadurch gelangen Sie zur Detail-Seite der Person oder Familie.<br /><br />Sie können Ihre Orts-Wahl auch abändern, indem Sie einen Ort oberhalb der Liste klicken.<br /><br />";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~MULTI MEDIA LISTE~<br />Die Multi Media Seite listet alle Multi Media Objekte, die in der GEDCOM-Datei vorkommen.<br /><br />Zu jedem Objekt finden Sie den Titel oder Dateinamen des Objekts sowie die Namen der Personen oder Familien, die mit dem Objekt verbunden sind, sowie Bemerkungen zum Objekt.<br /><br />Den Titel oder Dateinamen des Objekts klicken bewirkt das gleiche wie ein Klick auf sein Miniaturbild.<br />Abhängig vom Dateiformat (*.gif, *.jpg, *.png), wird das Objekt mit dem PGV-internen Betrachter geöffnet oder in einem Plugin Ihres Browsers.<br /><br />Wenn Sie das «Zeige» Link einer Person oder Familie klicken, gelangen Sie zur Seite der jeweiligen Familie oder Person.<br /><br />";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~MULTIMEDIA-DATEIEN HOCHLADEN~<br />Das Hochladen der Dateien ist einfach, hier aber ein paar Zusatzinformationen.<br /><br /><b>Miniaturbilder</b><br />Miniaturbilder sollten ungefähr 100 Pixel breit sein. Der Dateiname muss der gleiche sein, wie der des Original-Bildes.<br /><br /><b>Hochladen</b><br />Die Dateien werden automatisch in das Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#</b> übertragen, wenn es sich um Originale handelt und in das Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#/thumbs</b> bei Miniaturbildern.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~JAHRESTAG KALENDER~<br /><ul><li><a href=\"#calendar_general\">Allgemeine Informationen</a></li><li><a href=\"#calendar_day\">#pgv_lang[day]#</a></li><li><a href=\"#calendar_month\">#pgv_lang[month]#</a></li><li><a href=\"#calendar_year\">#pgv_lang[year]#</a></li><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a></li><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a></li><li><a href=\"#calendar_event\">Ereignis</a></li><li><a href=\"#calendar_button\">Vorauswahl (Buttons)</a></li><li><a href=\"#calendar_tip\">Tipp</a></li></ul><br /><a name=\"calendar_general\"></a>Der Jahrestag-Kalender stellt Personen und Familien dar, die mit einem Ereignis verbunden sind, das sich an einem bestimmten Tag oder Monat oder in einem bestimmten Zeitraum ereignet hat. Er besitzt ein mehrstufiges Filtersystem, um das gewünschte Datum oder den gewünschten Zeitraum und die Art der Ereignisse zu wählen.<br /><br /><dl><dt><b><a href=\"#calendar_day\">Tag zeigen</b></dt><dd>Dies zeigt die Ereignisse eines bestimmten Tages an (unabhängig vom gewählten Jahr). Eine Liste enthält Personen und eine andere Familien.</dd><dt><b><a href=\"#calendar_month\">Monat zeigen</a></b></dt><dd>Dies zeigt einen <b>Kalender</b>, wobei die Namen von Personen und Familien jeweils in den Tages-Kästchen erscheinen. Der Kalender erscheint wie in dem Jahr, das Sie im Jahres-Feld eingegeben haben. Alle Ereignisse, die sich in der Vergangenheit bis zu diesem Jahr ereignet haben, werden gezeigt. In Kombination mit der Option <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a> ergibt sich eine realistische Ansicht, wie sich die Ereignisse für die Vorfahren dargestellt haben.</dd><dt><b><a href=\"#calendar_year\">Jahr zeigen</a></b></dt><dd>Dies zeigt die Ereignisse eines oder mehrerer Jahre. Eine Liste enthält Personen und eine andere Familien.</dd></dl><br />Die aktuell eingestellten Datums-Werte sind im Kalender-Menü farblich hervorgehoben dargestellt.<br /><br />Die Namen und Daten, die in der Liste oder im Kalender erscheinen, können Sie klicken.<br />Wenn Sie einen Namen klicken, gelangen Sie zur Detail-Seite der betreffenden Person oder Familie; wenn Sie ein Datum klicken, gelangen Sie in die «Heute»-Ansicht (oder das Jahr) für das geklickte Datum.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~DATUMS WAHL~<br />Die obere Zeile der Wahl-Tabelle ist die <b>Tageswahl</b>. Hier wählen Sie den Tag. Das Ergebnis hängt davon ab, ob Sie sich im «Tages Modus» oder im «Monats Modus» befinden.<br /><br />Der <b>Tages Modus</b>:<br />Wenn Sie in diesem Modus einen Tag klicken, wird der Bildschirm aktualisiert und die Liste des geklickten Tages wird gezeigt.<br /><br />Der <b>Monats Modus</b>:<br />Wenn Sie im Monatsmodus einen Tag klicken, wird der Bildschirm zwar aktualisiert, aber Sie sehen immer noch den Kalender des gleichen Monats wie zuvor.<br /><br />Um den Modus zu wechseln klicken Sie einfach den <b>#pgv_lang[viewday]#</b> oder <b>#pgv_lang[viewmonth]# Button</b>.<br /><br />Am Ende der Tages-Reihe finden Sie das «Direkt-Link» mit dem heutigen Datum. Wenn Sie dieses «Direkt-Link» klicken, sehen Sie die Liste für den heutigen Tag im «Tages-Modus», gleich in welchem Modus Sie zuvor waren.<br /><br />";
$pgv_lang["annivers_month_select_help"]	= "~MONATS AUSWAHL~<br />Die mittlere Zeile der Auswahl-Tabelle ist die <b>Monatsauswahl</b>. Hier wählen Sie den Monat. Das Ergebnis hängt davon ab, ob Sie sich im «Tages Modus» oder im «Monats Modus» befinden.<br /><br />Der <b>Tages Modus</b>:<br />Wenn Sie in diesem Modus einen Monat klicken, wird der Bildschirm aktualisiert und die Liste des geklickten Datums mit dem neu gewählten Monat wird gezeigt.<br /><br />Der <b>Monats Modus</b>:<br />Wenn Sie im Monatsmodus einen Monat klicken, wird der Kalender des neuen Monats gezeigt.<br /><br />Am Ende der Monats-Reihe finden Sie das «Direkt-Link» mit dem aktuellen Monat. Wenn Sie dieses «Direkt-Link» klicken, sehen Sie den Kalender des aktuellen Monats, gleich in welchem Modus Sie zuvor waren.<br /><br />";
$pgv_lang["annivers_year_select_help"]	= "~JAHRES EINGABEFELD~<br />In diesem Feld können Sie das Jahr eingeben für die Ausgabe der Liste im «Jahres Modus» bzw. für den Kalender im «Monats Modus».<br /><br />Im «Tages-Modus» ändert die Jahreszahl nichts, da die Ereignisse aller Jahre gezeigt werden.<dl><dt><b>Tipps für Fortgeschrittene</b> bei <b>#pgv_lang[viewyear]#:<br />Mehrere Jahre</b></dt><dd>Sie können über mehrere Jahre suchen, indem Sie im Jahresfeld folgende Eingabe machen:<br />- Beisp. 1: <b>1992-5</b> für alle Ereignisse von 1992 bis 1995.<br />- Beisp. 2: <b>1972-89</b> für alle Ereignisse von 1972 bis 1989.<br />- Beisp. 3: <b>1610-759</b> für alle Ereignisse von 1610 bis 1759.<br />- Beisp. 4: <b>1880-1905</b> für alle Ereignisse von 1880 bis 1905.<br />- Beisp. 5: <b>880-1105</b> für alle Ereignisse von 880 bis 1105.<br /><br />Sie können auch die letzten Ziffern der Jahreszahl durch Fragezeichen <b>?</b> erzetzen, um alle Ereignisse eines Jahrzehntes oder Jahrhundertes zu erhalten.<br />- Beisp.: <b>197?</b> für alle Ereignisse von 1970 bis 1979 oder <b>16??</b> für alle Ereignisse von 1600 bis 1699.</dd><dt><b>Abkürzungen</b></dt><dd>Manchmal ist das genaue Datum eines Ereignisses nicht bekannt. In diesem Fall können Begriffe wie «nach», «vor» und «um» in Verbindung mit einem Datum verwendet werden. Die Daten werden zusammen mit einer englischen Abkürzung dieser Begriffe in der GEDCOM-Datei gespeichert. Im Jahres-Modus können Sie auch nach diesen Begriffen (mit oder ohne Datumsangabe) suchen. Hier einige Beispiele:<br /><b>abt</b> 1800 (abt = about, d.h. um)<br /><b>bet</b> 1950-1959 (bet = between, d.h. zwischen) Eingabe: bet 1950-59<br /><b>bef</b> 1950 (bef = before, d.h. vor)<br /><b>aft</b> 1900 (aft = after, d.h. nach)<br /><br />PS: <i><b>Diese Abkürzungen müssen in Englisch eingegeben werden, da der GEDCOM-Standard die englischen Kürzel beinhaltet!</b> Das Programm sucht nach der genauen Zeichenfolge, die Sie eingeben. Wenn Sie also nach «abt 1850» suchen, wird ein Datum wie «abt oct 1850» <b>nicht</b> unter den Suchergebnissen erscheinen.</i></dd></dl>Wenn Sie eine neue Jahreszahl eingeben, wird der Bildschirm nicht sofort aktualisiert. Sie müssen den Button <b>#pgv_lang[viewmonth]#</b> oder <b>#pgv_lang[viewyear]# </b> klicken, um die Anzeige zu aktualisieren.<br /><br />";
$pgv_lang["annivers_show_help"]			= "~EREIGNISWAHL~<br />Wenn Sie nicht angemeldeter Benutzer sind, haben Sie diese Wahlmöglichkeiten:<br /><br /><b>1. Alle Personen</b><br />Mit dieser Option werden alle Personen und Familien gezeigt.<br /><br /><b>2. Jüngere Ereignisse (<100 Jahre)</b><br />Mit dieser Option sehen Sie alle Ereignisse des gewählten Datums oder Monates, die maximal 100 Jahre zurück liegen.<br /><br />Es gibt eine dritte Option. Hierfür müssen Sie entweder angemeldet sein, oder der Verwalter muss auch die Daten von lebenden Personen für alle sichtbar gemacht haben.<br /><br /><b>3. Lebende Personen</b><br />Mit dieser Option sehen Sie nur Ereignisse noch lebender Personen.<br /><br />Wenn Sie eine Option wählen, wird die Bildschirm aktualisiert und die Ereignisse Ihrer Wahl werden aufgezählt. Die Einstellungen von Tag, Monat, Jahr und Tag-Modus oder Monats-Modus bleiben unverändert.<br /><br />";
$pgv_lang["annivers_sex_help"]			= "~GESCHLECHT-FILTER~<br />Wenn Sie angemeldet sind oder wenn der Verwalter die Datenschutzoptionen deaktiviert hat, können Sie zwischen diesen Optionen wählen:<dl><dt><b>1. Symbol «beide»</b></dt><dd>Mit dieser voreingestellten Option werden alle Ereignisse von Personen und Familien gezeigt.</dd><dt><b>2. Symbol «männlich»</b></dt><dd>Hier werden nur Ereignisse von männlichen Personen gezeigt. Außerdem werden männliche Familienmitglieder bei Familien-Ereignissen gezeigt.</dd><dt><b>3. Symbol «weiblich»</b></dt><dd>Hier werden nur Ereignisse von weiblichen Personen gezeigt. Außerdem werden weibliche Familienmitglieder bei Familien-Ereignissen gezeigt.</dd></dl>Wenn Sie ein Symbol klicken, wird die Bildschirm aktualisiert und die von Ihnen ausgewählten Ereignisse werden gezeigt. Die übrigen Einstellungen von Tag, Monat, Jahr, Ereignis-Filter und Anzeige-Modus bleiben unverändert.<br /><br />";
$pgv_lang["annivers_event_help"]		= "~EREIGNISWAHL~<br />Hier können Sie wählen, ob Sie <b>alle</b> Ereignisse für Personen und Familien zeigen möchten, oder nur ein bestimmtes Ereignis.<br /><br />Wenn Sie eine Option wählen, wird der Bildschirm aktualisiert und die Ereignisse Ihrer Wahl werden gezeigt. Die übrigen Einstellungen von Tag, Monat, Jahr, Ereignis-Filter und Anzeige-Modus bleiben unverändert.<br /><br />";
$pgv_lang["annivers_tip_help"]			= "~TIPP~<br />Angenommen Sie hätten einen Verwandten, der am am 25. Januar 1875 geboren wurde.<br /><br />Stellen Sie die Datumsangabe auf dieses Datum ein. So können Sie sich eine Liste oder einen Kalender zeigen lassen, für genau diesen Tag. Alle Altersangaben, Jahrestage usw. werden neu auf den Tag berechnet, den Sie eingegeben haben. So sehen Sie die Angaben genau so, wie sie sich für Ihren Verwandten vor langer Zeit dargestellt haben.<br /><br />";
$pgv_lang["day_month_help"]				= "~TAG / MONAT / JAHR ZEIGEN~<br />Wenn Sie <b>Tag zeigen</b> klicken, werden nur die Ereignisse genau dieses Datums in einer Liste gezeigt. Alle Jahre werden durchsucht, deshalb können hier auch nur Tag und Monat angegeben werden. Eine Änderung der Jahreszahl bewirkt nichts.<br /><br />Sie können die Liste einschränken, in dem Sie die Option «Jüngere Ereignisse» oder «Lebende Personen» wählen. Die Altersangaben in der Liste beziehen sich auf die angegebene Jahreszahl.<br /><br />Klicken Sie <b>Monat zeigen</b>, wird ein Kalender des gewählten Monats und Jahres dargestellt. Auch hier können Sie die Liste durch die Wahl von «Jüngere Ereignisse» oder «Lebende Personen» einschränken. Wenn Sie ein Jahr in der Vergangenheit wählen und «Jüngere Ereignisse» wählen, erhalten Sie einen realistischen Eindruck, wie sich der Kalender Ihrer Vorfahren darbot. Alle Altersangaben beziehen sich auf die angegebene Jahreszahl.<br /><br />Der Button <b>Jahr zeigen</b> zeigt eine Liste der Ereignisse des gewählten Jahres. Auch hier können Sie die Liste durch die Wahl von «Jüngere Ereignisse» oder «Lebende Personen» einschränken. Eine weitere Möglichkeit ist die Darstellung der Ereignisse aus mehreren Jahren: Geben Sie einfach die Endziffern der zweiten Jahreszahl hinter der ersten Jahreszahl ein, als Trennzeichen verwenden Sie ein «-» (z.B. <b>1992-4</b> für alle Ereignisse von 1992 bis 1994), oder <b>1976-1984</b> für alle Ereignisse von 1976 bis 1984).<br />- Sie können auch die letzten Ziffern der Jahreszahl durch Fragezeichen <b>?</b> erzetzen, um alle Ereignisse eines Jahrzehntes oder Jahrhundertes zu erhalten.<br />- Beisp.: <b>197?</b> für alle Ereignisse von 1970 bis 1979 oder <b>16??</b> für alle Ereignisse von 1600 bis 1699.<br /><br />Wenn Sie das <b>Jahr wechseln</b> möchten <b>müssen</b> Sie einen der drei Buttons benutzen.<br /><br />Alle anderen Einstellungen bleiben unverändert wenn Sie einen dieser Buttons klicken.<br /><br />";

//-- Clipping Cart-page
$pgv_lang["help_clippings.php"]			= "~AUSSCHNITTSAMMELBEHÄLTER~<br />Der Ausschnittsammelbehälter erlaubt Ausschnitte aus diesem Stammbaum zu sammeln und in eine separate GEDCOM-Datei zu speichern, die man anschließend herunterladen kann.<br /><br />Wie wählt man Abschnitte?<br />Jeder klickbare Name führt zur Detail-Seite der betreffenden Person (Familie, Quelle). Dort gibt es die Option «Zum Ausschnittsammelbehälter hinzufügen». Klicken Sie dieses Link und Sie gelangen zu einer Liste von Optionen.<br /><br />Wie herunterladen?<br />Sobald Sie Elemente in Ihrem Sammelbehälter haben, können Sie diese durch Klick auf «Jetzt herunterladen» herunterladen.<br /><br />Folgen Sie den weiteren Anweisungen.<br /><br />";
$pgv_lang["clip_download_help"]			= "~AUSSCHNITTE HERUNTERLADEN~<br />Wenn Sie dieses Link klicken, gelangen Sie auf eine andere Seite. Falls in den von Ihnen gesammelten Ausschnitten auch Multimedia-Objekte referenziert sind, werden auch diese auf der Seite gezeigt.<br /><br />Folgen Sie den Anweisungen.<br /><br />";
$pgv_lang["empty_cart_help"]			= "~AUSSCHNITTSAMMELBEHÄLTER LEEREN~<br />Klicken Sie dieses Link, um den Ausschnittsammelbehälter zu leeren.<br /><br />Falls Sie nicht ALLE Personen, Familien usw. aus dem Sammelbehälter entfernen möchten, können Sie auch einzelne Elemente entfernenen, indem Sie das jeweilige «Entfernen»-Link in der Namensbox klicken.<br /><br />";
$pgv_lang["add_by_id_help"]				= "~ID-Nummer dem Sammelbehälter hinzufügen~<br />Hier geben Sie die ID-Nummer der Person, dessen Datensatz dem Sammelbehälter hinzugefügt werden soll.  Nachdem Sie diese ID-Nummer eingegeben haben, können Sie bestimmen ob und welche Verwandte dem Sammelbehälter auch hinzugefügt werden sollen.<br /><br />Falls Sie die ID-Nummer der gewünschten Person nicht wissen, können Sie die Datenbank danach dursuchen.<br /><br />";
$pgv_lang["zip_help"]					= "~Ausschnitt als ZIP-Datei erstellen~<br />Wenn diese Option angekreuzt ist, wird die Ausgangs-Datei im ZIP format erstellt.<br /><br />ZIP-Dateien sind oft weitaus kleiner als gewöhnliche Dateien, aber sie benötigen ein passendes Programm um daraus eine Datei zu erstellen die dann von gewöhnlichen Programmen bearbeitet werden kann.  Der Zweck der ZIP-Dateien ist das schnelle Übertragen der Datensätze auf Ihren lokalen Computer.<br /><br />Bitte wenden Sie sich an <a href=\"http://de.wikipedia.org/wiki/ZIP_%28Dateiformat%29\" target=\"_blank\">http://de.wikipedia.org/wiki/ZIP_%28Dateiformat%29</a> um mehr Auskunft über ZIP Dateien zu erhalten.<br /><br />";
$pgv_lang["include_media_help"]			= "~Medien hinzufügen~<br />Diese Option bestimmt ob Medien-Dateien die mit den Personen im Sammelbehälter verknüpft sind auch dem Sammelbehälter hinzugefügt werden sollen.<br /><br />Wenn diese Option angekreuzt ist, wird die Ausgangs-Datei automatisch im ZIP-Format erstellt.<br /><br />";
$pgv_lang["clip_cart_help"]				= "~Sammelbehälter~<br />Diese Tabelle zeigt Ihnen den aktuellen Inhalt des Sammelbehälters.  In der <i>Typ</i> Spalte finden Sie den Typ des jeweiligen Eintrages.  Die Eintragstypen, die hier dargestellt sind können Person (INDI), Familie (FAM), Quelle (SOUR), Archiv (REPO), Bemerkung (NOTE), oder Medien-Objekte (OBJE) sein.  In der <i>ID</i> Spalte finden Sie die ID-Nummer des jeweiligen Eintrages. Die <i>Name / Beschreibung</i> Spalte enthält den Namen der Familie oder Person, oder die in der Datenbank eingetragene Beschreibung des Datensatzes.<br /><br /><b>Wenn Sie Einträge aus dem Sammelbehälter entfernen, fragt das Programm <u>nicht</u> ob Sie dessen sicher sind.</b><br /><br />";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			= "~ÄNDERUNGEN AN DER GEDCOM-DATEI ZEIGEN~<br />Wenn Sie diese Meldung sehen, bedeutet das:<br /><br />1. Jemand hat Änderungen an der GEDCOM-Datei vorgenommen.<br />Einer oder mehrere Datensätze wurden hinzugefügt, verändert oder gelöscht.<br /><br />2. Die Änderungen wurden bisher noch nicht vom Verwalter in die Datenbank übernommen.<br /><br />Sobald die Änderungen übernommen oder abgelehnt sind, wird diese Meldung nicht mehr gezeigt.<br /><br />Indem Sie das Link klicken, sehen Sie, welche Änderungen beantragt wurden. Wenn Sie merken, dass eine Änderung nicht korrekt ist, informieren Sie bitte den Verwalter.<br /><br />";

//-- Search-page
$pgv_lang["help_search.php"]			= "~Die SUCH-SEITE~<br />Obwohl diese Seite sehr einfach aussieht, arbeitet sie mit einem vielseitigen Such-Algorithmus.<br /><br />Die meisten Genealogie-Webseiten ermöglichen nur eine einfache Nachnamen-Suche. Auf dieser Seite können Sie praktisch nach allem suchen.<br /><br />Das Such-Feld auf der linken Seite ist das gleiche wie im Seitenkopf.<br /><br />Wenn Sie nach Personen in Verbindung mit einer bestimmten Jahreszahl suchen, geben Sie nur das Jahr ein. Das Programm wird alle Verbindungen finden.<br /><br />Suchen Sie einen Namen oder einen Ort?<br />Geben Sie den Namen oder den Ort (vollständing oder teilweise) ein, und das Programm erledigt den Rest.<br /><br />SOUNDEX (Phonetische) Suche<br />Mit diesen Such-Feldern auf der rechten Seite können Sie nach Namen von Personen oder Orten suchen, auch wenn Sie die genaue Schreibweise nicht kennen.<br /><br />Sie finden weitere Hilfe, wenn Sie das Fragezeichen an den Feldern klicken.<br /><br />";
$pgv_lang["search_enter_terms_help"]	= "~SUCH-BEGRIFFE EINGEBEN~<br />In dieses Feld können Sie Suchkriterien wie Daten, Vornamen, Nachnamen, Orte, Mediennamen usw. eingeben.<br /><br /><b>Wildcards (Joker)</b><br />Wildcards, die Sie sicherlich kennen (wie * oder ?), sind nicht erlaubt, aber das Programm <u>vermutet</u> mit einer Ausnahme immer Wildcards.<br /><br />Was bedeutet das?<br />Angenommen Sie geben in in das Such-Feld folgendes ein: <b>Pete</b><br />Als Ergebnis erhalten Sie (vorausgesetzt diese Namen sind in der Datenbank enthalten):<div style=\"padding-left:30px;\"><b>Pete</b> Schmidt<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />irgendjemand --Geburt 1. Januar 1901 <b>Pete</b>rsburg<br />usw.</div><br /><b>Daten</b><br />Geben Sie ein Datum in das Such-Feld ein und Sie erhalten eine Liste aller Personen, die mit dieser Jahreszahl in Verbindung stehen. Wenn Sie 1950 eingeben, erhalten Sie alle Personen, die in diesem Jahr geboren wurden, geheiratet haben, gestorben sind usw. Wenn Sie <b>4&nbsp;Dec</b> eingeben, werden alle Personen, die Verbindung zu einem Ereignis an irgend einem 4. Dezember haben, aufgezählt. Es werden aber auch Personen mit Ereignissen am 14. oder 24. Dezember aufgezählt. Wie Sie sehen, werden auch hier Wildcards angenommen, so dass man sie nicht eingeben muss.<br /><br /><b>Richtige Datumsangabe</b><br />Das Programm sucht nach den Daten, so wie sie in der GEDCOM-Datei eingetragen sind. D. h., wenn Sie nach einem Ereignis an irgend einem 14. Dezember suchen, sollten Sie <b>14&nbsp;dec</b><br /> eingeben, weil diese englische Schreibweise in GEDCOM-Dateien verwendet wird. Wenn Sie z.B. <b>dec&nbsp;14</b> eingeben, würde das Ergebnis eine Person sein, die z.B. mit dem Datum 08 <b>dec</b>ember 18<b>14</b> verbunden ist. Sie können auch reguläre Ausdrücke in der Sucher verwenden. Um z.B. alle Personen zu finden, die Daten im 20. Jahrhundert haben, geben Sie im Suchfeld <b>19[0-9][0-9]</b> ein, dann erhalten Sie Personen mit Daten von 1900 bis 1999.<br /><br />Wenn Sie weitere Hilfe zu diesem Such-System benötigen, teilen Sie uns dies mit, damit wir die Hilfe-Datei erweitern können.<br /><br />";
$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br />Mit dieser Funktion können Sie die Datenbank nach Fehlern durchsuchen und diese korrigieren.<br /><br /><b>Suchen</b><br />Diese Option durchsucht die Datenbank genau wie eine <a href=\"help_text.php?help=search_enter_terms_help\">normale Suche</a>.<br /><br /><b>Ersetzen</b><br />Alle Vorkommen des Such-Objekts werden in der Datenbank mit dem Ersatz-Objekt ersetzt.<br /><br /><b>Zum Beispiel...</b><br />Sie haben versehentlich den Namen Ihres Ur-Großvaters «Michael» als «Micheal» eingegeben.<br /><br />Als Such-Objekt würden Sie <b>Micheal</b> eingeben, und als Ersatz-Objekt <b>Michael</b>.<br />Jedes Vorkommen von «Micheal» wird dann mit «Michael» ersetzt.<br /><br /><b>Suchen nach...</b><br />Zuerst sollten Sie den Umfang der Suche bestimmen.  Sie können die Suche auf Namen, Orte, oder nicht beschränken.  Falls Sie keine Beschränkung bestimmen, wird die ganze Datenbank durchsucht.  Falls Sie die Option <i>#pgv_lang[search_place_word]#</i> wählen, durchsucht das Programm Ortsangaben ohne zugleich Wildcards anzunehmen.  Dementsprechend wird Ihr Suchobjekt in Ortsangaben nur gefunden, wenn es dort als alleinstehendes Wort vorhanden ist. Zum Beispiel, eine Suche nach <b>UT</b> findet dann nicht «ut» innerhalb Connectic<b>ut</b>.<br /><br />Bitte machen Sie sich keine Sorgen über Fehler in der Ersetzung.  Am Ende der automatischen Ersetzung können Sie jede Änderung einzeln annehmen oder verwerfen.<br /><br />";
$pgv_lang["soundex_search_help"]		= "~NAMEN NACH AUSSPRACHE SUCHEN - SOUNDEX (PHONETISCHE) NAMENS SUCHE~<br />Die SOUNDEX Namens-Suche ist besonders leistungstark. Zunächst eine kurze Erläuterung zu Soundex:<br /><br />Soundex sortiert Namen, die gleich klingen aber verschieden geschrieben werden, zusammen. Der Soundex-Code eines Namens beginnt mit dem ersten Buchstaben des Nachnamens, gefolgt von einem 3-ziffrigen Code, der die ersten drei folgenden Konsonanten repräsentiert. Nullen werden angefügt, falls der Name zu kurz ist.<br /><br />Für einen englischen Namen bedeutet das:<br />Wenn Sie nach «Smith» suchen, können Sie als Ergebnis folgende erhalten:<br />Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead,  Sneed, Smoote usw.<br /><br />Über die eigentliche Codierung brauchen Sie sich keine Gedanken zu machen. Geben Sie einfach einen Namen ein, nach dem Sie suchen, und das Programm erledigt die Aufgabe.<br /><br />Die Soundex-Suche ist sehr nützlich, wenn man die genaue Schreibweise eines Namens nicht kennt. Es kann auch vorkommen, dass beim Eingeben einer Person in die Datenbank ein Schreibfehler passiert ist. Mit dem Soundex-System finden Sie auch solche Namen.<br /><br />Um damit vertraut zu werden, versuchen Sie nach einem Namen zu suchen, aber geben Sie ihn in veränderter Schreibweise in das Feld ein.<br /><br />Bei der Soundex-Suche genügt schon ein Name als Ausgangspunkt. Sie können nach einem Vor-, Nachnamen oder einer Ortsangabe suchen. Wenn Sie mehrere Angaben machen, werden diese mit «UND» verknüpft.<br /><br />Sie können die Anzahl der Suchergebnisse auch verringern, wenn Sie zusätzlich eine Jahreszahl oder einen Zeitraum eingeben. Z.B.: 1950 oder 19[5-7][0-9], letzteres bedeutet 1950 bis 1979. Das Suchergebnis enthält alle Personen bei denen ein Ereignis am betreffenden Ort in der angegebenen Zeitspanne eingetragen ist.<br /><br />";
$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />Die Wahl <b>#pgv_lang[search_tagfon]#</b> bewirkt dass folgende GEDCOM Tags nicht durchsucht werden:<div style=\"padding-left:30px;\"><b>_PGVU</b> - Letzte Änderung von<br /><b>CHAN</b> - Datum der letzten Änderung<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />Folgende GEDCOM Tags werden nie durchsucht:<div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div><br /><br />";
$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />Diese Option bewirkt, dass in den Such-Resultaten auch Personen gezeigt werden, die mit der gefundenen Person oder Familie irgend eine Beziehung haben.  Die umgekehrte Wirkung, wo alle Personen oder Familien die irgend eine Beziehung zu der gefundenen Person haben, ist leider nicht möglich.<br /><br />Zum Beispiel, falls Person <b>A</b> Pate von Person <b>B</b> ist, und dieses durch einen ASSO Tag im Datensatz der Person <b>B</b> angedeutet wurde, wird Person <b>A</b> immer in den Resultaten automatisch gezeigt, wenn Person <b>B</b> darin gezeigt wird.<br /><br />Das Umgekehrte, wo Person <b>B</b> in den Resultaten automatisch gezeigt werden sollte wenn Person <b>A</b> sich darin befindet, ist nicht möglich, da das ASSO Tag im Datensatz der Person <b>A</b> fehlt.<br /><br />";

//-- Individuals-page
$pgv_lang["help_individual.php"]		= "~PERSÖNLICHE INFORMATIONEN SEITE~<br />Auf dieser Seite werden alle Details zu einer Person aufgezählt.<br /><br />Falls ein Bild vorhanden ist, wird es links oben gezeigt. Direkt neben dem Bild sehen Sie alle Namen der Person. Zu den Namen können Notizen oder Quellen angegeben sein. Wenn zu einem Namen diese Angaben vorhanden sind, werden Sie jeweils unter dem Namen gezeigt. Wenn die Person auch unter anderem Namen bekannt ist (AKA = Also Known As), erscheint dies hier ebenfalls.<br /><br />Wenn Sie Rechte zum Bearbeiten der Daten haben, sehen Sie bei einigen Angaben auch Links zum Bearbeiten oder Löschen.<br /><br />Auf dieser Seite gibt es außerdem die Ordner «Persönliche Fakten und Details», «Notizen», «Quellen», «Multimedia» und «Direkte Verwandtschaft».<br /><br />In diesen Ordnern finden Sie alle Informationen die in der GEDCOM-Datei zu dieser Person gespeichert sind.<br /><ul><li>Der Ordner «Persönliche Fakten und Details» zeigt die Daten der Person und zu Ehen. Wenn Sie ein Datum in diesem Ordner klicken, gelangen Sie zum Jahrestagskalender für dieses Datum, der Ihnen andere Ereignisse dieses Datums aus der GEDCOM-Datei zeigt. Wenn Sie auf einen Ort klicken, gelangen Sie in die Liste der Orte und finden so andere Personen, in deren Leben dieser Ort irgendeine Rolle spielte. Bei Ehen und anderen Familienereignissen wird der Name des Ehepartners gezeigt, so dass Sie direkt zum Partner gelangen können; außerdem ist ein Link zur Familien-Seite vorhanden.<br /></li><li>Der «Notizen»-Ordner zeigt alle allgemeinen Notizen, die zu dieser Person vorhanden sind.<br /></li><li>Der «Quellen»-Ordner zeigt alle Quellen, in denen diese Person genannt wird. Klicken Sie den Titel einer Quelle, erhalten Sie weitere Informationen zu dieser Quelle, sowie eine Liste von weiteren Personen, die in dieser Quelle genannt werden.<br /></li><li>Der «Multimedia»-Ordner zeigt alle Bilder oder andere Media-Dateien, die zu dieser Person verbunden sind. Wenn Sie das Miniaturbild eines Bildes klicken, öffnet sich ein größeres Bild-Betrachtungsfenster.<br /></li><li>Der «Direkte Verwandschaft»-Ordner listet die Eltern und Geschwistern, sowie die Ehepartner und Kinder dieser Person. Alle Personen sind in Boxen dargestellt, die den Boxen in den Diagrammen ähneln.</li></ul><br /><br />Am rechten Rand des Bildschirmes sehen Sie eine Box mit Links. Die meisten Links in dieser Box entsprechen denen im Menü der Kopfzeile. Wenn Sie z.B. das «Stammbaum»-Link an der rechten Seite klicken, gelangen Sie zum Stammbaum dieser Person. Das ist der Unterschied zu den Links im Menü, denn dort führt das «Stammbaum»-Link zum Grund-Stammbaum dieser GEDCOM-Datei.<br /><br />Wenn der Verwalter diese Funktion aktiviert hat, erscheint bei diesen Links rechts auch «GEDCOM-Datensatz zeigen». Dieses Link zeigt Ihnen die GEDCOM Rohdaten dieser Person.<br /><br />Wenn der Ausschnittsammelbehälter aktiviert wurde, erscheint auch ein Link, das diese Person in den Ausschnittsammelbehälter hinzufügt.<br /><br />Das Link «Verwandschaft mit mir» erscheint nur, wenn Sie angemeldet sind und Ihnen eine ID-Nummer in der GEDCOM-Datei zugewiesen wurde. Ihnen wird mit diesem Link gezeigt, wie Sie mit dieser Person verwandt sind.<br /><br />Weitere Hilfe zu dieser Seite erhalten Sie, wenn Sie das <b>?</b> neben den Links oder Elementen klicken.<br /><br />";
$pgv_lang["delete_person_help"]			= "~#pgv_lang[delete_person]#~<br />Wenn Sie dieses Link klicken, wird die Person zum Löschen markiert.<br /><br />Was bedeutet das?<br />Angenommen Sie möchten aus irgendeinem Grund eine Person löschen. Klicken Sie das Link, dann erscheint eine Sicherheitsabfrage zum Löschen oder Abbrechen.<br /><br />Wenn Sie mit dem Löschen fortfahren, kann es einige Zeit dauern, bis eine Bestätigungs-Nachricht erscheint.<br /><br />Bei näherem Betrachten werden Sie aber feststellen, dass die Person weiterhin sichtbar ist und wie zuvor gewählt werden kann.<br /><br />Dies ist <b>kein</b> Fehler.<br />Der Verwalter wird eine Nachricht bekommen, dass Änderungen an der Datenbank erwünscht sind, und dass Sie die Person gelöscht haben. Der Verwalter kann Ihre Änderung in die Datenbank übernehmen oder sie ablehnen. Erst danach ist die Person unwiderruflich gelöscht. Im Zweifelsfall wird der Verwalter Sie kontaktieren.<br /><br />";
$pgv_lang["delete_name_help"]			= "~NAMEN EDITIEREN ODER LÖSCHEN~<br /><b>Namen editieren</b><br />Wenn Sie dieses Link klicken, öffnet sich ein Fenster, in dem Sie den Namen der Person verändern können. Das funktioniert einfach, indem Sie die Änderungen in die Felder schreiben und auf Speichern klicken. Dann können Sie das Fenster einfach schließen.<br /><br /><b>Namen löschen</b><br />Wenn Sie dieses Link klicken, wird der Name zum Löschen markiert. Beachten Sie bitte, dass das Löschen eines Namens etwas anderes ist als das Löschen einer Person. Wenn Sie den Namen löschen, wird nur der Name der Person entfernt. Die Person selbst wird nicht gelöscht. Wenn Sie den Namen unter «auch bekannt als» löschen, trägt die Person immer noch ihre anderen Namen. Wenn Sie alle Namen löschen, wird die Person anschließend unter «Unbekannt» aufgezählt. Die Person wird aber nicht von den übrigen Verwandten getrennt, ebensowenig von den Links zu Quellen, Notizen usw.<br /><br />Wie funktioniert das?<br />Angenommen Sie möchten aus irgendeinem Grund den Namen einer Person löschen. Klicken Sie das Link, dann erscheint eine Sicherheitsabfrage zum Löschen oder Abbrechen. Wenn Sie mit dem Löschen fortfahren, kann es einige Zeit dauern, bis eine Bestätigungs-Nachricht erscheint.<br /><br />Bei näherem Betrachten werden Sie aber feststellen, dass der Name weiterhin sichtbar ist und wie zuvor gewählt werden kann.<br /><br />Dies ist <b>kein</b> Fehler.<br />Der Verwalter wird eine Nachricht bekommen, dass nderungen an der Datenbank erwünscht sind, und dass Sie den Namen gelöscht haben. Der Verwalter kann Ihre Änderung in die Datenbank übernehmen oder sie ablehnen. Erst danach ist der Name unwiderruflich gelöscht. Im Zweifelsfall wird der Verwalter Sie kontaktieren.<br /><br />";
$pgv_lang["add_name_help"]				= "~NEUEN NAMEN HINZUFÜGEN~<br />Mit diesem Link können Sie einen weiteren Namen zu einer Person hinzufügen. Eventuell sind Personen unter anderen Namen oder Schreibweisen bekannt. Mit diesem Link können Sie einen neuen Namen zu einer Person hinzufügen, ohne die alten Namen zu ändern.<br /><br />";
$pgv_lang["add_sibling_help"]			= "~EINEN BRUDER ODER EINE SCHWESTER HINZUFÜGEN~<br />Wenn Sie dieses Link klicken, können Sie ein der Datenbank bisher unbekanntes Kind zu dieser Familie hinzufügen.<br /><br />«Diese Familie» ist in diesem Fall der Vater und die Mutter der Person, deren Seite Sie gerade betrachten. Das heißt, Sie fügen einen Bruder oder eine Schwester dieser Person hinzu.<br /><br />Das Verfahren ist einfach: Klicken Sie das Link, und füllen Sie die Felder im Formular aus.<br /><br />Wenn Sie einen Sohn oder eine Tochter der Hauptperson dieser Seite hinzufügen möchten, scrollen Sie ein wenig nach unten und klicken Sie das Link unter «Familie mit Ehefrau».<br /><br />";
$pgv_lang["add_son_daughter_help"]		= "~EINEN SOHN ODER EINE TOCHTER HINZUFÜGEN~<br />Wenn Sie dieses Link klicken, können Sie ein der Datenbank bisher unbekanntes Kind zu dieser Familie hinzufügen.<br /><br />«Diese Familie» ist in diesem Fall die Person, deren Seite Sie gerade betrachten und dessen Ehepartner. Das heißt, Sie fügen einen Sohn oder eine Tochter dieser Person hinzu.<br /><br />Das Verfahren ist einfach: Klicken Sie das Link, und füllen Sie die Felder im Formular aus.<br /><br />Wenn Sie einen Bruder oder eine Schwester der Hauptperson dieser Seite hinzufügen möchten, scrollen Sie ein wenig nach oben und klicken Sie das Link unter «Familiendaten als Kind».<br /><br />";
$pgv_lang["link_child_help"]			= "~DIESE PERSON ALS KIND MIT EINER BESTEHENDEN FAMILIE VERBINDEN~<br />Wenn Sie dieses Link klicken, können Sie die Person als Kind zu einer bestehenden Familie hinzufügen.<br /><br />Wenn z.B. die Eltern einer Person als unbekannt eingetragen wurden, und Sie später feststellen, dass die Eltern auch in der Datenbank eingetragen sind, klicken Sie dieses Link.<br /><br />Geben Sie die ID-Nummer der Familie an (wenn Sie die ID-Nummer nicht kennen, können Sie danach suchen) und die Verbindung ist schon eingetragen.<br /><br />";
$pgv_lang["link_husband_help"]			= "~DIESE PERSON ALS EHEMANN MIT EINER BESTEHENDEN FAMILIE VERBINDEN~<br />Wenn Sie dieses Link klicken, fügen Sie die aktuelle Person als Ehemann zu einer bereits bestehenden Familie hinzu. Wenn Sie dieses Link klicken, wird die Person zu einer bestehenden Familie hinzugefügt, in der der Ehemann bisher unbekannt war. Die Person wird den Platz dieses unbekannten Ehemannes einnehmen. Alle Ereignisse, Ehedaten, Informationen und Kinder werden ihre bestehenden Verbindungen zu dieser Familie beibehalten.<br /><br />Klicken Sie nur dieses Link und geben Sie die ID-Nummer der Familie ein.  Wenn Sie die ID-Nummer nicht kennen, können Sie danach suchen. Diese besondere Option darf nur verwendet werden, wenn die Familie wirklich schon in der Datei existiert. Wenn Sie eine neue Familie hinzufügen möchten, verwenden Sie bitte das Link «Ehefrau hinzufügen».<br /><br />";
$pgv_lang["add_husband_help"]			= "~EINEN WEITEREN EHEMANN HINZUFÜGEN~<br />Wenn Sie dieses Link klicken, können Sie eine neue männliche Person eintragen und mit der Hauptperson dieser Seite als Ehemann verknüpfen.<br /><br />Klicken Sie einfach dieses Link und es öffnet sich ein Formular zum Eingeben der neuen Person. Füllen Sie so viele Felder wie möglich aus und klicken Sie den «Speichern» Button.<br /><br />";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br />Diese Option ermöglicht Ihnen, eine bereits bestehende Person als neuen Ehemann mit dieser Person zu verknüpfen.  Dadurch entsteht eine neue Familie, worin die von Ihnen eingegebene Person als Ehemann erscheint.  Sie können auch sofort Details über die Ehe eingeben.<br /><br />";
$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />Wenn Sie dieses Link klicken, können Sie dieser Person ein <u>neues</u> Kind hinzufügen.  Dadurch wird auch gleichzeitig eine neue Familie erstellt, die nur ein Elternteil hat.<br /><br />Klicken Sie einfach dieses Link und es öffnet sich ein Formular zum Eingeben des neuen Kindes. Füllen Sie so viele Felder wie möglich aus und klicken Sie den «Speichern» Button.<br /><br />";
$pgv_lang["link_wife_help"]				= "~DIESE PERSON ALS EHEFRAU MIT EINER BESTEHENDEN FAMILIE VERBINDEN~<br />Wenn Sie dieses Link klicken, fügen Sie die aktuelle Person als Ehefrau zu einer bereits in der GEDCOM-Datei bestehenden Familie hinzu. Diese besondere Option darf nur verwendet werden, wenn die Familie wirklich schon in der Datei existiert. Wenn Sie eine neue Familie hinzufügen möchten, verwenden Sie bitte das Link «Ehemann hinzufügen».<br /><br />";
$pgv_lang["add_wife_help"]				= "~EINE WEITERE EHEFRAU HINZUFÜGEN~<br />Wenn Sie dieses Link klicken, können Sie eine neue weibliche Person eintragen und mit der Hauptperson dieser Seite als Ehefrau verknüpfen.<br /><br />Klicken Sie einfach dieses Link und es öffnet sich ein Formular zum Eingeben der neuen Person. Füllen Sie so viele Felder wie möglich aus und klicken Sie den «Speichern» Button.<br /><br />";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br />Diese Option ermöglicht Ihnen, eine bereits bestehende Person als neue Ehefrau mit dieser Person zu verknüpfen.  Dadurch entsteht eine neue Familie, worin die von Ihnen eingegebene Person als Ehefrau erscheint.  Sie können auch sofort Details über die Ehe eingeben.<br /><br />";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~VATER oder MUTTER HINZUFÜGEN~<br />Bei vielen Personen in der GEDCOM-Datei sind Vater bzw. Mutter noch nicht eingetragen.<br /><br />In diesem Fall sehen Sie auf der Seite <b>Persönliche Informationen</b>, Ordner <b>Direkte Verwandschaft</b> in der Tabelle <b>Familiendaten als Kind</b> die Links zum hinzufügen von Vater oder Mutter.<br /><br /><b>ANMERKUNG:</b><br />Bitte beachten Sie, dass diese Links bestimmt sind, Eltern einzutragen, wenn keine Eltern vorhanden sind. Wenn Vater oder Mutter bereits in der GEDCOM-Datei eingetragen sind, benutzen Sie bitte das folgende Link: <b>#pgv_lang[link_as]##pgv_lang[child]#</b>, das Sie ebenfalls auf der Seite der persönlichen Informationen unterhalb der letzten Tabelle finden.<br /><br />";
$pgv_lang["show_fact_sources_help"]		= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br />Wenn diese Option angekreuzt ist, können Sie alle Quellenangaben oder Bemerkungen dieser Person sehen.  Wenn die Option nicht angekreuzt ist, werden Quellenangaben oder Bemerkungen, die mit Fakten verbunden sind, nicht gezeigt.<br /><br />";
$pgv_lang["age_differences_help"]		= "~#pgv_lang[age_differences]#~<br />Wenn die Option angekreuzt ist, zeigt der «#pgv_lang[relatives]#» Ordner Differenzen zwischen Daten wie folgt:<br /><ul><li>Geburtsdaten der Partner.<br />Die negative Zahl bedeutet dass der zweite Partner älter ist als der erste.<br /><br /></li><li>Ehedatum und Geburtsdatum des ersten Kindes.<br />Die negative Zahl bedeutet dass das Kind vor der Ehe geboren wurde oder dass entweder das Ehedatum oder das Geburtsdatum des ersten Kindes fehlerhaft ist.<br /><br /></li><li>Geburtsdaten der Geschwister.<br />Die negative Zahl bedeutet dass entweder die Reihenfolge oder die Geburtsdaten fehlerhaft sind.</li></ul><br /><br />";

//-- Add Facts
$pgv_lang["add_facts_help"]				= "~NEUE EREIGNISSE HINZUFÜGEN~<br />Hier können Sie ein Ereignis zu einer Person hinzufügen.<br /><br />Wählen Sie zunächst das Ereignis aus der Liste, klicken Sie dann den «Hinzufügen» Button. In der Liste befinden sich schon alle möglichen Ereignisse, die zum Hinzufügen in Frage kommen.<br /><br />";
$pgv_lang["add_custom_facts_help"]		= "~Ein benutzerdefiniertes Ereignis hinzufügen~<br />Wenn Sie das Ereignis, das Sie hinzufügen möchten, in der Liste der vordefinierten Ereignisse nicht finden können, benutzen Sie ein <b>Benutzerdefiniertes Ereignis</b>.<br /><br />Es gibt bei der Eingabe keinen wesentlichen Unterschied zu einem vordefinierten Ereignis. Sie müssen nur für das Ereignis zusätzlich eine Bezeichnung eingeben. Nutzen Sie hierfür das oberste Feld: <b>#pgv_lang[type]#</b><br />";
$pgv_lang["add_note_help"]				= "#pgv_lang[multiple_help]#<br />~NEUE NOTIZ HINZUFÜGEN~<br />Wenn Sie eine Notiz zu einer Person hinzufügen möchten, können Sie das hier tun.<br /><br />Klicken Sie einfach das Link, dann öffnet sich ein Formular und Sie können die Notiz dort eingeben. Wenn Sie fertig sind, klicken Sie den Button unter der Box und schließen Sie das Formular.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~Neues Quellenzitat hinzufügen~<br />Wenn Sie ein neues Quellenzitat hinzufügen möchten, können Sie das hier tun.<br /><br />Klicken Se einfach das Link, dann öffnet sich ein Formular.  Sie können die Quelle, die Sie zitieren möchten, aus einer Liste wählen, oder Sie können erst die neue Quelle erstellen und danach zitieren.<br /><br />Quellenzitate sind für Ahnenforscher sehr wichtig; Mit Quellenzitaten können Andere Ihrer Forschung folgen.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]				= "~NEUE MULTIMEDIA-DATEI HINZUFÜGEN~<br />Dies ist eine sehr nützliche Funktion. Obwohl das Programm die Daten auch ohne Bilder schon sehr angenehm darstellt, wird die Optik durch hinzugefügte Bilder oder andere Multimedia-Dateien doch deutlich aufgewertet.<br /><br /><b>Hierbei sollten Sie allerdings einiges beachten.</b><br />Wie Sie sicher wissen, gibt es unzählige Formate für Multimedia-Dateien. Auch wenn PhpGedView die meisten davon verarbeiten kann, sollte man bestimmte Hinweise berücksichtigen.<br /><ul><li><b>Dateityp</b><br />Bilder können in verschiedenen Dateitypen gespeichert werden. z.B. picture.jpg / picture.png / picture.bmp / picture.gif / usw. Alle Bilder dieses Beispieles können die selbe Pixelzahl haben, aber die Dateien werden sich in ihrer Größe stark unterscheiden.<br /></li><li><b>Auflösung</b><br />Die Auflösung eines Bildes wird in «dpi» (dots per inch = Punkte pro Inch, ein Inch=Zoll sind 2,54 cm) angegeben. Sie können diese Angabe im Grunde vergleichen mit den Unterschieden zwischen 25 ASA - 200 ASA - 800 ASA in der herkömmlichen Fotografie. Je höher die Auflösung, umso besser die Qualität, aber umso größer wird auch die Datei. Für ein Bild im Internet sind 75 dpi normalerweise gut genug.<br /></li><li><b>Farbtiefe</b><br />Eine weitere Möglichkeit, die Datei kleiner zu bekommen, ist die Anzahl der Farben zu vermindern. Die Anzahl der Farben kann variieren zwischen 2 (Schwarz-Weiß) und «True-Color» also einer wirklichkeitsgetreuen Farbdarstellung. Natürlich ist die Datei umso größer, je mehr Farben benutzt werden.<br /></li><li><b>Warum ist es wichtig kleine Dateien zu verwenden?</b><ul><li><b>Zuallererst weil der Web-Speicherplatz begrenzt ist.</b> Je größer die einzelnen Dateien sind, umso mehr Platz wird auf dem Server belegt. Je mehr Platz man belegt, umso mehr muss man in der Regel dafür bezahlen.</li><li><b>Übertragungsdauer.</b> Wenn Sie große Dateien verwenden, muss der Besucher sehr lange warten, bis die Datei vom Server auf seinen Rechner übertragen ist. Nicht jeder verfügt über einen Breitband-Anschluss oder DSL.</li></ul></li><li><b>Wie laden Sie Ihre Multimedia-Datei hoch?</b><br />Kurz gesagt: Es geht nicht. Auch aus den eben genannten Gründen können Sie Ihre Datei nicht direkt in die Datenbank hochladen.<br /></li><li><b>Was nun?</b><br />Kontaktieren Sie den Verwalter und teilen Sie ihm mit, dass Sie eine Datei beisteuern möchten. Er kann Ihnen auch mitteilen, was das optimale Format ist. Wenn Sie Bilder im richtigen Format haben, können Sie diese per Mail an den Verwalter schicken. Er wird die Bilder prüfen und auf die Webseite hochladen. Anschließend können Sie diese Multimedia-Dateien mit Personen verknüpfen, indem Sie dieses Link verwenden.</li></ul><br />";
$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br />Diese Option erzeugt fehlende Miniaturbilder für alle Bilder in diesem Verzeichnis.  Das ist leichter und schneller als das Benutzen der einzelnen <b>#pgv_lang[gen_thumb]#</b> Optionen.<br /><br />Sie müssen die einzelnen <b>#pgv_lang[gen_thumb]#</b> Optionen benutzen, wenn nicht alle fehlende Miniaturbilder erzeugt werden sollen.<br /><br />";
$pgv_lang["add_facts_general_help"]		= "~Allgemeine Informationen über das Hinzufügen~<br />Wenn Sie ein Ereignis, eine Notiz, Quelle oder eine Multi-Media-Datei zu einer Person hinzugefügt haben, muss dieser Vorgang erst von einem Benutzer mit «Akzeptieren»-Rechten überprüft werden. Inzwischen sind die Änderungen auf der Seite nur für Benutzer mit Editier-Rechten sichtbar und mit einem andersfarbigen Rahmen gekennzeichnet. Wenn die Angaben überprüft sind, verschwinden die andersfarbigen Rahmen und die Daten werden dann wie üblich dargestellt.<br /><br />";

//-- Edit user
$pgv_lang["edituser_my_account_help"]	= "Auf dieser Seite können Sie Ihre persönlichen Einstellungen ändern.<br /><br />Sie können Ihren Benutzernamen, den richtigen Namen, Ihr Kennwort, die Sprachanzeige, Mail-Adresse, verwendetes Theme und die bevorzugte Kontakt-Methode anpassen.<br /><br />Was Sie nicht selbst ändern können, ist Ihre ID-Nummer in der Datenbank.<br /><br />";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br />In diesem Feld können Sie Ihren Benutzernamen ändern.<br /><br />Wenn Sie einen neuen Benutzernamen haben möchten, können Sie ihn hier eintragen. Beim Benutzernamen müssen Sie auf <b>Groß- und Kleinschreibung</b> achten. Das bedeutet, das «John» nicht das gleiche ist wie «john» oder «JOHN».<br /><br />Sie sollten <b>ausschließlich</b> Buchstaben des vom Programm unterstützten Alphabets (große oder kleine Buchstaben), Ziffern, Bindestriche (-) und Unterstriche (_) verwenden. Verwenden Sie <b>keine</b> Interpunktionszeichen, Leerzeichen oder andere Sonderzeichen wie Umlaute usw.<br /><br />";
$pgv_lang["edituser_firstname_help"]	= "~#pgv_lang[firstname]#~<br />Durch Eingaben in diesem Feld können Sie Ihren Vornamen ändern.  Ihre Vor- und Nachnamen, die Sie hier eingeben, sind anderen angemeldeten Benutzern sichtbar wenn Sie auch angemeldet sind.<br /><br />Obwohl diese Namen Ihnen überlassen sind, sollten Sie den Verwalter über Änderungen Ihres Benutzernamens benachrichtigen.  So hat der Verwalter immer über eingetragene Benutzer Bescheid, ohne die Benutzerliste mühsam nach Änderungen zu durchsuchen.  Er kann dann Fragen anderer Benutzer über neu erscheinende Benutzer leicht beantworten.<br /><br />";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br />Durch Eingaben in diesem Feld können Sie Ihren Nachnamen ändern.  Ihre Vor- und Nachnamen, die Sie hier eingeben, sind anderen angemeldeten Benutzern sichtbar wenn Sie auch angemeldet sind.<br /><br />Obwohl diese Namen Ihnen überlassen sind, sollten Sie den Verwalter über Änderungen Ihres Benutzernamens benachrichtigen.  So hat der Verwalter immer über eingetragene Benutzer Bescheid, ohne die Benutzerliste mühsam nach Änderungen zu durchsuchen.  Er kann dann Fragen anderer Benutzer über neu erscheinende Benutzer leicht beantworten.<br /><br />";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br />Diese interne ID-Nummer verweist auf Ihre Daten in der Datenbank.<br /><br />Diese ID-Nummer können Sie nicht selbst ändern, sondern wird vom Verwalter eingetragen. Wenn Sie glauben, dass Ihre ID-Nummer nicht korrekt ist, kontaktieren Sie bitte den Verwalter, nur er kann sie ändern.<br /><br />";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br />Dies ist die Ausgangsperson aller Ihrer Diagramme.<br /><br />Bei der Ausgangsperson beginnen die Diagramme. Wenn Sie z.B. einen Stammbaum darstellen lassen, dann ist diese Person die äußerste Person am linken Rand. Natürlich muss diese Person nicht Sie selbst sein. Sie können jede Person wählen, solange Sie berechtigt sind die Person überhaupt zu sehen. In einigen Diagrammen können Sie die Ausgangsperson auch speziell nur für diese Seite ändern.<br /><br />";
$pgv_lang["edituser_password_help"]		= "~#pgv_lang[password]#~<br />Es ist sinnvoll, Ihr Kennwort regelmäßig zu ändern.<br /><br />Sie müssen bedenken, dass jeder, der Ihren Benutzernamen und Ihr Kennwort kennt, auch Ihre persönlichen Daten sehen kann. Das Kennwort sollte aus mindestens 6 Zeichen bestehen. Je länger, umso sicherer. Sie können alle Buchstaben des Alphabetes und Ziffern verwenden, sowie alle Zeichen auf der Tastatur.<br /><b>Anmerkung:</b> Sicherheitshalber sollten Sie <b>nicht</b> Anführungszeichen (\") oder Hochkommata (') verwenden! Das könnte zwar funktionieren, die Funktion ist aber nicht sichergestellt.<br /><br /><b>Ideal ist eine Mischung aus Großbuchstaben, Kleinbuchstaben, Ziffern und anderen Zeichen</b>. Beispiel: 5Z_q\$P4=r9.<br /><br />Wie beim Benutzernamen müssen Sie auch beim Kennwort auf <b>Groß- und Kleinschreibung</b> achten. Das bedeutet, das «Jo5hn» nicht das gleiche ist wie «jo5hn» oder «JO5HN».<br /><br />";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br />Wenn Sie Ihr Kennwort geändert haben, muss es ein zweites Mal eingegeben werden.<br /><br />Dies soll sicherstellen, dass Sie sich nicht bei der Eingabe vertippt haben. Wenn die beiden Eingaben nicht übereinstimmen, erhalten Sie eine Fehlermeldung: <b>#pgv_lang[password_mismatch]#</b>. Beide Felder (Kennwort- und Bestätigungsfeld) werden geleert und Sie müssen Ihr neues Kennwort nochmals in beiden Feldern eingeben.<br /><br />";
$pgv_lang["edituser_change_lang_help"]	= "~#pgv_lang[change_lang]#~<br />Hier stellen Sie eine Ausgabesprache ein, in der Sie diese Seite normalerweise betrachten möchten.<br /><br />Das Programm erkennt normalerweise die <b>Bevorzugte Sprache </b>-Einstellung Ihres Browsers, so dass Sie in den meisten Fällen hier gar keine Eingabe machen müssen. Trotzdem können Sie, wenn Ihr Browser z.B. auf Englisch eingestellt ist, diese Seite unabhängig davon auch standardmäßig auf Deutsch oder Holländisch ausgeben lassen.<br /><br />";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br />Ihre korrekte Mail-Adresse ist wichtig, damit der Verwalter mit Ihnen in Kontakt bleiben kann. Wenn Sie eine neue Mail-Adresse erhalten (z.B. bei Providerwechsel), vergessen Sie bitte nicht, diese auch hier einzutragen. Falls Sie mehrere Mail-Adressen haben und für genealogische Fragen eine bestimmte Adresse bevorzugen, geben Sie diese bitte hier an.<br /><br />";
$pgv_lang["edituser_user_theme_help"]	= "~#pgv_lang[user_theme]#~<br />Diese Seite können Sie sich in verschiedenen Themes zeigen lassen.<br /><br />Man könnte es auch als «Seiten-Layout» bezeichnen. In jedem Theme sehen Sie die selben Daten aber in einer anderen Darstellung. Es ist vergleichbar mit dem Wechsel eines Bilderrahmens oder dem Aufhängen eines Bildes in einem anderen Zimmer. Das Bild verändert sich dabei nicht, aber die Ansicht ist doch eine ganz andere.<br /><br />Probieren Sie es einfach aus. Stellen Sie ein anderes Theme ein. Geben Sie hier Ihr bevorzugtes Theme an. Immer wenn Sie sich bei dieser Seite anmelden, wird das Programm Ihr zuletzt benutzes Theme verwenden.<br /><br />";
$pgv_lang["edituser_contact_meth_help"]	= "~#pgv_lang[user_contact_method]#~<br />Das Nachrichten-System dieser Seite bietet verschiedene Methoden an.<br /><br />Die Sende-Methode wird vom Verwalter ausgewählt. Die Methode zum <b>Nachrichten-Empfang</b> können Sie hier einstellen. Derzeit stehen 4 verschiedene Methoden zur Verfügung.<br /><br />";
$pgv_lang["mail_option1_help"]			= "Wenn Sie diese Option nutzen, wird das interne PhpGedView Nachrichtensystem benutzt und es werden keine Mails versendet.<br /><br />So werden Sie nur <b>interne Nachrichten</b> von den anderen Nutzern erhalten. Wenn ein anderer Nutzer Ihnen eine Nachricht von dieser Seite aus schickt, wird diese im Nachrichten-Block auf Ihrer MeinGedView Seite erscheinen, sofern Sie den Block nicht deaktiviert haben.<br /><br />";
$pgv_lang["mail_option2_help"]			= "Diese standardmäßig eingestellte Option entspricht der Einstellung #pgv_lang[messaging]# mit einer Ergänzung.<br /><br />Zusätzlich wird eine Kopie der Nachricht an die Mail-Adresse geschickt, die Sie angegeben haben.<br /><br />";
$pgv_lang["mail_option3_help"]			= "Mit dieser Option werden Sie die Nachrichten nur per Mail erhalten. Die anderen Benutzer können Sie nicht über das interne Mail System erreichen.<br /><br />";
$pgv_lang["mail_option4_help"]			= "Mit dieser Option werden Sie überhaupt keine Nachrichten erhalten.<br /><br />";

//-- Admin
$pgv_lang["admin_help"]					= "Auf dieser Seite finden Sie alle Links zur Konfigurations-Seiten, Dokumentation und Protokoll-Dateien.<br /><br />Die <b>System-Zeit</b>, direkt unter der Seiten-Überschrift zeigt die Uhrzeit des Servers, auf dem Ihre Seite gehostet ist. Die gezeigte Zeit ist die, bei der Sie die Seite geöffnet oder neu geladen haben.<br /><br /><b>ACHTUNG</b><br />Wenn unterhalb der System-Zeit eine Warnung erscheint, bedeutet das, dass die Datei <b>config.php</b> noch Schreibrechte besitzt! Nachdem Sie Ihre Seite konfiguriert haben, sollten Sie zur <b>Sicherheit</b> die Rechte für diese Datei wieder auf read-only (nur lesen) setzen. Dies müssen Sie <b>manuell</b> tun, da PhpGedView diesen Schritt nicht durchführen kann.#pgv_lang[readme_help]#<br /><br />Außer den Möglichkeiten Readme-Datei, Benutzerhandbuch und Log File, werden Sie weitere Hilfe auf den Seiten finden, die Sie aufrufen.<br /><br />";

//-- User Admin
$pgv_lang["useradmin_help"]				= "~#pgv_lang[user_admin]#~<br />Auf dieser Seite können Sie die vorhandenen Benutzer verwalten und neue anlegen.<br /><br /><b>Liste vorhandener Benutzer</b><br />In dieser Tabelle werden die vorhandenen Benutzer, deren Status und Rechte gezeigt. Sie können Benutzer <b>löschen</b> oder <b>bearbeiten</b>.<br /><br /><b>Neuen Benutzer hinzufügen</b><br />Dieses Formular ähnelt dem Formular «Meine Benutzerdaten». Für viele Punkte gibt es keine speziellen Hilfe-Texte für Verwalter. Dort lesen Sie den Text:";
$pgv_lang["useradmin_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br />Diese ID muss der Verwalter für den Benutzer setzen. Sie identifiziert den Benutzer in der GEDCOM-Datei. Sie legt auch den Zugriff des Benutzers fest für die «Mein Datenblatt» und «Mein Stammbaum» Seiten.<br /><br />Für jede GEDCOM-Datei, die Sie in diesem Programm verwenden, können Sie die ID-Nummer für den Benutzer festlegen. Wenn ein Benutzer in einer Datei nicht genannt wird und daher auch keine ID-Nummer hat, lassen Sie dieses Feld leer.<br /><br />";
$pgv_lang["useradmin_rootid_help"]		= "~#pgv_lang[rootid]#~<br />Für jede GEDCOM-Datei können Sie eine <b>Start-Person</b> je Benutzer festlegen. Wahrscheinlich möchtet der Benutzer das Programm mit seinem eigenen Stammbaum beginnen, aber das ist nicht zwingend.<br /><br />Der Benutzer kann diese Einstellung selbst beliebig ändern.<br /><br />";
$pgv_lang["useradmin_can_admin_help"]	= "~#pgv_lang[can_admin]#~<br />Wenn diese Option angekreuzt ist, hat der Benutzer die gleichen Rechte für das Programm, wie Sie als Verwalter.<dl><dt>D.h. er kann nicht nur:</dt><dd>Benutzer hinzufügen / löschen / bearbeiten</dd><dd>Eine Nachricht an alle Nutzer gleichzeitig senden</dd><dd>Die Begrüßungs-Nachrichten bearbeiten</dd><dd>Sprachdateien bearbeiten und konfigurieren</dd><dt>Sondern auch:</dt><dd>Einen Upgrade des Programmes durchführen</dd><dd>Die Konfiguration ändern</dd><dd>Die GEDCOM-Dateien verwalten</dd><dd>Die Datenschutzeinstellungen ändern</dd><dt>Und vieles andere, was hier nicht genannt ist</dt><dd>Außerhalb dieses Programmes hat er dadurch noch keine weiteren Rechte.</dd></dl>";
$pgv_lang["useradmin_sync_gedcom_help"]	= "~#pgv_lang[sync_gedcom]#<br />Wenn diese Option angekreuzt ist und der Benutzer auch eine ID-Nummer in der Personen-Datenbank hat, werden einige Änderungen in der Personen-Datenbank die diesen Benutzer betreffen auch automatisch in dessen Benutzer-Datensatz übertragen.<br /><br />Wenn Sie in der Personen-Datenbank Einträge wie Mail-Adresse oder Namen ändern, werden diese Änderungen auch automatisch in den Benutzer-Datensatz dieser Person übertragen.  Änderungen an Daten der Benutzer-Datenbank die gemeinsam mit der Personen-Datenbank sind werden auch in die Personen-Datenbank übernommen.<br /><br />";
$pgv_lang["useradmin_can_edit_help"]	= "~#pgv_lang[can_edit]#~<br />Für jede GEDCOM-Datei werden jedem Benutzer bestimmte Zugriffs- und Editier-Rechte zugewiesen.<ul><li>Bei <b>Keine</b> hat der Benutzer keinen Zugriff auf private Daten in der GEDCOM-Datei.</li><li>Bei <b>Zugreifen</b> kann der Benutzer zwar keine Daten ändern und keine Änderungen akzeptieren, aber er kann private Daten sehen.</li><li>Bei <b>Editieren</b> kann der Benutzer Daten ändern, aber ein anderer Benutzer mit dem Recht <b>Akzeptieren</b> muss die Änderungen erst bestätigen, bevor sie in die Datenbank eingetragen werden und veröffentlicht werden.</li><li>Bei <b>Akzeptieren</b> kann der Benutzer sowohl Daten ändern, als auch Änderungen anderer freigeben.</li><li>Bei <b>GEDCOM verwalten</b> kann der Benutzer sowohl Daten ändern, als auch Änderungen anderer freigeben.  Er kann auch die Konfiguration und die Datenschutzeinstellungen dieser GEDCOM-Datei ändern.</li></ul><br />Verwalter haben automatisch das Recht <b>verwalten</b>.<br /><br />";
$pgv_lang["useradmin_verified_help"]	= "~#pgv_lang[verified]#~<br /><b>Selbst-Registrierung</b><br />Ein Benutzer kann einen neuen Benutzerzugang mit Hilfe des <b>Selbst Registrierungs</b> Moduls anlegen.<br /><br />Wenn er dies tut, erhält er eine Mail mit einem Link zur Bestätigung seiner Angaben. Nachdem er diese Anweisung durchgeführt hat, sehen Sie diese Box aktiviert und Sie können mit dem nächsten Schritt fortfahren: <b>Benutzer-Überprüfung durch den Verwalter</b>.<br /><br />Wenn der Benutzer sich noch nicht selbst verifiziert hat, sollten Sie mit Ihrer Überprüfung warten.<br /><br /><b>Benutzer manuell erstellen</b><br />Wenn Sie dieses Formular benutzen um einen Benutzer manuell hinzuzufügen, dann ist diese Option bereits angekreuzt.<br /><br />";
$pgv_lang["useradmin_verbyadmin_help"]	= "~#pgv_lang[verified_by_admin]#~<br />Wenn ein Benutzer sich mit Hilfe des Selbst Registrierungs Moduls angemeldet und bereits selbst verifiziert hat, dann ist der letzte Schritt Ihre Zustimmung, bevor der Benutzerzugang freigeschaltet ist.<br /><br />Nachdem Sie Ihre Zustimmung erteilt haben, erhält der Benutzer eine Mail-Nachricht, dass sein Zugang nun freigegeben ist und dass er sich mit seinem Benutzernamen und Kennwort anmelden kann.<br /><br />";
$pgv_lang["useradmin_edit_user_help"]	= "~#pgv_lang[update_user]#~<br />Dieses Formular dient dem Verwalter zum Ändern der Benutzerdaten.<br /><br />Das Formular ähnelt den Formularen «Benutzer erstellen» und «Meine Benutzerdaten».<br /><br />";
$pgv_lang["useradmin_visibleonline_help"]	= "~ONLINE SICHTABR~<br />Wenn aktiviert, können andere angemeldete Benutzer sehen, wenn diese Person ebenfalls angemeldet ist und umgekehrt. Wenn Sie nicht möchten dass andere Personen sehen wenn Sie angemeldet sind, sollten Sie die Option deaktivieren, dann sehen Sie aber auch nicht mehr andere angemeldete Benutzer.<br /><br />";
$pgv_lang["useradmin_editaccount_help"]	= "~BENUTZERDATEN ÄNDERN~<br />Wenn aktiviert, kann dieser Benutzer seine Benutzerdaten ändern. So können Sie einen einzelnen Benutzer erstellen, der von mehreren Personen verwendet wird, ohne dass diese Personen die Benutzerdaten ändern können.<br /><br />";
$pgv_lang["useradmin_relation_priv_help"]	= "~#pgv_lang[user_relationship_priv]#~<br />Wenn aktiviert, darf der Benutzer Daten lebender Personen nur sehen, wenn er mit ihnen verwandt ist.<br /><br />Die <i>#pgv_lang[user_path_length]#</i> Option bestimmt die Verwandtschafts-Entfernung, innerhalb welcher Daten lebender sichtbar sind.  Datenschutz durch Verwandtschafts-Entfernung kann für alle Benutzer in der Konfiguration der Datenschutz-Datei eingestellt werden.<br /><br />Datenschutz durch Verwandtschafts-Berechnung erfordert dass alle betroffene Benutzer in der Personen-Datenbank eingetragen sind.<br /><br />";
$pgv_lang["useradmin_path_length_help"]	= "~#pgv_lang[user_path_length]#~<br />Wenn die Option <i>#pgv_lang[user_relationship_priv]#</i> aktiviert ist, bestimmt diese Option die maximale Verwandtschafts-Entfernung innerhalb welcher der Benutzer Daten lebender zugreifen kann.<br /><br />";
$pgv_lang["useradmin_auto_accept_help"]	= "~#pgv_lang[user_auto_accept]#~<br />Falls angekreuzt, übernimmt das System automatisch alle von diesem Benutzer vorgenommene Änderungen.  Diese Option ist ohne Bedeutung wenn der Benutzer nur das Recht hat, Daten zu bearbeiten und nicht das Recht, Änderungen zu übernehmen.<br /><br />";

//-- Manage Sites
$pgv_lang["help_managesites"] 			= "~#pgv_lang[title_manage_servers]#~<br />Hier können Sie fremde Seiten hinzufügen.  Sie können auch den Zugriff zu dieser Site von bestimmten IP Adressen verbieten.<br /><br />Fremde Seiten werden hinzugefügt indem Sie Titel und Zugriffsdaten (URL, Datenbank ID, Benutzername, und Kennwort) eingeben.<br /><br />Der Zugriff von bestimmten IP-Adressen kann durch richtiges Eingeben von IP-Adressen verboten werden.  Z.B., <b>212.10.*.*</b>.  Zugriffe zu diesen Seiten wird nur erlaubt wenn die IP-Adresse des anderen Endes nicht in einen der verbotenen IP-Adressen Bereiche enthalten ist.  Sie können auch den Zugriff von bestimmten einzelnen IP-Adressen verbieten.  Z.B., <b>172.252.13.56</b>.<br /><br />";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]			= "~Fremde Seiten hinzufügen~<br />Um eine neue fremde Seite in die Liste einzutragen, müssen Sie den Titel und die Zugriffsdaten (URL, Datenbank-ID, Benutzername, und Kennwort) eingeben.  Falls die fremde Seite anonymen Zugriff erlaubt, müssen Sie die Benutzername und Kennwort Felder leer lassen.<br /><br />";
//-- IP Address Banning
$pgv_lang["help_banning"]				= "~Zugriff von IP-Adressen verbieten~<br />Um den Zugriff von fremden Seiten nach deren IP-Adressen zu verbieten, können Sie hier einzelne IP-Adressen oder einen IP-Adressen Bereich eingeben.  Z.B., <b>172.252.13.56</b> oder <b>212.10.*.*</b>.<br /><br />";
$pgv_lang["help_manual_search_engines"]	= "~Manuelle Suchmaschinen-Identifizierung~<br />PhpGedView liefert Suchmaschinen automatisch kleinere Seiten, mit wenigeren Links.  Die gelieferten Daten sind auf die gesuchte Person und dessen sehr nahe Verwandtschaft beschränkt. Daten über Großeltern oder Enkel werden Suchmaschinen <u>nicht</u> geliefert.  Suchmaschinen können auch nicht auf Berichte, viele Diagramme, und den Jahrestag-Kalender zugreifen.<br /><br />Die meisten Suchmaschinen werden automatisch erkannt.  Falls eine Suchmaschine nicht automatisch erkannt wird und Sie die Datenlieferung beschränken möchten, können Sie hier die IP-Adressen der neuen Suchmaschine eingeben.  Falls Sie den Zugriff der neuen Suchmaschine verbieten möchten, können Sie dessen IP-Adressen in der unten stehenden Liste eintragen.<br /><br />Falls Sie probieren möchten, welche Daten Suchmaschinen geliefert werden, können Sie die IP-Adresse Ihres lokalen Computers hier eingeben. <class 'warning'>Warnung</class> Wenn Sie die IP-Adresse Ihres Computers hier eingeben, können Sie sich <b>nicht mehr</b> als Verwalter anmelden.  Sie müssen sich dann von einem Computer mit anderer IP-Adresse anmelden.  Sie können auch manuell die <i>/index/search_engines.php</i> Datei ändern.<br /><br />Beispiele von IP-Adressen sind <b>212.10.*.*</b> (Adressenbereich) und <b>172.252.13.56</b> (einzelne Adresse).<br /><br />";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]	= "~Suchmaschine entdeckt~<br />PhpGedView liefert Suchmaschinen automatisch kleinere Seiten, mit wenigeren Links.  Die gelieferten Daten sind auf die gesuchte Person und dessen sehr nahe Verwandtschaft beschränkt. Daten über Großeltern oder Enkel werden Suchmaschinen <u>nicht</u> geliefert.  Suchmaschinen können auch nicht auf Berichte, viele Diagramme, und den Jahrestag-Kalender zugreifen.<br /><br />Wenn Suchmaschinen versuchen, solchen Seiten zuzugreifen, erhalten sie diese Fehlermeldung.  Wenn Sie diese Fehlermedung erhalten, glaubt das Programm dass Ihr lokaler Computer eine Suchmaschine betreibt.  Unten sind alle Seiten, die von Suchmaschinen zugreifbar sind, aufgezeichnet.<br /><br />Gewöhnliche Benutzer, die von Suchmaschinen erstellte Links folgen, erhalten normale Seiten und Daten, und nicht diese Fehlermeldung.<br /><br />";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~HINZUFÜGEN oder UPLOAD EINER GEDCOM-DATEI~<dl><dt>Upload einer GEDCOM-Datei</dt><dd>Ein Upload wird online durchgeführt. Sie können von jedem Ort aus Daten hochladen, ohne Hilfe eines FTP-Programmes.</dd><dt>Hinzufügen von GEDCOM-Dateien</dt><dd>Wenn eine Datei in Ihrem GEDCOM-Verzeichnis noch existiert, können Sie sie benutzen, ohne sie erneut hochzuladen. Manchmal wählt man Hinzufügen anstelle von Upload, z.B. wegen der Dateigröße oder Upload-Beschränkungen.</dd></dl>Beide Vorgänge können in vier einfachen Schritten durchgeführt werden.<br />Nur der erste Schritt ist jeweils anders.<br /><br />";
$pgv_lang["gedcom_configfile_help"]		= "~GEDCOM KONFIGURATIONS DATEI~<br />Dies ist die Datei in der alle Grundeinstellungen zur GEDCOM-Datei gespeichert werden.<br /><br />In der Spalte «Konfigurations-Datei» auf der GEDCOM-Verwaltungs-Seite wird der Pfad und der Dateiname dieser Datei gezeigt.<br /><br />";
$pgv_lang["default_gedcom_help"]		= "~STANDARD GEDCOM~<br />Wenn Sie mehr als eine GEDCOM-Datei eingetragen haben, können Sie hier andeuten, welche davon die <b>Standard</b> GEDCOM-Datei für dieses Programm sein soll.<br /><br />Das heißt, dass diese Datei den Besuchern und unangemeldeten Benutzern gezeigt wird.<br /><br />Benutzer können diese Wahl überschreiben, indem sie in ihrem Benutzerprofil eine andere Standard-Datei wählen.<br /><br />";
$pgv_lang["delete_gedcom_help"]			= "~GEDCOM LÖSCHEN~<br />PhpGedView erstellt die Datenbank aus einer vorher hochgeladenen GEDCOM-Datei.  Wenn Sie auf <b>Löschen</b> klicken, entfernt das Programm diese Datensätze aus der Datenbank. Die eigentliche GEDCOM-Datei wird nicht aus dem Verzeichnis, in das sie hochgeladen wurde, gelöscht.<br /><br />Wenn Sie später wieder mit dieser GEDCOM-Datei arbeiten möchten, müssen Sie sie nicht erneut hochladen. Stattdessen können Sie die Option <b>GEDCOM-Datei hinzufügen</b> verwenden.<br /><br />Nachdem Sie «Löschen» geklickt haben, müssen Sie dies in einer Sicherheitsabfrage bestätigen.<br /><br />";
$pgv_lang["add_gedcom_help"]			= "~GEDCOM-DATEI HINZUFÜGEN~<br />Wenn Sie diese Option nutzen, müssen Sie die GEDCOM-Datei bereits mit Hilfe eines externen Programmes, z.B. <b>ftp</b> auf Ihren Server hochgeladen haben. Wenn die GEDCOM-Datei noch nicht auf Ihrem Server besteht, <b>müssen</b> Sie dies erst erledigen, bevor Sie mit dem «Hinzufügen» beginnen.<br /><br />Sie werden Schritt für Schritt durch die Prozedur geführt.<br /><br />";
$pgv_lang["add_new_gedcom_help"]		= "~EINE NEUE GEDCOM-DATEI ERSTELLEN~<br />Sie können eine ganz neue GEDCOM-Datei erstellen.<br /><br />Dazu sind nur wenige Schritte erforderlich. Schritt 1 unterscheidet sich von den bekannten Vorgängen zu upload und hinzufügen. Die übrigen Schritte sind bekannt.<dl><dt>Schritt 1: Benennen Sie die neue GEDCOM-Datei</dt><dd>Geben Sie einen Namen für die neue Datei ohne die Endung '.ged' an. Die Datei wird in dem Verzeichnis angelegt, das oberhalb des Eingabefeldes zu lesen ist. Klicken Sie <b>Hinzufügen</b>.</dd><dt>Schritt 2: Konfigurations Seite.</dt><dd>Dies ist die Seite zur Konfiguration einer GEDCOM-Datei, die Sie schon kennen.</dd><dt>Schritt 3: Überprüfen</dt><dd>Auch dieser Schritt ist schon bekannt. Die neue GEDCOM-Datei wird überprüft und ist höchstwahrscheinlich in Ordnung.</dd><dt>Schritt 4: Datensätze importieren</dt><dd>Da es nur einen einzigen Datensatz zu importieren gibt, wird das sehr schnell gehen.</dd><dt>Erstellung fertig</dt><dd>Sie können nun z.B. das Stammbaum-Diagramm öffnen, um die erste Person Ihrer neuen Datei zu sehen. Klicken Sie den Namen der Person und beginnen Sie mit der Eingabe weiterer Daten. Nun können Sie auch weitere Personen zur ersten Person hinzufügen.</dd></dl>";
$pgv_lang["download_gedcom_help"]		= "~GEDCOM-DATEI HERUNTERLADEN~<br />Sie haben die Möglichkeit eine GEDCOM-Datei von Ihrem Server herunterzuladen.<br /><br />Auf der Seite «Download GEDCOM» haben Sie die Wahl, ob Sie die Datei vom <b>UTF-8</b>-Format in das <b>ANSI (ISO-8859-1)</b>-Format umwandeln möchten. Welches Format Sie benötigen hängt von dem Programm ab, mit dem Sie die heruntergeladene GEDCOM-Datei bearbeiten möchten.<br /><br />Schlagen Sie dazu in der Dokumentation Ihrer Software nach.<br /><br />";
$pgv_lang["edit_gedcoms_help"]			= "~GEDCOM-Verwaltung~<br />Die GEDCOM-Verwaltungs-Seite ist die wichtigste Seite für Einstellungen an <b>vorhandenen</b> und and <b>neuen</b> GEDCOM-Dateien.<br /><dl><b>VORHANDENE GEDCOM-DATEIEN</b><br /><dt>In der <b>Vorhandene GEDCOMs</b> Tabelle haben Sie folgende Optionen:</dt><dd>Löschen</dd><dd>Bearbeiten</dd><dl><dt>Konfiguration der Datenschutzdatei</dt><dd>Die Konfiguration der Datenschutzdatei ist in jede Zeile der Tabelle integriert, weil jede GEDCOM-Datei ihre eigene zugehörige Datenschutzdatei hat.</dd></dl><dd>Standard GEDCOM</dd><dd>GEDCOM-Import</dd><dd>Download</dd><dt>Folgende 3 Spalten enthalten Informationen:</dt><dd>GEDCOM-Datei</dd><dd>GEDCOM-Bezeichnung</dd><dd>Konfigurations-Datei</dd></dl><dl><b>NEUE GEDCOM-DATEIEN</b><dt>Auf dieser Seite haben Sie die folgenden Möglichkeiten, <b>neue</b> oder <b>existierende</b> GEDCOM-Dateien zum System hinzuzufügen.</dt><dd>GEDCOM-Datei hinzufügen</dd><dd>GEDCOM-Upload </dd><dd>Eine neue GEDCOM-Datei erstellen</dd></dl>#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]	= "~GEDCOM-KONFIGURATION BEARBEITEN~<br />Jede GEDCOM-Datei in diesem Programm hat ihre eigene <b>Konfigurations-Datei</b>.<br /><br />In diesem Formular können Sie die Grundeinstellungen vornehmen, wie z.B. Sprache, Kalenderformat, Mail-Optionen usw.<br /><br />";
$pgv_lang["import_gedcom_help"]			= "~GEDCOM-DATEI IMPORTIEREN~<br />In den meisten Fällen ist das Importieren einer GEDCOM-Datei ein einzelner Schritt in einer Prozedur ebenso wie das Hinzufügen oder Hochladen einer GEDCOM-Datei.<br /><br />Diese Schritte bauen aufeinander auf und müssen beendet werden, damit man mit der GEDCOM-Datei arbeiten kann. Wenn Sie diese Prozedur nicht vollständig beenden, sehen Sie eine <b>Warnungs</b>-Meldung, dass die GEDCOM-Datei noch nicht importiert wurde. In diesem Fall klicken Sie das Link zum (wieder)importieren der GEDCOM-Datei.<br /><br /><b>Importieren</b><br /><br />Die Konfiguration der GEDCOM-Datei wird beim Importieren nicht geändert. Die alte Datenbank wird aber überschrieben.<br /><br />";
$pgv_lang["upload_gedcom_help"]			= "~#pgv_lang[upload_gedcom]#~<br />Im Gegenteil zur Funktion «GEDCOM hinzufügen», muss noch keine GEDCOM-Datei auf Ihrem Server bereitliegen.<br /><br />Auf Ihrem lokalen Computer wählen Sie eine GEDCOM-Datei oder eine ZIP-Datei, die eine einzige GEDCOM-Datei enthält. Geben Sie den kompletten Pfad und Dateinamen in das Feld ein oder nutzen Sie den Button <b>Browse</b> auf dieser Seite.<br /><br />Falls eine ZIP-Datei vorliegt, wird die enthaltene GEDCOM-Datei daraus extrahiert.  Die GEDCOM-Datei wird ins <b>#INDEX_DIRECTORY#</b> Verzeichnis übertragen.<br /><br />";
$pgv_lang["validate_gedcom_help"]		= "~GEDCOM-DATEI PRÜFEN~<br />Die Überprüfung der GEDCOM-Datei, die Sie hochladen oder hinzufügen findet im 3. Schritt der Prozedur statt.<br /><br />Das Programm prüft das korrekte Format von Datumsangaben, Ortsangaben, Zeichensatz, usw.<br /><br />Einige Abweichungen kann das Programm selbst korrigieren, z.B. die Zeilenumbrüche von MacIntosh oder falsche Verwendung von Ortsangaben.  In diesen Fällen sehen Sie eine Meldung, dass das Programm die Daten geändert hat.  Bei anderen Abweichungen erhalten Sie eine Warn-Meldung mit einem Lösungsvorschlag.<br /><br />#pgv_lang[more_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]		= "~ANSI NACH UTF-8 KONVERTIEREN~<br />Um sicherzustellen, dass das Programm Ihre GEDCOM-Dateien korrekt behandeln kann, sollten die Dateien im UTF-8-Format gespeichert sein.<br /><br />Viele Genealogie-Programme besitzen eine Option, um Daten im UTF-8-Format zu exportieren.  Falls das Programm, welches Sie benutzen, diese Option nicht anbieten sollte, kann PhpGedView die Konvertierung für Sie übernehmen.<br /><br />Beim Überprüfen der hochgeladenen oder hinzugefügten Dateien, wird PhpGedView feststelllen, ob die Datei im ANSI-Format kodiert ist.<br /><br />";
$pgv_lang["detected_ansi2utf_help"]		= "~ANSI-CODIERUNG ERKANNT~<br />Die überprüfte GEDCOM-Datei hat ANSI-Codierung.<br /<br />Es wird dringend empfohlen, die Codierung auf UTF-8 zu ändern.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			= "~FALSCHES DATUMS-FORMAT ERKANNT:<br />DATUMS-FORMATIERUNG WIRD GEÄNDERT~<br />Das Standard-Datums-Format in PhpGedView ist, entsprechend des <b>GEDCOM 5.5 Standard</b>, DD MMM YYYY (d.h. 01 JAN 2004)<br /><br />Wenn Sie nach der Überprüfung der GEDCOM-Datei eine Meldung erhalten, dass ein falsches Datums-Format erkannt wurde, wird das Programm diese Datumsangaben in diesen Standard konvertieren.<br /><br />Sie können aber wählen zwischen «<b>Tag</b> vor Monat» (DD MMM YYYY) oder «<b>Monat</b> vor Tag» (MMM DD YYYY).<br />Empfohlen ist die erste Einstellung.<br /><br />";
$pgv_lang["change_indi2id_help"]		= "~PERSÖNLICHE ID ÄNDERN IN ...~<br />Dieses Tool wurde erstellt für Benutzer, deren Genealogie Software bei jedem Export andere ID-Nummern für die Personen generiert. D.h. beim ersten Export ist die ID für eine Person I100 aber beim erneuten Export ist die ID der selben Person z.B. I234. Dieses Wechseln der IDs erschwert die Verwaltung in PhpGedView, denn die ID ist die Referenz auf die sich viele Personenangaben beziehen.<br /><br />Die meisten Genealogie-Programme nutzen aber zusätzlich einen RIN oder REFN Bezeichner, um jeder Person eine eindeutige Nummer zuzuordnen, die auch als Referenz verwendet werden kann. Dieses Tool ersetzt alle IDs in der GEDCOM-Datei mit dem Wert aus dem von Ihnen gewünschten Feld (RIN oder REFN).<br /><br />";
$pgv_lang["edit_privacy_help"]			= "Auf dieser Seite können Sie alle Datenschutzeinstellungen für die ausgewählte GEDCOM-Datei vornehmen.<br /><br />Unterhalb der Überschrift können Sie erkennen, ob Sie die richtige Datei bearbeiten.  Der Dateiname wird wie folgt dargestellt: <b>Pfad/NameIhrerGedcomDatei_priv.php</b><br /><br />Wenn Sie weitergehende Einstellungen vornehmen möchten, können Sie auch Änderungen direkt in der Datenschutzdatei vornehmen. Dazu finden Sie weitere Informationen auf der PhpGedView Web Seite.<br /><br />";
$pgv_lang["BOM_detected_help"]			= "~Byte Order Mark (BOM) erkannt~<br />Die GEDCOM-Datei, die Sie importieren möchten, hat ein besonderes 3-stelliges Zeichen am Anfang.  Durch dieses Zeichen erkennen manche Programme dass Dateien im UTF-8 Zeichensatz erstellt sind.<br /><br />Obwohl dieses Zeichen kein Fehler ist, funktioniert PhpGedView nur richtig wenn das Zeichen nicht vorhanden ist.  Sie sollten PhpGedView gestatten, das BOM-Zeichen zu entfernen.<br /><br />";
$pgv_lang["invalid_header_help"]		= "~UNGÜLTIGER GEDCOM HEADER~<br />Eine GEDCOM-Datei muss in der ersten Zeile folgendermaßen beginnen: 0&nbsp;HEAD. PhpGedView hat erkannt, dass Ihre GEDCOM-Datei in der ersten Zeile anders beginnt. Wenn Sie den Korrigieren-Button klicken, werden alle Zeile vor der ersten «0&nbsp;HEAD»-Zeile entfernt.<br /><br />Dieser Fehler bedeutet meistens, dass das von Ihnen verwendete Programm die Datei nicht ordnungsgemäß erstellt hat oder dass es sich nicht um eine GEDCOM-Datei handelt. Sie sollten überprüfen, ob Sie die richtige Datei hochgeladen haben und ob sie mit der Zeile «0&nbsp;HEAD» beginnt und mit der Zeile «0&nbsp;TRLR» endet.<br /><br />";
$pgv_lang["macfile_detected_help"]		= "~MACINTOSH DATEI ERKANNT~<br />PhpGedView hat erkannt, dass Ihre GEDCOM-Datei auf einem Macintosh Computer erstellt wurde.<br /><br /Macintosh-Dateien enthalten andere Zeilenumbrüche als die in in Unix oder Windows erstellten. Die PHP-Funktionen, die PhpGedView benutzt, verlangen das Unix- oder Windows-Format. Wenn Sie auf «Korrigieren» klicken, wird Ihre Datei in eine Windows-Datei umgewandelt.<br /><br />";
$pgv_lang["cleanup_places_help"]		= "~ORTE KORRIGIEREN~<br />PhpGedView hat erkannt, dass Ihre GEDCOM-Datei Ortsangaben zu GEDCOM-Daten macht, die keine Ortsangaben zulassen.<br /><br /Manche Genealogie-Programme, z.B. Family Tree Maker, erstellen solche GEDCOM-Dateien. PhpGedView funktioniert zwar mit solchen Dateien, aber es tauchen einige ungültige Orte in der Ortsliste auf.<br /><br />Beipiel: Ihre GEDCOM-Datei enthält folgende Zeilen<br />1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Architekt<br /><br />Nach den geltenden GEDCOM Regeln sollte dies eigentlich wie folgt notiert sein<br />1 SSN 123-45-6789<br />1 OCCU Architekt<br /><br />Wenn Sie diese Option auf <b>#pgv_lang[yes]#</b> setzen, wird PhpGedView automatisch solche Fehler korrigieren.<br /><br />";
$pgv_lang["empty_lines_detected_help"]	= "~LEERE ZEILEN ERKANNT~<br />PhpGedView hat erkannt, dass in Ihrer GEDCOM-Datei Leerzeilen enthalten sind. Diese Zeilen können zu Fehlern führen und werden vor dem Import aus der Datei entfernt.<br /><br />";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~PhpGedView KONFIGURIEREN~<br />Auf dieser Seite werden die Grundeinstellungen des Programmes vorgenommen, nachdem PhpGedView neu auf Ihrem Server installiert wurde und zum ersten Mal gestartet wird.<br /><br />#pgv_lang[review_readme]#Da diese <b>Grund</b>einstellungen sind, gelten sie für das gesamte Programm und für alle Datenbanken, die Sie darin benutzen.<br /><br />Für jede Datenbank können Sie zusätzlich noch jeweils eigene Einstellungen festlegen. Auf diser Konfigurations-Seite können Sie auch das Link zur GEDCOM-Verwaltung direkt über der Tabelle klicken. Normalerweise finden Sie dieses Link im Menü «Mein GedView Portal».<br /><br />";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br />Hier können Sie zwei Datensätze der selben GEDCOM Datei zusammenfügen.  Das kann nützlich sein, wenn Sie GEDCOM-Dateien zusammengefügt haben, und deshalb jetzt mehrere Datensätze für die selben Personen, Familien, Quellen, oder Archive haben.<br /><br />Das Verfahren besteht aus drei Schritten.<br /><ol><li>Sie geben zwei ID-Nummern des <u>gleichen</u> Typs ein.  Sie können nicht, zum Beispiel, Personen und Familien oder Familien und Quellen zusammenfügen.<br />Ins <b>#pgv_lang[merge_to]#</b> Feld geben Sie die gewünschte ID-Nummer des Ausgangs-Datensatzes.<br />Ins <b>#pgv_lang[merge_from]#</b> Feld geben Sie die ID-Nummer des Datensatzes dessen Informationen mit den Informationen des #pgv_lang[merge_to]# (Ausgangs) Datensatzes zusammengefügt werden sollen. Am Ende des Verfahrens wird dieser Datensatz gelöscht.</li><li>Für jedes Datum aus beiden Datensätzen wählen Sie durch ankreuzen ob es in den Ausgangs-Datensatz übernommen werden soll oder nicht.</li><li>Genau wie alle anderen Änderungen verifizieren Sie das Resultat.</li></ol>Jemand der genügend Rechte hat, Änderungen in die Datenbank zu übernehmen, muss noch Ihre zusammengefügte Datensätze kontrollieren, bevor sie endgültig in die Datenbank übernommen werden.<br /><br />";

//-- report engine
$pgv_lang["help_reportengine.php"]		= "~Berichte~<br />Die Erstellungsmaschine für Berichte benutzt XML (E<b>x</b>tended <b>M</b>arkup <b>L</b>anguage) Vorlagen um bestimmte Berichte automatisch zu erstellen.  Die erstellten Berichte können als Dateien im PDF-Format für späteres Lesen oder Drucken heruntergeladen werden.<br /><br />Die <b>#pgv_lang[select_report]#</b> Liste, die alle erhältlichen Berichte aufzählt, wird aus dem Inhalt des <i>reports</i> Verzeichnisses erstellt.  Sie können das Programm durch Ihre eigenen Berichte ergänzen, indem Sie eine der vorhandenen Vorlagen kopieren und dann nach Ihren Bedürfnissen ändern.  Um diesen neuen Bericht dem Programm bekannt zu geben, muss die XML-Vorlage richtig benannt werden (z.B. <i>MeinBericht.xml</i>) und im <i>reports</i> Verzeichnis zu finden sein.  Wenn Sie dann die Datei <i>reports.dat</i> aus dem <i>index</i> Verzeichnis löschen, erkennt PhpGedView dass eine neue #pgv_lang[select_report]# Liste erstellt werden muss.<br /><br />";
$pgv_lang["def_pdf_format_help"]		= "~Dateien im PDF-Format~<br />PhpGedView erstellt Berichte als Dateien im Adobe&reg; PDF-Format, die Sie nach dem Erstellen auf Ihren lokalen Computer übertragen können.  Der GEDCOM 5.5.1 Standard, der anderswo in diesem Hilfe-System erwähnt ist, kann ebenfalls als PDF-Datei übertragen werden. PDF ist ein Akronym von <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat (tragbares Dokument Format).<br /><br />Die meisten Programme können PDF-Dateien nicht lesen.  Falls Sie schon das Programm <i>Adobe&reg; Acrobat Reader</i> installiert haben, können Sie mit diesem die von PhpGedView erstellten PDF-Dateien lesen und drucken;  es ist nicht notwending das Programm wegen PhpGedView zu aktualisieren.<br /><br />Sie können das Acrobat&reg; Reader Programm gratis von der <a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Adobe Systems Inc.</b></a> Seite übertragen. Es ist möglich, dass Sie das Programm auch anderswo zum Herunterladen finden, aber Ihnen wird strengstens geraten, <u>nur</u> der Adobe Systems Inc. Seite zu vertrauen.<br /><br />Acrobat Reader ist in vielen Sprachen, für viele verschiedene Betriebssysteme erhältlich, inklusiv Microsoft&reg; Windows und Apple&reg; Macintosh.  Falls Sie noch Windows 95 betreiben, sollten Sie darauf achten, die Version 5.0.5 zu installieren.  Neuere Versionen lassen sich nicht richtig auf Windows 95 Systemen installieren.<br /><br /><a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Acrobat Reader von hier übertragen</b></a><br /><br />";
$pgv_lang["help_ahnentafel.xml"]		= "~#pgv_lang[ahnentafel_report]#~<br />Dies ist ein Bericht über die gewählte Person und seine Vorfahren, als Broschüre gedruckt.  Der Bericht beginnt mit der gewählten Startperson.  Seine Eltern, Großeltern, usw. folgen.<br /><br />Bitte beachten Sie dass der #pgv_lang[ahnentafel_report]# nur in der englischen Sprache erstellt werden kann.<br /><br />";
$pgv_lang["help_birthlist.xml"]			= "~#pgv_lang[birth_report]#~<br />In diesem Bericht können Sie all Personen aufzählen, die an einem bestimmten Datum oder in einem bestimmten Ort geboren wurden.<br /><br />";
$pgv_lang["help_relativelist.xml"]		= "~#pgv_lang[relatives_report]#~<br />Dieser Bericht zählt alle Verwandte der gewünschten Startperson auf.  Sie können bestimmen, welche Verwandte aufgezählt werden sollen.<ul><li><b>#pgv_lang[child-family]#</b> zeigt die Startperson, seine Eltern, und seine Geschwister.</li><li><b>#pgv_lang[spouse-family]#</b> zeigt die Startperson, seine Ehepartner, und seine Kinder.</li><li><b>#pgv_lang[direct-ancestors]#</b> zeigt die Startperson und alle seine Vorfahren (seine Eltern, seine Großeltern, seine Urgroßeltern, usw.) bis zum Anfang des Stammbaumes.</li><li><b>#pgv_lang[ancestors]#</b> zeigt nicht nur alle Personen der #pgv_lang[direct-ancestors]# Liste sondern auch Geschwister der Eltern (Tanten und Onkel), Großeltern (Großtanten, Großonkel), usw. Kinder dieser Geschwister (Cousinen) werden nicht aufgezählt.</li><li><b>#pgv_lang[descendants]#</b> zeigt alle Nachfahren der Startperson (Kinder, Enkel, Urenkel, usw.)</li><li><b>#pgv_lang[all]#</b> Diese Option ist eine Mischung der #pgv_lang[descendants]# und #pgv_lang[ancestors]# Optionen in einem Bericht.</li></ul><br /><br />";
$pgv_lang["help_xml_reports"]			= "~Bericht Erstellungsmaschine~<br />Die Erstellungsmaschine für Berichte benutzt XML (E<b>x</b>tended <b>M</b>arkup <b>L</b>anguage) Vorlagen um bestimmte Berichte automatisch zu erstellen.  Die erstellten Berichte können als Dateien im PDF-Format für späteres Lesen oder Drucken heruntergeladen werden.<br /><br />Die <b>#pgv_lang[select_report]#</b> Liste, die alle erhältliche Berichte aufzählt, wird aus dem Inhalt des <i>reports</i> Verzeichnisses erstellt.  Sie können das Programm durch Ihre eigenen Berichte ergänzen, indem Sie eine der vorhandenen Vorlagen kopieren und dann nach Ihren Bedürfnissen ändern.  Um diesen neuen Bericht dem Programm bekannt zu geben, muss die XML-Vorlage richtig benannt werden (z.B. <i>MeinBericht.xml</i>) und im <i>reports</i> Verzeichnis zu finden sein.  Wenn Sie dann die Datei <i>reports.dat</i> aus dem <i>index</i> Verzeichnis löschen, erkennt PhpGedView dass eine neue #pgv_lang[select_report]# Liste erstellt werden muss.<br /><br />";

//-- Help Contents
$pgv_lang["help_contents_head_help"]	= "<b>INHALT HILFE</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]	= "GEDCOM-Informationen";
$pgv_lang["help_contents_gedcom_places"]	= "Orte in der GEDCOM-Datei";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>HILFE INHALT<br /><br />HILFE FÜR VERWALTER</b> wurde der Liste vorangestellt.<br /><br />";
// $pgv_lang["ah1_help"]				= "_Upgrade";
$pgv_lang["ah2_help"]					= "_PhpGedView konfigurieren";
$pgv_lang["ah3_help"]					= "_GEDCOM: Hinzufügen oder Upload";
$pgv_lang["ah4_help"]					= "_GEDCOM: Konfigurations-Datei";
$pgv_lang["ah5_help"]					= "_GEDCOM: Standard";
$pgv_lang["ah6_help"]					= "_GEDCOM: Löschen";
$pgv_lang["ah7_help"]					= "_GEDCOM: Hinzufügen";
$pgv_lang["ah8_help"]					= "_GEDCOM: neue GEDCOM-Datei erstellen";
$pgv_lang["ah9_help"]					= "_GEDCOM: Herunterladen";
$pgv_lang["ah10_help"]					= "_GEDCOM: Verwaltung";
$pgv_lang["ah11_help"]					= "_GEDCOM: Konfiguration bearbeiten";
$pgv_lang["ah12_help"]					= "_GEDCOM: Importieren";
$pgv_lang["ah13_help"]					= "_GEDCOM: Hochladen (Upload)";
$pgv_lang["ah14_help"]					= "_GEDCOM: Prüfen";
$pgv_lang["ah15_help"]					= "_GEDCOM: ANSI nach UTF-8 konvertieren";
$pgv_lang["ah16_help"]					= "_GEDCOM: Datenschutz-Datei konfigurieren";
$pgv_lang["ah17_help"]					= "_Benutzer-Verwaltung";
$pgv_lang["ah18_help"]					= "_Verwaltung";
$pgv_lang["ah19_help"]					= "_GEDCOM: Multimedia-Tool";
$pgv_lang["ah20_help"]					= "_GEDCOM: Persönliche ID ändern in ...";
$pgv_lang["ah21_help"]					= "_Sprach-Dateien";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]					= "_Unterstützte Sprachen konfigurieren";
$pgv_lang["ah24_help"]					= "_Benutzer-Informationen übertragen (Index -->> SQL)";
$pgv_lang["ah25_help"]					= "_PhpGedView Sicherheits-Kopie";
$pgv_lang["ah26_help"]					= "_Häufig gestellte Fragen (FAQ) Liste: Bearbeiten";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"]	= "~Statistiken-Diagramm~<br /><br />Diese Seite zeigt Ihnen das Diagramm der Statistiken, die entsprechend den Eingaben der vorigen Seite aus der Datenbank aufgerufen wurden.<br /><br />";
$pgv_lang["help_statistics.php"]		= "~Statistiken-Diagramm~<br /><br />Auf dieser Seite bestimmen Sie die Statistiken die als Diagramm aus der Datenbank aufgerufen werden sollen.<br /><br />";
$pgv_lang["stat_help"]					= "~Optionen der Statistiken-Diagramme~<br /><br />Verschiedene Statistiken der Datenbank können durch Eingaben auf dieser Seite als Diagramm aufgerufen werden.<br /><br />Sie wählen das gewünschte Diagramm, und dann noch weitere Optionen.<br /><br />Die Zahlen, die in den Diagrammen gezeigt werden, hängen von den Eingabedaten ab.  Zum Beispiel, Personen von denen nur das Geburtsjahr bekannt ist, können im Geburtsmonat-Diagramm nicht gezählt werden.<br /><br />";
$pgv_lang["stat_help_x"]				= "~Optionen der Statistiken-Diagramme~<br /><br />~X Achse~<br />Folgende Optionen sind für die X Achse (horizontal) gültig.  Das Diagramm wird dann durch weitere Optionen der Y und Z Achsen angefertigt.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;Anzahl der Geburten, pro Geburtsmonat.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;Anzahl der Tode, pro Sterbemonat.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;Anzahl der Ehen, pro Ehemonat.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;Anzahl der Erstgeborenen, pro Geburtsmonat.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;Anzahl der ersten Ehen, pro Ehemonat.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;Monate zwischen Eheschließung und Geburt des ersten Kindes dieses Paares.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;Todesalter, mit Geburtsjahr verglichen.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;Todesalter, mit Sterbejahr verglichen.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;Alter, mit Ehejahr verglichen.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;Alter, mit Jahr der ersten Ehe verglichen.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;Durchschnittliche Familiengröße.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;Anzahl der Personen, pro Land.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;Geburtsland.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;Eheland.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;Sterbeland.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;Kreisdiagramm der Personen mit Quellen.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;Kreisdiagramm der Familien mit Quellen.</p><br /><br />";
$pgv_lang["stat_help_y"]				= "~Optionen der Statistiken-Diagramme~<br /><br />~Y Achse~<br />Folgende Optionen sind für die Y Achse (vertikal) gültig.  Diese Optionen beeinflussen die Präsentation der für die X Achse gewählten Daten.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;zeigt die Anzahl der von der X Achse bestimmten Personen, Familien, usw.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;zeigt die Prozentzahl der von der X Achse bestimmten Personen, Familien, usw.</p>";
$pgv_lang["stat_help_z"]				= "~Optionen der Statistiken-Diagramme~<br /><br />~Z Achse~<br />Folgende Optionen sind für die Z Achse gültig.  Sie unterteilen die für die X Achse gewählten Kategorien.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;Keine Unterteilung.  Alle Daten der X Achse sind jeweils in einer Spalte dargestellt.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;Die Daten sind nach Geschlecht unterteilt und dann in zwei Spalten dargestellt.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;Die Daten sind in mehrere Bereiche unterteilt und dann in entsprechenden Spalten dargestellt.</p>";
$pgv_lang["stat_help_gwx"]				= "~Optionen der Statistiken-Diagramme~<br /><br />~Bereichsgrenzen der X Achse~<br />Sie können unter verschiedenen Bereichsgrenzen wählen.<br /><br />Zum Beispiel, die Wahl <b>#pgv_lang[aft_marr]#</b> bedeutet folgende Monatsbereiche:<div style=\"padding-left:30px;\">vor der Ehe<br />bis zu 8 Monate nach der Ehe<br />zwischen 8 und 12 Monate nach der Ehe<br />zwischen 12 und 15 Monate nach der Ehe<br />zwischen 15 und 18 Monate nach der Ehe<br />zwischen 18 und 24 Monate nach der Ehe<br />zwischen 24 und 48 Monate nach der Ehe<br />über 48 Monate nach der Ehe</div><br /><br />Wenn Sie Quartale zeigen möchten, müssen Sie <b>Quartale</b> wählen.<br /><br />";
$pgv_lang["stat_help_gax"]				= "~Optionen der Statistiken-Diagramme~<br /><br />~Bereichsgrenzen der X Achse~<br />Sie können unter verschiedenen Bereichsgrenzen wählen.<br /><br />Zum Beispiel, die Wahl <b>Spanne 10 Jahre</b> bedeutet folgende Altersbereiche:<div style=\"padding-left:30px;\">weniger als 1 Jahr alt<br />1 bis 5 Jahre<br />5 bis 10<br />10 bis 20<br />20 bis 30<br />30 bis 40<br />40 bis 50<br />50 bis 60<br />60 bis 70<br />70 bis 80<br />80 bis 90<br />90 bis 100<br />mehr als 100 Jahre alt</div><br /><br />";
$pgv_lang["stat_help_gbx"]				= "~Optionen der Statistiken-Diagramme~<br /><br />~Bereichsgrenzen der X Achse~<br />Sie können unter verschiedenen Bereichsgrenzen wählen.<br /><br />Zum Beispiel, die Wahl <b>Spanne 2 Jahre</b> bedeutet folgende Altersbereiche:<div style=\"padding-left:30px;\">weniger als 16 Jahre alt<br />16 bis 18<br />20 bis 22<br />22 bis 24<br />24 bis 28<br />28 bis 30<br />30 bis 32<br />32 bis 35<br />35 bis 40<br />40 bis 50<br />mehr als 50 Jahre alt</div><br /><br />";
$pgv_lang["stat_help_gcx"]				= "~Optionen des Statistiken-Diagrammes~<br /><br />~Bereichsgrenzen der X Achse~<br />Bitte wählen Sie einen Anzahlabstand.<br /><br />Zum Beispiel, die Wahl <b>Spanne: 1 Kind</b> bedeutet folgende Anzahlbereiche:<div style=\"padding-left:30px;\">kinderlos<br />ein Kind<br />zwei Kinder<br />3, 4, 5, 6, 7, 8, 9, 10 Kinder<br />mehr als 10 Kinder</div><br /><br />";
$pgv_lang["stat_help_gwz"]				= "~Optionen der Statistiken-Diagramme~<br /><br />~Bereichsgrenzen der Z Achse~<br />Sie können unter verschiedenen Bereichsgrenzen wählen.<br /><br />Zum Beispiel, die Wahl <b>von 1700 Spanne 50 Jahre</b> bedeutet folgende Jahresbereiche:<div style=\"padding-left:30px;\">vor 1700<br />zwischen 1700 und 1749<br />zwischen 1750 und 1799<br />zwischen 1800 und 1849<br />zwischen 1850 und 1899<br />zwischen 1900 und 1949<br />zwischen 1950 und 1999<br />2000 oder später</div><br /><br />";
$pgv_lang["chart_type_help"]			= "~Optionen der Statistiken-Diagramme~<br /><br />Ihre Wahl wird auf einer Landkarte gezeigt.  Sie haben folgende Optionen zur Wahl:<p style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;Zeigt, in welchen Ländern Personen dieser Datenbank vorkommen.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;Zeigt, in welchen Ländern Personen mit dem gewählten Nachnamen vorkommen.</p><br /><br />";
$pgv_lang["google_chart_surname_help"]	= "~Optionen der Statistiken-Diagramme~<br /><br />Die Anzahl des gewählten Nachnamens wird auf einer Landkarte gezeigt.  Das leere Feld bedeutet, dass der häufigst vorkommende Nachname benutzt werden soll.<br /><br />";
$pgv_lang["chart_area_help"]			= "~Optionen der Statistiken-Diagramme~<br /><br />Sie können folgende Landkarten wählen:<p style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;Alle Kontinente.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;Europa.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;Süd Amerika.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;Asien.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;Naher Osten.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;Afrika.</p><br /><br />";

//-- Find Media Help
$pgv_lang["manage_media_help"]			= "~#pgv_lang[manage_media]#~<br />Auf dieser Seite können Sie Ihre Medien-Dateien und Medien-Verzeichnisse leicht verwalten.<br /><br />Wenn Sie neue Medien-Unterverzeichnisse erstellen, sorgt das Programm dafür, dass die gleiche Struktur auch im <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b> Verzeichnis erstellt wird.  Wenn Sie neue Bilder auf den Server übertragen, kann PhpGedView die Miniaturbilder automatisch erstellen.<br /><br />Neben jedem Bild in der Medien-Liste finden Sie folgende Optionen.  Welche Optionen vorhanden sind hängt vom aktuellen Status der jeweiligen Medien-Datei ab.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;Wenn Sie diese Option klicken, erhalten Sie ein Formular worin Sie den Titel der Datei ändern können.  Falls die Datei noch nicht mit einer Person, Familie, oder Quelle der aktuellen Datenbank verbunden ist, können Sie das hier tun.  Sie können auch den Dateinamen ändern oder sogar die Datei in ein anderes Verzeichnis verlegen.  Wenn notwendig, erstellt PhpGedView fehlende Verzeichnisse oder Miniaturbilder.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;Diese Option ist nur sichtbar wenn sie vom Verwalter erlaubt ist.  Sie können die GEDCOM Rohdaten, die dieses Medien-Objekt betreffen, sehen und bearbeiten.  Sie sollten sehr vorsichtig sein wenn Sie diese Option benutzen.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;Mit dieser Option können Sie alle Kenntnisse über diese Medien-Datei aus der aktuellen Datenbank entfernen.  Andere vorhandene Datenbanken werden nicht geändert.  Wenn diese Datei in keiner anderen Datenbank erwähnt ist, wird sie, sowie dessen Miniaturbild, entfernt.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;Diese Option entfernt alle Kenntnisse über diese Medien-Datei aus der aktuellen Datenbank.  Die Medien-Datei wird nicht gelöscht.  Andere vorhandene Datenbanken werden nicht geändert.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;Mit dieser Option können Sie alle Verbindungen zu diesem Medien-Objekt in der aktuellen Datenbank löschen.  Die Datei wird nicht entfernt, und das Medien-Objekt, mit dem diese Datei in der aktuellen Datenbank bekannt ist, wird auch nicht entfernt.  Andere vorhandene Datenbanken werden nicht geändert.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;Diese Option lässt Sie Verbindungen zwischen dieser Medien-Datei und Personen, Familien, oder Quellen der aktuellen Datenbank erstellen.  Wenn notwending, erstellt das Programm auch das Medien-Objekt, mit dem die Datei in der Datenbank bekannt ist.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;Wenn Sie diese Option wählen, erstellt PhpGedView das fehlende Miniaturbild.</li></ul><br /><br />";
$pgv_lang["simple_filter_help"]			= "~#pgv_lang[filter]#~<br />Ein einfacher Filter.  Die Medien-Liste wird nach Ihrer genauen Eingabe durchsucht.  Die <b>?</b> und <b>*</b> Zeichen haben keine besondere Bedeutung.<br /><br />";
$pgv_lang["show_thumb_help"]			= "~#pgv_lang[show_thumbnail]#~<br />Falls angekreuzt, werden vorhandene Miniaturbilder in der Liste gezeigt.<br /><br />";
$pgv_lang["new_dir_help"]				= "~#pgv_lang[add_directory]#~<br />Als Verwalter können Sie Unterverzeichnisse erstellen wie Sie möchten.  So können Sie leichter die Medien-Dateien verwalten.  Das Programm sorgt dafür, dass die gleiche Struktur im <b>#GLOBALS[MEDIA_DIRECTORY]#/thumbs</b> Verzeichnis vorhanden ist.  Wenn ein neues Verzeichnis erstellt wird, sorgt das Programm auch dafür, dass die richtige <i>index.php</i> Datei, entsprechend dem neuen Verzeichnis, sofort darin erstellt wird.<br /><br />Wenn Sie dieses Link klicken, können Sie den neuen Verzeichnisnamen eingeben.<br /><br />";
$pgv_lang["find_media_help"]			= "~#pgv_lang[find_media]#~<br />Mit dieser Option können Sie alle Medien-Verzeichnisse nach der gewünschten Datei, mit der Sie eine Verbindung erstellen möchten, durchsuchen.<br /><br />";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]			= "~Link ID~<br />Jedes Medien-Objekt soll mit mindestens einer Person, Familie, oder Quelle Ihrer Datenbank verbunden sein.<br /><br />Um solche Verbindung herzustellen, können Sie die Datenbank nach der ID-Nummer der gewünschten Person, Familie, oder Quelle zur gleichen Zeit durchsuchen, als Sie das Medien-Objekt erstellen.<br /><br />Es ist nicht nötig die Verbindungen sofort herzustellen.  Sie können das jederzeit durch das Betätigen des <b>#pgv_lang[edit]#</b> oder <b>#pgv_lang[set_link]#</b> Links der <b>#pgv_lang[manage_media]#</b> Seite oder des <b>#pgv_lang[add_media_lbl]#</b> Links der Personen-, Familien-, oder Quellen-Informationsseiten tun.<br /><br />";
$pgv_lang["upload_server_file_help"]	= "~#pgv_lang[server_file]#~<br />Die Medien-Datei, die Sie auf den Server übertragen möchten, sollte dort anders benannt sein als auf Ihrem lokalen Computer.  Bedenken Sie, dass Dateinamen, die für Sie sinnvoll sind, anderen weniger Sinn haben können.  Es ist auch durchaus möglich, dass Sie und andere zur gleichen Zeit verschiedene Bilder mit dem gleichen Namen (z.B., «oma.jpg») hochladen möchten.<br /><br />In diesem Feld geben Sie den Namen, mit dem die übertragene Datei, und auch dessen automatisch erstelltes Miniaturbild, auf dem Server benannt werden soll.  Ihre Eingabe des Namenszusatzes (jpg, gif, pdf, doc, usw.) wird nicht beachtet.  Das Programm benutzt immer den ursprünglichen Namenszusatz der hochgeladenen Datei.<br /><br />Wenn Sie dieses Feld leer lassen, erhält die hochgeladene Datei ihren ursprünglichen Namen.<br /><br />";
$pgv_lang["upload_server_folder_help"]	= "~#pgv_lang[server_folder]#~<br />Der Verwalter hat bis zu #GLOBALS[MEDIA_DIRECTORY_LEVELS]# Verzeichnisebenen unter dem Standard-Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#</b> erlaubt.  Das erleichtert das Verwalten der Medien-Dateien, und mindert die Möglichkeit von Namenskonflikten.<br /><br />In diesem Feld wählen Sie das Zielverzeichnis der zu übertragenden Datei.  Das dazugehörende Miniaturbild, entweder automatisch erstellt oder separat hochgeladen, wird in der gleichen Struktur, angefangen im <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> anstatt dem <b>#GLOBALS[MEDIA_DIRECTORY]#</b> Verzeichnis, gespeichert. Es ist nicht notwendig, den <b>#GLOBALS[MEDIA_DIRECTORY]#</b> Teil des Zielverzeichnisses einzugeben.<br /><br />Falls Sie sich nicht über diese Eingabe sicher sind, sollten Sie sich an den Verwalter wenden.<br /><br />";
$pgv_lang["view_server_folder_help"]	= "~#pgv_lang[server_folder]#~<br />Der Verwalter hat bis zu #GLOBALS[MEDIA_DIRECTORY_LEVELS]# Verzeichnisebenen unter dem Standard-Verzeichnis <b>#GLOBALS[MEDIA_DIRECTORY]#</b> erlaubt.  Das erleichtert das Verwalten der Medien-Dateien, und mindert die Möglichkeit von Namenskonflikten.<br /><br />Hier wählen Sie das Medien-Verzeichnis dessen Inhalt Sie sehen möchten.  Wenn Sie <b>#pgv_lang[all]#</b> wählen, wird der Inhalt aller Medien-Verzeichnisse gezeigt.  So erhalten Sie unter Umständen eine sehr lange Liste.<br /><br />";

//--Repository Help
$pgv_lang["help_repolist.php"]			= "~#pgv_lang[repo_list]#~<br />Diese Seite zeigt Ihnen die Achivenliste.<br /><br /><b>ARCHIVE</b><br />Ohne Archive ist es unmöglich, die Datenbank zu erstellen.  Quellen existieren für alle Daten, und Quellen sind immer in Archiven aufbewahrt.  Solche Quellen-Lagerorte könnten persönliche Archive, öffentliche Datenbanken, kirchliche oder behördliche Archive, Internet-zugängliche Datenbanken, usw. sein.  Um Quellen später wieder zu finden, müssen genaue Kenntnisse über deren Lagerorte vorhanden sein.  Diese Informationen sind immer in Archiv-Datensätzen eingetragen.<br /><br />Jeder Archiv-Datensatz kann mit mehreren Quellen verbunden sein.<br /><br />";
$pgv_lang["help_repo.php"]				= "~#pgv_lang[repo_info]#~<br />Einzelheiten über das Archiv sind hier aufgezeichnet.  Quellen und deren Lagerorte (Archive) sind für Ahnenforscher sehr wichtig.  Wenn Sie genaue Kenntnisse über eine Quelle und dessen Lagerort haben, können Sie jederzeit dem Pfad anderer Ahnenforscher zu den Informationen folgen.  So können Sie, oder andere, immer die Informationen bestätigen.<br /><br />Diese Seite zeichnet Informationen wie Titel, Post-, Mail-, und Internet-Adressen auf.<br /><br />Unter diesen Informationen sehen Sie noch eine Liste aller Quellen die mit diesem Archiv verbunden sind.  So können Sie leicht feststellen, welche Informationen der Datenbank in diesem Lagerort zu finden sind.<br /><br />Falls vom Verwalter erlaubt, sehen Sie noch folgende Links:<ul><li><b>#pgv_lang[view_gedcom]#</b> wodurch Sie die Einzelheiten dieses Archivs im GEDCOM Rohformat sehen können.  Diese Option ist für die meisten Fälle nicht sehr nützlich.</li><li><b>#pgv_lang[add_to_cart]#</b> wodurch Sie diesen Archiv-Datensatz dem #pgv_lang[clip_cart]# hinzufügen können. Der #pgv_lang[clip_cart]#-Inhalt kann auf Ihren lokalen Computer im GEDCOM-Format übertragen werden, für späteres Bearbeiten von anderen Programmen.</li></ul><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br />Wenn Sie dieses Link klicken, wird das Archiv zum Löschen markiert.<br /><br />Was bedeutet das?<br />Angenommen Sie möchten aus irgendeinem Grund ein Archiv löschen. Klicken Sie das Link, dann erscheint eine Sicherheitsabfrage zum Löschen oder Abbrechen.<br /><br />Wenn Sie mit dem Löschen fortfahren, kann es einige Zeit dauern, bis eine Bestätigungs-Nachricht erscheint.<br /><br />Bei näherem Betrachten werden Sie aber feststellen, dass das Archiv weiterhin sichtbar ist und wie zuvor ausgewählt werden kann.<br /><br />Dies ist <b>kein</b> Fehler.<br />Der Verwalter wird eine Nachricht bekommen, dass Änderungen an der Datenbank erwünscht sind, und dass Sie das Archiv gelöscht haben. Der Verwalter kann Ihre Änderung in die Datenbank übernehmen oder sie ablehnen. Erst danach ist das Archiv unwiderruflich gelöscht. Im Zweifelsfall wird der Verwalter Sie kontaktieren.<br /><br />";
$pgv_lang["show_repo_gedcom_help"]		= "~#pgv_lang[view_gedcom]#~<br />Diese Option zeigt Ihnen, im GEDCOM Rohformat, alle Informationen über dieses Archiv.  Für die meisten Fälle ist diese Option wahrscheinlich nicht sehr nützlich.<br /><br />";
$pgv_lang["add_repository_clip_help"]	= "~#pgv_lang[add_to_cart]#~<br />Mit dieser Option können Sie alle Einzelheiten dieses Archivs dem #pgv_lang[clip_cart]# hinzufügen. Der #pgv_lang[clip_cart]#-Inhalt kann im GEDCOM-Format auf Ihren lokalen Computer übertragen werden, für späteres Bearbeiten von anderen Programmen.<br /><br />";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br />Diese Liste zeigt Ihnen alle in der Datenbank eingetragene Archive.<br /><br />Wenn Sie auf einen der Archivnamen klicken, erhalten Sie die #pgv_lang[repo_info]# Seite, wo alle mit diesem Archiv verbundene Quellen gezeigt werden.<br /><br />";
$pgv_lang["repos_listbox_help"]			= "~#pgv_lang[other_repo_records]#~<br />Hier werden alle mit diesem Archiv verbundene Quellen gezeigt.<br /><br />Wenn Sie auf einen der Quellennamen klicken, gelangen Sie auf eine Seite, wo Ihnen Einzelheiten über diese Quelle gezeigt werden.<br /><br />";

// Index-Edit
$pgv_lang["block_move_up_help"]			= "~Reihenfolge ändern~<br />Mit diesen Buttons können Sie die Reihenfolge der Blöcke ändern.  Die Blöcke werden auf der Startseite in der selben Reihenfolge dargestellt, wie sie in dieser Liste vorkommen.<br /><br />Um die Reihenfolge zu ändern, wählen Sie zuerst mit <u>einem</u> Klick der <u>linken</u> Maustaste den Block den Sie verschieben möchten.  Danach klicken Sie Buttons so oft wie notwendig um den gewählten Block in der Reihenfolge zu verschieben.<br /><br />";
$pgv_lang["block_move_right_help"]		= "~Listen ändern~<br />Mit diesen Buttons können Sie Einträge aus einer Liste kopieren oder entfernen und in einer anderen Liste eintragen.<br /><br />Wie gewohnt, wählen Sie zuerst mit <u>einem</u> Klick der <u>linken</u> Maustaste den Block mit dem Sie eben arbeiten möchten.  Danach klicken Sie einen der Pfeile um den gewählten Block in der Pfeilrichtung zu verschieben.  Die <b>&raquo;</b> und <b>&laquo;</b> verschieben den gewählten Block von der ganz linken zur ganz rechten Liste oder umgekehrt. Die  <b>&gt;</b> und <b>&lt;</b> Pfeile verschieben den gewählten Block zwischen der #pgv_lang[available_blocks]# Liste und der Liste rechts oder links daneben.<br /><br />Die Einträge in der #pgv_lang[available_blocks]# Liste werden niemals entfernt, weil der selbe Block, z.B. der HTML Block, mehrmals auf der Seite dargestellt werden kann.<br /><br />";
$pgv_lang["block_default_index"]		= "~Standard-Blöcke der #pgv_lang[welcome]# Seite~<br />Wenn Sie alle Einträge der #pgv_lang[main_section]# und #pgv_lang[right_section]# Listen entfernen, oder wenn Sie den <b>#pgv_lang[reset_default_blocks]#</b> Button klicken, erhalten Sie folgende Standard-Einstellungen:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["block_default_portal"]		= "~Standard-Blöcke der #pgv_lang[mygedview]# Seite~<br />Wenn Sie alle Einträge der #pgv_lang[main_section]# und #pgv_lang[right_section]# Listen entfernen, oder wenn Sie den <b>#pgv_lang[reset_default_blocks]#</b> Button klicken, erhalten Sie folgende Standard-Einstellungen:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";

// accesskey help
$pgv_lang["accesskey_viewing_advice_help"]	= "~#pgv_lang[accesskeys]#~<br />Abkürzungen, die über die Tastatur erhältlich sind, sind im Großen und Ganzen dafür gedacht, den Zugriff ohne Maus zu verschiedenen Teilen der Seite zu erleichtern. Die Betätigung der Abkürzungen ist für fast jeden Browser verschieden:<ul><li>Internet Explorer 5+:&nbsp;&nbsp;Sie müssen die «Alt» Taste niederhalten während Sie die gewünschte Buchstaben- oder Zifferntaste drücken.  Nachdem Sie beide Tasten los gelassen haben, müssen Sie noch die «Eingabe» Taste betätigen.</li><li>Firefox 2+:&nbsp;&nbsp;Sie müssen die «Shift» und «Alt» Tasten niederhalten während Sie die gewünschte Buchstaben- oder Zifferntaste drücken. Nachdem Sie alle Tasten los gelassen haben, sollten Sie die «Eingabe» Taste <u>nicht</u> betätigen.</li><li>Firefox 1, 1.5 und Netscape 6+:&nbsp;&nbsp;Sie müssen die «Alt» Taste niederhalten während Sie die gewünschte Buchstaben- oder Zifferntaste drücken. Nachdem Sie beide Tasten los gelassen haben, sollten Sie die «Eingabe» Taste <u>nicht</u> betätigen.</li><li>Opera:&nbsp;&nbsp;Sie müssen die «Shift» und «Esc» Tasten niederhalten während Sie die gewünschte Buchstaben- oder Zifferntaste drücken. Nachdem Sie alle Tasten los gelassen haben, sollten Sie die «Eingabe» Taste <u>nicht</u> betätigen.</li><li>Internet Explorer 5+ for Mac / Safari 1.2+:&nbsp;&nbsp;Sie müssen die «Ctrl» Taste niederhalten während Sie die gewünschte Buchstaben- oder Zifferntaste drücken. Nachdem Sie beide Tasten los gelassen haben, sollten Sie die «Eingabe» Taste <u>nicht</u> betätigen.</li></ul><br />Folgende Abkürzungen sind Ihnen erhältlich:<ul><li>Auf allen Seiten<ul><li><b>0 (null)</b> - Informationen über Abkürzungen</li><li><b>1 (eins)</b> - #pgv_lang[welcome_page]#</li><li><b>#pgv_lang[accesskey_help_content]#</b> - #pgv_lang[help_contents]#</li><li><b>#pgv_lang[accesskey_help_current_page]#</b> - #pgv_lang[help_for_this_page]#</li><li><b>#pgv_lang[accesskey_contact]#</b> - Kontakt-Adresse </li><li><b>#pgv_lang[accesskey_skip_to_content]#</b> - Seiten-Inhalt zugreifen</li><li><b>#pgv_lang[accesskey_search]#</b> - #pgv_lang[search]# </li></ul></li><li>#pgv_lang[indi_info]# Seite<ul><li><b>#pgv_lang[accesskey_individual_details]#</b> - #pgv_lang[personal_facts]# Ordner zeigen</li><li><b>#pgv_lang[accesskey_individual_notes]#</b> - #pgv_lang[notes]# Ordner zeigen</li><li><b>#pgv_lang[accesskey_individual_sources]#</b> - #pgv_lang[ssourcess]# Ordner zeigen </li><li><b>#pgv_lang[accesskey_individual_media]#</b> - #pgv_lang[media]# Ordner zeigen</li><li><b>#pgv_lang[accesskey_individual_relatives]#</b> - #pgv_lang[relatives]# Ordner zeigen</li><li><b>#pgv_lang[accesskey_individual_research_log]#</b> - #pgv_lang[research_assistant]# Ordner zeigen</li><li><b>#pgv_lang[accesskey_individual_pedigree]#</b> - #pgv_lang[pedigree_chart]# zeigen</li><li><b>#pgv_lang[accesskey_individual_descendancy]#</b> - #pgv_lang[descend_chart]# zeigen</li><li><b>#pgv_lang[accesskey_individual_timeline]#</b> - #pgv_lang[timeline_chart]# zeigen</li><li><b>#pgv_lang[accesskey_individual_relation_to_me]#</b> - #pgv_lang[relationship_to_me]# zeigen</li><li><b>#pgv_lang[accesskey_individual_gedcom]#</b> - #pgv_lang[view_gedcom]#</li></ul></li><li>#pgv_lang[family_info]# Seite<ul><li><b>#pgv_lang[accesskey_family_parents_timeline]#</b> - #pgv_lang[parents_timeline]# Ordner zeigen</li><li><b>#pgv_lang[accesskey_family_children_timeline]#</b> - #pgv_lang[children_timeline]# Ordner zeigen</li><li><b>#pgv_lang[accesskey_family_timeline]#</b> - #pgv_lang[family_timeline]# Regisetr zeigen</li><li><b>#pgv_lang[accesskey_family_gedcom]#</b> - #pgv_lang[view_gedcom]#</li></ul></li></ul><br />";

// FAQ page
$pgv_lang["help_faq.php"]				= "~FAQ - Frequently Asked Questions<br />Häufig gestellte Fragen~<br />#pgv_lang[text_faq_help]#<br />";
$pgv_lang["text_faq_help"]				= "Die FAQ Seite kann eine Übersicht oder eine Liste der häufig gestellten Fragen (und natürlich deren Antworten) über diese Ahnenforschungs-Seiten enthalten.<br /><br />FAQ ist ein Akronym von <b>F</b>requently <b>A</b>sked <b>Q</b>uestions (englisch = häufig gestellte Fragen).<br /><br />Der Verwalter bestimmt, wie diese Seite benutzt wird, und er bestimmt auch dessen Inhalt und die Reihenfolge der Fragen.<br /><br />";

// Help search
$pgv_lang["hs_title_help"] 				= "<center>~#pgv_lang[hs_title]#~</center><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]					= "Sie können das Hilfe-System in PhpGedView durchsuchen. Mit dem  #pgv_lang[hs_title]# Element haben Sie viel Einfluss über das Durchsuchen;  die gewünschten Auskünfte sollten leicht zu finden sein.<br /><br />";
$pgv_lang["hs_keyword_advice"] 			= "~#pgv_lang[hs_keyword]#~<br />Sie geben das gewünschte Wort oder den Satzteil ein.<br /><br />Das Groß- oder Kleinschreiben spielt bei der Suche keine Rolle.  Wenn Sie, zum Beispiel, nach dem Wort <b>Suche</b> suchen, findet das Programm <b>Suche</b>, <b>suche</b>, oder <b>SUCHE</b>. Text, in dem das gewünschte Wort als Wortteil enthalten ist, wird auch gefunden.  Zum Beispiel: <b>suchen</b>, <b>durchsuchen</b>, usw.<br /><br />Sie können mehrere Wörter, mit Leerzeichen dazwischen, eingeben.  Zum Beispiel: <b>Person&nbsp;Familie&nbsp;Kind</b> Die Bedeutung solcher Eingaben wird dem Programm im #pgv_lang[hs_searchhow]# Feld angedeutet.<br /><br />";
$pgv_lang["hs_searchin_advice"]			= "~#pgv_lang[hs_searchin]#~<br />Hier bestimmen Sie den Umfang der Suche.<br /><br />Verwalter können Benutzer oder Konfigurations-Hilfetexte durchsuchen.  Gewöhnlichen Benutzern ist diese Wahl nicht gestattet;  da diese keinen Zugang zu den Konfigurations-Seiten haben, ist es für sie nutzlos, die Konfigurations-Hilfetexte zu durchsuchen.<br /><br />Die Text-Dateien enthalten nicht nur Hilfetexte, sonder auch Texte die beim Erstellen der verschiedenen Formulare benutzt werden.  Mit dieser Option können Sie bestimmen, ob alle Texte durchsucht werden sollen, oder nur die Hilfetexte.<br /><br />";
$pgv_lang["hs_searchhow_advice"]		= "~#pgv_lang[hs_searchhow]#~<br />Hier können Sie die Bedeutung Ihrer Eingaben im #pgv_lang[hs_keyword]# Feld erläutern.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Wenn Sie <b>Person&nbsp;Familie&nbsp;Kind</b> eingegeben haben, findet das Programm alle Texte in denen eines dieser Wörter vorkommt.  Die Reihenfolge der eingegebenen Wörter spielt keine Rolle.  Die aktuelle Bedeutung Ihrer Eingaben ist also:  «Finde alle Texte in denen <b>Person</b> <u>oder</u> <b>Familie</b> <u>oder</u> <b>Kind</b> vorkommt.»</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd><br />Wenn Sie <b>Person&nbsp;Familie&nbsp;Kind</b> eingegeben haben, findet das Programm alle Texte in denen alle eingegebenen Wörter vorkommen.  Die Reihenfolge der eingegebenen Wörter spielt keine Rolle.  Die aktuelle Bedeutung Ihrer Eingaben ist also:  «Finde alle Texte in denen <b>Person</b> <u>und</u> <b>Familie</b> <u>und</u> <b>Kind</b> vorkommen.»</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Wenn Sie <b>Person&nbsp;Familie&nbsp;Kind</b> eingegeben haben, findet das Programm alle Texte in denen die eingegebenen Wörter in der selben Reihenfolge vorkommen, ohne andere Texte dazwischen. Die aktuelle Bedeutung Ihrer Eingaben ist also:  «Finde alle Texte in denen <b>Person</b> <u>und</u> <b>Familie</b> <u>und</u> <b>Kind</b> in dieser Reihenfolge, ohne andere Texte dazwischen, vorkommen.»  Die Wörter die Sie eingeben sind also ein Satzteil. Das Beispiel kommt bestimmt nicht in den Hilfetexten vor.<br /><br />Diese Suche hat einige Beschränkungen.  Bestimmte Sonderzeichen, wie <b>\" &lt; &gt;</b> usw. sind in den Texten oft symbolisch dargestellt und werden deshalb nicht gefunden, wenn Ihre Eingabe solche Zeichen enthält. Einige Texte enthalten besondere Leerzeichen, die symbolisch als <b>&amp;nbsp;</b> dargestellt sind.  Texte mit solchen besonderen Leerzeichen werden auch nicht gefunden.</dd></dl>";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]		= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Dieses Programm kann dem Verwalter das Reinigen der Dateien im Index-Verzeichnis ermöglichen.<br /><br />Unbrauchbare Dateien, wie zum Beispiel alte Log-Dateien, alte GEDCOM-Dateien, alte Sicherheits-Kopien, usw. sammeln sich oft im Index-Verzeichnis.  Da diese Dateien meistens von PhpGedView erstellt wurden, ist das Server-Nutzerid deren Besitzer.  Es kann dann vorkommen, dass Sie diese veralteten Dateien nicht direkt löschen können.  Dieses Programm ermöglicht Ihnen, solche Dateien zu löschen.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";
?>
