/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import net.sourceforge.dvb.projectx.audio.AudioFormat;

public class AudioFormatAAC
extends AudioFormat {
    private int[] frequency_index;
    private int[] bitrate_index;
    private String[] acmod;
    private int[] channels;

    public AudioFormatAAC() {
        int[] nArray = new int[16];
        nArray[0] = 96000;
        nArray[1] = 88200;
        nArray[2] = 64000;
        nArray[3] = 48000;
        nArray[4] = 44100;
        nArray[5] = 32000;
        nArray[6] = 24000;
        nArray[7] = 22050;
        nArray[8] = 16000;
        nArray[9] = 12000;
        nArray[10] = 11025;
        nArray[11] = 8000;
        this.frequency_index = nArray;
        this.bitrate_index = new int[]{32000, 56000, 64000, 96000, 112000, 128000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000, 768000};
        this.acmod = new String[]{"1", "DM", "2/0", "2/0"};
        int[] nArray2 = new int[16];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 2;
        nArray2[3] = 2;
        nArray2[4] = 2;
        nArray2[5] = 3;
        nArray2[6] = 3;
        nArray2[7] = 4;
        nArray2[8] = 4;
        nArray2[9] = 5;
        nArray2[10] = 6;
        nArray2[11] = 6;
        nArray2[12] = 7;
        nArray2[13] = 8;
        this.channels = nArray2;
    }

    public int compareHeader() {
        if (this.getLastID() != this.getID()) {
            return 1;
        }
        if (this.getLastLayer() != this.getLayer()) {
            return 2;
        }
        if (this.getLastSamplingFrequency() != this.getSamplingFrequency()) {
            return 4;
        }
        if (this.getLastBitrate() != this.getBitrate()) {
            return 8;
        }
        if (this.getLastMode() != this.getMode()) {
            return 16;
        }
        if (this.getLastModeExtension() != this.getModeExtension()) {
            return 32;
        }
        if (this.getLastSize() != this.getSize()) {
            return 64;
        }
        return 0;
    }

    public String displayHeader() {
        return "AAC, " + this.acmod[this.getLastMode()] + "(" + this.channels[this.getLastChannel()] + "), " + this.getLastSamplingFrequency() + "Hz, " + (double)this.getLastBitrate() / 1000.0 + "kbps, " + this.getLastSize() + "BpF";
    }

    public int parseHeader(byte[] byArray, int n) {
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = bl = byArray[n] == 86 && (0xE0 & byArray[n + 1]) == 224;
        if (bl) {
            n2 = 3 + ((0x1F & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2]);
            n += 3;
        }
        if (byArray.length == 4) {
            return bl && (0xFF & byArray[n]) == 255 ? n2 : -1;
        }
        if ((0xFF & byArray[n]) != 255 && (0xE0 & byArray[n + 1]) != 224) {
            return -1;
        }
        this.setID(1 & byArray[n + 1] >>> 3);
        this.setLayer(3 & byArray[n + 1] >>> 1);
        this.setProtectionBit(1 ^ 1 & byArray[n + 1]);
        this.setMode(3 & byArray[n + 2] >>> 6);
        this.setSamplingFrequency(this.frequency_index[0xF & byArray[n + 2] >>> 2]);
        this.setPrivateBit(1 & byArray[n + 2] >>> 1);
        this.setChannel(7 & byArray[n + 2] << 2 | 3 & byArray[n + 3] >>> 6);
        this.setCopyright(1 & byArray[n + 3] >>> 5);
        this.setOriginal(1 & byArray[n + 3] >>> 4);
        this.setEmphasis(3 & byArray[n + 3] >>> 2);
        this.setFrameTimeLength(3840.0);
        this.setBitrate(1000);
        this.setSizeBase((0xFF & byArray[n + 4]) << 5 | 0x1F & byArray[n + 5] >> 3);
        this.setSize(this.getSizeBase());
        return this.getLayer();
    }

    public int parseNextHeader(byte[] byArray, int n) {
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = bl = byArray[n] == 86 && (0xE0 & byArray[n + 1]) == 224;
        if (bl) {
            n2 = 3 + ((0x1F & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2]);
            n += 3;
        }
        if ((0xFF & byArray[n]) != 255 && (0xE0 & byArray[n + 1]) != 224) {
            return -1;
        }
        this.setNextID(1 & byArray[n + 1] >>> 3);
        this.setNextLayer(3 & byArray[n + 1] >>> 1);
        this.setNextProtectionBit(1 ^ 1 & byArray[n + 1]);
        this.setNextMode(3 & byArray[n + 2] >>> 6);
        this.setNextSamplingFrequency(this.frequency_index[0xF & byArray[n + 2] >>> 2]);
        this.setNextPrivateBit(1 & byArray[n + 2] >>> 1);
        this.setNextChannel(7 & byArray[n + 2] << 2 | 3 & byArray[n + 3] >>> 6);
        this.setNextCopyright(1 & byArray[n + 3] >>> 5);
        this.setNextOriginal(1 & byArray[n + 3] >>> 4);
        this.setNextEmphasis(3 & byArray[n + 3] >>> 2);
        this.setNextFrameTimeLength(3840.0);
        this.setNextBitrate(1000);
        this.setNextSizeBase((0xFF & byArray[n + 4]) << 5 | 0x1F & byArray[n + 5] >> 3);
        this.setNextSize(this.getNextSizeBase());
        return this.getNextLayer();
    }
}

