/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.xinput.XInputDirectory;

public class Settings {
    private static final String DEFAULT_INI = "X.ini";
    private String inifile = "";
    private Properties props = new Properties();
    private ArrayList input_directories = new ArrayList();
    private ArrayList output_directories = new ArrayList();

    public Settings() {
        this(String.valueOf(Resource.workdir) + Resource.filesep + DEFAULT_INI);
    }

    public Settings(String string) {
        this.inifile = string;
        this.load();
        this.buildInputDirectories();
        this.buildOutputDirectories();
    }

    public String addInputDirectory(Object object) {
        if (object == null) {
            return null;
        }
        try {
            XInputDirectory xInputDirectory = (XInputDirectory)object;
            this.input_directories.add(xInputDirectory);
            return xInputDirectory.toString();
        }
        catch (Exception exception) {
            try {
                XInputDirectory xInputDirectory = new XInputDirectory(object);
                if (xInputDirectory.test()) {
                    this.input_directories.add(xInputDirectory);
                    return xInputDirectory.toString();
                }
            }
            catch (RuntimeException runtimeException) {}
            return null;
        }
    }

    public void addOutputDirectory(Object object) {
        this.addOutputDirectory(object, -1);
    }

    public void addOutputDirectory(Object object, int n) {
        if (object == null) {
            return;
        }
        if (n < 0 || n > this.output_directories.size()) {
            this.output_directories.add(object);
        } else {
            this.output_directories.add(n, object);
        }
        this.updateOutputDirectories();
    }

    public void buildInputDirectories() {
        String string = "Application.InputDirectories.";
        ArrayList arrayList = (ArrayList)this.getListProperty(string);
        int n = 0;
        while (n < arrayList.size()) {
            if (this.addInputDirectory(arrayList.get(n)) == null) {
                arrayList.remove(n);
                --n;
            }
            ++n;
        }
        if (n != arrayList.size()) {
            this.setListProperty(string, arrayList);
        }
    }

    public void buildOutputDirectories() {
        String string = "Application.OutputDirectories.";
        ArrayList arrayList = (ArrayList)this.getListProperty(string);
        int n = 0;
        while (n < arrayList.size()) {
            this.addOutputDirectory(arrayList.get(n));
            ++n;
        }
        if (n != arrayList.size()) {
            this.setListProperty(string, arrayList);
        }
    }

    public Boolean getBooleanProperty(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        if (string2.equals("1") || string2.equals("true") || string2.equals("yes") || string2.equals("on")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        Boolean bl2 = this.getBooleanProperty(string);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public boolean getBooleanProperty(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        Boolean bl = this.getBooleanProperty(string);
        if (bl != null) {
            return bl;
        }
        return string2.equals("1") || string2.equals("true") || string2.equals("yes") || string2.equals("on");
    }

    public Map getHashMapProperty(String string) {
        Set set = ((Hashtable)this.props).keySet();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            hashMap.put(string2.substring(string.length()), this.props.getProperty(string2));
        }
        return hashMap;
    }

    public String getInifile() {
        return this.inifile;
    }

    public ArrayList getInputDirectories() {
        return this.input_directories;
    }

    public int getIntProperty(String string) {
        return Integer.parseInt(this.props.getProperty(string));
    }

    public int getIntProperty(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(this.getProperty(string));
        }
        catch (Exception exception) {}
        return n2;
    }

    public int getIntProperty(String[] stringArray) {
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        try {
            n = Integer.parseInt(this.getProperty(string));
        }
        catch (Exception exception) {}
        return n;
    }

    public List getListProperty(String string) {
        Set set = ((Hashtable)this.props).keySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            arrayList.add(this.props.getProperty(string2));
        }
        return arrayList;
    }

    public ArrayList getOutputDirectories() {
        return this.output_directories;
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.props.getProperty(string, string2);
    }

    public String getProperty(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        return this.props.getProperty(string, string2);
    }

    public void load() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.inifile));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.startsWith("#") || (n = string.indexOf(61)) == -1) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                ((Hashtable)this.props).put(string2, string3);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println(String.valueOf(Resource.getString("msg.loadini.error")) + " " + iOException);
        }
    }

    public void loadProperties(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.props.load(byteArrayInputStream);
    }

    public void remove(String string) {
        ((Hashtable)this.props).remove(string);
    }

    public void removeInputDirectory(int n) {
        if (n < 0 || this.input_directories.isEmpty() || this.input_directories.size() <= n) {
            return;
        }
        this.input_directories.remove(n);
    }

    public void removeListProperty(String string) {
        Set set = ((Hashtable)this.props).keySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        int n = 0;
        while (n < arrayList.size()) {
            this.remove(arrayList.get(n).toString());
            ++n;
        }
    }

    public void removeOutputDirectory(int n) {
        if (n < 0 || this.output_directories.size() < n - 1) {
            return;
        }
        this.output_directories.remove(n);
        this.updateOutputDirectories();
    }

    public void save() {
        this.save(this.inifile);
    }

    public void save(String string) {
        if (string == null) {
            string = this.inifile;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            String string2 = "# Project-X INI";
            printWriter.println(string2);
            printWriter.println("# " + Common.getVersionName() + " / " + Common.getVersionDate());
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(this.props);
            Set<Object> set = treeMap.keySet();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = string3.substring(0, string3.indexOf("."));
                if (!string2.equals(string4)) {
                    printWriter.println();
                    printWriter.println("# " + string4);
                    string2 = string4;
                }
                printWriter.println(String.valueOf(string3) + "=" + treeMap.get(string3));
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public void setBooleanProperty(String string, boolean bl) {
        this.props.setProperty(string, bl ? "1" : "0");
    }

    public void setHashMapProperty(String string, Map map) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.setProperty(String.valueOf(string) + string2, map.get(string2));
        }
    }

    public void setIntProperty(String string, int n) {
        this.props.setProperty(string, String.valueOf(n));
    }

    public void setListProperty(String string, List list) {
        this.removeListProperty(string);
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            this.setProperty(String.valueOf(string) + n, e);
            ++n;
        }
    }

    public void setProperty(String string, Object object) {
        String string2 = object == null ? null : String.valueOf(object);
        this.setProperty(string, string2);
    }

    public void setProperty(String string, String string2) {
        if (string2 != null) {
            this.props.setProperty(string, string2);
        } else {
            ((Hashtable)this.props).remove(string);
        }
    }

    public void setProperty(Object[] objectArray, Object object) {
        this.setProperty(objectArray[0].toString(), String.valueOf(object));
    }

    public byte[] storeProperties() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.props.store(byteArrayOutputStream, null);
        return byteArrayOutputStream.toByteArray();
    }

    public void updateInputDirectories() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.input_directories.size()) {
            arrayList.add(this.input_directories.get(n).toString());
            ++n;
        }
        this.setListProperty("Application.InputDirectories.", arrayList);
    }

    public void updateOutputDirectories() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.output_directories.size()) {
            arrayList.add(this.output_directories.get(n).toString());
            ++n;
        }
        this.setListProperty("Application.OutputDirectories.", arrayList);
    }
}

