/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Resource;

class HtmlPane
extends JScrollPane
implements HyperlinkListener {
    private JEditorPane html;

    public HtmlPane(String string) {
        try {
            if (string != null) {
                this.html = new JEditorPane(string);
            } else {
                string = "htmls/index.html";
                this.html = new JEditorPane(Resource.getLocalizedResourceURL("htmls", "index.html"));
            }
        }
        catch (MalformedURLException malformedURLException) {
            Common.setMessage("Malformed URL: " + malformedURLException);
            this.html = new JEditorPane();
            this.html.setText("wrong url ! :\n" + string);
        }
        catch (IOException iOException) {
            Common.setMessage("IOException: " + iOException);
            this.html = new JEditorPane();
            this.html.setText("missing resource ! :\n" + string);
        }
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        JViewport jViewport = this.getViewport();
        jViewport.add(this.html);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkEvent.getURL());
        }
    }

    protected void linkActivated(URL uRL) {
        if (uRL.getProtocol().equals("http") || uRL.getProtocol().equals("https")) {
            try {
                BrowserLauncher.openURL(uRL.toString());
            }
            catch (IOException iOException) {
                Common.setMessage(String.valueOf(Resource.getString("msg.browser.launcher.error")) + " " + iOException);
            }
        } else {
            Cursor cursor = this.html.getCursor();
            Cursor cursor2 = Cursor.getPredefinedCursor(3);
            this.html.setCursor(cursor2);
            SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
        }
    }

    private class PageLoader
    implements Runnable {
        private URL url;
        private Cursor cursor;

        PageLoader(URL uRL, Cursor cursor) {
            this.url = uRL;
            this.cursor = cursor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (this.url == null) {
                HtmlPane.this.html.setCursor(this.cursor);
                Container container = HtmlPane.this.html.getParent();
                container.repaint();
                return;
            }
            Document document = HtmlPane.this.html.getDocument();
            try {
                try {
                    HtmlPane.this.html.setPage(this.url);
                }
                catch (IOException iOException) {
                    HtmlPane.this.html.setDocument(document);
                    HtmlPane.this.getToolkit().beep();
                }
                Object var3_3 = null;
                this.url = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.url = null;
                SwingUtilities.invokeLater(this);
                throw throwable;
            }
            SwingUtilities.invokeLater(this);
        }
    }
}

