/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.MemoryImageSource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.UIManager;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;
import net.sourceforge.dvb.projectx.gui.X_JFileChooser;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.video.PreviewObject;
import net.sourceforge.dvb.projectx.xinput.StreamInfo;

public class PicturePanel
extends JPanel {
    private Image StreamTypeImage = Resource.loadImage("_container.gif");
    private Image VideoImage = Resource.loadImage("_video.gif");
    private Image AudioImage = Resource.loadImage("_audio.gif");
    private Image TeletextImage = Resource.loadImage("_teletext.gif");
    private Image SubtitleImage = Resource.loadImage("_subtitle.gif");
    private Image PlaytimeImage = Resource.loadImage("_playtime.gif");
    private Image PalPlusImage = Resource.loadImage("_ppl.gif");
    private Image SubpictureImage;
    private Image image;
    private Image mixed_image;
    private Image thumb_image;
    private Image InfoBackground = Resource.loadImage("ibg.gif");
    private Image SlideBackground = Resource.loadImage("sbg.gif");
    private MemoryImageSource source;
    private MemoryImageSource mixed_source;
    private MemoryImageSource thumb_source;
    private boolean showFileInfo = false;
    private boolean isSubpictureAvailable = false;
    private boolean isThumbnailAvailable = false;
    private boolean isOSDInfoAvailable = false;
    private boolean isOSDErrorInfo = false;
    private boolean PLAY = true;
    private boolean isMixedImageAvailable = false;
    private boolean isMatrixImageAvailable = false;
    private boolean isFilterActive = false;
    private boolean fullScaled = false;
    private boolean manualzoom = false;
    private boolean definezoom = false;
    private int[] zoomrect = new int[6];
    private int[] mixed_image_array;
    private int[] thumb_image_array;
    private String mixed_image_info = "";
    private int matrix_index = -1;
    private int matrix_new_width = 128;
    private int matrix_new_height = 72;
    private Hashtable matrix_positions = new Hashtable();
    private int[][] matrix_table;
    private StreamInfo streamInfo;
    private Font font_1;
    private Font font_2;
    private Font font_3;
    private NumberFormat percentage;
    private int ErrorFlag;
    private int bmpCount;
    private int collection_number;
    private int[] imageSizeMin;
    private final String tooltip1;
    private long cutfiles_length;
    private long[] cutfiles_points;
    private long chapter_length;
    private long[] chapter_points;
    private Object[] OSDInfo;
    private JPopupMenu popup;
    private JPanel sliderPanel;
    private Clock clock;
    private Dimension previewImageSize;
    private static final Color OUTLINE_COLOR_1 = Color.lightGray;
    private static final Color OUTLINE_COLOR_2 = Color.white;
    private static final Color OUTLINE_COLOR_3 = new Color(151, 151, 151);
    private Dimension infoParts;
    private byte[] bmpHead;
    private double[] aspectratio_table;

    public PicturePanel() {
        int[][] nArrayArray = new int[16][];
        nArrayArray[0] = new int[2];
        nArrayArray[1] = new int[]{128, 1};
        nArrayArray[2] = new int[]{256, 1};
        nArrayArray[3] = new int[]{384, 1};
        int[] nArray = new int[2];
        nArray[1] = 72;
        nArrayArray[4] = nArray;
        nArrayArray[5] = new int[]{128, 72};
        nArrayArray[6] = new int[]{256, 72};
        nArrayArray[7] = new int[]{384, 72};
        int[] nArray2 = new int[2];
        nArray2[1] = 144;
        nArrayArray[8] = nArray2;
        nArrayArray[9] = new int[]{128, 144};
        nArrayArray[10] = new int[]{256, 144};
        nArrayArray[11] = new int[]{384, 144};
        int[] nArray3 = new int[2];
        nArray3[1] = 216;
        nArrayArray[12] = nArray3;
        nArrayArray[13] = new int[]{128, 216};
        nArrayArray[14] = new int[]{256, 216};
        nArrayArray[15] = new int[]{384, 216};
        this.matrix_table = nArrayArray;
        this.streamInfo = null;
        this.ErrorFlag = 0;
        this.bmpCount = 0;
        this.collection_number = -1;
        this.imageSizeMin = new int[]{512, 288};
        this.tooltip1 = Resource.getString("mpvdecoder.tip1");
        this.cutfiles_length = 0L;
        this.cutfiles_points = null;
        this.chapter_length = 0L;
        this.chapter_points = null;
        this.infoParts = new Dimension(184, 44);
        byte[] byArray = new byte[54];
        byArray[0] = 66;
        byArray[1] = 77;
        byArray[10] = 54;
        byArray[14] = 40;
        byArray[26] = 1;
        byArray[28] = 24;
        byArray[38] = -120;
        byArray[39] = 11;
        byArray[42] = -120;
        byArray[43] = 11;
        this.bmpHead = byArray;
        this.aspectratio_table = new double[]{1.3333, 1.3333, 1.3333, 1.7778, 2.21, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333};
        this.percentage = NumberFormat.getPercentInstance();
        this.percentage.setMaximumFractionDigits(2);
        this.source = new MemoryImageSource(this.imageSizeMin[0], this.imageSizeMin[1], Common.getMpvDecoderClass().getPreviewPixel(), 0, this.imageSizeMin[0]);
        this.source.setAnimated(true);
        this.image = this.createImage(this.source);
        this.mixed_image_array = new int[this.imageSizeMin[0] * this.imageSizeMin[1]];
        this.mixed_source = new MemoryImageSource(this.imageSizeMin[0], this.imageSizeMin[1], this.mixed_image_array, 0, this.imageSizeMin[0]);
        this.mixed_source.setAnimated(true);
        this.mixed_image = this.createImage(this.mixed_source);
        this.thumb_image_array = new int[14400];
        this.thumb_source = new MemoryImageSource(160, 90, this.thumb_image_array, 0, 160);
        this.thumb_source.setAnimated(true);
        this.thumb_image = this.createImage(this.thumb_source);
        this.font_1 = new Font("Tahoma", 0, 12);
        this.font_2 = new Font("Tahoma", 1, 12);
        this.font_3 = new Font("Tahoma", 1, 24);
        this.setBackground(Color.black);
        this.setVisible(true);
        this.setToolTipText(this.tooltip1);
        this.buildPopupMenu();
        this.sliderPanel = this.buildSliderPanel();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 1 && (PicturePanel.this.showFileInfo || PicturePanel.this.isOSDInfoAvailable)) {
                    PicturePanel.this.showFileInfo = false;
                    PicturePanel.this.isOSDInfoAvailable = false;
                    PicturePanel.this.repaint();
                }
                if (PicturePanel.this.isMatrixImageAvailable) {
                    long l;
                    if (mouseEvent.getClickCount() == 1 && mouseEvent.getModifiers() == 16) {
                        if (PicturePanel.this.matrix_positions.containsKey(String.valueOf(PicturePanel.this.matrix_index))) {
                            l = (Long)PicturePanel.this.matrix_positions.get(String.valueOf(PicturePanel.this.matrix_index));
                            CommonGui.getCutPanel().startMatrix(l);
                        } else {
                            CommonGui.getCutPanel().stopMatrix();
                        }
                    }
                    if (mouseEvent.getClickCount() >= 2 && mouseEvent.getModifiers() == 4 && PicturePanel.this.matrix_positions.containsKey(String.valueOf(PicturePanel.this.matrix_index))) {
                        l = (Long)PicturePanel.this.matrix_positions.get(String.valueOf(PicturePanel.this.matrix_index));
                        PicturePanel.this.disableMatrix();
                        CommonGui.getCutPanel().stopMatrix();
                        CommonGui.getCutPanel().preview(l);
                    }
                } else if (mouseEvent.getClickCount() >= 1 && mouseEvent.getModifiers() == 4) {
                    PicturePanel.this.popup.show(PicturePanel.this.getParent(), mouseEvent.getX(), mouseEvent.getY());
                }
                if (mouseEvent.getClickCount() >= 2 && mouseEvent.getModifiers() == 16) {
                    CommonGui.getPlayerFrame().repaintPicture();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!PicturePanel.this.definezoom) {
                    return;
                }
                PicturePanel.this.definezoom = false;
                PicturePanel.this.manualzoom = false;
                PicturePanel.this.repaint();
                Common.getMpvDecoderClass().setZoomMode(PicturePanel.this.zoomrect);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (Common.getMpvDecoderClass().getZoomMode() == 2) {
                    ((PicturePanel)PicturePanel.this).zoomrect[0] = mouseEvent.getX() < 0 ? 0 : mouseEvent.getX();
                    ((PicturePanel)PicturePanel.this).zoomrect[1] = mouseEvent.getY() < 0 ? 0 : mouseEvent.getY();
                    Common.getMpvDecoderClass().setZoomMode(PicturePanel.this.zoomrect);
                }
                if (!PicturePanel.this.definezoom) {
                    return;
                }
                if (!PicturePanel.this.manualzoom) {
                    PicturePanel.this.manualzoom = true;
                    ((PicturePanel)PicturePanel.this).zoomrect[0] = mouseEvent.getX();
                    ((PicturePanel)PicturePanel.this).zoomrect[1] = mouseEvent.getY();
                } else {
                    ((PicturePanel)PicturePanel.this).zoomrect[2] = mouseEvent.getX() - PicturePanel.this.zoomrect[0];
                    ((PicturePanel)PicturePanel.this).zoomrect[3] = (int)(9.0 * (double)PicturePanel.this.zoomrect[2] / 16.0);
                }
                PicturePanel.this.repaint();
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                int n = 0;
                if (PicturePanel.this.isMatrixImageAvailable && (n = mouseEvent.getX() / PicturePanel.this.matrix_new_width + PicturePanel.this.imageSizeMin[0] / PicturePanel.this.matrix_new_width * (mouseEvent.getY() / PicturePanel.this.matrix_new_height)) < PicturePanel.this.matrix_table.length) {
                    PicturePanel.this.matrix_index = n;
                    PicturePanel.this.repaint();
                }
                if (!PicturePanel.this.definezoom || PicturePanel.this.manualzoom) {
                    return;
                }
                ((PicturePanel)PicturePanel.this).zoomrect[4] = mouseEvent.getX();
                ((PicturePanel)PicturePanel.this).zoomrect[5] = mouseEvent.getY();
                PicturePanel.this.repaint();
            }
        });
        this.clock = new Clock();
    }

    private int YUVtoRGB(int n) {
        int n2 = 255;
        int n3 = 0xFF & n >>> 16;
        int n4 = 0xFF & n >>> 8;
        int n5 = 0xFF & n;
        if (n3 == 0) {
            return 0;
        }
        int n6 = (int)((float)n3 + 1.402f * (float)(n5 - 128));
        int n7 = (int)((double)n3 - 0.34414 * (double)(n4 - 128) - 0.71414 * (double)(n5 - 128));
        int n8 = (int)((double)n3 + 1.722 * (double)(n4 - 128));
        int n9 = n6 < 0 ? 0 : (n6 = n6 > 255 ? 255 : n6);
        int n10 = n7 < 0 ? 0 : (n7 = n7 > 255 ? 255 : n7);
        n8 = n8 < 0 ? 0 : (n8 > 255 ? 255 : n8);
        return n2 << 24 | n6 << 16 | n7 << 8 | n8;
    }

    protected void buildPopupMenu() {
        final String[] stringArray = new String[]{"normalzoom", "lbzoom", "zoomarea", "save_1", "save_2"};
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals(stringArray[3])) {
                    this.saveBMP(Common.getMpvDecoderClass().getPixels(), Common.getMpvDecoderClass().getWidth(), Common.getMpvDecoderClass().getHeight(), 0, false);
                } else if (string.equals(stringArray[4])) {
                    this.saveBMP(Common.getMpvDecoderClass().getPixels(), Common.getMpvDecoderClass().getWidth(), Common.getMpvDecoderClass().getHeight(), Common.getMpvDecoderClass().getAspectRatio(), true);
                } else if (string.equals(stringArray[0])) {
                    Common.getMpvDecoderClass().setZoomMode(0);
                } else if (string.equals(stringArray[1])) {
                    Common.getMpvDecoderClass().setZoomMode(1);
                } else if (string.equals(stringArray[2])) {
                    definezoom = true;
                    Arrays.fill(zoomrect, 0);
                }
            }
        };
        this.popup = new JPopupMenu("save");
        JMenuItem jMenuItem = this.popup.add("Normal Zoom");
        jMenuItem.setActionCommand(stringArray[0]);
        JMenuItem jMenuItem2 = this.popup.add("LB Zoom");
        jMenuItem2.setActionCommand(stringArray[1]);
        JMenuItem jMenuItem3 = this.popup.add("Zoom Area..");
        jMenuItem3.setActionCommand(stringArray[2]);
        this.popup.addSeparator();
        JMenuItem jMenuItem4 = this.popup.add(Resource.getString("PreviewPanel.saveCurrentPicture"));
        jMenuItem4.setActionCommand(stringArray[3]);
        JMenuItem jMenuItem5 = this.popup.add(Resource.getString("PreviewPanel.saveCurrentPictureDAR"));
        jMenuItem5.setActionCommand(stringArray[4]);
        this.popup.pack();
        UIManager.addPropertyChangeListener(new UISwitchListener(this.popup));
        jMenuItem.addActionListener(actionListener);
        jMenuItem2.addActionListener(actionListener);
        jMenuItem3.addActionListener(actionListener);
        jMenuItem4.addActionListener(actionListener);
        jMenuItem5.addActionListener(actionListener);
    }

    protected JPanel buildSliderPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JSlider jSlider = new JSlider();
        jSlider.setOrientation(1);
        jSlider.setInverted(true);
        jSlider.setMaximum(100);
        jSlider.setMajorTickSpacing(10);
        jSlider.setMinorTickSpacing(1);
        jSlider.setPaintTicks(true);
        jSlider.setValue(50);
        jSlider.setPreferredSize(new Dimension(30, 356));
        jSlider.setMaximumSize(new Dimension(30, 356));
        jSlider.setMinimumSize(new Dimension(30, 356));
        jPanel.add(jSlider);
        return jPanel;
    }

    public void clearMixedImage() {
        Arrays.fill(this.mixed_image_array, 0);
    }

    public void disableMatrix() {
        this.isMatrixImageAvailable = false;
    }

    public int[][] getMatrixTable() {
        return this.matrix_table;
    }

    public Image getPreviewImage() {
        return this.image;
    }

    private int[] getScaledPixel(int[] nArray, int n, int n2, double d) {
        int n3 = n2;
        int n4 = n;
        int n5 = (0xF & n) != 0 ? (n & 0xFFFFFFF0) + 16 : n;
        int n6 = n2;
        int n7 = (int)Math.round((double)n2 * d);
        int n8 = n7 * n6;
        if (n8 > 0x1000000 || n8 <= 0) {
            return null;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        double d2 = (double)n3 / (double)n6;
        double d3 = (double)n4 / (double)n7;
        int[] nArray2 = new int[n8];
        int n9 = 0;
        while (f < (float)n3 && n9 < n6) {
            int n10 = 0;
            while (f2 < (float)n4 && n10 < n7) {
                nArray2[n10 + n9 * n7] = nArray[(int)f2 + (int)f * n5];
                f2 = (float)((double)f2 + d3);
                ++n10;
            }
            f = (float)((double)f + d2);
            ++n9;
            f2 = 0.0f;
        }
        return nArray2;
    }

    public JPanel getSliderPanel() {
        return this.sliderPanel;
    }

    private void littleEndian(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            byArray[n + n3] = (byte)(n2 >> (n3 << 3) & 0xFF);
            ++n3;
        }
    }

    private void loadSubpicture() {
        this.SubpictureImage = !this.isSubpictureAvailable ? null : Common.getSubpictureClass().getScaledImage(this.previewImageSize.width, this.previewImageSize.height);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.previewImageSize = new Dimension(this.getSize().width - this.infoParts.width, this.getSize().height - this.infoParts.height);
        this.setPreviewSize(this.previewImageSize.width, this.previewImageSize.height);
        this.paintInfoBackground(graphics);
        this.paintOutline(graphics);
        this.paintPreviewPicture(graphics, graphics2D);
        this.paintMixedCutPreviewPicture(graphics, graphics2D);
        this.paintMatrixPreviewPicture(graphics);
        this.paintZoomInfo(graphics);
        this.paintSlideBackground(graphics);
        this.paintVideoInfo(graphics);
        this.paintWSSInfo(graphics);
        this.paintErrorInfo(graphics);
        this.paintPlayInfo(graphics);
        graphics.setFont(this.font_2);
        this.paintCutInfo(graphics);
        this.paintPositionInfo(graphics);
        this.paintChapterInfo(graphics);
        this.paintSubpicture(graphics, graphics2D);
        this.paintOSDInfo(graphics);
        this.paintFileInfo(graphics);
        this.paintCollectionNumber(graphics);
        this.paintZoomRect(graphics);
    }

    private void paintChapterInfo(Graphics graphics) {
        if (this.chapter_length <= 0L) {
            return;
        }
        int n = 10;
        int n2 = this.previewImageSize.height + 22;
        int n3 = this.previewImageSize.width - 22;
        int n4 = 6;
        if (this.chapter_points != null && this.chapter_points.length > 0) {
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < this.chapter_points.length) {
                if (this.chapter_points[n7] > this.chapter_length) break;
                n5 = n7 == 0 ? 0 : (int)(this.chapter_points[n7 - 1] * (long)n3 / this.chapter_length);
                n6 = (int)(this.chapter_points[n7] * (long)n3 / this.chapter_length);
                graphics.setColor(new Color(195, 205, 255));
                graphics.fillRect(n + n6 - 1, n2 - 4, 2, n4 + 8);
                int[] nArray = new int[]{n + n6 - 1, n + n6 - 5, n + n6 + 5};
                int[] nArray2 = new int[]{n2 + n4 + 3, n2 + n4 + 3 + 5, n2 + n4 + 3 + 5};
                graphics.fillPolygon(nArray, nArray2, 3);
                ++n7;
            }
        }
    }

    private void paintCollectionNumber(Graphics graphics) {
        if (this.collection_number < 0) {
            return;
        }
        graphics.setFont(this.font_2);
        graphics.setColor(Color.green);
        graphics.drawString("Collection", this.previewImageSize.width - 60, 16);
        graphics.setFont(this.font_3);
        graphics.setColor(Color.green);
        graphics.drawString(String.valueOf(this.collection_number), this.previewImageSize.width - 50, 38);
    }

    private void paintCutInfo(Graphics graphics) {
        if (this.cutfiles_length <= 0L) {
            return;
        }
        int n = 10;
        int n2 = this.previewImageSize.height + 12;
        int n3 = this.previewImageSize.width - 22;
        int n4 = 6;
        graphics.setColor(new Color(0, 200, 0));
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.white);
        graphics.drawRect(n - 2, n2 - 2, n3 + 3, n4 + 3);
        if (this.cutfiles_points != null && this.cutfiles_points.length > 0) {
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < this.cutfiles_points.length) {
                if (this.cutfiles_points[n7] > this.cutfiles_length) break;
                n5 = n7 == 0 ? 0 : (int)(this.cutfiles_points[n7 - 1] * (long)n3 / this.cutfiles_length);
                n6 = (int)(this.cutfiles_points[n7] * (long)n3 / this.cutfiles_length);
                if (n7 % 2 == 0) {
                    graphics.setColor(new Color(150, 0, 0));
                    graphics.fillRect(n + n5, n2, n6 - n5, n4);
                }
                graphics.setColor(new Color(200, 100, 200));
                graphics.fillRect(n + n6 - 1, n2 - 4, 2, n4 + 8);
                int[] nArray = new int[]{n2 - 3, n2 - 3 - 5, n2 - 3 - 5};
                int[] nArray2 = new int[]{n + n6 - 1, n + n6 - 1, n + n6 + 5};
                int[] nArray3 = new int[]{n + n6 + 1, n + n6 - 5, n + n6 + 1};
                if (n7 % 2 == 0) {
                    graphics.fillPolygon(nArray2, nArray, 3);
                } else {
                    graphics.fillPolygon(nArray3, nArray, 3);
                }
                ++n7;
            }
            if ((this.cutfiles_points.length & 1) == 0) {
                n5 = (int)(this.cutfiles_points[this.cutfiles_points.length - 1] * (long)n3 / this.cutfiles_length);
                graphics.setColor(new Color(150, 0, 0));
                graphics.fillRect(n + n5, n2, n3 - n5, n4);
            }
        }
    }

    private void paintErrorInfo(Graphics graphics) {
        this.ErrorFlag = Common.getMpvDecoderClass().getErrors();
        if ((this.ErrorFlag & 1) != 0) {
            graphics.setColor(Color.white);
            graphics.fill3DRect(150, 120, 200, 20, true);
            graphics.setColor(Color.red);
            graphics.drawString("picture decoding not possible", 160, 133);
        }
        if ((this.ErrorFlag & 0xC) == 4) {
            graphics.setColor(Color.white);
            graphics.fill3DRect(150, 135, 200, 20, true);
            graphics.setColor(Color.red);
            graphics.drawString("not enough data in buffer", 160, 148);
        }
        if ((this.ErrorFlag & 2) != 0) {
            graphics.setColor(Color.white);
            graphics.fill3DRect(150, 150, 200, 20, true);
            graphics.setColor(Color.red);
            graphics.drawString("cannot find sequence header", 160, 163);
        }
        if ((this.ErrorFlag & 0x13) > 16) {
            graphics.setColor(Color.white);
            graphics.fill3DRect(150, 150, 200, 20, true);
            graphics.setColor(Color.red);
            graphics.drawString("no Sequ. but GOP header found", 160, 163);
        }
        if ((this.ErrorFlag & 8) != 0) {
            graphics.setColor(Color.white);
            graphics.fill3DRect(150, 135, 200, 20, true);
            graphics.setColor(Color.red);
            graphics.drawString("no preview for MPEG-4/H.264", 160, 148);
        }
        if ((this.ErrorFlag & 0x20) != 0) {
            graphics.setColor(Color.white);
            graphics.fill3DRect(150, 165, 200, 20, true);
            graphics.setColor(Color.red);
            graphics.drawString("java instance out of memory", 160, 178);
        }
    }

    private void paintFileInfo(Graphics graphics) {
        if (!this.showFileInfo) {
            return;
        }
        int n = 8;
        int n2 = 8;
        int n3 = this.previewImageSize.width - 18;
        int n4 = this.previewImageSize.height - 50;
        int n5 = 0;
        this.paintOSDBg(graphics, n, n2, n3, n4);
        graphics.setColor(Color.white);
        graphics.drawString(this.streamInfo.getFileSourceAndName(), n + 6, n2 + 14);
        graphics.drawString(this.streamInfo.getFileDate(), n + 6, n2 + n4 + 16);
        graphics.drawString(this.streamInfo.getFileSize(), n + 6, n2 + n4 + 30);
        if (this.isThumbnailAvailable) {
            graphics.setColor(Color.gray);
            graphics.drawRect(n + n3 - 160 - 5, n2 + n4 - 90 - 5, 161, 91);
            graphics.drawImage(this.thumb_image, n + n3 - 160 - 4, n2 + n4 - 90 - 4, this);
        }
        graphics.setColor(Color.white);
        n5 = n2 + 24;
        n5 = this.paintSubInfo(graphics, this.streamInfo.getFileType(), this.StreamTypeImage, n, n5);
        Object[] objectArray = this.streamInfo.getVideoStreams();
        n5 = this.paintSubInfo(graphics, objectArray, this.VideoImage, n, n5);
        objectArray = this.streamInfo.getAudioStreams();
        n5 = this.paintSubInfo(graphics, objectArray, this.AudioImage, n, n5);
        objectArray = this.streamInfo.getTeletextStreams();
        n5 = this.paintSubInfo(graphics, objectArray, this.TeletextImage, n, n5);
        objectArray = this.streamInfo.getSubpictureStreams();
        n5 = this.paintSubInfo(graphics, objectArray, this.SubtitleImage, n, n5);
        n5 = this.paintSubInfo(graphics, this.streamInfo.getPlaytime(), this.PlaytimeImage, n, n5);
    }

    private void paintInfoBackground(Graphics graphics) {
        graphics.setColor(new Color(0, 35, 110));
        graphics.fillRect(0, 0, this.previewImageSize.width + 200, this.previewImageSize.height + 100);
        graphics.drawImage(this.InfoBackground, 0, this.previewImageSize.height + 2, this.previewImageSize.width, this.InfoBackground.getHeight(this), this);
    }

    private void paintMatrixPreviewPicture(Graphics graphics) {
        if (!this.isMatrixImageAvailable) {
            return;
        }
        graphics.drawImage(this.mixed_image, 0, 0, this);
        if (this.matrix_index < 0 || this.matrix_index >= this.matrix_table.length) {
            return;
        }
        if (!this.matrix_positions.containsKey(String.valueOf(this.matrix_index))) {
            return;
        }
        graphics.setColor(Color.green);
        graphics.drawRect(this.matrix_table[this.matrix_index][0], this.matrix_table[this.matrix_index][1], this.matrix_new_width + 1, this.matrix_new_height + 1);
        graphics.setFont(this.font_2);
        graphics.drawString(String.valueOf(this.matrix_index), this.matrix_table[this.matrix_index][0] + 5, this.matrix_table[this.matrix_index][1] + 14);
        graphics.drawString(this.matrix_positions.get(String.valueOf(this.matrix_index)).toString(), this.matrix_table[this.matrix_index][0] + 5, this.matrix_table[this.matrix_index][1] + 54);
        graphics.drawString(this.matrix_positions.get(String.valueOf(String.valueOf(this.matrix_index)) + "TC").toString(), this.matrix_table[this.matrix_index][0] + 5, this.matrix_table[this.matrix_index][1] + 68);
        graphics.drawString(this.percentage.format(((Long)this.matrix_positions.get(String.valueOf(this.matrix_index))).doubleValue() / ((Long)this.matrix_positions.get("end")).doubleValue()), this.matrix_table[this.matrix_index][0] + 50, this.matrix_table[this.matrix_index][1] + 14);
    }

    private void paintMixedCutPreviewPicture(Graphics graphics, Graphics2D graphics2D) {
        if (!this.isMixedImageAvailable) {
            return;
        }
        if (!this.fullScaled) {
            graphics2D.drawImage(this.mixed_image, 0, 0, this.previewImageSize.width, this.previewImageSize.height, this);
        } else {
            graphics.drawImage(this.mixed_image, 0, 0, this);
        }
        graphics.setFont(this.font_2);
        graphics.setColor(Color.green);
        graphics.drawString(this.mixed_image_info, 340, 280);
    }

    private void paintOSDBg(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = new Color(150, 150, 255, 210);
        Color color2 = new Color(50, 20, 225, 210);
        Color color3 = new Color(255, 150, 150, 210);
        Color color4 = new Color(225, 20, 20, 210);
        graphics.setColor(this.isOSDErrorInfo ? color3 : color);
        graphics.fillRect(n, n2 + 20, n3, this.previewImageSize.height - 70);
        graphics.setColor(this.isOSDErrorInfo ? color4 : color2);
        graphics.fillRect(n, n2, n3, 20);
        graphics.fillRect(n, n2 + n4, n3, 34);
        graphics.setColor(Color.white);
        graphics.drawLine(n, n2 + 20, n + n3 - 1, n2 + 20);
        graphics.drawLine(n, n2 + this.previewImageSize.height - 50, n + n3 - 1, n2 + this.previewImageSize.height - 50);
    }

    private void paintOSDInfo(Graphics graphics) {
        if (!this.isOSDInfoAvailable || this.OSDInfo == null || this.OSDInfo.length == 0) {
            return;
        }
        int n = 8;
        int n2 = 8;
        int n3 = this.previewImageSize.width - 18;
        int n4 = this.previewImageSize.height - 50;
        int n5 = 0;
        this.paintOSDBg(graphics, n, n2, n3, n4);
        graphics.setColor(Color.white);
        graphics.drawString(this.OSDInfo[0].toString(), n + 10, n2 + 14);
        graphics.drawString(this.OSDInfo[1].toString(), n + 10, n2 + n4 + 16);
        n5 = n2 + 24;
        int n6 = 2;
        while (n6 < this.OSDInfo.length) {
            n5 = this.paintSubInfo(graphics, this.OSDInfo[n6].toString(), null, n, n5);
            ++n6;
        }
    }

    private void paintOutline(Graphics graphics) {
        int n = this.infoParts.height;
        graphics.setColor(OUTLINE_COLOR_3);
        graphics.drawLine(1, 1, this.previewImageSize.width, 1);
        graphics.drawLine(1, 1, 1, this.previewImageSize.height + n);
        graphics.setColor(OUTLINE_COLOR_1);
        graphics.drawLine(2, this.previewImageSize.height, this.previewImageSize.width, this.previewImageSize.height);
        graphics.drawLine(this.previewImageSize.width, 2, this.previewImageSize.width, this.previewImageSize.height + n);
        graphics.setColor(OUTLINE_COLOR_2);
        graphics.drawLine(0, 0, this.previewImageSize.width + 1, 0);
        graphics.drawLine(0, 0, 0, this.previewImageSize.height + n);
        graphics.drawLine(0, this.previewImageSize.height + 1, this.previewImageSize.width + 1, this.previewImageSize.height + 1);
        graphics.drawLine(this.previewImageSize.width + 1, 0, this.previewImageSize.width + 1, this.previewImageSize.height + n);
    }

    private void paintPlayInfo(Graphics graphics) {
        int[] nArray = new int[]{this.previewImageSize.width + 8, this.previewImageSize.width + 8, this.previewImageSize.width + 28};
        int[] nArray2 = new int[]{this.previewImageSize.height + 18, this.previewImageSize.height + 38, this.previewImageSize.height + 28};
        if (this.isFilterActive && this.PLAY) {
            graphics.setColor(Color.yellow);
            graphics.drawString("Export Filter Mismatch !", this.previewImageSize.width + 32, this.previewImageSize.height + 32);
            graphics.fillRect(this.previewImageSize.width + 8, this.previewImageSize.height + 18, 8, 20);
            graphics.fillRect(this.previewImageSize.width + 20, this.previewImageSize.height + 18, 8, 20);
            graphics.drawRect(0, 0, this.previewImageSize.width - 1, this.previewImageSize.height - 1);
            graphics.drawRect(1, 1, this.previewImageSize.width - 3, this.previewImageSize.height - 3);
        } else if (this.PLAY) {
            graphics.setColor(Color.green);
            graphics.fillPolygon(nArray, nArray2, 3);
            graphics.drawString("Inside Export Range", this.previewImageSize.width + 32, this.previewImageSize.height + 32);
        } else {
            graphics.setColor(Color.red);
            graphics.fillRect(this.previewImageSize.width + 8, this.previewImageSize.height + 18, 20, 20);
            graphics.drawString("Outside Export Range", this.previewImageSize.width + 32, this.previewImageSize.height + 32);
            graphics.drawRect(0, 0, this.previewImageSize.width - 1, this.previewImageSize.height - 1);
            graphics.drawRect(1, 1, this.previewImageSize.width - 3, this.previewImageSize.height - 3);
        }
    }

    private void paintPositionInfo(Graphics graphics) {
        int n;
        long l;
        int n2;
        int n3 = 10;
        int n4 = this.previewImageSize.height + 30;
        int n5 = this.previewImageSize.width - 22;
        int n6 = 8;
        List list = Common.getMpvDecoderClass().getPositions();
        graphics.setColor(Color.white);
        graphics.fillRect(n3, n4, 2, n6);
        graphics.fillRect(n3 + n5, n4, 2, n6);
        graphics.fillRect(n3, n4 + 3, n5, 2);
        long l2 = 1L;
        if (!list.isEmpty()) {
            l2 = (Long)list.get(list.size() - 1);
            int n7 = 1;
            n2 = list.size() - 1;
            while (n7 < n2) {
                l = (Long)list.get(n7);
                n = (int)(l * (long)n5 / l2);
                graphics.fillRect(n3 + n, n4, 2, n6);
                ++n7;
            }
            l = (Long)list.get(0);
            n = (int)(l * (long)n5 / l2);
            graphics.setColor(Color.red);
            graphics.fillRect(n3 + n, n4, 2, n6);
        }
        graphics.setFont(this.font_2);
        graphics.setColor(Color.green);
        String string = Common.getMpvDecoderClass().getPidAndFileInfo();
        int n8 = n2 = string.indexOf("-");
        if (n2 < 0) {
            n2 = n8 = string.length();
        } else {
            --n2;
            n8 += 2;
        }
        graphics.drawString(string.substring(0, n2), this.previewImageSize.width + 8, this.previewImageSize.height + 12);
        graphics.drawString(string.substring(n8), this.previewImageSize.width + 8, this.previewImageSize.height - 2);
        if (!this.isMatrixImageAvailable) {
            return;
        }
        int n9 = 0;
        while (n9 < this.matrix_table.length) {
            if (this.matrix_positions.containsKey(String.valueOf(n9))) {
                l = (Long)this.matrix_positions.get(String.valueOf(n9));
                n = (int)(l * (long)n5 / l2);
                graphics.fillRect(n3 + n, n4 + 4, 2, n6 - 4);
            }
            ++n9;
        }
        if (this.matrix_positions.containsKey(String.valueOf(this.matrix_index))) {
            l = (Long)this.matrix_positions.get(String.valueOf(this.matrix_index));
            n = (int)(l * (long)n5 / l2);
            graphics.setColor(Color.magenta);
            graphics.fillRect(n3 + n, n4, 2, n6);
        }
    }

    private void paintPreviewPicture(Graphics graphics, Graphics2D graphics2D) {
        if (!this.fullScaled) {
            graphics2D.drawImage(this.image, 0, 0, this.previewImageSize.width, this.previewImageSize.height, this);
        } else {
            graphics.drawImage(this.image, 0, 0, this);
        }
    }

    private void paintSlideBackground(Graphics graphics) {
        graphics.drawImage(this.SlideBackground, this.previewImageSize.width + 2, 0, this.infoParts.width, this.previewImageSize.height + this.infoParts.height, this);
    }

    private int paintSubInfo(Graphics graphics, String string, Image image, int n, int n2) {
        if (string != null && string.length() > 0) {
            int n3;
            if (n2 > this.previewImageSize.height - 60) {
                graphics.fillPolygon(new int[]{n + 3, n + 17, n + 9}, new int[]{n2, n2, n2 + 7}, 3);
                graphics.drawString("...", n + 25, n2 + 6);
                return n2;
            }
            int n4 = string.indexOf("\t");
            int n5 = n3 = image != null ? 25 : 10;
            if (image != null) {
                graphics.drawImage(image, n + 2, n2, this);
            }
            if (n4 >= 0) {
                graphics.drawString(string.substring(n4 + 1), n + n3 + 120, n2 + 12);
                graphics.drawString(string.substring(0, n4), n + n3, n2 + 12);
            } else {
                graphics.drawString(string, n + n3, n2 + 12);
            }
            n2 += 16;
        }
        return n2;
    }

    private int paintSubInfo(Graphics graphics, Object[] objectArray, Image image, int n, int n2) {
        if (objectArray != null && objectArray.length > 0) {
            int n3 = 0;
            while (n3 < objectArray.length) {
                n2 = this.paintSubInfo(graphics, n3 + 1 + ".  " + objectArray[n3].toString(), image, n, n2);
                ++n3;
            }
        }
        return n2;
    }

    private void paintSubpicture(Graphics graphics, Graphics2D graphics2D) {
        if (!this.isSubpictureAvailable) {
            return;
        }
        graphics2D.drawImage(this.SubpictureImage, 0, 0, this.previewImageSize.width, this.previewImageSize.height, this);
    }

    private void paintVideoInfo(Graphics graphics) {
        graphics.setFont(this.font_1);
        graphics.setColor(Color.white);
        String[] stringArray = Common.getMpvDecoderClass().getMpgInfo();
        int n = 0;
        int n2 = this.previewImageSize.width + 8;
        int n3 = 18;
        while (n < stringArray.length - 1) {
            if (stringArray[n] != null) {
                graphics.drawString(stringArray[n], n2, n3);
            }
            ++n;
            n3 += 14;
        }
    }

    private void paintWSSInfo(Graphics graphics) {
        String string = Common.getMpvDecoderClass().getWSSInfo();
        if (string == null) {
            this.setToolTipText(this.tooltip1);
            return;
        }
        graphics.setFont(this.font_2);
        graphics.setColor(Color.green);
        graphics.drawString("WSS present", 10, 16);
        graphics.drawString(Common.getMpvDecoderClass().getWSSFormatInfo(), 10, 30);
        if (Common.getMpvDecoderClass().getPalPlusInfo()) {
            graphics.drawImage(this.PalPlusImage, 8, 34, this);
        }
        this.setToolTipText("<html>" + this.tooltip1 + "<p><p>" + string + "</html>");
    }

    private void paintZoomInfo(Graphics graphics) {
        graphics.setFont(this.font_2);
        graphics.setColor(Color.green);
        graphics.drawString(Common.getMpvDecoderClass().getZoomInfo(), 20, this.previewImageSize.height - 5);
    }

    private void paintZoomRect(Graphics graphics) {
        if (!this.definezoom) {
            return;
        }
        if (!this.manualzoom) {
            graphics.setColor(new Color(255, 255, 255, 255));
            graphics.drawLine(this.zoomrect[4] - 10, this.zoomrect[5], this.zoomrect[4] + 10, this.zoomrect[5]);
            graphics.drawLine(this.zoomrect[4], this.zoomrect[5] - 10, this.zoomrect[4], this.zoomrect[5] + 10);
        } else {
            graphics.setColor(new Color(100, 100, 255, 120));
            graphics.fillRect(this.zoomrect[0], this.zoomrect[1], this.zoomrect[2], this.zoomrect[3]);
            graphics.setColor(new Color(255, 255, 255, 255));
            graphics.drawRect(this.zoomrect[0], this.zoomrect[1], this.zoomrect[2], this.zoomrect[3]);
        }
    }

    public void resetMatrixPositions(long l) {
        this.matrix_positions.clear();
        this.setMatrixEndPosition(l);
        this.clearMixedImage();
    }

    private void saveBMP(int[] nArray, int n, int n2, int n3, boolean bl) {
        Object object;
        int n4;
        int[] nArray2 = null;
        int n5 = n4 = (0xF & n) != 0 ? (n & 0xFFFFFFF0) + 16 : n;
        if (bl) {
            nArray2 = this.getScaledPixel(nArray, n, n2, this.aspectratio_table[n3]);
            if (nArray2 == null) {
                nArray2 = nArray;
            } else {
                n4 = n = (int)Math.round(this.aspectratio_table[n3] * (double)n2);
            }
        } else {
            nArray2 = nArray;
        }
        int n6 = n * n2;
        if (n6 <= 0) {
            return;
        }
        X_JFileChooser x_JFileChooser = CommonGui.getMainFileChooser();
        String string = String.valueOf(String.valueOf(x_JFileChooser.getCurrentDirectory())) + System.getProperty("file.separator") + "X_picture(" + this.bmpCount + ").bmp";
        x_JFileChooser.setSelectedFile(new File(string));
        x_JFileChooser.rescanCurrentDirectory();
        x_JFileChooser.setDialogTitle("save picture");
        int n7 = x_JFileChooser.showSaveDialog(this);
        if (n7 == 0) {
            object = x_JFileChooser.getSelectedFile();
            if (object != null && !((File)object).isDirectory()) {
                string = ((File)object).getAbsolutePath();
            }
        } else {
            return;
        }
        object = new byte[3];
        int n8 = (n & 3) != 0 ? n & 3 : 0;
        n6 = n * n2 * 3 + (n8 > 0 ? n8 * n2 : 0);
        this.littleEndian(this.bmpHead, 2, 54 + n6);
        this.littleEndian(this.bmpHead, 18, n);
        this.littleEndian(this.bmpHead, 22, n2);
        this.littleEndian(this.bmpHead, 34, n6);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 2048000);
            bufferedOutputStream.write(this.bmpHead);
            byte[] byArray = new byte[n8];
            int n9 = n2 - 1;
            while (n9 >= 0) {
                int n10 = n9 * n4;
                int n11 = 0;
                int n12 = 0;
                while (n11 < n) {
                    n12 = this.YUVtoRGB(nArray2[n11 + n10]);
                    int n13 = 0;
                    while (n13 < 3) {
                        object[n13] = (byte)(n12 >> (n13 << 3) & 0xFF);
                        ++n13;
                    }
                    bufferedOutputStream.write((byte[])object);
                    ++n11;
                }
                if (n8 > 0) {
                    bufferedOutputStream.write(byArray);
                }
                --n9;
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            ++this.bmpCount;
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    public void setFilterStatus(boolean bl) {
        this.isFilterActive = bl;
    }

    public void setMatrixEndPosition(long l) {
        this.matrix_positions.put("end", new Long(l));
    }

    public void setMatrixIndexPosition(int n, long l, String string) {
        this.matrix_positions.put(String.valueOf(n), new Long(l));
        this.matrix_positions.put(String.valueOf(String.valueOf(n)) + "TC", string);
    }

    public void setMatrixPreviewPixel(int n) {
        this.isMatrixImageAvailable = true;
        Common.getMpvDecoderClass().getScaledCutMatrixImage(this.mixed_image_array, this.matrix_new_width, this.matrix_new_height, this.matrix_table[n][0], this.matrix_table[n][1]);
        this.mixed_source.newPixels();
    }

    public void setMixedPreviewPixel(int[] nArray, int n) {
        this.isMixedImageAvailable = nArray != null && n > 0;
        String string = this.mixed_image_info = this.isMixedImageAvailable ? "CutImage Mix Mode: " + n * 100 / 255 + "%" : "";
        if (!this.isMixedImageAvailable) {
            this.clearMixedImage();
        } else {
            int n2 = 0;
            int n3 = this.mixed_image_array.length;
            while (n2 < n3) {
                this.mixed_image_array[n2] = 0xFFFFFF & nArray[n2] | n << 24;
                ++n2;
            }
        }
        this.isMatrixImageAvailable = false;
        this.mixed_source.newPixels();
    }

    public void setOSD(Object[] objectArray) {
        this.isOSDErrorInfo = false;
        this.setOSDMessage(objectArray);
    }

    public void setOSDMessage(String string, boolean bl) {
        this.isOSDErrorInfo = bl;
        this.setOSDMessage(new Object[]{bl ? "Fehler" : "Info", "", "", string});
    }

    public void setOSDMessage(Object[] objectArray) {
        this.setOSDMessage(objectArray, false);
    }

    public void setOSDMessage(Object[] objectArray, boolean bl) {
        this.OSDInfo = objectArray;
        this.isOSDInfoAvailable = true;
        this.showFileInfo = false;
        if (!bl) {
            this.startClock(10000);
        }
        this.repaint();
    }

    public void setPreviewSize(int n, int n2) {
        if (!Common.getSettings().getBooleanProperty(Keys.KEY_Preview_fullScaled)) {
            n = 512;
            n2 = 288;
        }
        if (n == this.imageSizeMin[0] && n2 == this.imageSizeMin[1]) {
            return;
        }
        this.imageSizeMin[0] = n;
        this.imageSizeMin[1] = n2;
        Common.getMpvDecoderClass().setPreviewSize(n, n2);
        this.source = new MemoryImageSource(this.imageSizeMin[0], this.imageSizeMin[1], Common.getMpvDecoderClass().getPreviewPixel(), 0, this.imageSizeMin[0]);
        this.source.setAnimated(true);
        this.image = this.createImage(this.source);
        this.source.newPixels();
    }

    public void setStreamInfo(StreamInfo streamInfo) {
        this.streamInfo = streamInfo.getNewInstance();
        this.showFileInfo = this.streamInfo != null;
        boolean bl = this.isThumbnailAvailable = this.showFileInfo && this.streamInfo.getThumbnail() != null && this.streamInfo.getThumbnail().length > 0;
        if (this.isThumbnailAvailable) {
            int[] nArray = this.streamInfo.getThumbnail();
            System.arraycopy(nArray, 0, this.thumb_image_array, 0, nArray.length);
            this.thumb_source.newPixels();
        }
        if (this.showFileInfo && !Common.getSettings().getBooleanProperty(Keys.KEY_holdStreamInfoOnOSD)) {
            this.startClock(10000);
        }
        this.isSubpictureAvailable = this.showFileInfo && this.streamInfo.getStreamType() == 16;
        this.loadSubpicture();
        this.isOSDInfoAvailable = false;
        this.isOSDErrorInfo = false;
        this.repaint();
    }

    public void showChapterIcon(Object[] objectArray, Object object) {
        List list = (List)object;
        if (!list.isEmpty()) {
            this.chapter_length = ((PreviewObject)list.get(list.size() - 1)).getEnd();
            if (objectArray != null) {
                this.chapter_points = new long[objectArray.length];
                int n = 0;
                while (n < this.chapter_points.length) {
                    this.chapter_points[n] = CommonParsing.parseCutValue(objectArray[n].toString(), false);
                    ++n;
                }
            } else {
                this.chapter_points = null;
            }
        } else {
            this.chapter_length = 0L;
            this.chapter_points = null;
        }
        this.repaint();
    }

    public void showCollectionNumber(int n) {
        this.collection_number = n;
        this.startClock();
        this.repaint();
    }

    public void showCutIcon(boolean bl, Object[] objectArray, Object object) {
        this.PLAY = bl;
        List list = (List)object;
        if (!list.isEmpty()) {
            this.cutfiles_length = ((PreviewObject)list.get(list.size() - 1)).getEnd();
            if (objectArray != null) {
                this.cutfiles_points = new long[objectArray.length];
                int n = 0;
                while (n < this.cutfiles_points.length) {
                    this.cutfiles_points[n] = CommonParsing.parseCutValue(objectArray[n].toString(), false);
                    ++n;
                }
            } else {
                this.cutfiles_points = null;
            }
        } else {
            this.cutfiles_length = 0L;
            this.cutfiles_points = null;
        }
        this.repaint();
    }

    public void startClock() {
        this.clock.start();
    }

    public void startClock(int n) {
        this.clock.start(n);
    }

    public void updatePreviewPixel() {
        this.source.newPixels();
    }

    private class Clock
    implements Runnable {
        private Thread clockThread = null;
        private int sleepAmount = 3000;

        Clock() {
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.clockThread == thread) {
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException interruptedException) {}
                if (this.update()) {
                    PicturePanel.this.repaint();
                }
                this.stop();
            }
        }

        public void start() {
            this.start(3000);
        }

        public void start(int n) {
            if (this.clockThread == null) {
                this.clockThread = new Thread((Runnable)this, "Clock_4");
                this.clockThread.setPriority(1);
                this.sleepAmount = n;
                this.clockThread.start();
            }
        }

        public void stop() {
            this.clockThread = null;
        }

        private boolean update() {
            boolean bl = false;
            if (PicturePanel.this.collection_number >= 0) {
                PicturePanel.this.collection_number = -1;
                bl = true;
            }
            if (PicturePanel.this.showFileInfo) {
                PicturePanel.this.showFileInfo = false;
                bl = true;
            }
            if (PicturePanel.this.isOSDInfoAvailable) {
                PicturePanel.this.isOSDInfoAvailable = false;
                bl = true;
            }
            return bl;
        }
    }
}

