/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.subtitle;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.util.Arrays;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class Sup2VobSub {
    private PushbackInputStream inputstream;
    private BufferedOutputStream outputstream;
    private PrintWriter printstream;
    private XInputFile xInputFile;
    private String outputfile_sub;
    private String outputfile_idx;
    private long file_length;
    private long read_position;
    private long write_position;
    private long pts_value;
    private int buffersize = 12;
    private int packetsize = 65535;
    private int packsize = 2048;
    private int packetlength;
    private int startoffset;
    private byte[] sup_packet;
    private byte[] export_pack;
    private byte[] pack_header;
    private byte[] pes_header;
    private byte[] padding_header;
    private byte[] pes_extension1;
    private byte[] pes_extension2;
    private byte stream_id;

    private Sup2VobSub() {
        byte[] byArray = new byte[14];
        byArray[2] = 1;
        byArray[3] = -70;
        byArray[4] = 68;
        byArray[5] = 2;
        byArray[6] = -60;
        byArray[7] = -126;
        byArray[8] = 4;
        byArray[9] = -87;
        byArray[10] = 1;
        byArray[11] = -119;
        byArray[12] = -61;
        byArray[13] = -8;
        this.pack_header = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[2] = 1;
        byArray2[3] = -67;
        this.pes_header = byArray2;
        byte[] byArray3 = new byte[6];
        byArray3[2] = 1;
        byArray3[3] = -66;
        this.padding_header = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = -127;
        byArray4[1] = -128;
        byArray4[2] = 5;
        this.pes_extension1 = byArray4;
        byte[] byArray5 = new byte[3];
        byArray5[0] = -128;
        this.pes_extension2 = byArray5;
        this.stream_id = (byte)32;
    }

    public Sup2VobSub(String string) {
        byte[] byArray = new byte[14];
        byArray[2] = 1;
        byArray[3] = -70;
        byArray[4] = 68;
        byArray[5] = 2;
        byArray[6] = -60;
        byArray[7] = -126;
        byArray[8] = 4;
        byArray[9] = -87;
        byArray[10] = 1;
        byArray[11] = -119;
        byArray[12] = -61;
        byArray[13] = -8;
        this.pack_header = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[2] = 1;
        byArray2[3] = -67;
        this.pes_header = byArray2;
        byte[] byArray3 = new byte[6];
        byArray3[2] = 1;
        byArray3[3] = -66;
        this.padding_header = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = -127;
        byArray4[1] = -128;
        byArray4[2] = 5;
        this.pes_extension1 = byArray4;
        byte[] byArray5 = new byte[3];
        byArray5[0] = -128;
        this.pes_extension2 = byArray5;
        this.stream_id = (byte)32;
        if (this.init(string)) {
            this.parseStream();
        }
    }

    public Sup2VobSub(String string, Object[] objectArray) {
        byte[] byArray = new byte[14];
        byArray[2] = 1;
        byArray[3] = -70;
        byArray[4] = 68;
        byArray[5] = 2;
        byArray[6] = -60;
        byArray[7] = -126;
        byArray[8] = 4;
        byArray[9] = -87;
        byArray[10] = 1;
        byArray[11] = -119;
        byArray[12] = -61;
        byArray[13] = -8;
        this.pack_header = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[2] = 1;
        byArray2[3] = -67;
        this.pes_header = byArray2;
        byte[] byArray3 = new byte[6];
        byArray3[2] = 1;
        byArray3[3] = -66;
        this.padding_header = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = -127;
        byArray4[1] = -128;
        byArray4[2] = 5;
        this.pes_extension1 = byArray4;
        byte[] byArray5 = new byte[3];
        byArray5[0] = -128;
        this.pes_extension2 = byArray5;
        this.stream_id = (byte)32;
        if (this.init(string, objectArray)) {
            this.parseStream();
        }
    }

    private void closeStreams() {
        try {
            this.inputstream.close();
            this.outputstream.flush();
            this.outputstream.close();
            this.printstream.flush();
            this.printstream.close();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    private boolean init(String string) {
        return this.init(string, null);
    }

    private boolean init(String string, Object[] objectArray) {
        boolean bl = false;
        this.xInputFile = new XInputFile(new File(string));
        this.file_length = this.xInputFile.length();
        this.read_position = 0L;
        this.write_position = 0L;
        if (!this.initStreams()) {
            return bl;
        }
        this.initIndex(objectArray);
        this.sup_packet = new byte[this.packetsize];
        this.export_pack = new byte[this.packsize];
        System.arraycopy(this.pack_header, 0, this.export_pack, 0, this.pack_header.length);
        System.arraycopy(this.pes_header, 0, this.export_pack, this.pack_header.length, this.pes_header.length);
        return bl ^ true;
    }

    private void initIndex(Object[] objectArray) {
        this.printstream.println("# VobSub index file, v7 (do not modify this line!)");
        this.printstream.println("size: 720x576");
        this.printstream.println("org: 0, 0");
        this.printstream.println("scale: 100%, 100%");
        this.printstream.println("alpha: 100%");
        this.printstream.println("smooth: OFF");
        this.printstream.println("fadein/out: 0, 0");
        this.printstream.println("align: OFF at LEFT TOP");
        this.printstream.println("time offset: 0");
        this.printstream.println("forced subs: OFF");
        this.printColourTable(objectArray);
        this.printstream.println("custom colors: OFF, tridx: 1000, colors: 600000, 101010, ffffff, a9a9a9");
        this.printstream.println("langidx: 0");
        this.printstream.println("id: --, index: 0");
        this.printstream.println("");
    }

    private boolean initStreams() {
        boolean bl = false;
        try {
            this.outputfile_sub = String.valueOf(String.valueOf(this.xInputFile)) + ".sub";
            this.outputfile_idx = String.valueOf(String.valueOf(this.xInputFile)) + ".idx";
            this.inputstream = new PushbackInputStream(this.xInputFile.getInputStream(), this.buffersize);
            this.outputstream = new BufferedOutputStream(new FileOutputStream(this.outputfile_sub), 1024000);
            this.printstream = new PrintWriter(new FileOutputStream(this.outputfile_idx));
            Common.setMessage("");
            Common.setMessage("-> create VobSub Files (idx + sub) : " + this.outputfile_sub);
            return bl ^ true;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
            return bl;
        }
    }

    private boolean nextStartCode() {
        boolean bl = false;
        this.startoffset = 0;
        this.readData(this.startoffset, this.buffersize);
        if (this.sup_packet[this.startoffset] != 83 || this.sup_packet[this.startoffset + 1] != 80) {
            this.unreadData(1, this.buffersize - 1);
            return bl;
        }
        this.startoffset += 2;
        return bl ^ true;
    }

    private void parseStream() {
        while (this.read_position < this.file_length) {
            while (!this.nextStartCode()) {
            }
            if (!this.readPicture()) continue;
            this.writePicture();
        }
        this.closeStreams();
    }

    private void printColourTable(Object[] objectArray) {
        int n = 16;
        this.printstream.print("palette: ");
        String[] stringArray = new String[]{"600000", "101010", "ffffff", "a9a9a9", "4d4d4d", "d7d7d7", "d7d7d7", "d7d7d7", "d7d7d7", "d7d7d7", "d7d7d7", "d7d7d7", "d7d7d7", "d7d7d7", "d7d7d7", "d7d7d7"};
        if (objectArray == null) {
            objectArray = new Object[]{};
        } else {
            int n2 = 0;
            int n3 = objectArray.length;
            while (n2 < n3 && n2 < n) {
                this.printstream.print(String.valueOf(Common.adaptString(Integer.toHexString(0xFFFFFF & Integer.parseInt(objectArray[n2].toString())), 6)));
                if (n2 < n - 1) {
                    this.printstream.print(", ");
                }
                ++n2;
            }
            int n4 = objectArray.length;
            int n5 = stringArray.length;
            while (n4 < n5 && n4 < n) {
                this.printstream.print(String.valueOf(Common.adaptString(stringArray[n4], 6)));
                if (n4 < n - 1) {
                    this.printstream.print(", ");
                }
                ++n4;
            }
        }
        this.printstream.println();
    }

    private int readData(int n, int n2) {
        int n3 = 0;
        try {
            n3 = this.inputstream.read(this.sup_packet, n, n2);
            this.read_position += (long)n3;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        return n3;
    }

    private boolean readPicture() {
        boolean bl = false;
        int n = 0;
        int n2 = 8;
        int n3 = 2;
        this.pts_value = CommonParsing.readPTS(this.sup_packet, this.startoffset, n2, true, false);
        this.startoffset += n2;
        this.packetlength = CommonParsing.getIntValue(this.sup_packet, this.startoffset, n3, false);
        n = this.readData(this.buffersize, this.packetlength - n3);
        if (n < this.packetlength - n3) {
            Common.setMessage("!> packet too short");
            return bl;
        }
        return bl ^ true;
    }

    private int unreadData(int n, int n2) {
        try {
            this.inputstream.unread(this.sup_packet, n, n2);
            this.read_position -= (long)n2;
            return n2;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
            return 0;
        }
    }

    private void writeData() {
        try {
            this.outputstream.write(this.export_pack);
            this.write_position += (long)this.packsize;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    private int writeFirstPack(int n) {
        if (n >= this.packetlength) {
            return -1;
        }
        int n2 = this.packsize - this.pack_header.length - this.pes_header.length - this.pes_extension1.length - 1;
        int n3 = this.packetlength - n >= n2 ? n2 : this.packetlength - n;
        int n4 = n2 - n3;
        int n5 = this.pes_extension1.length + 1;
        System.arraycopy(this.pes_extension1, 0, this.export_pack, this.pack_header.length + this.pes_header.length, this.pes_extension1.length);
        if (n4 <= this.padding_header.length) {
            Arrays.fill(this.export_pack, this.pack_header.length + this.pes_header.length + this.pes_extension1.length, this.pack_header.length + this.pes_header.length + this.pes_extension1.length + n4, (byte)-1);
            CommonParsing.setPES_LengthField(this.export_pack, this.pack_header.length, (n5 += n4) + n3);
            CommonParsing.setValue(this.export_pack, this.pack_header.length + this.pes_header.length + 2, 1, false, 5 + n4);
            CommonParsing.setPES_PTSField(this.export_pack, this.pack_header.length, this.pts_value);
            CommonParsing.setPES_SubIdField(this.export_pack, this.pack_header.length, this.pes_header.length, this.pes_extension1.length + n4, this.stream_id);
        } else {
            System.arraycopy(this.padding_header, 0, this.export_pack, this.pack_header.length + this.pes_header.length + n5 + n3, this.padding_header.length);
            CommonParsing.setPES_LengthField(this.export_pack, this.pack_header.length + this.pes_header.length + n5 + n3, n4 - this.padding_header.length);
            Arrays.fill(this.export_pack, this.pack_header.length + this.pes_header.length + n5 + n3 + this.padding_header.length, this.packsize, (byte)-1);
            CommonParsing.setPES_LengthField(this.export_pack, this.pack_header.length, n5 + n3);
            CommonParsing.setPES_PTSField(this.export_pack, this.pack_header.length, this.pts_value);
            CommonParsing.setPES_SubIdField(this.export_pack, this.pack_header.length, this.pes_header.length, this.pes_extension1.length, this.stream_id);
        }
        System.arraycopy(this.sup_packet, this.startoffset + n, this.export_pack, this.pack_header.length + this.pes_header.length + n5, n3);
        this.writeData();
        return n += n3;
    }

    private void writePicture() {
        int n = 0;
        this.writePictureIndex();
        n = this.writeFirstPack(n);
        while (n > 0) {
            n = this.writeSubPack(n);
        }
    }

    private void writePictureIndex() {
        this.printstream.print("timestamp: " + Common.formatTime_2a(this.pts_value / 90L) + ", ");
        this.printstream.println("filepos: " + Common.adaptString(Long.toHexString(this.write_position), 9));
    }

    private int writeSubPack(int n) {
        if (n >= this.packetlength) {
            return -1;
        }
        int n2 = this.packsize - this.pack_header.length - this.pes_header.length - this.pes_extension2.length - 1;
        int n3 = this.packetlength - n >= n2 ? n2 : this.packetlength - n;
        int n4 = n2 - n3;
        int n5 = this.pes_extension2.length + 1;
        System.arraycopy(this.pes_extension2, 0, this.export_pack, this.pack_header.length + this.pes_header.length, this.pes_extension2.length);
        if (n4 <= this.padding_header.length) {
            Arrays.fill(this.export_pack, this.pack_header.length + this.pes_header.length + this.pes_extension2.length, this.pack_header.length + this.pes_header.length + this.pes_extension2.length + n4, (byte)-1);
            CommonParsing.setPES_LengthField(this.export_pack, this.pack_header.length, (n5 += n4) + n3);
            CommonParsing.setValue(this.export_pack, this.pack_header.length + this.pes_header.length + 2, 1, false, n4);
            CommonParsing.setPES_SubIdField(this.export_pack, this.pack_header.length, this.pes_header.length, this.pes_extension2.length + n4, this.stream_id);
        } else {
            System.arraycopy(this.padding_header, 0, this.export_pack, this.pack_header.length + this.pes_header.length + n5 + n3, this.padding_header.length);
            CommonParsing.setPES_LengthField(this.export_pack, this.pack_header.length + this.pes_header.length + n5 + n3, n4 - this.padding_header.length);
            Arrays.fill(this.export_pack, this.pack_header.length + this.pes_header.length + n5 + n3 + this.padding_header.length, this.packsize, (byte)-1);
            CommonParsing.setPES_LengthField(this.export_pack, this.pack_header.length, n3 + n5);
            CommonParsing.setPES_SubIdField(this.export_pack, this.pack_header.length, this.pes_header.length, this.pes_extension2.length, this.stream_id);
        }
        System.arraycopy(this.sup_packet, this.startoffset + n, this.export_pack, this.pack_header.length + this.pes_header.length + n5, n3);
        this.writeData();
        return n += n3;
    }
}

