from ExperimentObjects import *

ourExp = Experiment()
#the following are the sort of commands that should be generated by GUI
#create a new procedure (main time-line panel)
ourExp.addProcedure('trial')

#add events (stimuli or keyboard checking etc...)
ourExp.procs['trial'].append( 
    EventPatch(name='fixation', image=None, 
        size=0.5, pos=[0,0],ori=0,
        onTimes=[(0,1), (1.5,2.0)],#on twice
        )
    )
ourExp.procs['trial'].append(
    EventPatch(name='face', image='face.jpg', 
        size=3.0, pos=[0,0], ori=45,
        onTimes=[(1.0,1.5)],#on just once
        )
    )
    
trialInfo = [ {'ori':5, 'sf':1.5}, {'ori':2, 'sf':1.5},{'ori':5, 'sf':3}, ]  
#insert the procedure into the flow (so that it gets used)    
ourExp.flow.addProcedure(
    ourExp.procs['trial'], pos=1)
#also add a trial handler (a loop, basically)
ourExp.flow.addLoop(
    LoopHandler(name='trials', loopType='simple', nReps=5, trialList = trialInfo),
    startPos=0.5, endPos=1.5,#specify positions relative to the
    )
    
print ourExp.generateScript().getvalue()