/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.changed_lines;

import java.util.ArrayList;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.python.pydev.changed_lines.LineComparator;
import org.python.pydev.core.log.Log;

public class ChangedLinesComputer {
    public static IRegion[] calculateChangedLineRegions(ITextFileBuffer buffer, IProgressMonitor monitor) throws CoreException {
        IRegion[] result = null;
        try {
            monitor.beginTask("Calculating changed lines", 20);
            IFileStore fileStore = buffer.getFileStore();
            ITextFileBufferManager fileBufferManager = FileBuffers.createTextFileBufferManager();
            fileBufferManager.connectFileStore(fileStore, ChangedLinesComputer.getSubProgressMonitor(monitor, 15));
            try {
                IDocument currentDocument = buffer.getDocument();
                IDocument oldDocument = ((ITextFileBuffer)fileBufferManager.getFileStoreFileBuffer(fileStore)).getDocument();
                result = ChangedLinesComputer.getChangedLineRegions(oldDocument, currentDocument);
            }
            finally {
                fileBufferManager.disconnectFileStore(fileStore, ChangedLinesComputer.getSubProgressMonitor(monitor, 5));
                monitor.done();
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
        return result;
    }

    private static IRegion[] getChangedLineRegions(IDocument oldDocument, IDocument currentDocument) throws BadLocationException {
        LineComparator leftSide = new LineComparator(oldDocument);
        LineComparator rightSide = new LineComparator(currentDocument);
        RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)leftSide, (IRangeComparator)rightSide);
        ArrayList<Object> regions = new ArrayList<Object>();
        int i = 0;
        while (i < differences.length) {
            RangeDifference curr = differences[i];
            if (curr.kind() == 2 && curr.rightLength() > 0) {
                int startLine = curr.rightStart();
                int endLine = curr.rightEnd() - 1;
                IRegion startLineRegion = currentDocument.getLineInformation(startLine);
                if (startLine == endLine) {
                    regions.add(startLineRegion);
                } else {
                    IRegion endLineRegion = currentDocument.getLineInformation(endLine);
                    int startOffset = startLineRegion.getOffset();
                    int endOffset = endLineRegion.getOffset() + endLineRegion.getLength();
                    regions.add(new Region(startOffset, endOffset - startOffset));
                }
            }
            ++i;
        }
        return regions.toArray(new IRegion[regions.size()]);
    }

    private static IProgressMonitor getSubProgressMonitor(IProgressMonitor monitor, int ticks) {
        if (monitor != null) {
            return new SubProgressMonitor(monitor, ticks, 4);
        }
        return new NullProgressMonitor();
    }
}

