/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.lang.ref.WeakReference;
import java.util.ListResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.python.pydev.core.callbacks.CallbackWithListeners;
import org.python.pydev.editor.ICodeScannerKeywords;
import org.python.pydev.editor.IPyEditListener;
import org.python.pydev.editor.IPyEditListener3;
import org.python.pydev.editor.PyCodeScanner;
import org.python.pydev.editor.PyEdit;

public class PyEditBasedCodeScannerKeywords
implements ICodeScannerKeywords {
    private WeakReference<PyEdit> edit;
    private final CallbackWithListeners callbackWithListeners = new CallbackWithListeners();

    public PyEditBasedCodeScannerKeywords(PyEdit pyEdit) {
        this.edit = new WeakReference<PyEdit>(pyEdit);
        pyEdit.addPyeditListener(new CythonStatusChangeNotifier(this));
    }

    public CallbackWithListeners getOnChangeCallbackWithListeners() {
        return this.callbackWithListeners;
    }

    public String[] getKeywords() {
        PyEdit pyEdit = (PyEdit)this.edit.get();
        if (pyEdit.isCythonFile()) {
            return PyCodeScanner.CYTHON_KEYWORDS;
        }
        return PyCodeScanner.DEFAULT_KEYWORDS;
    }

    private static class CythonStatusChangeNotifier
    implements IPyEditListener,
    IPyEditListener3 {
        private WeakReference<CallbackWithListeners> ref;
        private boolean currentIsCythonFile;

        public CythonStatusChangeNotifier(PyEditBasedCodeScannerKeywords pyEditBasedCodeScannerKeywords) {
            this.ref = new WeakReference<CallbackWithListeners>(pyEditBasedCodeScannerKeywords.callbackWithListeners);
            PyEdit pyEdit = (PyEdit)pyEditBasedCodeScannerKeywords.edit.get();
            this.currentIsCythonFile = pyEdit.isCythonFile();
        }

        public void onInputChanged(PyEdit edit, IEditorInput oldInput, IEditorInput input, IProgressMonitor monitor) {
            boolean cythonFile = edit.isCythonFile();
            if (cythonFile != this.currentIsCythonFile) {
                this.currentIsCythonFile = cythonFile;
                CallbackWithListeners callbackWithListeners = (CallbackWithListeners)this.ref.get();
                if (callbackWithListeners != null) {
                    callbackWithListeners.call(null);
                } else {
                    edit.removePyeditListener(this);
                }
            }
        }

        public void onSave(PyEdit edit, IProgressMonitor monitor) {
        }

        public void onCreateActions(ListResourceBundle resources, PyEdit edit, IProgressMonitor monitor) {
        }

        public void onDispose(PyEdit edit, IProgressMonitor monitor) {
        }

        public void onSetDocument(IDocument document, PyEdit edit, IProgressMonitor monitor) {
        }
    }
}

