/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PyPartitionScanner;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyCodeScanner;
import org.python.pydev.editor.actions.PyFormatStd;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.ColorAndStyleCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledTextForShowingCodeFactory
implements IPropertyChangeListener {
    private StyledText styledText;
    private ColorAndStyleCache backgroundColorCache;
    private ColorAndStyleCache colorCache;

    public StyledText createStyledTextForCodePresentation(Composite parent) {
        this.styledText = new StyledText(parent, 2056);
        this.backgroundColorCache = new ColorAndStyleCache((IPreferenceStore)new PreferenceStore());
        this.colorCache = new ColorAndStyleCache(null);
        try {
            FontData labelFontData = new FontData("Courier New", 10, 0);
            this.styledText.setFont(new Font((Device)parent.getDisplay(), labelFontData));
        }
        catch (Throwable throwable) {}
        this.updateBackgroundColor();
        PydevPrefs.getChainedPrefStore().addPropertyChangeListener((IPropertyChangeListener)this);
        return this.styledText;
    }

    private void updateBackgroundColor() {
        IPreferenceStore chainedPrefStore = PydevPrefs.getChainedPrefStore();
        Color backgroundColor = null;
        if (!chainedPrefStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault")) {
            RGB backgroundRGB = PreferenceConverter.getColor((IPreferenceStore)chainedPrefStore, (String)"AbstractTextEditor.Color.Background");
            backgroundColor = this.backgroundColorCache.getColor(backgroundRGB);
        }
        this.styledText.setBackground(backgroundColor);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if ("AbstractTextEditor.Color.Background".equals(prop) || "AbstractTextEditor.Color.Background.SystemDefault".equals(prop)) {
            this.updateBackgroundColor();
        }
    }

    public void dispose() {
        PydevPrefs.getChainedPrefStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.backgroundColorCache.dispose();
        this.colorCache.dispose();
    }

    public Tuple<String, StyleRange[]> formatAndGetStyleRanges(PyFormatStd.FormatStd formatStd, String str, IPreferenceStore prefs, boolean showSpacesAndNewLines) {
        this.colorCache.setPreferences(prefs);
        PyFormatStd formatter = new PyFormatStd();
        try {
            str = formatter.formatStr(str, formatStd, "\n", false);
        }
        catch (SyntaxErrorException syntaxErrorException) {}
        FastStringBuffer buf = new FastStringBuffer();
        for (String line : StringUtils.splitInLines((String)str)) {
            buf.append(line);
            char c = buf.lastChar();
            if (c != '\n') continue;
            buf.deleteLast();
            if (showSpacesAndNewLines) {
                buf.append("\\n");
            }
            buf.appendN('|', 8);
            buf.append(c);
        }
        String result = buf.toString();
        String finalResult = showSpacesAndNewLines ? result.replace(' ', '.') : result;
        finalResult = finalResult.replace('|', ' ');
        PyPartitionScanner pyPartitionScanner = new PyPartitionScanner();
        FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)pyPartitionScanner, IPythonPartitions.types);
        Document doc = new Document(result);
        fastPartitioner.connect((IDocument)doc);
        TextPresentation textPresentation = new TextPresentation();
        PyCodeScanner scanner = new PyCodeScanner(this.colorCache);
        try {
            ITypedRegion[] computePartitioning;
            ITypedRegion[] iTypedRegionArray = computePartitioning = fastPartitioner.computePartitioning(0, doc.getLength());
            int n = computePartitioning.length;
            int n2 = 0;
            while (n2 < n) {
                TextAttribute textAttribute;
                ITypedRegion region = iTypedRegionArray[n2];
                String type = region.getType();
                int offset = region.getOffset();
                int len = region.getLength();
                if ("__dftl_partition_content_type".equals(type) || type == null) {
                    this.createDefaultRanges(textPresentation, scanner, doc, offset, len);
                } else if ("__python_comment".equals(type)) {
                    textAttribute = this.colorCache.getCommentTextAttribute();
                    textPresentation.addStyleRange(new StyleRange(offset, len, textAttribute.getForeground(), null, textAttribute.getStyle()));
                } else if ("__python_backquotes".equals(type)) {
                    textAttribute = this.colorCache.getBackquotesTextAttribute();
                    textPresentation.addStyleRange(new StyleRange(offset, len, textAttribute.getForeground(), null, textAttribute.getStyle()));
                } else if ("__python_multiline_string1".equals(type) || "__python_multiline_string2".equals(type) || "__python_singleline_string1".equals(type) || "__python_singleline_string2".equals(type)) {
                    textAttribute = this.colorCache.getStringTextAttribute();
                    textPresentation.addStyleRange(new StyleRange(offset, len, textAttribute.getForeground(), null, textAttribute.getStyle()));
                }
                ++n2;
            }
        }
        finally {
            fastPartitioner.disconnect();
        }
        if (showSpacesAndNewLines) {
            int i = 0;
            while (i < result.length()) {
                char curr = result.charAt(i);
                if (curr == '\\' && i + 1 < result.length() && result.charAt(i + 1) == 'n') {
                    textPresentation.mergeStyleRange(new StyleRange(i, 2, this.colorCache.getColor(new RGB(180, 180, 180)), null));
                    ++i;
                } else if (curr == ' ') {
                    int finalI = i;
                    while (finalI < result.length() && result.charAt(finalI) == ' ') {
                        ++finalI;
                    }
                    textPresentation.mergeStyleRange(new StyleRange(i, finalI - i, this.colorCache.getColor(new RGB(180, 180, 180)), null));
                }
                ++i;
            }
        }
        ArrayList<StyleRange> list = new ArrayList<StyleRange>();
        Iterator it = textPresentation.getAllStyleRangeIterator();
        while (it.hasNext()) {
            list.add((StyleRange)it.next());
        }
        StyleRange[] ranges = list.toArray(new StyleRange[list.size()]);
        return new Tuple((Object)finalResult, (Object)ranges);
    }

    private void createDefaultRanges(TextPresentation textPresentation, PyCodeScanner scanner, Document doc, int partitionOffset, int partitionLen) {
        scanner.setRange((IDocument)doc, partitionOffset, partitionLen);
        IToken nextToken = scanner.nextToken();
        while (!nextToken.isEOF()) {
            Object data = nextToken.getData();
            if (data instanceof TextAttribute) {
                TextAttribute textAttribute = (TextAttribute)data;
                int offset = scanner.getTokenOffset();
                int len = scanner.getTokenLength();
                Color foreground = textAttribute.getForeground();
                Color background = textAttribute.getBackground();
                int style = textAttribute.getStyle();
                textPresentation.addStyleRange(new StyleRange(offset, len, foreground, background, style));
            }
            nextToken = scanner.nextToken();
        }
    }
}

