/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.autoedit.DocCmd;
import org.python.pydev.editor.autoedit.PyAutoIndentStrategy;

public abstract class PyMoveLineAction
extends TextEditorAction {
    protected PyEdit pyEdit;

    protected PyMoveLineAction(ResourceBundle bundle, String prefix, PyEdit editor) {
        super(bundle, prefix, (ITextEditor)editor);
        this.pyEdit = editor;
        this.update();
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    public void run() {
        if (this.pyEdit == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        ISourceViewer viewer = this.pyEdit.getEditorSourceViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        StyledText widget = viewer.getTextWidget();
        if (widget == null) {
            return;
        }
        ITextSelection sel = (ITextSelection)viewer.getSelectionProvider().getSelection();
        this.move(this.pyEdit, viewer, document, sel);
    }

    public void move(PyEdit pyEdit, ISourceViewer viewer, IDocument document, ITextSelection sel) {
        if (sel.isEmpty()) {
            return;
        }
        ITextSelection skippedLine = this.getSkippedLine(document, sel);
        if (skippedLine == null) {
            return;
        }
        try {
            LineRange selectionAfter;
            ITextSelection movingArea;
            try {
                movingArea = this.getMovingSelection(document, sel);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (!this.containedByVisibleRegion(movingArea, viewer) || !this.containedByVisibleRegion(skippedLine, viewer)) {
                return;
            }
            PySelection skippedPs = new PySelection(document, skippedLine);
            String moving = movingArea.getText();
            String skipped = skippedLine.getText();
            if (moving == null || skipped == null || document.getLength() == 0) {
                return;
            }
            ILineRange selectionBefore = this.getLineRange(document, movingArea);
            IRewriteTarget target = null;
            if (pyEdit != null && (target = (IRewriteTarget)pyEdit.getAdapter(IRewriteTarget.class)) != null) {
                target.beginCompoundChange();
                if (!this.getMoveUp()) {
                    target.setRedraw(false);
                }
            }
            try {
                String prevExpectedIndent;
                int length;
                int offset;
                String delim;
                boolean isStringPartition;
                if (this.getMoveUp()) {
                    isStringPartition = ParsingUtils.isStringPartition((IDocument)document, (int)skippedLine.getOffset());
                    delim = document.getLineDelimiter(skippedLine.getEndLine());
                    Assert.isNotNull((Object)delim);
                    offset = skippedLine.getOffset();
                    length = moving.length() + delim.length() + skipped.length();
                } else {
                    int offsetToCheckPartition = skippedLine.getEndLine() == document.getNumberOfLines() - 1 ? document.getLength() - 1 : skippedLine.getOffset() + skippedLine.getLength();
                    isStringPartition = ParsingUtils.isStringPartition((IDocument)document, (int)offsetToCheckPartition);
                    delim = document.getLineDelimiter(movingArea.getEndLine());
                    Assert.isNotNull((Object)delim);
                    offset = movingArea.getOffset();
                    document.replace(movingArea.getOffset(), movingArea.getLength() + delim.length(), "");
                    length = skipped.length();
                    int pos = skippedPs.getAbsoluteCursorOffset() - (movingArea.getLength() + delim.length());
                    skippedPs.setSelection(pos, pos);
                }
                PyAutoIndentStrategy indentStrategy = null;
                if (pyEdit != null) {
                    indentStrategy = pyEdit.getAutoEditStrategy();
                }
                if (indentStrategy == null) {
                    indentStrategy = new PyAutoIndentStrategy();
                }
                if (!isStringPartition && indentStrategy.getIndentPrefs().getSmartLineMove() && (prevExpectedIndent = this.calculateNewIndentationString(document, skippedPs, indentStrategy)) != null) {
                    moving = StringUtils.removeWhitespaceColumnsToLeftAndApplyIndent((String)moving, (String)prevExpectedIndent, (boolean)false);
                }
                String insertion = this.getMoveUp() ? String.valueOf(moving) + delim + skipped : String.valueOf(skipped) + delim + moving;
                document.replace(offset, length, insertion);
                selectionAfter = this.getMoveUp() ? new LineRange(selectionBefore.getStartLine() - 1, selectionBefore.getNumberOfLines()) : new LineRange(selectionBefore.getStartLine() + 1, selectionBefore.getNumberOfLines());
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                    if (!this.getMoveUp()) {
                        target.setRedraw(true);
                    }
                }
            }
            IRegion region = this.getRegion(document, (ILineRange)selectionAfter);
            this.selectAndReveal((ITextViewer)viewer, region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
            return;
        }
    }

    private String calculateNewIndentationString(IDocument document, PySelection skippedPs, PyAutoIndentStrategy indentStrategy) throws BadLocationException {
        int cursorLine;
        int line = cursorLine = skippedPs.getCursorLine();
        if (this.getMoveUp()) {
            if (cursorLine == 0) {
                String cursorLineContents = skippedPs.getCursorLineContents();
                int firstCharPosition = PySelection.getFirstCharPosition((String)cursorLineContents);
                return cursorLineContents.substring(0, firstCharPosition);
            }
            line = cursorLine - 1;
            if (line < 0) {
                return null;
            }
        }
        String line2 = skippedPs.getLine(line);
        while (line > 0 && (line2.startsWith("#") || line2.trim().length() == 0)) {
            line2 = skippedPs.getLine(--line);
        }
        DocCmd command = new DocCmd(skippedPs.getEndLineOffset(line), 0, "\n");
        indentStrategy.customizeDocumentCommand(document, command);
        return command.text.substring(1);
    }

    private ILineRange getLineRange(IDocument document, ITextSelection selection) throws BadLocationException {
        int offset = selection.getOffset();
        int startLine = document.getLineOfOffset(offset);
        int endOffset = offset + selection.getLength();
        int endLine = document.getLineOfOffset(endOffset);
        int nLines = endLine - startLine + 1;
        return new LineRange(startLine, nLines);
    }

    private void selectAndReveal(ITextViewer viewer, int offset, int length) {
        if (viewer == null) {
            return;
        }
        viewer.setSelectedRange(offset + length, -length);
        StyledText st = viewer.getTextWidget();
        if (st != null) {
            st.showSelection();
        }
    }

    private IRegion getRegion(IDocument document, ILineRange lineRange) throws BadLocationException {
        int endOffset;
        int startLine = lineRange.getStartLine();
        int offset = document.getLineOffset(startLine);
        int numberOfLines = lineRange.getNumberOfLines();
        if (numberOfLines < 1) {
            return new Region(offset, 0);
        }
        int endLine = startLine + numberOfLines - 1;
        boolean blockSelectionModeEnabled = false;
        try {
            blockSelectionModeEnabled = ((AbstractTextEditor)this.getTextEditor()).isBlockSelectionModeEnabled();
        }
        catch (Throwable throwable) {}
        if (blockSelectionModeEnabled) {
            IRegion endLineInfo = document.getLineInformation(endLine);
            endOffset = endLineInfo.getOffset() + endLineInfo.getLength();
        } else {
            endOffset = document.getLineOffset(endLine) + document.getLineLength(endLine);
        }
        return new Region(offset, endOffset - offset);
    }

    protected abstract boolean getMoveUp();

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor());
        }
    }

    private ITextSelection getSkippedLine(IDocument document, ITextSelection selection) {
        int skippedLineN;
        int n = skippedLineN = this.getMoveUp() ? selection.getStartLine() - 1 : selection.getEndLine() + 1;
        if (skippedLineN > document.getNumberOfLines() || skippedLineN < 0 || skippedLineN == document.getNumberOfLines()) {
            return null;
        }
        try {
            IRegion line = document.getLineInformation(skippedLineN);
            return new TextSelection(document, line.getOffset(), line.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private ITextSelection getMovingSelection(IDocument document, ITextSelection selection) throws BadLocationException {
        int low = document.getLineOffset(selection.getStartLine());
        int endLine = selection.getEndLine();
        int high = document.getLineOffset(endLine) + document.getLineLength(endLine);
        String delim = document.getLineDelimiter(endLine);
        if (delim != null) {
            high -= delim.length();
        }
        return new TextSelection(document, low, high - low);
    }

    private boolean containedByVisibleRegion(ITextSelection selection, ISourceViewer viewer) {
        block8: {
            int visEnd;
            IDocument document;
            int max;
            block9: {
                int visOffset;
                IRegion visible;
                block6: {
                    int min;
                    block7: {
                        if (viewer == null) {
                            return true;
                        }
                        min = selection.getOffset();
                        max = min + selection.getLength();
                        document = viewer.getDocument();
                        visible = viewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)viewer).getModelCoverage() : viewer.getVisibleRegion();
                        visOffset = visible.getOffset();
                        try {
                            if (visOffset <= min) break block6;
                            if (document.getLineOfOffset(visOffset) == selection.getStartLine()) break block7;
                            return false;
                        }
                        catch (BadLocationException badLocationException) {
                            return false;
                        }
                    }
                    if (this.isWhitespace(document.get(min, visOffset - min))) break block6;
                    this.showStatus();
                    return false;
                }
                visEnd = visOffset + visible.getLength();
                if (visEnd >= max) break block8;
                if (document.getLineOfOffset(visEnd) == selection.getEndLine()) break block9;
                return false;
            }
            if (this.isWhitespace(document.get(visEnd, max - visEnd))) break block8;
            this.showStatus();
            return false;
        }
        return true;
    }

    private boolean isWhitespace(String string) {
        return string == null ? true : string.trim().length() == 0;
    }

    private void showStatus() {
        ITextEditor textEditor = this.getTextEditor();
        IEditorStatusLine status = (IEditorStatusLine)textEditor.getAdapter(IEditorStatusLine.class);
        if (status == null) {
            return;
        }
        status.setMessage(false, "Move not possible - Uncheck \"Show Source of Selected Element Only\" to see the entire document", null);
    }
}

