/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.ide.IDE;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.ModulesFoundStructure;
import org.python.pydev.plugin.nature.IPythonPathHelper;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;
import org.python.pydev.utils.PyFileListing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonPathHelper
implements IPythonPathHelper {
    private final List<String> pythonpath = new ArrayList<String>();

    public static String getDefaultPathStr(String str) {
        return StringUtils.replaceAllSlashes((String)str.trim());
    }

    public static PyFileListing getModulesBelow(File root, IProgressMonitor monitor) {
        if (!root.exists()) {
            return null;
        }
        if (root.isDirectory()) {
            FileFilter filter = new FileFilter(){

                public boolean accept(File pathname) {
                    if (pathname.isFile()) {
                        return PythonPathHelper.isValidFileMod(REF.getFileAbsolutePath((File)pathname));
                    }
                    if (pathname.isDirectory()) {
                        return PythonPathHelper.isFileOrFolderWithInit(pathname);
                    }
                    return false;
                }
            };
            return PyFileListing.getPyFilesBelow(root, filter, monitor, true);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static ModulesFoundStructure.ZipContents getFromZip(File root, IProgressMonitor monitor) {
        String fileName = root.getName();
        if (!root.isFile()) return null;
        if (!FileTypesPreferencesPage.isValidZipFile(fileName)) return null;
        ModulesFoundStructure.ZipContents zipContents = new ModulesFoundStructure.ZipContents(root);
        zipContents.zipContentsType = ModulesFoundStructure.ZipContents.ZIP_CONTENTS_TYPE_PY_ZIP;
        try {
            String zipFileName = root.getName();
            ZipFile zipFile = new ZipFile(root);
            try {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                int i = 0;
                FastStringBuffer buffer = new FastStringBuffer();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!entry.isDirectory()) {
                        if (PythonPathHelper.isValidFileMod(name) || name.endsWith(".class")) {
                            if (name.endsWith(".class")) {
                                zipContents.zipContentsType = ModulesFoundStructure.ZipContents.ZIP_CONTENTS_TYPE_JAR;
                            }
                            if (i % 15 == 0) {
                                if (monitor.isCanceled()) {
                                    return null;
                                }
                                buffer.clear();
                                monitor.setTaskName(buffer.append("Found in ").append(zipFileName).append(" module ").append(name).toString());
                                monitor.worked(1);
                            }
                            if (PythonPathHelper.isValidInitFile(name)) {
                                zipContents.pyInitFilesLowerWithoutExtension.add(StringUtils.stripExtension((String)name).toLowerCase());
                            }
                            zipContents.pyFilesLowerToRegular.put(name.toLowerCase(), name);
                        }
                    } else {
                        zipContents.pyfoldersLower.add(name.toLowerCase());
                    }
                    ++i;
                }
            }
            finally {
                zipFile.close();
            }
            zipContents.consolidatePythonpathInfo(monitor);
            return zipContents;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    public static boolean isValidSourceFile(String path) {
        path = path.toLowerCase();
        String[] stringArray = FileTypesPreferencesPage.getDottedValidSourceFiles();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String end = stringArray[n2];
            if (path.endsWith(end)) {
                return true;
            }
            ++n2;
        }
        return path.endsWith(".pypredef");
    }

    public static boolean isValidSourceFile(IFile file) {
        String ext = file.getFileExtension();
        if (ext == null) {
            return false;
        }
        ext = ext.toLowerCase();
        String[] stringArray = FileTypesPreferencesPage.getValidSourceFiles();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String end = stringArray[n2];
            if (ext.equals(end)) {
                return true;
            }
            ++n2;
        }
        return ext.equals(".pypredef");
    }

    public static boolean isValidFileMod(String path) {
        boolean ret = false;
        if (PythonPathHelper.isValidSourceFile(path)) {
            ret = true;
        } else if (FileTypesPreferencesPage.isValidDll(path)) {
            ret = true;
        }
        return ret;
    }

    @Override
    public String resolveModule(String fullPath) {
        return this.resolveModule(fullPath, false);
    }

    public String resolveModule(String fullPath, ArrayList<String> pythonPathToUse) {
        return this.resolveModule(fullPath, false, pythonPathToUse);
    }

    public String resolveModule(String fullPath, boolean requireFileToExist) {
        return this.resolveModule(fullPath, requireFileToExist, this.getPythonpath());
    }

    public String resolveModule(String fullPath, boolean requireFileToExist, List<String> pythonPathCopy) {
        fullPath = REF.getFileAbsolutePath((String)fullPath);
        String fullPathWithoutExtension = PythonPathHelper.isValidSourceFile(fullPath = PythonPathHelper.getDefaultPathStr(fullPath)) || FileTypesPreferencesPage.isValidDll(fullPath) ? FullRepIterable.headAndTail((String)fullPath)[0] : fullPath;
        File moduleFile = new File(fullPath);
        if (requireFileToExist && !moduleFile.exists()) {
            return null;
        }
        boolean isFile = moduleFile.isFile();
        for (String pathEntry : pythonPathCopy) {
            String element = PythonPathHelper.getDefaultPathStr(pathEntry);
            if (!fullPath.startsWith(element)) continue;
            int len = element.length();
            String s = fullPath.substring(len);
            String sWithoutExtension = fullPathWithoutExtension.substring(len);
            if (s.startsWith("/")) {
                s = s.substring(1);
            }
            if (sWithoutExtension.startsWith("/")) {
                sWithoutExtension = sWithoutExtension.substring(1);
            }
            if (!PythonPathHelper.isValidModuleLastPart(sWithoutExtension)) continue;
            if ((s = s.replaceAll("/", ".")).indexOf(".") != -1) {
                int i;
                File root = new File(element);
                if (!root.exists()) continue;
                List temp = StringUtils.dotSplit((String)s);
                String[] modulesParts = temp.toArray(new String[temp.size()]);
                if (modulesParts.length > 1 && isFile) {
                    String[] t = new String[modulesParts.length - 1];
                    i = 0;
                    while (i < modulesParts.length - 1) {
                        t[i] = modulesParts[i];
                        ++i;
                    }
                    t[t.length - 1] = String.valueOf(t[t.length - 1]) + "." + modulesParts[modulesParts.length - 1];
                    modulesParts = t;
                }
                boolean isValid = true;
                i = 0;
                while (i < modulesParts.length && root != null) {
                    root = new File(String.valueOf(REF.getFileAbsolutePath((File)root)) + "/" + modulesParts[i]);
                    if (PythonPathHelper.isValidFileMod(modulesParts[i])) {
                        if (root.exists() && root.isFile()) {
                            break;
                        }
                    } else if (!PythonPathHelper.isFileOrFolderWithInit(root)) {
                        isValid = false;
                        break;
                    }
                    ++i;
                }
                if (!isValid) continue;
                if (isFile) {
                    s = PythonPathHelper.stripExtension(s);
                } else if (!moduleFile.exists() && PythonPathHelper.isValidFileMod(s)) {
                    s = PythonPathHelper.stripExtension(s);
                }
                return s;
            }
            if (!isFile && moduleFile.isDirectory() && !PythonPathHelper.isFileOrFolderWithInit(moduleFile)) {
                return null;
            }
            return s;
        }
        if (!requireFileToExist) {
            for (String element : pythonPathCopy) {
                if (!fullPathWithoutExtension.startsWith(element = PythonPathHelper.getDefaultPathStr(element))) continue;
                String s = fullPathWithoutExtension.substring(element.length());
                if (s.startsWith("/")) {
                    s = s.substring(1);
                }
                if (!PythonPathHelper.isValidModuleLastPart(s)) continue;
                s = s.replaceAll("/", ".");
                return s;
            }
        }
        return null;
    }

    public static String stripExtension(String s) {
        if (s != null) {
            return StringUtils.stripExtension((String)s);
        }
        return null;
    }

    protected static boolean isFileOrFolderWithInit(File root) {
        String[] items = root.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return PythonPathHelper.isValidInitFile(name);
            }
        });
        return items != null && items.length >= 1;
    }

    public static boolean isValidInitFile(String item) {
        return item.toLowerCase().indexOf("__init__.") != -1 && PythonPathHelper.isValidSourceFile(item);
    }

    public static boolean isValidModuleLastPart(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '-' || c == ' ' || c == '.' || c == '+') {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPythonPath(List<String> newPythonpath) {
        List<String> list = this.pythonpath;
        synchronized (list) {
            this.pythonpath.clear();
            this.pythonpath.addAll(newPythonpath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPythonPath(String string) {
        List<String> list = this.pythonpath;
        synchronized (list) {
            this.pythonpath.clear();
            PythonPathHelper.parsePythonPathFromStr(string, this.pythonpath);
        }
    }

    public static List<String> parsePythonPathFromStr(String string, List<String> lPath) {
        String[] strings = string.split("\\|");
        int i = 0;
        while (i < strings.length) {
            String defaultPathStr = PythonPathHelper.getDefaultPathStr(strings[i]);
            if (defaultPathStr != null && defaultPathStr.trim().length() > 0) {
                File file = new File(defaultPathStr);
                if (file.exists()) {
                    String path = REF.getFileAbsolutePath((File)file);
                    lPath.add(path);
                } else {
                    lPath.add(defaultPathStr);
                }
            }
            ++i;
        }
        return lPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getPythonpath() {
        List<String> list = this.pythonpath;
        synchronized (list) {
            return new ArrayList<String>(this.pythonpath);
        }
    }

    @Override
    public ModulesFoundStructure getModulesFoundStructure(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        List<String> pythonpathList = this.getPythonpath();
        ModulesFoundStructure ret = new ModulesFoundStructure();
        FastStringBuffer tempBuf = new FastStringBuffer();
        for (String element : pythonpathList) {
            if (monitor.isCanceled()) break;
            File root = new File(element);
            PyFileListing below = PythonPathHelper.getModulesBelow(root, monitor);
            if (below != null) {
                for (PyFileListing.PyFileInfo pyFileInfo : below.getFoundPyFileInfos()) {
                    File file = pyFileInfo.getFile();
                    String modName = pyFileInfo.getModuleName(tempBuf);
                    if (!PythonPathHelper.isValidModuleLastPart(FullRepIterable.getLastPart((String)modName))) continue;
                    ret.regularModules.put(file, modName);
                }
                continue;
            }
            ModulesFoundStructure.ZipContents zipContents = PythonPathHelper.getFromZip(root, monitor);
            if (zipContents == null) continue;
            ret.zipContents.add(zipContents);
        }
        return ret;
    }

    public void loadFromFile(File pythonpatHelperFile) throws IOException {
        String fileContents = REF.getFileContents((File)pythonpatHelperFile);
        if (fileContents == null || fileContents.trim().length() == 0) {
            throw new IOException("No loaded contents from: " + pythonpatHelperFile);
        }
        this.pythonpath.addAll(StringUtils.split((String)fileContents, (char)'\n'));
    }

    public void saveToFile(File pythonpatHelperFile) {
        REF.writeStrToFile((String)StringUtils.join((String)"\n", this.pythonpath), (File)pythonpatHelperFile);
    }

    public static boolean canAddAstInfoFor(ModulesKey key) {
        if (key.file != null && key.file.exists()) {
            if (PythonPathHelper.isValidSourceFile(key.file.getName())) {
                return true;
            }
            boolean isZipModule = key instanceof ModulesKeyForZip;
            if (isZipModule) {
                ModulesKeyForZip modulesKeyForZip = (ModulesKeyForZip)key;
                if (PythonPathHelper.isValidSourceFile(modulesKeyForZip.zipModulePath)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean markAsPyDevFileIfDetected(IFile file) {
        block6: {
            String editorID;
            block5: {
                String name = file.getName();
                if (name == null || name.indexOf(46) != -1) {
                    return false;
                }
                editorID = file.getPersistentProperty(IDE.EDITOR_KEY);
                if (editorID != null) break block5;
                InputStream contents = file.getContents(true);
                InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(contents));
                if (REF.hasPythonShebang((Reader)inputStreamReader)) {
                    IDE.setDefaultEditor((IFile)file, (String)"org.python.pydev.editor.PythonEditor");
                    return true;
                }
            }
            try {
                return "org.python.pydev.editor.PythonEditor".equals(editorID);
            }
            catch (Exception e) {
                if (!file.exists()) break block6;
                Log.log((Throwable)e);
            }
        }
        return false;
    }
}

