/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IToken;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.GlobalModelVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assert;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.SequencialASTIteratorVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalScope
implements ILocalScope {
    public FastStack<SimpleNode> scope = new FastStack();
    public int scopeEndLine = -1;
    public int ifMainLine = -1;
    public static final Map<String, Integer> ISINSTANCE_POSSIBILITIES = new HashMap<String, Integer>();

    static {
        ISINSTANCE_POSSIBILITIES.put("isinstance".toLowerCase(), 2);
        ISINSTANCE_POSSIBILITIES.put("IsImplementation".toLowerCase(), 2);
        ISINSTANCE_POSSIBILITIES.put("IsInterfaceDeclared".toLowerCase(), 2);
        ISINSTANCE_POSSIBILITIES.put("implementedBy".toLowerCase(), -1);
    }

    public LocalScope() {
    }

    public LocalScope(FastStack<SimpleNode> scope) {
        this.scope.addAll(scope);
    }

    public FastStack<SimpleNode> getScopeStack() {
        return this.scope;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalScope)) {
            return false;
        }
        LocalScope s = (LocalScope)obj;
        if (this.scope.size() != s.scope.size()) {
            return false;
        }
        return this.checkIfScopesMatch(s);
    }

    public boolean isOuterOrSameScope(ILocalScope s) {
        if (this.scope.size() > s.getScopeStack().size()) {
            return false;
        }
        return this.checkIfScopesMatch(s);
    }

    private boolean checkIfScopesMatch(ILocalScope s) {
        ListIterator otIt = s.getScopeStack().iterator();
        for (SimpleNode element : this.scope) {
            SimpleNode otElement = (SimpleNode)otIt.next();
            if (element.beginColumn != otElement.beginColumn) {
                return false;
            }
            if (element.beginLine != otElement.beginLine) {
                return false;
            }
            if (!element.getClass().equals(otElement.getClass())) {
                return false;
            }
            String rep1 = NodeUtils.getFullRepresentationString((SimpleNode)element);
            String rep2 = NodeUtils.getFullRepresentationString((SimpleNode)otElement);
            if (!(rep1 == null || rep2 == null ? rep1 != rep2 : !rep1.equals(rep2))) continue;
            return false;
        }
        return true;
    }

    public IToken[] getAllLocalTokens() {
        return this.getLocalTokens(Integer.MAX_VALUE, Integer.MAX_VALUE, false);
    }

    public IToken[] getLocalTokens(int endLine, int col, boolean onlyArgs) {
        HashSet<SourceToken> comps = new HashSet<SourceToken>();
        ListIterator iter = this.scope.iterator();
        while (iter.hasNext()) {
            SimpleNode element = (SimpleNode)iter.next();
            stmtType[] body = null;
            if (element instanceof FunctionDef) {
                String s;
                FunctionDef f = (FunctionDef)element;
                argumentsType args = f.args;
                int i = 0;
                while (i < args.args.length) {
                    s = NodeUtils.getRepresentationString((SimpleNode)args.args[i]);
                    comps.add(new SourceToken((SimpleNode)args.args[i], s, "", "", "", 5));
                    ++i;
                }
                if (args.vararg != null) {
                    String s2 = NodeUtils.getRepresentationString((SimpleNode)args.vararg);
                    comps.add(new SourceToken((SimpleNode)args.vararg, s2, "", "", "", 5));
                }
                if (args.kwarg != null) {
                    String s3 = NodeUtils.getRepresentationString((SimpleNode)args.kwarg);
                    comps.add(new SourceToken((SimpleNode)args.kwarg, s3, "", "", "", 5));
                }
                if (args.kwonlyargs != null) {
                    i = 0;
                    while (i < args.kwonlyargs.length) {
                        s = NodeUtils.getRepresentationString((SimpleNode)args.kwonlyargs[i]);
                        comps.add(new SourceToken((SimpleNode)args.kwonlyargs[i], s, "", "", "", 5));
                        ++i;
                    }
                }
                if (onlyArgs) continue;
                body = f.body;
            } else if (element instanceof ClassDef && !iter.hasNext()) {
                ClassDef classDef = (ClassDef)element;
                body = classDef.body;
            }
            if (body == null) continue;
            try {
                int i = 0;
                while (i < body.length) {
                    GlobalModelVisitor visitor = new GlobalModelVisitor(1, "", false, true);
                    stmtType stmt = body[i];
                    if (stmt != null) {
                        stmt.accept((VisitorIF)visitor);
                        List t = visitor.tokens;
                        for (SourceToken tok : t) {
                            tok.type = 9;
                            if (tok.getAst().beginLine > endLine) continue;
                            comps.add(tok);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return comps.toArray(new SourceToken[0]);
    }

    public Collection<IToken> getInterfaceForLocal(String activationToken) {
        return this.getInterfaceForLocal(activationToken, true, true);
    }

    public Collection<IToken> getInterfaceForLocal(String activationToken, boolean addAttributeAccess, boolean addLocalsFromHasAttr) {
        HashSet<SourceToken> comps = new HashSet<SourceToken>();
        Iterator it = this.scope.topDownIterator();
        if (!it.hasNext()) {
            return new ArrayList<IToken>();
        }
        SimpleNode element = (SimpleNode)it.next();
        String dottedActTok = String.valueOf(activationToken) + '.';
        SequencialASTIteratorVisitor visitor = SequencialASTIteratorVisitor.create((SimpleNode)element);
        ArrayList<Class> classes = new ArrayList<Class>(2);
        if (addAttributeAccess) {
            classes.add(Attribute.class);
        }
        if (addLocalsFromHasAttr) {
            classes.add(Call.class);
        }
        Iterator iterator = visitor.getIterator(classes.toArray(new Class[classes.size()]));
        while (iterator.hasNext()) {
            exprType node;
            String rep;
            ASTEntry entry = (ASTEntry)iterator.next();
            if (entry.node instanceof Attribute) {
                String rep2 = NodeUtils.getFullRepresentationString((SimpleNode)entry.node);
                if (!rep2.startsWith(dottedActTok) || !NodeUtils.isValidNameRepresentation((String)(rep2 = rep2.substring(dottedActTok.length())))) continue;
                comps.add(new SourceToken(entry.node, FullRepIterable.getFirstPart((String)rep2), "", "", "", 10));
                continue;
            }
            if (!(entry.node instanceof Call)) continue;
            Call call = (Call)entry.node;
            if (!"hasattr".equals(NodeUtils.getFullRepresentationString((SimpleNode)call.func)) || call.args == null || call.args.length != 2 || !(rep = NodeUtils.getFullRepresentationString((SimpleNode)call.args[0])).equals(activationToken) || !((node = call.args[1]) instanceof Str)) continue;
            Str str = (Str)node;
            String attrName = str.s;
            if (!NodeUtils.isValidNameRepresentation((String)attrName)) continue;
            comps.add(new SourceToken((SimpleNode)node, attrName, "", "", "", 10));
        }
        return new ArrayList<IToken>(comps);
    }

    public List<IToken> getLocalImportedModules(int line, int col, String moduleName) {
        ArrayList<IToken> importedModules = new ArrayList<IToken>();
        for (SimpleNode element : this.scope) {
            if (!(element instanceof FunctionDef)) continue;
            FunctionDef f = (FunctionDef)element;
            int i = 0;
            while (i < f.body.length) {
                stmtType stmt = f.body[i];
                if (stmt != null) {
                    importedModules.addAll(GlobalModelVisitor.getTokens((SimpleNode)stmt, 4, moduleName, null, false));
                }
                ++i;
            }
        }
        return importedModules;
    }

    public ClassDef getClassDef() {
        Iterator it = this.scope.topDownIterator();
        while (it.hasNext()) {
            SimpleNode node = (SimpleNode)it.next();
            if (!(node instanceof ClassDef)) continue;
            return (ClassDef)node;
        }
        return null;
    }

    public boolean isLastClassDef() {
        return this.scope.size() > 0 && this.scope.peek() instanceof ClassDef;
    }

    public Iterator iterator() {
        return this.scope.topDownIterator();
    }

    public int getIfMainLine() {
        return this.ifMainLine;
    }

    public int getScopeEndLine() {
        return this.scopeEndLine;
    }

    public void setIfMainLine(int original) {
        this.ifMainLine = original;
    }

    public void setScopeEndLine(int beginLine) {
        this.scopeEndLine = beginLine;
    }

    public List<String> getPossibleClassesForActivationToken(String actTok) {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator it = this.scope.topDownIterator();
        if (!it.hasNext()) {
            return ret;
        }
        SimpleNode element = (SimpleNode)it.next();
        SequencialASTIteratorVisitor visitor = SequencialASTIteratorVisitor.create((SimpleNode)element);
        Iterator iterator = visitor.getIterator(Assert.class);
        while (iterator.hasNext()) {
            String foundActTok;
            Integer classIndex;
            ASTEntry entry = (ASTEntry)iterator.next();
            Assert ass = (Assert)entry.node;
            if (!(ass.test instanceof Call)) continue;
            Call call = (Call)ass.test;
            String rep = NodeUtils.getFullRepresentationString((SimpleNode)call.func);
            if (rep == null || (classIndex = ISINSTANCE_POSSIBILITIES.get(FullRepIterable.getLastPart((String)rep).toLowerCase())) == null || call.args == null || call.args.length < Math.max(classIndex, 1) || (foundActTok = NodeUtils.getFullRepresentationString((SimpleNode)call.args[0])) == null || !foundActTok.equals(actTok)) continue;
            if (classIndex > 0) {
                exprType type = call.args[classIndex - 1];
                if (type instanceof Tuple) {
                    Tuple tuple = (Tuple)type;
                    exprType[] exprTypeArray = tuple.elts;
                    int n = tuple.elts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        exprType expr = exprTypeArray[n2];
                        this.addRepresentationIfPossible(ret, expr);
                        ++n2;
                    }
                    continue;
                }
                this.addRepresentationIfPossible(ret, type);
                continue;
            }
            ret.add(FullRepIterable.getWithoutLastPart((String)rep));
        }
        return ret;
    }

    private void addRepresentationIfPossible(ArrayList<String> ret, exprType expr) {
        String string;
        if ((expr instanceof Name || expr instanceof Attribute) && (string = NodeUtils.getFullRepresentationString((SimpleNode)expr)) != null) {
            ret.add(string);
        }
    }
}

