/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.REF;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimplePythonRunner;
import org.python.pydev.runners.SimpleRunner;

public class PythonShell
extends AbstractShell {
    public PythonShell() throws IOException, CoreException {
        super(PydevPlugin.getScriptWithinPySrc("pycompletionserver.py"));
    }

    protected synchronized String createServerProcess(IInterpreterInfo interpreter, int pWrite, int pRead) throws IOException {
        File file = new File(interpreter.getExecutableOrJar());
        if (!file.exists()) {
            throw new RuntimeException("The interpreter location found does not exist. " + interpreter);
        }
        if (file.isDirectory()) {
            throw new RuntimeException("The interpreter location found is a directory. " + interpreter);
        }
        String execMsg = REF.isWindowsPlatform() ? interpreter + " \"" + REF.getFileAbsolutePath((File)this.serverFile) + "\" " + pWrite + " " + pRead : interpreter + " " + REF.getFileAbsolutePath((File)this.serverFile) + " " + pWrite + " " + pRead;
        String[] parameters = SimplePythonRunner.preparePythonCallParameters(interpreter.getExecutableOrJar(), REF.getFileAbsolutePath((File)this.serverFile), new String[]{"" + pWrite, "" + pRead});
        IInterpreterManager manager = PydevPlugin.getPythonInterpreterManager();
        String[] envp = null;
        try {
            envp = SimpleRunner.getEnvironment(null, interpreter, manager, true);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        this.process = SimpleRunner.createProcess(parameters, envp, this.serverFile.getParentFile());
        return execMsg;
    }
}

