/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.overview_ruler;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.core.uiutils.RunInUiThread;
import org.python.pydev.overview_ruler.CopiedOverviewRuler;

public class MinimapOverviewRuler
extends CopiedOverviewRuler {
    private static final Object lockStackedParameters = new Object();
    private boolean mousePressed = false;
    private WeakReference<StyledText> styledText;
    private final PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            if (!MinimapOverviewRuler.this.fCanvas.isDisposed()) {
                MinimapOverviewRuler.this.redraw();
            }
        }
    };
    private volatile Image baseImage;
    private volatile Image lastImage;
    private Object[] cacheKey;
    private final RedrawJob redrawJob = new RedrawJob("Redraw overview ruler");

    public static String rightTrim(String input) {
        int len = input.length();
        int st = 0;
        int off = 0;
        while (st < len && input.charAt(off + len - 1) <= ' ') {
            --len;
        }
        return input.substring(0, len);
    }

    public static int getFirstCharPosition(String src) {
        int i = 0;
        boolean breaked = false;
        while (i < src.length()) {
            if (!Character.isWhitespace(src.charAt(i)) && src.charAt(i) != '\t') {
                ++i;
                breaked = true;
                break;
            }
            ++i;
        }
        if (!breaked) {
            ++i;
        }
        return i - 1;
    }

    public MinimapOverviewRuler(IAnnotationAccess annotationAccess, ISharedTextColors sharedColors) {
        super(annotationAccess, 120, sharedColors);
    }

    protected void doubleBufferPaint(GC dest) {
        if (this.fTextViewer != null) {
            this.fCanvas.setBackground(this.fTextViewer.getTextWidget().getBackground());
            this.fCanvas.setForeground(this.fTextViewer.getTextWidget().getForeground());
        }
        super.doubleBufferPaint(dest);
    }

    public Control createControl(Composite parent, ITextViewer textViewer) {
        Control ret = super.createControl(parent, textViewer);
        this.fCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                MinimapOverviewRuler.this.onMouseDown(event);
            }

            public void mouseUp(MouseEvent event) {
                MinimapOverviewRuler.this.onMouseUp(event);
            }
        });
        this.fCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                MinimapOverviewRuler.this.onMouseMove(event);
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                MinimapOverviewRuler.this.onDispose();
            }
        });
        StyledText textWidget = textViewer.getTextWidget();
        if (!textWidget.isDisposed()) {
            this.styledText = new WeakReference<StyledText>(textWidget);
            textWidget.addPaintListener(this.paintListener);
        }
        return ret;
    }

    private void onMouseDown(MouseEvent event) {
        this.mousePressed = true;
    }

    private void onMouseUp(MouseEvent event) {
        this.mousePressed = false;
    }

    private void onMouseMove(MouseEvent event) {
        if (this.mousePressed) {
            event.button = 1;
            super.handleMouseDown(event);
        }
    }

    private void onDispose() {
        try {
            StyledText textWidget;
            if (this.baseImage != null && !this.baseImage.isDisposed()) {
                this.baseImage.dispose();
                this.baseImage = null;
            }
            if (this.lastImage != null && !this.lastImage.isDisposed()) {
                this.lastImage.dispose();
                this.lastImage = null;
            }
            if (this.styledText != null && (textWidget = (StyledText)this.styledText.get()) != null && !textWidget.isDisposed()) {
                textWidget.removePaintListener(this.paintListener);
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            this.redrawJob.cancel();
            this.redrawJob.disposeStackedParameters();
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    protected void doPaint1(GC paintGc) {
        IDocumentExtension4 document;
        if (this.fTextViewer != null && (document = (IDocumentExtension4)this.fTextViewer.getDocument()) != null) {
            StyledText styledText = this.fTextViewer.getTextWidget();
            Point size = this.fCanvas.getSize();
            if (size.x != 0 && size.y != 0) {
                StyledTextContent content = styledText.getContent();
                int lineCount = content.getLineCount();
                IPreferenceStore preferenceStore = EditorsUI.getPreferenceStore();
                int marginCols = preferenceStore.getInt("printMarginColumn");
                String strColor = preferenceStore.getString("printMarginColor");
                RGB marginRgb = StringConverter.asRGB((String)strColor);
                Color marginColor = new Color((Device)Display.getCurrent(), marginRgb);
                Color black = new Color((Device)Display.getCurrent(), new RGB(0, 0, 0));
                int maxChars = (int)((double)marginCols + (double)marginCols * 0.1);
                int imageHeight = lineCount * 1;
                int imageWidth = maxChars;
                Object[] currCacheKey = new Object[]{document.getModificationStamp(), size.x, size.y, styledText.getForeground(), styledText.getBackground(), marginCols, marginRgb};
                double scaleX = (double)size.x / (double)imageWidth;
                double scaleY = (double)size.y / (double)imageHeight;
                Transform transform = new Transform((Device)Display.getCurrent());
                transform.scale((float)scaleX, (float)scaleY);
                if (this.baseImage == null || !Arrays.equals(this.cacheKey, currCacheKey)) {
                    this.cacheKey = currCacheKey;
                    Image tmpImage = new Image((Device)Display.getCurrent(), size.x, size.y);
                    GC gc = new GC((Drawable)tmpImage);
                    gc.setAdvanced(true);
                    gc.setAntialias(1);
                    gc.setBackground(styledText.getBackground());
                    gc.setForeground(styledText.getBackground());
                    gc.fillRectangle(0, 0, size.x, size.y);
                    Color styledTextForeground = styledText.getForeground();
                    Color marginColor2 = new Color((Device)Display.getCurrent(), marginRgb);
                    this.redrawJob.cancel();
                    this.redrawJob.setParameters(gc, styledTextForeground, size, content, lineCount, marginCols, marginColor2, 1, imageHeight, transform, tmpImage);
                    this.redrawJob.schedule();
                }
                try {
                    if (this.baseImage != null && !this.baseImage.isDisposed()) {
                        if (this.lastImage != null && !this.lastImage.isDisposed()) {
                            this.lastImage.dispose();
                        }
                        Image image = new Image((Device)Display.getCurrent(), size.x, size.y);
                        GC gc2 = new GC((Drawable)image);
                        try {
                            gc2.drawImage(this.baseImage, 0, 0);
                            Rectangle clientArea = styledText.getClientArea();
                            int top = styledText.getLineIndex(0);
                            int bottom = styledText.getLineIndex(clientArea.height) + 1;
                            float[] rect = new float[]{0.0f, top * 1, imageWidth, bottom * 1 - top * 1};
                            transform.transform(rect);
                            gc2.setLineWidth(3);
                            gc2.setAlpha(150);
                            gc2.fillRectangle(Math.round(rect[0]), Math.round(rect[1]), Math.round(rect[2]), Math.round(rect[3]));
                            gc2.setAlpha(255);
                            gc2.drawRectangle(Math.round(rect[0]), Math.round(rect[1]), Math.round(rect[2]), Math.round(rect[3]));
                            gc2.setForeground(black);
                            gc2.drawRectangle(0, 0, size.x, size.y);
                        }
                        finally {
                            gc2.dispose();
                        }
                        this.lastImage = image;
                    }
                    if (this.lastImage != null && !this.lastImage.isDisposed()) {
                        paintGc.drawImage(this.lastImage, 0, 0);
                    }
                }
                finally {
                    marginColor.dispose();
                    black.dispose();
                }
            }
        }
        super.doPaint1(paintGc);
    }

    private final class RedrawJob
    extends Job {
        private FastStack<Object[]> stackedParameters;

        private RedrawJob(String name) {
            super(name);
            this.stackedParameters = new FastStack();
            this.setPriority(20);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setParameters(GC gc, Color styledTextForeground, Point size, StyledTextContent content, int lineCount, int marginCols, Color marginColor, int spacing, int imageHeight, Transform transform, Image tmpImage) {
            Object object = lockStackedParameters;
            synchronized (object) {
                this.stackedParameters.push((Object)new Object[]{gc, styledTextForeground, size, content, lineCount, marginCols, marginColor, spacing, imageHeight, transform, tmpImage});
            }
        }

        private void redrawBaseImage(GC gc, Color styledTextForeground, Point size, StyledTextContent content, int lineCount, int marginCols, Color marginColor, int spacing, int imageHeight, Transform transform, IProgressMonitor monitor) {
            gc.setForeground(styledTextForeground);
            gc.setAlpha(200);
            gc.setTransform(transform);
            int x1 = 0;
            int y1 = 0;
            int x2 = 0;
            int y2 = 0;
            int i = 0;
            while (i < lineCount) {
                if (monitor.isCanceled()) {
                    return;
                }
                String line = MinimapOverviewRuler.rightTrim(content.getLine(i));
                x1 = MinimapOverviewRuler.getFirstCharPosition(line);
                x2 = line.length();
                if (x2 > 0) {
                    gc.drawLine(x1, y1, x2, y2);
                }
                y1 = y2 = y1 + spacing;
                ++i;
            }
            if (monitor.isCanceled()) {
                return;
            }
            gc.setForeground(marginColor);
            gc.setBackground(marginColor);
            gc.drawLine(marginCols, 0, marginCols, imageHeight);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Image image;
            block13: {
                Object[] parameters;
                Object object = lockStackedParameters;
                synchronized (object) {
                    parameters = (Object[])this.stackedParameters.pop();
                    this.disposeStackedParameters();
                }
                GC gc = (GC)parameters[0];
                Color styledTextForeground = (Color)parameters[1];
                Point size = (Point)parameters[2];
                StyledTextContent content = (StyledTextContent)parameters[3];
                int lineCount = (Integer)parameters[4];
                int marginCols = (Integer)parameters[5];
                Color marginColor = (Color)parameters[6];
                int spacing = (Integer)parameters[7];
                int imageHeight = (Integer)parameters[8];
                Transform transform = (Transform)parameters[9];
                image = (Image)parameters[10];
                try {
                    try {
                        this.redrawBaseImage(gc, styledTextForeground, size, content, lineCount, marginCols, marginColor, spacing, imageHeight, transform, monitor);
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                        gc.dispose();
                        marginColor.dispose();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    gc.dispose();
                    marginColor.dispose();
                    throw throwable;
                }
                gc.dispose();
                marginColor.dispose();
            }
            boolean disposeOfImage = true;
            try {
                Canvas c;
                if (!monitor.isCanceled() && (c = MinimapOverviewRuler.this.fCanvas) != null && !c.isDisposed()) {
                    disposeOfImage = false;
                    RunInUiThread.async((Runnable)new Runnable(){

                        public void run() {
                            if (MinimapOverviewRuler.this.baseImage != null && !MinimapOverviewRuler.this.baseImage.isDisposed()) {
                                MinimapOverviewRuler.this.baseImage.dispose();
                            }
                            if (c != null && !c.isDisposed()) {
                                MinimapOverviewRuler.this.baseImage = image;
                                MinimapOverviewRuler.this.redraw();
                            } else {
                                image.dispose();
                            }
                        }
                    });
                }
            }
            finally {
                if (disposeOfImage) {
                    image.dispose();
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disposeStackedParameters() {
            Object object = lockStackedParameters;
            synchronized (object) {
                while (this.stackedParameters.size() > 0) {
                    Object[] disposeOfParameters = (Object[])this.stackedParameters.pop();
                    GC gc = (GC)disposeOfParameters[0];
                    Color marginColor = (Color)disposeOfParameters[6];
                    gc.dispose();
                    marginColor.dispose();
                }
            }
        }
    }
}

