/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import java.io.File;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.ui.dialogs.AbstractKeyValueDialog;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterInputDialog
extends AbstractKeyValueDialog {
    private AbstractInterpreterEditor editor;

    public InterpreterInputDialog(Shell shell, String dialogTitle, String dialogMessage, AbstractInterpreterEditor editor) {
        super(shell, dialogTitle, dialogMessage);
        this.editor = editor;
    }

    @Override
    protected String getInitialMessage() {
        return "Please, inform the name and executable of your intepreter";
    }

    @Override
    protected String getValueLabelText() {
        return "Interpreter Executable: ";
    }

    @Override
    protected String getKeyLabelText() {
        return "Interpreter Name: ";
    }

    @Override
    protected Listener createChangesValidator() {
        return new Listener(){

            public void handleEvent(Event event) {
                File file;
                String errorMessage = null;
                String interpreterName = InterpreterInputDialog.this.keyField.getText().trim();
                if (interpreterName.equals("")) {
                    errorMessage = "The interpreter name must be specified";
                }
                String executableOrJar = InterpreterInputDialog.this.valueField.getText().trim();
                if (errorMessage == null && executableOrJar.equals("")) {
                    errorMessage = "The interpreter location must be specified";
                }
                if (errorMessage == null && (!(file = new File(executableOrJar)).exists() || file.isDirectory())) {
                    errorMessage = "Invalid interpreter";
                }
                if (errorMessage == null) {
                    errorMessage = InterpreterInputDialog.this.editor.getDuplicatedMessageError(interpreterName, executableOrJar);
                }
                InterpreterInputDialog.this.setErrorMessage(errorMessage);
            }
        };
    }

    @Override
    public Tuple<String, String> getKeyAndValueEntered() {
        Tuple<String, String> keyAndValueEntered = super.getKeyAndValueEntered();
        if (keyAndValueEntered != null) {
            keyAndValueEntered.o2 = REF.getFileAbsolutePath((String)this.finalValueValue);
        }
        return keyAndValueEntered;
    }

    @Override
    protected String handleBrowseButton() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        String[] filterExtensions = this.editor.getInterpreterFilterExtensions();
        if (filterExtensions != null) {
            dialog.setFilterExtensions(filterExtensions);
        }
        String file = dialog.open();
        return file;
    }

    @Override
    protected void setValueField(String file) {
        if (this.keyField.getText().trim().equals("")) {
            this.keyField.setText(file);
        }
        super.setValueField(file);
    }
}

