/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.cache.CompleteIndexKey;
import org.python.pydev.core.cache.CompleteIndexValue;
import org.python.pydev.core.cache.DiskCache;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.ModulesKeyTreeMap;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.parser.jython.SimpleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAdditionalDependencyInfo
extends AbstractAdditionalTokensInfo {
    public static boolean TESTING = false;
    public static final boolean DEBUG = false;
    public DiskCache completeIndex;
    private static ICallback<CompleteIndexValue, String> readFromFileMethod = new ICallback<CompleteIndexValue, String>(){

        public CompleteIndexValue call(String arg) {
            CompleteIndexValue entry = new CompleteIndexValue();
            if (arg.equals("0")) {
                return entry;
            }
            HashSet hashSet = new HashSet();
            if (arg.length() > 0) {
                StringUtils.splitWithIntern((String)arg, (char)'\n', hashSet);
            }
            entry.entries = hashSet;
            return entry;
        }
    };
    private static ICallback<String, CompleteIndexValue> toFileMethod = new ICallback<String, CompleteIndexValue>(){

        public String call(CompleteIndexValue arg) {
            if (arg.entries == null) {
                return "0";
            }
            FastStringBuffer buf = new FastStringBuffer(arg.entries.size() * 20);
            for (String s : arg.entries) {
                buf.append(s);
                buf.append('\n');
            }
            return buf.toString();
        }
    };

    public AbstractAdditionalDependencyInfo() throws MisconfigurationException {
        this.init();
    }

    public AbstractAdditionalDependencyInfo(boolean callInit) throws MisconfigurationException {
        if (callInit) {
            this.init();
        }
    }

    protected void init() throws MisconfigurationException {
        File persistingFolder = this.getCompleteIndexPersistingFolder();
        this.completeIndex = new DiskCache(persistingFolder, ".v1_indexcache", readFromFileMethod, toFileMethod);
    }

    protected File getCompleteIndexPersistingFolder() throws MisconfigurationException {
        File persistingFolder = this.getPersistingFolder();
        if ((persistingFolder = new File(persistingFolder, "v1_indexcache")).exists() && !persistingFolder.isDirectory()) {
            persistingFolder.delete();
        }
        if (!persistingFolder.exists()) {
            persistingFolder.mkdirs();
        }
        return persistingFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllInfo() {
        Object object = this.lock;
        synchronized (object) {
            super.clearAllInfo();
            try {
                this.completeIndex.clear();
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public void updateKeysIfNeededAndSave(ModulesKeyTreeMap<ModulesKey, ModulesKey> keysFound) {
        boolean hasRemoved;
        Map keys = this.completeIndex.keys();
        ArrayList<ModulesKey> newKeys = new ArrayList<ModulesKey>();
        ArrayList<ModulesKey> removedKeys = new ArrayList<ModulesKey>();
        CompleteIndexKey tempKey = new CompleteIndexKey(null);
        for (ModulesKey next : keysFound.values()) {
            long lastModified;
            if (next.file == null || (lastModified = next.file.lastModified()) == 0L) continue;
            tempKey.key = next;
            CompleteIndexKey completeIndexKey = (CompleteIndexKey)keys.get(tempKey);
            boolean canAddAstInfoFor = PythonPathHelper.canAddAstInfoFor((ModulesKey)next);
            if (completeIndexKey == null) {
                if (!canAddAstInfoFor) continue;
                newKeys.add(next);
                continue;
            }
            if (canAddAstInfoFor) {
                if (completeIndexKey.lastModified == lastModified) continue;
                newKeys.add(next);
                continue;
            }
            removedKeys.add(next);
        }
        for (CompleteIndexKey next : keys.values()) {
            if (keysFound.containsKey((Object)next.key) && PythonPathHelper.canAddAstInfoFor((ModulesKey)next.key)) continue;
            removedKeys.add(next.key);
        }
        boolean hasNew = newKeys.size() != 0;
        boolean bl = hasRemoved = removedKeys.size() != 0;
        if (hasNew) {
            for (ModulesKey newKey : newKeys) {
                try {
                    this.addAstInfo(newKey, false);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }
        if (hasRemoved) {
            for (ModulesKey removedKey : removedKeys) {
                this.removeInfoFromModule(removedKey.name, false);
            }
        }
        if (hasNew || hasRemoved) {
            if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                Log.toLogFile((Object)this, (String)StringUtils.format((String)"Additional info modules. Added: %s Removed: %s", (Object[])new Object[]{newKeys, removedKeys}));
            }
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ModulesKey> getModulesWithToken(String token, IProgressMonitor monitor) {
        FastStringBuffer temp = new FastStringBuffer();
        ArrayList<ModulesKey> ret = new ArrayList<ModulesKey>();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (token == null) return ret;
        if (token.length() == 0) {
            return ret;
        }
        int i = 0;
        while (i < token.length()) {
            if (!Character.isJavaIdentifierPart(token.charAt(i))) {
                throw new RuntimeException(StringUtils.format((String)"Token: %s is not a valid token to search for.", (Object[])new Object[]{token}));
            }
            ++i;
        }
        Object object = this.lock;
        synchronized (object) {
            FastStringBuffer bufProgress = new FastStringBuffer();
            Tuple memoryInfo = this.completeIndex.getInMemoryInfo();
            long last = System.currentTimeMillis();
            int worked = 0;
            try {
                monitor.beginTask("Get modules with token", ((List)memoryInfo.o1).size() + ((Collection)memoryInfo.o2).size());
                for (Tuple tup : (List)memoryInfo.o1) {
                    CompleteIndexKey indexKey = (CompleteIndexKey)tup.o1;
                    CompleteIndexValue obj = (CompleteIndexValue)tup.o2;
                    ++worked;
                    if (monitor.isCanceled()) {
                        ArrayList<ModulesKey> arrayList = ret;
                        return arrayList;
                    }
                    long current = System.currentTimeMillis();
                    if (last + 200L < current) {
                        last = current;
                        monitor.setTaskName(bufProgress.clear().append("Searching: ").append(indexKey.key.name).toString());
                        monitor.worked(worked);
                    }
                    this.check(indexKey, obj, temp, token, ret);
                }
                for (CompleteIndexKey indexKey : (Collection)memoryInfo.o2) {
                    ++worked;
                    if (monitor.isCanceled()) {
                        ArrayList<ModulesKey> arrayList = ret;
                        return arrayList;
                    }
                    long current = System.currentTimeMillis();
                    if (last + 200L < current) {
                        last = current;
                        monitor.setTaskName(bufProgress.clear().append("Searching: ").append(indexKey.key.name).toString());
                        monitor.worked(worked);
                    }
                    this.check(indexKey, null, temp, token, ret);
                }
            }
            finally {
                monitor.done();
            }
            return ret;
        }
    }

    private void check(CompleteIndexKey indexKey, CompleteIndexValue obj, FastStringBuffer temp, String token, ArrayList<ModulesKey> ret) {
        long lastModified;
        if (obj == null) {
            obj = this.completeIndex.getObj(indexKey);
        }
        boolean canAddAstInfoFor = PythonPathHelper.canAddAstInfoFor((ModulesKey)indexKey.key);
        if (obj == null) {
            if (canAddAstInfoFor) {
                try {
                    this.addAstInfo(indexKey.key, true);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                obj = new CompleteIndexValue();
            } else {
                this.removeInfoFromModule(indexKey.key.name, true);
                return;
            }
        }
        if ((lastModified = indexKey.key.file.lastModified()) == 0L || !canAddAstInfoFor) {
            this.removeInfoFromModule(indexKey.key.name, true);
            return;
        }
        if (obj.entries != null && lastModified != indexKey.lastModified) {
            obj = new CompleteIndexValue();
            try {
                this.addAstInfo(indexKey.key, true);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        if (obj.entries == null) {
            FastStringBuffer buf;
            ModulesKey key = indexKey.key;
            try {
                if (key instanceof ModulesKeyForZip) {
                    ModulesKeyForZip modulesKeyForZip = (ModulesKeyForZip)key;
                    buf = (FastStringBuffer)REF.getCustomReturnFromZip((File)modulesKeyForZip.file, (String)modulesKeyForZip.zipModulePath, FastStringBuffer.class);
                } else {
                    buf = (FastStringBuffer)REF.getFileContentsCustom((File)key.file, FastStringBuffer.class);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return;
            }
            HashSet<String> set = new HashSet<String>();
            temp = temp.clear();
            int length = buf.length();
            int i = 0;
            while (i < length) {
                char c = buf.charAt(i);
                if (Character.isJavaIdentifierStart(c)) {
                    String str;
                    temp.clear();
                    temp.append(c);
                    ++i;
                    while (i < length) {
                        c = buf.charAt(i);
                        if (c == ' ' || c == '\t' || !Character.isJavaIdentifierPart(c)) break;
                        temp.append(c);
                        ++i;
                    }
                    if (!PySelection.ALL_KEYWORD_TOKENS.contains(str = temp.toString())) {
                        set.add(str);
                    }
                }
                ++i;
            }
            obj.entries = set;
            indexKey.lastModified = lastModified;
            this.completeIndex.add(indexKey, obj);
        }
        if (obj.entries != null && obj.entries.contains(token)) {
            ret.add(indexKey.key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IInfo> addAstInfo(SimpleNode node, ModulesKey key, boolean generateDelta) {
        List<IInfo> addAstInfo = new ArrayList<IInfo>();
        if (node == null || key == null || key.name == null) {
            return addAstInfo;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                addAstInfo = super.addAstInfo(node, key, generateDelta);
                if (key.file != null) {
                    this.completeIndex.add(new CompleteIndexKey(key), new CompleteIndexValue());
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return addAstInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInfoFromModule(String moduleName, boolean generateDelta) {
        Object object = this.lock;
        synchronized (object) {
            if (moduleName == null) {
                throw new AssertionError((Object)"The module name may not be null.");
            }
            this.completeIndex.remove(new CompleteIndexKey(moduleName));
            super.removeInfoFromModule(moduleName, generateDelta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getInfoToSave() {
        Object object = this.lock;
        synchronized (object) {
            return new Tuple(super.getInfoToSave(), (Object)this.completeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void restoreSavedInfo(Object o) throws MisconfigurationException {
        Object object = this.lock;
        synchronized (object) {
            Tuple readFromFile = (Tuple)o;
            if (!(readFromFile.o1 instanceof Tuple3)) {
                throw new RuntimeException("Type Error: the info must be regenerated (changed across versions).");
            }
            this.completeIndex = (DiskCache)readFromFile.o2;
            if (this.completeIndex == null) {
                throw new RuntimeException("Type Error (index == null): the info must be regenerated (changed across versions).");
            }
            this.completeIndex.readFromFileMethod = readFromFileMethod;
            this.completeIndex.toFileMethod = toFileMethod;
            String shouldBeOn = REF.getFileAbsolutePath((File)this.getCompleteIndexPersistingFolder());
            if (!this.completeIndex.getFolderToPersist().equals(shouldBeOn)) {
                this.completeIndex.setFolderToPersist(shouldBeOn);
            }
            super.restoreSavedInfo(readFromFile.o1);
        }
    }

    protected void addInfoToModuleOnRestoreInsertCommand(Tuple<ModulesKey, List<IInfo>> data) {
        this.completeIndex.add(new CompleteIndexKey((ModulesKey)data.o1), null);
        for (IInfo info : (List)data.o2) {
            if (info.getPath() == null || info.getPath().length() == 0) {
                this.add(info, 1);
                continue;
            }
            this.add(info, 2);
        }
    }
}

